/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import loci.poi.poifs.filesystem.BATManaged;
import loci.poi.poifs.filesystem.POIFSDocument;
import loci.poi.poifs.property.RootProperty;
import loci.poi.poifs.storage.BlockAllocationTableWriter;
import loci.poi.poifs.storage.BlockWritable;
import loci.poi.poifs.storage.SmallDocumentBlock;

public class SmallBlockTableWriter
implements BlockWritable,
BATManaged {
    private BlockAllocationTableWriter _sbat = new BlockAllocationTableWriter();
    private List _small_blocks = new ArrayList();
    private int _big_block_count;
    private RootProperty _root;

    public SmallBlockTableWriter(List documents, RootProperty root) {
        this._root = root;
        Iterator iter = documents.iterator();
        int size = 0;
        while (iter.hasNext()) {
            POIFSDocument doc = (POIFSDocument)iter.next();
            BlockWritable[] blocks = doc.getSmallBlocks();
            if (size == 0) {
                size = doc.getBigBlockSize();
            }
            if (blocks.length == 0) continue;
            doc.setStartBlock(this._sbat.allocateSpace(blocks.length));
            for (int j = 0; j < blocks.length; ++j) {
                this._small_blocks.add(blocks[j]);
            }
        }
        this._sbat.simpleCreateBlocks(size);
        this._root.setSize(this._small_blocks.size());
        this._big_block_count = SmallDocumentBlock.fill(this._small_blocks, size);
    }

    public int getSBATBlockCount() {
        return (this._big_block_count + 15) / 16;
    }

    public BlockAllocationTableWriter getSBAT() {
        return this._sbat;
    }

    public int countBlocks() {
        return this._big_block_count;
    }

    public void setStartBlock(int start_block) {
        this._root.setStartBlock(start_block);
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        Iterator iter = this._small_blocks.iterator();
        while (iter.hasNext()) {
            ((BlockWritable)iter.next()).writeBlocks(stream);
        }
    }
}

