/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import loci.poi.poifs.storage.BigBlock;
import loci.poi.util.IntegerField;

public class BATBlock
extends BigBlock {
    private static final byte _default_value = -1;
    private IntegerField[] _fields;
    private byte[] _data;
    private int _entries_per_block;
    private int _xbat_chain_offset;
    private int blockSize;

    private BATBlock(int blockSize) {
        this.blockSize = blockSize;
        this._entries_per_block = blockSize / 4;
        this._xbat_chain_offset = (this._entries_per_block - 1) * 4;
        this._data = new byte[blockSize];
        Arrays.fill(this._data, (byte)-1);
        this._fields = new IntegerField[this._entries_per_block];
        int offset = 0;
        for (int j = 0; j < this._entries_per_block; ++j) {
            this._fields[j] = new IntegerField(offset);
            offset += 4;
        }
    }

    public int getBigBlockSize() {
        return this.blockSize;
    }

    public static BATBlock[] createBATBlocks(int[] entries, int size) {
        int block_count = BATBlock.calculateStorageRequirements(entries.length, size);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        int entriesPerBlock = size / 4;
        for (int j = 0; j < entries.length; j += entriesPerBlock) {
            blocks[index++] = new BATBlock(entries, j, remaining > entriesPerBlock ? j + entriesPerBlock : entries.length, size);
            remaining -= entriesPerBlock;
        }
        return blocks;
    }

    public static BATBlock[] createXBATBlocks(int[] entries, int startBlock, int size) {
        int block_count = BATBlock.calculateXBATStorageRequirements(entries.length, size);
        BATBlock[] blocks = new BATBlock[block_count];
        int index = 0;
        int remaining = entries.length;
        int entriesPerXBAT = size / 4 - 1;
        if (block_count != 0) {
            for (int j = 0; j < entries.length; j += entriesPerXBAT) {
                blocks[index++] = new BATBlock(entries, j, remaining > entriesPerXBAT ? j + entriesPerXBAT : entries.length, size);
                remaining -= entriesPerXBAT;
            }
            for (index = 0; index < blocks.length - 1; ++index) {
                blocks[index].setXBATChain(startBlock + index + 1);
            }
            blocks[index].setXBATChain(-2);
        }
        return blocks;
    }

    public static int calculateStorageRequirements(int entryCount, int size) {
        int entriesPerBlock = size / 4;
        return (entryCount + entriesPerBlock - 1) / entriesPerBlock;
    }

    public static int calculateXBATStorageRequirements(int entryCount, int size) {
        int entriesPerXBAT = size / 4 - 1;
        return (entryCount + entriesPerXBAT - 1) / entriesPerXBAT;
    }

    public static final int entriesPerBlock(int size) {
        return size / 4;
    }

    public static final int entriesPerXBATBlock(int size) {
        return BATBlock.entriesPerBlock(size) - 1;
    }

    public static final int getXBATChainOffset(int size) {
        return BATBlock.entriesPerXBATBlock(size) * 4;
    }

    private void setXBATChain(int chainIndex) {
        this._fields[this._entries_per_block - 1].set(chainIndex, this._data);
    }

    private BATBlock(int[] entries, int start_index, int end_index, int size) {
        this(size);
        for (int k = start_index; k < end_index; ++k) {
            this._fields[k - start_index].set(entries[k], this._data);
        }
    }

    void writeData(OutputStream stream) throws IOException {
        this.doWriteData(stream, this._data);
    }
}

