/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.formula;

import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.formula.Ptg;
import loci.poi.util.LittleEndian;

public class RefErrorPtg
extends Ptg {
    private static final int SIZE = 5;
    public static final byte sid = 42;
    private int field_1_reserved;

    private RefErrorPtg() {
    }

    public RefErrorPtg(RecordInputStream in) {
        this.field_1_reserved = in.readInt();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[RefError]\n");
        buffer.append("reserved = ").append(this.getReserved()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(42 + this.ptgClass);
        LittleEndian.putInt(array, offset + 1, this.field_1_reserved);
    }

    public void setReserved(int reserved) {
        this.field_1_reserved = reserved;
    }

    public int getReserved() {
        return this.field_1_reserved;
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString(Workbook book) {
        return "#REF!";
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        RefErrorPtg ptg = new RefErrorPtg();
        ptg.field_1_reserved = this.field_1_reserved;
        ptg.setClass(this.ptgClass);
        return ptg;
    }
}

