/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.gui.GenericDialog;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;

public class MemoryDialog
extends ImporterDialog {
    private static final long MINIMUM_MEMORY_PADDING = 0x1400000L;
    private long needMem;
    private long availMem;

    public MemoryDialog(ImportProcess process) {
        super(process);
    }

    protected boolean needPrompt() {
        if (this.process.isWindowless()) {
            return false;
        }
        if (this.process.getOptions().getStackFormat().equals("Metadata only")) {
            return false;
        }
        this.needMem = this.process.getMemoryUsage();
        this.availMem = this.getAvailableMemory();
        return this.availMem - this.needMem < 0x1400000L;
    }

    protected GenericDialog constructDialog() {
        long needMB = this.needMem / 0x100000L;
        long availMB = this.availMem / 0x100000L;
        GenericDialog gd = new GenericDialog("Bio-Formats Memory Usage");
        gd.addMessage("Warning: It will require approximately " + needMB + " MB to open this dataset.\nHowever, only " + availMB + " MB is currently available. You may receive an error\n" + "message about insufficient memory. Are you sure you want to proceed?");
        return gd;
    }

    protected boolean harvestResults(GenericDialog gd) {
        return gd.wasOKed();
    }

    private long getAvailableMemory() {
        Runtime r = Runtime.getRuntime();
        long usedMem = r.totalMemory() - r.freeMemory();
        return r.maxMemory() - usedMem;
    }
}

