/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import loci.common.enumeration.CodedEnum;
import loci.common.enumeration.EnumException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PhotoInterp implements CodedEnum
{
    WHITE_IS_ZERO(0, "WhiteIsZero", "Monochrome"),
    BLACK_IS_ZERO(1, "BlackIsZero", "Monochrome"),
    RGB(2, "RGB", "RGB"),
    RGB_PALETTE(3, "Palette", "Monochrome"),
    TRANSPARENCY_MASK(4, "Transparency Mask", "RGB"),
    CMYK(5, "CMYK", "CMYK"),
    Y_CB_CR(6, "YCbCr", "RGB"),
    CIE_LAB(8, "CIELAB", "RGB"),
    CFA_ARRAY(32803, "Color Filter Array", "RGB");

    public static final float LUMA_RED = 0.299f;
    public static final float LUMA_GREEN = 0.587f;
    public static final float LUMA_BLUE = 0.114f;
    private int code;
    private String name;
    private String metadataType;
    private static final Map<Integer, PhotoInterp> lookup;

    private PhotoInterp(int code, String name, String metadataType) {
        this.code = code;
        this.name = name;
        this.metadataType = metadataType;
    }

    public static PhotoInterp get(int code) {
        PhotoInterp toReturn = lookup.get(code);
        if (toReturn == null) {
            throw new EnumException("Unable to find PhotoInterp with code: " + code);
        }
        return toReturn;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getMetadataType() {
        return this.metadataType;
    }

    static {
        lookup = new HashMap<Integer, PhotoInterp>();
        for (PhotoInterp v : EnumSet.allOf(PhotoInterp.class)) {
            lookup.put(v.getCode(), v);
        }
    }
}

