/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVSReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVSReader.class);
    public static final String APERIO_IMAGE_DESCRIPTION_PREFIX = "Aperio Image";
    private float[] pixelSize;
    private String[] comments;

    public SVSReader() {
        super("Aperio SVS", new String[]{"svs"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (!isThisType && open) {
            RandomAccessInputStream stream = null;
            try {
                stream = new RandomAccessInputStream(name);
                TiffParser tiffParser = new TiffParser(stream);
                if (!tiffParser.isValidHeader()) {
                    boolean bl = false;
                    return bl;
                }
                String imageDescription = tiffParser.getComment();
                if (imageDescription != null && imageDescription.startsWith(APERIO_IMAGE_DESCRIPTION_PREFIX)) {
                    boolean e = true;
                    return e;
                }
                boolean e = false;
                return e;
            }
            catch (IOException e) {
                LOGGER.debug("I/O exception during isThisType() evaluation.", e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("I/O exception during stream closure.", e);
                }
            }
        }
        return isThisType;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.getSeriesCount() == 1) {
            return super.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.tiffParser.getSamples((IFD)this.ifds.get(this.series), buf, x, y, w, h);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelSize = null;
            this.comments = null;
        }
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.getSeries())).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.getSeries())).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getIFDs();
        this.core = new CoreMetadata[this.ifds.size()];
        this.pixelSize = new float[this.core.length];
        this.comments = new String[this.core.length];
        for (int i = 0; i < this.core.length; ++i) {
            String[] lines;
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            this.tiffParser.fillInIFD((IFD)this.ifds.get(i));
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            String comment = ((IFD)this.ifds.get(i)).getComment();
            for (String line : lines = comment.split("\n")) {
                String[] tokens;
                for (String t : tokens = line.split("[|]")) {
                    if (t.indexOf("=") == -1) {
                        this.addGlobalMeta("Comment", t);
                        this.comments[i] = t;
                        continue;
                    }
                    String key = t.substring(0, t.indexOf("=")).trim();
                    String value = t.substring(t.indexOf("=") + 1).trim();
                    this.addSeriesMeta(key, value);
                    if (!key.equals("MPP")) continue;
                    this.pixelSize[i] = Float.parseFloat(value);
                }
            }
        }
        this.setSeries(0);
        for (int s = 0; s < this.core.length; ++s) {
            IFD ifd = (IFD)this.ifds.get(s);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            this.core[s].rgb = samples > 1 || p == PhotoInterp.RGB;
            this.core[s].sizeX = (int)ifd.getImageWidth();
            this.core[s].sizeY = (int)ifd.getImageLength();
            this.core[s].sizeZ = 1;
            this.core[s].sizeT = 1;
            this.core[s].sizeC = this.core[s].rgb ? samples : 1;
            this.core[s].littleEndian = ifd.isLittleEndian();
            this.core[s].indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            this.core[s].imageCount = 1;
            this.core[s].pixelType = ifd.getPixelType();
            this.core[s].metadataComplete = true;
            this.core[s].interleaved = false;
            this.core[s].falseColor = false;
            this.core[s].dimensionOrder = "XYCZT";
            this.core[s].thumbnail = s != 0;
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
            store.setImageDescription(this.comments[i], i);
        }
    }
}

