/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class QuesantReader
extends FormatReader {
    public static final int MAX_HEADER_SIZE = 1024;
    private int pixelsOffset;
    private double xSize = 0.0;
    private String date = null;
    private String comment = null;

    public QuesantReader() {
        super("Quesant AFM", "afm");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(this.pixelsOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsOffset = 0;
            this.xSize = 0.0;
            this.comment = null;
            this.date = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        while (this.in.getFilePointer() < 1024L) {
            this.readVariable();
        }
        this.in.seek(this.pixelsOffset);
        this.core[0].sizeX = this.in.readShort();
        this.pixelsOffset += 2;
        this.core[0].sizeY = this.getSizeX();
        this.core[0].pixelType = 3;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.date != null) {
            this.date = DateTools.formatDate(this.date, "MMM dd yyyy HH:mm:ssSSS");
            store.setImageAcquiredDate(this.date, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(this.comment, 0);
            store.setPixelsPhysicalSizeX(new PositiveFloat(this.xSize / (double)this.getSizeX()), 0);
            store.setPixelsPhysicalSizeY(new PositiveFloat(this.xSize / (double)this.getSizeY()), 0);
        }
    }

    private void readVariable() throws IOException {
        String code = this.in.readString(4);
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM && !code.equals("IMAG")) {
            this.in.skipBytes(4);
            return;
        }
        int offset = this.in.readInt();
        long fp = this.in.getFilePointer();
        if (offset <= 0 || (long)offset > this.in.length()) {
            return;
        }
        this.in.seek(offset);
        if (code.equals("SDES")) {
            String sdes = this.in.readCString().trim();
            this.comment = this.comment == null ? sdes : this.comment + " " + sdes;
        } else if (code.equals("DESC")) {
            short length = this.in.readShort();
            String desc = this.in.readString(length);
            this.comment = this.comment == null ? desc : this.comment + " " + desc;
        } else if (code.equals("DATE")) {
            this.date = this.in.readCString();
        } else if (code.equals("IMAG")) {
            this.pixelsOffset = offset;
        } else if (code.equals("HARD")) {
            this.xSize = this.in.readFloat();
            float scanRate = this.in.readFloat();
            float tunnelCurrent = this.in.readFloat() * 10.0f / 32768.0f;
            this.in.skipBytes(12);
            float integralGain = this.in.readFloat();
            float proportGain = this.in.readFloat();
            boolean isSTM = this.in.readShort() == 10;
            float dynamicRange = this.in.readFloat();
            this.addGlobalMeta("Scan rate (Hz)", scanRate);
            this.addGlobalMeta("Tunnel current", tunnelCurrent);
            this.addGlobalMeta("Is STM image", isSTM);
            this.addGlobalMeta("Integral gain", integralGain);
            this.addGlobalMeta("Proportional gain", proportGain);
            this.addGlobalMeta("Z dynamic range", dynamicRange);
        }
        this.in.seek(fp);
    }
}

