/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.codec.JPEGTileDecoder;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import ome.xml.model.primitives.PositiveFloat;

public class NDPIReader
extends BaseTiffReader {
    private static final int MAX_SIZE = 8192;
    private static final int THUMB_TAG_1 = 65426;
    private static final int THUMB_TAG_2 = 65439;
    private static final int METADATA_TAG = 65449;
    private JPEGTileDecoder decoder;
    private int initializedSeries = -1;
    private int initializedPlane = -1;
    private int sizeZ = 1;
    private int pyramidHeight = 1;

    public NDPIReader() {
        super("Hamamatsu NDPI", new String[]{"ndpi"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = true;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (x == 0 && y == 0 && w == 1 && h == 1) {
            return buf;
        }
        if (this.getSizeX() <= 8192 && this.getSizeY() <= 8192) {
            int ifdIndex = this.getIFDIndex(this.getSeries(), no);
            return this.tiffParser.getSamples((IFD)this.ifds.get(ifdIndex), buf, x, y, w, h);
        }
        if (this.initializedSeries != this.getSeries() || this.initializedPlane != no) {
            if (x == 0 && y == 0 && w == this.getOptimalTileWidth() && h == this.getOptimalTileHeight()) {
                this.setupService(0, 0, no);
            } else {
                this.setupService(y, h, no);
            }
            this.initializedSeries = this.getSeries();
            this.initializedPlane = no;
        } else if (this.decoder.getScanline(y) == null) {
            this.setupService(y, h, no);
        }
        int c = this.getRGBChannelCount();
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int row = w * c * bytes;
        for (int yy = y; yy < y + h; ++yy) {
            byte[] scanline = this.decoder.getScanline(yy);
            if (scanline == null) continue;
            System.arraycopy(scanline, x * c * bytes, buf, (yy - y) * row, row);
        }
        return buf;
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        int currentSeries = this.getSeries();
        if (currentSeries >= this.pyramidHeight) {
            return super.openThumbBytes(no);
        }
        this.setSeries(this.pyramidHeight - 1);
        byte[] thumb = FormatTools.openThumbBytes(this, no);
        this.setSeries(currentSeries);
        return thumb;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.decoder != null) {
                this.decoder.close();
            }
            this.decoder = null;
            this.initializedSeries = -1;
            this.initializedPlane = -1;
            this.sizeZ = 1;
            this.pyramidHeight = 1;
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int maxHeight = 0x100000 / (this.getSizeX() * this.getRGBChannelCount() * bpp);
        return Math.min(maxHeight, this.getSizeY());
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        IFD ifd;
        super.initStandardMetadata();
        this.decoder = new JPEGTileDecoder();
        this.ifds = this.tiffParser.getIFDs();
        for (int i = 1; i < this.ifds.size(); ++i) {
            IFD ifd2 = (IFD)this.ifds.get(i);
            if (ifd2.getImageWidth() == ((IFD)this.ifds.get(0)).getImageWidth() && ifd2.getImageLength() == ((IFD)this.ifds.get(0)).getImageLength()) {
                ++this.sizeZ;
                continue;
            }
            if (this.sizeZ != 1) continue;
            ++this.pyramidHeight;
        }
        int seriesCount = this.pyramidHeight + (this.ifds.size() - this.pyramidHeight * this.sizeZ);
        this.core = new CoreMetadata[seriesCount];
        for (int i = 0; i < this.ifds.size(); ++i) {
            ifd = (IFD)this.ifds.get(i);
            ifd.remove(65426);
            ifd.remove(65439);
            this.ifds.set(i, ifd);
            this.tiffParser.fillInIFD((IFD)this.ifds.get(i));
        }
        for (int s = 0; s < this.core.length; ++s) {
            this.setSeries(s);
            this.core[s] = new CoreMetadata();
            ifd = (IFD)this.ifds.get(this.getIFDIndex(s, 0));
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            this.core[s].rgb = samples > 1 || p == PhotoInterp.RGB;
            this.core[s].sizeX = (int)ifd.getImageWidth();
            this.core[s].sizeY = (int)ifd.getImageLength();
            this.core[s].sizeZ = s < this.pyramidHeight ? this.sizeZ : 1;
            this.core[s].sizeT = 1;
            this.core[s].sizeC = this.core[s].rgb ? samples : 1;
            this.core[s].littleEndian = ifd.isLittleEndian();
            this.core[s].indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            this.core[s].imageCount = this.getSizeZ() * this.getSizeT();
            this.core[s].pixelType = ifd.getPixelType();
            this.core[s].metadataComplete = true;
            this.core[s].interleaved = this.getSizeX() > 8192 || this.getSizeY() > 8192;
            this.core[s].falseColor = false;
            this.core[s].dimensionOrder = "XYCZT";
            this.core[s].thumbnail = s != 0;
        }
        this.setSeries(0);
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
            if (i <= 0) continue;
            int ifdIndex = this.getIFDIndex(i, 0);
            String creationDate = ((IFD)this.ifds.get(ifdIndex)).getIFDTextValue(306);
            creationDate = DateTools.formatDate(creationDate, DATE_FORMATS);
            store.setImageAcquiredDate(creationDate, i);
            store.setPixelsPhysicalSizeX(new PositiveFloat(((IFD)this.ifds.get(ifdIndex)).getXResolution()), i);
            store.setPixelsPhysicalSizeY(new PositiveFloat(((IFD)this.ifds.get(ifdIndex)).getYResolution()), i);
            store.setPixelsPhysicalSizeZ(null, i);
        }
    }

    private void setupService(int y, int h, int z) throws FormatException, IOException {
        this.decoder.close();
        IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(this.getSeries(), z));
        long offset = ifd.getStripOffsets()[0];
        int byteCount = (int)ifd.getStripByteCounts()[0];
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(this.currentId);
        this.in.seek(offset);
        this.in.setLength(offset + (long)byteCount);
        this.decoder.initialize(this.in, y, h, this.getSizeX());
    }

    private int getIFDIndex(int seriesIndex, int zIndex) {
        if (seriesIndex < this.pyramidHeight) {
            return zIndex * this.pyramidHeight + seriesIndex;
        }
        return this.sizeZ * this.pyramidHeight + (seriesIndex - this.pyramidHeight);
    }
}

