/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.BIFormatReader;
import loci.formats.meta.MetadataStore;

public class MNGReader
extends BIFormatReader {
    public static final long MNG_MAGIC_BYTES = -8481036456200365558L;
    private Vector<SeriesInfo> seriesInfo;

    public MNGReader() {
        super("Multiple Network Graphics", "mng");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readLong() == -8481036456200365558L;
    }

    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h);
        SeriesInfo info = this.seriesInfo.get(this.series);
        long offset = info.offsets.get(no);
        this.in.seek(offset);
        long end = info.lengths.get(no);
        BufferedImage img = this.readImage(end);
        return AWTImageTools.getSubimage(img, this.isLittleEndian(), x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.seriesInfo = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(false);
        LOGGER.info("Verifying MNG format");
        this.seriesInfo = new Vector();
        this.seriesInfo.add(new SeriesInfo());
        this.in.skipBytes(12);
        if (!"MHDR".equals(this.in.readString(4))) {
            throw new FormatException("Invalid MNG file.");
        }
        LOGGER.info("Reading dimensions");
        this.in.skipBytes(32);
        Vector<Long> stack = new Vector<Long>();
        int maxIterations = 0;
        int currentIteration = 0;
        LOGGER.info("Finding image offsets");
        while (this.in.getFilePointer() < this.in.length()) {
            int len = this.in.readInt();
            String code = this.in.readString(4);
            long fp = this.in.getFilePointer();
            if (code.equals("IHDR")) {
                this.seriesInfo.get((int)0).offsets.add(fp - 8L);
            } else if (code.equals("IEND")) {
                this.seriesInfo.get((int)0).lengths.add(fp + (long)len + 4L);
            } else if (code.equals("LOOP")) {
                stack.add(fp + (long)len + 4L);
                this.in.skipBytes(1);
                maxIterations = this.in.readInt();
            } else if (code.equals("ENDL")) {
                long seek = (Long)stack.get(stack.size() - 1);
                if (currentIteration < maxIterations) {
                    this.in.seek(seek);
                    ++currentIteration;
                } else {
                    stack.remove(stack.size() - 1);
                    maxIterations = 0;
                    currentIteration = 0;
                }
            }
            this.in.seek(fp + (long)len + 4L);
        }
        LOGGER.info("Populating metadata");
        Hashtable<String, Vector> seriesOffsets = new Hashtable<String, Vector>();
        Hashtable<String, Vector> seriesLengths = new Hashtable<String, Vector>();
        SeriesInfo info = this.seriesInfo.get(0);
        this.addGlobalMeta("Number of frames", info.offsets.size());
        for (int i = 0; i < info.offsets.size(); ++i) {
            long offset = info.offsets.get(i);
            this.in.seek(offset);
            long end = info.lengths.get(i);
            if (end < offset) continue;
            BufferedImage img = this.readImage(end);
            String data = img.getWidth() + "-" + img.getHeight() + "-" + img.getRaster().getNumBands() + "-" + AWTImageTools.getPixelType(img);
            Vector v = new Vector();
            if (seriesOffsets.containsKey(data)) {
                v = (Vector)seriesOffsets.get(data);
            }
            v.add(new Long(offset));
            seriesOffsets.put(data, v);
            v = new Vector();
            if (seriesLengths.containsKey(data)) {
                v = (Vector)seriesLengths.get(data);
            }
            v.add(new Long(end));
            seriesLengths.put(data, v);
        }
        String[] keys = seriesOffsets.keySet().toArray(new String[0]);
        if (keys.length == 0) {
            throw new FormatException("Pixel data not found.");
        }
        this.core = new CoreMetadata[keys.length];
        this.seriesInfo.clear();
        for (int i = 0; i < keys.length; ++i) {
            this.core[i] = new CoreMetadata();
            String[] tokens = keys[i].split("-");
            this.core[i].sizeX = Integer.parseInt(tokens[0]);
            this.core[i].sizeY = Integer.parseInt(tokens[1]);
            this.core[i].sizeC = Integer.parseInt(tokens[2]);
            this.core[i].pixelType = Integer.parseInt(tokens[3]);
            this.core[i].rgb = this.core[i].sizeC > 1;
            this.core[i].sizeZ = 1;
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].interleaved = false;
            this.core[i].metadataComplete = true;
            this.core[i].indexed = false;
            this.core[i].littleEndian = false;
            this.core[i].falseColor = false;
            SeriesInfo inf = new SeriesInfo();
            inf.offsets = (Vector)seriesOffsets.get(keys[i]);
            inf.lengths = (Vector)seriesLengths.get(keys[i]);
            this.seriesInfo.add(inf);
            this.core[i].sizeT = this.core[i].imageCount = inf.offsets.size();
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + (i + 1), i);
            MetadataTools.setDefaultCreationDate(store, id, i);
        }
    }

    private BufferedImage readImage(long end) throws IOException {
        byte[] b = new byte[(int)(end - this.in.getFilePointer() + 8L)];
        this.in.read(b, 8, b.length - 8);
        b[0] = -119;
        b[1] = 80;
        b[2] = 78;
        b[3] = 71;
        b[4] = 13;
        b[5] = 10;
        b[6] = 26;
        b[7] = 10;
        return ImageIO.read(new ByteArrayInputStream(b));
    }

    private class SeriesInfo {
        public Vector<Long> offsets = new Vector();
        public Vector<Long> lengths = new Vector();

        private SeriesInfo() {
        }
    }
}

