/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import loci.formats.cache.Cache;
import loci.formats.cache.CacheEvent;
import loci.formats.cache.CacheException;
import loci.formats.cache.CacheListener;

public class CacheIndicator
extends JComponent
implements CacheListener {
    private static final int COMPONENT_WIDTH = 5;
    private static final int COMPONENT_HEIGHT = 5;
    private Cache cache;
    private int axis;
    private Component comp;
    private int lPad;
    private int rPad;

    public CacheIndicator(Cache cache, int axis) {
        this(cache, axis, null, 0, 0);
    }

    public CacheIndicator(Cache cache, int axis, Component comp, int lPad, int rPad) {
        this.cache = cache;
        this.axis = axis;
        this.comp = comp;
        this.lPad = lPad;
        this.rPad = rPad;
        cache.addCacheListener(this);
        this.setBackground(Color.WHITE);
    }

    public void paintComponent(Graphics g) {
        int cacheLength;
        g.setColor(Color.BLACK);
        int xStart = this.lPad;
        int width = this.getWidth() - this.lPad - this.rPad;
        g.drawRect(xStart, 0, width - 1, 4);
        int[] lengths = this.cache.getStrategy().getLengths();
        int n = cacheLength = this.axis >= 0 && this.axis < lengths.length ? lengths[this.axis] : 0;
        if (cacheLength == 0) {
            return;
        }
        int pixelsPerIndex = (width - 2) / cacheLength;
        int remainder = width - 2 - pixelsPerIndex * cacheLength;
        try {
            int[] currentPos = null;
            int[][] loadList = null;
            currentPos = this.cache.getCurrentPos();
            loadList = this.cache.getStrategy().getLoadList(currentPos);
            int[] pos = new int[currentPos.length];
            System.arraycopy(currentPos, 0, pos, 0, pos.length);
            int start = xStart + 1;
            for (int i = 0; i < cacheLength; ++i) {
                pos[this.axis] = i;
                boolean inLoadList = false;
                for (int j = 0; j < loadList.length; ++j) {
                    boolean equal = true;
                    for (int k = 0; k < loadList[j].length; ++k) {
                        if (loadList[j][k] == pos[k]) continue;
                        equal = false;
                        break;
                    }
                    if (!equal) continue;
                    inLoadList = true;
                    break;
                }
                boolean inCache = false;
                inCache = this.cache.isInCache(pos);
                if (inCache) {
                    g.setColor(Color.BLUE);
                } else if (inLoadList) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.WHITE);
                }
                int len = pixelsPerIndex;
                if (i < remainder) {
                    ++len;
                }
                g.fillRect(start, 1, len, this.getHeight() - 2);
                start += len;
            }
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
    }

    public Dimension getPreferredSize() {
        int w = this.comp == null ? 5 : this.comp.getPreferredSize().width;
        return new Dimension(w, 5);
    }

    public Dimension getMinimumSize() {
        int w = this.comp == null ? 5 : this.comp.getMinimumSize().width;
        return new Dimension(w, 5);
    }

    public Dimension getMaximumSize() {
        int w = this.comp == null ? Integer.MAX_VALUE : this.comp.getMaximumSize().width;
        return new Dimension(w, 5);
    }

    public void cacheUpdated(CacheEvent e) {
        int type;
        if (e.getSource() instanceof Cache) {
            this.cache = (Cache)e.getSource();
        }
        if ((type = e.getType()) == 7 || type == 8 || !(e.getSource() instanceof Cache)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CacheIndicator.this.repaint();
                }
            });
        }
    }
}

