/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;

public final class DebugTools {
    private DebugTools() {
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(out));
        return new String(out.toByteArray());
    }

    public static synchronized boolean enableLogging(String level) {
        ReflectedUniverse r = new ReflectedUniverse();
        try {
            r.exec("import org.apache.log4j.Level");
            r.exec("import org.apache.log4j.Logger");
            r.exec("root = Logger.getRootLogger()");
            r.exec("root.setLevel(Level." + level + ")");
            Enumeration en = (Enumeration)r.exec("root.getAllAppenders()");
            if (!en.hasMoreElements()) {
                r.exec("import org.apache.log4j.ConsoleAppender");
                r.exec("import org.apache.log4j.PatternLayout");
                r.setVar("pattern", "%m%n");
                r.exec("layout = new PatternLayout(pattern)");
                r.exec("appender = new ConsoleAppender(layout)");
                r.exec("root.addAppender(appender)");
            }
        }
        catch (ReflectException exc) {
            return false;
        }
        return true;
    }
}

