# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._my_sql_management_client_enums import *


class Backup(msrest.serialization.Model):
    """Storage Profile properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param backup_retention_days: Backup retention days for the server.
    :type backup_retention_days: int
    :param geo_redundant_backup: Whether or not geo redundant backup is enabled. Possible values
     include: "Enabled", "Disabled".
    :type geo_redundant_backup: str or
     ~azure.mgmt.rdbms.mysql_flexibleservers.models.EnableStatusEnum
    :ivar earliest_restore_date: Earliest restore point creation time (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    """

    _validation = {
        'earliest_restore_date': {'readonly': True},
    }

    _attribute_map = {
        'backup_retention_days': {'key': 'backupRetentionDays', 'type': 'int'},
        'geo_redundant_backup': {'key': 'geoRedundantBackup', 'type': 'str'},
        'earliest_restore_date': {'key': 'earliestRestoreDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        backup_retention_days: Optional[int] = None,
        geo_redundant_backup: Optional[Union[str, "EnableStatusEnum"]] = None,
        **kwargs
    ):
        super(Backup, self).__init__(**kwargs)
        self.backup_retention_days = backup_retention_days
        self.geo_redundant_backup = geo_redundant_backup
        self.earliest_restore_date = None


class CapabilitiesListResult(msrest.serialization.Model):
    """location capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of supported capabilities.
    :vartype value: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.CapabilityProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapabilityProperties]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilitiesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class CapabilityProperties(msrest.serialization.Model):
    """Location capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar zone: zone name.
    :vartype zone: str
    :ivar supported_ha_mode: Supported high availability mode.
    :vartype supported_ha_mode: list[str]
    :ivar supported_geo_backup_regions: supported geo backup regions.
    :vartype supported_geo_backup_regions: list[str]
    :ivar supported_flexible_server_editions: A list of supported flexible server editions.
    :vartype supported_flexible_server_editions:
     list[~azure.mgmt.rdbms.mysql_flexibleservers.models.ServerEditionCapability]
    """

    _validation = {
        'zone': {'readonly': True},
        'supported_ha_mode': {'readonly': True},
        'supported_geo_backup_regions': {'readonly': True},
        'supported_flexible_server_editions': {'readonly': True},
    }

    _attribute_map = {
        'zone': {'key': 'zone', 'type': 'str'},
        'supported_ha_mode': {'key': 'supportedHAMode', 'type': '[str]'},
        'supported_geo_backup_regions': {'key': 'supportedGeoBackupRegions', 'type': '[str]'},
        'supported_flexible_server_editions': {'key': 'supportedFlexibleServerEditions', 'type': '[ServerEditionCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapabilityProperties, self).__init__(**kwargs)
        self.zone = None
        self.supported_ha_mode = None
        self.supported_geo_backup_regions = None
        self.supported_flexible_server_editions = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class Configuration(ProxyResource):
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.rdbms.mysql_flexibleservers.models.SystemData
    :param value: Value of the configuration.
    :type value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration.
    :vartype data_type: str
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :param source: Source of the configuration. Possible values include: "system-default",
     "user-override".
    :type source: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.ConfigurationSource
    :ivar is_read_only: If is the configuration read only. Possible values include: "True",
     "False".
    :vartype is_read_only: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.IsReadOnly
    :ivar is_config_pending_restart: If is the configuration pending restart or not. Possible
     values include: "True", "False".
    :vartype is_config_pending_restart: str or
     ~azure.mgmt.rdbms.mysql_flexibleservers.models.IsConfigPendingRestart
    :ivar is_dynamic_config: If is the configuration dynamic. Possible values include: "True",
     "False".
    :vartype is_dynamic_config: str or
     ~azure.mgmt.rdbms.mysql_flexibleservers.models.IsDynamicConfig
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'description': {'readonly': True},
        'default_value': {'readonly': True},
        'data_type': {'readonly': True},
        'allowed_values': {'readonly': True},
        'is_read_only': {'readonly': True},
        'is_config_pending_restart': {'readonly': True},
        'is_dynamic_config': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'default_value': {'key': 'properties.defaultValue', 'type': 'str'},
        'data_type': {'key': 'properties.dataType', 'type': 'str'},
        'allowed_values': {'key': 'properties.allowedValues', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'is_read_only': {'key': 'properties.isReadOnly', 'type': 'str'},
        'is_config_pending_restart': {'key': 'properties.isConfigPendingRestart', 'type': 'str'},
        'is_dynamic_config': {'key': 'properties.isDynamicConfig', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        source: Optional[Union[str, "ConfigurationSource"]] = None,
        **kwargs
    ):
        super(Configuration, self).__init__(**kwargs)
        self.system_data = None
        self.value = value
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = source
        self.is_read_only = None
        self.is_config_pending_restart = None
        self.is_dynamic_config = None


class ConfigurationForBatchUpdate(msrest.serialization.Model):
    """Represents a Configuration.

    :param name: Name of the configuration.
    :type name: str
    :param value: Value of the configuration.
    :type value: str
    :param source: Source of the configuration.
    :type source: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        source: Optional[str] = None,
        **kwargs
    ):
        super(ConfigurationForBatchUpdate, self).__init__(**kwargs)
        self.name = name
        self.value = value
        self.source = source


class ConfigurationListForBatchUpdate(msrest.serialization.Model):
    """A list of server configurations to update.

    :param value: The list of server configurations.
    :type value: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.ConfigurationForBatchUpdate]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConfigurationForBatchUpdate]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ConfigurationForBatchUpdate"]] = None,
        **kwargs
    ):
        super(ConfigurationListForBatchUpdate, self).__init__(**kwargs)
        self.value = value


class ConfigurationListResult(msrest.serialization.Model):
    """A list of server configurations.

    :param value: The list of server configurations.
    :type value: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.Configuration]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Configuration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Configuration"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ConfigurationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Database(ProxyResource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.rdbms.mysql_flexibleservers.models.SystemData
    :param charset: The charset of the database.
    :type charset: str
    :param collation: The collation of the database.
    :type collation: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'charset': {'key': 'properties.charset', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        charset: Optional[str] = None,
        collation: Optional[str] = None,
        **kwargs
    ):
        super(Database, self).__init__(**kwargs)
        self.system_data = None
        self.charset = charset
        self.collation = collation


class DatabaseListResult(msrest.serialization.Model):
    """A List of databases.

    :param value: The list of databases housed in a server.
    :type value: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.Database]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Database]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Database"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DatabaseListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DelegatedSubnetUsage(msrest.serialization.Model):
    """Delegated subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subnet_name: name of the subnet.
    :vartype subnet_name: str
    :ivar usage: Number of used delegated subnets.
    :vartype usage: long
    """

    _validation = {
        'subnet_name': {'readonly': True},
        'usage': {'readonly': True},
    }

    _attribute_map = {
        'subnet_name': {'key': 'subnetName', 'type': 'str'},
        'usage': {'key': 'usage', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DelegatedSubnetUsage, self).__init__(**kwargs)
        self.subnet_name = None
        self.usage = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.rdbms.mysql_flexibleservers.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.rdbms.mysql_flexibleservers.models.SystemData
    :param start_ip_address: Required. The start IP address of the server firewall rule. Must be
     IPv4 format.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the server firewall rule. Must be IPv4
     format.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'start_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
        'end_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_ip_address: str,
        end_ip_address: str,
        **kwargs
    ):
        super(FirewallRule, self).__init__(**kwargs)
        self.system_data = None
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class FirewallRuleListResult(msrest.serialization.Model):
    """A list of firewall rules.

    :param value: The list of firewall rules in a server.
    :type value: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.FirewallRule]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[FirewallRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["FirewallRule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(FirewallRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GetPrivateDnsZoneSuffixResponse(msrest.serialization.Model):
    """The response of get private dns zone suffix.

    :param private_dns_zone_suffix: Represents the private DNS zone suffix.
    :type private_dns_zone_suffix: str
    """

    _attribute_map = {
        'private_dns_zone_suffix': {'key': 'privateDnsZoneSuffix', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_dns_zone_suffix: Optional[str] = None,
        **kwargs
    ):
        super(GetPrivateDnsZoneSuffixResponse, self).__init__(**kwargs)
        self.private_dns_zone_suffix = private_dns_zone_suffix


class HighAvailability(msrest.serialization.Model):
    """Network related properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param mode: High availability mode for a server. Possible values include: "Enabled",
     "Disabled", "ZoneRedundant", "SameZone".
    :type mode: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.HighAvailabilityMode
    :ivar state: The state of server high availability. Possible values include: "NotEnabled",
     "CreatingStandby", "Healthy", "FailingOver", "RemovingStandby".
    :vartype state: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.HighAvailabilityState
    :param standby_availability_zone: Availability zone of the standby server.
    :type standby_availability_zone: str
    """

    _validation = {
        'state': {'readonly': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'standby_availability_zone': {'key': 'standbyAvailabilityZone', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "HighAvailabilityMode"]] = None,
        standby_availability_zone: Optional[str] = None,
        **kwargs
    ):
        super(HighAvailability, self).__init__(**kwargs)
        self.mode = mode
        self.state = None
        self.standby_availability_zone = standby_availability_zone


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class MaintenanceWindow(msrest.serialization.Model):
    """Maintenance window of a server.

    :param custom_window: indicates whether custom window is enabled or disabled.
    :type custom_window: str
    :param start_hour: start hour for maintenance window.
    :type start_hour: int
    :param start_minute: start minute for maintenance window.
    :type start_minute: int
    :param day_of_week: day of week for maintenance window.
    :type day_of_week: int
    """

    _attribute_map = {
        'custom_window': {'key': 'customWindow', 'type': 'str'},
        'start_hour': {'key': 'startHour', 'type': 'int'},
        'start_minute': {'key': 'startMinute', 'type': 'int'},
        'day_of_week': {'key': 'dayOfWeek', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        custom_window: Optional[str] = None,
        start_hour: Optional[int] = None,
        start_minute: Optional[int] = None,
        day_of_week: Optional[int] = None,
        **kwargs
    ):
        super(MaintenanceWindow, self).__init__(**kwargs)
        self.custom_window = custom_window
        self.start_hour = start_hour
        self.start_minute = start_minute
        self.day_of_week = day_of_week


class NameAvailability(msrest.serialization.Model):
    """Represents a resource name availability.

    :param message: Error Message.
    :type message: str
    :param name_available: Indicates whether the resource name is available.
    :type name_available: bool
    :param reason: Reason for name being unavailable.
    :type reason: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        **kwargs
    ):
        super(NameAvailability, self).__init__(**kwargs)
        self.message = message
        self.name_available = name_available
        self.reason = reason


class NameAvailabilityRequest(msrest.serialization.Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Resource type used for verification.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Optional[str] = None,
        **kwargs
    ):
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type


class Network(msrest.serialization.Model):
    """Network related properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_network_access: Whether or not public network access is allowed for this server.
     Value is 'Disabled' when server has VNet integration. Possible values include: "Enabled",
     "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.rdbms.mysql_flexibleservers.models.EnableStatusEnum
    :param delegated_subnet_resource_id: Delegated subnet resource id used to setup vnet for a
     server.
    :type delegated_subnet_resource_id: str
    :param private_dns_zone_resource_id: Private DNS zone resource id.
    :type private_dns_zone_resource_id: str
    """

    _validation = {
        'public_network_access': {'readonly': True},
    }

    _attribute_map = {
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'delegated_subnet_resource_id': {'key': 'delegatedSubnetResourceId', 'type': 'str'},
        'private_dns_zone_resource_id': {'key': 'privateDnsZoneResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        delegated_subnet_resource_id: Optional[str] = None,
        private_dns_zone_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(Network, self).__init__(**kwargs)
        self.public_network_access = None
        self.delegated_subnet_resource_id = delegated_subnet_resource_id
        self.private_dns_zone_resource_id = private_dns_zone_resource_id


class Operation(msrest.serialization.Model):
    """REST API operation definition.

    :param name: The name of the operation being performed on this particular object.
    :type name: str
    :param display: The localized display information for this particular operation or action.
    :type display: ~azure.mgmt.rdbms.mysql_flexibleservers.models.OperationDisplay
    :param origin: The intended executor of the operation.
    :type origin: str
    :param properties: Additional descriptions for the operation.
    :type properties: dict[str, any]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Operation resource provider name.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: Localized friendly name for the operation.
    :type operation: str
    :param description: Operation description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """A list of resource provider operations.

    :param value: Collection of available operation details.
    :type value: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.Operation]
    :param next_link: URL client should use to fetch the next page (per server side paging).
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.mysql_flexibleservers.models.Identity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.mysql_flexibleservers.models.Sku
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.rdbms.mysql_flexibleservers.models.SystemData
    :param administrator_login: The administrator's login name of a server. Can only be specified
     when the server is being created (and is required for creation).
    :type administrator_login: str
    :param administrator_login_password: The password of the administrator login (required for
     server creation).
    :type administrator_login_password: str
    :param version: Server version. Possible values include: "5.7", "8.0.21".
    :type version: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.ServerVersion
    :param availability_zone: availability Zone information of the server.
    :type availability_zone: str
    :param create_mode: The mode to create a new MySQL server. Possible values include: "Default",
     "PointInTimeRestore", "Replica", "GeoRestore".
    :type create_mode: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.CreateMode
    :param source_server_resource_id: The source MySQL server id.
    :type source_server_resource_id: str
    :param restore_point_in_time: Restore point creation time (ISO8601 format), specifying the time
     to restore from.
    :type restore_point_in_time: ~datetime.datetime
    :param replication_role: The replication role. Possible values include: "None", "Source",
     "Replica".
    :type replication_role: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.ReplicationRole
    :ivar replica_capacity: The maximum number of replicas that a primary server can have.
    :vartype replica_capacity: int
    :ivar state: The state of a server. Possible values include: "Ready", "Dropping", "Disabled",
     "Starting", "Stopping", "Stopped", "Updating".
    :vartype state: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.ServerState
    :ivar fully_qualified_domain_name: The fully qualified domain name of a server.
    :vartype fully_qualified_domain_name: str
    :param storage: Storage related properties of a server.
    :type storage: ~azure.mgmt.rdbms.mysql_flexibleservers.models.Storage
    :param backup: Backup related properties of a server.
    :type backup: ~azure.mgmt.rdbms.mysql_flexibleservers.models.Backup
    :param high_availability: High availability related properties of a server.
    :type high_availability: ~azure.mgmt.rdbms.mysql_flexibleservers.models.HighAvailability
    :param network: Network related properties of a server.
    :type network: ~azure.mgmt.rdbms.mysql_flexibleservers.models.Network
    :param maintenance_window: Maintenance window of a server.
    :type maintenance_window: ~azure.mgmt.rdbms.mysql_flexibleservers.models.MaintenanceWindow
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'replica_capacity': {'readonly': True, 'minimum': 0},
        'state': {'readonly': True},
        'fully_qualified_domain_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'availability_zone': {'key': 'properties.availabilityZone', 'type': 'str'},
        'create_mode': {'key': 'properties.createMode', 'type': 'str'},
        'source_server_resource_id': {'key': 'properties.sourceServerResourceId', 'type': 'str'},
        'restore_point_in_time': {'key': 'properties.restorePointInTime', 'type': 'iso-8601'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'replica_capacity': {'key': 'properties.replicaCapacity', 'type': 'int'},
        'state': {'key': 'properties.state', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'storage': {'key': 'properties.storage', 'type': 'Storage'},
        'backup': {'key': 'properties.backup', 'type': 'Backup'},
        'high_availability': {'key': 'properties.highAvailability', 'type': 'HighAvailability'},
        'network': {'key': 'properties.network', 'type': 'Network'},
        'maintenance_window': {'key': 'properties.maintenanceWindow', 'type': 'MaintenanceWindow'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        sku: Optional["Sku"] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[Union[str, "ServerVersion"]] = None,
        availability_zone: Optional[str] = None,
        create_mode: Optional[Union[str, "CreateMode"]] = None,
        source_server_resource_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        replication_role: Optional[Union[str, "ReplicationRole"]] = None,
        storage: Optional["Storage"] = None,
        backup: Optional["Backup"] = None,
        high_availability: Optional["HighAvailability"] = None,
        network: Optional["Network"] = None,
        maintenance_window: Optional["MaintenanceWindow"] = None,
        **kwargs
    ):
        super(Server, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.system_data = None
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.availability_zone = availability_zone
        self.create_mode = create_mode
        self.source_server_resource_id = source_server_resource_id
        self.restore_point_in_time = restore_point_in_time
        self.replication_role = replication_role
        self.replica_capacity = None
        self.state = None
        self.fully_qualified_domain_name = None
        self.storage = storage
        self.backup = backup
        self.high_availability = high_availability
        self.network = network
        self.maintenance_window = maintenance_window


class ServerBackup(ProxyResource):
    """Server backup properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.rdbms.mysql_flexibleservers.models.SystemData
    :param backup_type: Backup type.
    :type backup_type: str
    :param completed_time: Backup completed time (ISO8601 format).
    :type completed_time: ~datetime.datetime
    :param source: Backup source.
    :type source: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'backup_type': {'key': 'properties.backupType', 'type': 'str'},
        'completed_time': {'key': 'properties.completedTime', 'type': 'iso-8601'},
        'source': {'key': 'properties.source', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        backup_type: Optional[str] = None,
        completed_time: Optional[datetime.datetime] = None,
        source: Optional[str] = None,
        **kwargs
    ):
        super(ServerBackup, self).__init__(**kwargs)
        self.system_data = None
        self.backup_type = backup_type
        self.completed_time = completed_time
        self.source = source


class ServerBackupListResult(msrest.serialization.Model):
    """A list of server backups.

    :param value: The list of backups of a server.
    :type value: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.ServerBackup]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerBackup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ServerBackup"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ServerBackupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServerEditionCapability(msrest.serialization.Model):
    """Server edition capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Server edition name.
    :vartype name: str
    :ivar supported_storage_editions: A list of supported storage editions.
    :vartype supported_storage_editions:
     list[~azure.mgmt.rdbms.mysql_flexibleservers.models.StorageEditionCapability]
    :ivar supported_server_versions: A list of supported server versions.
    :vartype supported_server_versions:
     list[~azure.mgmt.rdbms.mysql_flexibleservers.models.ServerVersionCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'supported_storage_editions': {'readonly': True},
        'supported_server_versions': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_storage_editions': {'key': 'supportedStorageEditions', 'type': '[StorageEditionCapability]'},
        'supported_server_versions': {'key': 'supportedServerVersions', 'type': '[ServerVersionCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_storage_editions = None
        self.supported_server_versions = None


class ServerForUpdate(msrest.serialization.Model):
    """Parameters allowed to update for a server.

    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.mysql_flexibleservers.models.Sku
    :param tags: A set of tags. Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param administrator_login_password: The password of the administrator login.
    :type administrator_login_password: str
    :param storage: Storage related properties of a server.
    :type storage: ~azure.mgmt.rdbms.mysql_flexibleservers.models.Storage
    :param backup: Backup related properties of a server.
    :type backup: ~azure.mgmt.rdbms.mysql_flexibleservers.models.Backup
    :param high_availability: High availability related properties of a server.
    :type high_availability: ~azure.mgmt.rdbms.mysql_flexibleservers.models.HighAvailability
    :param maintenance_window: Maintenance window of a server.
    :type maintenance_window: ~azure.mgmt.rdbms.mysql_flexibleservers.models.MaintenanceWindow
    :param replication_role: The replication role of the server. Possible values include: "None",
     "Source", "Replica".
    :type replication_role: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.ReplicationRole
    """

    _attribute_map = {
        'sku': {'key': 'sku', 'type': 'Sku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'storage': {'key': 'properties.storage', 'type': 'Storage'},
        'backup': {'key': 'properties.backup', 'type': 'Backup'},
        'high_availability': {'key': 'properties.highAvailability', 'type': 'HighAvailability'},
        'maintenance_window': {'key': 'properties.maintenanceWindow', 'type': 'MaintenanceWindow'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sku: Optional["Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        administrator_login_password: Optional[str] = None,
        storage: Optional["Storage"] = None,
        backup: Optional["Backup"] = None,
        high_availability: Optional["HighAvailability"] = None,
        maintenance_window: Optional["MaintenanceWindow"] = None,
        replication_role: Optional[Union[str, "ReplicationRole"]] = None,
        **kwargs
    ):
        super(ServerForUpdate, self).__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.administrator_login_password = administrator_login_password
        self.storage = storage
        self.backup = backup
        self.high_availability = high_availability
        self.maintenance_window = maintenance_window
        self.replication_role = replication_role


class ServerListResult(msrest.serialization.Model):
    """A list of servers.

    :param value: The list of servers.
    :type value: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.Server]
    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Server]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Server"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ServerListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServerRestartParameter(msrest.serialization.Model):
    """Server restart parameters.

    :param restart_with_failover: Whether or not failover to standby server when restarting a
     server with high availability enabled. Possible values include: "Enabled", "Disabled".
    :type restart_with_failover: str or
     ~azure.mgmt.rdbms.mysql_flexibleservers.models.EnableStatusEnum
    :param max_failover_seconds: The maximum allowed failover time in seconds.
    :type max_failover_seconds: int
    """

    _attribute_map = {
        'restart_with_failover': {'key': 'restartWithFailover', 'type': 'str'},
        'max_failover_seconds': {'key': 'maxFailoverSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        restart_with_failover: Optional[Union[str, "EnableStatusEnum"]] = None,
        max_failover_seconds: Optional[int] = None,
        **kwargs
    ):
        super(ServerRestartParameter, self).__init__(**kwargs)
        self.restart_with_failover = restart_with_failover
        self.max_failover_seconds = max_failover_seconds


class ServerVersionCapability(msrest.serialization.Model):
    """Server version capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: server version.
    :vartype name: str
    :ivar supported_skus: A list of supported Skus.
    :vartype supported_skus: list[~azure.mgmt.rdbms.mysql_flexibleservers.models.SkuCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'supported_skus': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'supported_skus': {'key': 'supportedSkus', 'type': '[SkuCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerVersionCapability, self).__init__(**kwargs)
        self.name = None
        self.supported_skus = None


class Sku(msrest.serialization.Model):
    """Billing information related properties of a server.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the sku, e.g. Standard_D32s_v3.
    :type name: str
    :param tier: Required. The tier of the particular SKU, e.g. GeneralPurpose. Possible values
     include: "Burstable", "GeneralPurpose", "MemoryOptimized".
    :type tier: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Union[str, "SkuTier"],
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class SkuCapability(msrest.serialization.Model):
    """Sku capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: vCore name.
    :vartype name: str
    :ivar v_cores: supported vCores.
    :vartype v_cores: long
    :ivar supported_iops: supported IOPS.
    :vartype supported_iops: long
    :ivar supported_memory_per_v_core_mb: supported memory per vCore in MB.
    :vartype supported_memory_per_v_core_mb: long
    """

    _validation = {
        'name': {'readonly': True},
        'v_cores': {'readonly': True},
        'supported_iops': {'readonly': True},
        'supported_memory_per_v_core_mb': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'v_cores': {'key': 'vCores', 'type': 'long'},
        'supported_iops': {'key': 'supportedIops', 'type': 'long'},
        'supported_memory_per_v_core_mb': {'key': 'supportedMemoryPerVCoreMB', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCapability, self).__init__(**kwargs)
        self.name = None
        self.v_cores = None
        self.supported_iops = None
        self.supported_memory_per_v_core_mb = None


class Storage(msrest.serialization.Model):
    """Storage Profile properties of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param storage_size_gb: Max storage size allowed for a server.
    :type storage_size_gb: int
    :param iops: Storage IOPS for a server.
    :type iops: int
    :param auto_grow: Enable Storage Auto Grow or not. Possible values include: "Enabled",
     "Disabled".
    :type auto_grow: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.EnableStatusEnum
    :ivar storage_sku: The sku name of the server storage.
    :vartype storage_sku: str
    """

    _validation = {
        'storage_sku': {'readonly': True},
    }

    _attribute_map = {
        'storage_size_gb': {'key': 'storageSizeGB', 'type': 'int'},
        'iops': {'key': 'iops', 'type': 'int'},
        'auto_grow': {'key': 'autoGrow', 'type': 'str'},
        'storage_sku': {'key': 'storageSku', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_size_gb: Optional[int] = None,
        iops: Optional[int] = None,
        auto_grow: Optional[Union[str, "EnableStatusEnum"]] = None,
        **kwargs
    ):
        super(Storage, self).__init__(**kwargs)
        self.storage_size_gb = storage_size_gb
        self.iops = iops
        self.auto_grow = auto_grow
        self.storage_sku = None


class StorageEditionCapability(msrest.serialization.Model):
    """storage edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: storage edition name.
    :vartype name: str
    :ivar min_storage_size: The minimal supported storage size.
    :vartype min_storage_size: long
    :ivar max_storage_size: The maximum supported storage size.
    :vartype max_storage_size: long
    :ivar min_backup_retention_days: Minimal backup retention days.
    :vartype min_backup_retention_days: long
    :ivar max_backup_retention_days: Maximum backup retention days.
    :vartype max_backup_retention_days: long
    """

    _validation = {
        'name': {'readonly': True},
        'min_storage_size': {'readonly': True},
        'max_storage_size': {'readonly': True},
        'min_backup_retention_days': {'readonly': True},
        'max_backup_retention_days': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'min_storage_size': {'key': 'minStorageSize', 'type': 'long'},
        'max_storage_size': {'key': 'maxStorageSize', 'type': 'long'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'long'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageEditionCapability, self).__init__(**kwargs)
        self.name = None
        self.min_storage_size = None
        self.max_storage_size = None
        self.min_backup_retention_days = None
        self.max_backup_retention_days = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.rdbms.mysql_flexibleservers.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~azure.mgmt.rdbms.mysql_flexibleservers.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class VirtualNetworkSubnetUsageParameter(msrest.serialization.Model):
    """Virtual network subnet usage parameter.

    :param virtual_network_resource_id: Virtual network resource id.
    :type virtual_network_resource_id: str
    """

    _attribute_map = {
        'virtual_network_resource_id': {'key': 'virtualNetworkResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkSubnetUsageParameter, self).__init__(**kwargs)
        self.virtual_network_resource_id = virtual_network_resource_id


class VirtualNetworkSubnetUsageResult(msrest.serialization.Model):
    """Virtual network subnet usage data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar delegated_subnets_usage: A list of delegated subnet usage.
    :vartype delegated_subnets_usage:
     list[~azure.mgmt.rdbms.mysql_flexibleservers.models.DelegatedSubnetUsage]
    """

    _validation = {
        'delegated_subnets_usage': {'readonly': True},
    }

    _attribute_map = {
        'delegated_subnets_usage': {'key': 'delegatedSubnetsUsage', 'type': '[DelegatedSubnetUsage]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualNetworkSubnetUsageResult, self).__init__(**kwargs)
        self.delegated_subnets_usage = None
