# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AgeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Age Unit of measurement
    """

    UNSPECIFIED = "Unspecified"
    YEAR = "Year"
    MONTH = "Month"
    WEEK = "Week"
    DAY = "Day"

class AnalyzeConversationTaskKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported Conversation tasks.
    """

    CUSTOM_CONVERSATION = "CustomConversation"

class AnalyzeConversationTaskResultsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported conversational task results
    """

    CUSTOM_CONVERSATION_RESULT = "CustomConversationResult"

class AreaUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The area Unit of measurement
    """

    UNSPECIFIED = "Unspecified"
    SQUARE_KILOMETER = "SquareKilometer"
    SQUARE_HECTOMETER = "SquareHectometer"
    SQUARE_DECAMETER = "SquareDecameter"
    SQUARE_DECIMETER = "SquareDecimeter"
    SQUARE_METER = "SquareMeter"
    SQUARE_CENTIMETER = "SquareCentimeter"
    SQUARE_MILLIMETER = "SquareMillimeter"
    SQUARE_INCH = "SquareInch"
    SQUARE_FOOT = "SquareFoot"
    SQUARE_MILE = "SquareMile"
    SQUARE_YARD = "SquareYard"
    ACRE = "Acre"

class DateTimeSubKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The DateTime SubKind
    """

    TIME = "Time"
    DATE = "Date"
    DATE_TIME = "DateTime"
    DURATION = "Duration"
    SET = "Set"

class ErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code.
    """

    INVALID_REQUEST = "InvalidRequest"
    INVALID_ARGUMENT = "InvalidArgument"
    UNAUTHORIZED = "Unauthorized"
    FORBIDDEN = "Forbidden"
    NOT_FOUND = "NotFound"
    PROJECT_NOT_FOUND = "ProjectNotFound"
    OPERATION_NOT_FOUND = "OperationNotFound"
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    AZURE_COGNITIVE_SEARCH_INDEX_NOT_FOUND = "AzureCognitiveSearchIndexNotFound"
    TOO_MANY_REQUESTS = "TooManyRequests"
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    AZURE_COGNITIVE_SEARCH_INDEX_LIMIT_REACHED = "AzureCognitiveSearchIndexLimitReached"
    INTERNAL_SERVER_ERROR = "InternalServerError"
    SERVICE_UNAVAILABLE = "ServiceUnavailable"

class ExtraInformationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The extra information object kind.
    """

    ENTITY_SUBTYPE = "EntitySubtype"
    LIST_KEY = "ListKey"

class InformationUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The information (data) Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    BIT = "Bit"
    KILOBIT = "Kilobit"
    MEGABIT = "Megabit"
    GIGABIT = "Gigabit"
    TERABIT = "Terabit"
    PETABIT = "Petabit"
    BYTE = "Byte"
    KILOBYTE = "Kilobyte"
    MEGABYTE = "Megabyte"
    GIGABYTE = "Gigabyte"
    TERABYTE = "Terabyte"
    PETABYTE = "Petabyte"

class InnerErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code.
    """

    INVALID_REQUEST = "InvalidRequest"
    INVALID_PARAMETER_VALUE = "InvalidParameterValue"
    KNOWLEDGE_BASE_NOT_FOUND = "KnowledgeBaseNotFound"
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    EXTRACTION_FAILURE = "ExtractionFailure"
    INVALID_REQUEST_BODY_FORMAT = "InvalidRequestBodyFormat"
    EMPTY_REQUEST = "EmptyRequest"
    MISSING_INPUT_DOCUMENTS = "MissingInputDocuments"
    INVALID_DOCUMENT = "InvalidDocument"
    MODEL_VERSION_INCORRECT = "ModelVersionIncorrect"
    INVALID_DOCUMENT_BATCH = "InvalidDocumentBatch"
    UNSUPPORTED_LANGUAGE_CODE = "UnsupportedLanguageCode"
    INVALID_COUNTRY_HINT = "InvalidCountryHint"

class LengthUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The length Unit of measurement
    """

    UNSPECIFIED = "Unspecified"
    KILOMETER = "Kilometer"
    HECTOMETER = "Hectometer"
    DECAMETER = "Decameter"
    METER = "Meter"
    DECIMETER = "Decimeter"
    CENTIMETER = "Centimeter"
    MILLIMETER = "Millimeter"
    MICROMETER = "Micrometer"
    NANOMETER = "Nanometer"
    PICOMETER = "Picometer"
    MILE = "Mile"
    YARD = "Yard"
    INCH = "Inch"
    FOOT = "Foot"
    LIGHT_YEAR = "LightYear"
    PT = "Pt"

class Modality(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The modality (format) of ConversationItem (e.g., Text, Transcript)
    """

    TEXT = "text"

class Modifier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An optional modifier of a date/time instance.
    """

    AFTER_APPROX = "AfterApprox"
    BEFORE = "Before"
    BEFORE_START = "BeforeStart"
    APPROX = "Approx"
    REFERENCE_UNDEFINED = "ReferenceUndefined"
    SINCE_END = "SinceEnd"
    AFTER_MID = "AfterMid"
    START = "Start"
    AFTER = "After"
    BEFORE_END = "BeforeEnd"
    UNTIL = "Until"
    END = "End"
    LESS = "Less"
    SINCE = "Since"
    AFTER_START = "AfterStart"
    BEFORE_APPROX = "BeforeApprox"
    MID = "Mid"
    MORE = "More"

class NumberKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the extracted number entity.
    """

    INTEGER = "Integer"
    DECIMAL = "Decimal"
    POWER = "Power"
    FRACTION = "Fraction"
    PERCENT = "Percent"
    UNSPECIFIED = "Unspecified"

class ProjectKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the project.
    """

    CONVERSATION = "conversation"
    WORKFLOW = "workflow"

class RangeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of range that the resolution object represents.
    """

    NUMBER = "Number"
    SPEED = "Speed"
    WEIGHT = "Weight"
    LENGTH = "Length"
    VOLUME = "Volume"
    AREA = "Area"
    AGE = "Age"
    INFORMATION = "Information"
    TEMPERATURE = "Temperature"
    CURRENCY = "Currency"

class RelativeTo(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reference point that the ordinal number denotes.
    """

    CURRENT = "Current"
    END = "End"
    START = "Start"

class ResolutionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The entity resolution object kind.
    """

    BOOLEAN = "Boolean"
    DATE_TIME = "DateTime"
    NUMBER = "Number"
    ORDINAL = "Ordinal"
    SPEED = "Speed"
    WEIGHT = "Weight"
    LENGTH = "Length"
    VOLUME = "Volume"
    AREA = "Area"
    AGE = "Age"
    INFORMATION = "Information"
    TEMPERATURE = "Temperature"
    CURRENCY = "Currency"
    NUMERIC_RANGE = "NumericRange"
    TEMPORAL_SPAN = "TemporalSpan"

class SpeedUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The speed Unit of measurement
    """

    UNSPECIFIED = "Unspecified"
    METERS_PER_SECOND = "MetersPerSecond"
    KILOMETERS_PER_HOUR = "KilometersPerHour"
    KILOMETERS_PER_MINUTE = "KilometersPerMinute"
    KILOMETERS_PER_SECOND = "KilometersPerSecond"
    MILES_PER_HOUR = "MilesPerHour"
    KNOT = "Knot"
    FOOT_PER_SECOND = "FootPerSecond"
    FOOT_PER_MINUTE = "FootPerMinute"
    YARDS_PER_MINUTE = "YardsPerMinute"
    YARDS_PER_SECOND = "YardsPerSecond"
    METERS_PER_MILLISECOND = "MetersPerMillisecond"
    CENTIMETERS_PER_MILLISECOND = "CentimetersPerMillisecond"
    KILOMETERS_PER_MILLISECOND = "KilometersPerMillisecond"

class TargetKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of a target service.
    """

    LUIS = "luis"
    CONVERSATION = "conversation"
    QUESTION_ANSWERING = "question_answering"
    NON_LINKED = "non_linked"

class TemperatureUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The temperature Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    FAHRENHEIT = "Fahrenheit"
    KELVIN = "Kelvin"
    RANKINE = "Rankine"
    CELSIUS = "Celsius"

class VolumeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Volume Unit of measurement
    """

    UNSPECIFIED = "Unspecified"
    CUBIC_METER = "CubicMeter"
    CUBIC_CENTIMETER = "CubicCentimeter"
    CUBIC_MILLIMETER = "CubicMillimeter"
    HECTOLITER = "Hectoliter"
    DECALITER = "Decaliter"
    LITER = "Liter"
    CENTILITER = "Centiliter"
    MILLILITER = "Milliliter"
    CUBIC_YARD = "CubicYard"
    CUBIC_INCH = "CubicInch"
    CUBIC_FOOT = "CubicFoot"
    CUBIC_MILE = "CubicMile"
    FLUID_OUNCE = "FluidOunce"
    TEASPOON = "Teaspoon"
    TABLESPOON = "Tablespoon"
    PINT = "Pint"
    QUART = "Quart"
    CUP = "Cup"
    GILL = "Gill"
    PINCH = "Pinch"
    FLUID_DRAM = "FluidDram"
    BARREL = "Barrel"
    MINIM = "Minim"
    CORD = "Cord"
    PECK = "Peck"
    BUSHEL = "Bushel"
    HOGSHEAD = "Hogshead"

class WeightUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The weight Unit of measurement.
    """

    UNSPECIFIED = "Unspecified"
    KILOGRAM = "Kilogram"
    GRAM = "Gram"
    MILLIGRAM = "Milligram"
    GALLON = "Gallon"
    METRIC_TON = "MetricTon"
    TON = "Ton"
    POUND = "Pound"
    OUNCE = "Ounce"
    GRAIN = "Grain"
    PENNY_WEIGHT = "PennyWeight"
    LONG_TON_BRITISH = "LongTonBritish"
    SHORT_TON_US = "ShortTonUS"
    SHORT_HUNDRED_WEIGHT_US = "ShortHundredWeightUS"
    STONE = "Stone"
    DRAM = "Dram"
