#!python

from __future__ import absolute_import

import os
import itertools
from .environ import get_environment_from_batch_command

def find_visual_studio(versions):
	r"""
	Find the location of the locally-installed
	Visual Studio instance. Uses the heuristic of searching the
	default paths for the supplied versions.
	
	Versions should be a string or list of strings
	indicating the version
	as found in the file path.
	
	>>> find_visual_studio('9.0') #doctest:+SKIP
	'C:\\Program Files\\Microsoft Visual Studio 9.0'
	"""
	if isinstance(versions, basestring):
		versions = [versions]
	keys = ['PROGRAMFILES', 'PROGRAMFILES(X86)']
	search_path = [os.environ.get(key) for key in keys if os.environ.has_key(key)]
	path_versions = itertools.product(search_path, versions)
	vs_candidate_dirs = [
		os.path.join(base, 'Microsoft Visual Studio ' + version)
		for base, version in path_versions
		]
	has_VC_child = lambda dir: os.path.isdir(os.path.join(dir, 'VC'))
	tests = os.path.isdir, has_VC_child
	test_adequacy = lambda candidate: all(t(candidate) for t in tests)
	return next(iter(itertools.ifilter(test_adequacy, vs_candidate_dirs)))

def get_vcvars_env(*params):
	"""
	Get the environment variables generated by running vcvarsall.bat in Visual Studio 9.
	Additional parameters will be passed to the script.
	"""
	visual_studio = find_visual_studio('9.0')
	vcvarsall = os.path.join(visual_studio, 'VC', 'vcvarsall.bat')
	if not os.path.isfile(vcvarsall):
		msg = "Couldn't find vcvarsall"
		raise RuntimeError(msg)
	return get_environment_from_batch_command([vcvarsall]+list(params))
