# -*- coding: utf-8 -*-
# Generated by Django 1.9.4 on 2016-03-22 10:23
from __future__ import unicode_literals

from django.db import migrations
from django.utils.crypto import get_random_string


def add_api_keys(apps, schema_editor):
    Token = apps.get_model('authtoken', 'Token')
    User = apps.get_model('auth', 'User')
    for user in User.objects.iterator():
        Token.objects.get_or_create(
            user=user,
            defaults={'key': get_random_string(40)}
        )


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0015_auto_20160304_1418'),
        ('authtoken', '0001_initial'),
        ('auth', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(add_api_keys),
    ]
