# -*- coding: UTF-8 -*-
package = "alioss"
version = "0.22.2"
url = "http://www.phodal.com"
license = "GPL version 2"
author="Phodal.Gmszone"
author_emial="gmszone@gmail.com",
short_description = "Command line tool for managing Aliyun Open Storage Service."

long_description = """
osscmd lets you create/delete/list bucket and upload/download/copy/delete file from/to
        Aliyun OSS (Open Storage Service).

The package would not be update .
===============================

阿里云开放存储服务 Open Storage Service (OSS) Python SDK说明文档
===============================================================

阿里云开放存储服务官方网站:
    http://oss.aliyun.com

阿里云开放存储 
===============================================================
存储在OSS里的文件叫做"object". 所有的object都放在bucket里面。

简介
===============================================================
这篇文档主要介绍如何使用Python来进行OSS API调用，并且介绍osscmd
的简单使用。
这篇文档假设你已经熟悉Python，熟悉OSS的相关概念，并且已经注册了
阿里云的OSS服务，且获得了相应的ID和KEY。
如果你还没有开通或者还不了解OSS，请移步OSS官方网站。

环境要求
===============================================================
Python SDK需要：安装python 2.5（包括）以上且在3.0（不包括）以下
的版本。
可以在Windows平台和Linux平台使用。

如何获取
===============================================================
1.  打开浏览器，输入oss.aliyun.com
2.  找到Python SDK链接：
3.  下载后可以得到类似OSS_Python_API_xxxxxxxx.tar.gz的包
4.  进入压缩包所在的目录，进行解压缩
5.  解压缩后得到，oss文件夹和osscmd文件
 
使用说明
===============================================================
使用oss_api.py 
===============================================================
1.  创建bucket
    def put_bucket(self, bucket, acl='', headers=None):
        等同create_bucket函数
    def create_bucket(self, bucket, acl='', headers=None):
        参数说明：
            bucket，类型：string
            acl，类型：string，目前为private，public-read， 
                public-read-write中的一种
            headers， 类型：dict，默认为空
        返回值说明：
            HTTP Response 
            参见http://docs.python.org/2/library/httplib.html
    def put_bucket_with_location(self, bucket, acl='', \
                                 location='', headers=None):
        参数说明：
            bucket，类型：string
            acl，类型：string
            location， 类型：string
            headers， 类型：dict
        返回值说明：
            HTTP Response
2.  删除bucket
    def delete_bucket(self, bucket, headers=None):
        参数说明：
            bucket，类型：string
            headers， 类型：dict
        返回值说明：
            HTTP Response
3.  修改bucket访问权限
    def put_bucket(self, bucket, acl='', headers=None):
    def create_bucket(self, bucket, acl='', headers=None):
        同1中的put_bucket和create_bucket
4.  获取bucket访问权限
    def get_bucket_acl(self, bucket):
        参数说明：
            bucket，类型：string
        返回值说明：
            HTTP Response
5.  显示创建的bucket
    def get_service(self, headers=None):
        参数说明：
            headers， 类型：dict
        返回值说明：
            HTTP Response
    def list_all_my_buckets(self, headers=None):
        参数说明：
            headers， 类型：dict
        返回值说明：
            HTTP Response
6.  上传object
    def put_object_from_string(self, bucket, object,\
                               input_content,\
                               content_type=DefaultContentType,\
                               headers=None, params=None):
        参数说明：   
            bucket，类型：string
            object，类型：string
            input_content，类型：string
            content_type，类型：string
            headers，类型：dict
            params，类型：dict
        返回值说明：
            HTTP Response
    def put_object_from_file(self, bucket, object,\
                             filename, content_type='',\
                             headers=None, params=None):
        参数说明：   
            bucket，类型：string
            object，类型：string
            filename，类型：string，本地需要上传的文件名
            content_type，类型：string，object的类型
            headers，类型：dict
            params，类型：dict
        返回值说明：
            HTTP Response
7.  显示上传的object
    def get_bucket(self, bucket, prefix='', marker='',\
                   delimiter='', maxkeys='', headers=None):
        同list_bucket 
    def list_bucket(self, bucket, prefix='', marker='',\
                    delimiter='', maxkeys='', headers=None):
        参数说明：   
            bucket，类型：string
            prefix，类型：string
            marker，类型：string
            delimiter，类型：string
            maxkeys，类型：string
            headers，类型：dict
        返回值说明：
            HTTP Response
8.  删除object
    def delete_object(self, bucket, object, headers=None):
        参数说明：   
            bucket，类型：string
            object，类型：string
            headers，类型：dict
        返回值说明：
            HTTP Response
9.  下载object
    def get_object_to_file(self, bucket, object,\
                           filename, headers=None):
        参数说明：   
            bucket，类型：string
            object，类型：string
            filename，类型：string，
                将object内容下载到本地文件的文件名
            headers，类型：dict
        返回值说明：
            HTTP Response
10. 使用示例：
在解压的oss目录下，创建一个测试文件test.py内容如下，
并将ACCESS_ID和SECRET_ACCESS_KEY的内容填写正确，
并且将BUCKET填写一个唯一的名字。

#!/usr/bin/env python
#coding=utf8
import time
from oss_api import *
from oss_xml_handler import *
HOST="oss.aliyuncs.com"
ACCESS_ID = ""
SECRET_ACCESS_KEY = ""
#ACCESS_ID and SECRET_ACCESS_KEY 默认是空，
#请填入您申请的正确的ID和KEY.
BUCKET = ""
#bucket 默认是空，请填入唯一的bucket名称
#例如test-bucket-20130101等带唯一日期的bucket名字.

def check_not_empty(input, msg=""):
    if not input:
        print "Please make sure %s not empty!" % msg 
        exit(-1)
def check_res(res, msg=""):
    if res.status / 100 == 2:
        print "%s OK" % msg
    else:
        print "%s FAIL" % msg
        print "ret:%s" % res.status
        print "request-id:%s" % res.getheader("x-oss-request-id")
        print "reason:%s" % res.read()
        exit(-1)
   
if __name__ == "__main__": 
    #初始化
    check_not_empty(ACCESS_ID, "ACCESS_ID")
    check_not_empty(SECRET_ACCESS_KEY, "SECRET_ACCESS_KEY")
    oss = OssAPI(HOST, ACCESS_ID, SECRET_ACCESS_KEY)
    #创建属于自己的bucket
    bucket = BUCKET 
    check_not_empty(bucket, "bucket")
    acl = 'private'
    headers = {}
    res = oss.put_bucket(bucket, acl, headers)
    check_res(res, "create bucket")

    #列出创建的bucket
    res = oss.get_service()
    check_res(res, "list all buckets")
    #把指定的字符串内容上传到bucket中,在bucket中的文件名叫object。
    object = "object_test"
    input_content = "hello, OSS"
    content_type = "text/HTML"
    headers = {}
    res = oss.put_object_from_string(bucket, object, input_content, content_type, headers)
    check_res(res, "upload from string")
    #指定文件名, 把这个文件上传到bucket中,在bucket中的文件名叫object。
    object = "object_test"
    filename = __file__ 
    content_type = "text/HTML"
    headers = {}
    res = oss.put_object_from_file(bucket, object, filename, content_type, headers)
    check_res(res, "upload from localfile")
    #下载bucket中的object，内容在body中
    object = "object_test"
    headers = {}
    res = oss.get_object(bucket, object, headers)
    check_res(res, "download object")
    #下载bucket中的object，把内容写入到本地文件中
    object = "object_test"
    headers = {}
    filename = "get_object_test_file"
    res = oss.get_object_to_file(bucket, object, filename, headers)
    if os.path.isfile(filename):
        os.remove(filename)
    check_res(res, "download object to localfile")   
    #查看bucket中所拥有的权限
    res = oss.get_bucket_acl(bucket)
    check_res(res, "get bucket acl")
    #列出bucket中所拥有的object
    prefix = ""
    marker = ""
    delimiter = "/"
    maxkeys = "100"
    headers = {}
    res = oss.get_bucket(bucket, prefix, marker, delimiter, maxkeys, headers)   
    check_res(res, "list objects in bucket")
    #删除bucket中的object
    object = "object_test"
    headers = {}
    res = oss.delete_object(bucket, object, headers)
    check_res(res, "delete object")
    #删除bucket
    res = oss.delete_bucket(bucket)
    check_res(res, "delete bucket")

11. 示例的预期结果：
    create bucket OK
    list all buckets OK
    upload from string OK
    upload from localfile OK
    download object OK
    download object to localfile OK
    get bucket acl OK
    list objects in bucket OK
    delete object OK
    delete bucket OK

使用osscmd
===============================================================
1.  在Linux上安装 osscmd.
    sudo rm -r /usr/local/oss
    sudo mkdir -p /usr/local/oss
    sudo tar -zxf oss.tar.gz -C /usr/local/oss
    sudo rm -f /usr/bin/osscmd
    sudo ln -s /usr/local/oss/osscmd /usr/bin/osscmd
    sudo chmod 755 /usr/local/oss/osscmd

    在Windows上安装osscmd
    解压缩包
   
2.  运行"python osscmd config --id=YOUR_ID --key=YOUR_KEY" 
    用来配置访问OSS所需要的认证码
   

3.  运行"python osscmd getallbucket" 列出创建的bucket.
    如果是刚刚使用OSS的用户因为没有创建bucket，输出是空

4.  运行"python osscmd createbucket mybucket" 创建一个名字
    叫mybucket的bucket，有可能不成功，这个时候需要换一个名字。
    因为OSS中的bucket名字是全局唯一的。

5.  可以再次运行"python osscmd getallbucket" 查看是否创建成功。
    如果没有成功请检查osscmd返回的错误信息。

6.  成功创建bucket后。运行"python osscmd list oss://mybucket/",
    查看bucket中有哪些object。
    由于bucket中还没有
    object，输出是空的。

7.  向bucket中上传一个object.
    $ md5sum my_local_file
    7625e1adc3a4b129763d580ca0a78e44 my_local_file

    $ python osscmd put my_local_file oss://mybucket/myobject

8.  如果创建成功，再次运行"python osscmd list oss://mybucket/" 

9.  从bucket中下载object到本地文件，并比对下载的文件的md5值
    $ python osscmd get oss://mybucket/myobject local_file

    $ md5sum local_file
    7625e1adc3a4b129763d580ca0a78e44  local_file

10. 删除bucket中的object 
    $ python osscmd delete oss://mybucket/myobject

11. 删除bucket, 注意，如果bucket中有object或者parts
    则这个bucket不能被删除
    $ python osscmd deletebucket test-oss-aliyun-com

ChangeHistory
===============================================================
0.3.2   -   2013-10-20
* 修复osscmd的uploadfromdir命令中，在中文目录下，上传的object名字被截断的问题。
* 修复oss_util.py中DEBUG被设置成True的情况下无法打印log的问题。
* oss_api.py中增加了设置每次上传和下载大小的接口。
* osscmd增加了--debug=true来打印日志。
* oss_api.py中增加了上传失败时候的重试，最大重试100次。

0.3.1   -   2013-08-02
* 支持跳转。
* 给oss_api.py部分函数增加说明。

0.1.3   -   2013-07-12
* 支持multipart相关操作，osscmd增加multipart相关的接口。
  osscmd支持本地目录上传。
  osscmd支持将bucket的某一个prefix的object下载到本地的目录。

0.1.0   -   2011-11-15
* 第一次操作支持基本的创建，删除和显示bucket。
  支持创建，删除和显示object。


"""

