"""
A module for a stopwatch timer.

Copyright (C) 2020, fondlez "Anuber"-Kronos, fondlez at protonmail.com
"""
import time


class Timer(object):
    """A stopwtch timer class for timing of arbitrary code blocks.
    
    Ref: Recipe 13.13 in 'Python Cookbook', Third Edition, by David Beazley 
    and Brian k. Jones
    """
    def __init__(self, func=time.perf_counter):
        self.elapsed = 0.0
        self._func = func
        self._start = None

    def start(self):
        if self._start is not None:
            raise RuntimeError('Already started.')
        self._start = self._func()

    def stop(self):
        if self._start is None:
            raise RuntimeError('Not started.')
        end = self._func()
        self.elapsed += end - self._start
        self._start = None

    def reset(self):
        self.elapsed = 0.0

    @property
    def running(self):
        return self._start is not None

    def __enter__(self):
        self.start()
        return self

    def __exit__(self, *args):
        self.stop()
