# Copyright ©, 2022-present, Lightspark Group, Inc. - All Rights Reserved

from enum import Enum


class RegionCode(Enum):
    """The alpha-2 representation of a country, as defined by the ISO 3166-1 standard."""

    ___FUTURE_VALUE___ = "___FUTURE_VALUE___"
    """This is an enum value that represents future values that could be added in the future. Clients should support unknown values as more of them could be added without notice."""
    AF = "AF"
    """The code representing the country of Afghanistan."""
    AX = "AX"
    """The code representing the country of Åland Islands."""
    AL = "AL"
    """The code representing the country of Albania."""
    DZ = "DZ"
    """The code representing the country of Algeria."""
    AS = "AS"
    """The code representing the country of American Samoa."""
    AD = "AD"
    """The code representing the country of Andorra."""
    AO = "AO"
    """The code representing the country of Angola."""
    AI = "AI"
    """The code representing the country of Anguilla."""
    AQ = "AQ"
    """The code representing the country of Antarctica."""
    AG = "AG"
    """The code representing the country of Antigua and Barbuda."""
    AR = "AR"
    """The code representing the country of Argentina."""
    AM = "AM"
    """The code representing the country of Armenia."""
    AW = "AW"
    """The code representing the country of Aruba."""
    AU = "AU"
    """The code representing the country of Australia."""
    AT = "AT"
    """The code representing the country of Austria."""
    AZ = "AZ"
    """The code representing the country of Azerbaijan."""
    BS = "BS"
    """The code representing the country of Bahamas."""
    BH = "BH"
    """The code representing the country of Bahrain."""
    BD = "BD"
    """The code representing the country of Bangladesh."""
    BB = "BB"
    """The code representing the country of Barbados."""
    BY = "BY"
    """The code representing the country of Belarus."""
    BE = "BE"
    """The code representing the country of Belgium."""
    BZ = "BZ"
    """The code representing the country of Belize."""
    BJ = "BJ"
    """The code representing the country of Benin."""
    BM = "BM"
    """The code representing the country of Bermuda."""
    BT = "BT"
    """The code representing the country of Bhutan."""
    BO = "BO"
    """The code representing the country of The Plurinational State of Bolivia."""
    BQ = "BQ"
    """The code representing the country of Bonaire, Sint Eustatius, and Saba."""
    BA = "BA"
    """The code representing the country of Bosnia and Herzegovina."""
    BW = "BW"
    """The code representing the country of Botswana."""
    BV = "BV"
    """The code representing the country of Bouvet Island."""
    BR = "BR"
    """The code representing the country of Brazil."""
    IO = "IO"
    """The code representing the country of British Indian Ocean Territory."""
    BN = "BN"
    """The code representing the country of Brunei Darussalam."""
    BG = "BG"
    """The code representing the country of Bulgaria."""
    BF = "BF"
    """The code representing the country of Burkina Faso."""
    BI = "BI"
    """The code representing the country of Burundi."""
    KH = "KH"
    """The code representing the country of Cambodia."""
    CM = "CM"
    """The code representing the country of Cameroon."""
    CA = "CA"
    """The code representing the country of Canada."""
    CV = "CV"
    """The code representing the country of Cape Verde."""
    KY = "KY"
    """The code representing the country of Cayman Islands."""
    CF = "CF"
    """The code representing the country of Central African Republic."""
    TD = "TD"
    """The code representing the country of Chad."""
    CL = "CL"
    """The code representing the country of Chile."""
    CN = "CN"
    """The code representing the country of China."""
    CX = "CX"
    """The code representing the country of Christmas Island."""
    CC = "CC"
    """The code representing the country of Cocos (Keeling) Islands."""
    CO = "CO"
    """The code representing the country of Colombia."""
    KM = "KM"
    """The code representing the country of Comoros."""
    CG = "CG"
    """The code representing the country of Congo."""
    CD = "CD"
    """The code representing the country of The Democratic Republic of the Congo."""
    CK = "CK"
    """The code representing the country of Cook Islands."""
    CR = "CR"
    """The code representing the country of Costa Rica."""
    CI = "CI"
    """The code representing the country of Côte d'Ivoire."""
    HR = "HR"
    """The code representing the country of Croatia."""
    CU = "CU"
    """The code representing the country of Cuba."""
    CW = "CW"
    """The code representing the country of Curaçao."""
    CY = "CY"
    """The code representing the country of Cyprus."""
    CZ = "CZ"
    """The code representing the country of Czech Republic."""
    DK = "DK"
    """The code representing the country of Denmark."""
    DJ = "DJ"
    """The code representing the country of Djibouti."""
    DM = "DM"
    """The code representing the country of Dominica."""
    DO = "DO"
    """The code representing the country of Dominican Republic."""
    EC = "EC"
    """The code representing the country of Ecuador."""
    EG = "EG"
    """The code representing the country of Egypt."""
    SV = "SV"
    """The code representing the country of El Salvador."""
    GQ = "GQ"
    """The code representing the country of Equatorial Guinea."""
    ER = "ER"
    """The code representing the country of Eritrea."""
    EE = "EE"
    """The code representing the country of Estonia."""
    ET = "ET"
    """The code representing the country of Ethiopia."""
    FK = "FK"
    """The code representing the country of Falkland Islands (Malvinas)."""
    FO = "FO"
    """The code representing the country of Faroe Islands."""
    FJ = "FJ"
    """The code representing the country of Fiji."""
    FI = "FI"
    """The code representing the country of Finland."""
    FR = "FR"
    """The code representing the country of France."""
    GF = "GF"
    """The code representing the country of French Guiana."""
    PF = "PF"
    """The code representing the country of French Polynesia."""
    TF = "TF"
    """The code representing the country of French Southern Territories."""
    GA = "GA"
    """The code representing the country of Gabon."""
    GM = "GM"
    """The code representing the country of Gambia."""
    GE = "GE"
    """The code representing the country of Georgia."""
    DE = "DE"
    """The code representing the country of Germany."""
    GH = "GH"
    """The code representing the country of Ghana."""
    GI = "GI"
    """The code representing the country of Gibraltar."""
    GR = "GR"
    """The code representing the country of Greece."""
    GL = "GL"
    """The code representing the country of Greenland."""
    GD = "GD"
    """The code representing the country of Grenada."""
    GP = "GP"
    """The code representing the country of Guadeloupe."""
    GU = "GU"
    """The code representing the country of Guam."""
    GT = "GT"
    """The code representing the country of Guatemala."""
    GG = "GG"
    """The code representing the country of Guernsey."""
    GN = "GN"
    """The code representing the country of Guinea."""
    GW = "GW"
    """The code representing the country of Guinea-Bissau."""
    GY = "GY"
    """The code representing the country of Guyana."""
    HT = "HT"
    """The code representing the country of Haiti."""
    HM = "HM"
    """The code representing the country of Heard Island and McDonald Islands."""
    VA = "VA"
    """The code representing the country of Holy See (Vatican City State)."""
    HN = "HN"
    """The code representing the country of Honduras."""
    HK = "HK"
    """The code representing the country of Hong Kong."""
    HU = "HU"
    """The code representing the country of Hungary."""
    IS = "IS"
    """The code representing the country of Iceland."""
    IN = "IN"
    """The code representing the country of India."""
    ID = "ID"
    """The code representing the country of Indonesia."""
    IR = "IR"
    """The code representing the country of Islamic Republic of Iran."""
    IQ = "IQ"
    """The code representing the country of Iraq."""
    IE = "IE"
    """The code representing the country of Ireland."""
    IM = "IM"
    """The code representing the country of Isle of Man."""
    IL = "IL"
    """The code representing the country of Israel."""
    IT = "IT"
    """The code representing the country of Italy."""
    JM = "JM"
    """The code representing the country of Jamaica."""
    JP = "JP"
    """The code representing the country of Japan."""
    JE = "JE"
    """The code representing the country of Jersey."""
    JO = "JO"
    """The code representing the country of Jordan."""
    KZ = "KZ"
    """The code representing the country of Kazakhstan."""
    KE = "KE"
    """The code representing the country of Kenya."""
    KI = "KI"
    """The code representing the country of Kiribati."""
    KP = "KP"
    """The code representing the country of Democratic People's Republic ofKorea."""
    KR = "KR"
    """The code representing the country of Republic of Korea."""
    KW = "KW"
    """The code representing the country of Kuwait."""
    KG = "KG"
    """The code representing the country of Kyrgyzstan."""
    LA = "LA"
    """The code representing the country of Lao People's Democratic Republic."""
    LV = "LV"
    """The code representing the country of Latvia."""
    LB = "LB"
    """The code representing the country of Lebanon."""
    LS = "LS"
    """The code representing the country of Lesotho."""
    LR = "LR"
    """The code representing the country of Liberia."""
    LY = "LY"
    """The code representing the country of Libya."""
    LI = "LI"
    """The code representing the country of Liechtenstein."""
    LT = "LT"
    """The code representing the country of Lithuania."""
    LU = "LU"
    """The code representing the country of Luxembourg."""
    MO = "MO"
    """The code representing the country of Macao."""
    MK = "MK"
    """The code representing the country of The Former Yugoslav Republic of Macedonia."""
    MG = "MG"
    """The code representing the country of Madagascar."""
    MW = "MW"
    """The code representing the country of Malawi."""
    MY = "MY"
    """The code representing the country of Malaysia."""
    MV = "MV"
    """The code representing the country of Maldives."""
    ML = "ML"
    """The code representing the country of Mali."""
    MT = "MT"
    """The code representing the country of Malta."""
    MH = "MH"
    """The code representing the country of Marshall Islands."""
    MQ = "MQ"
    """The code representing the country of Martinique."""
    MR = "MR"
    """The code representing the country of Mauritania."""
    MU = "MU"
    """The code representing the country of Mauritius."""
    YT = "YT"
    """The code representing the country of Mayotte."""
    MX = "MX"
    """The code representing the country of Mexico."""
    FM = "FM"
    """The code representing the country of Federated States ofMicronesia."""
    MD = "MD"
    """The code representing the country of Republic of Moldova."""
    MC = "MC"
    """The code representing the country of Monaco."""
    MN = "MN"
    """The code representing the country of Mongolia."""
    ME = "ME"
    """The code representing the country of Montenegro."""
    MS = "MS"
    """The code representing the country of Montserrat."""
    MA = "MA"
    """The code representing the country of Morocco."""
    MZ = "MZ"
    """The code representing the country of Mozambique."""
    MM = "MM"
    """The code representing the country of Myanmar."""
    NA = "NA"
    """The code representing the country of Namibia."""
    NR = "NR"
    """The code representing the country of Nauru."""
    NP = "NP"
    """The code representing the country of Nepal."""
    NL = "NL"
    """The code representing the country of Netherlands."""
    NC = "NC"
    """The code representing the country of New Caledonia."""
    NZ = "NZ"
    """The code representing the country of New Zealand."""
    NI = "NI"
    """The code representing the country of Nicaragua."""
    NE = "NE"
    """The code representing the country of Niger."""
    NG = "NG"
    """The code representing the country of Nigeria."""
    NU = "NU"
    """The code representing the country of Niue."""
    NF = "NF"
    """The code representing the country of Norfolk Island."""
    MP = "MP"
    """The code representing the country of Northern Mariana Islands."""
    NO = "NO"
    """The code representing the country of Norway."""
    OM = "OM"
    """The code representing the country of Oman."""
    PK = "PK"
    """The code representing the country of Pakistan."""
    PW = "PW"
    """The code representing the country of Palau."""
    PS = "PS"
    """The code representing the country of State of Palestine."""
    PA = "PA"
    """The code representing the country of Panama."""
    PG = "PG"
    """The code representing the country of Papua New Guinea."""
    PY = "PY"
    """The code representing the country of Paraguay."""
    PE = "PE"
    """The code representing the country of Peru."""
    PH = "PH"
    """The code representing the country of Philippines."""
    PN = "PN"
    """The code representing the country of Pitcairn."""
    PL = "PL"
    """The code representing the country of Poland."""
    PT = "PT"
    """The code representing the country of Portugal."""
    PR = "PR"
    """The code representing the country of Puerto Rico."""
    QA = "QA"
    """The code representing the country of Qatar."""
    RE = "RE"
    """The code representing the country of Réunion."""
    RO = "RO"
    """The code representing the country of Romania."""
    RU = "RU"
    """The code representing the country of Russian Federation."""
    RW = "RW"
    """The code representing the country of Rwanda."""
    BL = "BL"
    """The code representing the country of Saint Barthélemy."""
    SH = "SH"
    """The code representing the country of Saint Helena  Ascension and Tristan da Cunha."""
    KN = "KN"
    """The code representing the country of Saint Kitts and Nevis."""
    LC = "LC"
    """The code representing the country of Saint Lucia."""
    MF = "MF"
    """The code representing the country of Saint Martin (French part)."""
    PM = "PM"
    """The code representing the country of Saint Pierre and Miquelon."""
    VC = "VC"
    """The code representing the country of Saint Vincent and the Grenadines."""
    WS = "WS"
    """The code representing the country of Samoa."""
    SM = "SM"
    """The code representing the country of San Marino."""
    ST = "ST"
    """The code representing the country of Sao Tome and Principe."""
    SA = "SA"
    """The code representing the country of Saudi Arabia."""
    SN = "SN"
    """The code representing the country of Senegal."""
    RS = "RS"
    """The code representing the country of Serbia."""
    SC = "SC"
    """The code representing the country of Seychelles."""
    SL = "SL"
    """The code representing the country of Sierra Leone."""
    SG = "SG"
    """The code representing the country of Singapore."""
    SX = "SX"
    """The code representing the country of Sint Maarten (Dutch part)."""
    SK = "SK"
    """The code representing the country of Slovakia."""
    SI = "SI"
    """The code representing the country of Slovenia."""
    SB = "SB"
    """The code representing the country of Solomon Islands."""
    SO = "SO"
    """The code representing the country of Somalia."""
    ZA = "ZA"
    """The code representing the country of South Africa."""
    GS = "GS"
    """The code representing the country of South Georgia and the South Sandwich Islands."""
    SS = "SS"
    """The code representing the country of South Sudan."""
    ES = "ES"
    """The code representing the country of Spain."""
    LK = "LK"
    """The code representing the country of Sri Lanka."""
    SD = "SD"
    """The code representing the country of Sudan."""
    SR = "SR"
    """The code representing the country of Suriname."""
    SJ = "SJ"
    """The code representing the country of Svalbard and Jan Mayen."""
    SZ = "SZ"
    """The code representing the country of Swaziland."""
    SE = "SE"
    """The code representing the country of Sweden."""
    CH = "CH"
    """The code representing the country of Switzerland."""
    SY = "SY"
    """The code representing the country of Syrian Arab Republic."""
    TW = "TW"
    """The code representing the country of Taiwan, Province of China."""
    TJ = "TJ"
    """The code representing the country of Tajikistan."""
    TZ = "TZ"
    """The code representing the country of United Republic of Tanzania."""
    TH = "TH"
    """The code representing the country of Thailand."""
    TL = "TL"
    """The code representing the country of Timor-Leste."""
    TG = "TG"
    """The code representing the country of Togo."""
    TK = "TK"
    """The code representing the country of Tokelau."""
    TO = "TO"
    """The code representing the country of Tonga."""
    TT = "TT"
    """The code representing the country of Trinidad and Tobago."""
    TN = "TN"
    """The code representing the country of Tunisia."""
    TR = "TR"
    """The code representing the country of Turkey."""
    TM = "TM"
    """The code representing the country of Turkmenistan."""
    TC = "TC"
    """The code representing the country of Turks and Caicos Islands."""
    TV = "TV"
    """The code representing the country of Tuvalu."""
    UG = "UG"
    """The code representing the country of Uganda."""
    UA = "UA"
    """The code representing the country of Ukraine."""
    AE = "AE"
    """The code representing the country of United Arab Emirates."""
    GB = "GB"
    """The code representing the country of United Kingdom."""
    US = "US"
    """The code representing the country of United States."""
    UM = "UM"
    """The code representing the country of United States Minor Outlying Islands."""
    UY = "UY"
    """The code representing the country of Uruguay."""
    UZ = "UZ"
    """The code representing the country of Uzbekistan."""
    VU = "VU"
    """The code representing the country of Vanuatu."""
    VE = "VE"
    """The code representing the country of Bolivarian Republic of Venezuela."""
    VN = "VN"
    """The code representing the country of Viet Nam."""
    VG = "VG"
    """The code representing the country of British Virgin Islands."""
    VI = "VI"
    """The code representing the country of U.S. Virgin Islands."""
    WF = "WF"
    """The code representing the country of Wallis and Futuna."""
    EH = "EH"
    """The code representing the country of Western Sahara."""
    YE = "YE"
    """The code representing the country of Yemen."""
    ZM = "ZM"
    """The code representing the country of Zambia."""
    ZW = "ZW"
    """The code representing the country of Zimbabwe."""
