﻿# 
# Copyright (c) Microsoft and contributors.  All rights reserved.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#   http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# 
# See the License for the specific language governing permissions and
# limitations under the License.
# 

# Warning: This code was generated by a tool.
# 
# Changes to this file may cause incorrect behavior and will be lost if the
# code is regenerated.

import json
import re
from requests import Session, Request
import time
try:
    from urllib import quote, unquote
except:
    from urllib.parse import quote, unquote
from azure.common import AzureHttpError
from azure.mgmt.common import AzureOperationResponse, OperationStatusResponse, OperationStatus, Service
from azure.mgmt.common.arm import ResourceBase, ResourceBaseExtended

class DnsNameAvailabilityResponse(AzureOperationResponse):
    """
     Response for CheckDnsNameAvailability Api servive call
    """
    
    def __init__(self, **kwargs):
        super(DnsNameAvailabilityResponse, self).__init__(**kwargs)
        self._dns_name_availability = kwargs.get('dns_name_availability')
    
    @property
    def dns_name_availability(self):
        """
         Domain availability (True/False)
        """
        return self._dns_name_availability
    
    @dns_name_availability.setter 
    def dns_name_availability(self, value):
        self._dns_name_availability = value

class ResourceProviderErrorResponse(AzureOperationResponse):
    """
     If the resource provide needs to return an error to any operation, it
     should return the appropriate HTTP error code and a message body as can
     be seen below.The message should be localized per the Accept-Language
     header specified in the original request such thatit could be directly be
     exposed to users
    """
    
    def __init__(self, **kwargs):
        super(ResourceProviderErrorResponse, self).__init__(**kwargs)
        self._error = kwargs.get('error')
    
    @property
    def error(self):
        return self._error
    
    @error.setter 
    def error(self, value):
        self._error = value

class RetriableOperationResponse(ResourceProviderErrorResponse):
    """
     If the resource provide needs to return an error to any operation, it
     should return the appropriate HTTP error code and a message body as can
     be seen below.The message should be localized per the Accept-Language
     header specified in the original request such thatit could be directly be
     exposed to users
    """
    
    def __init__(self, **kwargs):
        super(RetriableOperationResponse, self).__init__(**kwargs)
        self._retry_after = kwargs.get('retry_after', 0)
    
    @property
    def retry_after(self):
        """
         The recommended retry interval for the Get Azure-AsyncOperation call
        """
        return self._retry_after
    
    @retry_after.setter 
    def retry_after(self, value):
        self._retry_after = value

class AzureAsyncOperationResponse(RetriableOperationResponse):
    """
     The response body contains the status of the specified asynchronous
     operation, indicating whether it has succeeded, is inprogress, or has
     failed. Note that this status is distinct from the HTTP status code
     returned for the Get Operation Status operation itself. If the
     asynchronous operation succeeded, the response body includes the HTTP
     status code for the successful request. If the asynchronous operation
     failed, the response body includes the HTTP status code for the failed
     request and error information regarding the failure.
    """
    
    def __init__(self, **kwargs):
        super(AzureAsyncOperationResponse, self).__init__(**kwargs)
        self._status = kwargs.get('status')
    
    @property
    def status(self):
        """
         Status of the AzureAsuncOperation
        """
        return self._status
    
    @status.setter 
    def status(self, value):
        self._status = value

class UpdateOperationResponse(RetriableOperationResponse):
    """
     If the resource provide needs to return an error to any operation, it
     should return the appropriate HTTP error code and a message body as can
     be seen below.The message should be localized per the Accept-Language
     header specified in the original request such thatit could be directly be
     exposed to users
    """
    
    def __init__(self, **kwargs):
        super(UpdateOperationResponse, self).__init__(**kwargs)
        self._azure_async_operation = kwargs.get('azure_async_operation')
    
    @property
    def azure_async_operation(self):
        """
         Users can perform a Get on Azure-AsyncOperation to get the status of
         their update(PUT/PATCH/DELETE) operations
        """
        return self._azure_async_operation
    
    @azure_async_operation.setter 
    def azure_async_operation(self, value):
        self._azure_async_operation = value

class LoadBalancerGetResponse(AzureOperationResponse):
    """
     Response of a GET Load Balancer operation
    """
    
    def __init__(self, **kwargs):
        super(LoadBalancerGetResponse, self).__init__(**kwargs)
        self._load_balancer = kwargs.get('load_balancer')
    
    @property
    def load_balancer(self):
        """
         Gets a Load Balancer in a resource group
        """
        return self._load_balancer
    
    @load_balancer.setter 
    def load_balancer(self, value):
        self._load_balancer = value

class LoadBalancerListResponse(AzureOperationResponse):
    """
     Response for ListLoadBalancers Api service call
    """
    
    def __init__(self, **kwargs):
        super(LoadBalancerListResponse, self).__init__(**kwargs)
        self._load_balancers = kwargs.get('load_balancers')
        self._next_link = kwargs.get('next_link')
    
    @property
    def load_balancers(self):
        """
         Gets a list of LoadBalancers in a resource group
        """
        return self._load_balancers
    
    @load_balancers.setter 
    def load_balancers(self, value):
        self._load_balancers = value
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value

class LoadBalancerPutResponse(UpdateOperationResponse):
    """
     Response of a PUT Load Balancer operation
    """
    
    def __init__(self, **kwargs):
        super(LoadBalancerPutResponse, self).__init__(**kwargs)
        self._load_balancer = kwargs.get('load_balancer')
    
    @property
    def load_balancer(self):
        """
         Gets Load Balancer in a resource group
        """
        return self._load_balancer
    
    @load_balancer.setter 
    def load_balancer(self, value):
        self._load_balancer = value

class TopLevelResource(ResourceBaseExtended):
    """
     A common class for general resource information
    """
    
    def __init__(self, **kwargs):
        super(TopLevelResource, self).__init__(**kwargs)
        self._etag = kwargs.get('etag')
    
    @property
    def etag(self):
        """
         Gets a unique read-only string that changes whenever the resource is
         updated
        """
        return self._etag
    
    @etag.setter 
    def etag(self, value):
        self._etag = value

class LoadBalancer(TopLevelResource):
    """
     LoadBalancer resource
    """
    
    def __init__(self, **kwargs):
        super(LoadBalancer, self).__init__(**kwargs)
        self._frontend_ip_configurations = kwargs.get('frontend_ip_configurations')
        self._backend_address_pools = kwargs.get('backend_address_pools')
        self._load_balancing_rules = kwargs.get('load_balancing_rules')
        self._probes = kwargs.get('probes')
        self._inbound_nat_rules = kwargs.get('inbound_nat_rules')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def backend_address_pools(self):
        """
         Gets or sets Pools of backend IP addresseses
        """
        return self._backend_address_pools
    
    @backend_address_pools.setter 
    def backend_address_pools(self, value):
        self._backend_address_pools = value
    
    @property
    def frontend_ip_configurations(self):
        """
         Gets or sets frontend IP addresses of the load balancer
        """
        return self._frontend_ip_configurations
    
    @frontend_ip_configurations.setter 
    def frontend_ip_configurations(self, value):
        self._frontend_ip_configurations = value
    
    @property
    def inbound_nat_rules(self):
        """
         Gets or sets list of inbound rules
        """
        return self._inbound_nat_rules
    
    @inbound_nat_rules.setter 
    def inbound_nat_rules(self, value):
        self._inbound_nat_rules = value
    
    @property
    def load_balancing_rules(self):
        """
         Gets or sets loadbalancing rules
        """
        return self._load_balancing_rules
    
    @load_balancing_rules.setter 
    def load_balancing_rules(self, value):
        self._load_balancing_rules = value
    
    @property
    def probes(self):
        """
         Gets or sets list of Load balancer probes
        """
        return self._probes
    
    @probes.setter 
    def probes(self, value):
        self._probes = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class LocalNetworkGatewayPutResponse(UpdateOperationResponse):
    """
     Response for PutLocalNetworkGateway Api servive call
    """
    
    def __init__(self, **kwargs):
        super(LocalNetworkGatewayPutResponse, self).__init__(**kwargs)
        self._local_network_gateway = kwargs.get('local_network_gateway')
    
    @property
    def local_network_gateway(self):
        """
         Puts the local network gateway that exists in a resource group
        """
        return self._local_network_gateway
    
    @local_network_gateway.setter 
    def local_network_gateway(self, value):
        self._local_network_gateway = value

class LocalNetworkGateway(TopLevelResource):
    """
     A common class for general resource information
    """
    
    def __init__(self, **kwargs):
        super(LocalNetworkGateway, self).__init__(**kwargs)
        self._gateway_ip_address = kwargs.get('gateway_ip_address')
        self._local_network_site_address_space = kwargs.get('local_network_site_address_space')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def gateway_ip_address(self):
        """
         IP address of local network gateway.
        """
        return self._gateway_ip_address
    
    @gateway_ip_address.setter 
    def gateway_ip_address(self, value):
        self._gateway_ip_address = value
    
    @property
    def local_network_site_address_space(self):
        """
         Local network site Address space
        """
        return self._local_network_site_address_space
    
    @local_network_site_address_space.setter 
    def local_network_site_address_space(self, value):
        self._local_network_site_address_space = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the LocalNetworkGateway resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class LocalNetworkGatewayGetResponse(AzureOperationResponse):
    """
     Response for GetLocalNetworkgateway Api servive call.
    """
    
    def __init__(self, **kwargs):
        super(LocalNetworkGatewayGetResponse, self).__init__(**kwargs)
        self._local_network_gateway = kwargs.get('local_network_gateway')
    
    @property
    def local_network_gateway(self):
        """
         Gets local network gateway details that exists in a resource group
        """
        return self._local_network_gateway
    
    @local_network_gateway.setter 
    def local_network_gateway(self, value):
        self._local_network_gateway = value

class LocalNetworkGatewayListResponse(AzureOperationResponse):
    """
     Response for ListLocalNetworkGateways Api service call
    """
    
    def __init__(self, **kwargs):
        super(LocalNetworkGatewayListResponse, self).__init__(**kwargs)
        self._local_network_gateways = kwargs.get('local_network_gateways')
        self._next_link = kwargs.get('next_link')
    
    @property
    def local_network_gateways(self):
        """
         Gets List of LocalNetworkGateways that exists in a resource group
        """
        return self._local_network_gateways
    
    @local_network_gateways.setter 
    def local_network_gateways(self, value):
        self._local_network_gateways = value
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value

class NetworkInterfaceListResponse(AzureOperationResponse):
    """
     Response for ListNetworkInterface Api service call
    """
    
    def __init__(self, **kwargs):
        super(NetworkInterfaceListResponse, self).__init__(**kwargs)
        self._network_interfaces = kwargs.get('network_interfaces')
        self._next_link = kwargs.get('next_link')
    
    @property
    def network_interfaces(self):
        """
         Gets or sets list of NetworkInterfaces in a resource group
        """
        return self._network_interfaces
    
    @network_interfaces.setter 
    def network_interfaces(self, value):
        self._network_interfaces = value
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value

class NetworkInterfaceGetResponse(AzureOperationResponse):
    """
     Response for GetNetworkInterface Api service call
    """
    
    def __init__(self, **kwargs):
        super(NetworkInterfaceGetResponse, self).__init__(**kwargs)
        self._network_interface = kwargs.get('network_interface')
    
    @property
    def network_interface(self):
        """
         Gets or sets a NetworkInterface that exists in a resource group
        """
        return self._network_interface
    
    @network_interface.setter 
    def network_interface(self, value):
        self._network_interface = value

class NetworkInterfacePutResponse(UpdateOperationResponse):
    """
     Response for PutNetworkInterface Api servive call
    """
    
    def __init__(self, **kwargs):
        super(NetworkInterfacePutResponse, self).__init__(**kwargs)
        self._network_interface = kwargs.get('network_interface')
    
    @property
    def network_interface(self):
        """
         Gets a NetworkInterface that exists in a resource group
        """
        return self._network_interface
    
    @network_interface.setter 
    def network_interface(self, value):
        self._network_interface = value

class NetworkInterface(TopLevelResource):
    """
     A NetworkInterface in a resource group
    """
    
    def __init__(self, **kwargs):
        super(NetworkInterface, self).__init__(**kwargs)
        self._virtual_machine = kwargs.get('virtual_machine')
        self._network_security_group = kwargs.get('network_security_group')
        self._ip_configurations = kwargs.get('ip_configurations')
        self._dns_settings = kwargs.get('dns_settings')
        self._mac_address = kwargs.get('mac_address')
        self._primary = kwargs.get('primary')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def dns_settings(self):
        """
         Gets or sets DNsSettings in  NetworkInterface
        """
        return self._dns_settings
    
    @dns_settings.setter 
    def dns_settings(self, value):
        self._dns_settings = value
    
    @property
    def ip_configurations(self):
        """
         Gets or sets list of IPConfigurations of the NetworkInterface
        """
        return self._ip_configurations
    
    @ip_configurations.setter 
    def ip_configurations(self, value):
        self._ip_configurations = value
    
    @property
    def mac_address(self):
        """
         Gets the MAC Address of the network interface
        """
        return self._mac_address
    
    @mac_address.setter 
    def mac_address(self, value):
        self._mac_address = value
    
    @property
    def network_security_group(self):
        """
         Gets or sets the reference of the NetworkSecurityGroup resource
        """
        return self._network_security_group
    
    @network_security_group.setter 
    def network_security_group(self, value):
        self._network_security_group = value
    
    @property
    def primary(self):
        """
         Gets whether this is a primary NIC on a virtual machine
        """
        return self._primary
    
    @primary.setter 
    def primary(self, value):
        self._primary = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def virtual_machine(self):
        """
         Gets or sets the reference of a VirtualMachine
        """
        return self._virtual_machine
    
    @virtual_machine.setter 
    def virtual_machine(self, value):
        self._virtual_machine = value

class NetworkSecurityGroupGetResponse(AzureOperationResponse):
    """
     Response for GetNetworkSecurityGroup Api service call
    """
    
    def __init__(self, **kwargs):
        super(NetworkSecurityGroupGetResponse, self).__init__(**kwargs)
        self._network_security_group = kwargs.get('network_security_group')
    
    @property
    def network_security_group(self):
        """
         Gets a Network Security Group in a resource group
        """
        return self._network_security_group
    
    @network_security_group.setter 
    def network_security_group(self, value):
        self._network_security_group = value

class NetworkSecurityGroupListResponse(AzureOperationResponse):
    """
     Response for ListNetworkSecurityGroups Api servive call
    """
    
    def __init__(self, **kwargs):
        super(NetworkSecurityGroupListResponse, self).__init__(**kwargs)
        self._network_security_groups = kwargs.get('network_security_groups')
        self._next_link = kwargs.get('next_link')
    
    @property
    def network_security_groups(self):
        """
         Gets List of NetworkSecurityGroups in a resource group
        """
        return self._network_security_groups
    
    @network_security_groups.setter 
    def network_security_groups(self, value):
        self._network_security_groups = value
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value

class NetworkSecurityGroupPutResponse(UpdateOperationResponse):
    """
     Response for PUT NetworkSecurityGroups Api servive call
    """
    
    def __init__(self, **kwargs):
        super(NetworkSecurityGroupPutResponse, self).__init__(**kwargs)
        self._network_security_group = kwargs.get('network_security_group')
    
    @property
    def network_security_group(self):
        """
         Gets NetworkSecurityGroups in a resource group
        """
        return self._network_security_group
    
    @network_security_group.setter 
    def network_security_group(self, value):
        self._network_security_group = value

class NetworkSecurityGroup(TopLevelResource):
    """
     NetworkSecurityGroup resource
    """
    
    def __init__(self, **kwargs):
        super(NetworkSecurityGroup, self).__init__(**kwargs)
        self._security_rules = kwargs.get('security_rules')
        self._default_security_rules = kwargs.get('default_security_rules')
        self._network_interfaces = kwargs.get('network_interfaces')
        self._subnets = kwargs.get('subnets')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def default_security_rules(self):
        """
         Gets or sets Default security rules of network security group
        """
        return self._default_security_rules
    
    @default_security_rules.setter 
    def default_security_rules(self, value):
        self._default_security_rules = value
    
    @property
    def network_interfaces(self):
        """
         Gets collection of references to Network Interfaces
        """
        return self._network_interfaces
    
    @network_interfaces.setter 
    def network_interfaces(self, value):
        self._network_interfaces = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def security_rules(self):
        """
         Gets or sets Security rules of network security group
        """
        return self._security_rules
    
    @security_rules.setter 
    def security_rules(self, value):
        self._security_rules = value
    
    @property
    def subnets(self):
        """
         Gets collection of references to subnets
        """
        return self._subnets
    
    @subnets.setter 
    def subnets(self, value):
        self._subnets = value

class PublicIpAddressListResponse(AzureOperationResponse):
    """
     Response for ListPublicIpAddresses Api service call
    """
    
    def __init__(self, **kwargs):
        super(PublicIpAddressListResponse, self).__init__(**kwargs)
        self._public_ip_addresses = kwargs.get('public_ip_addresses')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def public_ip_addresses(self):
        """
         Gets List of publicIP addresses that exists in a resource group
        """
        return self._public_ip_addresses
    
    @public_ip_addresses.setter 
    def public_ip_addresses(self, value):
        self._public_ip_addresses = value

class PublicIpAddressGetResponse(AzureOperationResponse):
    """
     Response for GetPublicIpAddress Api servive call
    """
    
    def __init__(self, **kwargs):
        super(PublicIpAddressGetResponse, self).__init__(**kwargs)
        self._public_ip_address = kwargs.get('public_ip_address')
    
    @property
    def public_ip_address(self):
        """
         Gets publicIP address that exists in a resource group
        """
        return self._public_ip_address
    
    @public_ip_address.setter 
    def public_ip_address(self, value):
        self._public_ip_address = value

class PublicIpAddressPutResponse(UpdateOperationResponse):
    """
     Response for PutPublicIpAddress Api servive call
    """
    
    def __init__(self, **kwargs):
        super(PublicIpAddressPutResponse, self).__init__(**kwargs)
        self._public_ip_address = kwargs.get('public_ip_address')
    
    @property
    def public_ip_address(self):
        """
         Gets a publicIP address that exists in a resource group
        """
        return self._public_ip_address
    
    @public_ip_address.setter 
    def public_ip_address(self, value):
        self._public_ip_address = value

class PublicIpAddress(TopLevelResource):
    """
     PublicIPAddress resource
    """
    
    def __init__(self, **kwargs):
        super(PublicIpAddress, self).__init__(**kwargs)
        self._public_ip_allocation_method = kwargs.get('public_ip_allocation_method')
        self._ip_configuration = kwargs.get('ip_configuration')
        self._dns_settings = kwargs.get('dns_settings')
        self._ip_address = kwargs.get('ip_address')
        self._idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def dns_settings(self):
        """
         Gets or sets FQDN of the DNS record associated with the public IP
         address
        """
        return self._dns_settings
    
    @dns_settings.setter 
    def dns_settings(self, value):
        self._dns_settings = value
    
    @property
    def idle_timeout_in_minutes(self):
        """
         Gets or sets the Idletimeout of the public IP address
        """
        return self._idle_timeout_in_minutes
    
    @idle_timeout_in_minutes.setter 
    def idle_timeout_in_minutes(self, value):
        self._idle_timeout_in_minutes = value
    
    @property
    def ip_address(self):
        """
         Gets the assigned public IP address
        """
        return self._ip_address
    
    @ip_address.setter 
    def ip_address(self, value):
        self._ip_address = value
    
    @property
    def ip_configuration(self):
        """
         Gets a reference to the network interface IP configurations using this
         public IP address
        """
        return self._ip_configuration
    
    @ip_configuration.setter 
    def ip_configuration(self, value):
        self._ip_configuration = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def public_ip_allocation_method(self):
        """
         Gets or sets PublicIP allocation method (Static/Dynamic)
        """
        return self._public_ip_allocation_method
    
    @public_ip_allocation_method.setter 
    def public_ip_allocation_method(self, value):
        self._public_ip_allocation_method = value

class SecurityRuleGetResponse(AzureOperationResponse):
    """
     Response for GetSecurityRule Api service call
    """
    
    def __init__(self, **kwargs):
        super(SecurityRuleGetResponse, self).__init__(**kwargs)
        self._security_rule = kwargs.get('security_rule')
    
    @property
    def security_rule(self):
        """
         Gets the security rule in a network security group
        """
        return self._security_rule
    
    @security_rule.setter 
    def security_rule(self, value):
        self._security_rule = value

class SecurityRuleListResponse(AzureOperationResponse):
    """
     Response for ListSecurityRule Api service callRetrieves all security rules
     that belongs to a network security group
    """
    
    def __init__(self, **kwargs):
        super(SecurityRuleListResponse, self).__init__(**kwargs)
        self._security_rules = kwargs.get('security_rules')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def security_rules(self):
        """
         Gets security rules in a network security group
        """
        return self._security_rules
    
    @security_rules.setter 
    def security_rules(self, value):
        self._security_rules = value

class SecurityRulePutResponse(UpdateOperationResponse):
    """
     Response for PUT SecurityRule Api service call
    """
    
    def __init__(self, **kwargs):
        super(SecurityRulePutResponse, self).__init__(**kwargs)
        self._security_rule = kwargs.get('security_rule')
    
    @property
    def security_rule(self):
        """
         Gets the security rule in a network security group
        """
        return self._security_rule
    
    @security_rule.setter 
    def security_rule(self, value):
        self._security_rule = value

class ResourceId(object):
    """
     Id of the resource
    """
    
    def __init__(self, **kwargs):
        self._id = kwargs.get('id')
    
    @property
    def id(self):
        """
         Id of the resource
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value

class ChildResource(ResourceId):
    """
     A common class for general resource information
    """
    
    def __init__(self, **kwargs):
        super(ChildResource, self).__init__(**kwargs)
        self._name = kwargs.get('name')
        self._etag = kwargs.get('etag')
    
    @property
    def etag(self):
        """
         A unique read-only string that changes whenever the resource is updated
        """
        return self._etag
    
    @etag.setter 
    def etag(self, value):
        self._etag = value
    
    @property
    def name(self):
        """
         Gets name of the resource that is unique within a resource group. This
         name can be used to access the resource
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value

class SecurityRule(ChildResource):
    """
     Network security rule
    """
    
    def __init__(self, **kwargs):
        super(SecurityRule, self).__init__(**kwargs)
        self._description = kwargs.get('description')
        self._protocol = kwargs.get('protocol')
        self._source_port_range = kwargs.get('source_port_range')
        self._destination_port_range = kwargs.get('destination_port_range')
        self._source_address_prefix = kwargs.get('source_address_prefix')
        self._destination_address_prefix = kwargs.get('destination_address_prefix')
        self._access = kwargs.get('access')
        self._priority = kwargs.get('priority')
        self._direction = kwargs.get('direction')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def access(self):
        """
         Gets or sets network traffic is allowed or denied. Possible values are
         “Allow” and “Deny”
        """
        return self._access
    
    @access.setter 
    def access(self, value):
        self._access = value
    
    @property
    def description(self):
        """
         Gets or sets a description for this rule. Restricted to 140 chars.
        """
        return self._description
    
    @description.setter 
    def description(self, value):
        self._description = value
    
    @property
    def destination_address_prefix(self):
        """
         Gets or sets destination address prefix. CIDR or source IP range.
         Asterix “*” can also be used to match all source IPs. Default tags
         such as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also
         be used.
        """
        return self._destination_address_prefix
    
    @destination_address_prefix.setter 
    def destination_address_prefix(self, value):
        self._destination_address_prefix = value
    
    @property
    def destination_port_range(self):
        """
         Gets or sets Destination Port or Range. Integer or range between 0 and
         65535. Asterix “*” can also be used to match all ports.
        """
        return self._destination_port_range
    
    @destination_port_range.setter 
    def destination_port_range(self, value):
        self._destination_port_range = value
    
    @property
    def direction(self):
        """
         Gets or sets the direction of the rule.InBound or Outbound. The
         direction specifies if rule will be evaluated on incoming or
         outcoming traffic.
        """
        return self._direction
    
    @direction.setter 
    def direction(self, value):
        self._direction = value
    
    @property
    def priority(self):
        """
         Gets or sets the priority of the rule. The value can be between 100
         and 4096. The priority number must be unique for each rule in the
         collection. The lower the priority number, the higher the priority of
         the rule.
        """
        return self._priority
    
    @priority.setter 
    def priority(self, value):
        self._priority = value
    
    @property
    def protocol(self):
        """
         Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or
         All(*).
        """
        return self._protocol
    
    @protocol.setter 
    def protocol(self, value):
        self._protocol = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def source_address_prefix(self):
        """
         Gets or sets source address prefix. CIDR or source IP range. Asterix
         “*” can also be used to match all source IPs. Default tags such as
         ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be
         used. If this is an ingress rule, specifies where network traffic
         originates from.
        """
        return self._source_address_prefix
    
    @source_address_prefix.setter 
    def source_address_prefix(self, value):
        self._source_address_prefix = value
    
    @property
    def source_port_range(self):
        """
         Gets or sets Source Port or Range. Integer or range between 0 and
         65535. Asterix “*” can also be used to match all ports.
        """
        return self._source_port_range
    
    @source_port_range.setter 
    def source_port_range(self, value):
        self._source_port_range = value

class SubnetListResponse(AzureOperationResponse):
    """
     Response for ListSubnets Api service callRetrieves all subnet that belongs
     to a virtual network
    """
    
    def __init__(self, **kwargs):
        super(SubnetListResponse, self).__init__(**kwargs)
        self._subnets = kwargs.get('subnets')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def subnets(self):
        """
         Gets the subnets in a virtual network
        """
        return self._subnets
    
    @subnets.setter 
    def subnets(self, value):
        self._subnets = value

class SubnetGetResponse(AzureOperationResponse):
    """
     Response for GetSubnet Api service call
    """
    
    def __init__(self, **kwargs):
        super(SubnetGetResponse, self).__init__(**kwargs)
        self._subnet = kwargs.get('subnet')
    
    @property
    def subnet(self):
        """
         Gets the subnet in a virtual network
        """
        return self._subnet
    
    @subnet.setter 
    def subnet(self, value):
        self._subnet = value

class SubnetPutResponse(UpdateOperationResponse):
    """
     Response for PutSubnet Api service call
    """
    
    def __init__(self, **kwargs):
        super(SubnetPutResponse, self).__init__(**kwargs)
        self._subnet = kwargs.get('subnet')
    
    @property
    def subnet(self):
        """
         Gets the subnet in a virtual network
        """
        return self._subnet
    
    @subnet.setter 
    def subnet(self, value):
        self._subnet = value

class Subnet(ChildResource):
    """
     Subnet in a VirtualNework resource
    """
    
    def __init__(self, **kwargs):
        super(Subnet, self).__init__(**kwargs)
        self._address_prefix = kwargs.get('address_prefix')
        self._network_security_group = kwargs.get('network_security_group')
        self._ip_configurations = kwargs.get('ip_configurations')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def address_prefix(self):
        """
         Gets or sets Address prefix for the subnet.
        """
        return self._address_prefix
    
    @address_prefix.setter 
    def address_prefix(self, value):
        self._address_prefix = value
    
    @property
    def ip_configurations(self):
        """
         Gets array of references to the network interface IP configurations
         using subnet
        """
        return self._ip_configurations
    
    @ip_configurations.setter 
    def ip_configurations(self, value):
        self._ip_configurations = value
    
    @property
    def network_security_group(self):
        """
         Gets or sets the reference of the NetworkSecurityGroup resource
        """
        return self._network_security_group
    
    @network_security_group.setter 
    def network_security_group(self, value):
        self._network_security_group = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class UsagesListResponse(AzureOperationResponse):
    """
     The List Usages operation response.
    """
    
    def __init__(self, **kwargs):
        super(UsagesListResponse, self).__init__(**kwargs)
        self._usages = kwargs.get('usages')
    
    @property
    def usages(self):
        """
         Gets or sets the list Network Resource Usages.
        """
        return self._usages
    
    @usages.setter 
    def usages(self, value):
        self._usages = value

class VirtualNetworkGatewayConnectionPutResponse(UpdateOperationResponse):
    """
     Response for CreateOrUpdateVirtualNetworkGatewayConnection Api servive call
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayConnectionPutResponse, self).__init__(**kwargs)
        self._virtual_network_gateway_connection = kwargs.get('virtual_network_gateway_connection')
    
    @property
    def virtual_network_gateway_connection(self):
        """
         Gets the virtual network gateway connection that exists in a resource
         group
        """
        return self._virtual_network_gateway_connection
    
    @virtual_network_gateway_connection.setter 
    def virtual_network_gateway_connection(self, value):
        self._virtual_network_gateway_connection = value

class VirtualNetworkGatewayConnection(TopLevelResource):
    """
     A common class for general resource information
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayConnection, self).__init__(**kwargs)
        self._virtual_network_gateway1 = kwargs.get('virtual_network_gateway1')
        self._virtual_network_gateway2 = kwargs.get('virtual_network_gateway2')
        self._local_network_gateway2 = kwargs.get('local_network_gateway2')
        self._connection_type = kwargs.get('connection_type')
        self._routing_weight = kwargs.get('routing_weight')
        self._shared_key = kwargs.get('shared_key')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def connection_type(self):
        """
         Gateway connection type -Ipsec/Dedicated/VpnClient/Vnet2Vnet
        """
        return self._connection_type
    
    @connection_type.setter 
    def connection_type(self, value):
        self._connection_type = value
    
    @property
    def local_network_gateway2(self):
        return self._local_network_gateway2
    
    @local_network_gateway2.setter 
    def local_network_gateway2(self, value):
        self._local_network_gateway2 = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the VirtualNetworkGatewayConnection
         resource Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def routing_weight(self):
        """
         The Routing weight.
        """
        return self._routing_weight
    
    @routing_weight.setter 
    def routing_weight(self, value):
        self._routing_weight = value
    
    @property
    def shared_key(self):
        """
         The Ipsec share key.
        """
        return self._shared_key
    
    @shared_key.setter 
    def shared_key(self, value):
        self._shared_key = value
    
    @property
    def virtual_network_gateway1(self):
        return self._virtual_network_gateway1
    
    @virtual_network_gateway1.setter 
    def virtual_network_gateway1(self, value):
        self._virtual_network_gateway1 = value
    
    @property
    def virtual_network_gateway2(self):
        return self._virtual_network_gateway2
    
    @virtual_network_gateway2.setter 
    def virtual_network_gateway2(self, value):
        self._virtual_network_gateway2 = value

class VirtualNetworkGatewayConnectionGetResponse(AzureOperationResponse):
    """
     Response for GetVitualNetworkGatewayConnection Api servive call.
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayConnectionGetResponse, self).__init__(**kwargs)
        self._virtual_network_gateway_connection = kwargs.get('virtual_network_gateway_connection')
    
    @property
    def virtual_network_gateway_connection(self):
        """
         Gets virtual network gateway connection details that exists in a
         resource group
        """
        return self._virtual_network_gateway_connection
    
    @virtual_network_gateway_connection.setter 
    def virtual_network_gateway_connection(self, value):
        self._virtual_network_gateway_connection = value

class ConnectionSharedKeyResponse(AzureOperationResponse):
    """
     Response for CheckConnectionSharedKey Api servive call
    """
    
    def __init__(self, **kwargs):
        super(ConnectionSharedKeyResponse, self).__init__(**kwargs)
        self._value = kwargs.get('value')
    
    @property
    def value(self):
        """
         The virtual network connection shared key value
        """
        return self._value
    
    @value.setter 
    def value(self, value):
        self._value = value

class VirtualNetworkGatewayConnectionListResponse(AzureOperationResponse):
    """
     Response for ListVirtualNetworkGatewayConnections Api service call
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayConnectionListResponse, self).__init__(**kwargs)
        self._virtual_network_gateway_connections = kwargs.get('virtual_network_gateway_connections')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def virtual_network_gateway_connections(self):
        """
         Gets List of VirtualNetworkGatewayConnections that exists in a
         resource group
        """
        return self._virtual_network_gateway_connections
    
    @virtual_network_gateway_connections.setter 
    def virtual_network_gateway_connections(self, value):
        self._virtual_network_gateway_connections = value

class ConnectionResetSharedKeyPutResponse(UpdateOperationResponse):
    """
     Response for PutVirtualNetworkGatewayConnectionResetSharedKey Api servive
     call
    """
    
    def __init__(self, **kwargs):
        super(ConnectionResetSharedKeyPutResponse, self).__init__(**kwargs)
        self._connection_reset_shared_key = kwargs.get('connection_reset_shared_key')
    
    @property
    def connection_reset_shared_key(self):
        """
         Puts the virtual network gateway connection reset shared key that
         exists in a resource group
        """
        return self._connection_reset_shared_key
    
    @connection_reset_shared_key.setter 
    def connection_reset_shared_key(self, value):
        self._connection_reset_shared_key = value

class ConnectionResetSharedKey(object):
    
    def __init__(self, **kwargs):
        self._key_length = kwargs.get('key_length')
    
    @property
    def key_length(self):
        """
         The virtual network connection reset shared key length
        """
        return self._key_length
    
    @key_length.setter 
    def key_length(self, value):
        self._key_length = value

class ConnectionSharedKeyPutResponse(UpdateOperationResponse):
    """
     Response for PutVirtualNetworkGatewayConnectionSharedKey Api servive call
    """
    
    def __init__(self, **kwargs):
        super(ConnectionSharedKeyPutResponse, self).__init__(**kwargs)
        self._connection_shared_key = kwargs.get('connection_shared_key')
    
    @property
    def connection_shared_key(self):
        """
         Puts the virtual network gateway connection shared key that exists in
         a resource group
        """
        return self._connection_shared_key
    
    @connection_shared_key.setter 
    def connection_shared_key(self, value):
        self._connection_shared_key = value

class ConnectionSharedKey(object):
    """
     Response for GetConnectionSharedKey Api servive call
    """
    
    def __init__(self, **kwargs):
        self._value = kwargs.get('value')
    
    @property
    def value(self):
        """
         The virtual network connection shared key value
        """
        return self._value
    
    @value.setter 
    def value(self, value):
        self._value = value

class VirtualNetworkGatewayPutResponse(UpdateOperationResponse):
    """
     Response for PutVirtualNetworkGateway Api servive call
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayPutResponse, self).__init__(**kwargs)
        self._virtual_network_gateway = kwargs.get('virtual_network_gateway')
    
    @property
    def virtual_network_gateway(self):
        """
         Puts the virtual network gateway that exists in a resource group
        """
        return self._virtual_network_gateway
    
    @virtual_network_gateway.setter 
    def virtual_network_gateway(self, value):
        self._virtual_network_gateway = value

class VirtualNetworkGateway(TopLevelResource):
    """
     A common class for general resource information
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGateway, self).__init__(**kwargs)
        self._ip_configurations = kwargs.get('ip_configurations')
        self._gateway_size = kwargs.get('gateway_size')
        self._gateway_type = kwargs.get('gateway_type')
        self._enable_bgp = kwargs.get('enable_bgp')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def enable_bgp(self):
        """
         EnableBgp Flag
        """
        return self._enable_bgp
    
    @enable_bgp.setter 
    def enable_bgp(self, value):
        self._enable_bgp = value
    
    @property
    def gateway_size(self):
        """
         The size of this virtual network gateway.
        """
        return self._gateway_size
    
    @gateway_size.setter 
    def gateway_size(self, value):
        self._gateway_size = value
    
    @property
    def gateway_type(self):
        """
         The type of this virtual network gateway.
        """
        return self._gateway_type
    
    @gateway_type.setter 
    def gateway_type(self, value):
        self._gateway_type = value
    
    @property
    def ip_configurations(self):
        """
         IpConfigurations for Virtual network gateway.
        """
        return self._ip_configurations
    
    @ip_configurations.setter 
    def ip_configurations(self, value):
        self._ip_configurations = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the VirtualNetworkGateway resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class VirtualNetworkGatewayGetResponse(AzureOperationResponse):
    """
     Response for GetVitualNetworkgateway Api servive call.
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayGetResponse, self).__init__(**kwargs)
        self._virtual_network_gateway = kwargs.get('virtual_network_gateway')
    
    @property
    def virtual_network_gateway(self):
        """
         Gets virtual network gateway details that exists in a resource group
        """
        return self._virtual_network_gateway
    
    @virtual_network_gateway.setter 
    def virtual_network_gateway(self, value):
        self._virtual_network_gateway = value

class VirtualNetworkGatewayListResponse(AzureOperationResponse):
    """
     Response for ListVirtualNetworkGateways Api service call
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayListResponse, self).__init__(**kwargs)
        self._virtual_network_gateways = kwargs.get('virtual_network_gateways')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def virtual_network_gateways(self):
        """
         Gets List of VirtualNetworkGateways that exists in a resource group
        """
        return self._virtual_network_gateways
    
    @virtual_network_gateways.setter 
    def virtual_network_gateways(self, value):
        self._virtual_network_gateways = value

class VirtualNetworkListResponse(AzureOperationResponse):
    """
     Response for ListVirtualNetworks Api servive call
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkListResponse, self).__init__(**kwargs)
        self._virtual_networks = kwargs.get('virtual_networks')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def virtual_networks(self):
        """
         Gets list of VirtualNetworks in a resource group
        """
        return self._virtual_networks
    
    @virtual_networks.setter 
    def virtual_networks(self, value):
        self._virtual_networks = value

class VirtualNetworkGetResponse(AzureOperationResponse):
    """
     Response for GetVirtualNetworks API service calls.
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGetResponse, self).__init__(**kwargs)
        self._virtual_network = kwargs.get('virtual_network')
    
    @property
    def virtual_network(self):
        """
         Gets a VirtualNetwork in a resource group
        """
        return self._virtual_network
    
    @virtual_network.setter 
    def virtual_network(self, value):
        self._virtual_network = value

class VirtualNetworkPutResponse(UpdateOperationResponse):
    """
     Response for PutVirtualNetworks API service calls.
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkPutResponse, self).__init__(**kwargs)
        self._virtual_network = kwargs.get('virtual_network')
    
    @property
    def virtual_network(self):
        """
         Gets a  VirtualNetwork in a resource group
        """
        return self._virtual_network
    
    @virtual_network.setter 
    def virtual_network(self, value):
        self._virtual_network = value

class VirtualNetwork(TopLevelResource):
    """
     Virtual Network resource
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetwork, self).__init__(**kwargs)
        self._address_space = kwargs.get('address_space')
        self._dhcp_options = kwargs.get('dhcp_options')
        self._subnets = kwargs.get('subnets')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def address_space(self):
        """
         Gets or sets AddressSpace that contains an array of IP address ranges
         that can be used by subnets
        """
        return self._address_space
    
    @address_space.setter 
    def address_space(self, value):
        self._address_space = value
    
    @property
    def dhcp_options(self):
        """
         Gets or sets DHCPOptions that contains an array of DNS servers
         available to VMs deployed in the virtual network
        """
        return self._dhcp_options
    
    @dhcp_options.setter 
    def dhcp_options(self, value):
        self._dhcp_options = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def subnets(self):
        """
         Gets or sets List of subnets in a VirtualNetwork
        """
        return self._subnets
    
    @subnets.setter 
    def subnets(self, value):
        self._subnets = value

class ResourceProperties(object):
    
    def __init__(self, **kwargs):
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class ProvisioningState(object):
    """
     Provisioning state of the resource
    """
    updating = 'Updating'
    deleting = 'Deleting'
    failed = 'Failed'
    succeeded = 'Succeeded'

class IpAllocationMethod(object):
    """
     IP address allocation method
    """
    static = 'Static'
    dynamic = 'Dynamic'

class FrontendIpConfiguration(ChildResource):
    """
     Frontend IP address of the load balancer
    """
    
    def __init__(self, **kwargs):
        super(FrontendIpConfiguration, self).__init__(**kwargs)
        self._private_ip_address = kwargs.get('private_ip_address')
        self._private_ip_allocation_method = kwargs.get('private_ip_allocation_method')
        self._subnet = kwargs.get('subnet')
        self._public_ip_address = kwargs.get('public_ip_address')
        self._inbound_nat_rules = kwargs.get('inbound_nat_rules')
        self._load_balancing_rules = kwargs.get('load_balancing_rules')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def inbound_nat_rules(self):
        """
         Read only.Inbound rules URIs that use this frontend IP
        """
        return self._inbound_nat_rules
    
    @inbound_nat_rules.setter 
    def inbound_nat_rules(self, value):
        self._inbound_nat_rules = value
    
    @property
    def load_balancing_rules(self):
        """
         Gets Load Balancing rules URIs that use this frontend IP
        """
        return self._load_balancing_rules
    
    @load_balancing_rules.setter 
    def load_balancing_rules(self, value):
        self._load_balancing_rules = value
    
    @property
    def private_ip_address(self):
        """
         Gets or sets the IP address of the Load Balancer.This is only
         specified if a specific private IP address shall be allocated from
         the subnet specified in subnetRef
        """
        return self._private_ip_address
    
    @private_ip_address.setter 
    def private_ip_address(self, value):
        self._private_ip_address = value
    
    @property
    def private_ip_allocation_method(self):
        """
         Gets or sets PrivateIP allocation method (Static/Dynamic)
        """
        return self._private_ip_allocation_method
    
    @private_ip_allocation_method.setter 
    def private_ip_allocation_method(self, value):
        self._private_ip_allocation_method = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def public_ip_address(self):
        """
         Gets or sets the reference of the PublicIP resource
        """
        return self._public_ip_address
    
    @public_ip_address.setter 
    def public_ip_address(self, value):
        self._public_ip_address = value
    
    @property
    def subnet(self):
        """
         Gets or sets the reference of the subnet resource.A subnet from wher
         the load balancer gets its private frontend address
        """
        return self._subnet
    
    @subnet.setter 
    def subnet(self, value):
        self._subnet = value

class TransportProtocol(object):
    """
     Provisioning state of the resource
    """
    udp = 'Udp'
    tcp = 'Tcp'

class LoadDistribution(object):
    """
     The load distribution policy
    """
    default = 'Default'
    source_ip = 'SourceIP'
    source_ip_protocol = 'SourceIPProtocol'

class NetworkInterfaceIpConfiguration(ChildResource):
    """
     IPConfiguration in a NetworkInterface
    """
    
    def __init__(self, **kwargs):
        super(NetworkInterfaceIpConfiguration, self).__init__(**kwargs)
        self._private_ip_address = kwargs.get('private_ip_address')
        self._private_ip_allocation_method = kwargs.get('private_ip_allocation_method')
        self._subnet = kwargs.get('subnet')
        self._public_ip_address = kwargs.get('public_ip_address')
        self._load_balancer_backend_address_pools = kwargs.get('load_balancer_backend_address_pools')
        self._load_balancer_inbound_nat_rules = kwargs.get('load_balancer_inbound_nat_rules')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def load_balancer_backend_address_pools(self):
        """
         Gets or sets the reference of LoadBalancerBackendAddressPool resource
        """
        return self._load_balancer_backend_address_pools
    
    @load_balancer_backend_address_pools.setter 
    def load_balancer_backend_address_pools(self, value):
        self._load_balancer_backend_address_pools = value
    
    @property
    def load_balancer_inbound_nat_rules(self):
        """
         Gets or sets list of references of LoadBalancerInboundNatRules
        """
        return self._load_balancer_inbound_nat_rules
    
    @load_balancer_inbound_nat_rules.setter 
    def load_balancer_inbound_nat_rules(self, value):
        self._load_balancer_inbound_nat_rules = value
    
    @property
    def private_ip_address(self):
        """
         Gets or sets the privateIPAddress of the Network Interface IP
         Configuration
        """
        return self._private_ip_address
    
    @private_ip_address.setter 
    def private_ip_address(self, value):
        self._private_ip_address = value
    
    @property
    def private_ip_allocation_method(self):
        """
         Gets or sets PrivateIP allocation method (Static/Dynamic)
        """
        return self._private_ip_allocation_method
    
    @private_ip_allocation_method.setter 
    def private_ip_allocation_method(self, value):
        self._private_ip_allocation_method = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def public_ip_address(self):
        """
         Gets or sets the reference of the PublicIP resource
        """
        return self._public_ip_address
    
    @public_ip_address.setter 
    def public_ip_address(self, value):
        self._public_ip_address = value
    
    @property
    def subnet(self):
        """
         Gets or sets the reference of the subnet resource
        """
        return self._subnet
    
    @subnet.setter 
    def subnet(self, value):
        self._subnet = value

class LoadBalancingRule(ChildResource):
    """
     Rules of the load balancer
    """
    
    def __init__(self, **kwargs):
        super(LoadBalancingRule, self).__init__(**kwargs)
        self._frontend_ip_configuration = kwargs.get('frontend_ip_configuration')
        self._backend_address_pool = kwargs.get('backend_address_pool')
        self._probe = kwargs.get('probe')
        self._protocol = kwargs.get('protocol')
        self._load_distribution = kwargs.get('load_distribution')
        self._frontend_port = kwargs.get('frontend_port')
        self._backend_port = kwargs.get('backend_port')
        self._idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes')
        self._enable_floating_ip = kwargs.get('enable_floating_ip')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def backend_address_pool(self):
        """
         Gets or sets  a reference to a pool of DIPs. Inbound traffic is
         randomly load balanced across IPs in the backend IPs
        """
        return self._backend_address_pool
    
    @backend_address_pool.setter 
    def backend_address_pool(self, value):
        self._backend_address_pool = value
    
    @property
    def backend_port(self):
        """
         Gets or sets a port used for internal connections on the endpoint. The
         localPort attribute maps the eternal port of the endpoint to an
         internal port on a role. This is useful in scenarios where a role
         must communicate to an internal compotnent on a port that is
         different from the one that is exposed externally. If not specified,
         the value of localPort is the same as the port attribute. Set the
         value of localPort to '*' to automatically assign an unallocated port
         that is discoverable using the runtime API
        """
        return self._backend_port
    
    @backend_port.setter 
    def backend_port(self, value):
        self._backend_port = value
    
    @property
    def enable_floating_ip(self):
        """
         Configures a virtual machine's endpoint for the floating IP capability
         required to configure a SQL AlwaysOn availability Group. This setting
         is required when using the SQL Always ON availability Groups in SQL
         server. This setting can't be changed after you create the endpoint
        """
        return self._enable_floating_ip
    
    @enable_floating_ip.setter 
    def enable_floating_ip(self, value):
        self._enable_floating_ip = value
    
    @property
    def frontend_ip_configuration(self):
        """
         Gets or sets a reference to frontend IP Addresses
        """
        return self._frontend_ip_configuration
    
    @frontend_ip_configuration.setter 
    def frontend_ip_configuration(self, value):
        self._frontend_ip_configuration = value
    
    @property
    def frontend_port(self):
        """
         Gets or sets the port for the external endpoint. You can specify any
         port number you choose, but the port numbers specified for each role
         in the service must be unique. Possible values range between 1 and
         65535, inclusive
        """
        return self._frontend_port
    
    @frontend_port.setter 
    def frontend_port(self, value):
        self._frontend_port = value
    
    @property
    def idle_timeout_in_minutes(self):
        """
         Gets or sets the timeout for the Tcp idle connection. The value can be
         set between 4 and 30 minutes. The default value is 4 minutes. This
         emlement is only used when the protocol is set to Tcp
        """
        return self._idle_timeout_in_minutes
    
    @idle_timeout_in_minutes.setter 
    def idle_timeout_in_minutes(self, value):
        self._idle_timeout_in_minutes = value
    
    @property
    def load_distribution(self):
        """
         Gets or sets the load distribution policy for this rule
        """
        return self._load_distribution
    
    @load_distribution.setter 
    def load_distribution(self, value):
        self._load_distribution = value
    
    @property
    def probe(self):
        """
         Gets or sets the reference of the load balancer probe used by the Load
         Balancing rule.
        """
        return self._probe
    
    @probe.setter 
    def probe(self, value):
        self._probe = value
    
    @property
    def protocol(self):
        """
         Gets or sets the transport protocol for the external endpoint.
         Possible values are Udp or Tcp
        """
        return self._protocol
    
    @protocol.setter 
    def protocol(self, value):
        self._protocol = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class BackendAddressPool(ChildResource):
    """
     Pool of backend IP addresseses
    """
    
    def __init__(self, **kwargs):
        super(BackendAddressPool, self).__init__(**kwargs)
        self._backend_ip_configurations = kwargs.get('backend_ip_configurations')
        self._load_balancing_rules = kwargs.get('load_balancing_rules')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def backend_ip_configurations(self):
        """
         Gets collection of references to IPs defined in NICs
        """
        return self._backend_ip_configurations
    
    @backend_ip_configurations.setter 
    def backend_ip_configurations(self, value):
        self._backend_ip_configurations = value
    
    @property
    def load_balancing_rules(self):
        """
         Gets Load Balancing rules that use this Backend Address Pool
        """
        return self._load_balancing_rules
    
    @load_balancing_rules.setter 
    def load_balancing_rules(self, value):
        self._load_balancing_rules = value
    
    @property
    def provisioning_state(self):
        """
         Provisioning state of the PublicIP resource Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class ProbeProtocol(object):
    """
     Protocol for load balancer probe
    """
    http = 'Http'
    tcp = 'Tcp'

class Probe(ChildResource):
    """
     Load balancer Probe
    """
    
    def __init__(self, **kwargs):
        super(Probe, self).__init__(**kwargs)
        self._load_balancing_rules = kwargs.get('load_balancing_rules')
        self._protocol = kwargs.get('protocol')
        self._port = kwargs.get('port')
        self._interval_in_seconds = kwargs.get('interval_in_seconds')
        self._number_of_probes = kwargs.get('number_of_probes')
        self._request_path = kwargs.get('request_path')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def interval_in_seconds(self):
        """
         Gets or sets the interval, in seconds, for how frequently to probe the
         endpoint for health status. Typically, the interval is slightly less
         than half the allocated timeout period (in seconds) which allows two
         full probes before taking the instance out of rotation. The default
         value is 15, the minimum value is 5
        """
        return self._interval_in_seconds
    
    @interval_in_seconds.setter 
    def interval_in_seconds(self, value):
        self._interval_in_seconds = value
    
    @property
    def load_balancing_rules(self):
        """
         Gets Load balancer rules that use this probe
        """
        return self._load_balancing_rules
    
    @load_balancing_rules.setter 
    def load_balancing_rules(self, value):
        self._load_balancing_rules = value
    
    @property
    def number_of_probes(self):
        """
         Gets or sets the number of probes where if no response, will result in
         stopping further traffic from being delivered to the endpoint. This
         values allows endponints to be taken out of rotation faster or slower
         than the typical times used in Azure.
        """
        return self._number_of_probes
    
    @number_of_probes.setter 
    def number_of_probes(self, value):
        self._number_of_probes = value
    
    @property
    def port(self):
        """
         Gets or sets Port for communicating the probe. Possible values range
         from 1 to 65535, inclusive.
        """
        return self._port
    
    @port.setter 
    def port(self, value):
        self._port = value
    
    @property
    def protocol(self):
        """
         Gets or sets the protocol of the end point. Possible values are http
         pr Tcp. If Tcp is specified, a received ACK is required for the probe
         to be successful. If http is specified,a 200 OK response from the
         specifies URI is required for the probe to be successful
        """
        return self._protocol
    
    @protocol.setter 
    def protocol(self, value):
        self._protocol = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def request_path(self):
        """
         Gets or sets the URI used for requesting health status from the VM.
         Path is required if a protocol is set to http. Otherwise, it is not
         allowed. There is no default value
        """
        return self._request_path
    
    @request_path.setter 
    def request_path(self, value):
        self._request_path = value

class InboundNatRule(ChildResource):
    """
     Inbound NAT rule of the loadbalancer
    """
    
    def __init__(self, **kwargs):
        super(InboundNatRule, self).__init__(**kwargs)
        self._frontend_ip_configuration = kwargs.get('frontend_ip_configuration')
        self._backend_ip_configuration = kwargs.get('backend_ip_configuration')
        self._protocol = kwargs.get('protocol')
        self._frontend_port = kwargs.get('frontend_port')
        self._backend_port = kwargs.get('backend_port')
        self._idle_timeout_in_minutes = kwargs.get('idle_timeout_in_minutes')
        self._enable_floating_ip = kwargs.get('enable_floating_ip')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def backend_ip_configuration(self):
        """
         Gets or sets a reference to a private ip address defined on a
         NetworkInterface of a VM. Traffic sent to frontendPort of each of the
         frontendIPConfigurations is forwarded to the backed IP
        """
        return self._backend_ip_configuration
    
    @backend_ip_configuration.setter 
    def backend_ip_configuration(self, value):
        self._backend_ip_configuration = value
    
    @property
    def backend_port(self):
        """
         Gets or sets a port used for internal connections on the endpoint. The
         localPort attribute maps the eternal port of the endpoint to an
         internal port on a role. This is useful in scenarios where a role
         must communicate to an internal compotnent on a port that is
         different from the one that is exposed externally. If not specified,
         the value of localPort is the same as the port attribute. Set the
         value of localPort to '*' to automatically assign an unallocated port
         that is discoverable using the runtime API
        """
        return self._backend_port
    
    @backend_port.setter 
    def backend_port(self, value):
        self._backend_port = value
    
    @property
    def enable_floating_ip(self):
        """
         Configures a virtual machine's endpoint for the floating IP capability
         required to configure a SQL AlwaysOn availability Group. This setting
         is required when using the SQL Always ON availability Groups in SQL
         server. This setting can't be changed after you create the endpoint
        """
        return self._enable_floating_ip
    
    @enable_floating_ip.setter 
    def enable_floating_ip(self, value):
        self._enable_floating_ip = value
    
    @property
    def frontend_ip_configuration(self):
        """
         Gets or sets a reference to frontend IP Addresses
        """
        return self._frontend_ip_configuration
    
    @frontend_ip_configuration.setter 
    def frontend_ip_configuration(self, value):
        self._frontend_ip_configuration = value
    
    @property
    def frontend_port(self):
        """
         Gets or sets the port for the external endpoint. You can spcify any
         port number you choose, but the port numbers specified for each role
         in the service must be unique. Possible values range between 1 and
         65535, inclusive
        """
        return self._frontend_port
    
    @frontend_port.setter 
    def frontend_port(self, value):
        self._frontend_port = value
    
    @property
    def idle_timeout_in_minutes(self):
        """
         Gets or sets the timeout for the Tcp idle connection. The value can be
         set between 4 and 30 minutes. The default value is 4 minutes. This
         emlement is only used when the protocol is set to Tcp
        """
        return self._idle_timeout_in_minutes
    
    @idle_timeout_in_minutes.setter 
    def idle_timeout_in_minutes(self, value):
        self._idle_timeout_in_minutes = value
    
    @property
    def protocol(self):
        """
         Gets or sets the transport potocol for the external endpoint. Possible
         values are Udp or Tcp
        """
        return self._protocol
    
    @protocol.setter 
    def protocol(self, value):
        self._protocol = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class VirtualNetworkGatewayIpConfiguration(ChildResource):
    """
     IpConfiguration for Virtual network gateway
    """
    
    def __init__(self, **kwargs):
        super(VirtualNetworkGatewayIpConfiguration, self).__init__(**kwargs)
        self._private_ip_address = kwargs.get('private_ip_address')
        self._private_ip_allocation_method = kwargs.get('private_ip_allocation_method')
        self._subnet = kwargs.get('subnet')
        self._public_ip_address = kwargs.get('public_ip_address')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def private_ip_address(self):
        """
         Gets or sets the privateIPAddress of the Network Interface IP
         Configuration
        """
        return self._private_ip_address
    
    @private_ip_address.setter 
    def private_ip_address(self, value):
        self._private_ip_address = value
    
    @property
    def private_ip_allocation_method(self):
        """
         Gets or sets PrivateIP allocation method (Static/Dynamic)
        """
        return self._private_ip_allocation_method
    
    @private_ip_allocation_method.setter 
    def private_ip_allocation_method(self, value):
        self._private_ip_allocation_method = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets Provisioning state of the PublicIP resource
         Updating/Deleting/Failed
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def public_ip_address(self):
        """
         Gets or sets the reference of the PublicIP resource
        """
        return self._public_ip_address
    
    @public_ip_address.setter 
    def public_ip_address(self, value):
        self._public_ip_address = value
    
    @property
    def subnet(self):
        """
         Gets or sets the reference of the subnet resource
        """
        return self._subnet
    
    @subnet.setter 
    def subnet(self, value):
        self._subnet = value

class SecurityRuleProtocol(object):
    """
     Protocol for network security rule
    """
    tcp = 'Tcp'
    udp = 'Udp'
    all = '*'

class SecurityRuleAccess(object):
    """
     Access for network security rule
    """
    allow = 'Allow'
    deny = 'Deny'

class SecurityRuleDirection(object):
    """
     Dircetion of network security rule
    """
    inbound = 'Inbound'
    outbound = 'Outbound'

class VirtualNetworkGatewayConnectionType(object):
    """
     The different connection types that a virtual network gateway can have.
    """
    ipsec = 'IPsec'
    vnet2_vnet = 'Vnet2Vnet'
    dedicated = 'Dedicated'
    vpn_client = 'VPNClient'

class VirtualNetworkGatewaySize(object):
    """
     The different SKUs that a gateway can have.
    """
    default = 'Default'
    high_performance = 'HighPerformance'

class VpnGatewayType(object):
    static_routing = 'StaticRouting'
    dynamic_routing = 'DynamicRouting'

class Error(object):
    
    def __init__(self, **kwargs):
        self._code = kwargs.get('code')
        self._message = kwargs.get('message')
        self._target = kwargs.get('target')
        self._details = kwargs.get('details')
        self._inner_error = kwargs.get('inner_error')
    
    @property
    def code(self):
        return self._code
    
    @code.setter 
    def code(self, value):
        self._code = value
    
    @property
    def details(self):
        return self._details
    
    @details.setter 
    def details(self, value):
        self._details = value
    
    @property
    def inner_error(self):
        return self._inner_error
    
    @inner_error.setter 
    def inner_error(self, value):
        self._inner_error = value
    
    @property
    def message(self):
        return self._message
    
    @message.setter 
    def message(self, value):
        self._message = value
    
    @property
    def target(self):
        return self._target
    
    @target.setter 
    def target(self, value):
        self._target = value

class ErrorDetails(object):
    
    def __init__(self, **kwargs):
        self._code = kwargs.get('code')
        self._target = kwargs.get('target')
        self._message = kwargs.get('message')
    
    @property
    def code(self):
        return self._code
    
    @code.setter 
    def code(self, value):
        self._code = value
    
    @property
    def message(self):
        return self._message
    
    @message.setter 
    def message(self, value):
        self._message = value
    
    @property
    def target(self):
        return self._target
    
    @target.setter 
    def target(self, value):
        self._target = value

class OperationStatus(object):
    """
     The status of the asynchronous request.
    """
    in_progress = 'InProgress'
    succeeded = 'Succeeded'
    failed = 'Failed'

class AddressSpace(object):
    """
     AddressSpace contains an array of IP address ranges that can be used by
     subnets
    """
    
    def __init__(self, **kwargs):
        self._address_prefixes = kwargs.get('address_prefixes')
    
    @property
    def address_prefixes(self):
        """
         Gets or sets List of address blocks reserved for this virtual network
         in CIDR notation
        """
        return self._address_prefixes
    
    @address_prefixes.setter 
    def address_prefixes(self, value):
        self._address_prefixes = value

class DnsSettings(object):
    """
     Dns Settings of a resource
    """
    
    def __init__(self, **kwargs):
        self._dns_servers = kwargs.get('dns_servers')
        self._applied_dns_servers = kwargs.get('applied_dns_servers')
    
    @property
    def applied_dns_servers(self):
        """
         Gets or sets list of Applied DNS servers IP addresses
        """
        return self._applied_dns_servers
    
    @applied_dns_servers.setter 
    def applied_dns_servers(self, value):
        self._applied_dns_servers = value
    
    @property
    def dns_servers(self):
        """
         Gets or sets list of DNS servers IP addresses
        """
        return self._dns_servers
    
    @dns_servers.setter 
    def dns_servers(self, value):
        self._dns_servers = value

class PublicIpAddressDnsSettings(object):
    """
     Contains FQDN of the DNS record associated with the public IP address
    """
    
    def __init__(self, **kwargs):
        self._domain_name_label = kwargs.get('domain_name_label')
        self._fqdn = kwargs.get('fqdn')
        self._reverse_fqdn = kwargs.get('reverse_fqdn')
    
    @property
    def domain_name_label(self):
        """
         Gets or sets the Domain name label.The concatenation of the domain
         name label and the regionalized DNS zone make up the fully qualified
         domain name associated with the public IP address. If a domain name
         label is specified, an A DNS record is created for the public IP in
         the Microsoft Azure DNS system.
        """
        return self._domain_name_label
    
    @domain_name_label.setter 
    def domain_name_label(self, value):
        self._domain_name_label = value
    
    @property
    def fqdn(self):
        """
         Gets the FQDN, Fully qualified domain name of the A DNS record
         associated with the public IP. This is the concatenation of the
         domainNameLabel and the regionalized DNS zone.
        """
        return self._fqdn
    
    @fqdn.setter 
    def fqdn(self, value):
        self._fqdn = value
    
    @property
    def reverse_fqdn(self):
        """
         Gets or Sests the Reverse FQDN. A user-visible, fully qualified domain
         name that resolves to this public IP address. If the reverseFqdn is
         specified, then a PTR DNS record is created pointing from the IP
         address in the in-addr.arpa domain to the reverse FQDN.
        """
        return self._reverse_fqdn
    
    @reverse_fqdn.setter 
    def reverse_fqdn(self, value):
        self._reverse_fqdn = value

class Usage(object):
    """
     Describes Network Resource Usage.
    """
    
    def __init__(self, **kwargs):
        self._unit = kwargs.get('unit')
        self._current_value = kwargs.get('current_value')
        self._limit = kwargs.get('limit')
        self._name = kwargs.get('name')
    
    @property
    def current_value(self):
        """
         Gets or sets the current value of the usage.
        """
        return self._current_value
    
    @current_value.setter 
    def current_value(self, value):
        self._current_value = value
    
    @property
    def limit(self):
        """
         Gets or sets the limit of usage.
        """
        return self._limit
    
    @limit.setter 
    def limit(self, value):
        self._limit = value
    
    @property
    def name(self):
        """
         Gets or sets the name of the type of usage.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def unit(self):
        """
         Gets or sets an enum describing the unit of measurement.
        """
        return self._unit
    
    @unit.setter 
    def unit(self, value):
        self._unit = value

class UsageUnit(object):
    """
     The usage unit.
    """
    count = 'Count'

class UsageName(object):
    """
     The Usage Names.
    """
    
    def __init__(self, **kwargs):
        self._value = kwargs.get('value')
        self._localized_value = kwargs.get('localized_value')
    
    @property
    def localized_value(self):
        """
         Gets or sets a localized string describing the resource name.
        """
        return self._localized_value
    
    @localized_value.setter 
    def localized_value(self, value):
        self._localized_value = value
    
    @property
    def value(self):
        """
         Gets or sets a string describing the resource name.
        """
        return self._value
    
    @value.setter 
    def value(self, value):
        self._value = value

class DhcpOptions(object):
    """
     DHCPOptions contains an array of DNS servers available to VMs deployed in
     the virtual networkStandard DHCP option for a subnet overrides VNET DHCP
     options.
    """
    
    def __init__(self, **kwargs):
        self._dns_servers = kwargs.get('dns_servers')
    
    @property
    def dns_servers(self):
        """
         Gets or sets list of DNS servers IP addresses
        """
        return self._dns_servers
    
    @dns_servers.setter 
    def dns_servers(self, value):
        self._dns_servers = value

class NetworkResourceProviderClient(Service):
    """
     The Windows Azure Network management API provides a RESTful set of web
     services that interact with Windows Azure Networks service to manage your
     network resrources. The API has entities that capture the relationship
     between an end user and the Windows Azure Networks service.
    """
    
    @property
    def api_version(self):
        """
         Gets the API version.
        """
        return self._api_version
    
    @property
    def long_running_operation_initial_timeout(self):
        """
         Gets or sets the initial timeout for Long Running Operations.
        """
        return self._long_running_operation_initial_timeout
    
    @long_running_operation_initial_timeout.setter 
    def long_running_operation_initial_timeout(self, value):
        self._long_running_operation_initial_timeout = value
    
    @property
    def long_running_operation_retry_timeout(self):
        """
         Gets or sets the retry timeout for Long Running Operations.
        """
        return self._long_running_operation_retry_timeout
    
    @long_running_operation_retry_timeout.setter 
    def long_running_operation_retry_timeout(self, value):
        self._long_running_operation_retry_timeout = value
    
    @property
    def load_balancers(self):
        """
         The Network Resource Provider API includes operations for managing the
         load balancers for your subscription.
        """
        return self._load_balancers
    
    @property
    def local_network_gateways(self):
        """
         The Network Resource Provider API includes operations for managing the
         Virtual network Gateway for your subscription.
        """
        return self._local_network_gateways
    
    @property
    def network_interfaces(self):
        """
         The Network Resource Provider API includes operations for managing the
         subnets for your subscription.
        """
        return self._network_interfaces
    
    @property
    def network_security_groups(self):
        """
         The Network Resource Provider API includes operations for managing the
         NetworkSecurityGroups for your subscription.
        """
        return self._network_security_groups
    
    @property
    def public_ip_addresses(self):
        """
         The Network Resource Provider API includes operations for managing the
         PublicIPAddress for your subscription.
        """
        return self._public_ip_addresses
    
    @property
    def security_rules(self):
        """
         The Network Resource Provider API includes operations for managing the
         SecurityRules for your subscription.
        """
        return self._security_rules
    
    @property
    def subnets(self):
        """
         The Network Resource Provider API includes operations for managing the
         subnets for your subscription.
        """
        return self._subnets
    
    @property
    def usages(self):
        """
         Operations for listing usage.
        """
        return self._usages
    
    @property
    def virtual_network_gateway_connections(self):
        """
         The Network Resource Provider API includes operations for managing the
         Virtual network Gateway for your subscription.
        """
        return self._virtual_network_gateway_connections
    
    @property
    def virtual_network_gateways(self):
        """
         The Network Resource Provider API includes operations for managing the
         Virtual network Gateway for your subscription.
        """
        return self._virtual_network_gateways
    
    @property
    def virtual_networks(self):
        """
         The Network Resource Provider API includes operations for managing the
         Virtual Networks for your subscription.
        """
        return self._virtual_networks
    
    def __init__(self, credentials, **kwargs):
        super(NetworkResourceProviderClient, self).__init__(credentials, **kwargs)
        
        if getattr(self, '_base_uri', None) is None:
            self._base_uri = 'https://management.azure.com/'
        
        if getattr(self, '_api_version', None) is None:
            self._api_version = '2015-05-01-preview'
        
        if getattr(self, '_long_running_operation_initial_timeout', None) is None:
            self._long_running_operation_initial_timeout = -1
        
        if getattr(self, '_long_running_operation_retry_timeout', None) is None:
            self._long_running_operation_retry_timeout = -1
        
        self._load_balancers = LoadBalancerOperations(self)
        self._local_network_gateways = LocalNetworkGatewayOperations(self)
        self._network_interfaces = NetworkInterfaceOperations(self)
        self._network_security_groups = NetworkSecurityGroupOperations(self)
        self._public_ip_addresses = PublicIpAddressOperations(self)
        self._security_rules = SecurityRuleOperations(self)
        self._subnets = SubnetOperations(self)
        self._usages = UsageOperations(self)
        self._virtual_network_gateway_connections = VirtualNetworkGatewayConnectionOperations(self)
        self._virtual_network_gateways = VirtualNetworkGatewayOperations(self)
        self._virtual_networks = VirtualNetworkOperations(self)
    
    def check_dns_name_availability(self, location, domain_name_label):
        """
         Checks whether a domain name in the cloudapp.net zone is available for
         use.
         
         Args:
         
         location (string): The location of the domain name
         
         domain_name_label (string): The domain name to be verified. It must
         conform to the following regular expression:
         ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
         
         Returns:
         
         DnsNameAvailabilityResponse: Response for CheckDnsNameAvailability Api
         servive call
        """
        # Validate
        if location is None:
            raise ValueError('location cannot be None.')
        
        if domain_name_label is None:
            raise ValueError('domain_name_label cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.credentials.subscription_id is not None:
            url = url + quote(self.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/locations/'
        url = url + quote(location)
        url = url + '/CheckDnsNameAvailability'
        query_parameters = []
        query_parameters.append('domainNameLabel=' + quote(domain_name_label))
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = DnsNameAvailabilityResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                available_value = response_doc.get('available', None)
                if available_value is not None:
                    available_instance = available_value
                    result.dns_name_availability = available_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get_long_running_operation_status(self, azure_async_operation):
        """
         The Get Operation Status operation returns the status of the specified
         operation. After calling an asynchronous operation, you can call Get
         Operation Status to determine whether the operation has succeeded,
         failed, or is still in progress.
         
         Args:
         
         azure_async_operation (string): Location value returned by the Begin
         operation.
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        # Validate
        if azure_async_operation is None:
            raise ValueError('azure_async_operation cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + azure_async_operation
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['x-ms-version'] = '2015-05-01-preview'
        
        # Send Request
        response = self.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 202:
            response_content = body
            result = AzureAsyncOperationResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                status_value = response_doc.get('status', None)
                if status_value is not None:
                    status_instance = status_value
                    result.status = status_instance
                
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class LoadBalancerOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     load balancers for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, load_balancer_name, parameters):
        """
         The Put LoadBalancer operation creates/updates a LoadBalancer
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         load_balancer_name (string): The name of the loadBalancer.
         
         parameters (LoadBalancer): Parameters supplied to the create/delete
         LoadBalancer operation
         
         Returns:
         
         LoadBalancerPutResponse: Response of a PUT Load Balancer operation
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if load_balancer_name is None:
            raise ValueError('load_balancer_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.inbound_nat_rules is not None:
            for inbound_nat_rules_parameter_item in parameters.inbound_nat_rules:
                if inbound_nat_rules_parameter_item.enable_floating_ip is None:
                    raise ValueError('parameters.inbound_nat_rules.enable_floating_ip cannot be None.')
                
                if inbound_nat_rules_parameter_item.frontend_port is None:
                    raise ValueError('parameters.inbound_nat_rules.frontend_port cannot be None.')
                
                if inbound_nat_rules_parameter_item.protocol is None:
                    raise ValueError('parameters.inbound_nat_rules.protocol cannot be None.')
                
        if parameters.load_balancing_rules is not None:
            for load_balancing_rules_parameter_item in parameters.load_balancing_rules:
                if load_balancing_rules_parameter_item.backend_address_pool is None:
                    raise ValueError('parameters.load_balancing_rules.backend_address_pool cannot be None.')
                
                if load_balancing_rules_parameter_item.enable_floating_ip is None:
                    raise ValueError('parameters.load_balancing_rules.enable_floating_ip cannot be None.')
                
                if load_balancing_rules_parameter_item.frontend_port is None:
                    raise ValueError('parameters.load_balancing_rules.frontend_port cannot be None.')
                
                if load_balancing_rules_parameter_item.protocol is None:
                    raise ValueError('parameters.load_balancing_rules.protocol cannot be None.')
                
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        if parameters.probes is not None:
            for probes_parameter_item in parameters.probes:
                if probes_parameter_item.port is None:
                    raise ValueError('parameters.probes.port cannot be None.')
                
                if probes_parameter_item.protocol is None:
                    raise ValueError('parameters.probes.protocol cannot be None.')
                
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/loadBalancers/'
        url = url + quote(load_balancer_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        load_balancer_json_format_value = {}
        request_doc = load_balancer_json_format_value
        
        properties_value = {}
        load_balancer_json_format_value['properties'] = properties_value
        
        if parameters.frontend_ip_configurations is not None:
            frontend_ip_configurations_array = []
            for frontend_ip_configurations_item in parameters.frontend_ip_configurations:
                frontend_ip_configuration_json_format_value = {}
                frontend_ip_configurations_array.append(frontend_ip_configuration_json_format_value)
                
                properties_value2 = {}
                frontend_ip_configuration_json_format_value['properties'] = properties_value2
                
                if frontend_ip_configurations_item.private_ip_address is not None:
                    properties_value2['privateIPAddress'] = frontend_ip_configurations_item.private_ip_address
                
                if frontend_ip_configurations_item.private_ip_allocation_method is not None:
                    properties_value2['privateIPAllocationMethod'] = frontend_ip_configurations_item.private_ip_allocation_method
                
                if frontend_ip_configurations_item.subnet is not None:
                    subnet_value = {}
                    properties_value2['subnet'] = subnet_value
                    
                    if frontend_ip_configurations_item.subnet.id is not None:
                        subnet_value['id'] = frontend_ip_configurations_item.subnet.id
                    
                if frontend_ip_configurations_item.public_ip_address is not None:
                    public_ip_address_value = {}
                    properties_value2['publicIPAddress'] = public_ip_address_value
                    
                    if frontend_ip_configurations_item.public_ip_address.id is not None:
                        public_ip_address_value['id'] = frontend_ip_configurations_item.public_ip_address.id
                    
                if frontend_ip_configurations_item.inbound_nat_rules is not None:
                    inbound_nat_rules_array = []
                    for inbound_nat_rules_item in frontend_ip_configurations_item.inbound_nat_rules:
                        resource_id_value = {}
                        inbound_nat_rules_array.append(resource_id_value)
                        
                        if inbound_nat_rules_item.id is not None:
                            resource_id_value['id'] = inbound_nat_rules_item.id
                        
                    properties_value2['inboundNatRules'] = inbound_nat_rules_array
                
                if frontend_ip_configurations_item.load_balancing_rules is not None:
                    load_balancing_rules_array = []
                    for load_balancing_rules_item in frontend_ip_configurations_item.load_balancing_rules:
                        resource_id_value2 = {}
                        load_balancing_rules_array.append(resource_id_value2)
                        
                        if load_balancing_rules_item.id is not None:
                            resource_id_value2['id'] = load_balancing_rules_item.id
                        
                    properties_value2['loadBalancingRules'] = load_balancing_rules_array
                
                if frontend_ip_configurations_item.provisioning_state is not None:
                    properties_value2['provisioningState'] = frontend_ip_configurations_item.provisioning_state
                
                if frontend_ip_configurations_item.name is not None:
                    frontend_ip_configuration_json_format_value['name'] = frontend_ip_configurations_item.name
                
                if frontend_ip_configurations_item.etag is not None:
                    frontend_ip_configuration_json_format_value['etag'] = frontend_ip_configurations_item.etag
                
                if frontend_ip_configurations_item.id is not None:
                    frontend_ip_configuration_json_format_value['id'] = frontend_ip_configurations_item.id
                
            properties_value['frontendIPConfigurations'] = frontend_ip_configurations_array
        
        if parameters.backend_address_pools is not None:
            backend_address_pools_array = []
            for backend_address_pools_item in parameters.backend_address_pools:
                backend_address_pool_json_format_value = {}
                backend_address_pools_array.append(backend_address_pool_json_format_value)
                
                properties_value3 = {}
                backend_address_pool_json_format_value['properties'] = properties_value3
                
                if backend_address_pools_item.backend_ip_configurations is not None:
                    backend_ip_configurations_array = []
                    for backend_ip_configurations_item in backend_address_pools_item.backend_ip_configurations:
                        resource_id_value3 = {}
                        backend_ip_configurations_array.append(resource_id_value3)
                        
                        if backend_ip_configurations_item.id is not None:
                            resource_id_value3['id'] = backend_ip_configurations_item.id
                        
                    properties_value3['backendIPConfigurations'] = backend_ip_configurations_array
                
                if backend_address_pools_item.load_balancing_rules is not None:
                    load_balancing_rules_array2 = []
                    for load_balancing_rules_item2 in backend_address_pools_item.load_balancing_rules:
                        resource_id_value4 = {}
                        load_balancing_rules_array2.append(resource_id_value4)
                        
                        if load_balancing_rules_item2.id is not None:
                            resource_id_value4['id'] = load_balancing_rules_item2.id
                        
                    properties_value3['loadBalancingRules'] = load_balancing_rules_array2
                
                if backend_address_pools_item.provisioning_state is not None:
                    properties_value3['provisioningState'] = backend_address_pools_item.provisioning_state
                
                if backend_address_pools_item.name is not None:
                    backend_address_pool_json_format_value['name'] = backend_address_pools_item.name
                
                if backend_address_pools_item.etag is not None:
                    backend_address_pool_json_format_value['etag'] = backend_address_pools_item.etag
                
                if backend_address_pools_item.id is not None:
                    backend_address_pool_json_format_value['id'] = backend_address_pools_item.id
                
            properties_value['backendAddressPools'] = backend_address_pools_array
        
        if parameters.load_balancing_rules is not None:
            load_balancing_rules_array3 = []
            for load_balancing_rules_item3 in parameters.load_balancing_rules:
                load_balancing_rule_json_format_value = {}
                load_balancing_rules_array3.append(load_balancing_rule_json_format_value)
                
                properties_value4 = {}
                load_balancing_rule_json_format_value['properties'] = properties_value4
                
                if load_balancing_rules_item3.frontend_ip_configuration is not None:
                    frontend_ip_configuration_value = {}
                    properties_value4['frontendIPConfiguration'] = frontend_ip_configuration_value
                    
                    if load_balancing_rules_item3.frontend_ip_configuration.id is not None:
                        frontend_ip_configuration_value['id'] = load_balancing_rules_item3.frontend_ip_configuration.id
                    
                backend_address_pool_value = {}
                properties_value4['backendAddressPool'] = backend_address_pool_value
                
                if load_balancing_rules_item3.backend_address_pool.id is not None:
                    backend_address_pool_value['id'] = load_balancing_rules_item3.backend_address_pool.id
                
                if load_balancing_rules_item3.probe is not None:
                    probe_value = {}
                    properties_value4['probe'] = probe_value
                    
                    if load_balancing_rules_item3.probe.id is not None:
                        probe_value['id'] = load_balancing_rules_item3.probe.id
                    
                properties_value4['protocol'] = load_balancing_rules_item3.protocol
                
                if load_balancing_rules_item3.load_distribution is not None:
                    properties_value4['loadDistribution'] = load_balancing_rules_item3.load_distribution
                
                properties_value4['frontendPort'] = load_balancing_rules_item3.frontend_port
                
                if load_balancing_rules_item3.backend_port is not None:
                    properties_value4['backendPort'] = load_balancing_rules_item3.backend_port
                
                if load_balancing_rules_item3.idle_timeout_in_minutes is not None:
                    properties_value4['idleTimeoutInMinutes'] = load_balancing_rules_item3.idle_timeout_in_minutes
                
                properties_value4['enableFloatingIP'] = load_balancing_rules_item3.enable_floating_ip
                
                if load_balancing_rules_item3.provisioning_state is not None:
                    properties_value4['provisioningState'] = load_balancing_rules_item3.provisioning_state
                
                if load_balancing_rules_item3.name is not None:
                    load_balancing_rule_json_format_value['name'] = load_balancing_rules_item3.name
                
                if load_balancing_rules_item3.etag is not None:
                    load_balancing_rule_json_format_value['etag'] = load_balancing_rules_item3.etag
                
                if load_balancing_rules_item3.id is not None:
                    load_balancing_rule_json_format_value['id'] = load_balancing_rules_item3.id
                
            properties_value['loadBalancingRules'] = load_balancing_rules_array3
        
        if parameters.probes is not None:
            probes_array = []
            for probes_item in parameters.probes:
                probe_json_format_value = {}
                probes_array.append(probe_json_format_value)
                
                properties_value5 = {}
                probe_json_format_value['properties'] = properties_value5
                
                if probes_item.load_balancing_rules is not None:
                    load_balancing_rules_array4 = []
                    for load_balancing_rules_item4 in probes_item.load_balancing_rules:
                        resource_id_value5 = {}
                        load_balancing_rules_array4.append(resource_id_value5)
                        
                        if load_balancing_rules_item4.id is not None:
                            resource_id_value5['id'] = load_balancing_rules_item4.id
                        
                    properties_value5['loadBalancingRules'] = load_balancing_rules_array4
                
                properties_value5['protocol'] = probes_item.protocol
                
                properties_value5['port'] = probes_item.port
                
                if probes_item.interval_in_seconds is not None:
                    properties_value5['intervalInSeconds'] = probes_item.interval_in_seconds
                
                if probes_item.number_of_probes is not None:
                    properties_value5['numberOfProbes'] = probes_item.number_of_probes
                
                if probes_item.request_path is not None:
                    properties_value5['requestPath'] = probes_item.request_path
                
                if probes_item.provisioning_state is not None:
                    properties_value5['provisioningState'] = probes_item.provisioning_state
                
                if probes_item.name is not None:
                    probe_json_format_value['name'] = probes_item.name
                
                if probes_item.etag is not None:
                    probe_json_format_value['etag'] = probes_item.etag
                
                if probes_item.id is not None:
                    probe_json_format_value['id'] = probes_item.id
                
            properties_value['probes'] = probes_array
        
        if parameters.inbound_nat_rules is not None:
            inbound_nat_rules_array2 = []
            for inbound_nat_rules_item2 in parameters.inbound_nat_rules:
                inbound_nat_rule_json_format_value = {}
                inbound_nat_rules_array2.append(inbound_nat_rule_json_format_value)
                
                properties_value6 = {}
                inbound_nat_rule_json_format_value['properties'] = properties_value6
                
                if inbound_nat_rules_item2.frontend_ip_configuration is not None:
                    frontend_ip_configuration_value2 = {}
                    properties_value6['frontendIPConfiguration'] = frontend_ip_configuration_value2
                    
                    if inbound_nat_rules_item2.frontend_ip_configuration.id is not None:
                        frontend_ip_configuration_value2['id'] = inbound_nat_rules_item2.frontend_ip_configuration.id
                    
                if inbound_nat_rules_item2.backend_ip_configuration is not None:
                    backend_ip_configuration_value = {}
                    properties_value6['backendIPConfiguration'] = backend_ip_configuration_value
                    
                    if inbound_nat_rules_item2.backend_ip_configuration.id is not None:
                        backend_ip_configuration_value['id'] = inbound_nat_rules_item2.backend_ip_configuration.id
                    
                properties_value6['protocol'] = inbound_nat_rules_item2.protocol
                
                properties_value6['frontendPort'] = inbound_nat_rules_item2.frontend_port
                
                if inbound_nat_rules_item2.backend_port is not None:
                    properties_value6['backendPort'] = inbound_nat_rules_item2.backend_port
                
                if inbound_nat_rules_item2.idle_timeout_in_minutes is not None:
                    properties_value6['idleTimeoutInMinutes'] = inbound_nat_rules_item2.idle_timeout_in_minutes
                
                properties_value6['enableFloatingIP'] = inbound_nat_rules_item2.enable_floating_ip
                
                if inbound_nat_rules_item2.provisioning_state is not None:
                    properties_value6['provisioningState'] = inbound_nat_rules_item2.provisioning_state
                
                if inbound_nat_rules_item2.name is not None:
                    inbound_nat_rule_json_format_value['name'] = inbound_nat_rules_item2.name
                
                if inbound_nat_rules_item2.etag is not None:
                    inbound_nat_rule_json_format_value['etag'] = inbound_nat_rules_item2.etag
                
                if inbound_nat_rules_item2.id is not None:
                    inbound_nat_rule_json_format_value['id'] = inbound_nat_rules_item2.id
                
            properties_value['inboundNatRules'] = inbound_nat_rules_array2
        
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            load_balancer_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            load_balancer_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            load_balancer_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            load_balancer_json_format_value['type'] = parameters.type
        
        load_balancer_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            load_balancer_json_format_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = LoadBalancerPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                load_balancer_instance = LoadBalancer(backend_address_pools=[], frontend_ip_configurations=[], inbound_nat_rules=[], load_balancing_rules=[], probes=[], tags={})
                result.load_balancer = load_balancer_instance
                
                properties_value7 = response_doc.get('properties', None)
                if properties_value7 is not None:
                    frontend_ip_configurations_array2 = properties_value7.get('frontendIPConfigurations', None)
                    if frontend_ip_configurations_array2 is not None:
                        for frontend_ip_configurations_value in frontend_ip_configurations_array2:
                            frontend_ip_configuration_json_format_instance = FrontendIpConfiguration(inbound_nat_rules=[], load_balancing_rules=[])
                            load_balancer_instance.frontend_ip_configurations.append(frontend_ip_configuration_json_format_instance)
                            
                            properties_value8 = frontend_ip_configurations_value.get('properties', None)
                            if properties_value8 is not None:
                                private_ip_address_value = properties_value8.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    frontend_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = properties_value8.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    frontend_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value2 = properties_value8.get('subnet', None)
                                if subnet_value2 is not None:
                                    subnet_instance = ResourceId()
                                    frontend_ip_configuration_json_format_instance.subnet = subnet_instance
                                    
                                    id_value = subnet_value2.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        subnet_instance.id = id_instance
                                    
                                public_ip_address_value2 = properties_value8.get('publicIPAddress', None)
                                if public_ip_address_value2 is not None:
                                    public_ip_address_instance = ResourceId()
                                    frontend_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value2 = public_ip_address_value2.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        public_ip_address_instance.id = id_instance2
                                    
                                inbound_nat_rules_array3 = properties_value8.get('inboundNatRules', None)
                                if inbound_nat_rules_array3 is not None:
                                    for inbound_nat_rules_value in inbound_nat_rules_array3:
                                        resource_id_instance = ResourceId()
                                        frontend_ip_configuration_json_format_instance.inbound_nat_rules.append(resource_id_instance)
                                        
                                        id_value3 = inbound_nat_rules_value.get('id', None)
                                        if id_value3 is not None:
                                            id_instance3 = id_value3
                                            resource_id_instance.id = id_instance3
                                        
                                load_balancing_rules_array5 = properties_value8.get('loadBalancingRules', None)
                                if load_balancing_rules_array5 is not None:
                                    for load_balancing_rules_value in load_balancing_rules_array5:
                                        resource_id_instance2 = ResourceId()
                                        frontend_ip_configuration_json_format_instance.load_balancing_rules.append(resource_id_instance2)
                                        
                                        id_value4 = load_balancing_rules_value.get('id', None)
                                        if id_value4 is not None:
                                            id_instance4 = id_value4
                                            resource_id_instance2.id = id_instance4
                                        
                                provisioning_state_value = properties_value8.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    frontend_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = frontend_ip_configurations_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                frontend_ip_configuration_json_format_instance.name = name_instance
                            
                            etag_value = frontend_ip_configurations_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                frontend_ip_configuration_json_format_instance.etag = etag_instance
                            
                            id_value5 = frontend_ip_configurations_value.get('id', None)
                            if id_value5 is not None:
                                id_instance5 = id_value5
                                frontend_ip_configuration_json_format_instance.id = id_instance5
                            
                    backend_address_pools_array2 = properties_value7.get('backendAddressPools', None)
                    if backend_address_pools_array2 is not None:
                        for backend_address_pools_value in backend_address_pools_array2:
                            backend_address_pool_json_format_instance = BackendAddressPool(backend_ip_configurations=[], load_balancing_rules=[])
                            load_balancer_instance.backend_address_pools.append(backend_address_pool_json_format_instance)
                            
                            properties_value9 = backend_address_pools_value.get('properties', None)
                            if properties_value9 is not None:
                                backend_ip_configurations_array2 = properties_value9.get('backendIPConfigurations', None)
                                if backend_ip_configurations_array2 is not None:
                                    for backend_ip_configurations_value in backend_ip_configurations_array2:
                                        resource_id_instance3 = ResourceId()
                                        backend_address_pool_json_format_instance.backend_ip_configurations.append(resource_id_instance3)
                                        
                                        id_value6 = backend_ip_configurations_value.get('id', None)
                                        if id_value6 is not None:
                                            id_instance6 = id_value6
                                            resource_id_instance3.id = id_instance6
                                        
                                load_balancing_rules_array6 = properties_value9.get('loadBalancingRules', None)
                                if load_balancing_rules_array6 is not None:
                                    for load_balancing_rules_value2 in load_balancing_rules_array6:
                                        resource_id_instance4 = ResourceId()
                                        backend_address_pool_json_format_instance.load_balancing_rules.append(resource_id_instance4)
                                        
                                        id_value7 = load_balancing_rules_value2.get('id', None)
                                        if id_value7 is not None:
                                            id_instance7 = id_value7
                                            resource_id_instance4.id = id_instance7
                                        
                                provisioning_state_value2 = properties_value9.get('provisioningState', None)
                                if provisioning_state_value2 is not None:
                                    provisioning_state_instance2 = provisioning_state_value2
                                    backend_address_pool_json_format_instance.provisioning_state = provisioning_state_instance2
                                
                            name_value2 = backend_address_pools_value.get('name', None)
                            if name_value2 is not None:
                                name_instance2 = name_value2
                                backend_address_pool_json_format_instance.name = name_instance2
                            
                            etag_value2 = backend_address_pools_value.get('etag', None)
                            if etag_value2 is not None:
                                etag_instance2 = etag_value2
                                backend_address_pool_json_format_instance.etag = etag_instance2
                            
                            id_value8 = backend_address_pools_value.get('id', None)
                            if id_value8 is not None:
                                id_instance8 = id_value8
                                backend_address_pool_json_format_instance.id = id_instance8
                            
                    load_balancing_rules_array7 = properties_value7.get('loadBalancingRules', None)
                    if load_balancing_rules_array7 is not None:
                        for load_balancing_rules_value3 in load_balancing_rules_array7:
                            load_balancing_rule_json_format_instance = LoadBalancingRule()
                            load_balancer_instance.load_balancing_rules.append(load_balancing_rule_json_format_instance)
                            
                            properties_value10 = load_balancing_rules_value3.get('properties', None)
                            if properties_value10 is not None:
                                frontend_ip_configuration_value3 = properties_value10.get('frontendIPConfiguration', None)
                                if frontend_ip_configuration_value3 is not None:
                                    frontend_ip_configuration_instance = ResourceId()
                                    load_balancing_rule_json_format_instance.frontend_ip_configuration = frontend_ip_configuration_instance
                                    
                                    id_value9 = frontend_ip_configuration_value3.get('id', None)
                                    if id_value9 is not None:
                                        id_instance9 = id_value9
                                        frontend_ip_configuration_instance.id = id_instance9
                                    
                                backend_address_pool_value2 = properties_value10.get('backendAddressPool', None)
                                if backend_address_pool_value2 is not None:
                                    backend_address_pool_instance = ResourceId()
                                    load_balancing_rule_json_format_instance.backend_address_pool = backend_address_pool_instance
                                    
                                    id_value10 = backend_address_pool_value2.get('id', None)
                                    if id_value10 is not None:
                                        id_instance10 = id_value10
                                        backend_address_pool_instance.id = id_instance10
                                    
                                probe_value2 = properties_value10.get('probe', None)
                                if probe_value2 is not None:
                                    probe_instance = ResourceId()
                                    load_balancing_rule_json_format_instance.probe = probe_instance
                                    
                                    id_value11 = probe_value2.get('id', None)
                                    if id_value11 is not None:
                                        id_instance11 = id_value11
                                        probe_instance.id = id_instance11
                                    
                                protocol_value = properties_value10.get('protocol', None)
                                if protocol_value is not None:
                                    protocol_instance = protocol_value
                                    load_balancing_rule_json_format_instance.protocol = protocol_instance
                                
                                load_distribution_value = properties_value10.get('loadDistribution', None)
                                if load_distribution_value is not None:
                                    load_distribution_instance = load_distribution_value
                                    load_balancing_rule_json_format_instance.load_distribution = load_distribution_instance
                                
                                frontend_port_value = properties_value10.get('frontendPort', None)
                                if frontend_port_value is not None:
                                    frontend_port_instance = frontend_port_value
                                    load_balancing_rule_json_format_instance.frontend_port = frontend_port_instance
                                
                                backend_port_value = properties_value10.get('backendPort', None)
                                if backend_port_value is not None:
                                    backend_port_instance = backend_port_value
                                    load_balancing_rule_json_format_instance.backend_port = backend_port_instance
                                
                                idle_timeout_in_minutes_value = properties_value10.get('idleTimeoutInMinutes', None)
                                if idle_timeout_in_minutes_value is not None:
                                    idle_timeout_in_minutes_instance = idle_timeout_in_minutes_value
                                    load_balancing_rule_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance
                                
                                enable_floating_ip_value = properties_value10.get('enableFloatingIP', None)
                                if enable_floating_ip_value is not None:
                                    enable_floating_ip_instance = enable_floating_ip_value
                                    load_balancing_rule_json_format_instance.enable_floating_ip = enable_floating_ip_instance
                                
                                provisioning_state_value3 = properties_value10.get('provisioningState', None)
                                if provisioning_state_value3 is not None:
                                    provisioning_state_instance3 = provisioning_state_value3
                                    load_balancing_rule_json_format_instance.provisioning_state = provisioning_state_instance3
                                
                            name_value3 = load_balancing_rules_value3.get('name', None)
                            if name_value3 is not None:
                                name_instance3 = name_value3
                                load_balancing_rule_json_format_instance.name = name_instance3
                            
                            etag_value3 = load_balancing_rules_value3.get('etag', None)
                            if etag_value3 is not None:
                                etag_instance3 = etag_value3
                                load_balancing_rule_json_format_instance.etag = etag_instance3
                            
                            id_value12 = load_balancing_rules_value3.get('id', None)
                            if id_value12 is not None:
                                id_instance12 = id_value12
                                load_balancing_rule_json_format_instance.id = id_instance12
                            
                    probes_array2 = properties_value7.get('probes', None)
                    if probes_array2 is not None:
                        for probes_value in probes_array2:
                            probe_json_format_instance = Probe(load_balancing_rules=[])
                            load_balancer_instance.probes.append(probe_json_format_instance)
                            
                            properties_value11 = probes_value.get('properties', None)
                            if properties_value11 is not None:
                                load_balancing_rules_array8 = properties_value11.get('loadBalancingRules', None)
                                if load_balancing_rules_array8 is not None:
                                    for load_balancing_rules_value4 in load_balancing_rules_array8:
                                        resource_id_instance5 = ResourceId()
                                        probe_json_format_instance.load_balancing_rules.append(resource_id_instance5)
                                        
                                        id_value13 = load_balancing_rules_value4.get('id', None)
                                        if id_value13 is not None:
                                            id_instance13 = id_value13
                                            resource_id_instance5.id = id_instance13
                                        
                                protocol_value2 = properties_value11.get('protocol', None)
                                if protocol_value2 is not None:
                                    protocol_instance2 = protocol_value2
                                    probe_json_format_instance.protocol = protocol_instance2
                                
                                port_value = properties_value11.get('port', None)
                                if port_value is not None:
                                    port_instance = port_value
                                    probe_json_format_instance.port = port_instance
                                
                                interval_in_seconds_value = properties_value11.get('intervalInSeconds', None)
                                if interval_in_seconds_value is not None:
                                    interval_in_seconds_instance = interval_in_seconds_value
                                    probe_json_format_instance.interval_in_seconds = interval_in_seconds_instance
                                
                                number_of_probes_value = properties_value11.get('numberOfProbes', None)
                                if number_of_probes_value is not None:
                                    number_of_probes_instance = number_of_probes_value
                                    probe_json_format_instance.number_of_probes = number_of_probes_instance
                                
                                request_path_value = properties_value11.get('requestPath', None)
                                if request_path_value is not None:
                                    request_path_instance = request_path_value
                                    probe_json_format_instance.request_path = request_path_instance
                                
                                provisioning_state_value4 = properties_value11.get('provisioningState', None)
                                if provisioning_state_value4 is not None:
                                    provisioning_state_instance4 = provisioning_state_value4
                                    probe_json_format_instance.provisioning_state = provisioning_state_instance4
                                
                            name_value4 = probes_value.get('name', None)
                            if name_value4 is not None:
                                name_instance4 = name_value4
                                probe_json_format_instance.name = name_instance4
                            
                            etag_value4 = probes_value.get('etag', None)
                            if etag_value4 is not None:
                                etag_instance4 = etag_value4
                                probe_json_format_instance.etag = etag_instance4
                            
                            id_value14 = probes_value.get('id', None)
                            if id_value14 is not None:
                                id_instance14 = id_value14
                                probe_json_format_instance.id = id_instance14
                            
                    inbound_nat_rules_array4 = properties_value7.get('inboundNatRules', None)
                    if inbound_nat_rules_array4 is not None:
                        for inbound_nat_rules_value2 in inbound_nat_rules_array4:
                            inbound_nat_rule_json_format_instance = InboundNatRule()
                            load_balancer_instance.inbound_nat_rules.append(inbound_nat_rule_json_format_instance)
                            
                            properties_value12 = inbound_nat_rules_value2.get('properties', None)
                            if properties_value12 is not None:
                                frontend_ip_configuration_value4 = properties_value12.get('frontendIPConfiguration', None)
                                if frontend_ip_configuration_value4 is not None:
                                    frontend_ip_configuration_instance2 = ResourceId()
                                    inbound_nat_rule_json_format_instance.frontend_ip_configuration = frontend_ip_configuration_instance2
                                    
                                    id_value15 = frontend_ip_configuration_value4.get('id', None)
                                    if id_value15 is not None:
                                        id_instance15 = id_value15
                                        frontend_ip_configuration_instance2.id = id_instance15
                                    
                                backend_ip_configuration_value2 = properties_value12.get('backendIPConfiguration', None)
                                if backend_ip_configuration_value2 is not None:
                                    backend_ip_configuration_instance = ResourceId()
                                    inbound_nat_rule_json_format_instance.backend_ip_configuration = backend_ip_configuration_instance
                                    
                                    id_value16 = backend_ip_configuration_value2.get('id', None)
                                    if id_value16 is not None:
                                        id_instance16 = id_value16
                                        backend_ip_configuration_instance.id = id_instance16
                                    
                                protocol_value3 = properties_value12.get('protocol', None)
                                if protocol_value3 is not None:
                                    protocol_instance3 = protocol_value3
                                    inbound_nat_rule_json_format_instance.protocol = protocol_instance3
                                
                                frontend_port_value2 = properties_value12.get('frontendPort', None)
                                if frontend_port_value2 is not None:
                                    frontend_port_instance2 = frontend_port_value2
                                    inbound_nat_rule_json_format_instance.frontend_port = frontend_port_instance2
                                
                                backend_port_value2 = properties_value12.get('backendPort', None)
                                if backend_port_value2 is not None:
                                    backend_port_instance2 = backend_port_value2
                                    inbound_nat_rule_json_format_instance.backend_port = backend_port_instance2
                                
                                idle_timeout_in_minutes_value2 = properties_value12.get('idleTimeoutInMinutes', None)
                                if idle_timeout_in_minutes_value2 is not None:
                                    idle_timeout_in_minutes_instance2 = idle_timeout_in_minutes_value2
                                    inbound_nat_rule_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance2
                                
                                enable_floating_ip_value2 = properties_value12.get('enableFloatingIP', None)
                                if enable_floating_ip_value2 is not None:
                                    enable_floating_ip_instance2 = enable_floating_ip_value2
                                    inbound_nat_rule_json_format_instance.enable_floating_ip = enable_floating_ip_instance2
                                
                                provisioning_state_value5 = properties_value12.get('provisioningState', None)
                                if provisioning_state_value5 is not None:
                                    provisioning_state_instance5 = provisioning_state_value5
                                    inbound_nat_rule_json_format_instance.provisioning_state = provisioning_state_instance5
                                
                            name_value5 = inbound_nat_rules_value2.get('name', None)
                            if name_value5 is not None:
                                name_instance5 = name_value5
                                inbound_nat_rule_json_format_instance.name = name_instance5
                            
                            etag_value5 = inbound_nat_rules_value2.get('etag', None)
                            if etag_value5 is not None:
                                etag_instance5 = etag_value5
                                inbound_nat_rule_json_format_instance.etag = etag_instance5
                            
                            id_value17 = inbound_nat_rules_value2.get('id', None)
                            if id_value17 is not None:
                                id_instance17 = id_value17
                                inbound_nat_rule_json_format_instance.id = id_instance17
                            
                    provisioning_state_value6 = properties_value7.get('provisioningState', None)
                    if provisioning_state_value6 is not None:
                        provisioning_state_instance6 = provisioning_state_value6
                        load_balancer_instance.provisioning_state = provisioning_state_instance6
                    
                etag_value6 = response_doc.get('etag', None)
                if etag_value6 is not None:
                    etag_instance6 = etag_value6
                    load_balancer_instance.etag = etag_instance6
                
                id_value18 = response_doc.get('id', None)
                if id_value18 is not None:
                    id_instance18 = id_value18
                    load_balancer_instance.id = id_instance18
                
                name_value6 = response_doc.get('name', None)
                if name_value6 is not None:
                    name_instance6 = name_value6
                    load_balancer_instance.name = name_instance6
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    load_balancer_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    load_balancer_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        load_balancer_instance.tags[tags_key2] = tags_value2
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        
        return result
    
    def begin_deleting(self, resource_group_name, load_balancer_name):
        """
         The delete loadbalancer operation deletes the specified loadbalancer.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         load_balancer_name (string): The name of the loadBalancer.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if load_balancer_name is None:
            raise ValueError('load_balancer_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/loadBalancers/'
        url = url + quote(load_balancer_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, load_balancer_name, parameters):
        """
         The Put LoadBalancer operation creates/updates a LoadBalancer
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         load_balancer_name (string): The name of the loadBalancer.
         
         parameters (LoadBalancer): Parameters supplied to the create/update
         LoadBalancer operation
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.load_balancers.begin_create_or_updating(resource_group_name, load_balancer_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, load_balancer_name):
        """
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         load_balancer_name (string): The name of the loadBalancer.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.load_balancers.begin_deleting(resource_group_name, load_balancer_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, load_balancer_name):
        """
         The Get ntework interface operation retreives information about the
         specified network interface.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         load_balancer_name (string): The name of the loadBalancer.
         
         Returns:
         
         LoadBalancerGetResponse: Response of a GET Load Balancer operation
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if load_balancer_name is None:
            raise ValueError('load_balancer_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/loadBalancers/'
        url = url + quote(load_balancer_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = LoadBalancerGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                load_balancer_instance = LoadBalancer(backend_address_pools=[], frontend_ip_configurations=[], inbound_nat_rules=[], load_balancing_rules=[], probes=[], tags={})
                result.load_balancer = load_balancer_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    frontend_ip_configurations_array = properties_value.get('frontendIPConfigurations', None)
                    if frontend_ip_configurations_array is not None:
                        for frontend_ip_configurations_value in frontend_ip_configurations_array:
                            frontend_ip_configuration_json_format_instance = FrontendIpConfiguration(inbound_nat_rules=[], load_balancing_rules=[])
                            load_balancer_instance.frontend_ip_configurations.append(frontend_ip_configuration_json_format_instance)
                            
                            properties_value2 = frontend_ip_configurations_value.get('properties', None)
                            if properties_value2 is not None:
                                private_ip_address_value = properties_value2.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    frontend_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = properties_value2.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    frontend_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value = properties_value2.get('subnet', None)
                                if subnet_value is not None:
                                    subnet_instance = ResourceId()
                                    frontend_ip_configuration_json_format_instance.subnet = subnet_instance
                                    
                                    id_value = subnet_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        subnet_instance.id = id_instance
                                    
                                public_ip_address_value = properties_value2.get('publicIPAddress', None)
                                if public_ip_address_value is not None:
                                    public_ip_address_instance = ResourceId()
                                    frontend_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value2 = public_ip_address_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        public_ip_address_instance.id = id_instance2
                                    
                                inbound_nat_rules_array = properties_value2.get('inboundNatRules', None)
                                if inbound_nat_rules_array is not None:
                                    for inbound_nat_rules_value in inbound_nat_rules_array:
                                        resource_id_instance = ResourceId()
                                        frontend_ip_configuration_json_format_instance.inbound_nat_rules.append(resource_id_instance)
                                        
                                        id_value3 = inbound_nat_rules_value.get('id', None)
                                        if id_value3 is not None:
                                            id_instance3 = id_value3
                                            resource_id_instance.id = id_instance3
                                        
                                load_balancing_rules_array = properties_value2.get('loadBalancingRules', None)
                                if load_balancing_rules_array is not None:
                                    for load_balancing_rules_value in load_balancing_rules_array:
                                        resource_id_instance2 = ResourceId()
                                        frontend_ip_configuration_json_format_instance.load_balancing_rules.append(resource_id_instance2)
                                        
                                        id_value4 = load_balancing_rules_value.get('id', None)
                                        if id_value4 is not None:
                                            id_instance4 = id_value4
                                            resource_id_instance2.id = id_instance4
                                        
                                provisioning_state_value = properties_value2.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    frontend_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = frontend_ip_configurations_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                frontend_ip_configuration_json_format_instance.name = name_instance
                            
                            etag_value = frontend_ip_configurations_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                frontend_ip_configuration_json_format_instance.etag = etag_instance
                            
                            id_value5 = frontend_ip_configurations_value.get('id', None)
                            if id_value5 is not None:
                                id_instance5 = id_value5
                                frontend_ip_configuration_json_format_instance.id = id_instance5
                            
                    backend_address_pools_array = properties_value.get('backendAddressPools', None)
                    if backend_address_pools_array is not None:
                        for backend_address_pools_value in backend_address_pools_array:
                            backend_address_pool_json_format_instance = BackendAddressPool(backend_ip_configurations=[], load_balancing_rules=[])
                            load_balancer_instance.backend_address_pools.append(backend_address_pool_json_format_instance)
                            
                            properties_value3 = backend_address_pools_value.get('properties', None)
                            if properties_value3 is not None:
                                backend_ip_configurations_array = properties_value3.get('backendIPConfigurations', None)
                                if backend_ip_configurations_array is not None:
                                    for backend_ip_configurations_value in backend_ip_configurations_array:
                                        resource_id_instance3 = ResourceId()
                                        backend_address_pool_json_format_instance.backend_ip_configurations.append(resource_id_instance3)
                                        
                                        id_value6 = backend_ip_configurations_value.get('id', None)
                                        if id_value6 is not None:
                                            id_instance6 = id_value6
                                            resource_id_instance3.id = id_instance6
                                        
                                load_balancing_rules_array2 = properties_value3.get('loadBalancingRules', None)
                                if load_balancing_rules_array2 is not None:
                                    for load_balancing_rules_value2 in load_balancing_rules_array2:
                                        resource_id_instance4 = ResourceId()
                                        backend_address_pool_json_format_instance.load_balancing_rules.append(resource_id_instance4)
                                        
                                        id_value7 = load_balancing_rules_value2.get('id', None)
                                        if id_value7 is not None:
                                            id_instance7 = id_value7
                                            resource_id_instance4.id = id_instance7
                                        
                                provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                if provisioning_state_value2 is not None:
                                    provisioning_state_instance2 = provisioning_state_value2
                                    backend_address_pool_json_format_instance.provisioning_state = provisioning_state_instance2
                                
                            name_value2 = backend_address_pools_value.get('name', None)
                            if name_value2 is not None:
                                name_instance2 = name_value2
                                backend_address_pool_json_format_instance.name = name_instance2
                            
                            etag_value2 = backend_address_pools_value.get('etag', None)
                            if etag_value2 is not None:
                                etag_instance2 = etag_value2
                                backend_address_pool_json_format_instance.etag = etag_instance2
                            
                            id_value8 = backend_address_pools_value.get('id', None)
                            if id_value8 is not None:
                                id_instance8 = id_value8
                                backend_address_pool_json_format_instance.id = id_instance8
                            
                    load_balancing_rules_array3 = properties_value.get('loadBalancingRules', None)
                    if load_balancing_rules_array3 is not None:
                        for load_balancing_rules_value3 in load_balancing_rules_array3:
                            load_balancing_rule_json_format_instance = LoadBalancingRule()
                            load_balancer_instance.load_balancing_rules.append(load_balancing_rule_json_format_instance)
                            
                            properties_value4 = load_balancing_rules_value3.get('properties', None)
                            if properties_value4 is not None:
                                frontend_ip_configuration_value = properties_value4.get('frontendIPConfiguration', None)
                                if frontend_ip_configuration_value is not None:
                                    frontend_ip_configuration_instance = ResourceId()
                                    load_balancing_rule_json_format_instance.frontend_ip_configuration = frontend_ip_configuration_instance
                                    
                                    id_value9 = frontend_ip_configuration_value.get('id', None)
                                    if id_value9 is not None:
                                        id_instance9 = id_value9
                                        frontend_ip_configuration_instance.id = id_instance9
                                    
                                backend_address_pool_value = properties_value4.get('backendAddressPool', None)
                                if backend_address_pool_value is not None:
                                    backend_address_pool_instance = ResourceId()
                                    load_balancing_rule_json_format_instance.backend_address_pool = backend_address_pool_instance
                                    
                                    id_value10 = backend_address_pool_value.get('id', None)
                                    if id_value10 is not None:
                                        id_instance10 = id_value10
                                        backend_address_pool_instance.id = id_instance10
                                    
                                probe_value = properties_value4.get('probe', None)
                                if probe_value is not None:
                                    probe_instance = ResourceId()
                                    load_balancing_rule_json_format_instance.probe = probe_instance
                                    
                                    id_value11 = probe_value.get('id', None)
                                    if id_value11 is not None:
                                        id_instance11 = id_value11
                                        probe_instance.id = id_instance11
                                    
                                protocol_value = properties_value4.get('protocol', None)
                                if protocol_value is not None:
                                    protocol_instance = protocol_value
                                    load_balancing_rule_json_format_instance.protocol = protocol_instance
                                
                                load_distribution_value = properties_value4.get('loadDistribution', None)
                                if load_distribution_value is not None:
                                    load_distribution_instance = load_distribution_value
                                    load_balancing_rule_json_format_instance.load_distribution = load_distribution_instance
                                
                                frontend_port_value = properties_value4.get('frontendPort', None)
                                if frontend_port_value is not None:
                                    frontend_port_instance = frontend_port_value
                                    load_balancing_rule_json_format_instance.frontend_port = frontend_port_instance
                                
                                backend_port_value = properties_value4.get('backendPort', None)
                                if backend_port_value is not None:
                                    backend_port_instance = backend_port_value
                                    load_balancing_rule_json_format_instance.backend_port = backend_port_instance
                                
                                idle_timeout_in_minutes_value = properties_value4.get('idleTimeoutInMinutes', None)
                                if idle_timeout_in_minutes_value is not None:
                                    idle_timeout_in_minutes_instance = idle_timeout_in_minutes_value
                                    load_balancing_rule_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance
                                
                                enable_floating_ip_value = properties_value4.get('enableFloatingIP', None)
                                if enable_floating_ip_value is not None:
                                    enable_floating_ip_instance = enable_floating_ip_value
                                    load_balancing_rule_json_format_instance.enable_floating_ip = enable_floating_ip_instance
                                
                                provisioning_state_value3 = properties_value4.get('provisioningState', None)
                                if provisioning_state_value3 is not None:
                                    provisioning_state_instance3 = provisioning_state_value3
                                    load_balancing_rule_json_format_instance.provisioning_state = provisioning_state_instance3
                                
                            name_value3 = load_balancing_rules_value3.get('name', None)
                            if name_value3 is not None:
                                name_instance3 = name_value3
                                load_balancing_rule_json_format_instance.name = name_instance3
                            
                            etag_value3 = load_balancing_rules_value3.get('etag', None)
                            if etag_value3 is not None:
                                etag_instance3 = etag_value3
                                load_balancing_rule_json_format_instance.etag = etag_instance3
                            
                            id_value12 = load_balancing_rules_value3.get('id', None)
                            if id_value12 is not None:
                                id_instance12 = id_value12
                                load_balancing_rule_json_format_instance.id = id_instance12
                            
                    probes_array = properties_value.get('probes', None)
                    if probes_array is not None:
                        for probes_value in probes_array:
                            probe_json_format_instance = Probe(load_balancing_rules=[])
                            load_balancer_instance.probes.append(probe_json_format_instance)
                            
                            properties_value5 = probes_value.get('properties', None)
                            if properties_value5 is not None:
                                load_balancing_rules_array4 = properties_value5.get('loadBalancingRules', None)
                                if load_balancing_rules_array4 is not None:
                                    for load_balancing_rules_value4 in load_balancing_rules_array4:
                                        resource_id_instance5 = ResourceId()
                                        probe_json_format_instance.load_balancing_rules.append(resource_id_instance5)
                                        
                                        id_value13 = load_balancing_rules_value4.get('id', None)
                                        if id_value13 is not None:
                                            id_instance13 = id_value13
                                            resource_id_instance5.id = id_instance13
                                        
                                protocol_value2 = properties_value5.get('protocol', None)
                                if protocol_value2 is not None:
                                    protocol_instance2 = protocol_value2
                                    probe_json_format_instance.protocol = protocol_instance2
                                
                                port_value = properties_value5.get('port', None)
                                if port_value is not None:
                                    port_instance = port_value
                                    probe_json_format_instance.port = port_instance
                                
                                interval_in_seconds_value = properties_value5.get('intervalInSeconds', None)
                                if interval_in_seconds_value is not None:
                                    interval_in_seconds_instance = interval_in_seconds_value
                                    probe_json_format_instance.interval_in_seconds = interval_in_seconds_instance
                                
                                number_of_probes_value = properties_value5.get('numberOfProbes', None)
                                if number_of_probes_value is not None:
                                    number_of_probes_instance = number_of_probes_value
                                    probe_json_format_instance.number_of_probes = number_of_probes_instance
                                
                                request_path_value = properties_value5.get('requestPath', None)
                                if request_path_value is not None:
                                    request_path_instance = request_path_value
                                    probe_json_format_instance.request_path = request_path_instance
                                
                                provisioning_state_value4 = properties_value5.get('provisioningState', None)
                                if provisioning_state_value4 is not None:
                                    provisioning_state_instance4 = provisioning_state_value4
                                    probe_json_format_instance.provisioning_state = provisioning_state_instance4
                                
                            name_value4 = probes_value.get('name', None)
                            if name_value4 is not None:
                                name_instance4 = name_value4
                                probe_json_format_instance.name = name_instance4
                            
                            etag_value4 = probes_value.get('etag', None)
                            if etag_value4 is not None:
                                etag_instance4 = etag_value4
                                probe_json_format_instance.etag = etag_instance4
                            
                            id_value14 = probes_value.get('id', None)
                            if id_value14 is not None:
                                id_instance14 = id_value14
                                probe_json_format_instance.id = id_instance14
                            
                    inbound_nat_rules_array2 = properties_value.get('inboundNatRules', None)
                    if inbound_nat_rules_array2 is not None:
                        for inbound_nat_rules_value2 in inbound_nat_rules_array2:
                            inbound_nat_rule_json_format_instance = InboundNatRule()
                            load_balancer_instance.inbound_nat_rules.append(inbound_nat_rule_json_format_instance)
                            
                            properties_value6 = inbound_nat_rules_value2.get('properties', None)
                            if properties_value6 is not None:
                                frontend_ip_configuration_value2 = properties_value6.get('frontendIPConfiguration', None)
                                if frontend_ip_configuration_value2 is not None:
                                    frontend_ip_configuration_instance2 = ResourceId()
                                    inbound_nat_rule_json_format_instance.frontend_ip_configuration = frontend_ip_configuration_instance2
                                    
                                    id_value15 = frontend_ip_configuration_value2.get('id', None)
                                    if id_value15 is not None:
                                        id_instance15 = id_value15
                                        frontend_ip_configuration_instance2.id = id_instance15
                                    
                                backend_ip_configuration_value = properties_value6.get('backendIPConfiguration', None)
                                if backend_ip_configuration_value is not None:
                                    backend_ip_configuration_instance = ResourceId()
                                    inbound_nat_rule_json_format_instance.backend_ip_configuration = backend_ip_configuration_instance
                                    
                                    id_value16 = backend_ip_configuration_value.get('id', None)
                                    if id_value16 is not None:
                                        id_instance16 = id_value16
                                        backend_ip_configuration_instance.id = id_instance16
                                    
                                protocol_value3 = properties_value6.get('protocol', None)
                                if protocol_value3 is not None:
                                    protocol_instance3 = protocol_value3
                                    inbound_nat_rule_json_format_instance.protocol = protocol_instance3
                                
                                frontend_port_value2 = properties_value6.get('frontendPort', None)
                                if frontend_port_value2 is not None:
                                    frontend_port_instance2 = frontend_port_value2
                                    inbound_nat_rule_json_format_instance.frontend_port = frontend_port_instance2
                                
                                backend_port_value2 = properties_value6.get('backendPort', None)
                                if backend_port_value2 is not None:
                                    backend_port_instance2 = backend_port_value2
                                    inbound_nat_rule_json_format_instance.backend_port = backend_port_instance2
                                
                                idle_timeout_in_minutes_value2 = properties_value6.get('idleTimeoutInMinutes', None)
                                if idle_timeout_in_minutes_value2 is not None:
                                    idle_timeout_in_minutes_instance2 = idle_timeout_in_minutes_value2
                                    inbound_nat_rule_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance2
                                
                                enable_floating_ip_value2 = properties_value6.get('enableFloatingIP', None)
                                if enable_floating_ip_value2 is not None:
                                    enable_floating_ip_instance2 = enable_floating_ip_value2
                                    inbound_nat_rule_json_format_instance.enable_floating_ip = enable_floating_ip_instance2
                                
                                provisioning_state_value5 = properties_value6.get('provisioningState', None)
                                if provisioning_state_value5 is not None:
                                    provisioning_state_instance5 = provisioning_state_value5
                                    inbound_nat_rule_json_format_instance.provisioning_state = provisioning_state_instance5
                                
                            name_value5 = inbound_nat_rules_value2.get('name', None)
                            if name_value5 is not None:
                                name_instance5 = name_value5
                                inbound_nat_rule_json_format_instance.name = name_instance5
                            
                            etag_value5 = inbound_nat_rules_value2.get('etag', None)
                            if etag_value5 is not None:
                                etag_instance5 = etag_value5
                                inbound_nat_rule_json_format_instance.etag = etag_instance5
                            
                            id_value17 = inbound_nat_rules_value2.get('id', None)
                            if id_value17 is not None:
                                id_instance17 = id_value17
                                inbound_nat_rule_json_format_instance.id = id_instance17
                            
                    provisioning_state_value6 = properties_value.get('provisioningState', None)
                    if provisioning_state_value6 is not None:
                        provisioning_state_instance6 = provisioning_state_value6
                        load_balancer_instance.provisioning_state = provisioning_state_instance6
                    
                etag_value6 = response_doc.get('etag', None)
                if etag_value6 is not None:
                    etag_instance6 = etag_value6
                    load_balancer_instance.etag = etag_instance6
                
                id_value18 = response_doc.get('id', None)
                if id_value18 is not None:
                    id_instance18 = id_value18
                    load_balancer_instance.id = id_instance18
                
                name_value6 = response_doc.get('name', None)
                if name_value6 is not None:
                    name_instance6 = name_value6
                    load_balancer_instance.name = name_instance6
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    load_balancer_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    load_balancer_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        load_balancer_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The List loadBalancer opertion retrieves all the loadbalancers in a
         resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         LoadBalancerListResponse: Response for ListLoadBalancers Api service
         call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/loadBalancers'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = LoadBalancerListResponse(load_balancers=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        load_balancer_json_format_instance = LoadBalancer(backend_address_pools=[], frontend_ip_configurations=[], inbound_nat_rules=[], load_balancing_rules=[], probes=[], tags={})
                        result.load_balancers.append(load_balancer_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            frontend_ip_configurations_array = properties_value.get('frontendIPConfigurations', None)
                            if frontend_ip_configurations_array is not None:
                                for frontend_ip_configurations_value in frontend_ip_configurations_array:
                                    frontend_ip_configuration_json_format_instance = FrontendIpConfiguration(inbound_nat_rules=[], load_balancing_rules=[])
                                    load_balancer_json_format_instance.frontend_ip_configurations.append(frontend_ip_configuration_json_format_instance)
                                    
                                    properties_value2 = frontend_ip_configurations_value.get('properties', None)
                                    if properties_value2 is not None:
                                        private_ip_address_value = properties_value2.get('privateIPAddress', None)
                                        if private_ip_address_value is not None:
                                            private_ip_address_instance = private_ip_address_value
                                            frontend_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                        
                                        private_ip_allocation_method_value = properties_value2.get('privateIPAllocationMethod', None)
                                        if private_ip_allocation_method_value is not None:
                                            private_ip_allocation_method_instance = private_ip_allocation_method_value
                                            frontend_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                        
                                        subnet_value = properties_value2.get('subnet', None)
                                        if subnet_value is not None:
                                            subnet_instance = ResourceId()
                                            frontend_ip_configuration_json_format_instance.subnet = subnet_instance
                                            
                                            id_value = subnet_value.get('id', None)
                                            if id_value is not None:
                                                id_instance = id_value
                                                subnet_instance.id = id_instance
                                            
                                        public_ip_address_value = properties_value2.get('publicIPAddress', None)
                                        if public_ip_address_value is not None:
                                            public_ip_address_instance = ResourceId()
                                            frontend_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                            
                                            id_value2 = public_ip_address_value.get('id', None)
                                            if id_value2 is not None:
                                                id_instance2 = id_value2
                                                public_ip_address_instance.id = id_instance2
                                            
                                        inbound_nat_rules_array = properties_value2.get('inboundNatRules', None)
                                        if inbound_nat_rules_array is not None:
                                            for inbound_nat_rules_value in inbound_nat_rules_array:
                                                resource_id_instance = ResourceId()
                                                frontend_ip_configuration_json_format_instance.inbound_nat_rules.append(resource_id_instance)
                                                
                                                id_value3 = inbound_nat_rules_value.get('id', None)
                                                if id_value3 is not None:
                                                    id_instance3 = id_value3
                                                    resource_id_instance.id = id_instance3
                                                
                                        load_balancing_rules_array = properties_value2.get('loadBalancingRules', None)
                                        if load_balancing_rules_array is not None:
                                            for load_balancing_rules_value in load_balancing_rules_array:
                                                resource_id_instance2 = ResourceId()
                                                frontend_ip_configuration_json_format_instance.load_balancing_rules.append(resource_id_instance2)
                                                
                                                id_value4 = load_balancing_rules_value.get('id', None)
                                                if id_value4 is not None:
                                                    id_instance4 = id_value4
                                                    resource_id_instance2.id = id_instance4
                                                
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            frontend_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = frontend_ip_configurations_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        frontend_ip_configuration_json_format_instance.name = name_instance
                                    
                                    etag_value = frontend_ip_configurations_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        frontend_ip_configuration_json_format_instance.etag = etag_instance
                                    
                                    id_value5 = frontend_ip_configurations_value.get('id', None)
                                    if id_value5 is not None:
                                        id_instance5 = id_value5
                                        frontend_ip_configuration_json_format_instance.id = id_instance5
                                    
                            backend_address_pools_array = properties_value.get('backendAddressPools', None)
                            if backend_address_pools_array is not None:
                                for backend_address_pools_value in backend_address_pools_array:
                                    backend_address_pool_json_format_instance = BackendAddressPool(backend_ip_configurations=[], load_balancing_rules=[])
                                    load_balancer_json_format_instance.backend_address_pools.append(backend_address_pool_json_format_instance)
                                    
                                    properties_value3 = backend_address_pools_value.get('properties', None)
                                    if properties_value3 is not None:
                                        backend_ip_configurations_array = properties_value3.get('backendIPConfigurations', None)
                                        if backend_ip_configurations_array is not None:
                                            for backend_ip_configurations_value in backend_ip_configurations_array:
                                                resource_id_instance3 = ResourceId()
                                                backend_address_pool_json_format_instance.backend_ip_configurations.append(resource_id_instance3)
                                                
                                                id_value6 = backend_ip_configurations_value.get('id', None)
                                                if id_value6 is not None:
                                                    id_instance6 = id_value6
                                                    resource_id_instance3.id = id_instance6
                                                
                                        load_balancing_rules_array2 = properties_value3.get('loadBalancingRules', None)
                                        if load_balancing_rules_array2 is not None:
                                            for load_balancing_rules_value2 in load_balancing_rules_array2:
                                                resource_id_instance4 = ResourceId()
                                                backend_address_pool_json_format_instance.load_balancing_rules.append(resource_id_instance4)
                                                
                                                id_value7 = load_balancing_rules_value2.get('id', None)
                                                if id_value7 is not None:
                                                    id_instance7 = id_value7
                                                    resource_id_instance4.id = id_instance7
                                                
                                        provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                        if provisioning_state_value2 is not None:
                                            provisioning_state_instance2 = provisioning_state_value2
                                            backend_address_pool_json_format_instance.provisioning_state = provisioning_state_instance2
                                        
                                    name_value2 = backend_address_pools_value.get('name', None)
                                    if name_value2 is not None:
                                        name_instance2 = name_value2
                                        backend_address_pool_json_format_instance.name = name_instance2
                                    
                                    etag_value2 = backend_address_pools_value.get('etag', None)
                                    if etag_value2 is not None:
                                        etag_instance2 = etag_value2
                                        backend_address_pool_json_format_instance.etag = etag_instance2
                                    
                                    id_value8 = backend_address_pools_value.get('id', None)
                                    if id_value8 is not None:
                                        id_instance8 = id_value8
                                        backend_address_pool_json_format_instance.id = id_instance8
                                    
                            load_balancing_rules_array3 = properties_value.get('loadBalancingRules', None)
                            if load_balancing_rules_array3 is not None:
                                for load_balancing_rules_value3 in load_balancing_rules_array3:
                                    load_balancing_rule_json_format_instance = LoadBalancingRule()
                                    load_balancer_json_format_instance.load_balancing_rules.append(load_balancing_rule_json_format_instance)
                                    
                                    properties_value4 = load_balancing_rules_value3.get('properties', None)
                                    if properties_value4 is not None:
                                        frontend_ip_configuration_value = properties_value4.get('frontendIPConfiguration', None)
                                        if frontend_ip_configuration_value is not None:
                                            frontend_ip_configuration_instance = ResourceId()
                                            load_balancing_rule_json_format_instance.frontend_ip_configuration = frontend_ip_configuration_instance
                                            
                                            id_value9 = frontend_ip_configuration_value.get('id', None)
                                            if id_value9 is not None:
                                                id_instance9 = id_value9
                                                frontend_ip_configuration_instance.id = id_instance9
                                            
                                        backend_address_pool_value = properties_value4.get('backendAddressPool', None)
                                        if backend_address_pool_value is not None:
                                            backend_address_pool_instance = ResourceId()
                                            load_balancing_rule_json_format_instance.backend_address_pool = backend_address_pool_instance
                                            
                                            id_value10 = backend_address_pool_value.get('id', None)
                                            if id_value10 is not None:
                                                id_instance10 = id_value10
                                                backend_address_pool_instance.id = id_instance10
                                            
                                        probe_value = properties_value4.get('probe', None)
                                        if probe_value is not None:
                                            probe_instance = ResourceId()
                                            load_balancing_rule_json_format_instance.probe = probe_instance
                                            
                                            id_value11 = probe_value.get('id', None)
                                            if id_value11 is not None:
                                                id_instance11 = id_value11
                                                probe_instance.id = id_instance11
                                            
                                        protocol_value = properties_value4.get('protocol', None)
                                        if protocol_value is not None:
                                            protocol_instance = protocol_value
                                            load_balancing_rule_json_format_instance.protocol = protocol_instance
                                        
                                        load_distribution_value = properties_value4.get('loadDistribution', None)
                                        if load_distribution_value is not None:
                                            load_distribution_instance = load_distribution_value
                                            load_balancing_rule_json_format_instance.load_distribution = load_distribution_instance
                                        
                                        frontend_port_value = properties_value4.get('frontendPort', None)
                                        if frontend_port_value is not None:
                                            frontend_port_instance = frontend_port_value
                                            load_balancing_rule_json_format_instance.frontend_port = frontend_port_instance
                                        
                                        backend_port_value = properties_value4.get('backendPort', None)
                                        if backend_port_value is not None:
                                            backend_port_instance = backend_port_value
                                            load_balancing_rule_json_format_instance.backend_port = backend_port_instance
                                        
                                        idle_timeout_in_minutes_value = properties_value4.get('idleTimeoutInMinutes', None)
                                        if idle_timeout_in_minutes_value is not None:
                                            idle_timeout_in_minutes_instance = idle_timeout_in_minutes_value
                                            load_balancing_rule_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance
                                        
                                        enable_floating_ip_value = properties_value4.get('enableFloatingIP', None)
                                        if enable_floating_ip_value is not None:
                                            enable_floating_ip_instance = enable_floating_ip_value
                                            load_balancing_rule_json_format_instance.enable_floating_ip = enable_floating_ip_instance
                                        
                                        provisioning_state_value3 = properties_value4.get('provisioningState', None)
                                        if provisioning_state_value3 is not None:
                                            provisioning_state_instance3 = provisioning_state_value3
                                            load_balancing_rule_json_format_instance.provisioning_state = provisioning_state_instance3
                                        
                                    name_value3 = load_balancing_rules_value3.get('name', None)
                                    if name_value3 is not None:
                                        name_instance3 = name_value3
                                        load_balancing_rule_json_format_instance.name = name_instance3
                                    
                                    etag_value3 = load_balancing_rules_value3.get('etag', None)
                                    if etag_value3 is not None:
                                        etag_instance3 = etag_value3
                                        load_balancing_rule_json_format_instance.etag = etag_instance3
                                    
                                    id_value12 = load_balancing_rules_value3.get('id', None)
                                    if id_value12 is not None:
                                        id_instance12 = id_value12
                                        load_balancing_rule_json_format_instance.id = id_instance12
                                    
                            probes_array = properties_value.get('probes', None)
                            if probes_array is not None:
                                for probes_value in probes_array:
                                    probe_json_format_instance = Probe(load_balancing_rules=[])
                                    load_balancer_json_format_instance.probes.append(probe_json_format_instance)
                                    
                                    properties_value5 = probes_value.get('properties', None)
                                    if properties_value5 is not None:
                                        load_balancing_rules_array4 = properties_value5.get('loadBalancingRules', None)
                                        if load_balancing_rules_array4 is not None:
                                            for load_balancing_rules_value4 in load_balancing_rules_array4:
                                                resource_id_instance5 = ResourceId()
                                                probe_json_format_instance.load_balancing_rules.append(resource_id_instance5)
                                                
                                                id_value13 = load_balancing_rules_value4.get('id', None)
                                                if id_value13 is not None:
                                                    id_instance13 = id_value13
                                                    resource_id_instance5.id = id_instance13
                                                
                                        protocol_value2 = properties_value5.get('protocol', None)
                                        if protocol_value2 is not None:
                                            protocol_instance2 = protocol_value2
                                            probe_json_format_instance.protocol = protocol_instance2
                                        
                                        port_value = properties_value5.get('port', None)
                                        if port_value is not None:
                                            port_instance = port_value
                                            probe_json_format_instance.port = port_instance
                                        
                                        interval_in_seconds_value = properties_value5.get('intervalInSeconds', None)
                                        if interval_in_seconds_value is not None:
                                            interval_in_seconds_instance = interval_in_seconds_value
                                            probe_json_format_instance.interval_in_seconds = interval_in_seconds_instance
                                        
                                        number_of_probes_value = properties_value5.get('numberOfProbes', None)
                                        if number_of_probes_value is not None:
                                            number_of_probes_instance = number_of_probes_value
                                            probe_json_format_instance.number_of_probes = number_of_probes_instance
                                        
                                        request_path_value = properties_value5.get('requestPath', None)
                                        if request_path_value is not None:
                                            request_path_instance = request_path_value
                                            probe_json_format_instance.request_path = request_path_instance
                                        
                                        provisioning_state_value4 = properties_value5.get('provisioningState', None)
                                        if provisioning_state_value4 is not None:
                                            provisioning_state_instance4 = provisioning_state_value4
                                            probe_json_format_instance.provisioning_state = provisioning_state_instance4
                                        
                                    name_value4 = probes_value.get('name', None)
                                    if name_value4 is not None:
                                        name_instance4 = name_value4
                                        probe_json_format_instance.name = name_instance4
                                    
                                    etag_value4 = probes_value.get('etag', None)
                                    if etag_value4 is not None:
                                        etag_instance4 = etag_value4
                                        probe_json_format_instance.etag = etag_instance4
                                    
                                    id_value14 = probes_value.get('id', None)
                                    if id_value14 is not None:
                                        id_instance14 = id_value14
                                        probe_json_format_instance.id = id_instance14
                                    
                            inbound_nat_rules_array2 = properties_value.get('inboundNatRules', None)
                            if inbound_nat_rules_array2 is not None:
                                for inbound_nat_rules_value2 in inbound_nat_rules_array2:
                                    inbound_nat_rule_json_format_instance = InboundNatRule()
                                    load_balancer_json_format_instance.inbound_nat_rules.append(inbound_nat_rule_json_format_instance)
                                    
                                    properties_value6 = inbound_nat_rules_value2.get('properties', None)
                                    if properties_value6 is not None:
                                        frontend_ip_configuration_value2 = properties_value6.get('frontendIPConfiguration', None)
                                        if frontend_ip_configuration_value2 is not None:
                                            frontend_ip_configuration_instance2 = ResourceId()
                                            inbound_nat_rule_json_format_instance.frontend_ip_configuration = frontend_ip_configuration_instance2
                                            
                                            id_value15 = frontend_ip_configuration_value2.get('id', None)
                                            if id_value15 is not None:
                                                id_instance15 = id_value15
                                                frontend_ip_configuration_instance2.id = id_instance15
                                            
                                        backend_ip_configuration_value = properties_value6.get('backendIPConfiguration', None)
                                        if backend_ip_configuration_value is not None:
                                            backend_ip_configuration_instance = ResourceId()
                                            inbound_nat_rule_json_format_instance.backend_ip_configuration = backend_ip_configuration_instance
                                            
                                            id_value16 = backend_ip_configuration_value.get('id', None)
                                            if id_value16 is not None:
                                                id_instance16 = id_value16
                                                backend_ip_configuration_instance.id = id_instance16
                                            
                                        protocol_value3 = properties_value6.get('protocol', None)
                                        if protocol_value3 is not None:
                                            protocol_instance3 = protocol_value3
                                            inbound_nat_rule_json_format_instance.protocol = protocol_instance3
                                        
                                        frontend_port_value2 = properties_value6.get('frontendPort', None)
                                        if frontend_port_value2 is not None:
                                            frontend_port_instance2 = frontend_port_value2
                                            inbound_nat_rule_json_format_instance.frontend_port = frontend_port_instance2
                                        
                                        backend_port_value2 = properties_value6.get('backendPort', None)
                                        if backend_port_value2 is not None:
                                            backend_port_instance2 = backend_port_value2
                                            inbound_nat_rule_json_format_instance.backend_port = backend_port_instance2
                                        
                                        idle_timeout_in_minutes_value2 = properties_value6.get('idleTimeoutInMinutes', None)
                                        if idle_timeout_in_minutes_value2 is not None:
                                            idle_timeout_in_minutes_instance2 = idle_timeout_in_minutes_value2
                                            inbound_nat_rule_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance2
                                        
                                        enable_floating_ip_value2 = properties_value6.get('enableFloatingIP', None)
                                        if enable_floating_ip_value2 is not None:
                                            enable_floating_ip_instance2 = enable_floating_ip_value2
                                            inbound_nat_rule_json_format_instance.enable_floating_ip = enable_floating_ip_instance2
                                        
                                        provisioning_state_value5 = properties_value6.get('provisioningState', None)
                                        if provisioning_state_value5 is not None:
                                            provisioning_state_instance5 = provisioning_state_value5
                                            inbound_nat_rule_json_format_instance.provisioning_state = provisioning_state_instance5
                                        
                                    name_value5 = inbound_nat_rules_value2.get('name', None)
                                    if name_value5 is not None:
                                        name_instance5 = name_value5
                                        inbound_nat_rule_json_format_instance.name = name_instance5
                                    
                                    etag_value5 = inbound_nat_rules_value2.get('etag', None)
                                    if etag_value5 is not None:
                                        etag_instance5 = etag_value5
                                        inbound_nat_rule_json_format_instance.etag = etag_instance5
                                    
                                    id_value17 = inbound_nat_rules_value2.get('id', None)
                                    if id_value17 is not None:
                                        id_instance17 = id_value17
                                        inbound_nat_rule_json_format_instance.id = id_instance17
                                    
                            provisioning_state_value6 = properties_value.get('provisioningState', None)
                            if provisioning_state_value6 is not None:
                                provisioning_state_instance6 = provisioning_state_value6
                                load_balancer_json_format_instance.provisioning_state = provisioning_state_instance6
                            
                        etag_value6 = value_value.get('etag', None)
                        if etag_value6 is not None:
                            etag_instance6 = etag_value6
                            load_balancer_json_format_instance.etag = etag_instance6
                        
                        id_value18 = value_value.get('id', None)
                        if id_value18 is not None:
                            id_instance18 = id_value18
                            load_balancer_json_format_instance.id = id_instance18
                        
                        name_value6 = value_value.get('name', None)
                        if name_value6 is not None:
                            name_instance6 = name_value6
                            load_balancer_json_format_instance.name = name_instance6
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            load_balancer_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            load_balancer_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                load_balancer_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_all(self):
        """
         The List loadBalancer opertion retrieves all the loadbalancers in a
         subscription.
         
         Returns:
         
         LoadBalancerListResponse: Response for ListLoadBalancers Api service
         call
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/loadBalancers'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = LoadBalancerListResponse(load_balancers=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        load_balancer_json_format_instance = LoadBalancer(backend_address_pools=[], frontend_ip_configurations=[], inbound_nat_rules=[], load_balancing_rules=[], probes=[], tags={})
                        result.load_balancers.append(load_balancer_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            frontend_ip_configurations_array = properties_value.get('frontendIPConfigurations', None)
                            if frontend_ip_configurations_array is not None:
                                for frontend_ip_configurations_value in frontend_ip_configurations_array:
                                    frontend_ip_configuration_json_format_instance = FrontendIpConfiguration(inbound_nat_rules=[], load_balancing_rules=[])
                                    load_balancer_json_format_instance.frontend_ip_configurations.append(frontend_ip_configuration_json_format_instance)
                                    
                                    properties_value2 = frontend_ip_configurations_value.get('properties', None)
                                    if properties_value2 is not None:
                                        private_ip_address_value = properties_value2.get('privateIPAddress', None)
                                        if private_ip_address_value is not None:
                                            private_ip_address_instance = private_ip_address_value
                                            frontend_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                        
                                        private_ip_allocation_method_value = properties_value2.get('privateIPAllocationMethod', None)
                                        if private_ip_allocation_method_value is not None:
                                            private_ip_allocation_method_instance = private_ip_allocation_method_value
                                            frontend_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                        
                                        subnet_value = properties_value2.get('subnet', None)
                                        if subnet_value is not None:
                                            subnet_instance = ResourceId()
                                            frontend_ip_configuration_json_format_instance.subnet = subnet_instance
                                            
                                            id_value = subnet_value.get('id', None)
                                            if id_value is not None:
                                                id_instance = id_value
                                                subnet_instance.id = id_instance
                                            
                                        public_ip_address_value = properties_value2.get('publicIPAddress', None)
                                        if public_ip_address_value is not None:
                                            public_ip_address_instance = ResourceId()
                                            frontend_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                            
                                            id_value2 = public_ip_address_value.get('id', None)
                                            if id_value2 is not None:
                                                id_instance2 = id_value2
                                                public_ip_address_instance.id = id_instance2
                                            
                                        inbound_nat_rules_array = properties_value2.get('inboundNatRules', None)
                                        if inbound_nat_rules_array is not None:
                                            for inbound_nat_rules_value in inbound_nat_rules_array:
                                                resource_id_instance = ResourceId()
                                                frontend_ip_configuration_json_format_instance.inbound_nat_rules.append(resource_id_instance)
                                                
                                                id_value3 = inbound_nat_rules_value.get('id', None)
                                                if id_value3 is not None:
                                                    id_instance3 = id_value3
                                                    resource_id_instance.id = id_instance3
                                                
                                        load_balancing_rules_array = properties_value2.get('loadBalancingRules', None)
                                        if load_balancing_rules_array is not None:
                                            for load_balancing_rules_value in load_balancing_rules_array:
                                                resource_id_instance2 = ResourceId()
                                                frontend_ip_configuration_json_format_instance.load_balancing_rules.append(resource_id_instance2)
                                                
                                                id_value4 = load_balancing_rules_value.get('id', None)
                                                if id_value4 is not None:
                                                    id_instance4 = id_value4
                                                    resource_id_instance2.id = id_instance4
                                                
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            frontend_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = frontend_ip_configurations_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        frontend_ip_configuration_json_format_instance.name = name_instance
                                    
                                    etag_value = frontend_ip_configurations_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        frontend_ip_configuration_json_format_instance.etag = etag_instance
                                    
                                    id_value5 = frontend_ip_configurations_value.get('id', None)
                                    if id_value5 is not None:
                                        id_instance5 = id_value5
                                        frontend_ip_configuration_json_format_instance.id = id_instance5
                                    
                            backend_address_pools_array = properties_value.get('backendAddressPools', None)
                            if backend_address_pools_array is not None:
                                for backend_address_pools_value in backend_address_pools_array:
                                    backend_address_pool_json_format_instance = BackendAddressPool(backend_ip_configurations=[], load_balancing_rules=[])
                                    load_balancer_json_format_instance.backend_address_pools.append(backend_address_pool_json_format_instance)
                                    
                                    properties_value3 = backend_address_pools_value.get('properties', None)
                                    if properties_value3 is not None:
                                        backend_ip_configurations_array = properties_value3.get('backendIPConfigurations', None)
                                        if backend_ip_configurations_array is not None:
                                            for backend_ip_configurations_value in backend_ip_configurations_array:
                                                resource_id_instance3 = ResourceId()
                                                backend_address_pool_json_format_instance.backend_ip_configurations.append(resource_id_instance3)
                                                
                                                id_value6 = backend_ip_configurations_value.get('id', None)
                                                if id_value6 is not None:
                                                    id_instance6 = id_value6
                                                    resource_id_instance3.id = id_instance6
                                                
                                        load_balancing_rules_array2 = properties_value3.get('loadBalancingRules', None)
                                        if load_balancing_rules_array2 is not None:
                                            for load_balancing_rules_value2 in load_balancing_rules_array2:
                                                resource_id_instance4 = ResourceId()
                                                backend_address_pool_json_format_instance.load_balancing_rules.append(resource_id_instance4)
                                                
                                                id_value7 = load_balancing_rules_value2.get('id', None)
                                                if id_value7 is not None:
                                                    id_instance7 = id_value7
                                                    resource_id_instance4.id = id_instance7
                                                
                                        provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                        if provisioning_state_value2 is not None:
                                            provisioning_state_instance2 = provisioning_state_value2
                                            backend_address_pool_json_format_instance.provisioning_state = provisioning_state_instance2
                                        
                                    name_value2 = backend_address_pools_value.get('name', None)
                                    if name_value2 is not None:
                                        name_instance2 = name_value2
                                        backend_address_pool_json_format_instance.name = name_instance2
                                    
                                    etag_value2 = backend_address_pools_value.get('etag', None)
                                    if etag_value2 is not None:
                                        etag_instance2 = etag_value2
                                        backend_address_pool_json_format_instance.etag = etag_instance2
                                    
                                    id_value8 = backend_address_pools_value.get('id', None)
                                    if id_value8 is not None:
                                        id_instance8 = id_value8
                                        backend_address_pool_json_format_instance.id = id_instance8
                                    
                            load_balancing_rules_array3 = properties_value.get('loadBalancingRules', None)
                            if load_balancing_rules_array3 is not None:
                                for load_balancing_rules_value3 in load_balancing_rules_array3:
                                    load_balancing_rule_json_format_instance = LoadBalancingRule()
                                    load_balancer_json_format_instance.load_balancing_rules.append(load_balancing_rule_json_format_instance)
                                    
                                    properties_value4 = load_balancing_rules_value3.get('properties', None)
                                    if properties_value4 is not None:
                                        frontend_ip_configuration_value = properties_value4.get('frontendIPConfiguration', None)
                                        if frontend_ip_configuration_value is not None:
                                            frontend_ip_configuration_instance = ResourceId()
                                            load_balancing_rule_json_format_instance.frontend_ip_configuration = frontend_ip_configuration_instance
                                            
                                            id_value9 = frontend_ip_configuration_value.get('id', None)
                                            if id_value9 is not None:
                                                id_instance9 = id_value9
                                                frontend_ip_configuration_instance.id = id_instance9
                                            
                                        backend_address_pool_value = properties_value4.get('backendAddressPool', None)
                                        if backend_address_pool_value is not None:
                                            backend_address_pool_instance = ResourceId()
                                            load_balancing_rule_json_format_instance.backend_address_pool = backend_address_pool_instance
                                            
                                            id_value10 = backend_address_pool_value.get('id', None)
                                            if id_value10 is not None:
                                                id_instance10 = id_value10
                                                backend_address_pool_instance.id = id_instance10
                                            
                                        probe_value = properties_value4.get('probe', None)
                                        if probe_value is not None:
                                            probe_instance = ResourceId()
                                            load_balancing_rule_json_format_instance.probe = probe_instance
                                            
                                            id_value11 = probe_value.get('id', None)
                                            if id_value11 is not None:
                                                id_instance11 = id_value11
                                                probe_instance.id = id_instance11
                                            
                                        protocol_value = properties_value4.get('protocol', None)
                                        if protocol_value is not None:
                                            protocol_instance = protocol_value
                                            load_balancing_rule_json_format_instance.protocol = protocol_instance
                                        
                                        load_distribution_value = properties_value4.get('loadDistribution', None)
                                        if load_distribution_value is not None:
                                            load_distribution_instance = load_distribution_value
                                            load_balancing_rule_json_format_instance.load_distribution = load_distribution_instance
                                        
                                        frontend_port_value = properties_value4.get('frontendPort', None)
                                        if frontend_port_value is not None:
                                            frontend_port_instance = frontend_port_value
                                            load_balancing_rule_json_format_instance.frontend_port = frontend_port_instance
                                        
                                        backend_port_value = properties_value4.get('backendPort', None)
                                        if backend_port_value is not None:
                                            backend_port_instance = backend_port_value
                                            load_balancing_rule_json_format_instance.backend_port = backend_port_instance
                                        
                                        idle_timeout_in_minutes_value = properties_value4.get('idleTimeoutInMinutes', None)
                                        if idle_timeout_in_minutes_value is not None:
                                            idle_timeout_in_minutes_instance = idle_timeout_in_minutes_value
                                            load_balancing_rule_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance
                                        
                                        enable_floating_ip_value = properties_value4.get('enableFloatingIP', None)
                                        if enable_floating_ip_value is not None:
                                            enable_floating_ip_instance = enable_floating_ip_value
                                            load_balancing_rule_json_format_instance.enable_floating_ip = enable_floating_ip_instance
                                        
                                        provisioning_state_value3 = properties_value4.get('provisioningState', None)
                                        if provisioning_state_value3 is not None:
                                            provisioning_state_instance3 = provisioning_state_value3
                                            load_balancing_rule_json_format_instance.provisioning_state = provisioning_state_instance3
                                        
                                    name_value3 = load_balancing_rules_value3.get('name', None)
                                    if name_value3 is not None:
                                        name_instance3 = name_value3
                                        load_balancing_rule_json_format_instance.name = name_instance3
                                    
                                    etag_value3 = load_balancing_rules_value3.get('etag', None)
                                    if etag_value3 is not None:
                                        etag_instance3 = etag_value3
                                        load_balancing_rule_json_format_instance.etag = etag_instance3
                                    
                                    id_value12 = load_balancing_rules_value3.get('id', None)
                                    if id_value12 is not None:
                                        id_instance12 = id_value12
                                        load_balancing_rule_json_format_instance.id = id_instance12
                                    
                            probes_array = properties_value.get('probes', None)
                            if probes_array is not None:
                                for probes_value in probes_array:
                                    probe_json_format_instance = Probe(load_balancing_rules=[])
                                    load_balancer_json_format_instance.probes.append(probe_json_format_instance)
                                    
                                    properties_value5 = probes_value.get('properties', None)
                                    if properties_value5 is not None:
                                        load_balancing_rules_array4 = properties_value5.get('loadBalancingRules', None)
                                        if load_balancing_rules_array4 is not None:
                                            for load_balancing_rules_value4 in load_balancing_rules_array4:
                                                resource_id_instance5 = ResourceId()
                                                probe_json_format_instance.load_balancing_rules.append(resource_id_instance5)
                                                
                                                id_value13 = load_balancing_rules_value4.get('id', None)
                                                if id_value13 is not None:
                                                    id_instance13 = id_value13
                                                    resource_id_instance5.id = id_instance13
                                                
                                        protocol_value2 = properties_value5.get('protocol', None)
                                        if protocol_value2 is not None:
                                            protocol_instance2 = protocol_value2
                                            probe_json_format_instance.protocol = protocol_instance2
                                        
                                        port_value = properties_value5.get('port', None)
                                        if port_value is not None:
                                            port_instance = port_value
                                            probe_json_format_instance.port = port_instance
                                        
                                        interval_in_seconds_value = properties_value5.get('intervalInSeconds', None)
                                        if interval_in_seconds_value is not None:
                                            interval_in_seconds_instance = interval_in_seconds_value
                                            probe_json_format_instance.interval_in_seconds = interval_in_seconds_instance
                                        
                                        number_of_probes_value = properties_value5.get('numberOfProbes', None)
                                        if number_of_probes_value is not None:
                                            number_of_probes_instance = number_of_probes_value
                                            probe_json_format_instance.number_of_probes = number_of_probes_instance
                                        
                                        request_path_value = properties_value5.get('requestPath', None)
                                        if request_path_value is not None:
                                            request_path_instance = request_path_value
                                            probe_json_format_instance.request_path = request_path_instance
                                        
                                        provisioning_state_value4 = properties_value5.get('provisioningState', None)
                                        if provisioning_state_value4 is not None:
                                            provisioning_state_instance4 = provisioning_state_value4
                                            probe_json_format_instance.provisioning_state = provisioning_state_instance4
                                        
                                    name_value4 = probes_value.get('name', None)
                                    if name_value4 is not None:
                                        name_instance4 = name_value4
                                        probe_json_format_instance.name = name_instance4
                                    
                                    etag_value4 = probes_value.get('etag', None)
                                    if etag_value4 is not None:
                                        etag_instance4 = etag_value4
                                        probe_json_format_instance.etag = etag_instance4
                                    
                                    id_value14 = probes_value.get('id', None)
                                    if id_value14 is not None:
                                        id_instance14 = id_value14
                                        probe_json_format_instance.id = id_instance14
                                    
                            inbound_nat_rules_array2 = properties_value.get('inboundNatRules', None)
                            if inbound_nat_rules_array2 is not None:
                                for inbound_nat_rules_value2 in inbound_nat_rules_array2:
                                    inbound_nat_rule_json_format_instance = InboundNatRule()
                                    load_balancer_json_format_instance.inbound_nat_rules.append(inbound_nat_rule_json_format_instance)
                                    
                                    properties_value6 = inbound_nat_rules_value2.get('properties', None)
                                    if properties_value6 is not None:
                                        frontend_ip_configuration_value2 = properties_value6.get('frontendIPConfiguration', None)
                                        if frontend_ip_configuration_value2 is not None:
                                            frontend_ip_configuration_instance2 = ResourceId()
                                            inbound_nat_rule_json_format_instance.frontend_ip_configuration = frontend_ip_configuration_instance2
                                            
                                            id_value15 = frontend_ip_configuration_value2.get('id', None)
                                            if id_value15 is not None:
                                                id_instance15 = id_value15
                                                frontend_ip_configuration_instance2.id = id_instance15
                                            
                                        backend_ip_configuration_value = properties_value6.get('backendIPConfiguration', None)
                                        if backend_ip_configuration_value is not None:
                                            backend_ip_configuration_instance = ResourceId()
                                            inbound_nat_rule_json_format_instance.backend_ip_configuration = backend_ip_configuration_instance
                                            
                                            id_value16 = backend_ip_configuration_value.get('id', None)
                                            if id_value16 is not None:
                                                id_instance16 = id_value16
                                                backend_ip_configuration_instance.id = id_instance16
                                            
                                        protocol_value3 = properties_value6.get('protocol', None)
                                        if protocol_value3 is not None:
                                            protocol_instance3 = protocol_value3
                                            inbound_nat_rule_json_format_instance.protocol = protocol_instance3
                                        
                                        frontend_port_value2 = properties_value6.get('frontendPort', None)
                                        if frontend_port_value2 is not None:
                                            frontend_port_instance2 = frontend_port_value2
                                            inbound_nat_rule_json_format_instance.frontend_port = frontend_port_instance2
                                        
                                        backend_port_value2 = properties_value6.get('backendPort', None)
                                        if backend_port_value2 is not None:
                                            backend_port_instance2 = backend_port_value2
                                            inbound_nat_rule_json_format_instance.backend_port = backend_port_instance2
                                        
                                        idle_timeout_in_minutes_value2 = properties_value6.get('idleTimeoutInMinutes', None)
                                        if idle_timeout_in_minutes_value2 is not None:
                                            idle_timeout_in_minutes_instance2 = idle_timeout_in_minutes_value2
                                            inbound_nat_rule_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance2
                                        
                                        enable_floating_ip_value2 = properties_value6.get('enableFloatingIP', None)
                                        if enable_floating_ip_value2 is not None:
                                            enable_floating_ip_instance2 = enable_floating_ip_value2
                                            inbound_nat_rule_json_format_instance.enable_floating_ip = enable_floating_ip_instance2
                                        
                                        provisioning_state_value5 = properties_value6.get('provisioningState', None)
                                        if provisioning_state_value5 is not None:
                                            provisioning_state_instance5 = provisioning_state_value5
                                            inbound_nat_rule_json_format_instance.provisioning_state = provisioning_state_instance5
                                        
                                    name_value5 = inbound_nat_rules_value2.get('name', None)
                                    if name_value5 is not None:
                                        name_instance5 = name_value5
                                        inbound_nat_rule_json_format_instance.name = name_instance5
                                    
                                    etag_value5 = inbound_nat_rules_value2.get('etag', None)
                                    if etag_value5 is not None:
                                        etag_instance5 = etag_value5
                                        inbound_nat_rule_json_format_instance.etag = etag_instance5
                                    
                                    id_value17 = inbound_nat_rules_value2.get('id', None)
                                    if id_value17 is not None:
                                        id_instance17 = id_value17
                                        inbound_nat_rule_json_format_instance.id = id_instance17
                                    
                            provisioning_state_value6 = properties_value.get('provisioningState', None)
                            if provisioning_state_value6 is not None:
                                provisioning_state_instance6 = provisioning_state_value6
                                load_balancer_json_format_instance.provisioning_state = provisioning_state_instance6
                            
                        etag_value6 = value_value.get('etag', None)
                        if etag_value6 is not None:
                            etag_instance6 = etag_value6
                            load_balancer_json_format_instance.etag = etag_instance6
                        
                        id_value18 = value_value.get('id', None)
                        if id_value18 is not None:
                            id_instance18 = id_value18
                            load_balancer_json_format_instance.id = id_instance18
                        
                        name_value6 = value_value.get('name', None)
                        if name_value6 is not None:
                            name_instance6 = name_value6
                            load_balancer_json_format_instance.name = name_instance6
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            load_balancer_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            load_balancer_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                load_balancer_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class LocalNetworkGatewayOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     Virtual network Gateway for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, local_network_gateway_name, parameters):
        """
         The Put LocalNetworkGateway operation creates/updates a local network
         gateway in the specified resource group through Network resource
         provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         local_network_gateway_name (string): The name of the local network
         gateway.
         
         parameters (LocalNetworkGateway): Parameters supplied to the Begin
         Create or update Local Network Gateway operation through Network
         resource provider.
         
         Returns:
         
         LocalNetworkGatewayPutResponse: Response for PutLocalNetworkGateway
         Api servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if local_network_gateway_name is None:
            raise ValueError('local_network_gateway_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/localNetworkGateways/'
        url = url + quote(local_network_gateway_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        local_network_gateway_json_format_value = {}
        request_doc = local_network_gateway_json_format_value
        
        properties_value = {}
        local_network_gateway_json_format_value['properties'] = properties_value
        
        if parameters.gateway_ip_address is not None:
            properties_value['gatewayIpAddress'] = parameters.gateway_ip_address
        
        if parameters.local_network_site_address_space is not None:
            local_network_site_address_space_value = {}
            properties_value['localNetworkSiteAddressSpace'] = local_network_site_address_space_value
            
            if parameters.local_network_site_address_space.address_prefixes is not None:
                address_prefixes_array = []
                for address_prefixes_item in parameters.local_network_site_address_space.address_prefixes:
                    address_prefixes_array.append(address_prefixes_item)
                
                local_network_site_address_space_value['addressPrefixes'] = address_prefixes_array
            
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            local_network_gateway_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            local_network_gateway_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            local_network_gateway_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            local_network_gateway_json_format_value['type'] = parameters.type
        
        local_network_gateway_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            local_network_gateway_json_format_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = LocalNetworkGatewayPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                local_network_gateway_instance = LocalNetworkGateway(tags={})
                result.local_network_gateway = local_network_gateway_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    gateway_ip_address_value = properties_value2.get('gatewayIpAddress', None)
                    if gateway_ip_address_value is not None:
                        gateway_ip_address_instance = gateway_ip_address_value
                        local_network_gateway_instance.gateway_ip_address = gateway_ip_address_instance
                    
                    local_network_site_address_space_value2 = properties_value2.get('localNetworkSiteAddressSpace', None)
                    if local_network_site_address_space_value2 is not None:
                        local_network_site_address_space_instance = AddressSpace(address_prefixes=[])
                        local_network_gateway_instance.local_network_site_address_space = local_network_site_address_space_instance
                        
                        address_prefixes_array2 = local_network_site_address_space_value2.get('addressPrefixes', None)
                        if address_prefixes_array2 is not None:
                            for address_prefixes_value in address_prefixes_array2:
                                local_network_site_address_space_instance.address_prefixes.append(address_prefixes_value)
                            
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        local_network_gateway_instance.provisioning_state = provisioning_state_instance
                    
                etag_value = response_doc.get('etag', None)
                if etag_value is not None:
                    etag_instance = etag_value
                    local_network_gateway_instance.etag = etag_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    local_network_gateway_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    local_network_gateway_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    local_network_gateway_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    local_network_gateway_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        local_network_gateway_instance.tags[tags_key2] = tags_value2
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, local_network_gateway_name):
        """
         The Delete LocalNetworkGateway operation deletes the specifed local
         network Gateway through Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         local_network_gateway_name (string): The name of the local network
         gateway.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if local_network_gateway_name is None:
            raise ValueError('local_network_gateway_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/localNetworkGateways/'
        url = url + quote(local_network_gateway_name)
        url = url + '/'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, local_network_gateway_name, parameters):
        """
         The Put LocalNetworkGateway operation creates/updates a local network
         gateway in the specified resource group through Network resource
         provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         local_network_gateway_name (string): The name of the local network
         gateway.
         
         parameters (LocalNetworkGateway): Parameters supplied to the Begin
         Create or update Local Network Gateway operation through Network
         resource provider.
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.local_network_gateways.begin_create_or_updating(resource_group_name, local_network_gateway_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, local_network_gateway_name):
        """
         The Delete LocalNetworkGateway operation deletes the specifed local
         network Gateway through Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         local_network_gateway_name (string): The name of the local network
         gateway.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.local_network_gateways.begin_deleting(resource_group_name, local_network_gateway_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, local_network_gateway_name):
        """
         The Get LocalNetworkGateway operation retrieves information about the
         specified local network gateway through Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         local_network_gateway_name (string): The name of the local network
         gateway.
         
         Returns:
         
         LocalNetworkGatewayGetResponse: Response for GetLocalNetworkgateway
         Api servive call.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if local_network_gateway_name is None:
            raise ValueError('local_network_gateway_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/localNetworkGateways/'
        url = url + quote(local_network_gateway_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = LocalNetworkGatewayGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                local_network_gateway_instance = LocalNetworkGateway(tags={})
                result.local_network_gateway = local_network_gateway_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    gateway_ip_address_value = properties_value.get('gatewayIpAddress', None)
                    if gateway_ip_address_value is not None:
                        gateway_ip_address_instance = gateway_ip_address_value
                        local_network_gateway_instance.gateway_ip_address = gateway_ip_address_instance
                    
                    local_network_site_address_space_value = properties_value.get('localNetworkSiteAddressSpace', None)
                    if local_network_site_address_space_value is not None:
                        local_network_site_address_space_instance = AddressSpace(address_prefixes=[])
                        local_network_gateway_instance.local_network_site_address_space = local_network_site_address_space_instance
                        
                        address_prefixes_array = local_network_site_address_space_value.get('addressPrefixes', None)
                        if address_prefixes_array is not None:
                            for address_prefixes_value in address_prefixes_array:
                                local_network_site_address_space_instance.address_prefixes.append(address_prefixes_value)
                            
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        local_network_gateway_instance.provisioning_state = provisioning_state_instance
                    
                etag_value = response_doc.get('etag', None)
                if etag_value is not None:
                    etag_instance = etag_value
                    local_network_gateway_instance.etag = etag_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    local_network_gateway_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    local_network_gateway_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    local_network_gateway_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    local_network_gateway_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        local_network_gateway_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The List LocalNetworkGateways opertion retrieves all the local network
         gateways stored.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         LocalNetworkGatewayListResponse: Response for ListLocalNetworkGateways
         Api service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/localNetworkGateways'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = LocalNetworkGatewayListResponse(local_network_gateways=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        local_network_gateway_json_format_instance = LocalNetworkGateway(tags={})
                        result.local_network_gateways.append(local_network_gateway_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            gateway_ip_address_value = properties_value.get('gatewayIpAddress', None)
                            if gateway_ip_address_value is not None:
                                gateway_ip_address_instance = gateway_ip_address_value
                                local_network_gateway_json_format_instance.gateway_ip_address = gateway_ip_address_instance
                            
                            local_network_site_address_space_value = properties_value.get('localNetworkSiteAddressSpace', None)
                            if local_network_site_address_space_value is not None:
                                local_network_site_address_space_instance = AddressSpace(address_prefixes=[])
                                local_network_gateway_json_format_instance.local_network_site_address_space = local_network_site_address_space_instance
                                
                                address_prefixes_array = local_network_site_address_space_value.get('addressPrefixes', None)
                                if address_prefixes_array is not None:
                                    for address_prefixes_value in address_prefixes_array:
                                        local_network_site_address_space_instance.address_prefixes.append(address_prefixes_value)
                                    
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                local_network_gateway_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        etag_value = value_value.get('etag', None)
                        if etag_value is not None:
                            etag_instance = etag_value
                            local_network_gateway_json_format_instance.etag = etag_instance
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            local_network_gateway_json_format_instance.id = id_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            local_network_gateway_json_format_instance.name = name_instance
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            local_network_gateway_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            local_network_gateway_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                local_network_gateway_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class NetworkInterfaceOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     subnets for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, network_interface_name, parameters):
        """
         The Put NetworkInterface operation creates/updates a networkInterface
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_interface_name (string): The name of the network interface.
         
         parameters (NetworkInterface): Parameters supplied to the
         create/update NetworkInterface operation
         
         Returns:
         
         NetworkInterfacePutResponse: Response for PutNetworkInterface Api
         servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_interface_name is None:
            raise ValueError('network_interface_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkInterfaces/'
        url = url + quote(network_interface_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        network_interface_json_format_value = {}
        request_doc = network_interface_json_format_value
        
        properties_value = {}
        network_interface_json_format_value['properties'] = properties_value
        
        if parameters.virtual_machine is not None:
            virtual_machine_value = {}
            properties_value['virtualMachine'] = virtual_machine_value
            
            if parameters.virtual_machine.id is not None:
                virtual_machine_value['id'] = parameters.virtual_machine.id
            
        if parameters.network_security_group is not None:
            network_security_group_value = {}
            properties_value['networkSecurityGroup'] = network_security_group_value
            
            if parameters.network_security_group.id is not None:
                network_security_group_value['id'] = parameters.network_security_group.id
            
        if parameters.ip_configurations is not None:
            ip_configurations_array = []
            for ip_configurations_item in parameters.ip_configurations:
                network_interface_ip_configuration_json_format_value = {}
                ip_configurations_array.append(network_interface_ip_configuration_json_format_value)
                
                properties_value2 = {}
                network_interface_ip_configuration_json_format_value['properties'] = properties_value2
                
                if ip_configurations_item.private_ip_address is not None:
                    properties_value2['privateIPAddress'] = ip_configurations_item.private_ip_address
                
                if ip_configurations_item.private_ip_allocation_method is not None:
                    properties_value2['privateIPAllocationMethod'] = ip_configurations_item.private_ip_allocation_method
                
                if ip_configurations_item.subnet is not None:
                    subnet_value = {}
                    properties_value2['subnet'] = subnet_value
                    
                    if ip_configurations_item.subnet.id is not None:
                        subnet_value['id'] = ip_configurations_item.subnet.id
                    
                if ip_configurations_item.public_ip_address is not None:
                    public_ip_address_value = {}
                    properties_value2['publicIPAddress'] = public_ip_address_value
                    
                    if ip_configurations_item.public_ip_address.id is not None:
                        public_ip_address_value['id'] = ip_configurations_item.public_ip_address.id
                    
                if ip_configurations_item.load_balancer_backend_address_pools is not None:
                    load_balancer_backend_address_pools_array = []
                    for load_balancer_backend_address_pools_item in ip_configurations_item.load_balancer_backend_address_pools:
                        resource_id_value = {}
                        load_balancer_backend_address_pools_array.append(resource_id_value)
                        
                        if load_balancer_backend_address_pools_item.id is not None:
                            resource_id_value['id'] = load_balancer_backend_address_pools_item.id
                        
                    properties_value2['loadBalancerBackendAddressPools'] = load_balancer_backend_address_pools_array
                
                if ip_configurations_item.load_balancer_inbound_nat_rules is not None:
                    load_balancer_inbound_nat_rules_array = []
                    for load_balancer_inbound_nat_rules_item in ip_configurations_item.load_balancer_inbound_nat_rules:
                        resource_id_value2 = {}
                        load_balancer_inbound_nat_rules_array.append(resource_id_value2)
                        
                        if load_balancer_inbound_nat_rules_item.id is not None:
                            resource_id_value2['id'] = load_balancer_inbound_nat_rules_item.id
                        
                    properties_value2['loadBalancerInboundNatRules'] = load_balancer_inbound_nat_rules_array
                
                if ip_configurations_item.provisioning_state is not None:
                    properties_value2['provisioningState'] = ip_configurations_item.provisioning_state
                
                if ip_configurations_item.name is not None:
                    network_interface_ip_configuration_json_format_value['name'] = ip_configurations_item.name
                
                if ip_configurations_item.etag is not None:
                    network_interface_ip_configuration_json_format_value['etag'] = ip_configurations_item.etag
                
                if ip_configurations_item.id is not None:
                    network_interface_ip_configuration_json_format_value['id'] = ip_configurations_item.id
                
            properties_value['ipConfigurations'] = ip_configurations_array
        
        if parameters.dns_settings is not None:
            dns_settings_value = {}
            properties_value['dnsSettings'] = dns_settings_value
            
            if parameters.dns_settings.dns_servers is not None:
                dns_servers_array = []
                for dns_servers_item in parameters.dns_settings.dns_servers:
                    dns_servers_array.append(dns_servers_item)
                
                dns_settings_value['dnsServers'] = dns_servers_array
            
            if parameters.dns_settings.applied_dns_servers is not None:
                applied_dns_servers_array = []
                for applied_dns_servers_item in parameters.dns_settings.applied_dns_servers:
                    applied_dns_servers_array.append(applied_dns_servers_item)
                
                dns_settings_value['appliedDnsServers'] = applied_dns_servers_array
            
        if parameters.mac_address is not None:
            properties_value['macAddress'] = parameters.mac_address
        
        if parameters.primary is not None:
            properties_value['primary'] = parameters.primary
        
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            network_interface_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            network_interface_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            network_interface_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            network_interface_json_format_value['type'] = parameters.type
        
        network_interface_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            network_interface_json_format_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = NetworkInterfacePutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                network_interface_instance = NetworkInterface(ip_configurations=[], tags={})
                result.network_interface = network_interface_instance
                
                properties_value3 = response_doc.get('properties', None)
                if properties_value3 is not None:
                    virtual_machine_value2 = properties_value3.get('virtualMachine', None)
                    if virtual_machine_value2 is not None:
                        virtual_machine_instance = ResourceId()
                        network_interface_instance.virtual_machine = virtual_machine_instance
                        
                        id_value = virtual_machine_value2.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            virtual_machine_instance.id = id_instance
                        
                    network_security_group_value2 = properties_value3.get('networkSecurityGroup', None)
                    if network_security_group_value2 is not None:
                        network_security_group_instance = ResourceId()
                        network_interface_instance.network_security_group = network_security_group_instance
                        
                        id_value2 = network_security_group_value2.get('id', None)
                        if id_value2 is not None:
                            id_instance2 = id_value2
                            network_security_group_instance.id = id_instance2
                        
                    ip_configurations_array2 = properties_value3.get('ipConfigurations', None)
                    if ip_configurations_array2 is not None:
                        for ip_configurations_value in ip_configurations_array2:
                            network_interface_ip_configuration_json_format_instance = NetworkInterfaceIpConfiguration(load_balancer_backend_address_pools=[], load_balancer_inbound_nat_rules=[])
                            network_interface_instance.ip_configurations.append(network_interface_ip_configuration_json_format_instance)
                            
                            properties_value4 = ip_configurations_value.get('properties', None)
                            if properties_value4 is not None:
                                private_ip_address_value = properties_value4.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    network_interface_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = properties_value4.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    network_interface_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value2 = properties_value4.get('subnet', None)
                                if subnet_value2 is not None:
                                    subnet_instance = ResourceId()
                                    network_interface_ip_configuration_json_format_instance.subnet = subnet_instance
                                    
                                    id_value3 = subnet_value2.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        subnet_instance.id = id_instance3
                                    
                                public_ip_address_value2 = properties_value4.get('publicIPAddress', None)
                                if public_ip_address_value2 is not None:
                                    public_ip_address_instance = ResourceId()
                                    network_interface_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value4 = public_ip_address_value2.get('id', None)
                                    if id_value4 is not None:
                                        id_instance4 = id_value4
                                        public_ip_address_instance.id = id_instance4
                                    
                                load_balancer_backend_address_pools_array2 = properties_value4.get('loadBalancerBackendAddressPools', None)
                                if load_balancer_backend_address_pools_array2 is not None:
                                    for load_balancer_backend_address_pools_value in load_balancer_backend_address_pools_array2:
                                        resource_id_instance = ResourceId()
                                        network_interface_ip_configuration_json_format_instance.load_balancer_backend_address_pools.append(resource_id_instance)
                                        
                                        id_value5 = load_balancer_backend_address_pools_value.get('id', None)
                                        if id_value5 is not None:
                                            id_instance5 = id_value5
                                            resource_id_instance.id = id_instance5
                                        
                                load_balancer_inbound_nat_rules_array2 = properties_value4.get('loadBalancerInboundNatRules', None)
                                if load_balancer_inbound_nat_rules_array2 is not None:
                                    for load_balancer_inbound_nat_rules_value in load_balancer_inbound_nat_rules_array2:
                                        resource_id_instance2 = ResourceId()
                                        network_interface_ip_configuration_json_format_instance.load_balancer_inbound_nat_rules.append(resource_id_instance2)
                                        
                                        id_value6 = load_balancer_inbound_nat_rules_value.get('id', None)
                                        if id_value6 is not None:
                                            id_instance6 = id_value6
                                            resource_id_instance2.id = id_instance6
                                        
                                provisioning_state_value = properties_value4.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    network_interface_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = ip_configurations_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                network_interface_ip_configuration_json_format_instance.name = name_instance
                            
                            etag_value = ip_configurations_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                network_interface_ip_configuration_json_format_instance.etag = etag_instance
                            
                            id_value7 = ip_configurations_value.get('id', None)
                            if id_value7 is not None:
                                id_instance7 = id_value7
                                network_interface_ip_configuration_json_format_instance.id = id_instance7
                            
                    dns_settings_value2 = properties_value3.get('dnsSettings', None)
                    if dns_settings_value2 is not None:
                        dns_settings_instance = DnsSettings(applied_dns_servers=[], dns_servers=[])
                        network_interface_instance.dns_settings = dns_settings_instance
                        
                        dns_servers_array2 = dns_settings_value2.get('dnsServers', None)
                        if dns_servers_array2 is not None:
                            for dns_servers_value in dns_servers_array2:
                                dns_settings_instance.dns_servers.append(dns_servers_value)
                            
                        applied_dns_servers_array2 = dns_settings_value2.get('appliedDnsServers', None)
                        if applied_dns_servers_array2 is not None:
                            for applied_dns_servers_value in applied_dns_servers_array2:
                                dns_settings_instance.applied_dns_servers.append(applied_dns_servers_value)
                            
                    mac_address_value = properties_value3.get('macAddress', None)
                    if mac_address_value is not None:
                        mac_address_instance = mac_address_value
                        network_interface_instance.mac_address = mac_address_instance
                    
                    primary_value = properties_value3.get('primary', None)
                    if primary_value is not None:
                        primary_instance = primary_value
                        network_interface_instance.primary = primary_instance
                    
                    provisioning_state_value2 = properties_value3.get('provisioningState', None)
                    if provisioning_state_value2 is not None:
                        provisioning_state_instance2 = provisioning_state_value2
                        network_interface_instance.provisioning_state = provisioning_state_instance2
                    
                etag_value2 = response_doc.get('etag', None)
                if etag_value2 is not None:
                    etag_instance2 = etag_value2
                    network_interface_instance.etag = etag_instance2
                
                id_value8 = response_doc.get('id', None)
                if id_value8 is not None:
                    id_instance8 = id_value8
                    network_interface_instance.id = id_instance8
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    network_interface_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    network_interface_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    network_interface_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        network_interface_instance.tags[tags_key2] = tags_value2
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        
        return result
    
    def begin_deleting(self, resource_group_name, network_interface_name):
        """
         The delete netwokInterface operation deletes the specified
         netwokInterface.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_interface_name (string): The name of the network interface.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_interface_name is None:
            raise ValueError('network_interface_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkInterfaces/'
        url = url + quote(network_interface_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, network_interface_name, parameters):
        """
         The Put NetworkInterface operation creates/updates a networkInterface
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_interface_name (string): The name of the network interface.
         
         parameters (NetworkInterface): Parameters supplied to the
         create/update NetworkInterface operation
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.network_interfaces.begin_create_or_updating(resource_group_name, network_interface_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, network_interface_name):
        """
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_interface_name (string): The name of the network interface.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.network_interfaces.begin_deleting(resource_group_name, network_interface_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, network_interface_name):
        """
         The Get ntework interface operation retreives information about the
         specified network interface.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_interface_name (string): The name of the network interface.
         
         Returns:
         
         NetworkInterfaceGetResponse: Response for GetNetworkInterface Api
         service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_interface_name is None:
            raise ValueError('network_interface_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkInterfaces/'
        url = url + quote(network_interface_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = NetworkInterfaceGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                network_interface_instance = NetworkInterface(ip_configurations=[], tags={})
                result.network_interface = network_interface_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    virtual_machine_value = properties_value.get('virtualMachine', None)
                    if virtual_machine_value is not None:
                        virtual_machine_instance = ResourceId()
                        network_interface_instance.virtual_machine = virtual_machine_instance
                        
                        id_value = virtual_machine_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            virtual_machine_instance.id = id_instance
                        
                    network_security_group_value = properties_value.get('networkSecurityGroup', None)
                    if network_security_group_value is not None:
                        network_security_group_instance = ResourceId()
                        network_interface_instance.network_security_group = network_security_group_instance
                        
                        id_value2 = network_security_group_value.get('id', None)
                        if id_value2 is not None:
                            id_instance2 = id_value2
                            network_security_group_instance.id = id_instance2
                        
                    ip_configurations_array = properties_value.get('ipConfigurations', None)
                    if ip_configurations_array is not None:
                        for ip_configurations_value in ip_configurations_array:
                            network_interface_ip_configuration_json_format_instance = NetworkInterfaceIpConfiguration(load_balancer_backend_address_pools=[], load_balancer_inbound_nat_rules=[])
                            network_interface_instance.ip_configurations.append(network_interface_ip_configuration_json_format_instance)
                            
                            properties_value2 = ip_configurations_value.get('properties', None)
                            if properties_value2 is not None:
                                private_ip_address_value = properties_value2.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    network_interface_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = properties_value2.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    network_interface_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value = properties_value2.get('subnet', None)
                                if subnet_value is not None:
                                    subnet_instance = ResourceId()
                                    network_interface_ip_configuration_json_format_instance.subnet = subnet_instance
                                    
                                    id_value3 = subnet_value.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        subnet_instance.id = id_instance3
                                    
                                public_ip_address_value = properties_value2.get('publicIPAddress', None)
                                if public_ip_address_value is not None:
                                    public_ip_address_instance = ResourceId()
                                    network_interface_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value4 = public_ip_address_value.get('id', None)
                                    if id_value4 is not None:
                                        id_instance4 = id_value4
                                        public_ip_address_instance.id = id_instance4
                                    
                                load_balancer_backend_address_pools_array = properties_value2.get('loadBalancerBackendAddressPools', None)
                                if load_balancer_backend_address_pools_array is not None:
                                    for load_balancer_backend_address_pools_value in load_balancer_backend_address_pools_array:
                                        resource_id_instance = ResourceId()
                                        network_interface_ip_configuration_json_format_instance.load_balancer_backend_address_pools.append(resource_id_instance)
                                        
                                        id_value5 = load_balancer_backend_address_pools_value.get('id', None)
                                        if id_value5 is not None:
                                            id_instance5 = id_value5
                                            resource_id_instance.id = id_instance5
                                        
                                load_balancer_inbound_nat_rules_array = properties_value2.get('loadBalancerInboundNatRules', None)
                                if load_balancer_inbound_nat_rules_array is not None:
                                    for load_balancer_inbound_nat_rules_value in load_balancer_inbound_nat_rules_array:
                                        resource_id_instance2 = ResourceId()
                                        network_interface_ip_configuration_json_format_instance.load_balancer_inbound_nat_rules.append(resource_id_instance2)
                                        
                                        id_value6 = load_balancer_inbound_nat_rules_value.get('id', None)
                                        if id_value6 is not None:
                                            id_instance6 = id_value6
                                            resource_id_instance2.id = id_instance6
                                        
                                provisioning_state_value = properties_value2.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    network_interface_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = ip_configurations_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                network_interface_ip_configuration_json_format_instance.name = name_instance
                            
                            etag_value = ip_configurations_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                network_interface_ip_configuration_json_format_instance.etag = etag_instance
                            
                            id_value7 = ip_configurations_value.get('id', None)
                            if id_value7 is not None:
                                id_instance7 = id_value7
                                network_interface_ip_configuration_json_format_instance.id = id_instance7
                            
                    dns_settings_value = properties_value.get('dnsSettings', None)
                    if dns_settings_value is not None:
                        dns_settings_instance = DnsSettings(applied_dns_servers=[], dns_servers=[])
                        network_interface_instance.dns_settings = dns_settings_instance
                        
                        dns_servers_array = dns_settings_value.get('dnsServers', None)
                        if dns_servers_array is not None:
                            for dns_servers_value in dns_servers_array:
                                dns_settings_instance.dns_servers.append(dns_servers_value)
                            
                        applied_dns_servers_array = dns_settings_value.get('appliedDnsServers', None)
                        if applied_dns_servers_array is not None:
                            for applied_dns_servers_value in applied_dns_servers_array:
                                dns_settings_instance.applied_dns_servers.append(applied_dns_servers_value)
                            
                    mac_address_value = properties_value.get('macAddress', None)
                    if mac_address_value is not None:
                        mac_address_instance = mac_address_value
                        network_interface_instance.mac_address = mac_address_instance
                    
                    primary_value = properties_value.get('primary', None)
                    if primary_value is not None:
                        primary_instance = primary_value
                        network_interface_instance.primary = primary_instance
                    
                    provisioning_state_value2 = properties_value.get('provisioningState', None)
                    if provisioning_state_value2 is not None:
                        provisioning_state_instance2 = provisioning_state_value2
                        network_interface_instance.provisioning_state = provisioning_state_instance2
                    
                etag_value2 = response_doc.get('etag', None)
                if etag_value2 is not None:
                    etag_instance2 = etag_value2
                    network_interface_instance.etag = etag_instance2
                
                id_value8 = response_doc.get('id', None)
                if id_value8 is not None:
                    id_instance8 = id_value8
                    network_interface_instance.id = id_instance8
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    network_interface_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    network_interface_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    network_interface_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        network_interface_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The List networkInterfaces opertion retrieves all the
         networkInterfaces in a resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         NetworkInterfaceListResponse: Response for ListNetworkInterface Api
         service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkInterfaces'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = NetworkInterfaceListResponse(network_interfaces=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        network_interface_json_format_instance = NetworkInterface(ip_configurations=[], tags={})
                        result.network_interfaces.append(network_interface_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            virtual_machine_value = properties_value.get('virtualMachine', None)
                            if virtual_machine_value is not None:
                                virtual_machine_instance = ResourceId()
                                network_interface_json_format_instance.virtual_machine = virtual_machine_instance
                                
                                id_value = virtual_machine_value.get('id', None)
                                if id_value is not None:
                                    id_instance = id_value
                                    virtual_machine_instance.id = id_instance
                                
                            network_security_group_value = properties_value.get('networkSecurityGroup', None)
                            if network_security_group_value is not None:
                                network_security_group_instance = ResourceId()
                                network_interface_json_format_instance.network_security_group = network_security_group_instance
                                
                                id_value2 = network_security_group_value.get('id', None)
                                if id_value2 is not None:
                                    id_instance2 = id_value2
                                    network_security_group_instance.id = id_instance2
                                
                            ip_configurations_array = properties_value.get('ipConfigurations', None)
                            if ip_configurations_array is not None:
                                for ip_configurations_value in ip_configurations_array:
                                    network_interface_ip_configuration_json_format_instance = NetworkInterfaceIpConfiguration(load_balancer_backend_address_pools=[], load_balancer_inbound_nat_rules=[])
                                    network_interface_json_format_instance.ip_configurations.append(network_interface_ip_configuration_json_format_instance)
                                    
                                    properties_value2 = ip_configurations_value.get('properties', None)
                                    if properties_value2 is not None:
                                        private_ip_address_value = properties_value2.get('privateIPAddress', None)
                                        if private_ip_address_value is not None:
                                            private_ip_address_instance = private_ip_address_value
                                            network_interface_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                        
                                        private_ip_allocation_method_value = properties_value2.get('privateIPAllocationMethod', None)
                                        if private_ip_allocation_method_value is not None:
                                            private_ip_allocation_method_instance = private_ip_allocation_method_value
                                            network_interface_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                        
                                        subnet_value = properties_value2.get('subnet', None)
                                        if subnet_value is not None:
                                            subnet_instance = ResourceId()
                                            network_interface_ip_configuration_json_format_instance.subnet = subnet_instance
                                            
                                            id_value3 = subnet_value.get('id', None)
                                            if id_value3 is not None:
                                                id_instance3 = id_value3
                                                subnet_instance.id = id_instance3
                                            
                                        public_ip_address_value = properties_value2.get('publicIPAddress', None)
                                        if public_ip_address_value is not None:
                                            public_ip_address_instance = ResourceId()
                                            network_interface_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                            
                                            id_value4 = public_ip_address_value.get('id', None)
                                            if id_value4 is not None:
                                                id_instance4 = id_value4
                                                public_ip_address_instance.id = id_instance4
                                            
                                        load_balancer_backend_address_pools_array = properties_value2.get('loadBalancerBackendAddressPools', None)
                                        if load_balancer_backend_address_pools_array is not None:
                                            for load_balancer_backend_address_pools_value in load_balancer_backend_address_pools_array:
                                                resource_id_instance = ResourceId()
                                                network_interface_ip_configuration_json_format_instance.load_balancer_backend_address_pools.append(resource_id_instance)
                                                
                                                id_value5 = load_balancer_backend_address_pools_value.get('id', None)
                                                if id_value5 is not None:
                                                    id_instance5 = id_value5
                                                    resource_id_instance.id = id_instance5
                                                
                                        load_balancer_inbound_nat_rules_array = properties_value2.get('loadBalancerInboundNatRules', None)
                                        if load_balancer_inbound_nat_rules_array is not None:
                                            for load_balancer_inbound_nat_rules_value in load_balancer_inbound_nat_rules_array:
                                                resource_id_instance2 = ResourceId()
                                                network_interface_ip_configuration_json_format_instance.load_balancer_inbound_nat_rules.append(resource_id_instance2)
                                                
                                                id_value6 = load_balancer_inbound_nat_rules_value.get('id', None)
                                                if id_value6 is not None:
                                                    id_instance6 = id_value6
                                                    resource_id_instance2.id = id_instance6
                                                
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            network_interface_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = ip_configurations_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        network_interface_ip_configuration_json_format_instance.name = name_instance
                                    
                                    etag_value = ip_configurations_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        network_interface_ip_configuration_json_format_instance.etag = etag_instance
                                    
                                    id_value7 = ip_configurations_value.get('id', None)
                                    if id_value7 is not None:
                                        id_instance7 = id_value7
                                        network_interface_ip_configuration_json_format_instance.id = id_instance7
                                    
                            dns_settings_value = properties_value.get('dnsSettings', None)
                            if dns_settings_value is not None:
                                dns_settings_instance = DnsSettings(applied_dns_servers=[], dns_servers=[])
                                network_interface_json_format_instance.dns_settings = dns_settings_instance
                                
                                dns_servers_array = dns_settings_value.get('dnsServers', None)
                                if dns_servers_array is not None:
                                    for dns_servers_value in dns_servers_array:
                                        dns_settings_instance.dns_servers.append(dns_servers_value)
                                    
                                applied_dns_servers_array = dns_settings_value.get('appliedDnsServers', None)
                                if applied_dns_servers_array is not None:
                                    for applied_dns_servers_value in applied_dns_servers_array:
                                        dns_settings_instance.applied_dns_servers.append(applied_dns_servers_value)
                                    
                            mac_address_value = properties_value.get('macAddress', None)
                            if mac_address_value is not None:
                                mac_address_instance = mac_address_value
                                network_interface_json_format_instance.mac_address = mac_address_instance
                            
                            primary_value = properties_value.get('primary', None)
                            if primary_value is not None:
                                primary_instance = primary_value
                                network_interface_json_format_instance.primary = primary_instance
                            
                            provisioning_state_value2 = properties_value.get('provisioningState', None)
                            if provisioning_state_value2 is not None:
                                provisioning_state_instance2 = provisioning_state_value2
                                network_interface_json_format_instance.provisioning_state = provisioning_state_instance2
                            
                        etag_value2 = value_value.get('etag', None)
                        if etag_value2 is not None:
                            etag_instance2 = etag_value2
                            network_interface_json_format_instance.etag = etag_instance2
                        
                        id_value8 = value_value.get('id', None)
                        if id_value8 is not None:
                            id_instance8 = id_value8
                            network_interface_json_format_instance.id = id_instance8
                        
                        name_value2 = value_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            network_interface_json_format_instance.name = name_instance2
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            network_interface_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            network_interface_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                network_interface_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_all(self):
        """
         The List networkInterfaces opertion retrieves all the
         networkInterfaces in a subscription.
         
         Returns:
         
         NetworkInterfaceListResponse: Response for ListNetworkInterface Api
         service call
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkInterfaces'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = NetworkInterfaceListResponse(network_interfaces=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        network_interface_json_format_instance = NetworkInterface(ip_configurations=[], tags={})
                        result.network_interfaces.append(network_interface_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            virtual_machine_value = properties_value.get('virtualMachine', None)
                            if virtual_machine_value is not None:
                                virtual_machine_instance = ResourceId()
                                network_interface_json_format_instance.virtual_machine = virtual_machine_instance
                                
                                id_value = virtual_machine_value.get('id', None)
                                if id_value is not None:
                                    id_instance = id_value
                                    virtual_machine_instance.id = id_instance
                                
                            network_security_group_value = properties_value.get('networkSecurityGroup', None)
                            if network_security_group_value is not None:
                                network_security_group_instance = ResourceId()
                                network_interface_json_format_instance.network_security_group = network_security_group_instance
                                
                                id_value2 = network_security_group_value.get('id', None)
                                if id_value2 is not None:
                                    id_instance2 = id_value2
                                    network_security_group_instance.id = id_instance2
                                
                            ip_configurations_array = properties_value.get('ipConfigurations', None)
                            if ip_configurations_array is not None:
                                for ip_configurations_value in ip_configurations_array:
                                    network_interface_ip_configuration_json_format_instance = NetworkInterfaceIpConfiguration(load_balancer_backend_address_pools=[], load_balancer_inbound_nat_rules=[])
                                    network_interface_json_format_instance.ip_configurations.append(network_interface_ip_configuration_json_format_instance)
                                    
                                    properties_value2 = ip_configurations_value.get('properties', None)
                                    if properties_value2 is not None:
                                        private_ip_address_value = properties_value2.get('privateIPAddress', None)
                                        if private_ip_address_value is not None:
                                            private_ip_address_instance = private_ip_address_value
                                            network_interface_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                        
                                        private_ip_allocation_method_value = properties_value2.get('privateIPAllocationMethod', None)
                                        if private_ip_allocation_method_value is not None:
                                            private_ip_allocation_method_instance = private_ip_allocation_method_value
                                            network_interface_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                        
                                        subnet_value = properties_value2.get('subnet', None)
                                        if subnet_value is not None:
                                            subnet_instance = ResourceId()
                                            network_interface_ip_configuration_json_format_instance.subnet = subnet_instance
                                            
                                            id_value3 = subnet_value.get('id', None)
                                            if id_value3 is not None:
                                                id_instance3 = id_value3
                                                subnet_instance.id = id_instance3
                                            
                                        public_ip_address_value = properties_value2.get('publicIPAddress', None)
                                        if public_ip_address_value is not None:
                                            public_ip_address_instance = ResourceId()
                                            network_interface_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                            
                                            id_value4 = public_ip_address_value.get('id', None)
                                            if id_value4 is not None:
                                                id_instance4 = id_value4
                                                public_ip_address_instance.id = id_instance4
                                            
                                        load_balancer_backend_address_pools_array = properties_value2.get('loadBalancerBackendAddressPools', None)
                                        if load_balancer_backend_address_pools_array is not None:
                                            for load_balancer_backend_address_pools_value in load_balancer_backend_address_pools_array:
                                                resource_id_instance = ResourceId()
                                                network_interface_ip_configuration_json_format_instance.load_balancer_backend_address_pools.append(resource_id_instance)
                                                
                                                id_value5 = load_balancer_backend_address_pools_value.get('id', None)
                                                if id_value5 is not None:
                                                    id_instance5 = id_value5
                                                    resource_id_instance.id = id_instance5
                                                
                                        load_balancer_inbound_nat_rules_array = properties_value2.get('loadBalancerInboundNatRules', None)
                                        if load_balancer_inbound_nat_rules_array is not None:
                                            for load_balancer_inbound_nat_rules_value in load_balancer_inbound_nat_rules_array:
                                                resource_id_instance2 = ResourceId()
                                                network_interface_ip_configuration_json_format_instance.load_balancer_inbound_nat_rules.append(resource_id_instance2)
                                                
                                                id_value6 = load_balancer_inbound_nat_rules_value.get('id', None)
                                                if id_value6 is not None:
                                                    id_instance6 = id_value6
                                                    resource_id_instance2.id = id_instance6
                                                
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            network_interface_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = ip_configurations_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        network_interface_ip_configuration_json_format_instance.name = name_instance
                                    
                                    etag_value = ip_configurations_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        network_interface_ip_configuration_json_format_instance.etag = etag_instance
                                    
                                    id_value7 = ip_configurations_value.get('id', None)
                                    if id_value7 is not None:
                                        id_instance7 = id_value7
                                        network_interface_ip_configuration_json_format_instance.id = id_instance7
                                    
                            dns_settings_value = properties_value.get('dnsSettings', None)
                            if dns_settings_value is not None:
                                dns_settings_instance = DnsSettings(applied_dns_servers=[], dns_servers=[])
                                network_interface_json_format_instance.dns_settings = dns_settings_instance
                                
                                dns_servers_array = dns_settings_value.get('dnsServers', None)
                                if dns_servers_array is not None:
                                    for dns_servers_value in dns_servers_array:
                                        dns_settings_instance.dns_servers.append(dns_servers_value)
                                    
                                applied_dns_servers_array = dns_settings_value.get('appliedDnsServers', None)
                                if applied_dns_servers_array is not None:
                                    for applied_dns_servers_value in applied_dns_servers_array:
                                        dns_settings_instance.applied_dns_servers.append(applied_dns_servers_value)
                                    
                            mac_address_value = properties_value.get('macAddress', None)
                            if mac_address_value is not None:
                                mac_address_instance = mac_address_value
                                network_interface_json_format_instance.mac_address = mac_address_instance
                            
                            primary_value = properties_value.get('primary', None)
                            if primary_value is not None:
                                primary_instance = primary_value
                                network_interface_json_format_instance.primary = primary_instance
                            
                            provisioning_state_value2 = properties_value.get('provisioningState', None)
                            if provisioning_state_value2 is not None:
                                provisioning_state_instance2 = provisioning_state_value2
                                network_interface_json_format_instance.provisioning_state = provisioning_state_instance2
                            
                        etag_value2 = value_value.get('etag', None)
                        if etag_value2 is not None:
                            etag_instance2 = etag_value2
                            network_interface_json_format_instance.etag = etag_instance2
                        
                        id_value8 = value_value.get('id', None)
                        if id_value8 is not None:
                            id_instance8 = id_value8
                            network_interface_json_format_instance.id = id_instance8
                        
                        name_value2 = value_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            network_interface_json_format_instance.name = name_instance2
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            network_interface_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            network_interface_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                network_interface_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class NetworkSecurityGroupOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     NetworkSecurityGroups for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, network_security_group_name, parameters):
        """
         The Put NetworkSecurityGroup operation creates/updates a network
         security groupin the specified resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         parameters (NetworkSecurityGroup): Parameters supplied to the
         create/update Network Security Group operation
         
         Returns:
         
         NetworkSecurityGroupPutResponse: Response for PUT
         NetworkSecurityGroups Api servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_security_group_name is None:
            raise ValueError('network_security_group_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.default_security_rules is not None:
            for default_security_rules_parameter_item in parameters.default_security_rules:
                if default_security_rules_parameter_item.access is None:
                    raise ValueError('parameters.default_security_rules.access cannot be None.')
                
                if default_security_rules_parameter_item.destination_address_prefix is None:
                    raise ValueError('parameters.default_security_rules.destination_address_prefix cannot be None.')
                
                if default_security_rules_parameter_item.direction is None:
                    raise ValueError('parameters.default_security_rules.direction cannot be None.')
                
                if default_security_rules_parameter_item.protocol is None:
                    raise ValueError('parameters.default_security_rules.protocol cannot be None.')
                
                if default_security_rules_parameter_item.source_address_prefix is None:
                    raise ValueError('parameters.default_security_rules.source_address_prefix cannot be None.')
                
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        if parameters.security_rules is not None:
            for security_rules_parameter_item in parameters.security_rules:
                if security_rules_parameter_item.access is None:
                    raise ValueError('parameters.security_rules.access cannot be None.')
                
                if security_rules_parameter_item.destination_address_prefix is None:
                    raise ValueError('parameters.security_rules.destination_address_prefix cannot be None.')
                
                if security_rules_parameter_item.direction is None:
                    raise ValueError('parameters.security_rules.direction cannot be None.')
                
                if security_rules_parameter_item.protocol is None:
                    raise ValueError('parameters.security_rules.protocol cannot be None.')
                
                if security_rules_parameter_item.source_address_prefix is None:
                    raise ValueError('parameters.security_rules.source_address_prefix cannot be None.')
                
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups/'
        url = url + quote(network_security_group_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        network_security_group_json_format_value = {}
        request_doc = network_security_group_json_format_value
        
        properties_value = {}
        network_security_group_json_format_value['properties'] = properties_value
        
        if parameters.security_rules is not None:
            security_rules_array = []
            for security_rules_item in parameters.security_rules:
                security_rule_json_format_value = {}
                security_rules_array.append(security_rule_json_format_value)
                
                properties_value2 = {}
                security_rule_json_format_value['properties'] = properties_value2
                
                if security_rules_item.description is not None:
                    properties_value2['description'] = security_rules_item.description
                
                properties_value2['protocol'] = security_rules_item.protocol
                
                if security_rules_item.source_port_range is not None:
                    properties_value2['sourcePortRange'] = security_rules_item.source_port_range
                
                if security_rules_item.destination_port_range is not None:
                    properties_value2['destinationPortRange'] = security_rules_item.destination_port_range
                
                properties_value2['sourceAddressPrefix'] = security_rules_item.source_address_prefix
                
                properties_value2['destinationAddressPrefix'] = security_rules_item.destination_address_prefix
                
                properties_value2['access'] = security_rules_item.access
                
                if security_rules_item.priority is not None:
                    properties_value2['priority'] = security_rules_item.priority
                
                properties_value2['direction'] = security_rules_item.direction
                
                if security_rules_item.provisioning_state is not None:
                    properties_value2['provisioningState'] = security_rules_item.provisioning_state
                
                if security_rules_item.name is not None:
                    security_rule_json_format_value['name'] = security_rules_item.name
                
                if security_rules_item.etag is not None:
                    security_rule_json_format_value['etag'] = security_rules_item.etag
                
                if security_rules_item.id is not None:
                    security_rule_json_format_value['id'] = security_rules_item.id
                
            properties_value['securityRules'] = security_rules_array
        
        if parameters.default_security_rules is not None:
            default_security_rules_array = []
            for default_security_rules_item in parameters.default_security_rules:
                security_rule_json_format_value2 = {}
                default_security_rules_array.append(security_rule_json_format_value2)
                
                properties_value3 = {}
                security_rule_json_format_value2['properties'] = properties_value3
                
                if default_security_rules_item.description is not None:
                    properties_value3['description'] = default_security_rules_item.description
                
                properties_value3['protocol'] = default_security_rules_item.protocol
                
                if default_security_rules_item.source_port_range is not None:
                    properties_value3['sourcePortRange'] = default_security_rules_item.source_port_range
                
                if default_security_rules_item.destination_port_range is not None:
                    properties_value3['destinationPortRange'] = default_security_rules_item.destination_port_range
                
                properties_value3['sourceAddressPrefix'] = default_security_rules_item.source_address_prefix
                
                properties_value3['destinationAddressPrefix'] = default_security_rules_item.destination_address_prefix
                
                properties_value3['access'] = default_security_rules_item.access
                
                if default_security_rules_item.priority is not None:
                    properties_value3['priority'] = default_security_rules_item.priority
                
                properties_value3['direction'] = default_security_rules_item.direction
                
                if default_security_rules_item.provisioning_state is not None:
                    properties_value3['provisioningState'] = default_security_rules_item.provisioning_state
                
                if default_security_rules_item.name is not None:
                    security_rule_json_format_value2['name'] = default_security_rules_item.name
                
                if default_security_rules_item.etag is not None:
                    security_rule_json_format_value2['etag'] = default_security_rules_item.etag
                
                if default_security_rules_item.id is not None:
                    security_rule_json_format_value2['id'] = default_security_rules_item.id
                
            properties_value['defaultSecurityRules'] = default_security_rules_array
        
        if parameters.network_interfaces is not None:
            network_interfaces_array = []
            for network_interfaces_item in parameters.network_interfaces:
                resource_id_value = {}
                network_interfaces_array.append(resource_id_value)
                
                if network_interfaces_item.id is not None:
                    resource_id_value['id'] = network_interfaces_item.id
                
            properties_value['networkInterfaces'] = network_interfaces_array
        
        if parameters.subnets is not None:
            subnets_array = []
            for subnets_item in parameters.subnets:
                resource_id_value2 = {}
                subnets_array.append(resource_id_value2)
                
                if subnets_item.id is not None:
                    resource_id_value2['id'] = subnets_item.id
                
            properties_value['subnets'] = subnets_array
        
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            network_security_group_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            network_security_group_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            network_security_group_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            network_security_group_json_format_value['type'] = parameters.type
        
        network_security_group_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            network_security_group_json_format_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = NetworkSecurityGroupPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                network_security_group_instance = NetworkSecurityGroup(default_security_rules=[], network_interfaces=[], security_rules=[], subnets=[], tags={})
                result.network_security_group = network_security_group_instance
                
                properties_value4 = response_doc.get('properties', None)
                if properties_value4 is not None:
                    security_rules_array2 = properties_value4.get('securityRules', None)
                    if security_rules_array2 is not None:
                        for security_rules_value in security_rules_array2:
                            security_rule_json_format_instance = SecurityRule()
                            network_security_group_instance.security_rules.append(security_rule_json_format_instance)
                            
                            properties_value5 = security_rules_value.get('properties', None)
                            if properties_value5 is not None:
                                description_value = properties_value5.get('description', None)
                                if description_value is not None:
                                    description_instance = description_value
                                    security_rule_json_format_instance.description = description_instance
                                
                                protocol_value = properties_value5.get('protocol', None)
                                if protocol_value is not None:
                                    protocol_instance = protocol_value
                                    security_rule_json_format_instance.protocol = protocol_instance
                                
                                source_port_range_value = properties_value5.get('sourcePortRange', None)
                                if source_port_range_value is not None:
                                    source_port_range_instance = source_port_range_value
                                    security_rule_json_format_instance.source_port_range = source_port_range_instance
                                
                                destination_port_range_value = properties_value5.get('destinationPortRange', None)
                                if destination_port_range_value is not None:
                                    destination_port_range_instance = destination_port_range_value
                                    security_rule_json_format_instance.destination_port_range = destination_port_range_instance
                                
                                source_address_prefix_value = properties_value5.get('sourceAddressPrefix', None)
                                if source_address_prefix_value is not None:
                                    source_address_prefix_instance = source_address_prefix_value
                                    security_rule_json_format_instance.source_address_prefix = source_address_prefix_instance
                                
                                destination_address_prefix_value = properties_value5.get('destinationAddressPrefix', None)
                                if destination_address_prefix_value is not None:
                                    destination_address_prefix_instance = destination_address_prefix_value
                                    security_rule_json_format_instance.destination_address_prefix = destination_address_prefix_instance
                                
                                access_value = properties_value5.get('access', None)
                                if access_value is not None:
                                    access_instance = access_value
                                    security_rule_json_format_instance.access = access_instance
                                
                                priority_value = properties_value5.get('priority', None)
                                if priority_value is not None:
                                    priority_instance = priority_value
                                    security_rule_json_format_instance.priority = priority_instance
                                
                                direction_value = properties_value5.get('direction', None)
                                if direction_value is not None:
                                    direction_instance = direction_value
                                    security_rule_json_format_instance.direction = direction_instance
                                
                                provisioning_state_value = properties_value5.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    security_rule_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = security_rules_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                security_rule_json_format_instance.name = name_instance
                            
                            etag_value = security_rules_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                security_rule_json_format_instance.etag = etag_instance
                            
                            id_value = security_rules_value.get('id', None)
                            if id_value is not None:
                                id_instance = id_value
                                security_rule_json_format_instance.id = id_instance
                            
                    default_security_rules_array2 = properties_value4.get('defaultSecurityRules', None)
                    if default_security_rules_array2 is not None:
                        for default_security_rules_value in default_security_rules_array2:
                            security_rule_json_format_instance2 = SecurityRule()
                            network_security_group_instance.default_security_rules.append(security_rule_json_format_instance2)
                            
                            properties_value6 = default_security_rules_value.get('properties', None)
                            if properties_value6 is not None:
                                description_value2 = properties_value6.get('description', None)
                                if description_value2 is not None:
                                    description_instance2 = description_value2
                                    security_rule_json_format_instance2.description = description_instance2
                                
                                protocol_value2 = properties_value6.get('protocol', None)
                                if protocol_value2 is not None:
                                    protocol_instance2 = protocol_value2
                                    security_rule_json_format_instance2.protocol = protocol_instance2
                                
                                source_port_range_value2 = properties_value6.get('sourcePortRange', None)
                                if source_port_range_value2 is not None:
                                    source_port_range_instance2 = source_port_range_value2
                                    security_rule_json_format_instance2.source_port_range = source_port_range_instance2
                                
                                destination_port_range_value2 = properties_value6.get('destinationPortRange', None)
                                if destination_port_range_value2 is not None:
                                    destination_port_range_instance2 = destination_port_range_value2
                                    security_rule_json_format_instance2.destination_port_range = destination_port_range_instance2
                                
                                source_address_prefix_value2 = properties_value6.get('sourceAddressPrefix', None)
                                if source_address_prefix_value2 is not None:
                                    source_address_prefix_instance2 = source_address_prefix_value2
                                    security_rule_json_format_instance2.source_address_prefix = source_address_prefix_instance2
                                
                                destination_address_prefix_value2 = properties_value6.get('destinationAddressPrefix', None)
                                if destination_address_prefix_value2 is not None:
                                    destination_address_prefix_instance2 = destination_address_prefix_value2
                                    security_rule_json_format_instance2.destination_address_prefix = destination_address_prefix_instance2
                                
                                access_value2 = properties_value6.get('access', None)
                                if access_value2 is not None:
                                    access_instance2 = access_value2
                                    security_rule_json_format_instance2.access = access_instance2
                                
                                priority_value2 = properties_value6.get('priority', None)
                                if priority_value2 is not None:
                                    priority_instance2 = priority_value2
                                    security_rule_json_format_instance2.priority = priority_instance2
                                
                                direction_value2 = properties_value6.get('direction', None)
                                if direction_value2 is not None:
                                    direction_instance2 = direction_value2
                                    security_rule_json_format_instance2.direction = direction_instance2
                                
                                provisioning_state_value2 = properties_value6.get('provisioningState', None)
                                if provisioning_state_value2 is not None:
                                    provisioning_state_instance2 = provisioning_state_value2
                                    security_rule_json_format_instance2.provisioning_state = provisioning_state_instance2
                                
                            name_value2 = default_security_rules_value.get('name', None)
                            if name_value2 is not None:
                                name_instance2 = name_value2
                                security_rule_json_format_instance2.name = name_instance2
                            
                            etag_value2 = default_security_rules_value.get('etag', None)
                            if etag_value2 is not None:
                                etag_instance2 = etag_value2
                                security_rule_json_format_instance2.etag = etag_instance2
                            
                            id_value2 = default_security_rules_value.get('id', None)
                            if id_value2 is not None:
                                id_instance2 = id_value2
                                security_rule_json_format_instance2.id = id_instance2
                            
                    network_interfaces_array2 = properties_value4.get('networkInterfaces', None)
                    if network_interfaces_array2 is not None:
                        for network_interfaces_value in network_interfaces_array2:
                            resource_id_instance = ResourceId()
                            network_security_group_instance.network_interfaces.append(resource_id_instance)
                            
                            id_value3 = network_interfaces_value.get('id', None)
                            if id_value3 is not None:
                                id_instance3 = id_value3
                                resource_id_instance.id = id_instance3
                            
                    subnets_array2 = properties_value4.get('subnets', None)
                    if subnets_array2 is not None:
                        for subnets_value in subnets_array2:
                            resource_id_instance2 = ResourceId()
                            network_security_group_instance.subnets.append(resource_id_instance2)
                            
                            id_value4 = subnets_value.get('id', None)
                            if id_value4 is not None:
                                id_instance4 = id_value4
                                resource_id_instance2.id = id_instance4
                            
                    provisioning_state_value3 = properties_value4.get('provisioningState', None)
                    if provisioning_state_value3 is not None:
                        provisioning_state_instance3 = provisioning_state_value3
                        network_security_group_instance.provisioning_state = provisioning_state_instance3
                    
                etag_value3 = response_doc.get('etag', None)
                if etag_value3 is not None:
                    etag_instance3 = etag_value3
                    network_security_group_instance.etag = etag_instance3
                
                id_value5 = response_doc.get('id', None)
                if id_value5 is not None:
                    id_instance5 = id_value5
                    network_security_group_instance.id = id_instance5
                
                name_value3 = response_doc.get('name', None)
                if name_value3 is not None:
                    name_instance3 = name_value3
                    network_security_group_instance.name = name_instance3
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    network_security_group_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    network_security_group_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        network_security_group_instance.tags[tags_key2] = tags_value2
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, network_security_group_name):
        """
         The Delete NetworkSecurityGroup operation deletes the specifed network
         security group
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_security_group_name is None:
            raise ValueError('network_security_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups/'
        url = url + quote(network_security_group_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, network_security_group_name, parameters):
        """
         The Put NetworkSecurityGroup operation creates/updates a network
         security groupin the specified resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         parameters (NetworkSecurityGroup): Parameters supplied to the
         create/update Network Security Group operation
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.network_security_groups.begin_create_or_updating(resource_group_name, network_security_group_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, network_security_group_name):
        """
         The Delete NetworkSecurityGroup operation deletes the specifed network
         security group
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.network_security_groups.begin_deleting(resource_group_name, network_security_group_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, network_security_group_name):
        """
         The Get NetworkSecurityGroups operation retrieves information about
         the specified network security group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         Returns:
         
         NetworkSecurityGroupGetResponse: Response for GetNetworkSecurityGroup
         Api service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_security_group_name is None:
            raise ValueError('network_security_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups/'
        url = url + quote(network_security_group_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = NetworkSecurityGroupGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                network_security_group_instance = NetworkSecurityGroup(default_security_rules=[], network_interfaces=[], security_rules=[], subnets=[], tags={})
                result.network_security_group = network_security_group_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    security_rules_array = properties_value.get('securityRules', None)
                    if security_rules_array is not None:
                        for security_rules_value in security_rules_array:
                            security_rule_json_format_instance = SecurityRule()
                            network_security_group_instance.security_rules.append(security_rule_json_format_instance)
                            
                            properties_value2 = security_rules_value.get('properties', None)
                            if properties_value2 is not None:
                                description_value = properties_value2.get('description', None)
                                if description_value is not None:
                                    description_instance = description_value
                                    security_rule_json_format_instance.description = description_instance
                                
                                protocol_value = properties_value2.get('protocol', None)
                                if protocol_value is not None:
                                    protocol_instance = protocol_value
                                    security_rule_json_format_instance.protocol = protocol_instance
                                
                                source_port_range_value = properties_value2.get('sourcePortRange', None)
                                if source_port_range_value is not None:
                                    source_port_range_instance = source_port_range_value
                                    security_rule_json_format_instance.source_port_range = source_port_range_instance
                                
                                destination_port_range_value = properties_value2.get('destinationPortRange', None)
                                if destination_port_range_value is not None:
                                    destination_port_range_instance = destination_port_range_value
                                    security_rule_json_format_instance.destination_port_range = destination_port_range_instance
                                
                                source_address_prefix_value = properties_value2.get('sourceAddressPrefix', None)
                                if source_address_prefix_value is not None:
                                    source_address_prefix_instance = source_address_prefix_value
                                    security_rule_json_format_instance.source_address_prefix = source_address_prefix_instance
                                
                                destination_address_prefix_value = properties_value2.get('destinationAddressPrefix', None)
                                if destination_address_prefix_value is not None:
                                    destination_address_prefix_instance = destination_address_prefix_value
                                    security_rule_json_format_instance.destination_address_prefix = destination_address_prefix_instance
                                
                                access_value = properties_value2.get('access', None)
                                if access_value is not None:
                                    access_instance = access_value
                                    security_rule_json_format_instance.access = access_instance
                                
                                priority_value = properties_value2.get('priority', None)
                                if priority_value is not None:
                                    priority_instance = priority_value
                                    security_rule_json_format_instance.priority = priority_instance
                                
                                direction_value = properties_value2.get('direction', None)
                                if direction_value is not None:
                                    direction_instance = direction_value
                                    security_rule_json_format_instance.direction = direction_instance
                                
                                provisioning_state_value = properties_value2.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    security_rule_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = security_rules_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                security_rule_json_format_instance.name = name_instance
                            
                            etag_value = security_rules_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                security_rule_json_format_instance.etag = etag_instance
                            
                            id_value = security_rules_value.get('id', None)
                            if id_value is not None:
                                id_instance = id_value
                                security_rule_json_format_instance.id = id_instance
                            
                    default_security_rules_array = properties_value.get('defaultSecurityRules', None)
                    if default_security_rules_array is not None:
                        for default_security_rules_value in default_security_rules_array:
                            security_rule_json_format_instance2 = SecurityRule()
                            network_security_group_instance.default_security_rules.append(security_rule_json_format_instance2)
                            
                            properties_value3 = default_security_rules_value.get('properties', None)
                            if properties_value3 is not None:
                                description_value2 = properties_value3.get('description', None)
                                if description_value2 is not None:
                                    description_instance2 = description_value2
                                    security_rule_json_format_instance2.description = description_instance2
                                
                                protocol_value2 = properties_value3.get('protocol', None)
                                if protocol_value2 is not None:
                                    protocol_instance2 = protocol_value2
                                    security_rule_json_format_instance2.protocol = protocol_instance2
                                
                                source_port_range_value2 = properties_value3.get('sourcePortRange', None)
                                if source_port_range_value2 is not None:
                                    source_port_range_instance2 = source_port_range_value2
                                    security_rule_json_format_instance2.source_port_range = source_port_range_instance2
                                
                                destination_port_range_value2 = properties_value3.get('destinationPortRange', None)
                                if destination_port_range_value2 is not None:
                                    destination_port_range_instance2 = destination_port_range_value2
                                    security_rule_json_format_instance2.destination_port_range = destination_port_range_instance2
                                
                                source_address_prefix_value2 = properties_value3.get('sourceAddressPrefix', None)
                                if source_address_prefix_value2 is not None:
                                    source_address_prefix_instance2 = source_address_prefix_value2
                                    security_rule_json_format_instance2.source_address_prefix = source_address_prefix_instance2
                                
                                destination_address_prefix_value2 = properties_value3.get('destinationAddressPrefix', None)
                                if destination_address_prefix_value2 is not None:
                                    destination_address_prefix_instance2 = destination_address_prefix_value2
                                    security_rule_json_format_instance2.destination_address_prefix = destination_address_prefix_instance2
                                
                                access_value2 = properties_value3.get('access', None)
                                if access_value2 is not None:
                                    access_instance2 = access_value2
                                    security_rule_json_format_instance2.access = access_instance2
                                
                                priority_value2 = properties_value3.get('priority', None)
                                if priority_value2 is not None:
                                    priority_instance2 = priority_value2
                                    security_rule_json_format_instance2.priority = priority_instance2
                                
                                direction_value2 = properties_value3.get('direction', None)
                                if direction_value2 is not None:
                                    direction_instance2 = direction_value2
                                    security_rule_json_format_instance2.direction = direction_instance2
                                
                                provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                if provisioning_state_value2 is not None:
                                    provisioning_state_instance2 = provisioning_state_value2
                                    security_rule_json_format_instance2.provisioning_state = provisioning_state_instance2
                                
                            name_value2 = default_security_rules_value.get('name', None)
                            if name_value2 is not None:
                                name_instance2 = name_value2
                                security_rule_json_format_instance2.name = name_instance2
                            
                            etag_value2 = default_security_rules_value.get('etag', None)
                            if etag_value2 is not None:
                                etag_instance2 = etag_value2
                                security_rule_json_format_instance2.etag = etag_instance2
                            
                            id_value2 = default_security_rules_value.get('id', None)
                            if id_value2 is not None:
                                id_instance2 = id_value2
                                security_rule_json_format_instance2.id = id_instance2
                            
                    network_interfaces_array = properties_value.get('networkInterfaces', None)
                    if network_interfaces_array is not None:
                        for network_interfaces_value in network_interfaces_array:
                            resource_id_instance = ResourceId()
                            network_security_group_instance.network_interfaces.append(resource_id_instance)
                            
                            id_value3 = network_interfaces_value.get('id', None)
                            if id_value3 is not None:
                                id_instance3 = id_value3
                                resource_id_instance.id = id_instance3
                            
                    subnets_array = properties_value.get('subnets', None)
                    if subnets_array is not None:
                        for subnets_value in subnets_array:
                            resource_id_instance2 = ResourceId()
                            network_security_group_instance.subnets.append(resource_id_instance2)
                            
                            id_value4 = subnets_value.get('id', None)
                            if id_value4 is not None:
                                id_instance4 = id_value4
                                resource_id_instance2.id = id_instance4
                            
                    provisioning_state_value3 = properties_value.get('provisioningState', None)
                    if provisioning_state_value3 is not None:
                        provisioning_state_instance3 = provisioning_state_value3
                        network_security_group_instance.provisioning_state = provisioning_state_instance3
                    
                etag_value3 = response_doc.get('etag', None)
                if etag_value3 is not None:
                    etag_instance3 = etag_value3
                    network_security_group_instance.etag = etag_instance3
                
                id_value5 = response_doc.get('id', None)
                if id_value5 is not None:
                    id_instance5 = id_value5
                    network_security_group_instance.id = id_instance5
                
                name_value3 = response_doc.get('name', None)
                if name_value3 is not None:
                    name_instance3 = name_value3
                    network_security_group_instance.name = name_instance3
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    network_security_group_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    network_security_group_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        network_security_group_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The list NetworkSecurityGroups returns all network security groups in
         a resource group
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         NetworkSecurityGroupListResponse: Response for
         ListNetworkSecurityGroups Api servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = NetworkSecurityGroupListResponse(network_security_groups=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        network_security_group_json_format_instance = NetworkSecurityGroup(default_security_rules=[], network_interfaces=[], security_rules=[], subnets=[], tags={})
                        result.network_security_groups.append(network_security_group_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            security_rules_array = properties_value.get('securityRules', None)
                            if security_rules_array is not None:
                                for security_rules_value in security_rules_array:
                                    security_rule_json_format_instance = SecurityRule()
                                    network_security_group_json_format_instance.security_rules.append(security_rule_json_format_instance)
                                    
                                    properties_value2 = security_rules_value.get('properties', None)
                                    if properties_value2 is not None:
                                        description_value = properties_value2.get('description', None)
                                        if description_value is not None:
                                            description_instance = description_value
                                            security_rule_json_format_instance.description = description_instance
                                        
                                        protocol_value = properties_value2.get('protocol', None)
                                        if protocol_value is not None:
                                            protocol_instance = protocol_value
                                            security_rule_json_format_instance.protocol = protocol_instance
                                        
                                        source_port_range_value = properties_value2.get('sourcePortRange', None)
                                        if source_port_range_value is not None:
                                            source_port_range_instance = source_port_range_value
                                            security_rule_json_format_instance.source_port_range = source_port_range_instance
                                        
                                        destination_port_range_value = properties_value2.get('destinationPortRange', None)
                                        if destination_port_range_value is not None:
                                            destination_port_range_instance = destination_port_range_value
                                            security_rule_json_format_instance.destination_port_range = destination_port_range_instance
                                        
                                        source_address_prefix_value = properties_value2.get('sourceAddressPrefix', None)
                                        if source_address_prefix_value is not None:
                                            source_address_prefix_instance = source_address_prefix_value
                                            security_rule_json_format_instance.source_address_prefix = source_address_prefix_instance
                                        
                                        destination_address_prefix_value = properties_value2.get('destinationAddressPrefix', None)
                                        if destination_address_prefix_value is not None:
                                            destination_address_prefix_instance = destination_address_prefix_value
                                            security_rule_json_format_instance.destination_address_prefix = destination_address_prefix_instance
                                        
                                        access_value = properties_value2.get('access', None)
                                        if access_value is not None:
                                            access_instance = access_value
                                            security_rule_json_format_instance.access = access_instance
                                        
                                        priority_value = properties_value2.get('priority', None)
                                        if priority_value is not None:
                                            priority_instance = priority_value
                                            security_rule_json_format_instance.priority = priority_instance
                                        
                                        direction_value = properties_value2.get('direction', None)
                                        if direction_value is not None:
                                            direction_instance = direction_value
                                            security_rule_json_format_instance.direction = direction_instance
                                        
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            security_rule_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = security_rules_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        security_rule_json_format_instance.name = name_instance
                                    
                                    etag_value = security_rules_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        security_rule_json_format_instance.etag = etag_instance
                                    
                                    id_value = security_rules_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        security_rule_json_format_instance.id = id_instance
                                    
                            default_security_rules_array = properties_value.get('defaultSecurityRules', None)
                            if default_security_rules_array is not None:
                                for default_security_rules_value in default_security_rules_array:
                                    security_rule_json_format_instance2 = SecurityRule()
                                    network_security_group_json_format_instance.default_security_rules.append(security_rule_json_format_instance2)
                                    
                                    properties_value3 = default_security_rules_value.get('properties', None)
                                    if properties_value3 is not None:
                                        description_value2 = properties_value3.get('description', None)
                                        if description_value2 is not None:
                                            description_instance2 = description_value2
                                            security_rule_json_format_instance2.description = description_instance2
                                        
                                        protocol_value2 = properties_value3.get('protocol', None)
                                        if protocol_value2 is not None:
                                            protocol_instance2 = protocol_value2
                                            security_rule_json_format_instance2.protocol = protocol_instance2
                                        
                                        source_port_range_value2 = properties_value3.get('sourcePortRange', None)
                                        if source_port_range_value2 is not None:
                                            source_port_range_instance2 = source_port_range_value2
                                            security_rule_json_format_instance2.source_port_range = source_port_range_instance2
                                        
                                        destination_port_range_value2 = properties_value3.get('destinationPortRange', None)
                                        if destination_port_range_value2 is not None:
                                            destination_port_range_instance2 = destination_port_range_value2
                                            security_rule_json_format_instance2.destination_port_range = destination_port_range_instance2
                                        
                                        source_address_prefix_value2 = properties_value3.get('sourceAddressPrefix', None)
                                        if source_address_prefix_value2 is not None:
                                            source_address_prefix_instance2 = source_address_prefix_value2
                                            security_rule_json_format_instance2.source_address_prefix = source_address_prefix_instance2
                                        
                                        destination_address_prefix_value2 = properties_value3.get('destinationAddressPrefix', None)
                                        if destination_address_prefix_value2 is not None:
                                            destination_address_prefix_instance2 = destination_address_prefix_value2
                                            security_rule_json_format_instance2.destination_address_prefix = destination_address_prefix_instance2
                                        
                                        access_value2 = properties_value3.get('access', None)
                                        if access_value2 is not None:
                                            access_instance2 = access_value2
                                            security_rule_json_format_instance2.access = access_instance2
                                        
                                        priority_value2 = properties_value3.get('priority', None)
                                        if priority_value2 is not None:
                                            priority_instance2 = priority_value2
                                            security_rule_json_format_instance2.priority = priority_instance2
                                        
                                        direction_value2 = properties_value3.get('direction', None)
                                        if direction_value2 is not None:
                                            direction_instance2 = direction_value2
                                            security_rule_json_format_instance2.direction = direction_instance2
                                        
                                        provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                        if provisioning_state_value2 is not None:
                                            provisioning_state_instance2 = provisioning_state_value2
                                            security_rule_json_format_instance2.provisioning_state = provisioning_state_instance2
                                        
                                    name_value2 = default_security_rules_value.get('name', None)
                                    if name_value2 is not None:
                                        name_instance2 = name_value2
                                        security_rule_json_format_instance2.name = name_instance2
                                    
                                    etag_value2 = default_security_rules_value.get('etag', None)
                                    if etag_value2 is not None:
                                        etag_instance2 = etag_value2
                                        security_rule_json_format_instance2.etag = etag_instance2
                                    
                                    id_value2 = default_security_rules_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        security_rule_json_format_instance2.id = id_instance2
                                    
                            network_interfaces_array = properties_value.get('networkInterfaces', None)
                            if network_interfaces_array is not None:
                                for network_interfaces_value in network_interfaces_array:
                                    resource_id_instance = ResourceId()
                                    network_security_group_json_format_instance.network_interfaces.append(resource_id_instance)
                                    
                                    id_value3 = network_interfaces_value.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        resource_id_instance.id = id_instance3
                                    
                            subnets_array = properties_value.get('subnets', None)
                            if subnets_array is not None:
                                for subnets_value in subnets_array:
                                    resource_id_instance2 = ResourceId()
                                    network_security_group_json_format_instance.subnets.append(resource_id_instance2)
                                    
                                    id_value4 = subnets_value.get('id', None)
                                    if id_value4 is not None:
                                        id_instance4 = id_value4
                                        resource_id_instance2.id = id_instance4
                                    
                            provisioning_state_value3 = properties_value.get('provisioningState', None)
                            if provisioning_state_value3 is not None:
                                provisioning_state_instance3 = provisioning_state_value3
                                network_security_group_json_format_instance.provisioning_state = provisioning_state_instance3
                            
                        etag_value3 = value_value.get('etag', None)
                        if etag_value3 is not None:
                            etag_instance3 = etag_value3
                            network_security_group_json_format_instance.etag = etag_instance3
                        
                        id_value5 = value_value.get('id', None)
                        if id_value5 is not None:
                            id_instance5 = id_value5
                            network_security_group_json_format_instance.id = id_instance5
                        
                        name_value3 = value_value.get('name', None)
                        if name_value3 is not None:
                            name_instance3 = name_value3
                            network_security_group_json_format_instance.name = name_instance3
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            network_security_group_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            network_security_group_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                network_security_group_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_all(self):
        """
         The list NetworkSecurityGroups returns all network security groups in
         a subscription
         
         Returns:
         
         NetworkSecurityGroupListResponse: Response for
         ListNetworkSecurityGroups Api servive call
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = NetworkSecurityGroupListResponse(network_security_groups=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        network_security_group_json_format_instance = NetworkSecurityGroup(default_security_rules=[], network_interfaces=[], security_rules=[], subnets=[], tags={})
                        result.network_security_groups.append(network_security_group_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            security_rules_array = properties_value.get('securityRules', None)
                            if security_rules_array is not None:
                                for security_rules_value in security_rules_array:
                                    security_rule_json_format_instance = SecurityRule()
                                    network_security_group_json_format_instance.security_rules.append(security_rule_json_format_instance)
                                    
                                    properties_value2 = security_rules_value.get('properties', None)
                                    if properties_value2 is not None:
                                        description_value = properties_value2.get('description', None)
                                        if description_value is not None:
                                            description_instance = description_value
                                            security_rule_json_format_instance.description = description_instance
                                        
                                        protocol_value = properties_value2.get('protocol', None)
                                        if protocol_value is not None:
                                            protocol_instance = protocol_value
                                            security_rule_json_format_instance.protocol = protocol_instance
                                        
                                        source_port_range_value = properties_value2.get('sourcePortRange', None)
                                        if source_port_range_value is not None:
                                            source_port_range_instance = source_port_range_value
                                            security_rule_json_format_instance.source_port_range = source_port_range_instance
                                        
                                        destination_port_range_value = properties_value2.get('destinationPortRange', None)
                                        if destination_port_range_value is not None:
                                            destination_port_range_instance = destination_port_range_value
                                            security_rule_json_format_instance.destination_port_range = destination_port_range_instance
                                        
                                        source_address_prefix_value = properties_value2.get('sourceAddressPrefix', None)
                                        if source_address_prefix_value is not None:
                                            source_address_prefix_instance = source_address_prefix_value
                                            security_rule_json_format_instance.source_address_prefix = source_address_prefix_instance
                                        
                                        destination_address_prefix_value = properties_value2.get('destinationAddressPrefix', None)
                                        if destination_address_prefix_value is not None:
                                            destination_address_prefix_instance = destination_address_prefix_value
                                            security_rule_json_format_instance.destination_address_prefix = destination_address_prefix_instance
                                        
                                        access_value = properties_value2.get('access', None)
                                        if access_value is not None:
                                            access_instance = access_value
                                            security_rule_json_format_instance.access = access_instance
                                        
                                        priority_value = properties_value2.get('priority', None)
                                        if priority_value is not None:
                                            priority_instance = priority_value
                                            security_rule_json_format_instance.priority = priority_instance
                                        
                                        direction_value = properties_value2.get('direction', None)
                                        if direction_value is not None:
                                            direction_instance = direction_value
                                            security_rule_json_format_instance.direction = direction_instance
                                        
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            security_rule_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = security_rules_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        security_rule_json_format_instance.name = name_instance
                                    
                                    etag_value = security_rules_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        security_rule_json_format_instance.etag = etag_instance
                                    
                                    id_value = security_rules_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        security_rule_json_format_instance.id = id_instance
                                    
                            default_security_rules_array = properties_value.get('defaultSecurityRules', None)
                            if default_security_rules_array is not None:
                                for default_security_rules_value in default_security_rules_array:
                                    security_rule_json_format_instance2 = SecurityRule()
                                    network_security_group_json_format_instance.default_security_rules.append(security_rule_json_format_instance2)
                                    
                                    properties_value3 = default_security_rules_value.get('properties', None)
                                    if properties_value3 is not None:
                                        description_value2 = properties_value3.get('description', None)
                                        if description_value2 is not None:
                                            description_instance2 = description_value2
                                            security_rule_json_format_instance2.description = description_instance2
                                        
                                        protocol_value2 = properties_value3.get('protocol', None)
                                        if protocol_value2 is not None:
                                            protocol_instance2 = protocol_value2
                                            security_rule_json_format_instance2.protocol = protocol_instance2
                                        
                                        source_port_range_value2 = properties_value3.get('sourcePortRange', None)
                                        if source_port_range_value2 is not None:
                                            source_port_range_instance2 = source_port_range_value2
                                            security_rule_json_format_instance2.source_port_range = source_port_range_instance2
                                        
                                        destination_port_range_value2 = properties_value3.get('destinationPortRange', None)
                                        if destination_port_range_value2 is not None:
                                            destination_port_range_instance2 = destination_port_range_value2
                                            security_rule_json_format_instance2.destination_port_range = destination_port_range_instance2
                                        
                                        source_address_prefix_value2 = properties_value3.get('sourceAddressPrefix', None)
                                        if source_address_prefix_value2 is not None:
                                            source_address_prefix_instance2 = source_address_prefix_value2
                                            security_rule_json_format_instance2.source_address_prefix = source_address_prefix_instance2
                                        
                                        destination_address_prefix_value2 = properties_value3.get('destinationAddressPrefix', None)
                                        if destination_address_prefix_value2 is not None:
                                            destination_address_prefix_instance2 = destination_address_prefix_value2
                                            security_rule_json_format_instance2.destination_address_prefix = destination_address_prefix_instance2
                                        
                                        access_value2 = properties_value3.get('access', None)
                                        if access_value2 is not None:
                                            access_instance2 = access_value2
                                            security_rule_json_format_instance2.access = access_instance2
                                        
                                        priority_value2 = properties_value3.get('priority', None)
                                        if priority_value2 is not None:
                                            priority_instance2 = priority_value2
                                            security_rule_json_format_instance2.priority = priority_instance2
                                        
                                        direction_value2 = properties_value3.get('direction', None)
                                        if direction_value2 is not None:
                                            direction_instance2 = direction_value2
                                            security_rule_json_format_instance2.direction = direction_instance2
                                        
                                        provisioning_state_value2 = properties_value3.get('provisioningState', None)
                                        if provisioning_state_value2 is not None:
                                            provisioning_state_instance2 = provisioning_state_value2
                                            security_rule_json_format_instance2.provisioning_state = provisioning_state_instance2
                                        
                                    name_value2 = default_security_rules_value.get('name', None)
                                    if name_value2 is not None:
                                        name_instance2 = name_value2
                                        security_rule_json_format_instance2.name = name_instance2
                                    
                                    etag_value2 = default_security_rules_value.get('etag', None)
                                    if etag_value2 is not None:
                                        etag_instance2 = etag_value2
                                        security_rule_json_format_instance2.etag = etag_instance2
                                    
                                    id_value2 = default_security_rules_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        security_rule_json_format_instance2.id = id_instance2
                                    
                            network_interfaces_array = properties_value.get('networkInterfaces', None)
                            if network_interfaces_array is not None:
                                for network_interfaces_value in network_interfaces_array:
                                    resource_id_instance = ResourceId()
                                    network_security_group_json_format_instance.network_interfaces.append(resource_id_instance)
                                    
                                    id_value3 = network_interfaces_value.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        resource_id_instance.id = id_instance3
                                    
                            subnets_array = properties_value.get('subnets', None)
                            if subnets_array is not None:
                                for subnets_value in subnets_array:
                                    resource_id_instance2 = ResourceId()
                                    network_security_group_json_format_instance.subnets.append(resource_id_instance2)
                                    
                                    id_value4 = subnets_value.get('id', None)
                                    if id_value4 is not None:
                                        id_instance4 = id_value4
                                        resource_id_instance2.id = id_instance4
                                    
                            provisioning_state_value3 = properties_value.get('provisioningState', None)
                            if provisioning_state_value3 is not None:
                                provisioning_state_instance3 = provisioning_state_value3
                                network_security_group_json_format_instance.provisioning_state = provisioning_state_instance3
                            
                        etag_value3 = value_value.get('etag', None)
                        if etag_value3 is not None:
                            etag_instance3 = etag_value3
                            network_security_group_json_format_instance.etag = etag_instance3
                        
                        id_value5 = value_value.get('id', None)
                        if id_value5 is not None:
                            id_instance5 = id_value5
                            network_security_group_json_format_instance.id = id_instance5
                        
                        name_value3 = value_value.get('name', None)
                        if name_value3 is not None:
                            name_instance3 = name_value3
                            network_security_group_json_format_instance.name = name_instance3
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            network_security_group_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            network_security_group_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                network_security_group_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class PublicIpAddressOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     PublicIPAddress for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, public_ip_address_name, parameters):
        """
         The Put PublicIPAddress operation creates/updates a stable/dynamic
         PublicIP address
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         public_ip_address_name (string): The name of the publicIpAddress.
         
         parameters (PublicIpAddress): Parameters supplied to the create/update
         PublicIPAddress operation
         
         Returns:
         
         PublicIpAddressPutResponse: Response for PutPublicIpAddress Api
         servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if public_ip_address_name is None:
            raise ValueError('public_ip_address_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        if parameters.public_ip_allocation_method is None:
            raise ValueError('parameters.public_ip_allocation_method cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/publicIPAddresses/'
        url = url + quote(public_ip_address_name)
        url = url + '/'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        public_ip_address_json_format_value = {}
        request_doc = public_ip_address_json_format_value
        
        properties_value = {}
        public_ip_address_json_format_value['properties'] = properties_value
        
        properties_value['publicIPAllocationMethod'] = parameters.public_ip_allocation_method
        
        if parameters.ip_configuration is not None:
            ip_configuration_value = {}
            properties_value['ipConfiguration'] = ip_configuration_value
            
            if parameters.ip_configuration.id is not None:
                ip_configuration_value['id'] = parameters.ip_configuration.id
            
        if parameters.dns_settings is not None:
            dns_settings_value = {}
            properties_value['dnsSettings'] = dns_settings_value
            
            if parameters.dns_settings.domain_name_label is not None:
                dns_settings_value['domainNameLabel'] = parameters.dns_settings.domain_name_label
            
            if parameters.dns_settings.fqdn is not None:
                dns_settings_value['fqdn'] = parameters.dns_settings.fqdn
            
            if parameters.dns_settings.reverse_fqdn is not None:
                dns_settings_value['reverseFqdn'] = parameters.dns_settings.reverse_fqdn
            
        if parameters.ip_address is not None:
            properties_value['ipAddress'] = parameters.ip_address
        
        if parameters.idle_timeout_in_minutes is not None:
            properties_value['idleTimeoutInMinutes'] = parameters.idle_timeout_in_minutes
        
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            public_ip_address_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            public_ip_address_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            public_ip_address_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            public_ip_address_json_format_value['type'] = parameters.type
        
        public_ip_address_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            public_ip_address_json_format_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = PublicIpAddressPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                public_ip_address_instance = PublicIpAddress(tags={})
                result.public_ip_address = public_ip_address_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    public_ip_allocation_method_value = properties_value2.get('publicIPAllocationMethod', None)
                    if public_ip_allocation_method_value is not None:
                        public_ip_allocation_method_instance = public_ip_allocation_method_value
                        public_ip_address_instance.public_ip_allocation_method = public_ip_allocation_method_instance
                    
                    ip_configuration_value2 = properties_value2.get('ipConfiguration', None)
                    if ip_configuration_value2 is not None:
                        ip_configuration_instance = ResourceId()
                        public_ip_address_instance.ip_configuration = ip_configuration_instance
                        
                        id_value = ip_configuration_value2.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            ip_configuration_instance.id = id_instance
                        
                    dns_settings_value2 = properties_value2.get('dnsSettings', None)
                    if dns_settings_value2 is not None:
                        dns_settings_instance = PublicIpAddressDnsSettings()
                        public_ip_address_instance.dns_settings = dns_settings_instance
                        
                        domain_name_label_value = dns_settings_value2.get('domainNameLabel', None)
                        if domain_name_label_value is not None:
                            domain_name_label_instance = domain_name_label_value
                            dns_settings_instance.domain_name_label = domain_name_label_instance
                        
                        fqdn_value = dns_settings_value2.get('fqdn', None)
                        if fqdn_value is not None:
                            fqdn_instance = fqdn_value
                            dns_settings_instance.fqdn = fqdn_instance
                        
                        reverse_fqdn_value = dns_settings_value2.get('reverseFqdn', None)
                        if reverse_fqdn_value is not None:
                            reverse_fqdn_instance = reverse_fqdn_value
                            dns_settings_instance.reverse_fqdn = reverse_fqdn_instance
                        
                    ip_address_value = properties_value2.get('ipAddress', None)
                    if ip_address_value is not None:
                        ip_address_instance = ip_address_value
                        public_ip_address_instance.ip_address = ip_address_instance
                    
                    idle_timeout_in_minutes_value = properties_value2.get('idleTimeoutInMinutes', None)
                    if idle_timeout_in_minutes_value is not None:
                        idle_timeout_in_minutes_instance = idle_timeout_in_minutes_value
                        public_ip_address_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance
                    
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        public_ip_address_instance.provisioning_state = provisioning_state_instance
                    
                etag_value = response_doc.get('etag', None)
                if etag_value is not None:
                    etag_instance = etag_value
                    public_ip_address_instance.etag = etag_instance
                
                id_value2 = response_doc.get('id', None)
                if id_value2 is not None:
                    id_instance2 = id_value2
                    public_ip_address_instance.id = id_instance2
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    public_ip_address_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    public_ip_address_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    public_ip_address_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        public_ip_address_instance.tags[tags_key2] = tags_value2
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, public_ip_address_name):
        """
         The delete publicIpAddress operation deletes the specified
         publicIpAddress.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         public_ip_address_name (string): The name of the subnet.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if public_ip_address_name is None:
            raise ValueError('public_ip_address_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/publicIPAddresses/'
        url = url + quote(public_ip_address_name)
        url = url + '/'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, public_ip_address_name, parameters):
        """
         The Put PublicIPAddress operation creates/updates a stable/dynamic
         PublicIP address
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         public_ip_address_name (string): The name of the publicIpAddress.
         
         parameters (PublicIpAddress): Parameters supplied to the create
         PublicIPAddress operation
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.public_ip_addresses.begin_create_or_updating(resource_group_name, public_ip_address_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, public_ip_address_name):
        """
         The Get Role operation retrieves information about the specified
         virtual machine.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         public_ip_address_name (string): The name of the subnet.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.public_ip_addresses.begin_deleting(resource_group_name, public_ip_address_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, public_ip_address_name):
        """
         The Get publicIpAddress operation retreives information about the
         specified pubicIpAddress
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         public_ip_address_name (string): The name of the subnet.
         
         Returns:
         
         PublicIpAddressGetResponse: Response for GetPublicIpAddress Api
         servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if public_ip_address_name is None:
            raise ValueError('public_ip_address_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/publicIPAddresses/'
        url = url + quote(public_ip_address_name)
        url = url + '/'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = PublicIpAddressGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                public_ip_address_instance = PublicIpAddress(tags={})
                result.public_ip_address = public_ip_address_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    public_ip_allocation_method_value = properties_value.get('publicIPAllocationMethod', None)
                    if public_ip_allocation_method_value is not None:
                        public_ip_allocation_method_instance = public_ip_allocation_method_value
                        public_ip_address_instance.public_ip_allocation_method = public_ip_allocation_method_instance
                    
                    ip_configuration_value = properties_value.get('ipConfiguration', None)
                    if ip_configuration_value is not None:
                        ip_configuration_instance = ResourceId()
                        public_ip_address_instance.ip_configuration = ip_configuration_instance
                        
                        id_value = ip_configuration_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            ip_configuration_instance.id = id_instance
                        
                    dns_settings_value = properties_value.get('dnsSettings', None)
                    if dns_settings_value is not None:
                        dns_settings_instance = PublicIpAddressDnsSettings()
                        public_ip_address_instance.dns_settings = dns_settings_instance
                        
                        domain_name_label_value = dns_settings_value.get('domainNameLabel', None)
                        if domain_name_label_value is not None:
                            domain_name_label_instance = domain_name_label_value
                            dns_settings_instance.domain_name_label = domain_name_label_instance
                        
                        fqdn_value = dns_settings_value.get('fqdn', None)
                        if fqdn_value is not None:
                            fqdn_instance = fqdn_value
                            dns_settings_instance.fqdn = fqdn_instance
                        
                        reverse_fqdn_value = dns_settings_value.get('reverseFqdn', None)
                        if reverse_fqdn_value is not None:
                            reverse_fqdn_instance = reverse_fqdn_value
                            dns_settings_instance.reverse_fqdn = reverse_fqdn_instance
                        
                    ip_address_value = properties_value.get('ipAddress', None)
                    if ip_address_value is not None:
                        ip_address_instance = ip_address_value
                        public_ip_address_instance.ip_address = ip_address_instance
                    
                    idle_timeout_in_minutes_value = properties_value.get('idleTimeoutInMinutes', None)
                    if idle_timeout_in_minutes_value is not None:
                        idle_timeout_in_minutes_instance = idle_timeout_in_minutes_value
                        public_ip_address_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance
                    
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        public_ip_address_instance.provisioning_state = provisioning_state_instance
                    
                etag_value = response_doc.get('etag', None)
                if etag_value is not None:
                    etag_instance = etag_value
                    public_ip_address_instance.etag = etag_instance
                
                id_value2 = response_doc.get('id', None)
                if id_value2 is not None:
                    id_instance2 = id_value2
                    public_ip_address_instance.id = id_instance2
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    public_ip_address_instance.name = name_instance
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    public_ip_address_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    public_ip_address_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        public_ip_address_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The List publicIpAddress opertion retrieves all the publicIpAddresses
         in a resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         PublicIpAddressListResponse: Response for ListPublicIpAddresses Api
         service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/publicIPAddresses'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = PublicIpAddressListResponse(public_ip_addresses=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        public_ip_address_json_format_instance = PublicIpAddress(tags={})
                        result.public_ip_addresses.append(public_ip_address_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            public_ip_allocation_method_value = properties_value.get('publicIPAllocationMethod', None)
                            if public_ip_allocation_method_value is not None:
                                public_ip_allocation_method_instance = public_ip_allocation_method_value
                                public_ip_address_json_format_instance.public_ip_allocation_method = public_ip_allocation_method_instance
                            
                            ip_configuration_value = properties_value.get('ipConfiguration', None)
                            if ip_configuration_value is not None:
                                ip_configuration_instance = ResourceId()
                                public_ip_address_json_format_instance.ip_configuration = ip_configuration_instance
                                
                                id_value = ip_configuration_value.get('id', None)
                                if id_value is not None:
                                    id_instance = id_value
                                    ip_configuration_instance.id = id_instance
                                
                            dns_settings_value = properties_value.get('dnsSettings', None)
                            if dns_settings_value is not None:
                                dns_settings_instance = PublicIpAddressDnsSettings()
                                public_ip_address_json_format_instance.dns_settings = dns_settings_instance
                                
                                domain_name_label_value = dns_settings_value.get('domainNameLabel', None)
                                if domain_name_label_value is not None:
                                    domain_name_label_instance = domain_name_label_value
                                    dns_settings_instance.domain_name_label = domain_name_label_instance
                                
                                fqdn_value = dns_settings_value.get('fqdn', None)
                                if fqdn_value is not None:
                                    fqdn_instance = fqdn_value
                                    dns_settings_instance.fqdn = fqdn_instance
                                
                                reverse_fqdn_value = dns_settings_value.get('reverseFqdn', None)
                                if reverse_fqdn_value is not None:
                                    reverse_fqdn_instance = reverse_fqdn_value
                                    dns_settings_instance.reverse_fqdn = reverse_fqdn_instance
                                
                            ip_address_value = properties_value.get('ipAddress', None)
                            if ip_address_value is not None:
                                ip_address_instance = ip_address_value
                                public_ip_address_json_format_instance.ip_address = ip_address_instance
                            
                            idle_timeout_in_minutes_value = properties_value.get('idleTimeoutInMinutes', None)
                            if idle_timeout_in_minutes_value is not None:
                                idle_timeout_in_minutes_instance = idle_timeout_in_minutes_value
                                public_ip_address_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance
                            
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                public_ip_address_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        etag_value = value_value.get('etag', None)
                        if etag_value is not None:
                            etag_instance = etag_value
                            public_ip_address_json_format_instance.etag = etag_instance
                        
                        id_value2 = value_value.get('id', None)
                        if id_value2 is not None:
                            id_instance2 = id_value2
                            public_ip_address_json_format_instance.id = id_instance2
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            public_ip_address_json_format_instance.name = name_instance
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            public_ip_address_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            public_ip_address_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                public_ip_address_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_all(self):
        """
         The List publicIpAddress opertion retrieves all the publicIpAddresses
         in a subscription.
         
         Returns:
         
         PublicIpAddressListResponse: Response for ListPublicIpAddresses Api
         service call
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/publicIPAddresses'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = PublicIpAddressListResponse(public_ip_addresses=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        public_ip_address_json_format_instance = PublicIpAddress(tags={})
                        result.public_ip_addresses.append(public_ip_address_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            public_ip_allocation_method_value = properties_value.get('publicIPAllocationMethod', None)
                            if public_ip_allocation_method_value is not None:
                                public_ip_allocation_method_instance = public_ip_allocation_method_value
                                public_ip_address_json_format_instance.public_ip_allocation_method = public_ip_allocation_method_instance
                            
                            ip_configuration_value = properties_value.get('ipConfiguration', None)
                            if ip_configuration_value is not None:
                                ip_configuration_instance = ResourceId()
                                public_ip_address_json_format_instance.ip_configuration = ip_configuration_instance
                                
                                id_value = ip_configuration_value.get('id', None)
                                if id_value is not None:
                                    id_instance = id_value
                                    ip_configuration_instance.id = id_instance
                                
                            dns_settings_value = properties_value.get('dnsSettings', None)
                            if dns_settings_value is not None:
                                dns_settings_instance = PublicIpAddressDnsSettings()
                                public_ip_address_json_format_instance.dns_settings = dns_settings_instance
                                
                                domain_name_label_value = dns_settings_value.get('domainNameLabel', None)
                                if domain_name_label_value is not None:
                                    domain_name_label_instance = domain_name_label_value
                                    dns_settings_instance.domain_name_label = domain_name_label_instance
                                
                                fqdn_value = dns_settings_value.get('fqdn', None)
                                if fqdn_value is not None:
                                    fqdn_instance = fqdn_value
                                    dns_settings_instance.fqdn = fqdn_instance
                                
                                reverse_fqdn_value = dns_settings_value.get('reverseFqdn', None)
                                if reverse_fqdn_value is not None:
                                    reverse_fqdn_instance = reverse_fqdn_value
                                    dns_settings_instance.reverse_fqdn = reverse_fqdn_instance
                                
                            ip_address_value = properties_value.get('ipAddress', None)
                            if ip_address_value is not None:
                                ip_address_instance = ip_address_value
                                public_ip_address_json_format_instance.ip_address = ip_address_instance
                            
                            idle_timeout_in_minutes_value = properties_value.get('idleTimeoutInMinutes', None)
                            if idle_timeout_in_minutes_value is not None:
                                idle_timeout_in_minutes_instance = idle_timeout_in_minutes_value
                                public_ip_address_json_format_instance.idle_timeout_in_minutes = idle_timeout_in_minutes_instance
                            
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                public_ip_address_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        etag_value = value_value.get('etag', None)
                        if etag_value is not None:
                            etag_instance = etag_value
                            public_ip_address_json_format_instance.etag = etag_instance
                        
                        id_value2 = value_value.get('id', None)
                        if id_value2 is not None:
                            id_instance2 = id_value2
                            public_ip_address_json_format_instance.id = id_instance2
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            public_ip_address_json_format_instance.name = name_instance
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            public_ip_address_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            public_ip_address_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                public_ip_address_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class SecurityRuleOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     SecurityRules for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, network_security_group_name, security_rule_name, security_rule_parameters):
        """
         The Put network security rule operation creates/updates a security
         rule in the specified network security group
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         security_rule_name (string): The name of the security rule.
         
         security_rule_parameters (SecurityRule): Parameters supplied to the
         create/update network security rule operation
         
         Returns:
         
         SecurityRulePutResponse: Response for PUT SecurityRule Api service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_security_group_name is None:
            raise ValueError('network_security_group_name cannot be None.')
        
        if security_rule_name is None:
            raise ValueError('security_rule_name cannot be None.')
        
        if security_rule_parameters is None:
            raise ValueError('security_rule_parameters cannot be None.')
        
        if security_rule_parameters.access is None:
            raise ValueError('security_rule_parameters.access cannot be None.')
        
        if security_rule_parameters.destination_address_prefix is None:
            raise ValueError('security_rule_parameters.destination_address_prefix cannot be None.')
        
        if security_rule_parameters.direction is None:
            raise ValueError('security_rule_parameters.direction cannot be None.')
        
        if security_rule_parameters.protocol is None:
            raise ValueError('security_rule_parameters.protocol cannot be None.')
        
        if security_rule_parameters.source_address_prefix is None:
            raise ValueError('security_rule_parameters.source_address_prefix cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups/'
        url = url + quote(network_security_group_name)
        url = url + '/securityRules/'
        url = url + quote(security_rule_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        security_rule_json_format_value = {}
        request_doc = security_rule_json_format_value
        
        properties_value = {}
        security_rule_json_format_value['properties'] = properties_value
        
        if security_rule_parameters.description is not None:
            properties_value['description'] = security_rule_parameters.description
        
        properties_value['protocol'] = security_rule_parameters.protocol
        
        if security_rule_parameters.source_port_range is not None:
            properties_value['sourcePortRange'] = security_rule_parameters.source_port_range
        
        if security_rule_parameters.destination_port_range is not None:
            properties_value['destinationPortRange'] = security_rule_parameters.destination_port_range
        
        properties_value['sourceAddressPrefix'] = security_rule_parameters.source_address_prefix
        
        properties_value['destinationAddressPrefix'] = security_rule_parameters.destination_address_prefix
        
        properties_value['access'] = security_rule_parameters.access
        
        if security_rule_parameters.priority is not None:
            properties_value['priority'] = security_rule_parameters.priority
        
        properties_value['direction'] = security_rule_parameters.direction
        
        if security_rule_parameters.provisioning_state is not None:
            properties_value['provisioningState'] = security_rule_parameters.provisioning_state
        
        if security_rule_parameters.name is not None:
            security_rule_json_format_value['name'] = security_rule_parameters.name
        
        if security_rule_parameters.etag is not None:
            security_rule_json_format_value['etag'] = security_rule_parameters.etag
        
        if security_rule_parameters.id is not None:
            security_rule_json_format_value['id'] = security_rule_parameters.id
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = SecurityRulePutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                security_rule_instance = SecurityRule()
                result.security_rule = security_rule_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    description_value = properties_value2.get('description', None)
                    if description_value is not None:
                        description_instance = description_value
                        security_rule_instance.description = description_instance
                    
                    protocol_value = properties_value2.get('protocol', None)
                    if protocol_value is not None:
                        protocol_instance = protocol_value
                        security_rule_instance.protocol = protocol_instance
                    
                    source_port_range_value = properties_value2.get('sourcePortRange', None)
                    if source_port_range_value is not None:
                        source_port_range_instance = source_port_range_value
                        security_rule_instance.source_port_range = source_port_range_instance
                    
                    destination_port_range_value = properties_value2.get('destinationPortRange', None)
                    if destination_port_range_value is not None:
                        destination_port_range_instance = destination_port_range_value
                        security_rule_instance.destination_port_range = destination_port_range_instance
                    
                    source_address_prefix_value = properties_value2.get('sourceAddressPrefix', None)
                    if source_address_prefix_value is not None:
                        source_address_prefix_instance = source_address_prefix_value
                        security_rule_instance.source_address_prefix = source_address_prefix_instance
                    
                    destination_address_prefix_value = properties_value2.get('destinationAddressPrefix', None)
                    if destination_address_prefix_value is not None:
                        destination_address_prefix_instance = destination_address_prefix_value
                        security_rule_instance.destination_address_prefix = destination_address_prefix_instance
                    
                    access_value = properties_value2.get('access', None)
                    if access_value is not None:
                        access_instance = access_value
                        security_rule_instance.access = access_instance
                    
                    priority_value = properties_value2.get('priority', None)
                    if priority_value is not None:
                        priority_instance = priority_value
                        security_rule_instance.priority = priority_instance
                    
                    direction_value = properties_value2.get('direction', None)
                    if direction_value is not None:
                        direction_instance = direction_value
                        security_rule_instance.direction = direction_instance
                    
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        security_rule_instance.provisioning_state = provisioning_state_instance
                    
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    security_rule_instance.name = name_instance
                
                etag_value = response_doc.get('etag', None)
                if etag_value is not None:
                    etag_instance = etag_value
                    security_rule_instance.etag = etag_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    security_rule_instance.id = id_instance
                
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, network_security_group_name, security_rule_name):
        """
         The delete network security rule operation deletes the specified
         network security rule.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         security_rule_name (string): The name of the security rule.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_security_group_name is None:
            raise ValueError('network_security_group_name cannot be None.')
        
        if security_rule_name is None:
            raise ValueError('security_rule_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups/'
        url = url + quote(network_security_group_name)
        url = url + '/securityRules/'
        url = url + quote(security_rule_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, network_security_group_name, security_rule_name, security_rule_parameters):
        """
         The Put network security rule operation creates/updates a security
         rule in the specified network security group
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         security_rule_name (string): The name of the security rule.
         
         security_rule_parameters (SecurityRule): Parameters supplied to the
         create/update network security rule operation
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.security_rules.begin_create_or_updating(resource_group_name, network_security_group_name, security_rule_name, security_rule_parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, network_security_group_name, security_rule_name):
        """
         The delete network security rule operation deletes the specified
         network security rule.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         security_rule_name (string): The name of the security rule.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.security_rules.begin_deleting(resource_group_name, network_security_group_name, security_rule_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, network_security_group_name, security_rule_name):
        """
         The Get NetworkSecurityRule operation retreives information about the
         specified network security rule.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         security_rule_name (string): The name of the security rule.
         
         Returns:
         
         SecurityRuleGetResponse: Response for GetSecurityRule Api service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_security_group_name is None:
            raise ValueError('network_security_group_name cannot be None.')
        
        if security_rule_name is None:
            raise ValueError('security_rule_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups/'
        url = url + quote(network_security_group_name)
        url = url + '/securityRules/'
        url = url + quote(security_rule_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = SecurityRuleGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                security_rule_instance = SecurityRule()
                result.security_rule = security_rule_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    description_value = properties_value.get('description', None)
                    if description_value is not None:
                        description_instance = description_value
                        security_rule_instance.description = description_instance
                    
                    protocol_value = properties_value.get('protocol', None)
                    if protocol_value is not None:
                        protocol_instance = protocol_value
                        security_rule_instance.protocol = protocol_instance
                    
                    source_port_range_value = properties_value.get('sourcePortRange', None)
                    if source_port_range_value is not None:
                        source_port_range_instance = source_port_range_value
                        security_rule_instance.source_port_range = source_port_range_instance
                    
                    destination_port_range_value = properties_value.get('destinationPortRange', None)
                    if destination_port_range_value is not None:
                        destination_port_range_instance = destination_port_range_value
                        security_rule_instance.destination_port_range = destination_port_range_instance
                    
                    source_address_prefix_value = properties_value.get('sourceAddressPrefix', None)
                    if source_address_prefix_value is not None:
                        source_address_prefix_instance = source_address_prefix_value
                        security_rule_instance.source_address_prefix = source_address_prefix_instance
                    
                    destination_address_prefix_value = properties_value.get('destinationAddressPrefix', None)
                    if destination_address_prefix_value is not None:
                        destination_address_prefix_instance = destination_address_prefix_value
                        security_rule_instance.destination_address_prefix = destination_address_prefix_instance
                    
                    access_value = properties_value.get('access', None)
                    if access_value is not None:
                        access_instance = access_value
                        security_rule_instance.access = access_instance
                    
                    priority_value = properties_value.get('priority', None)
                    if priority_value is not None:
                        priority_instance = priority_value
                        security_rule_instance.priority = priority_instance
                    
                    direction_value = properties_value.get('direction', None)
                    if direction_value is not None:
                        direction_instance = direction_value
                        security_rule_instance.direction = direction_instance
                    
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        security_rule_instance.provisioning_state = provisioning_state_instance
                    
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    security_rule_instance.name = name_instance
                
                etag_value = response_doc.get('etag', None)
                if etag_value is not None:
                    etag_instance = etag_value
                    security_rule_instance.etag = etag_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    security_rule_instance.id = id_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name, network_security_group_name):
        """
         The List network security rule opertion retrieves all the security
         rules in a network security group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         network_security_group_name (string): The name of the network security
         group.
         
         Returns:
         
         SecurityRuleListResponse: Response for ListSecurityRule Api service
         callRetrieves all security rules that belongs to a network security
         group
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if network_security_group_name is None:
            raise ValueError('network_security_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/networkSecurityGroups/'
        url = url + quote(network_security_group_name)
        url = url + '/securityRules'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = SecurityRuleListResponse(security_rules=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        security_rule_json_format_instance = SecurityRule()
                        result.security_rules.append(security_rule_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            description_value = properties_value.get('description', None)
                            if description_value is not None:
                                description_instance = description_value
                                security_rule_json_format_instance.description = description_instance
                            
                            protocol_value = properties_value.get('protocol', None)
                            if protocol_value is not None:
                                protocol_instance = protocol_value
                                security_rule_json_format_instance.protocol = protocol_instance
                            
                            source_port_range_value = properties_value.get('sourcePortRange', None)
                            if source_port_range_value is not None:
                                source_port_range_instance = source_port_range_value
                                security_rule_json_format_instance.source_port_range = source_port_range_instance
                            
                            destination_port_range_value = properties_value.get('destinationPortRange', None)
                            if destination_port_range_value is not None:
                                destination_port_range_instance = destination_port_range_value
                                security_rule_json_format_instance.destination_port_range = destination_port_range_instance
                            
                            source_address_prefix_value = properties_value.get('sourceAddressPrefix', None)
                            if source_address_prefix_value is not None:
                                source_address_prefix_instance = source_address_prefix_value
                                security_rule_json_format_instance.source_address_prefix = source_address_prefix_instance
                            
                            destination_address_prefix_value = properties_value.get('destinationAddressPrefix', None)
                            if destination_address_prefix_value is not None:
                                destination_address_prefix_instance = destination_address_prefix_value
                                security_rule_json_format_instance.destination_address_prefix = destination_address_prefix_instance
                            
                            access_value = properties_value.get('access', None)
                            if access_value is not None:
                                access_instance = access_value
                                security_rule_json_format_instance.access = access_instance
                            
                            priority_value = properties_value.get('priority', None)
                            if priority_value is not None:
                                priority_instance = priority_value
                                security_rule_json_format_instance.priority = priority_instance
                            
                            direction_value = properties_value.get('direction', None)
                            if direction_value is not None:
                                direction_instance = direction_value
                                security_rule_json_format_instance.direction = direction_instance
                            
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                security_rule_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            security_rule_json_format_instance.name = name_instance
                        
                        etag_value = value_value.get('etag', None)
                        if etag_value is not None:
                            etag_instance = etag_value
                            security_rule_json_format_instance.etag = etag_instance
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            security_rule_json_format_instance.id = id_instance
                        
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class SubnetOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     subnets for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, virtual_network_name, subnet_name, subnet_parameters):
        """
         The Put Subnet operation creates/updates a subnet in thespecified
         virtual network
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         subnet_name (string): The name of the subnet.
         
         subnet_parameters (Subnet): Parameters supplied to the create/update
         Subnet operation
         
         Returns:
         
         SubnetPutResponse: Response for PutSubnet Api service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_name is None:
            raise ValueError('virtual_network_name cannot be None.')
        
        if subnet_name is None:
            raise ValueError('subnet_name cannot be None.')
        
        if subnet_parameters is None:
            raise ValueError('subnet_parameters cannot be None.')
        
        if subnet_parameters.address_prefix is None:
            raise ValueError('subnet_parameters.address_prefix cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks/'
        url = url + quote(virtual_network_name)
        url = url + '/subnets/'
        url = url + quote(subnet_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        subnet_json_format_value = {}
        request_doc = subnet_json_format_value
        
        properties_value = {}
        subnet_json_format_value['properties'] = properties_value
        
        properties_value['addressPrefix'] = subnet_parameters.address_prefix
        
        if subnet_parameters.network_security_group is not None:
            network_security_group_value = {}
            properties_value['networkSecurityGroup'] = network_security_group_value
            
            if subnet_parameters.network_security_group.id is not None:
                network_security_group_value['id'] = subnet_parameters.network_security_group.id
            
        if subnet_parameters.ip_configurations is not None:
            ip_configurations_array = []
            for ip_configurations_item in subnet_parameters.ip_configurations:
                resource_id_value = {}
                ip_configurations_array.append(resource_id_value)
                
                if ip_configurations_item.id is not None:
                    resource_id_value['id'] = ip_configurations_item.id
                
            properties_value['ipConfigurations'] = ip_configurations_array
        
        if subnet_parameters.provisioning_state is not None:
            properties_value['provisioningState'] = subnet_parameters.provisioning_state
        
        if subnet_parameters.name is not None:
            subnet_json_format_value['name'] = subnet_parameters.name
        
        if subnet_parameters.etag is not None:
            subnet_json_format_value['etag'] = subnet_parameters.etag
        
        if subnet_parameters.id is not None:
            subnet_json_format_value['id'] = subnet_parameters.id
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = SubnetPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                subnet_instance = Subnet(ip_configurations=[])
                result.subnet = subnet_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    address_prefix_value = properties_value2.get('addressPrefix', None)
                    if address_prefix_value is not None:
                        address_prefix_instance = address_prefix_value
                        subnet_instance.address_prefix = address_prefix_instance
                    
                    network_security_group_value2 = properties_value2.get('networkSecurityGroup', None)
                    if network_security_group_value2 is not None:
                        network_security_group_instance = ResourceId()
                        subnet_instance.network_security_group = network_security_group_instance
                        
                        id_value = network_security_group_value2.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            network_security_group_instance.id = id_instance
                        
                    ip_configurations_array2 = properties_value2.get('ipConfigurations', None)
                    if ip_configurations_array2 is not None:
                        for ip_configurations_value in ip_configurations_array2:
                            resource_id_instance = ResourceId()
                            subnet_instance.ip_configurations.append(resource_id_instance)
                            
                            id_value2 = ip_configurations_value.get('id', None)
                            if id_value2 is not None:
                                id_instance2 = id_value2
                                resource_id_instance.id = id_instance2
                            
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        subnet_instance.provisioning_state = provisioning_state_instance
                    
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    subnet_instance.name = name_instance
                
                etag_value = response_doc.get('etag', None)
                if etag_value is not None:
                    etag_instance = etag_value
                    subnet_instance.etag = etag_instance
                
                id_value3 = response_doc.get('id', None)
                if id_value3 is not None:
                    id_instance3 = id_value3
                    subnet_instance.id = id_instance3
                
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, virtual_network_name, subnet_name):
        """
         The delete subnet operation deletes the specified subnet.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         subnet_name (string): The name of the subnet.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_name is None:
            raise ValueError('virtual_network_name cannot be None.')
        
        if subnet_name is None:
            raise ValueError('subnet_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks/'
        url = url + quote(virtual_network_name)
        url = url + '/subnets/'
        url = url + quote(subnet_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, virtual_network_name, subnet_name, subnet_parameters):
        """
         The Put Subnet operation creates/updates a subnet in thespecified
         virtual network
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         subnet_name (string): The name of the subnet.
         
         subnet_parameters (Subnet): Parameters supplied to the create/update
         Subnet operation
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.subnets.begin_create_or_updating(resource_group_name, virtual_network_name, subnet_name, subnet_parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, virtual_network_name, subnet_name):
        """
         The delete subnet operation deletes the specified subnet.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         subnet_name (string): The name of the subnet.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.subnets.begin_deleting(resource_group_name, virtual_network_name, subnet_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, virtual_network_name, subnet_name):
        """
         The Get subnet operation retreives information about the specified
         subnet.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         subnet_name (string): The name of the subnet.
         
         Returns:
         
         SubnetGetResponse: Response for GetSubnet Api service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_name is None:
            raise ValueError('virtual_network_name cannot be None.')
        
        if subnet_name is None:
            raise ValueError('subnet_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks/'
        url = url + quote(virtual_network_name)
        url = url + '/subnets/'
        url = url + quote(subnet_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = SubnetGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                subnet_instance = Subnet(ip_configurations=[])
                result.subnet = subnet_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    address_prefix_value = properties_value.get('addressPrefix', None)
                    if address_prefix_value is not None:
                        address_prefix_instance = address_prefix_value
                        subnet_instance.address_prefix = address_prefix_instance
                    
                    network_security_group_value = properties_value.get('networkSecurityGroup', None)
                    if network_security_group_value is not None:
                        network_security_group_instance = ResourceId()
                        subnet_instance.network_security_group = network_security_group_instance
                        
                        id_value = network_security_group_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            network_security_group_instance.id = id_instance
                        
                    ip_configurations_array = properties_value.get('ipConfigurations', None)
                    if ip_configurations_array is not None:
                        for ip_configurations_value in ip_configurations_array:
                            resource_id_instance = ResourceId()
                            subnet_instance.ip_configurations.append(resource_id_instance)
                            
                            id_value2 = ip_configurations_value.get('id', None)
                            if id_value2 is not None:
                                id_instance2 = id_value2
                                resource_id_instance.id = id_instance2
                            
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        subnet_instance.provisioning_state = provisioning_state_instance
                    
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    subnet_instance.name = name_instance
                
                etag_value = response_doc.get('etag', None)
                if etag_value is not None:
                    etag_instance = etag_value
                    subnet_instance.etag = etag_instance
                
                id_value3 = response_doc.get('id', None)
                if id_value3 is not None:
                    id_instance3 = id_value3
                    subnet_instance.id = id_instance3
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name, virtual_network_name):
        """
         The List subnets opertion retrieves all the subnets in a virtual
         network.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         Returns:
         
         SubnetListResponse: Response for ListSubnets Api service callRetrieves
         all subnet that belongs to a virtual network
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_name is None:
            raise ValueError('virtual_network_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks/'
        url = url + quote(virtual_network_name)
        url = url + '/subnets'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = SubnetListResponse(subnets=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        subnet_json_format_instance = Subnet(ip_configurations=[])
                        result.subnets.append(subnet_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            address_prefix_value = properties_value.get('addressPrefix', None)
                            if address_prefix_value is not None:
                                address_prefix_instance = address_prefix_value
                                subnet_json_format_instance.address_prefix = address_prefix_instance
                            
                            network_security_group_value = properties_value.get('networkSecurityGroup', None)
                            if network_security_group_value is not None:
                                network_security_group_instance = ResourceId()
                                subnet_json_format_instance.network_security_group = network_security_group_instance
                                
                                id_value = network_security_group_value.get('id', None)
                                if id_value is not None:
                                    id_instance = id_value
                                    network_security_group_instance.id = id_instance
                                
                            ip_configurations_array = properties_value.get('ipConfigurations', None)
                            if ip_configurations_array is not None:
                                for ip_configurations_value in ip_configurations_array:
                                    resource_id_instance = ResourceId()
                                    subnet_json_format_instance.ip_configurations.append(resource_id_instance)
                                    
                                    id_value2 = ip_configurations_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        resource_id_instance.id = id_instance2
                                    
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                subnet_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            subnet_json_format_instance.name = name_instance
                        
                        etag_value = value_value.get('etag', None)
                        if etag_value is not None:
                            etag_instance = etag_value
                            subnet_json_format_instance.etag = etag_instance
                        
                        id_value3 = value_value.get('id', None)
                        if id_value3 is not None:
                            id_instance3 = id_value3
                            subnet_json_format_instance.id = id_instance3
                        
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class UsageOperations(object):
    """
     Operations for listing usage.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def list(self, location):
        """
         Lists compute usages for a subscription.
         
         Args:
         
         location (string): The location upon which resource usage is queried.
         
         Returns:
         
         UsagesListResponse: The List Usages operation response.
        """
        # Validate
        if location is None:
            raise ValueError('location cannot be None.')
        
        if location is not None and len(location) > 1000:
            raise IndexError('location is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', location) is not None) == False:
            raise IndexError('location is outside the valid range.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/locations/'
        url = url + quote(location)
        url = url + '/usages'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = UsagesListResponse(usages=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        usage_instance = Usage()
                        result.usages.append(usage_instance)
                        
                        unit_value = value_value.get('unit', None)
                        if unit_value is not None:
                            unit_instance = unit_value
                            usage_instance.unit = unit_instance
                        
                        current_value_value = value_value.get('currentValue', None)
                        if current_value_value is not None:
                            current_value_instance = current_value_value
                            usage_instance.current_value = current_value_instance
                        
                        limit_value = value_value.get('limit', None)
                        if limit_value is not None:
                            limit_instance = limit_value
                            usage_instance.limit = limit_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = UsageName()
                            usage_instance.name = name_instance
                            
                            value_value2 = name_value.get('value', None)
                            if value_value2 is not None:
                                value_instance = value_value2
                                name_instance.value = value_instance
                            
                            localized_value_value = name_value.get('localizedValue', None)
                            if localized_value_value is not None:
                                localized_value_instance = localized_value_value
                                name_instance.localized_value = localized_value_instance
                            
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class VirtualNetworkGatewayConnectionOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     Virtual network Gateway for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, virtual_network_gateway_connection_name, parameters):
        """
         The Put VirtualNetworkGatewayConnection operation creates/updates a
         virtual network gateway connection in the specified resource group
         through Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The name of the
         virtual network gateway conenction.
         
         parameters (VirtualNetworkGatewayConnection): Parameters supplied to
         the Begin Create or update Virtual Network Gateway connection
         operation through Network resource provider.
         
         Returns:
         
         VirtualNetworkGatewayConnectionPutResponse: Response for
         CreateOrUpdateVirtualNetworkGatewayConnection Api servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_connection_name is None:
            raise ValueError('virtual_network_gateway_connection_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.local_network_gateway2 is not None:
            if parameters.local_network_gateway2.location is None:
                raise ValueError('parameters.local_network_gateway2.location cannot be None.')
            
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        if parameters.virtual_network_gateway1 is not None:
            if parameters.virtual_network_gateway1.location is None:
                raise ValueError('parameters.virtual_network_gateway1.location cannot be None.')
            
        if parameters.virtual_network_gateway2 is not None:
            if parameters.virtual_network_gateway2.location is None:
                raise ValueError('parameters.virtual_network_gateway2.location cannot be None.')
            
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/connections/'
        url = url + quote(virtual_network_gateway_connection_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        virtual_network_gateway_connection_json_format_value = {}
        request_doc = virtual_network_gateway_connection_json_format_value
        
        properties_value = {}
        virtual_network_gateway_connection_json_format_value['properties'] = properties_value
        
        if parameters.virtual_network_gateway1 is not None:
            virtual_network_gateway1_value = {}
            properties_value['virtualNetworkGateway1'] = virtual_network_gateway1_value
            
            if parameters.virtual_network_gateway1.ip_configurations is not None:
                ip_configurations_array = []
                for ip_configurations_item in parameters.virtual_network_gateway1.ip_configurations:
                    virtual_network_gateway_ip_configuration_value = {}
                    ip_configurations_array.append(virtual_network_gateway_ip_configuration_value)
                    
                    if ip_configurations_item.private_ip_address is not None:
                        virtual_network_gateway_ip_configuration_value['privateIPAddress'] = ip_configurations_item.private_ip_address
                    
                    if ip_configurations_item.private_ip_allocation_method is not None:
                        virtual_network_gateway_ip_configuration_value['privateIPAllocationMethod'] = ip_configurations_item.private_ip_allocation_method
                    
                    if ip_configurations_item.subnet is not None:
                        subnet_value = {}
                        virtual_network_gateway_ip_configuration_value['subnet'] = subnet_value
                        
                        if ip_configurations_item.subnet.id is not None:
                            subnet_value['id'] = ip_configurations_item.subnet.id
                        
                    if ip_configurations_item.public_ip_address is not None:
                        public_ip_address_value = {}
                        virtual_network_gateway_ip_configuration_value['publicIPAddress'] = public_ip_address_value
                        
                        if ip_configurations_item.public_ip_address.id is not None:
                            public_ip_address_value['id'] = ip_configurations_item.public_ip_address.id
                        
                    if ip_configurations_item.provisioning_state is not None:
                        virtual_network_gateway_ip_configuration_value['provisioningState'] = ip_configurations_item.provisioning_state
                    
                    if ip_configurations_item.name is not None:
                        virtual_network_gateway_ip_configuration_value['name'] = ip_configurations_item.name
                    
                    if ip_configurations_item.etag is not None:
                        virtual_network_gateway_ip_configuration_value['etag'] = ip_configurations_item.etag
                    
                    if ip_configurations_item.id is not None:
                        virtual_network_gateway_ip_configuration_value['id'] = ip_configurations_item.id
                    
                virtual_network_gateway1_value['ipConfigurations'] = ip_configurations_array
            
            if parameters.virtual_network_gateway1.gateway_size is not None:
                virtual_network_gateway1_value['gatewaySize'] = parameters.virtual_network_gateway1.gateway_size
            
            if parameters.virtual_network_gateway1.gateway_type is not None:
                virtual_network_gateway1_value['gatewayType'] = parameters.virtual_network_gateway1.gateway_type
            
            if parameters.virtual_network_gateway1.enable_bgp is not None:
                virtual_network_gateway1_value['enableBgp'] = parameters.virtual_network_gateway1.enable_bgp
            
            if parameters.virtual_network_gateway1.provisioning_state is not None:
                virtual_network_gateway1_value['provisioningState'] = parameters.virtual_network_gateway1.provisioning_state
            
            if parameters.virtual_network_gateway1.etag is not None:
                virtual_network_gateway1_value['etag'] = parameters.virtual_network_gateway1.etag
            
            if parameters.virtual_network_gateway1.id is not None:
                virtual_network_gateway1_value['id'] = parameters.virtual_network_gateway1.id
            
            if parameters.virtual_network_gateway1.name is not None:
                virtual_network_gateway1_value['name'] = parameters.virtual_network_gateway1.name
            
            if parameters.virtual_network_gateway1.type is not None:
                virtual_network_gateway1_value['type'] = parameters.virtual_network_gateway1.type
            
            virtual_network_gateway1_value['location'] = parameters.virtual_network_gateway1.location
            
            if parameters.virtual_network_gateway1.tags is not None:
                tags_dictionary = {}
                for tags_key in parameters.virtual_network_gateway1.tags:
                    tags_value = parameters.virtual_network_gateway1.tags[tags_key]
                    tags_dictionary[tags_key] = tags_value
                
                virtual_network_gateway1_value['tags'] = tags_dictionary
            
        if parameters.virtual_network_gateway2 is not None:
            virtual_network_gateway2_value = {}
            properties_value['virtualNetworkGateway2'] = virtual_network_gateway2_value
            
            if parameters.virtual_network_gateway2.ip_configurations is not None:
                ip_configurations_array2 = []
                for ip_configurations_item2 in parameters.virtual_network_gateway2.ip_configurations:
                    virtual_network_gateway_ip_configuration_value2 = {}
                    ip_configurations_array2.append(virtual_network_gateway_ip_configuration_value2)
                    
                    if ip_configurations_item2.private_ip_address is not None:
                        virtual_network_gateway_ip_configuration_value2['privateIPAddress'] = ip_configurations_item2.private_ip_address
                    
                    if ip_configurations_item2.private_ip_allocation_method is not None:
                        virtual_network_gateway_ip_configuration_value2['privateIPAllocationMethod'] = ip_configurations_item2.private_ip_allocation_method
                    
                    if ip_configurations_item2.subnet is not None:
                        subnet_value2 = {}
                        virtual_network_gateway_ip_configuration_value2['subnet'] = subnet_value2
                        
                        if ip_configurations_item2.subnet.id is not None:
                            subnet_value2['id'] = ip_configurations_item2.subnet.id
                        
                    if ip_configurations_item2.public_ip_address is not None:
                        public_ip_address_value2 = {}
                        virtual_network_gateway_ip_configuration_value2['publicIPAddress'] = public_ip_address_value2
                        
                        if ip_configurations_item2.public_ip_address.id is not None:
                            public_ip_address_value2['id'] = ip_configurations_item2.public_ip_address.id
                        
                    if ip_configurations_item2.provisioning_state is not None:
                        virtual_network_gateway_ip_configuration_value2['provisioningState'] = ip_configurations_item2.provisioning_state
                    
                    if ip_configurations_item2.name is not None:
                        virtual_network_gateway_ip_configuration_value2['name'] = ip_configurations_item2.name
                    
                    if ip_configurations_item2.etag is not None:
                        virtual_network_gateway_ip_configuration_value2['etag'] = ip_configurations_item2.etag
                    
                    if ip_configurations_item2.id is not None:
                        virtual_network_gateway_ip_configuration_value2['id'] = ip_configurations_item2.id
                    
                virtual_network_gateway2_value['ipConfigurations'] = ip_configurations_array2
            
            if parameters.virtual_network_gateway2.gateway_size is not None:
                virtual_network_gateway2_value['gatewaySize'] = parameters.virtual_network_gateway2.gateway_size
            
            if parameters.virtual_network_gateway2.gateway_type is not None:
                virtual_network_gateway2_value['gatewayType'] = parameters.virtual_network_gateway2.gateway_type
            
            if parameters.virtual_network_gateway2.enable_bgp is not None:
                virtual_network_gateway2_value['enableBgp'] = parameters.virtual_network_gateway2.enable_bgp
            
            if parameters.virtual_network_gateway2.provisioning_state is not None:
                virtual_network_gateway2_value['provisioningState'] = parameters.virtual_network_gateway2.provisioning_state
            
            if parameters.virtual_network_gateway2.etag is not None:
                virtual_network_gateway2_value['etag'] = parameters.virtual_network_gateway2.etag
            
            if parameters.virtual_network_gateway2.id is not None:
                virtual_network_gateway2_value['id'] = parameters.virtual_network_gateway2.id
            
            if parameters.virtual_network_gateway2.name is not None:
                virtual_network_gateway2_value['name'] = parameters.virtual_network_gateway2.name
            
            if parameters.virtual_network_gateway2.type is not None:
                virtual_network_gateway2_value['type'] = parameters.virtual_network_gateway2.type
            
            virtual_network_gateway2_value['location'] = parameters.virtual_network_gateway2.location
            
            if parameters.virtual_network_gateway2.tags is not None:
                tags_dictionary2 = {}
                for tags_key2 in parameters.virtual_network_gateway2.tags:
                    tags_value2 = parameters.virtual_network_gateway2.tags[tags_key2]
                    tags_dictionary2[tags_key2] = tags_value2
                
                virtual_network_gateway2_value['tags'] = tags_dictionary2
            
        if parameters.local_network_gateway2 is not None:
            local_network_gateway2_value = {}
            properties_value['localNetworkGateway2'] = local_network_gateway2_value
            
            if parameters.local_network_gateway2.gateway_ip_address is not None:
                local_network_gateway2_value['gatewayIpAddress'] = parameters.local_network_gateway2.gateway_ip_address
            
            if parameters.local_network_gateway2.local_network_site_address_space is not None:
                local_network_site_address_space_value = {}
                local_network_gateway2_value['localNetworkSiteAddressSpace'] = local_network_site_address_space_value
                
                if parameters.local_network_gateway2.local_network_site_address_space.address_prefixes is not None:
                    address_prefixes_array = []
                    for address_prefixes_item in parameters.local_network_gateway2.local_network_site_address_space.address_prefixes:
                        address_prefixes_array.append(address_prefixes_item)
                    
                    local_network_site_address_space_value['addressPrefixes'] = address_prefixes_array
                
            if parameters.local_network_gateway2.provisioning_state is not None:
                local_network_gateway2_value['provisioningState'] = parameters.local_network_gateway2.provisioning_state
            
            if parameters.local_network_gateway2.etag is not None:
                local_network_gateway2_value['etag'] = parameters.local_network_gateway2.etag
            
            if parameters.local_network_gateway2.id is not None:
                local_network_gateway2_value['id'] = parameters.local_network_gateway2.id
            
            if parameters.local_network_gateway2.name is not None:
                local_network_gateway2_value['name'] = parameters.local_network_gateway2.name
            
            if parameters.local_network_gateway2.type is not None:
                local_network_gateway2_value['type'] = parameters.local_network_gateway2.type
            
            local_network_gateway2_value['location'] = parameters.local_network_gateway2.location
            
            if parameters.local_network_gateway2.tags is not None:
                tags_dictionary3 = {}
                for tags_key3 in parameters.local_network_gateway2.tags:
                    tags_value3 = parameters.local_network_gateway2.tags[tags_key3]
                    tags_dictionary3[tags_key3] = tags_value3
                
                local_network_gateway2_value['tags'] = tags_dictionary3
            
        if parameters.connection_type is not None:
            properties_value['connectionType'] = parameters.connection_type
        
        if parameters.routing_weight is not None:
            properties_value['routingWeight'] = parameters.routing_weight
        
        if parameters.shared_key is not None:
            properties_value['sharedKey'] = parameters.shared_key
        
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            virtual_network_gateway_connection_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            virtual_network_gateway_connection_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            virtual_network_gateway_connection_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            virtual_network_gateway_connection_json_format_value['type'] = parameters.type
        
        virtual_network_gateway_connection_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary4 = {}
            for tags_key4 in parameters.tags:
                tags_value4 = parameters.tags[tags_key4]
                tags_dictionary4[tags_key4] = tags_value4
            
            virtual_network_gateway_connection_json_format_value['tags'] = tags_dictionary4
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = VirtualNetworkGatewayConnectionPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_network_gateway_connection_instance = VirtualNetworkGatewayConnection(tags={})
                result.virtual_network_gateway_connection = virtual_network_gateway_connection_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    virtual_network_gateway1_value2 = properties_value2.get('virtualNetworkGateway1', None)
                    if virtual_network_gateway1_value2 is not None:
                        virtual_network_gateway1_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                        virtual_network_gateway_connection_instance.virtual_network_gateway1 = virtual_network_gateway1_instance
                        
                        ip_configurations_array3 = virtual_network_gateway1_value2.get('ipConfigurations', None)
                        if ip_configurations_array3 is not None:
                            for ip_configurations_value in ip_configurations_array3:
                                virtual_network_gateway_ip_configuration_instance = VirtualNetworkGatewayIpConfiguration()
                                virtual_network_gateway1_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_instance)
                                
                                private_ip_address_value = ip_configurations_value.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    virtual_network_gateway_ip_configuration_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = ip_configurations_value.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    virtual_network_gateway_ip_configuration_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value3 = ip_configurations_value.get('subnet', None)
                                if subnet_value3 is not None:
                                    subnet_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_instance.subnet = subnet_instance
                                    
                                    id_value = subnet_value3.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        subnet_instance.id = id_instance
                                    
                                public_ip_address_value3 = ip_configurations_value.get('publicIPAddress', None)
                                if public_ip_address_value3 is not None:
                                    public_ip_address_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value2 = public_ip_address_value3.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        public_ip_address_instance.id = id_instance2
                                    
                                provisioning_state_value = ip_configurations_value.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    virtual_network_gateway_ip_configuration_instance.provisioning_state = provisioning_state_instance
                                
                                name_value = ip_configurations_value.get('name', None)
                                if name_value is not None:
                                    name_instance = name_value
                                    virtual_network_gateway_ip_configuration_instance.name = name_instance
                                
                                etag_value = ip_configurations_value.get('etag', None)
                                if etag_value is not None:
                                    etag_instance = etag_value
                                    virtual_network_gateway_ip_configuration_instance.etag = etag_instance
                                
                                id_value3 = ip_configurations_value.get('id', None)
                                if id_value3 is not None:
                                    id_instance3 = id_value3
                                    virtual_network_gateway_ip_configuration_instance.id = id_instance3
                                
                        gateway_size_value = virtual_network_gateway1_value2.get('gatewaySize', None)
                        if gateway_size_value is not None:
                            gateway_size_instance = gateway_size_value
                            virtual_network_gateway1_instance.gateway_size = gateway_size_instance
                        
                        gateway_type_value = virtual_network_gateway1_value2.get('gatewayType', None)
                        if gateway_type_value is not None:
                            gateway_type_instance = gateway_type_value
                            virtual_network_gateway1_instance.gateway_type = gateway_type_instance
                        
                        enable_bgp_value = virtual_network_gateway1_value2.get('enableBgp', None)
                        if enable_bgp_value is not None:
                            enable_bgp_instance = enable_bgp_value
                            virtual_network_gateway1_instance.enable_bgp = enable_bgp_instance
                        
                        provisioning_state_value2 = virtual_network_gateway1_value2.get('provisioningState', None)
                        if provisioning_state_value2 is not None:
                            provisioning_state_instance2 = provisioning_state_value2
                            virtual_network_gateway1_instance.provisioning_state = provisioning_state_instance2
                        
                        etag_value2 = virtual_network_gateway1_value2.get('etag', None)
                        if etag_value2 is not None:
                            etag_instance2 = etag_value2
                            virtual_network_gateway1_instance.etag = etag_instance2
                        
                        id_value4 = virtual_network_gateway1_value2.get('id', None)
                        if id_value4 is not None:
                            id_instance4 = id_value4
                            virtual_network_gateway1_instance.id = id_instance4
                        
                        name_value2 = virtual_network_gateway1_value2.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            virtual_network_gateway1_instance.name = name_instance2
                        
                        type_value = virtual_network_gateway1_value2.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            virtual_network_gateway1_instance.type = type_instance
                        
                        location_value = virtual_network_gateway1_value2.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_network_gateway1_instance.location = location_instance
                        
                        tags_sequence_element = virtual_network_gateway1_value2.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key5 = property
                                tags_value5 = tags_sequence_element[property]
                                virtual_network_gateway1_instance.tags[tags_key5] = tags_value5
                            
                    virtual_network_gateway2_value2 = properties_value2.get('virtualNetworkGateway2', None)
                    if virtual_network_gateway2_value2 is not None:
                        virtual_network_gateway2_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                        virtual_network_gateway_connection_instance.virtual_network_gateway2 = virtual_network_gateway2_instance
                        
                        ip_configurations_array4 = virtual_network_gateway2_value2.get('ipConfigurations', None)
                        if ip_configurations_array4 is not None:
                            for ip_configurations_value2 in ip_configurations_array4:
                                virtual_network_gateway_ip_configuration_instance2 = VirtualNetworkGatewayIpConfiguration()
                                virtual_network_gateway2_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_instance2)
                                
                                private_ip_address_value2 = ip_configurations_value2.get('privateIPAddress', None)
                                if private_ip_address_value2 is not None:
                                    private_ip_address_instance2 = private_ip_address_value2
                                    virtual_network_gateway_ip_configuration_instance2.private_ip_address = private_ip_address_instance2
                                
                                private_ip_allocation_method_value2 = ip_configurations_value2.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value2 is not None:
                                    private_ip_allocation_method_instance2 = private_ip_allocation_method_value2
                                    virtual_network_gateway_ip_configuration_instance2.private_ip_allocation_method = private_ip_allocation_method_instance2
                                
                                subnet_value4 = ip_configurations_value2.get('subnet', None)
                                if subnet_value4 is not None:
                                    subnet_instance2 = ResourceId()
                                    virtual_network_gateway_ip_configuration_instance2.subnet = subnet_instance2
                                    
                                    id_value5 = subnet_value4.get('id', None)
                                    if id_value5 is not None:
                                        id_instance5 = id_value5
                                        subnet_instance2.id = id_instance5
                                    
                                public_ip_address_value4 = ip_configurations_value2.get('publicIPAddress', None)
                                if public_ip_address_value4 is not None:
                                    public_ip_address_instance2 = ResourceId()
                                    virtual_network_gateway_ip_configuration_instance2.public_ip_address = public_ip_address_instance2
                                    
                                    id_value6 = public_ip_address_value4.get('id', None)
                                    if id_value6 is not None:
                                        id_instance6 = id_value6
                                        public_ip_address_instance2.id = id_instance6
                                    
                                provisioning_state_value3 = ip_configurations_value2.get('provisioningState', None)
                                if provisioning_state_value3 is not None:
                                    provisioning_state_instance3 = provisioning_state_value3
                                    virtual_network_gateway_ip_configuration_instance2.provisioning_state = provisioning_state_instance3
                                
                                name_value3 = ip_configurations_value2.get('name', None)
                                if name_value3 is not None:
                                    name_instance3 = name_value3
                                    virtual_network_gateway_ip_configuration_instance2.name = name_instance3
                                
                                etag_value3 = ip_configurations_value2.get('etag', None)
                                if etag_value3 is not None:
                                    etag_instance3 = etag_value3
                                    virtual_network_gateway_ip_configuration_instance2.etag = etag_instance3
                                
                                id_value7 = ip_configurations_value2.get('id', None)
                                if id_value7 is not None:
                                    id_instance7 = id_value7
                                    virtual_network_gateway_ip_configuration_instance2.id = id_instance7
                                
                        gateway_size_value2 = virtual_network_gateway2_value2.get('gatewaySize', None)
                        if gateway_size_value2 is not None:
                            gateway_size_instance2 = gateway_size_value2
                            virtual_network_gateway2_instance.gateway_size = gateway_size_instance2
                        
                        gateway_type_value2 = virtual_network_gateway2_value2.get('gatewayType', None)
                        if gateway_type_value2 is not None:
                            gateway_type_instance2 = gateway_type_value2
                            virtual_network_gateway2_instance.gateway_type = gateway_type_instance2
                        
                        enable_bgp_value2 = virtual_network_gateway2_value2.get('enableBgp', None)
                        if enable_bgp_value2 is not None:
                            enable_bgp_instance2 = enable_bgp_value2
                            virtual_network_gateway2_instance.enable_bgp = enable_bgp_instance2
                        
                        provisioning_state_value4 = virtual_network_gateway2_value2.get('provisioningState', None)
                        if provisioning_state_value4 is not None:
                            provisioning_state_instance4 = provisioning_state_value4
                            virtual_network_gateway2_instance.provisioning_state = provisioning_state_instance4
                        
                        etag_value4 = virtual_network_gateway2_value2.get('etag', None)
                        if etag_value4 is not None:
                            etag_instance4 = etag_value4
                            virtual_network_gateway2_instance.etag = etag_instance4
                        
                        id_value8 = virtual_network_gateway2_value2.get('id', None)
                        if id_value8 is not None:
                            id_instance8 = id_value8
                            virtual_network_gateway2_instance.id = id_instance8
                        
                        name_value4 = virtual_network_gateway2_value2.get('name', None)
                        if name_value4 is not None:
                            name_instance4 = name_value4
                            virtual_network_gateway2_instance.name = name_instance4
                        
                        type_value2 = virtual_network_gateway2_value2.get('type', None)
                        if type_value2 is not None:
                            type_instance2 = type_value2
                            virtual_network_gateway2_instance.type = type_instance2
                        
                        location_value2 = virtual_network_gateway2_value2.get('location', None)
                        if location_value2 is not None:
                            location_instance2 = location_value2
                            virtual_network_gateway2_instance.location = location_instance2
                        
                        tags_sequence_element2 = virtual_network_gateway2_value2.get('tags', None)
                        if tags_sequence_element2 is not None:
                            for property2 in tags_sequence_element2:
                                tags_key6 = property2
                                tags_value6 = tags_sequence_element2[property2]
                                virtual_network_gateway2_instance.tags[tags_key6] = tags_value6
                            
                    local_network_gateway2_value2 = properties_value2.get('localNetworkGateway2', None)
                    if local_network_gateway2_value2 is not None:
                        local_network_gateway2_instance = LocalNetworkGateway(tags={})
                        virtual_network_gateway_connection_instance.local_network_gateway2 = local_network_gateway2_instance
                        
                        gateway_ip_address_value = local_network_gateway2_value2.get('gatewayIpAddress', None)
                        if gateway_ip_address_value is not None:
                            gateway_ip_address_instance = gateway_ip_address_value
                            local_network_gateway2_instance.gateway_ip_address = gateway_ip_address_instance
                        
                        local_network_site_address_space_value2 = local_network_gateway2_value2.get('localNetworkSiteAddressSpace', None)
                        if local_network_site_address_space_value2 is not None:
                            local_network_site_address_space_instance = AddressSpace(address_prefixes=[])
                            local_network_gateway2_instance.local_network_site_address_space = local_network_site_address_space_instance
                            
                            address_prefixes_array2 = local_network_site_address_space_value2.get('addressPrefixes', None)
                            if address_prefixes_array2 is not None:
                                for address_prefixes_value in address_prefixes_array2:
                                    local_network_site_address_space_instance.address_prefixes.append(address_prefixes_value)
                                
                        provisioning_state_value5 = local_network_gateway2_value2.get('provisioningState', None)
                        if provisioning_state_value5 is not None:
                            provisioning_state_instance5 = provisioning_state_value5
                            local_network_gateway2_instance.provisioning_state = provisioning_state_instance5
                        
                        etag_value5 = local_network_gateway2_value2.get('etag', None)
                        if etag_value5 is not None:
                            etag_instance5 = etag_value5
                            local_network_gateway2_instance.etag = etag_instance5
                        
                        id_value9 = local_network_gateway2_value2.get('id', None)
                        if id_value9 is not None:
                            id_instance9 = id_value9
                            local_network_gateway2_instance.id = id_instance9
                        
                        name_value5 = local_network_gateway2_value2.get('name', None)
                        if name_value5 is not None:
                            name_instance5 = name_value5
                            local_network_gateway2_instance.name = name_instance5
                        
                        type_value3 = local_network_gateway2_value2.get('type', None)
                        if type_value3 is not None:
                            type_instance3 = type_value3
                            local_network_gateway2_instance.type = type_instance3
                        
                        location_value3 = local_network_gateway2_value2.get('location', None)
                        if location_value3 is not None:
                            location_instance3 = location_value3
                            local_network_gateway2_instance.location = location_instance3
                        
                        tags_sequence_element3 = local_network_gateway2_value2.get('tags', None)
                        if tags_sequence_element3 is not None:
                            for property3 in tags_sequence_element3:
                                tags_key7 = property3
                                tags_value7 = tags_sequence_element3[property3]
                                local_network_gateway2_instance.tags[tags_key7] = tags_value7
                            
                    connection_type_value = properties_value2.get('connectionType', None)
                    if connection_type_value is not None:
                        connection_type_instance = connection_type_value
                        virtual_network_gateway_connection_instance.connection_type = connection_type_instance
                    
                    routing_weight_value = properties_value2.get('routingWeight', None)
                    if routing_weight_value is not None:
                        routing_weight_instance = routing_weight_value
                        virtual_network_gateway_connection_instance.routing_weight = routing_weight_instance
                    
                    shared_key_value = properties_value2.get('sharedKey', None)
                    if shared_key_value is not None:
                        shared_key_instance = shared_key_value
                        virtual_network_gateway_connection_instance.shared_key = shared_key_instance
                    
                    provisioning_state_value6 = properties_value2.get('provisioningState', None)
                    if provisioning_state_value6 is not None:
                        provisioning_state_instance6 = provisioning_state_value6
                        virtual_network_gateway_connection_instance.provisioning_state = provisioning_state_instance6
                    
                etag_value6 = response_doc.get('etag', None)
                if etag_value6 is not None:
                    etag_instance6 = etag_value6
                    virtual_network_gateway_connection_instance.etag = etag_instance6
                
                id_value10 = response_doc.get('id', None)
                if id_value10 is not None:
                    id_instance10 = id_value10
                    virtual_network_gateway_connection_instance.id = id_instance10
                
                name_value6 = response_doc.get('name', None)
                if name_value6 is not None:
                    name_instance6 = name_value6
                    virtual_network_gateway_connection_instance.name = name_instance6
                
                type_value4 = response_doc.get('type', None)
                if type_value4 is not None:
                    type_instance4 = type_value4
                    virtual_network_gateway_connection_instance.type = type_instance4
                
                location_value4 = response_doc.get('location', None)
                if location_value4 is not None:
                    location_instance4 = location_value4
                    virtual_network_gateway_connection_instance.location = location_instance4
                
                tags_sequence_element4 = response_doc.get('tags', None)
                if tags_sequence_element4 is not None:
                    for property4 in tags_sequence_element4:
                        tags_key8 = property4
                        tags_value8 = tags_sequence_element4[property4]
                        virtual_network_gateway_connection_instance.tags[tags_key8] = tags_value8
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, virtual_network_gateway_connection_name):
        """
         The Delete VirtualNetworkGatewayConnection operation deletes the
         specifed virtual network Gateway connection through Network resource
         provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The name of the
         virtual network gateway connection.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_connection_name is None:
            raise ValueError('virtual_network_gateway_connection_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/connections/'
        url = url + quote(virtual_network_gateway_connection_name)
        url = url + '/'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_reset_shared_key(self, resource_group_name, virtual_network_gateway_connection_name, parameters):
        """
         The VirtualNetworkGatewayConnectionResetSharedKey operation resets the
         virtual network gateway connection shared key for passed virtual
         network gateway connection in the specified resource group through
         Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The virtual network
         gateway connection reset shared key Name.
         
         parameters (ConnectionResetSharedKey): Parameters supplied to the
         Begin Reset Virtual Network Gateway connection shared key operation
         through Network resource provider.
         
         Returns:
         
         ConnectionResetSharedKeyPutResponse: Response for
         PutVirtualNetworkGatewayConnectionResetSharedKey Api servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_connection_name is None:
            raise ValueError('virtual_network_gateway_connection_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/connections/'
        url = url + quote(virtual_network_gateway_connection_name)
        url = url + '/sharedkey/reset'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        connection_reset_shared_key_json_format_value = {}
        request_doc = connection_reset_shared_key_json_format_value
        
        properties_value = {}
        connection_reset_shared_key_json_format_value['properties'] = properties_value
        
        if parameters.key_length is not None:
            properties_value['keyLength'] = parameters.key_length
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = ConnectionResetSharedKeyPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                connection_reset_shared_key_instance = ConnectionResetSharedKey()
                result.connection_reset_shared_key = connection_reset_shared_key_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    key_length_value = properties_value2.get('keyLength', None)
                    if key_length_value is not None:
                        key_length_instance = key_length_value
                        connection_reset_shared_key_instance.key_length = key_length_instance
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_set_shared_key(self, resource_group_name, virtual_network_gateway_connection_name, parameters):
        """
         The Put VirtualNetworkGatewayConnectionSharedKey operation sets the
         virtual network gateway connection shared key for passed virtual
         network gateway connection in the specified resource group through
         Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The virtual network
         gateway connection name.
         
         parameters (ConnectionSharedKey): Parameters supplied to the Begin Set
         Virtual Network Gateway conection Shared key operation throughNetwork
         resource provider.
         
         Returns:
         
         ConnectionSharedKeyPutResponse: Response for
         PutVirtualNetworkGatewayConnectionSharedKey Api servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_connection_name is None:
            raise ValueError('virtual_network_gateway_connection_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/connections/'
        url = url + quote(virtual_network_gateway_connection_name)
        url = url + '/sharedkey'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        connection_shared_key_json_format_value = {}
        request_doc = connection_shared_key_json_format_value
        
        properties_value = {}
        connection_shared_key_json_format_value['properties'] = properties_value
        
        if parameters.value is not None:
            properties_value['value'] = parameters.value
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = ConnectionSharedKeyPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                connection_shared_key_instance = ConnectionSharedKey()
                result.connection_shared_key = connection_shared_key_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    value_value = properties_value2.get('value', None)
                    if value_value is not None:
                        value_instance = value_value
                        connection_shared_key_instance.value = value_instance
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, virtual_network_gateway_connection_name, parameters):
        """
         The CreateOrUpdate Virtual network Gateway connection creates a new or
         updates an existing virtualnetwork gateway connection through Network
         resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The name of the
         virtual network gateway conenction.
         
         parameters (VirtualNetworkGatewayConnection): Parameters supplied to
         the Begin Create or update Virtual Network Gateway connection
         operation through Network resource provider.
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.virtual_network_gateway_connections.begin_create_or_updating(resource_group_name, virtual_network_gateway_connection_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, virtual_network_gateway_connection_name):
        """
         The Delete VirtualNetworkGatewayConnection operation deletes the
         specifed virtual network Gateway connection through Network resource
         provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The name of the
         virtual network gateway connection.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.virtual_network_gateway_connections.begin_deleting(resource_group_name, virtual_network_gateway_connection_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, virtual_network_gateway_connection_name):
        """
         The Get VirtualNetworkGatewayConnection operation retrieves
         information about the specified virtual network gateway connection
         through Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The name of the
         virtual network gateway connection.
         
         Returns:
         
         VirtualNetworkGatewayConnectionGetResponse: Response for
         GetVitualNetworkGatewayConnection Api servive call.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_connection_name is None:
            raise ValueError('virtual_network_gateway_connection_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/connections/'
        url = url + quote(virtual_network_gateway_connection_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualNetworkGatewayConnectionGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_network_gateway_connection_instance = VirtualNetworkGatewayConnection(tags={})
                result.virtual_network_gateway_connection = virtual_network_gateway_connection_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    virtual_network_gateway1_value = properties_value.get('virtualNetworkGateway1', None)
                    if virtual_network_gateway1_value is not None:
                        virtual_network_gateway1_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                        virtual_network_gateway_connection_instance.virtual_network_gateway1 = virtual_network_gateway1_instance
                        
                        ip_configurations_array = virtual_network_gateway1_value.get('ipConfigurations', None)
                        if ip_configurations_array is not None:
                            for ip_configurations_value in ip_configurations_array:
                                virtual_network_gateway_ip_configuration_instance = VirtualNetworkGatewayIpConfiguration()
                                virtual_network_gateway1_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_instance)
                                
                                private_ip_address_value = ip_configurations_value.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    virtual_network_gateway_ip_configuration_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = ip_configurations_value.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    virtual_network_gateway_ip_configuration_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value = ip_configurations_value.get('subnet', None)
                                if subnet_value is not None:
                                    subnet_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_instance.subnet = subnet_instance
                                    
                                    id_value = subnet_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        subnet_instance.id = id_instance
                                    
                                public_ip_address_value = ip_configurations_value.get('publicIPAddress', None)
                                if public_ip_address_value is not None:
                                    public_ip_address_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value2 = public_ip_address_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        public_ip_address_instance.id = id_instance2
                                    
                                provisioning_state_value = ip_configurations_value.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    virtual_network_gateway_ip_configuration_instance.provisioning_state = provisioning_state_instance
                                
                                name_value = ip_configurations_value.get('name', None)
                                if name_value is not None:
                                    name_instance = name_value
                                    virtual_network_gateway_ip_configuration_instance.name = name_instance
                                
                                etag_value = ip_configurations_value.get('etag', None)
                                if etag_value is not None:
                                    etag_instance = etag_value
                                    virtual_network_gateway_ip_configuration_instance.etag = etag_instance
                                
                                id_value3 = ip_configurations_value.get('id', None)
                                if id_value3 is not None:
                                    id_instance3 = id_value3
                                    virtual_network_gateway_ip_configuration_instance.id = id_instance3
                                
                        gateway_size_value = virtual_network_gateway1_value.get('gatewaySize', None)
                        if gateway_size_value is not None:
                            gateway_size_instance = gateway_size_value
                            virtual_network_gateway1_instance.gateway_size = gateway_size_instance
                        
                        gateway_type_value = virtual_network_gateway1_value.get('gatewayType', None)
                        if gateway_type_value is not None:
                            gateway_type_instance = gateway_type_value
                            virtual_network_gateway1_instance.gateway_type = gateway_type_instance
                        
                        enable_bgp_value = virtual_network_gateway1_value.get('enableBgp', None)
                        if enable_bgp_value is not None:
                            enable_bgp_instance = enable_bgp_value
                            virtual_network_gateway1_instance.enable_bgp = enable_bgp_instance
                        
                        provisioning_state_value2 = virtual_network_gateway1_value.get('provisioningState', None)
                        if provisioning_state_value2 is not None:
                            provisioning_state_instance2 = provisioning_state_value2
                            virtual_network_gateway1_instance.provisioning_state = provisioning_state_instance2
                        
                        etag_value2 = virtual_network_gateway1_value.get('etag', None)
                        if etag_value2 is not None:
                            etag_instance2 = etag_value2
                            virtual_network_gateway1_instance.etag = etag_instance2
                        
                        id_value4 = virtual_network_gateway1_value.get('id', None)
                        if id_value4 is not None:
                            id_instance4 = id_value4
                            virtual_network_gateway1_instance.id = id_instance4
                        
                        name_value2 = virtual_network_gateway1_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            virtual_network_gateway1_instance.name = name_instance2
                        
                        type_value = virtual_network_gateway1_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            virtual_network_gateway1_instance.type = type_instance
                        
                        location_value = virtual_network_gateway1_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_network_gateway1_instance.location = location_instance
                        
                        tags_sequence_element = virtual_network_gateway1_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                virtual_network_gateway1_instance.tags[tags_key] = tags_value
                            
                    virtual_network_gateway2_value = properties_value.get('virtualNetworkGateway2', None)
                    if virtual_network_gateway2_value is not None:
                        virtual_network_gateway2_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                        virtual_network_gateway_connection_instance.virtual_network_gateway2 = virtual_network_gateway2_instance
                        
                        ip_configurations_array2 = virtual_network_gateway2_value.get('ipConfigurations', None)
                        if ip_configurations_array2 is not None:
                            for ip_configurations_value2 in ip_configurations_array2:
                                virtual_network_gateway_ip_configuration_instance2 = VirtualNetworkGatewayIpConfiguration()
                                virtual_network_gateway2_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_instance2)
                                
                                private_ip_address_value2 = ip_configurations_value2.get('privateIPAddress', None)
                                if private_ip_address_value2 is not None:
                                    private_ip_address_instance2 = private_ip_address_value2
                                    virtual_network_gateway_ip_configuration_instance2.private_ip_address = private_ip_address_instance2
                                
                                private_ip_allocation_method_value2 = ip_configurations_value2.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value2 is not None:
                                    private_ip_allocation_method_instance2 = private_ip_allocation_method_value2
                                    virtual_network_gateway_ip_configuration_instance2.private_ip_allocation_method = private_ip_allocation_method_instance2
                                
                                subnet_value2 = ip_configurations_value2.get('subnet', None)
                                if subnet_value2 is not None:
                                    subnet_instance2 = ResourceId()
                                    virtual_network_gateway_ip_configuration_instance2.subnet = subnet_instance2
                                    
                                    id_value5 = subnet_value2.get('id', None)
                                    if id_value5 is not None:
                                        id_instance5 = id_value5
                                        subnet_instance2.id = id_instance5
                                    
                                public_ip_address_value2 = ip_configurations_value2.get('publicIPAddress', None)
                                if public_ip_address_value2 is not None:
                                    public_ip_address_instance2 = ResourceId()
                                    virtual_network_gateway_ip_configuration_instance2.public_ip_address = public_ip_address_instance2
                                    
                                    id_value6 = public_ip_address_value2.get('id', None)
                                    if id_value6 is not None:
                                        id_instance6 = id_value6
                                        public_ip_address_instance2.id = id_instance6
                                    
                                provisioning_state_value3 = ip_configurations_value2.get('provisioningState', None)
                                if provisioning_state_value3 is not None:
                                    provisioning_state_instance3 = provisioning_state_value3
                                    virtual_network_gateway_ip_configuration_instance2.provisioning_state = provisioning_state_instance3
                                
                                name_value3 = ip_configurations_value2.get('name', None)
                                if name_value3 is not None:
                                    name_instance3 = name_value3
                                    virtual_network_gateway_ip_configuration_instance2.name = name_instance3
                                
                                etag_value3 = ip_configurations_value2.get('etag', None)
                                if etag_value3 is not None:
                                    etag_instance3 = etag_value3
                                    virtual_network_gateway_ip_configuration_instance2.etag = etag_instance3
                                
                                id_value7 = ip_configurations_value2.get('id', None)
                                if id_value7 is not None:
                                    id_instance7 = id_value7
                                    virtual_network_gateway_ip_configuration_instance2.id = id_instance7
                                
                        gateway_size_value2 = virtual_network_gateway2_value.get('gatewaySize', None)
                        if gateway_size_value2 is not None:
                            gateway_size_instance2 = gateway_size_value2
                            virtual_network_gateway2_instance.gateway_size = gateway_size_instance2
                        
                        gateway_type_value2 = virtual_network_gateway2_value.get('gatewayType', None)
                        if gateway_type_value2 is not None:
                            gateway_type_instance2 = gateway_type_value2
                            virtual_network_gateway2_instance.gateway_type = gateway_type_instance2
                        
                        enable_bgp_value2 = virtual_network_gateway2_value.get('enableBgp', None)
                        if enable_bgp_value2 is not None:
                            enable_bgp_instance2 = enable_bgp_value2
                            virtual_network_gateway2_instance.enable_bgp = enable_bgp_instance2
                        
                        provisioning_state_value4 = virtual_network_gateway2_value.get('provisioningState', None)
                        if provisioning_state_value4 is not None:
                            provisioning_state_instance4 = provisioning_state_value4
                            virtual_network_gateway2_instance.provisioning_state = provisioning_state_instance4
                        
                        etag_value4 = virtual_network_gateway2_value.get('etag', None)
                        if etag_value4 is not None:
                            etag_instance4 = etag_value4
                            virtual_network_gateway2_instance.etag = etag_instance4
                        
                        id_value8 = virtual_network_gateway2_value.get('id', None)
                        if id_value8 is not None:
                            id_instance8 = id_value8
                            virtual_network_gateway2_instance.id = id_instance8
                        
                        name_value4 = virtual_network_gateway2_value.get('name', None)
                        if name_value4 is not None:
                            name_instance4 = name_value4
                            virtual_network_gateway2_instance.name = name_instance4
                        
                        type_value2 = virtual_network_gateway2_value.get('type', None)
                        if type_value2 is not None:
                            type_instance2 = type_value2
                            virtual_network_gateway2_instance.type = type_instance2
                        
                        location_value2 = virtual_network_gateway2_value.get('location', None)
                        if location_value2 is not None:
                            location_instance2 = location_value2
                            virtual_network_gateway2_instance.location = location_instance2
                        
                        tags_sequence_element2 = virtual_network_gateway2_value.get('tags', None)
                        if tags_sequence_element2 is not None:
                            for property2 in tags_sequence_element2:
                                tags_key2 = property2
                                tags_value2 = tags_sequence_element2[property2]
                                virtual_network_gateway2_instance.tags[tags_key2] = tags_value2
                            
                    local_network_gateway2_value = properties_value.get('localNetworkGateway2', None)
                    if local_network_gateway2_value is not None:
                        local_network_gateway2_instance = LocalNetworkGateway(tags={})
                        virtual_network_gateway_connection_instance.local_network_gateway2 = local_network_gateway2_instance
                        
                        gateway_ip_address_value = local_network_gateway2_value.get('gatewayIpAddress', None)
                        if gateway_ip_address_value is not None:
                            gateway_ip_address_instance = gateway_ip_address_value
                            local_network_gateway2_instance.gateway_ip_address = gateway_ip_address_instance
                        
                        local_network_site_address_space_value = local_network_gateway2_value.get('localNetworkSiteAddressSpace', None)
                        if local_network_site_address_space_value is not None:
                            local_network_site_address_space_instance = AddressSpace(address_prefixes=[])
                            local_network_gateway2_instance.local_network_site_address_space = local_network_site_address_space_instance
                            
                            address_prefixes_array = local_network_site_address_space_value.get('addressPrefixes', None)
                            if address_prefixes_array is not None:
                                for address_prefixes_value in address_prefixes_array:
                                    local_network_site_address_space_instance.address_prefixes.append(address_prefixes_value)
                                
                        provisioning_state_value5 = local_network_gateway2_value.get('provisioningState', None)
                        if provisioning_state_value5 is not None:
                            provisioning_state_instance5 = provisioning_state_value5
                            local_network_gateway2_instance.provisioning_state = provisioning_state_instance5
                        
                        etag_value5 = local_network_gateway2_value.get('etag', None)
                        if etag_value5 is not None:
                            etag_instance5 = etag_value5
                            local_network_gateway2_instance.etag = etag_instance5
                        
                        id_value9 = local_network_gateway2_value.get('id', None)
                        if id_value9 is not None:
                            id_instance9 = id_value9
                            local_network_gateway2_instance.id = id_instance9
                        
                        name_value5 = local_network_gateway2_value.get('name', None)
                        if name_value5 is not None:
                            name_instance5 = name_value5
                            local_network_gateway2_instance.name = name_instance5
                        
                        type_value3 = local_network_gateway2_value.get('type', None)
                        if type_value3 is not None:
                            type_instance3 = type_value3
                            local_network_gateway2_instance.type = type_instance3
                        
                        location_value3 = local_network_gateway2_value.get('location', None)
                        if location_value3 is not None:
                            location_instance3 = location_value3
                            local_network_gateway2_instance.location = location_instance3
                        
                        tags_sequence_element3 = local_network_gateway2_value.get('tags', None)
                        if tags_sequence_element3 is not None:
                            for property3 in tags_sequence_element3:
                                tags_key3 = property3
                                tags_value3 = tags_sequence_element3[property3]
                                local_network_gateway2_instance.tags[tags_key3] = tags_value3
                            
                    connection_type_value = properties_value.get('connectionType', None)
                    if connection_type_value is not None:
                        connection_type_instance = connection_type_value
                        virtual_network_gateway_connection_instance.connection_type = connection_type_instance
                    
                    routing_weight_value = properties_value.get('routingWeight', None)
                    if routing_weight_value is not None:
                        routing_weight_instance = routing_weight_value
                        virtual_network_gateway_connection_instance.routing_weight = routing_weight_instance
                    
                    shared_key_value = properties_value.get('sharedKey', None)
                    if shared_key_value is not None:
                        shared_key_instance = shared_key_value
                        virtual_network_gateway_connection_instance.shared_key = shared_key_instance
                    
                    provisioning_state_value6 = properties_value.get('provisioningState', None)
                    if provisioning_state_value6 is not None:
                        provisioning_state_instance6 = provisioning_state_value6
                        virtual_network_gateway_connection_instance.provisioning_state = provisioning_state_instance6
                    
                etag_value6 = response_doc.get('etag', None)
                if etag_value6 is not None:
                    etag_instance6 = etag_value6
                    virtual_network_gateway_connection_instance.etag = etag_instance6
                
                id_value10 = response_doc.get('id', None)
                if id_value10 is not None:
                    id_instance10 = id_value10
                    virtual_network_gateway_connection_instance.id = id_instance10
                
                name_value6 = response_doc.get('name', None)
                if name_value6 is not None:
                    name_instance6 = name_value6
                    virtual_network_gateway_connection_instance.name = name_instance6
                
                type_value4 = response_doc.get('type', None)
                if type_value4 is not None:
                    type_instance4 = type_value4
                    virtual_network_gateway_connection_instance.type = type_instance4
                
                location_value4 = response_doc.get('location', None)
                if location_value4 is not None:
                    location_instance4 = location_value4
                    virtual_network_gateway_connection_instance.location = location_instance4
                
                tags_sequence_element4 = response_doc.get('tags', None)
                if tags_sequence_element4 is not None:
                    for property4 in tags_sequence_element4:
                        tags_key4 = property4
                        tags_value4 = tags_sequence_element4[property4]
                        virtual_network_gateway_connection_instance.tags[tags_key4] = tags_value4
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get_shared_key(self, resource_group_name, connection_shared_key_name):
        """
         The Get VirtualNetworkGatewayConnectionSharedKey operation retrieves
         information about the specified virtual network gateway connection
         shared key through Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         connection_shared_key_name (string): The virtual network gateway
         connection shared key name.
         
         Returns:
         
         ConnectionSharedKeyResponse: Response for CheckConnectionSharedKey Api
         servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if connection_shared_key_name is None:
            raise ValueError('connection_shared_key_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/connections/'
        url = url + quote(connection_shared_key_name)
        url = url + '/sharedkey'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ConnectionSharedKeyResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_value = response_doc.get('value', None)
                if value_value is not None:
                    value_instance = value_value
                    result.value = value_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The List VirtualNetworkGatewayConnections operation retrieves all the
         virtual network gateways connections created.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         VirtualNetworkGatewayConnectionListResponse: Response for
         ListVirtualNetworkGatewayConnections Api service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/connections'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualNetworkGatewayConnectionListResponse(virtual_network_gateway_connections=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_network_gateway_connection_json_format_instance = VirtualNetworkGatewayConnection(tags={})
                        result.virtual_network_gateway_connections.append(virtual_network_gateway_connection_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            virtual_network_gateway1_value = properties_value.get('virtualNetworkGateway1', None)
                            if virtual_network_gateway1_value is not None:
                                virtual_network_gateway1_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                                virtual_network_gateway_connection_json_format_instance.virtual_network_gateway1 = virtual_network_gateway1_instance
                                
                                ip_configurations_array = virtual_network_gateway1_value.get('ipConfigurations', None)
                                if ip_configurations_array is not None:
                                    for ip_configurations_value in ip_configurations_array:
                                        virtual_network_gateway_ip_configuration_instance = VirtualNetworkGatewayIpConfiguration()
                                        virtual_network_gateway1_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_instance)
                                        
                                        private_ip_address_value = ip_configurations_value.get('privateIPAddress', None)
                                        if private_ip_address_value is not None:
                                            private_ip_address_instance = private_ip_address_value
                                            virtual_network_gateway_ip_configuration_instance.private_ip_address = private_ip_address_instance
                                        
                                        private_ip_allocation_method_value = ip_configurations_value.get('privateIPAllocationMethod', None)
                                        if private_ip_allocation_method_value is not None:
                                            private_ip_allocation_method_instance = private_ip_allocation_method_value
                                            virtual_network_gateway_ip_configuration_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                        
                                        subnet_value = ip_configurations_value.get('subnet', None)
                                        if subnet_value is not None:
                                            subnet_instance = ResourceId()
                                            virtual_network_gateway_ip_configuration_instance.subnet = subnet_instance
                                            
                                            id_value = subnet_value.get('id', None)
                                            if id_value is not None:
                                                id_instance = id_value
                                                subnet_instance.id = id_instance
                                            
                                        public_ip_address_value = ip_configurations_value.get('publicIPAddress', None)
                                        if public_ip_address_value is not None:
                                            public_ip_address_instance = ResourceId()
                                            virtual_network_gateway_ip_configuration_instance.public_ip_address = public_ip_address_instance
                                            
                                            id_value2 = public_ip_address_value.get('id', None)
                                            if id_value2 is not None:
                                                id_instance2 = id_value2
                                                public_ip_address_instance.id = id_instance2
                                            
                                        provisioning_state_value = ip_configurations_value.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            virtual_network_gateway_ip_configuration_instance.provisioning_state = provisioning_state_instance
                                        
                                        name_value = ip_configurations_value.get('name', None)
                                        if name_value is not None:
                                            name_instance = name_value
                                            virtual_network_gateway_ip_configuration_instance.name = name_instance
                                        
                                        etag_value = ip_configurations_value.get('etag', None)
                                        if etag_value is not None:
                                            etag_instance = etag_value
                                            virtual_network_gateway_ip_configuration_instance.etag = etag_instance
                                        
                                        id_value3 = ip_configurations_value.get('id', None)
                                        if id_value3 is not None:
                                            id_instance3 = id_value3
                                            virtual_network_gateway_ip_configuration_instance.id = id_instance3
                                        
                                gateway_size_value = virtual_network_gateway1_value.get('gatewaySize', None)
                                if gateway_size_value is not None:
                                    gateway_size_instance = gateway_size_value
                                    virtual_network_gateway1_instance.gateway_size = gateway_size_instance
                                
                                gateway_type_value = virtual_network_gateway1_value.get('gatewayType', None)
                                if gateway_type_value is not None:
                                    gateway_type_instance = gateway_type_value
                                    virtual_network_gateway1_instance.gateway_type = gateway_type_instance
                                
                                enable_bgp_value = virtual_network_gateway1_value.get('enableBgp', None)
                                if enable_bgp_value is not None:
                                    enable_bgp_instance = enable_bgp_value
                                    virtual_network_gateway1_instance.enable_bgp = enable_bgp_instance
                                
                                provisioning_state_value2 = virtual_network_gateway1_value.get('provisioningState', None)
                                if provisioning_state_value2 is not None:
                                    provisioning_state_instance2 = provisioning_state_value2
                                    virtual_network_gateway1_instance.provisioning_state = provisioning_state_instance2
                                
                                etag_value2 = virtual_network_gateway1_value.get('etag', None)
                                if etag_value2 is not None:
                                    etag_instance2 = etag_value2
                                    virtual_network_gateway1_instance.etag = etag_instance2
                                
                                id_value4 = virtual_network_gateway1_value.get('id', None)
                                if id_value4 is not None:
                                    id_instance4 = id_value4
                                    virtual_network_gateway1_instance.id = id_instance4
                                
                                name_value2 = virtual_network_gateway1_value.get('name', None)
                                if name_value2 is not None:
                                    name_instance2 = name_value2
                                    virtual_network_gateway1_instance.name = name_instance2
                                
                                type_value = virtual_network_gateway1_value.get('type', None)
                                if type_value is not None:
                                    type_instance = type_value
                                    virtual_network_gateway1_instance.type = type_instance
                                
                                location_value = virtual_network_gateway1_value.get('location', None)
                                if location_value is not None:
                                    location_instance = location_value
                                    virtual_network_gateway1_instance.location = location_instance
                                
                                tags_sequence_element = virtual_network_gateway1_value.get('tags', None)
                                if tags_sequence_element is not None:
                                    for property in tags_sequence_element:
                                        tags_key = property
                                        tags_value = tags_sequence_element[property]
                                        virtual_network_gateway1_instance.tags[tags_key] = tags_value
                                    
                            virtual_network_gateway2_value = properties_value.get('virtualNetworkGateway2', None)
                            if virtual_network_gateway2_value is not None:
                                virtual_network_gateway2_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                                virtual_network_gateway_connection_json_format_instance.virtual_network_gateway2 = virtual_network_gateway2_instance
                                
                                ip_configurations_array2 = virtual_network_gateway2_value.get('ipConfigurations', None)
                                if ip_configurations_array2 is not None:
                                    for ip_configurations_value2 in ip_configurations_array2:
                                        virtual_network_gateway_ip_configuration_instance2 = VirtualNetworkGatewayIpConfiguration()
                                        virtual_network_gateway2_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_instance2)
                                        
                                        private_ip_address_value2 = ip_configurations_value2.get('privateIPAddress', None)
                                        if private_ip_address_value2 is not None:
                                            private_ip_address_instance2 = private_ip_address_value2
                                            virtual_network_gateway_ip_configuration_instance2.private_ip_address = private_ip_address_instance2
                                        
                                        private_ip_allocation_method_value2 = ip_configurations_value2.get('privateIPAllocationMethod', None)
                                        if private_ip_allocation_method_value2 is not None:
                                            private_ip_allocation_method_instance2 = private_ip_allocation_method_value2
                                            virtual_network_gateway_ip_configuration_instance2.private_ip_allocation_method = private_ip_allocation_method_instance2
                                        
                                        subnet_value2 = ip_configurations_value2.get('subnet', None)
                                        if subnet_value2 is not None:
                                            subnet_instance2 = ResourceId()
                                            virtual_network_gateway_ip_configuration_instance2.subnet = subnet_instance2
                                            
                                            id_value5 = subnet_value2.get('id', None)
                                            if id_value5 is not None:
                                                id_instance5 = id_value5
                                                subnet_instance2.id = id_instance5
                                            
                                        public_ip_address_value2 = ip_configurations_value2.get('publicIPAddress', None)
                                        if public_ip_address_value2 is not None:
                                            public_ip_address_instance2 = ResourceId()
                                            virtual_network_gateway_ip_configuration_instance2.public_ip_address = public_ip_address_instance2
                                            
                                            id_value6 = public_ip_address_value2.get('id', None)
                                            if id_value6 is not None:
                                                id_instance6 = id_value6
                                                public_ip_address_instance2.id = id_instance6
                                            
                                        provisioning_state_value3 = ip_configurations_value2.get('provisioningState', None)
                                        if provisioning_state_value3 is not None:
                                            provisioning_state_instance3 = provisioning_state_value3
                                            virtual_network_gateway_ip_configuration_instance2.provisioning_state = provisioning_state_instance3
                                        
                                        name_value3 = ip_configurations_value2.get('name', None)
                                        if name_value3 is not None:
                                            name_instance3 = name_value3
                                            virtual_network_gateway_ip_configuration_instance2.name = name_instance3
                                        
                                        etag_value3 = ip_configurations_value2.get('etag', None)
                                        if etag_value3 is not None:
                                            etag_instance3 = etag_value3
                                            virtual_network_gateway_ip_configuration_instance2.etag = etag_instance3
                                        
                                        id_value7 = ip_configurations_value2.get('id', None)
                                        if id_value7 is not None:
                                            id_instance7 = id_value7
                                            virtual_network_gateway_ip_configuration_instance2.id = id_instance7
                                        
                                gateway_size_value2 = virtual_network_gateway2_value.get('gatewaySize', None)
                                if gateway_size_value2 is not None:
                                    gateway_size_instance2 = gateway_size_value2
                                    virtual_network_gateway2_instance.gateway_size = gateway_size_instance2
                                
                                gateway_type_value2 = virtual_network_gateway2_value.get('gatewayType', None)
                                if gateway_type_value2 is not None:
                                    gateway_type_instance2 = gateway_type_value2
                                    virtual_network_gateway2_instance.gateway_type = gateway_type_instance2
                                
                                enable_bgp_value2 = virtual_network_gateway2_value.get('enableBgp', None)
                                if enable_bgp_value2 is not None:
                                    enable_bgp_instance2 = enable_bgp_value2
                                    virtual_network_gateway2_instance.enable_bgp = enable_bgp_instance2
                                
                                provisioning_state_value4 = virtual_network_gateway2_value.get('provisioningState', None)
                                if provisioning_state_value4 is not None:
                                    provisioning_state_instance4 = provisioning_state_value4
                                    virtual_network_gateway2_instance.provisioning_state = provisioning_state_instance4
                                
                                etag_value4 = virtual_network_gateway2_value.get('etag', None)
                                if etag_value4 is not None:
                                    etag_instance4 = etag_value4
                                    virtual_network_gateway2_instance.etag = etag_instance4
                                
                                id_value8 = virtual_network_gateway2_value.get('id', None)
                                if id_value8 is not None:
                                    id_instance8 = id_value8
                                    virtual_network_gateway2_instance.id = id_instance8
                                
                                name_value4 = virtual_network_gateway2_value.get('name', None)
                                if name_value4 is not None:
                                    name_instance4 = name_value4
                                    virtual_network_gateway2_instance.name = name_instance4
                                
                                type_value2 = virtual_network_gateway2_value.get('type', None)
                                if type_value2 is not None:
                                    type_instance2 = type_value2
                                    virtual_network_gateway2_instance.type = type_instance2
                                
                                location_value2 = virtual_network_gateway2_value.get('location', None)
                                if location_value2 is not None:
                                    location_instance2 = location_value2
                                    virtual_network_gateway2_instance.location = location_instance2
                                
                                tags_sequence_element2 = virtual_network_gateway2_value.get('tags', None)
                                if tags_sequence_element2 is not None:
                                    for property2 in tags_sequence_element2:
                                        tags_key2 = property2
                                        tags_value2 = tags_sequence_element2[property2]
                                        virtual_network_gateway2_instance.tags[tags_key2] = tags_value2
                                    
                            local_network_gateway2_value = properties_value.get('localNetworkGateway2', None)
                            if local_network_gateway2_value is not None:
                                local_network_gateway2_instance = LocalNetworkGateway(tags={})
                                virtual_network_gateway_connection_json_format_instance.local_network_gateway2 = local_network_gateway2_instance
                                
                                gateway_ip_address_value = local_network_gateway2_value.get('gatewayIpAddress', None)
                                if gateway_ip_address_value is not None:
                                    gateway_ip_address_instance = gateway_ip_address_value
                                    local_network_gateway2_instance.gateway_ip_address = gateway_ip_address_instance
                                
                                local_network_site_address_space_value = local_network_gateway2_value.get('localNetworkSiteAddressSpace', None)
                                if local_network_site_address_space_value is not None:
                                    local_network_site_address_space_instance = AddressSpace(address_prefixes=[])
                                    local_network_gateway2_instance.local_network_site_address_space = local_network_site_address_space_instance
                                    
                                    address_prefixes_array = local_network_site_address_space_value.get('addressPrefixes', None)
                                    if address_prefixes_array is not None:
                                        for address_prefixes_value in address_prefixes_array:
                                            local_network_site_address_space_instance.address_prefixes.append(address_prefixes_value)
                                        
                                provisioning_state_value5 = local_network_gateway2_value.get('provisioningState', None)
                                if provisioning_state_value5 is not None:
                                    provisioning_state_instance5 = provisioning_state_value5
                                    local_network_gateway2_instance.provisioning_state = provisioning_state_instance5
                                
                                etag_value5 = local_network_gateway2_value.get('etag', None)
                                if etag_value5 is not None:
                                    etag_instance5 = etag_value5
                                    local_network_gateway2_instance.etag = etag_instance5
                                
                                id_value9 = local_network_gateway2_value.get('id', None)
                                if id_value9 is not None:
                                    id_instance9 = id_value9
                                    local_network_gateway2_instance.id = id_instance9
                                
                                name_value5 = local_network_gateway2_value.get('name', None)
                                if name_value5 is not None:
                                    name_instance5 = name_value5
                                    local_network_gateway2_instance.name = name_instance5
                                
                                type_value3 = local_network_gateway2_value.get('type', None)
                                if type_value3 is not None:
                                    type_instance3 = type_value3
                                    local_network_gateway2_instance.type = type_instance3
                                
                                location_value3 = local_network_gateway2_value.get('location', None)
                                if location_value3 is not None:
                                    location_instance3 = location_value3
                                    local_network_gateway2_instance.location = location_instance3
                                
                                tags_sequence_element3 = local_network_gateway2_value.get('tags', None)
                                if tags_sequence_element3 is not None:
                                    for property3 in tags_sequence_element3:
                                        tags_key3 = property3
                                        tags_value3 = tags_sequence_element3[property3]
                                        local_network_gateway2_instance.tags[tags_key3] = tags_value3
                                    
                            connection_type_value = properties_value.get('connectionType', None)
                            if connection_type_value is not None:
                                connection_type_instance = connection_type_value
                                virtual_network_gateway_connection_json_format_instance.connection_type = connection_type_instance
                            
                            routing_weight_value = properties_value.get('routingWeight', None)
                            if routing_weight_value is not None:
                                routing_weight_instance = routing_weight_value
                                virtual_network_gateway_connection_json_format_instance.routing_weight = routing_weight_instance
                            
                            shared_key_value = properties_value.get('sharedKey', None)
                            if shared_key_value is not None:
                                shared_key_instance = shared_key_value
                                virtual_network_gateway_connection_json_format_instance.shared_key = shared_key_instance
                            
                            provisioning_state_value6 = properties_value.get('provisioningState', None)
                            if provisioning_state_value6 is not None:
                                provisioning_state_instance6 = provisioning_state_value6
                                virtual_network_gateway_connection_json_format_instance.provisioning_state = provisioning_state_instance6
                            
                        etag_value6 = value_value.get('etag', None)
                        if etag_value6 is not None:
                            etag_instance6 = etag_value6
                            virtual_network_gateway_connection_json_format_instance.etag = etag_instance6
                        
                        id_value10 = value_value.get('id', None)
                        if id_value10 is not None:
                            id_instance10 = id_value10
                            virtual_network_gateway_connection_json_format_instance.id = id_instance10
                        
                        name_value6 = value_value.get('name', None)
                        if name_value6 is not None:
                            name_instance6 = name_value6
                            virtual_network_gateway_connection_json_format_instance.name = name_instance6
                        
                        type_value4 = value_value.get('type', None)
                        if type_value4 is not None:
                            type_instance4 = type_value4
                            virtual_network_gateway_connection_json_format_instance.type = type_instance4
                        
                        location_value4 = value_value.get('location', None)
                        if location_value4 is not None:
                            location_instance4 = location_value4
                            virtual_network_gateway_connection_json_format_instance.location = location_instance4
                        
                        tags_sequence_element4 = value_value.get('tags', None)
                        if tags_sequence_element4 is not None:
                            for property4 in tags_sequence_element4:
                                tags_key4 = property4
                                tags_value4 = tags_sequence_element4[property4]
                                virtual_network_gateway_connection_json_format_instance.tags[tags_key4] = tags_value4
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def reset_shared_key(self, resource_group_name, virtual_network_gateway_connection_name, parameters):
        """
         The Reset VirtualNetworkGatewayConnectionSharedKey operation resets
         the virtual network gateway connection shared key for passed virtual
         network gateway connection in the specified resource group through
         Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The virtual network
         gateway connection name.
         
         parameters (ConnectionResetSharedKey): Parameters supplied to the
         Begin Reset Virtual Network Gateway connection shared key operation
         through Network resource provider.
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.virtual_network_gateway_connections.begin_reset_shared_key(resource_group_name, virtual_network_gateway_connection_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def set_shared_key(self, resource_group_name, virtual_network_gateway_connection_name, parameters):
        """
         The Put VirtualNetworkGatewayConnectionSharedKey operation sets the
         virtual network gateway connection shared key for passed virtual
         network gateway connection in the specified resource group through
         Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_connection_name (string): The virtual network
         gateway connection name.
         
         parameters (ConnectionSharedKey): Parameters supplied to the Begin
         Create or update Virtual Network Gateway connection shared key
         operation through Network resource provider.
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.virtual_network_gateway_connections.begin_set_shared_key(resource_group_name, virtual_network_gateway_connection_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
class VirtualNetworkGatewayOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     Virtual network Gateway for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, virtual_network_gateway_name, parameters):
        """
         The Put VirtualNetworkGateway operation creates/updates a virtual
         network gateway in the specified resource group through Network
         resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_name (string): The name of the virtual network
         gateway.
         
         parameters (VirtualNetworkGateway): Parameters supplied to the Begin
         Create or update Virtual Network Gateway operation through Network
         resource provider.
         
         Returns:
         
         VirtualNetworkGatewayPutResponse: Response for
         PutVirtualNetworkGateway Api servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_name is None:
            raise ValueError('virtual_network_gateway_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworkgateways/'
        url = url + quote(virtual_network_gateway_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        virtual_network_gateway_json_format_value = {}
        request_doc = virtual_network_gateway_json_format_value
        
        properties_value = {}
        virtual_network_gateway_json_format_value['properties'] = properties_value
        
        if parameters.ip_configurations is not None:
            ip_configurations_array = []
            for ip_configurations_item in parameters.ip_configurations:
                virtual_network_gateway_ip_configuration_json_format_value = {}
                ip_configurations_array.append(virtual_network_gateway_ip_configuration_json_format_value)
                
                properties_value2 = {}
                virtual_network_gateway_ip_configuration_json_format_value['properties'] = properties_value2
                
                if ip_configurations_item.private_ip_address is not None:
                    properties_value2['privateIPAddress'] = ip_configurations_item.private_ip_address
                
                if ip_configurations_item.private_ip_allocation_method is not None:
                    properties_value2['privateIPAllocationMethod'] = ip_configurations_item.private_ip_allocation_method
                
                if ip_configurations_item.subnet is not None:
                    subnet_value = {}
                    properties_value2['subnet'] = subnet_value
                    
                    if ip_configurations_item.subnet.id is not None:
                        subnet_value['id'] = ip_configurations_item.subnet.id
                    
                if ip_configurations_item.public_ip_address is not None:
                    public_ip_address_value = {}
                    properties_value2['publicIPAddress'] = public_ip_address_value
                    
                    if ip_configurations_item.public_ip_address.id is not None:
                        public_ip_address_value['id'] = ip_configurations_item.public_ip_address.id
                    
                if ip_configurations_item.provisioning_state is not None:
                    properties_value2['provisioningState'] = ip_configurations_item.provisioning_state
                
                if ip_configurations_item.name is not None:
                    virtual_network_gateway_ip_configuration_json_format_value['name'] = ip_configurations_item.name
                
                if ip_configurations_item.etag is not None:
                    virtual_network_gateway_ip_configuration_json_format_value['etag'] = ip_configurations_item.etag
                
                if ip_configurations_item.id is not None:
                    virtual_network_gateway_ip_configuration_json_format_value['id'] = ip_configurations_item.id
                
            properties_value['ipConfigurations'] = ip_configurations_array
        
        if parameters.gateway_size is not None:
            properties_value['gatewaySize'] = parameters.gateway_size
        
        if parameters.gateway_type is not None:
            properties_value['gatewayType'] = parameters.gateway_type
        
        if parameters.enable_bgp is not None:
            properties_value['enableBgp'] = parameters.enable_bgp
        
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            virtual_network_gateway_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            virtual_network_gateway_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            virtual_network_gateway_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            virtual_network_gateway_json_format_value['type'] = parameters.type
        
        virtual_network_gateway_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            virtual_network_gateway_json_format_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = VirtualNetworkGatewayPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_network_gateway_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                result.virtual_network_gateway = virtual_network_gateway_instance
                
                properties_value3 = response_doc.get('properties', None)
                if properties_value3 is not None:
                    ip_configurations_array2 = properties_value3.get('ipConfigurations', None)
                    if ip_configurations_array2 is not None:
                        for ip_configurations_value in ip_configurations_array2:
                            virtual_network_gateway_ip_configuration_json_format_instance = VirtualNetworkGatewayIpConfiguration()
                            virtual_network_gateway_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_json_format_instance)
                            
                            properties_value4 = ip_configurations_value.get('properties', None)
                            if properties_value4 is not None:
                                private_ip_address_value = properties_value4.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = properties_value4.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value2 = properties_value4.get('subnet', None)
                                if subnet_value2 is not None:
                                    subnet_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_json_format_instance.subnet = subnet_instance
                                    
                                    id_value = subnet_value2.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        subnet_instance.id = id_instance
                                    
                                public_ip_address_value2 = properties_value4.get('publicIPAddress', None)
                                if public_ip_address_value2 is not None:
                                    public_ip_address_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value2 = public_ip_address_value2.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        public_ip_address_instance.id = id_instance2
                                    
                                provisioning_state_value = properties_value4.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = ip_configurations_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                virtual_network_gateway_ip_configuration_json_format_instance.name = name_instance
                            
                            etag_value = ip_configurations_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                virtual_network_gateway_ip_configuration_json_format_instance.etag = etag_instance
                            
                            id_value3 = ip_configurations_value.get('id', None)
                            if id_value3 is not None:
                                id_instance3 = id_value3
                                virtual_network_gateway_ip_configuration_json_format_instance.id = id_instance3
                            
                    gateway_size_value = properties_value3.get('gatewaySize', None)
                    if gateway_size_value is not None:
                        gateway_size_instance = gateway_size_value
                        virtual_network_gateway_instance.gateway_size = gateway_size_instance
                    
                    gateway_type_value = properties_value3.get('gatewayType', None)
                    if gateway_type_value is not None:
                        gateway_type_instance = gateway_type_value
                        virtual_network_gateway_instance.gateway_type = gateway_type_instance
                    
                    enable_bgp_value = properties_value3.get('enableBgp', None)
                    if enable_bgp_value is not None:
                        enable_bgp_instance = enable_bgp_value
                        virtual_network_gateway_instance.enable_bgp = enable_bgp_instance
                    
                    provisioning_state_value2 = properties_value3.get('provisioningState', None)
                    if provisioning_state_value2 is not None:
                        provisioning_state_instance2 = provisioning_state_value2
                        virtual_network_gateway_instance.provisioning_state = provisioning_state_instance2
                    
                etag_value2 = response_doc.get('etag', None)
                if etag_value2 is not None:
                    etag_instance2 = etag_value2
                    virtual_network_gateway_instance.etag = etag_instance2
                
                id_value4 = response_doc.get('id', None)
                if id_value4 is not None:
                    id_instance4 = id_value4
                    virtual_network_gateway_instance.id = id_instance4
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_network_gateway_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    virtual_network_gateway_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_network_gateway_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        virtual_network_gateway_instance.tags[tags_key2] = tags_value2
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, virtual_network_gateway_name):
        """
         The Delete VirtualNetworkGateway operation deletes the specifed
         virtual network Gateway through Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_name (string): The name of the virtual network
         gateway.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_name is None:
            raise ValueError('virtual_network_gateway_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualNetworkGateways/'
        url = url + quote(virtual_network_gateway_name)
        url = url + '/'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_reset(self, resource_group_name, virtual_network_gateway_name, parameters):
        """
         The Reset VirtualNetworkGateway operation resets the primary of the
         virtual network gatewayin the specified resource group through
         Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_name (string): The name of the virtual network
         gateway.
         
         parameters (VirtualNetworkGateway): Parameters supplied to the Begin
         Reset Virtual Network Gateway operation through Network resource
         provider.
         
         Returns:
         
         VirtualNetworkGatewayPutResponse: Response for
         PutVirtualNetworkGateway Api servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_name is None:
            raise ValueError('virtual_network_gateway_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworkgateways/'
        url = url + quote(virtual_network_gateway_name)
        url = url + '/reset'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        virtual_network_gateway_json_format_value = {}
        request_doc = virtual_network_gateway_json_format_value
        
        properties_value = {}
        virtual_network_gateway_json_format_value['properties'] = properties_value
        
        if parameters.ip_configurations is not None:
            ip_configurations_array = []
            for ip_configurations_item in parameters.ip_configurations:
                virtual_network_gateway_ip_configuration_json_format_value = {}
                ip_configurations_array.append(virtual_network_gateway_ip_configuration_json_format_value)
                
                properties_value2 = {}
                virtual_network_gateway_ip_configuration_json_format_value['properties'] = properties_value2
                
                if ip_configurations_item.private_ip_address is not None:
                    properties_value2['privateIPAddress'] = ip_configurations_item.private_ip_address
                
                if ip_configurations_item.private_ip_allocation_method is not None:
                    properties_value2['privateIPAllocationMethod'] = ip_configurations_item.private_ip_allocation_method
                
                if ip_configurations_item.subnet is not None:
                    subnet_value = {}
                    properties_value2['subnet'] = subnet_value
                    
                    if ip_configurations_item.subnet.id is not None:
                        subnet_value['id'] = ip_configurations_item.subnet.id
                    
                if ip_configurations_item.public_ip_address is not None:
                    public_ip_address_value = {}
                    properties_value2['publicIPAddress'] = public_ip_address_value
                    
                    if ip_configurations_item.public_ip_address.id is not None:
                        public_ip_address_value['id'] = ip_configurations_item.public_ip_address.id
                    
                if ip_configurations_item.provisioning_state is not None:
                    properties_value2['provisioningState'] = ip_configurations_item.provisioning_state
                
                if ip_configurations_item.name is not None:
                    virtual_network_gateway_ip_configuration_json_format_value['name'] = ip_configurations_item.name
                
                if ip_configurations_item.etag is not None:
                    virtual_network_gateway_ip_configuration_json_format_value['etag'] = ip_configurations_item.etag
                
                if ip_configurations_item.id is not None:
                    virtual_network_gateway_ip_configuration_json_format_value['id'] = ip_configurations_item.id
                
            properties_value['ipConfigurations'] = ip_configurations_array
        
        if parameters.gateway_size is not None:
            properties_value['gatewaySize'] = parameters.gateway_size
        
        if parameters.gateway_type is not None:
            properties_value['gatewayType'] = parameters.gateway_type
        
        if parameters.enable_bgp is not None:
            properties_value['enableBgp'] = parameters.enable_bgp
        
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            virtual_network_gateway_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            virtual_network_gateway_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            virtual_network_gateway_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            virtual_network_gateway_json_format_value['type'] = parameters.type
        
        virtual_network_gateway_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            virtual_network_gateway_json_format_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = VirtualNetworkGatewayPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_network_gateway_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                result.virtual_network_gateway = virtual_network_gateway_instance
                
                properties_value3 = response_doc.get('properties', None)
                if properties_value3 is not None:
                    ip_configurations_array2 = properties_value3.get('ipConfigurations', None)
                    if ip_configurations_array2 is not None:
                        for ip_configurations_value in ip_configurations_array2:
                            virtual_network_gateway_ip_configuration_json_format_instance = VirtualNetworkGatewayIpConfiguration()
                            virtual_network_gateway_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_json_format_instance)
                            
                            properties_value4 = ip_configurations_value.get('properties', None)
                            if properties_value4 is not None:
                                private_ip_address_value = properties_value4.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = properties_value4.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value2 = properties_value4.get('subnet', None)
                                if subnet_value2 is not None:
                                    subnet_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_json_format_instance.subnet = subnet_instance
                                    
                                    id_value = subnet_value2.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        subnet_instance.id = id_instance
                                    
                                public_ip_address_value2 = properties_value4.get('publicIPAddress', None)
                                if public_ip_address_value2 is not None:
                                    public_ip_address_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value2 = public_ip_address_value2.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        public_ip_address_instance.id = id_instance2
                                    
                                provisioning_state_value = properties_value4.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = ip_configurations_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                virtual_network_gateway_ip_configuration_json_format_instance.name = name_instance
                            
                            etag_value = ip_configurations_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                virtual_network_gateway_ip_configuration_json_format_instance.etag = etag_instance
                            
                            id_value3 = ip_configurations_value.get('id', None)
                            if id_value3 is not None:
                                id_instance3 = id_value3
                                virtual_network_gateway_ip_configuration_json_format_instance.id = id_instance3
                            
                    gateway_size_value = properties_value3.get('gatewaySize', None)
                    if gateway_size_value is not None:
                        gateway_size_instance = gateway_size_value
                        virtual_network_gateway_instance.gateway_size = gateway_size_instance
                    
                    gateway_type_value = properties_value3.get('gatewayType', None)
                    if gateway_type_value is not None:
                        gateway_type_instance = gateway_type_value
                        virtual_network_gateway_instance.gateway_type = gateway_type_instance
                    
                    enable_bgp_value = properties_value3.get('enableBgp', None)
                    if enable_bgp_value is not None:
                        enable_bgp_instance = enable_bgp_value
                        virtual_network_gateway_instance.enable_bgp = enable_bgp_instance
                    
                    provisioning_state_value2 = properties_value3.get('provisioningState', None)
                    if provisioning_state_value2 is not None:
                        provisioning_state_instance2 = provisioning_state_value2
                        virtual_network_gateway_instance.provisioning_state = provisioning_state_instance2
                    
                etag_value2 = response_doc.get('etag', None)
                if etag_value2 is not None:
                    etag_instance2 = etag_value2
                    virtual_network_gateway_instance.etag = etag_instance2
                
                id_value4 = response_doc.get('id', None)
                if id_value4 is not None:
                    id_instance4 = id_value4
                    virtual_network_gateway_instance.id = id_instance4
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_network_gateway_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    virtual_network_gateway_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_network_gateway_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        virtual_network_gateway_instance.tags[tags_key2] = tags_value2
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, virtual_network_gateway_name, parameters):
        """
         The Put VirtualNetworkGateway operation creates/updates a virtual
         network gateway in the specified resource group through Network
         resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_name (string): The name of the virtual network
         gateway.
         
         parameters (VirtualNetworkGateway): Parameters supplied to the Begin
         Create or update Virtual Network Gateway operation through Network
         resource provider.
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.virtual_network_gateways.begin_create_or_updating(resource_group_name, virtual_network_gateway_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, virtual_network_gateway_name):
        """
         The Delete VirtualNetworkGateway operation deletes the specifed
         virtual network Gateway through Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_name (string): The name of the virtual network
         gateway.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.virtual_network_gateways.begin_deleting(resource_group_name, virtual_network_gateway_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, virtual_network_gateway_name):
        """
         The Get VirtualNetworkGateway operation retrieves information about
         the specified virtual network gateway through Network resource
         provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_name (string): The name of the virtual network
         gateway.
         
         Returns:
         
         VirtualNetworkGatewayGetResponse: Response for GetVitualNetworkgateway
         Api servive call.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_gateway_name is None:
            raise ValueError('virtual_network_gateway_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualNetworkGateways/'
        url = url + quote(virtual_network_gateway_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualNetworkGatewayGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_network_gateway_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                result.virtual_network_gateway = virtual_network_gateway_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    ip_configurations_array = properties_value.get('ipConfigurations', None)
                    if ip_configurations_array is not None:
                        for ip_configurations_value in ip_configurations_array:
                            virtual_network_gateway_ip_configuration_json_format_instance = VirtualNetworkGatewayIpConfiguration()
                            virtual_network_gateway_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_json_format_instance)
                            
                            properties_value2 = ip_configurations_value.get('properties', None)
                            if properties_value2 is not None:
                                private_ip_address_value = properties_value2.get('privateIPAddress', None)
                                if private_ip_address_value is not None:
                                    private_ip_address_instance = private_ip_address_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                
                                private_ip_allocation_method_value = properties_value2.get('privateIPAllocationMethod', None)
                                if private_ip_allocation_method_value is not None:
                                    private_ip_allocation_method_instance = private_ip_allocation_method_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                
                                subnet_value = properties_value2.get('subnet', None)
                                if subnet_value is not None:
                                    subnet_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_json_format_instance.subnet = subnet_instance
                                    
                                    id_value = subnet_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        subnet_instance.id = id_instance
                                    
                                public_ip_address_value = properties_value2.get('publicIPAddress', None)
                                if public_ip_address_value is not None:
                                    public_ip_address_instance = ResourceId()
                                    virtual_network_gateway_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                    
                                    id_value2 = public_ip_address_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        public_ip_address_instance.id = id_instance2
                                    
                                provisioning_state_value = properties_value2.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    virtual_network_gateway_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = ip_configurations_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                virtual_network_gateway_ip_configuration_json_format_instance.name = name_instance
                            
                            etag_value = ip_configurations_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                virtual_network_gateway_ip_configuration_json_format_instance.etag = etag_instance
                            
                            id_value3 = ip_configurations_value.get('id', None)
                            if id_value3 is not None:
                                id_instance3 = id_value3
                                virtual_network_gateway_ip_configuration_json_format_instance.id = id_instance3
                            
                    gateway_size_value = properties_value.get('gatewaySize', None)
                    if gateway_size_value is not None:
                        gateway_size_instance = gateway_size_value
                        virtual_network_gateway_instance.gateway_size = gateway_size_instance
                    
                    gateway_type_value = properties_value.get('gatewayType', None)
                    if gateway_type_value is not None:
                        gateway_type_instance = gateway_type_value
                        virtual_network_gateway_instance.gateway_type = gateway_type_instance
                    
                    enable_bgp_value = properties_value.get('enableBgp', None)
                    if enable_bgp_value is not None:
                        enable_bgp_instance = enable_bgp_value
                        virtual_network_gateway_instance.enable_bgp = enable_bgp_instance
                    
                    provisioning_state_value2 = properties_value.get('provisioningState', None)
                    if provisioning_state_value2 is not None:
                        provisioning_state_instance2 = provisioning_state_value2
                        virtual_network_gateway_instance.provisioning_state = provisioning_state_instance2
                    
                etag_value2 = response_doc.get('etag', None)
                if etag_value2 is not None:
                    etag_instance2 = etag_value2
                    virtual_network_gateway_instance.etag = etag_instance2
                
                id_value4 = response_doc.get('id', None)
                if id_value4 is not None:
                    id_instance4 = id_value4
                    virtual_network_gateway_instance.id = id_instance4
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_network_gateway_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    virtual_network_gateway_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_network_gateway_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        virtual_network_gateway_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The List VirtualNetworkGateways opertion retrieves all the virtual
         network gateways stored.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         VirtualNetworkGatewayListResponse: Response for
         ListVirtualNetworkGateways Api service call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualNetworkGateways'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualNetworkGatewayListResponse(virtual_network_gateways=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_network_gateway_json_format_instance = VirtualNetworkGateway(ip_configurations=[], tags={})
                        result.virtual_network_gateways.append(virtual_network_gateway_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            ip_configurations_array = properties_value.get('ipConfigurations', None)
                            if ip_configurations_array is not None:
                                for ip_configurations_value in ip_configurations_array:
                                    virtual_network_gateway_ip_configuration_json_format_instance = VirtualNetworkGatewayIpConfiguration()
                                    virtual_network_gateway_json_format_instance.ip_configurations.append(virtual_network_gateway_ip_configuration_json_format_instance)
                                    
                                    properties_value2 = ip_configurations_value.get('properties', None)
                                    if properties_value2 is not None:
                                        private_ip_address_value = properties_value2.get('privateIPAddress', None)
                                        if private_ip_address_value is not None:
                                            private_ip_address_instance = private_ip_address_value
                                            virtual_network_gateway_ip_configuration_json_format_instance.private_ip_address = private_ip_address_instance
                                        
                                        private_ip_allocation_method_value = properties_value2.get('privateIPAllocationMethod', None)
                                        if private_ip_allocation_method_value is not None:
                                            private_ip_allocation_method_instance = private_ip_allocation_method_value
                                            virtual_network_gateway_ip_configuration_json_format_instance.private_ip_allocation_method = private_ip_allocation_method_instance
                                        
                                        subnet_value = properties_value2.get('subnet', None)
                                        if subnet_value is not None:
                                            subnet_instance = ResourceId()
                                            virtual_network_gateway_ip_configuration_json_format_instance.subnet = subnet_instance
                                            
                                            id_value = subnet_value.get('id', None)
                                            if id_value is not None:
                                                id_instance = id_value
                                                subnet_instance.id = id_instance
                                            
                                        public_ip_address_value = properties_value2.get('publicIPAddress', None)
                                        if public_ip_address_value is not None:
                                            public_ip_address_instance = ResourceId()
                                            virtual_network_gateway_ip_configuration_json_format_instance.public_ip_address = public_ip_address_instance
                                            
                                            id_value2 = public_ip_address_value.get('id', None)
                                            if id_value2 is not None:
                                                id_instance2 = id_value2
                                                public_ip_address_instance.id = id_instance2
                                            
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            virtual_network_gateway_ip_configuration_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = ip_configurations_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        virtual_network_gateway_ip_configuration_json_format_instance.name = name_instance
                                    
                                    etag_value = ip_configurations_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        virtual_network_gateway_ip_configuration_json_format_instance.etag = etag_instance
                                    
                                    id_value3 = ip_configurations_value.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        virtual_network_gateway_ip_configuration_json_format_instance.id = id_instance3
                                    
                            gateway_size_value = properties_value.get('gatewaySize', None)
                            if gateway_size_value is not None:
                                gateway_size_instance = gateway_size_value
                                virtual_network_gateway_json_format_instance.gateway_size = gateway_size_instance
                            
                            gateway_type_value = properties_value.get('gatewayType', None)
                            if gateway_type_value is not None:
                                gateway_type_instance = gateway_type_value
                                virtual_network_gateway_json_format_instance.gateway_type = gateway_type_instance
                            
                            enable_bgp_value = properties_value.get('enableBgp', None)
                            if enable_bgp_value is not None:
                                enable_bgp_instance = enable_bgp_value
                                virtual_network_gateway_json_format_instance.enable_bgp = enable_bgp_instance
                            
                            provisioning_state_value2 = properties_value.get('provisioningState', None)
                            if provisioning_state_value2 is not None:
                                provisioning_state_instance2 = provisioning_state_value2
                                virtual_network_gateway_json_format_instance.provisioning_state = provisioning_state_instance2
                            
                        etag_value2 = value_value.get('etag', None)
                        if etag_value2 is not None:
                            etag_instance2 = etag_value2
                            virtual_network_gateway_json_format_instance.etag = etag_instance2
                        
                        id_value4 = value_value.get('id', None)
                        if id_value4 is not None:
                            id_instance4 = id_value4
                            virtual_network_gateway_json_format_instance.id = id_instance4
                        
                        name_value2 = value_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            virtual_network_gateway_json_format_instance.name = name_instance2
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            virtual_network_gateway_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_network_gateway_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                virtual_network_gateway_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def reset(self, resource_group_name, virtual_network_gateway_name, parameters):
        """
         The Reset VirtualNetworkGateway operation resets the primary of the
         virtual network gateway in the specified resource group through
         Network resource provider.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_gateway_name (string): The name of the virtual network
         gateway.
         
         parameters (VirtualNetworkGateway): Parameters supplied to the Begin
         Reset Virtual Network Gateway operation through Network resource
         provider.
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.virtual_network_gateways.begin_reset(resource_group_name, virtual_network_gateway_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 30
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
class VirtualNetworkOperations(object):
    """
     The Network Resource Provider API includes operations for managing the
     Virtual Networks for your subscription.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [NetworkResourceProviderClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Network.NetworkResourceProviderClient.
        """
        return self._client
    
    def begin_create_or_updating(self, resource_group_name, virtual_network_name, parameters):
        """
         The Put VirtualNetwork operation creates/updates a virtual network in
         the specified resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         parameters (VirtualNetwork): Parameters supplied to the create/update
         Virtual Network operation
         
         Returns:
         
         VirtualNetworkPutResponse: Response for PutVirtualNetworks API service
         calls.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_name is None:
            raise ValueError('virtual_network_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        if parameters.subnets is not None:
            for subnets_parameter_item in parameters.subnets:
                if subnets_parameter_item.address_prefix is None:
                    raise ValueError('parameters.subnets.address_prefix cannot be None.')
                
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks/'
        url = url + quote(virtual_network_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        virtual_network_json_format_value = {}
        request_doc = virtual_network_json_format_value
        
        properties_value = {}
        virtual_network_json_format_value['properties'] = properties_value
        
        if parameters.address_space is not None:
            address_space_value = {}
            properties_value['addressSpace'] = address_space_value
            
            if parameters.address_space.address_prefixes is not None:
                address_prefixes_array = []
                for address_prefixes_item in parameters.address_space.address_prefixes:
                    address_prefixes_array.append(address_prefixes_item)
                
                address_space_value['addressPrefixes'] = address_prefixes_array
            
        if parameters.dhcp_options is not None:
            dhcp_options_value = {}
            properties_value['dhcpOptions'] = dhcp_options_value
            
            if parameters.dhcp_options.dns_servers is not None:
                dns_servers_array = []
                for dns_servers_item in parameters.dhcp_options.dns_servers:
                    dns_servers_array.append(dns_servers_item)
                
                dhcp_options_value['dnsServers'] = dns_servers_array
            
        if parameters.subnets is not None:
            subnets_array = []
            for subnets_item in parameters.subnets:
                subnet_json_format_value = {}
                subnets_array.append(subnet_json_format_value)
                
                properties_value2 = {}
                subnet_json_format_value['properties'] = properties_value2
                
                properties_value2['addressPrefix'] = subnets_item.address_prefix
                
                if subnets_item.network_security_group is not None:
                    network_security_group_value = {}
                    properties_value2['networkSecurityGroup'] = network_security_group_value
                    
                    if subnets_item.network_security_group.id is not None:
                        network_security_group_value['id'] = subnets_item.network_security_group.id
                    
                if subnets_item.ip_configurations is not None:
                    ip_configurations_array = []
                    for ip_configurations_item in subnets_item.ip_configurations:
                        resource_id_value = {}
                        ip_configurations_array.append(resource_id_value)
                        
                        if ip_configurations_item.id is not None:
                            resource_id_value['id'] = ip_configurations_item.id
                        
                    properties_value2['ipConfigurations'] = ip_configurations_array
                
                if subnets_item.provisioning_state is not None:
                    properties_value2['provisioningState'] = subnets_item.provisioning_state
                
                if subnets_item.name is not None:
                    subnet_json_format_value['name'] = subnets_item.name
                
                if subnets_item.etag is not None:
                    subnet_json_format_value['etag'] = subnets_item.etag
                
                if subnets_item.id is not None:
                    subnet_json_format_value['id'] = subnets_item.id
                
            properties_value['subnets'] = subnets_array
        
        if parameters.provisioning_state is not None:
            properties_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.etag is not None:
            virtual_network_json_format_value['etag'] = parameters.etag
        
        if parameters.id is not None:
            virtual_network_json_format_value['id'] = parameters.id
        
        if parameters.name is not None:
            virtual_network_json_format_value['name'] = parameters.name
        
        if parameters.type is not None:
            virtual_network_json_format_value['type'] = parameters.type
        
        virtual_network_json_format_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            virtual_network_json_format_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = VirtualNetworkPutResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_network_instance = VirtualNetwork(subnets=[], tags={})
                result.virtual_network = virtual_network_instance
                
                properties_value3 = response_doc.get('properties', None)
                if properties_value3 is not None:
                    address_space_value2 = properties_value3.get('addressSpace', None)
                    if address_space_value2 is not None:
                        address_space_instance = AddressSpace(address_prefixes=[])
                        virtual_network_instance.address_space = address_space_instance
                        
                        address_prefixes_array2 = address_space_value2.get('addressPrefixes', None)
                        if address_prefixes_array2 is not None:
                            for address_prefixes_value in address_prefixes_array2:
                                address_space_instance.address_prefixes.append(address_prefixes_value)
                            
                    dhcp_options_value2 = properties_value3.get('dhcpOptions', None)
                    if dhcp_options_value2 is not None:
                        dhcp_options_instance = DhcpOptions(dns_servers=[])
                        virtual_network_instance.dhcp_options = dhcp_options_instance
                        
                        dns_servers_array2 = dhcp_options_value2.get('dnsServers', None)
                        if dns_servers_array2 is not None:
                            for dns_servers_value in dns_servers_array2:
                                dhcp_options_instance.dns_servers.append(dns_servers_value)
                            
                    subnets_array2 = properties_value3.get('subnets', None)
                    if subnets_array2 is not None:
                        for subnets_value in subnets_array2:
                            subnet_json_format_instance = Subnet(ip_configurations=[])
                            virtual_network_instance.subnets.append(subnet_json_format_instance)
                            
                            properties_value4 = subnets_value.get('properties', None)
                            if properties_value4 is not None:
                                address_prefix_value = properties_value4.get('addressPrefix', None)
                                if address_prefix_value is not None:
                                    address_prefix_instance = address_prefix_value
                                    subnet_json_format_instance.address_prefix = address_prefix_instance
                                
                                network_security_group_value2 = properties_value4.get('networkSecurityGroup', None)
                                if network_security_group_value2 is not None:
                                    network_security_group_instance = ResourceId()
                                    subnet_json_format_instance.network_security_group = network_security_group_instance
                                    
                                    id_value = network_security_group_value2.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        network_security_group_instance.id = id_instance
                                    
                                ip_configurations_array2 = properties_value4.get('ipConfigurations', None)
                                if ip_configurations_array2 is not None:
                                    for ip_configurations_value in ip_configurations_array2:
                                        resource_id_instance = ResourceId()
                                        subnet_json_format_instance.ip_configurations.append(resource_id_instance)
                                        
                                        id_value2 = ip_configurations_value.get('id', None)
                                        if id_value2 is not None:
                                            id_instance2 = id_value2
                                            resource_id_instance.id = id_instance2
                                        
                                provisioning_state_value = properties_value4.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    subnet_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = subnets_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                subnet_json_format_instance.name = name_instance
                            
                            etag_value = subnets_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                subnet_json_format_instance.etag = etag_instance
                            
                            id_value3 = subnets_value.get('id', None)
                            if id_value3 is not None:
                                id_instance3 = id_value3
                                subnet_json_format_instance.id = id_instance3
                            
                    provisioning_state_value2 = properties_value3.get('provisioningState', None)
                    if provisioning_state_value2 is not None:
                        provisioning_state_instance2 = provisioning_state_value2
                        virtual_network_instance.provisioning_state = provisioning_state_instance2
                    
                etag_value2 = response_doc.get('etag', None)
                if etag_value2 is not None:
                    etag_instance2 = etag_value2
                    virtual_network_instance.etag = etag_instance2
                
                id_value4 = response_doc.get('id', None)
                if id_value4 is not None:
                    id_instance4 = id_value4
                    virtual_network_instance.id = id_instance4
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_network_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    virtual_network_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_network_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        virtual_network_instance.tags[tags_key2] = tags_value2
                    
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = Error(details=[])
                    result.error = error_instance
                    
                    code_value = error_value.get('code', None)
                    if code_value is not None:
                        code_instance = code_value
                        error_instance.code = code_instance
                    
                    message_value = error_value.get('message', None)
                    if message_value is not None:
                        message_instance = message_value
                        error_instance.message = message_instance
                    
                    target_value = error_value.get('target', None)
                    if target_value is not None:
                        target_instance = target_value
                        error_instance.target = target_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            error_details_instance = ErrorDetails()
                            error_instance.details.append(error_details_instance)
                            
                            code_value2 = details_value.get('code', None)
                            if code_value2 is not None:
                                code_instance2 = code_value2
                                error_details_instance.code = code_instance2
                            
                            target_value2 = details_value.get('target', None)
                            if target_value2 is not None:
                                target_instance2 = target_value2
                                error_details_instance.target = target_instance2
                            
                            message_value2 = details_value.get('message', None)
                            if message_value2 is not None:
                                message_instance2 = message_value2
                                error_details_instance.message = message_instance2
                            
                    inner_error_value = error_value.get('innerError', None)
                    if inner_error_value is not None:
                        inner_error_instance = inner_error_value
                        error_instance.inner_error = inner_error_instance
                    
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def begin_deleting(self, resource_group_name, virtual_network_name):
        """
         The Delete VirtualNetwork operation deletes the specifed virtual
         network
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         Returns:
         
         UpdateOperationResponse: If the resource provide needs to return an
         error to any operation, it should return the appropriate HTTP error
         code and a message body as can be seen below.The message should be
         localized per the Accept-Language header specified in the original
         request such thatit could be directly be exposed to users
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_name is None:
            raise ValueError('virtual_network_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks/'
        url = url + quote(virtual_network_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = UpdateOperationResponse()
        result.status_code = status_code
        result.azure_async_operation = response.headers.get('azure-asyncoperation')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, virtual_network_name, parameters):
        """
         The Put VirtualNetwork operation creates/updates a virtual networkin
         the specified resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         parameters (VirtualNetwork): Parameters supplied to the create/update
         Virtual Network operation
         
         Returns:
         
         AzureAsyncOperationResponse: The response body contains the status of
         the specified asynchronous operation, indicating whether it has
         succeeded, is inprogress, or has failed. Note that this status is
         distinct from the HTTP status code returned for the Get Operation
         Status operation itself. If the asynchronous operation succeeded, the
         response body includes the HTTP status code for the successful
         request. If the asynchronous operation failed, the response body
         includes the HTTP status code for the failed request and error
         information regarding the failure.
        """
        client2 = self.client
        
        response = client2.virtual_networks.begin_create_or_updating(resource_group_name, virtual_network_name, parameters)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def delete(self, resource_group_name, virtual_network_name):
        """
         The Delete VirtualNetwork operation deletes the specifed virtual
         network
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.virtual_networks.begin_deleting(resource_group_name, virtual_network_name)
        result = client2.get_long_running_operation_status(response.azure_async_operation)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.azure_async_operation)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name, virtual_network_name):
        """
         The Get VirtualNetwork operation retrieves information about the
         specified virtual network.
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         virtual_network_name (string): The name of the virtual network.
         
         Returns:
         
         VirtualNetworkGetResponse: Response for GetVirtualNetworks API service
         calls.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if virtual_network_name is None:
            raise ValueError('virtual_network_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks/'
        url = url + quote(virtual_network_name)
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualNetworkGetResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                virtual_network_instance = VirtualNetwork(subnets=[], tags={})
                result.virtual_network = virtual_network_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    address_space_value = properties_value.get('addressSpace', None)
                    if address_space_value is not None:
                        address_space_instance = AddressSpace(address_prefixes=[])
                        virtual_network_instance.address_space = address_space_instance
                        
                        address_prefixes_array = address_space_value.get('addressPrefixes', None)
                        if address_prefixes_array is not None:
                            for address_prefixes_value in address_prefixes_array:
                                address_space_instance.address_prefixes.append(address_prefixes_value)
                            
                    dhcp_options_value = properties_value.get('dhcpOptions', None)
                    if dhcp_options_value is not None:
                        dhcp_options_instance = DhcpOptions(dns_servers=[])
                        virtual_network_instance.dhcp_options = dhcp_options_instance
                        
                        dns_servers_array = dhcp_options_value.get('dnsServers', None)
                        if dns_servers_array is not None:
                            for dns_servers_value in dns_servers_array:
                                dhcp_options_instance.dns_servers.append(dns_servers_value)
                            
                    subnets_array = properties_value.get('subnets', None)
                    if subnets_array is not None:
                        for subnets_value in subnets_array:
                            subnet_json_format_instance = Subnet(ip_configurations=[])
                            virtual_network_instance.subnets.append(subnet_json_format_instance)
                            
                            properties_value2 = subnets_value.get('properties', None)
                            if properties_value2 is not None:
                                address_prefix_value = properties_value2.get('addressPrefix', None)
                                if address_prefix_value is not None:
                                    address_prefix_instance = address_prefix_value
                                    subnet_json_format_instance.address_prefix = address_prefix_instance
                                
                                network_security_group_value = properties_value2.get('networkSecurityGroup', None)
                                if network_security_group_value is not None:
                                    network_security_group_instance = ResourceId()
                                    subnet_json_format_instance.network_security_group = network_security_group_instance
                                    
                                    id_value = network_security_group_value.get('id', None)
                                    if id_value is not None:
                                        id_instance = id_value
                                        network_security_group_instance.id = id_instance
                                    
                                ip_configurations_array = properties_value2.get('ipConfigurations', None)
                                if ip_configurations_array is not None:
                                    for ip_configurations_value in ip_configurations_array:
                                        resource_id_instance = ResourceId()
                                        subnet_json_format_instance.ip_configurations.append(resource_id_instance)
                                        
                                        id_value2 = ip_configurations_value.get('id', None)
                                        if id_value2 is not None:
                                            id_instance2 = id_value2
                                            resource_id_instance.id = id_instance2
                                        
                                provisioning_state_value = properties_value2.get('provisioningState', None)
                                if provisioning_state_value is not None:
                                    provisioning_state_instance = provisioning_state_value
                                    subnet_json_format_instance.provisioning_state = provisioning_state_instance
                                
                            name_value = subnets_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                subnet_json_format_instance.name = name_instance
                            
                            etag_value = subnets_value.get('etag', None)
                            if etag_value is not None:
                                etag_instance = etag_value
                                subnet_json_format_instance.etag = etag_instance
                            
                            id_value3 = subnets_value.get('id', None)
                            if id_value3 is not None:
                                id_instance3 = id_value3
                                subnet_json_format_instance.id = id_instance3
                            
                    provisioning_state_value2 = properties_value.get('provisioningState', None)
                    if provisioning_state_value2 is not None:
                        provisioning_state_instance2 = provisioning_state_value2
                        virtual_network_instance.provisioning_state = provisioning_state_instance2
                    
                etag_value2 = response_doc.get('etag', None)
                if etag_value2 is not None:
                    etag_instance2 = etag_value2
                    virtual_network_instance.etag = etag_instance2
                
                id_value4 = response_doc.get('id', None)
                if id_value4 is not None:
                    id_instance4 = id_value4
                    virtual_network_instance.id = id_instance4
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    virtual_network_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    virtual_network_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    virtual_network_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        virtual_network_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name):
        """
         The list VirtualNetwork returns all Virtual Networks in a resource
         group
         
         Args:
         
         resource_group_name (string): The name of the resource group.
         
         Returns:
         
         VirtualNetworkListResponse: Response for ListVirtualNetworks Api
         servive call
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualNetworkListResponse(virtual_networks=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_network_json_format_instance = VirtualNetwork(subnets=[], tags={})
                        result.virtual_networks.append(virtual_network_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            address_space_value = properties_value.get('addressSpace', None)
                            if address_space_value is not None:
                                address_space_instance = AddressSpace(address_prefixes=[])
                                virtual_network_json_format_instance.address_space = address_space_instance
                                
                                address_prefixes_array = address_space_value.get('addressPrefixes', None)
                                if address_prefixes_array is not None:
                                    for address_prefixes_value in address_prefixes_array:
                                        address_space_instance.address_prefixes.append(address_prefixes_value)
                                    
                            dhcp_options_value = properties_value.get('dhcpOptions', None)
                            if dhcp_options_value is not None:
                                dhcp_options_instance = DhcpOptions(dns_servers=[])
                                virtual_network_json_format_instance.dhcp_options = dhcp_options_instance
                                
                                dns_servers_array = dhcp_options_value.get('dnsServers', None)
                                if dns_servers_array is not None:
                                    for dns_servers_value in dns_servers_array:
                                        dhcp_options_instance.dns_servers.append(dns_servers_value)
                                    
                            subnets_array = properties_value.get('subnets', None)
                            if subnets_array is not None:
                                for subnets_value in subnets_array:
                                    subnet_json_format_instance = Subnet(ip_configurations=[])
                                    virtual_network_json_format_instance.subnets.append(subnet_json_format_instance)
                                    
                                    properties_value2 = subnets_value.get('properties', None)
                                    if properties_value2 is not None:
                                        address_prefix_value = properties_value2.get('addressPrefix', None)
                                        if address_prefix_value is not None:
                                            address_prefix_instance = address_prefix_value
                                            subnet_json_format_instance.address_prefix = address_prefix_instance
                                        
                                        network_security_group_value = properties_value2.get('networkSecurityGroup', None)
                                        if network_security_group_value is not None:
                                            network_security_group_instance = ResourceId()
                                            subnet_json_format_instance.network_security_group = network_security_group_instance
                                            
                                            id_value = network_security_group_value.get('id', None)
                                            if id_value is not None:
                                                id_instance = id_value
                                                network_security_group_instance.id = id_instance
                                            
                                        ip_configurations_array = properties_value2.get('ipConfigurations', None)
                                        if ip_configurations_array is not None:
                                            for ip_configurations_value in ip_configurations_array:
                                                resource_id_instance = ResourceId()
                                                subnet_json_format_instance.ip_configurations.append(resource_id_instance)
                                                
                                                id_value2 = ip_configurations_value.get('id', None)
                                                if id_value2 is not None:
                                                    id_instance2 = id_value2
                                                    resource_id_instance.id = id_instance2
                                                
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            subnet_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = subnets_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        subnet_json_format_instance.name = name_instance
                                    
                                    etag_value = subnets_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        subnet_json_format_instance.etag = etag_instance
                                    
                                    id_value3 = subnets_value.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        subnet_json_format_instance.id = id_instance3
                                    
                            provisioning_state_value2 = properties_value.get('provisioningState', None)
                            if provisioning_state_value2 is not None:
                                provisioning_state_instance2 = provisioning_state_value2
                                virtual_network_json_format_instance.provisioning_state = provisioning_state_instance2
                            
                        etag_value2 = value_value.get('etag', None)
                        if etag_value2 is not None:
                            etag_instance2 = etag_value2
                            virtual_network_json_format_instance.etag = etag_instance2
                        
                        id_value4 = value_value.get('id', None)
                        if id_value4 is not None:
                            id_instance4 = id_value4
                            virtual_network_json_format_instance.id = id_instance4
                        
                        name_value2 = value_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            virtual_network_json_format_instance.name = name_instance2
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            virtual_network_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_network_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                virtual_network_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_all(self):
        """
         The list VirtualNetwork returns all Virtual Networks in a subscription
         
         Returns:
         
         VirtualNetworkListResponse: Response for ListVirtualNetworks Api
         servive call
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + 'Microsoft.Network'
        url = url + '/virtualnetworks'
        query_parameters = []
        query_parameters.append('api-version=2015-05-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = VirtualNetworkListResponse(virtual_networks=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        virtual_network_json_format_instance = VirtualNetwork(subnets=[], tags={})
                        result.virtual_networks.append(virtual_network_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            address_space_value = properties_value.get('addressSpace', None)
                            if address_space_value is not None:
                                address_space_instance = AddressSpace(address_prefixes=[])
                                virtual_network_json_format_instance.address_space = address_space_instance
                                
                                address_prefixes_array = address_space_value.get('addressPrefixes', None)
                                if address_prefixes_array is not None:
                                    for address_prefixes_value in address_prefixes_array:
                                        address_space_instance.address_prefixes.append(address_prefixes_value)
                                    
                            dhcp_options_value = properties_value.get('dhcpOptions', None)
                            if dhcp_options_value is not None:
                                dhcp_options_instance = DhcpOptions(dns_servers=[])
                                virtual_network_json_format_instance.dhcp_options = dhcp_options_instance
                                
                                dns_servers_array = dhcp_options_value.get('dnsServers', None)
                                if dns_servers_array is not None:
                                    for dns_servers_value in dns_servers_array:
                                        dhcp_options_instance.dns_servers.append(dns_servers_value)
                                    
                            subnets_array = properties_value.get('subnets', None)
                            if subnets_array is not None:
                                for subnets_value in subnets_array:
                                    subnet_json_format_instance = Subnet(ip_configurations=[])
                                    virtual_network_json_format_instance.subnets.append(subnet_json_format_instance)
                                    
                                    properties_value2 = subnets_value.get('properties', None)
                                    if properties_value2 is not None:
                                        address_prefix_value = properties_value2.get('addressPrefix', None)
                                        if address_prefix_value is not None:
                                            address_prefix_instance = address_prefix_value
                                            subnet_json_format_instance.address_prefix = address_prefix_instance
                                        
                                        network_security_group_value = properties_value2.get('networkSecurityGroup', None)
                                        if network_security_group_value is not None:
                                            network_security_group_instance = ResourceId()
                                            subnet_json_format_instance.network_security_group = network_security_group_instance
                                            
                                            id_value = network_security_group_value.get('id', None)
                                            if id_value is not None:
                                                id_instance = id_value
                                                network_security_group_instance.id = id_instance
                                            
                                        ip_configurations_array = properties_value2.get('ipConfigurations', None)
                                        if ip_configurations_array is not None:
                                            for ip_configurations_value in ip_configurations_array:
                                                resource_id_instance = ResourceId()
                                                subnet_json_format_instance.ip_configurations.append(resource_id_instance)
                                                
                                                id_value2 = ip_configurations_value.get('id', None)
                                                if id_value2 is not None:
                                                    id_instance2 = id_value2
                                                    resource_id_instance.id = id_instance2
                                                
                                        provisioning_state_value = properties_value2.get('provisioningState', None)
                                        if provisioning_state_value is not None:
                                            provisioning_state_instance = provisioning_state_value
                                            subnet_json_format_instance.provisioning_state = provisioning_state_instance
                                        
                                    name_value = subnets_value.get('name', None)
                                    if name_value is not None:
                                        name_instance = name_value
                                        subnet_json_format_instance.name = name_instance
                                    
                                    etag_value = subnets_value.get('etag', None)
                                    if etag_value is not None:
                                        etag_instance = etag_value
                                        subnet_json_format_instance.etag = etag_instance
                                    
                                    id_value3 = subnets_value.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        subnet_json_format_instance.id = id_instance3
                                    
                            provisioning_state_value2 = properties_value.get('provisioningState', None)
                            if provisioning_state_value2 is not None:
                                provisioning_state_instance2 = provisioning_state_value2
                                virtual_network_json_format_instance.provisioning_state = provisioning_state_instance2
                            
                        etag_value2 = value_value.get('etag', None)
                        if etag_value2 is not None:
                            etag_instance2 = etag_value2
                            virtual_network_json_format_instance.etag = etag_instance2
                        
                        id_value4 = value_value.get('id', None)
                        if id_value4 is not None:
                            id_instance4 = id_value4
                            virtual_network_json_format_instance.id = id_instance4
                        
                        name_value2 = value_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            virtual_network_json_format_instance.name = name_instance2
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            virtual_network_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            virtual_network_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                virtual_network_json_format_instance.tags[tags_key] = tags_value
                            
                next_link_value = response_doc.get('nextLink', None)
                if next_link_value is not None:
                    next_link_instance = next_link_value
                    result.next_link = next_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
