
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation

class AdminUser(object):
	def __init__(self, mozuClient = None):
		self.client = mozuClient or default_client();
	
	def getTenantScopesForUser(self,userId, responseFields = None):
		""" Retrieves a list of the Mozu tenants or development stores for which the specified user has an assigned role.
		
		Args:
			| userId (string) - Unique identifier of the user whose tenant scopes you want to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| TenantCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/platform/adminuser/accounts/{userId}/tenants?responseFields={responseFields}", "GET", UrlLocation.HomePod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("userId", userId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getUser(self,userId, responseFields = None):
		""" Retrieves the details of the specified administrator user account.
		
		Args:
			| userId (string) - Unique identifier of the user whose tenant scopes you want to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| User 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/platform/adminuser/accounts/{userId}?responseFields={responseFields}", "GET", UrlLocation.HomePod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("userId", userId);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
	
	