
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class PublishSetSummary(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getPublishSets(self,pageSize = None, startIndex = None, responseFields = None):
		""" Returns a List of current Publishing sets with counts of drafts in each
		
		Args:
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The amount is divided and displayed on the  pageCount  amount of pages. The default is 20 and maximum value is 200 per page.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a  pageSize  of 25, to get the 51st through the 75th items, use  startIndex=3 .
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| PublishSetSummaryPagedCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/publishsets/?pageSize={pageSize}&startIndex={startIndex}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getPublishSetItems(self,code, pageSize = None, startIndex = None, responseFields = None):
		""" Retrieve a paged collection of publish set Items.
		
		Args:
			| code (string) - User-defined code that uniqely identifies the channel group.
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The amount is divided and displayed on the  pageCount  amount of pages. The default is 20 and maximum value is 200 per page.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a  pageSize  of 25, to get the 51st through the 75th items, use  startIndex=3 .
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| DocumentDraftSummaryPagedCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/publishsets/{code}/items?pageSize={pageSize}&startIndex={startIndex}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def deletePublishSet(self,code, shouldDiscard = False, responseFields = None):
		""" Adds a set of documents by id to a publish set
		
		Args:
			| code (string) - User-defined code that uniqely identifies the channel group.
			| shouldDiscard (bool) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| object 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/publishsets/{code}?shouldDiscard={shouldDiscard}&responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("shouldDiscard", shouldDiscard);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addPublishSetItems(self,itemsToPublish, code, responseFields = None):
		""" Adds a set of documents by id to a publish set
		
		Args:
			| itemsToPublish(array|itemsToPublish) - Mozu.Content.Contracts.AddOrDeletePublishItem ApiType DOCUMENT_HERE 
			| code (string) - User-defined code that uniqely identifies the channel group.
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| object 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/publishsets/{code}/items?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("code", code);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(itemsToPublish).execute();
		return self.client.result();

	
	
	