
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class DocumentType(object):
	def __init__(self, apiContext: ApiContext = None, dataViewMode="Live", mozuClient = None):
		if (apiContext is not None and apiContext.dataViewMode is None):
			apiContext.dataViewMode = dataViewMode;
		else:
			apiContext = ApiContext(dataViewMode = dataViewMode);
		self.client = mozuClient or default_client();
		self.client.withApiContext(apiContext);
	
	def getDocumentTypes(self,pageSize = None, startIndex = None, responseFields = None):
		""" Retrieves a paged list of the system-defined document types.
		
		Args:
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a PageSize of 25, to get the 51st through the 75th items, use startIndex=3.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DocumentTypeCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documenttypes/?pageSize={pageSize}&startIndex={startIndex}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getDocumentType(self,documentTypeName, responseFields = None):
		""" Retrieves a system-defined document type.
		
		Args:
			| documentTypeName (string) - The name of the document type to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DocumentType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documenttypes/{documentTypeName}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("documentTypeName", documentTypeName);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def createDocumentType(self,documentType, responseFields = None):
		""" Creates a new DocumentType
		
		Args:
			| documentType(documentType) - The type of documents used in the CMS such as "web_page" or "template" or "image_url".
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DocumentType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documenttypes/?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(documentType).execute();
		return self.client.result();

	
		
	def updateDocumentType(self,documentType, documentTypeName, responseFields = None):
		""" Updates a DocumentType
		
		Args:
			| documentType(documentType) - The type of documents used in the CMS such as "web_page" or "template" or "image_url".
			| documentTypeName (string) - The name of the document type to retrieve.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| DocumentType 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/content/documenttypes/{documentTypeName}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("documentTypeName", documentTypeName);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(documentType).execute();
		return self.client.result();

	
	
	