
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class Search(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getSearchTuningRule(self,searchTuningRuleCode, responseFields = None):
		""" admin-search Get GetSearchTuningRule description DOCUMENT_HERE 
		
		Args:
			| searchTuningRuleCode (string) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| SearchTuningRule 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/searchtuningrules/{searchTuningRuleCode}?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("searchTuningRuleCode", searchTuningRuleCode);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getSearchTuningRules(self,startIndex = None, pageSize = None, sortBy = None, filter = None, responseFields = None):
		""" admin-search Get GetSearchTuningRules description DOCUMENT_HERE 
		
		Args:
			| startIndex (int) - When creating paged results from a query, this value indicates the zero-based offset in the complete result set where the returned entities begin. For example, with a  pageSize  of 25, to get the 51st through the 75th items, use  startIndex=3 .
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The amount is divided and displayed on the  pageCount  amount of pages. The default is 20 and maximum value is 200 per page.
			| sortBy (string) - The element to sort the results by and the channel in which the results appear. Either ascending (a-z) or descending (z-a) channel. Optional.
			| filter (string) - A set of filter expressions representing the search parameters for a query: eq=equals, ne=not equals, gt=greater than, lt = less than or equals, gt = greater than or equals, lt = less than or equals, sw = starts with, or cont = contains. Optional.
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| SearchTuningRuleCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/searchtuningrules?startIndex={startIndex}&pageSize={pageSize}&sortBy={sortBy}&filter={filter}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getSearchTuningRuleSortFields(self,):
		""" 
		
		Returns:
			| Stream 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/searchtuningrulesortfields", "GET", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def getSettings(self,responseFields = None):
		""" Get site search settings
		
		Args:
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| SearchSettings 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/settings?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def addSearchTuningRule(self,searchTuningRuleIn, responseFields = None):
		""" admin-search Post AddSearchTuningRule description DOCUMENT_HERE 
		
		Args:
			| searchTuningRuleIn(searchTuningRuleIn) - Mozu.ProductAdmin.Contracts.Search.SearchTuningRule ApiType DOCUMENT_HERE 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| SearchTuningRule 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/searchtuningrules?responseFields={responseFields}", "POST", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(searchTuningRuleIn).execute();
		return self.client.result();

	
		
	def updateSearchTuningRuleSortFields(self,searchTuningRuleSortFieldsIn):
		""" 
		
		Args:
			| searchTuningRuleSortFieldsIn(searchTuningRuleSortFieldsIn) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/searchtuningrulesortfields", "POST", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).withBody(searchTuningRuleSortFieldsIn).execute();

	
		
	def updateSearchTuningRule(self,searchTuningRuleIn, searchTuningRuleCode, responseFields = None):
		""" admin-search Put UpdateSearchTuningRule description DOCUMENT_HERE 
		
		Args:
			| searchTuningRuleIn(searchTuningRuleIn) - Mozu.ProductAdmin.Contracts.Search.SearchTuningRule ApiType DOCUMENT_HERE 
			| searchTuningRuleCode (string) - 
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| SearchTuningRule 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/searchtuningrules/{searchTuningRuleCode}?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("searchTuningRuleCode", searchTuningRuleCode);
		self.client.withResourceUrl(url).withBody(searchTuningRuleIn).execute();
		return self.client.result();

	
		
	def updateSettings(self,settings, responseFields = None):
		""" Adds or Updates (Upsert) the Search Settings for a specific site
		
		Args:
			| settings(settings) - The settings to control product search and indexing behavior.
			| responseFields (string) - A list or array of fields returned for a call. These fields may be customized and may be used for various types of data calls in Mozu. For example, responseFields are returned for retrieving or updating attributes, carts, and messages in Mozu.
		
		Returns:
			| SearchSettings 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/settings?responseFields={responseFields}", "PUT", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).withBody(settings).execute();
		return self.client.result();

	
		
	def deleteSearchTuningRule(self,searchTuningRuleCode):
		""" admin-search Delete DeleteSearchTuningRule description DOCUMENT_HERE 
		
		Args:
			| searchTuningRuleCode (string) - 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/admin/search/searchtuningrules/{searchTuningRuleCode}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("searchTuningRuleCode", searchTuningRuleCode);
		self.client.withResourceUrl(url).execute();

	
	
	