
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class ChangeMessage(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		if (apiContext is not None):
			self.client.withApiContext(apiContext);
		else:
			self.client.withApiContext(ApiContext());
	
	def getMessages(self,responseFields = None):
		""" Retrieves the messages associated with the current shopper's cart.
		
		Args:
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| CartChangeMessageCollection 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/messages?responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def removeAllMessages(self,):
		""" Deletes all messages associated with the cart of the current shopper.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/messages", "DELETE", UrlLocation.TenantPod, False);
		self.client.withResourceUrl(url).execute();

	
		
	def removeMessage(self,messageId):
		""" Removes a single message associated with the cart of the current shopper.
		
		Args:
			| messageId (string) - Identifier of the message to remove from the cart.
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/carts/current/messages/{messageId}", "DELETE", UrlLocation.TenantPod, False);
		url.formatUrl("messageId", messageId);
		self.client.withResourceUrl(url).execute();

	
	
	