# Generated by Django 3.2.15 on 2023-09-11 18:41

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("course_flow", "0113_project_from_saltise"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="course",
            options={
                "verbose_name": "Course",
                "verbose_name_plural": "Courses",
            },
        ),
        migrations.AlterModelOptions(
            name="discipline",
            options={
                "verbose_name": "Discipline",
                "verbose_name_plural": "Disciplines",
            },
        ),
        migrations.AlterModelOptions(
            name="node",
            options={"verbose_name": "Node", "verbose_name_plural": "Nodes"},
        ),
        migrations.AlterModelOptions(
            name="program",
            options={
                "verbose_name": "Program",
                "verbose_name_plural": "Programs",
            },
        ),
        migrations.AlterModelOptions(
            name="workflow",
            options={
                "verbose_name": "Workflow",
                "verbose_name_plural": "Workflows",
            },
        ),
        migrations.CreateModel(
            name="Notification",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "notification_type",
                    models.PositiveIntegerField(
                        choices=[(0, "Shared"), (1, "Comment")], default=0
                    ),
                ),
                ("object_id", models.PositiveIntegerField()),
                ("text", models.TextField(blank=True)),
                (
                    "created_on",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        limit_choices_to={
                            "model__in": ["project", "workflow"]
                        },
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "source_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="sent_notifications",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
