# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class CertificateBodyDescription(msrest.serialization.Model):
    """The JSON-serialized X509 Certificate.

    :param certificate: base-64 representation of the X509 leaf certificate .cer file or just .pem
     file content.
    :type certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateBodyDescription, self).__init__(**kwargs)
        self.certificate = kwargs.get('certificate', None)


class CertificateDescription(msrest.serialization.Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param properties: The description of an X509 CA Certificate.
    :type properties: ~azure.mgmt.iothub.models.CertificateProperties
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificateProperties'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateDescription, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CertificateListDescription(msrest.serialization.Model):
    """The JSON-serialized array of Certificate objects.

    :param value: The array of Certificate objects.
    :type value: list[~azure.mgmt.iothub.models.CertificateDescription]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CertificateDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateListDescription, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class CertificateProperties(msrest.serialization.Model):
    """The description of an X509 CA Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar created: The certificate's create date and time.
    :vartype created: ~datetime.datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateProperties, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.created = None
        self.updated = None


class CertificatePropertiesWithNonce(msrest.serialization.Model):
    """The description of an X509 CA Certificate including the challenge nonce issued for the Proof-Of-Possession flow.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar created: The certificate's create date and time.
    :vartype created: ~datetime.datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: ~datetime.datetime
    :ivar verification_code: The certificate's verification code that will be used for proof of
     possession.
    :vartype verification_code: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
        'verification_code': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
        'verification_code': {'key': 'verificationCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificatePropertiesWithNonce, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.created = None
        self.updated = None
        self.verification_code = None


class CertificateVerificationDescription(msrest.serialization.Model):
    """The JSON-serialized leaf certificate.

    :param certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :type certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateVerificationDescription, self).__init__(**kwargs)
        self.certificate = kwargs.get('certificate', None)


class CertificateWithNonceDescription(msrest.serialization.Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param properties: The description of an X509 CA Certificate including the challenge nonce
     issued for the Proof-Of-Possession flow.
    :type properties: ~azure.mgmt.iothub.models.CertificatePropertiesWithNonce
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificatePropertiesWithNonce'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CertificateWithNonceDescription, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CloudToDeviceProperties(msrest.serialization.Model):
    """The IoT hub cloud-to-device messaging properties.

    :param max_delivery_count: The max delivery count for cloud-to-device messages in the device
     queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-
     device-messages.
    :type max_delivery_count: int
    :param default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the
     device queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-
     to-device-messages.
    :type default_ttl_as_iso8601: ~datetime.timedelta
    :param feedback: The properties of the feedback queue for cloud-to-device messages.
    :type feedback: ~azure.mgmt.iothub.models.FeedbackProperties
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
        'default_ttl_as_iso8601': {'key': 'defaultTtlAsIso8601', 'type': 'duration'},
        'feedback': {'key': 'feedback', 'type': 'FeedbackProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudToDeviceProperties, self).__init__(**kwargs)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)
        self.default_ttl_as_iso8601 = kwargs.get('default_ttl_as_iso8601', None)
        self.feedback = kwargs.get('feedback', None)


class ErrorDetails(msrest.serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar http_status_code: The HTTP status code.
    :vartype http_status_code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        'code': {'readonly': True},
        'http_status_code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'http_status_code': {'key': 'httpStatusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.http_status_code = None
        self.message = None
        self.details = None


class EventHubConsumerGroupInfo(msrest.serialization.Model):
    """The properties of the EventHubConsumerGroupInfo object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param properties: The tags.
    :type properties: dict[str, str]
    :ivar id: The Event Hub-compatible consumer group identifier.
    :vartype id: str
    :ivar name: The Event Hub-compatible consumer group name.
    :vartype name: str
    :ivar type: the resource type.
    :vartype type: str
    :ivar etag: The etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubConsumerGroupInfo, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class EventHubConsumerGroupsListResult(msrest.serialization.Model):
    """The JSON-serialized array of Event Hub-compatible consumer group names with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of consumer groups objects.
    :type value: list[~azure.mgmt.iothub.models.EventHubConsumerGroupInfo]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventHubConsumerGroupInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubConsumerGroupsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class EventHubProperties(msrest.serialization.Model):
    """The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param retention_time_in_days: The retention time for device-to-cloud messages in days. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :type retention_time_in_days: long
    :param partition_count: The number of partitions for receiving device-to-cloud messages in the
     Event Hub-compatible endpoint. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-
     messaging#device-to-cloud-messages.
    :type partition_count: int
    :ivar partition_ids: The partition ids in the Event Hub-compatible endpoint.
    :vartype partition_ids: list[str]
    :ivar path: The Event Hub-compatible name.
    :vartype path: str
    :ivar endpoint: The Event Hub-compatible endpoint.
    :vartype endpoint: str
    """

    _validation = {
        'partition_ids': {'readonly': True},
        'path': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'retention_time_in_days': {'key': 'retentionTimeInDays', 'type': 'long'},
        'partition_count': {'key': 'partitionCount', 'type': 'int'},
        'partition_ids': {'key': 'partitionIds', 'type': '[str]'},
        'path': {'key': 'path', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventHubProperties, self).__init__(**kwargs)
        self.retention_time_in_days = kwargs.get('retention_time_in_days', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.partition_ids = None
        self.path = None
        self.endpoint = None


class ExportDevicesRequest(msrest.serialization.Model):
    """Use to provide parameters when requesting an export of all devices in the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :param export_blob_container_uri: Required. The export blob container URI.
    :type export_blob_container_uri: str
    :param exclude_keys: Required. The value indicating whether keys should be excluded during
     export.
    :type exclude_keys: bool
    """

    _validation = {
        'export_blob_container_uri': {'required': True},
        'exclude_keys': {'required': True},
    }

    _attribute_map = {
        'export_blob_container_uri': {'key': 'exportBlobContainerUri', 'type': 'str'},
        'exclude_keys': {'key': 'excludeKeys', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportDevicesRequest, self).__init__(**kwargs)
        self.export_blob_container_uri = kwargs['export_blob_container_uri']
        self.exclude_keys = kwargs['exclude_keys']


class FallbackRouteProperties(msrest.serialization.Model):
    """The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the route. The name can only include alphanumeric characters, periods,
     underscores, hyphens, has a maximum length of 64 characters, and must be unique.
    :type name: str
    :param source: Required. The source to which the routing rule is to be applied to. For example,
     DeviceMessages. Possible values include: "DeviceMessages", "TwinChangeEvents",
     "DeviceLifecycleEvents", "DeviceJobLifecycleEvents".
    :type source: str or ~azure.mgmt.iothub.models.RoutingSource
    :param condition: The condition which is evaluated in order to apply the fallback route. If the
     condition is not provided it will evaluate to true by default. For grammar, See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language.
    :type condition: str
    :param endpoint_names: Required. The list of endpoints to which the messages that satisfy the
     condition are routed to. Currently only 1 endpoint is allowed.
    :type endpoint_names: list[str]
    :param is_enabled: Required. Used to specify whether the fallback route is enabled.
    :type is_enabled: bool
    """

    _validation = {
        'source': {'required': True},
        'endpoint_names': {'required': True, 'max_items': 1, 'min_items': 1},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'condition': {'key': 'condition', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FallbackRouteProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.source = kwargs['source']
        self.condition = kwargs.get('condition', None)
        self.endpoint_names = kwargs['endpoint_names']
        self.is_enabled = kwargs['is_enabled']


class FeedbackProperties(msrest.serialization.Model):
    """The properties of the feedback queue for cloud-to-device messages.

    :param lock_duration_as_iso8601: The lock duration for the feedback queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :type lock_duration_as_iso8601: ~datetime.timedelta
    :param ttl_as_iso8601: The period of time for which a message is available to consume before it
     is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-
     messaging#cloud-to-device-messages.
    :type ttl_as_iso8601: ~datetime.timedelta
    :param max_delivery_count: The number of times the IoT hub attempts to deliver a message on the
     feedback queue. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-
     to-device-messages.
    :type max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FeedbackProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = kwargs.get('lock_duration_as_iso8601', None)
        self.ttl_as_iso8601 = kwargs.get('ttl_as_iso8601', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)


class ImportDevicesRequest(msrest.serialization.Model):
    """Use to provide parameters when requesting an import of all devices in the hub.

    All required parameters must be populated in order to send to Azure.

    :param input_blob_container_uri: Required. The input blob container URI.
    :type input_blob_container_uri: str
    :param output_blob_container_uri: Required. The output blob container URI.
    :type output_blob_container_uri: str
    """

    _validation = {
        'input_blob_container_uri': {'required': True},
        'output_blob_container_uri': {'required': True},
    }

    _attribute_map = {
        'input_blob_container_uri': {'key': 'inputBlobContainerUri', 'type': 'str'},
        'output_blob_container_uri': {'key': 'outputBlobContainerUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImportDevicesRequest, self).__init__(**kwargs)
        self.input_blob_container_uri = kwargs['input_blob_container_uri']
        self.output_blob_container_uri = kwargs['output_blob_container_uri']


class IotHubCapacity(msrest.serialization.Model):
    """IoT Hub capacity information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum number of units.
    :vartype minimum: long
    :ivar maximum: The maximum number of units.
    :vartype maximum: long
    :ivar default: The default number of units.
    :vartype default: long
    :ivar scale_type: The type of the scaling enabled. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.iothub.models.IotHubScaleType
    """

    _validation = {
        'minimum': {'readonly': True, 'maximum': 1, 'minimum': 1},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default': {'key': 'default', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class Resource(msrest.serialization.Model):
    """The common properties of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class IotHubDescription(Resource):
    """The description of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param etag: The Etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal ETag convention.
    :type etag: str
    :param properties: The properties of an IoT hub.
    :type properties: ~azure.mgmt.iothub.models.IotHubProperties
    :param sku: Required. Information about the SKU of the IoT hub.
    :type sku: ~azure.mgmt.iothub.models.IotHubSkuInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IotHubProperties'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubDescription, self).__init__(**kwargs)
        self.etag = kwargs.get('etag', None)
        self.properties = kwargs.get('properties', None)
        self.sku = kwargs['sku']


class IotHubDescriptionListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubDescription objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The array of IotHubDescription objects.
    :type value: list[~azure.mgmt.iothub.models.IotHubDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubDescriptionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class IotHubNameAvailabilityInfo(msrest.serialization.Model):
    """The properties indicating whether a given IoT hub name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: The value which indicates whether the provided name is available.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.iothub.models.IotHubNameUnavailabilityReason
    :param message: The detailed reason message.
    :type message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubNameAvailabilityInfo, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = kwargs.get('message', None)


class IotHubProperties(msrest.serialization.Model):
    """The properties of an IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param authorization_policies: The shared access policies you can use to secure a connection to
     the IoT hub.
    :type authorization_policies:
     list[~azure.mgmt.iothub.models.SharedAccessSignatureAuthorizationRule]
    :param ip_filter_rules: The IP filter rules.
    :type ip_filter_rules: list[~azure.mgmt.iothub.models.IpFilterRule]
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar state: The hub state.
    :vartype state: str
    :ivar host_name: The name of the host.
    :vartype host_name: str
    :param event_hub_endpoints: The Event Hub-compatible endpoint properties. The possible keys to
     this dictionary are events and operationsMonitoringEvents. Both of these keys have to be
     present in the dictionary while making create or update calls for the IoT hub.
    :type event_hub_endpoints: dict[str, ~azure.mgmt.iothub.models.EventHubProperties]
    :param routing: The routing related properties of the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging.
    :type routing: ~azure.mgmt.iothub.models.RoutingProperties
    :param storage_endpoints: The list of Azure Storage endpoints where you can upload files.
     Currently you can configure only one Azure Storage account and that MUST have its key as
     $default. Specifying more than one storage account causes an error to be thrown. Not specifying
     a value for this property when the enableFileUploadNotifications property is set to True,
     causes an error to be thrown.
    :type storage_endpoints: dict[str, ~azure.mgmt.iothub.models.StorageEndpointProperties]
    :param messaging_endpoints: The messaging endpoint properties for the file upload notification
     queue.
    :type messaging_endpoints: dict[str, ~azure.mgmt.iothub.models.MessagingEndpointProperties]
    :param enable_file_upload_notifications: If True, file upload notifications are enabled.
    :type enable_file_upload_notifications: bool
    :param cloud_to_device: The IoT hub cloud-to-device messaging properties.
    :type cloud_to_device: ~azure.mgmt.iothub.models.CloudToDeviceProperties
    :param comments: IoT hub comments.
    :type comments: str
    :param operations_monitoring_properties: The operations monitoring properties for the IoT hub.
     The possible keys to the dictionary are Connections, DeviceTelemetry, C2DCommands,
     DeviceIdentityOperations, FileUploadOperations, Routes, D2CTwinOperations, C2DTwinOperations,
     TwinQueries, JobsOperations, DirectMethods.
    :type operations_monitoring_properties:
     ~azure.mgmt.iothub.models.OperationsMonitoringProperties
    :param features: The capabilities and features enabled for the IoT hub. Possible values
     include: "None", "DeviceManagement".
    :type features: str or ~azure.mgmt.iothub.models.Capabilities
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'host_name': {'readonly': True},
    }

    _attribute_map = {
        'authorization_policies': {'key': 'authorizationPolicies', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'ip_filter_rules': {'key': 'ipFilterRules', 'type': '[IpFilterRule]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'event_hub_endpoints': {'key': 'eventHubEndpoints', 'type': '{EventHubProperties}'},
        'routing': {'key': 'routing', 'type': 'RoutingProperties'},
        'storage_endpoints': {'key': 'storageEndpoints', 'type': '{StorageEndpointProperties}'},
        'messaging_endpoints': {'key': 'messagingEndpoints', 'type': '{MessagingEndpointProperties}'},
        'enable_file_upload_notifications': {'key': 'enableFileUploadNotifications', 'type': 'bool'},
        'cloud_to_device': {'key': 'cloudToDevice', 'type': 'CloudToDeviceProperties'},
        'comments': {'key': 'comments', 'type': 'str'},
        'operations_monitoring_properties': {'key': 'operationsMonitoringProperties', 'type': 'OperationsMonitoringProperties'},
        'features': {'key': 'features', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubProperties, self).__init__(**kwargs)
        self.authorization_policies = kwargs.get('authorization_policies', None)
        self.ip_filter_rules = kwargs.get('ip_filter_rules', None)
        self.provisioning_state = None
        self.state = None
        self.host_name = None
        self.event_hub_endpoints = kwargs.get('event_hub_endpoints', None)
        self.routing = kwargs.get('routing', None)
        self.storage_endpoints = kwargs.get('storage_endpoints', None)
        self.messaging_endpoints = kwargs.get('messaging_endpoints', None)
        self.enable_file_upload_notifications = kwargs.get('enable_file_upload_notifications', None)
        self.cloud_to_device = kwargs.get('cloud_to_device', None)
        self.comments = kwargs.get('comments', None)
        self.operations_monitoring_properties = kwargs.get('operations_monitoring_properties', None)
        self.features = kwargs.get('features', None)


class IotHubQuotaMetricInfo(msrest.serialization.Model):
    """Quota metrics properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the quota metric.
    :vartype name: str
    :ivar current_value: The current value for the quota metric.
    :vartype current_value: long
    :ivar max_value: The maximum value of the quota metric.
    :vartype max_value: long
    """

    _validation = {
        'name': {'readonly': True},
        'current_value': {'readonly': True},
        'max_value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'max_value': {'key': 'maxValue', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubQuotaMetricInfo, self).__init__(**kwargs)
        self.name = None
        self.current_value = None
        self.max_value = None


class IotHubQuotaMetricInfoListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubQuotaMetricInfo objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The array of quota metrics objects.
    :type value: list[~azure.mgmt.iothub.models.IotHubQuotaMetricInfo]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubQuotaMetricInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubQuotaMetricInfoListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class IotHubSkuDescription(msrest.serialization.Model):
    """SKU properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :param sku: Required. The type of the resource.
    :type sku: ~azure.mgmt.iothub.models.IotHubSkuInfo
    :param capacity: Required. IoT Hub capacity information.
    :type capacity: ~azure.mgmt.iothub.models.IotHubCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
        'capacity': {'key': 'capacity', 'type': 'IotHubCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubSkuDescription, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = kwargs['sku']
        self.capacity = kwargs['capacity']


class IotHubSkuDescriptionListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubSkuDescription objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The array of IotHubSkuDescription.
    :type value: list[~azure.mgmt.iothub.models.IotHubSkuDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubSkuDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubSkuDescriptionListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class IotHubSkuInfo(msrest.serialization.Model):
    """Information about the SKU of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Possible values include: "F1", "S1", "S2", "S3".
    :type name: str or ~azure.mgmt.iothub.models.IotHubSku
    :ivar tier: The billing tier for the IoT hub. Possible values include: "Free", "Standard".
    :vartype tier: str or ~azure.mgmt.iothub.models.IotHubSkuTier
    :param capacity: The number of provisioned IoT Hub units. See:
     https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
    :type capacity: long
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotHubSkuInfo, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = None
        self.capacity = kwargs.get('capacity', None)


class IpFilterRule(msrest.serialization.Model):
    """The IP filter rules for the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :param filter_name: Required. The name of the IP filter rule.
    :type filter_name: str
    :param action: Required. The desired action for requests captured by this rule. Possible values
     include: "Accept", "Reject".
    :type action: str or ~azure.mgmt.iothub.models.IpFilterActionType
    :param ip_mask: Required. A string that contains the IP address range in CIDR notation for the
     rule.
    :type ip_mask: str
    """

    _validation = {
        'filter_name': {'required': True},
        'action': {'required': True},
        'ip_mask': {'required': True},
    }

    _attribute_map = {
        'filter_name': {'key': 'filterName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IpFilterRule, self).__init__(**kwargs)
        self.filter_name = kwargs['filter_name']
        self.action = kwargs['action']
        self.ip_mask = kwargs['ip_mask']


class JobResponse(msrest.serialization.Model):
    """The properties of the Job Response object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_id: The job identifier.
    :vartype job_id: str
    :ivar start_time_utc: The start time of the job.
    :vartype start_time_utc: ~datetime.datetime
    :ivar end_time_utc: The time the job stopped processing.
    :vartype end_time_utc: ~datetime.datetime
    :ivar type: The type of the job. Possible values include: "unknown", "export", "import",
     "backup", "readDeviceProperties", "writeDeviceProperties", "updateDeviceConfiguration",
     "rebootDevice", "factoryResetDevice", "firmwareUpdate".
    :vartype type: str or ~azure.mgmt.iothub.models.JobType
    :ivar status: The status of the job. Possible values include: "unknown", "enqueued", "running",
     "completed", "failed", "cancelled".
    :vartype status: str or ~azure.mgmt.iothub.models.JobStatus
    :ivar failure_reason: If status == failed, this string containing the reason for the failure.
    :vartype failure_reason: str
    :ivar status_message: The status message for the job.
    :vartype status_message: str
    :ivar parent_job_id: The job identifier of the parent job, if any.
    :vartype parent_job_id: str
    """

    _validation = {
        'job_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'failure_reason': {'readonly': True},
        'status_message': {'readonly': True},
        'parent_job_id': {'readonly': True},
    }

    _attribute_map = {
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'rfc-1123'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'rfc-1123'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'parent_job_id': {'key': 'parentJobId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobResponse, self).__init__(**kwargs)
        self.job_id = None
        self.start_time_utc = None
        self.end_time_utc = None
        self.type = None
        self.status = None
        self.failure_reason = None
        self.status_message = None
        self.parent_job_id = None


class JobResponseListResult(msrest.serialization.Model):
    """The JSON-serialized array of JobResponse objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The array of JobResponse objects.
    :type value: list[~azure.mgmt.iothub.models.JobResponse]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobResponseListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class MessagingEndpointProperties(msrest.serialization.Model):
    """The properties of the messaging endpoints used by this IoT hub.

    :param lock_duration_as_iso8601: The lock duration. See: https://docs.microsoft.com/azure/iot-
     hub/iot-hub-devguide-file-upload.
    :type lock_duration_as_iso8601: ~datetime.timedelta
    :param ttl_as_iso8601: The period of time for which a message is available to consume before it
     is expired by the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-
     upload.
    :type ttl_as_iso8601: ~datetime.timedelta
    :param max_delivery_count: The number of times the IoT hub attempts to deliver a message. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :type max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MessagingEndpointProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = kwargs.get('lock_duration_as_iso8601', None)
        self.ttl_as_iso8601 = kwargs.get('ttl_as_iso8601', None)
        self.max_delivery_count = kwargs.get('max_delivery_count', None)


class Operation(msrest.serialization.Model):
    """IoT Hub REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action | delete}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.iothub.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft Devices.
    :vartype provider: str
    :ivar resource: Resource Type: IotHubs.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationInputs(msrest.serialization.Model):
    """Input values.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the IoT hub to check.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationInputs, self).__init__(**kwargs)
        self.name = kwargs['name']


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list IoT Hub operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of IoT Hub operations supported by the Microsoft.Devices resource provider.
    :vartype value: list[~azure.mgmt.iothub.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationsMonitoringProperties(msrest.serialization.Model):
    """The operations monitoring properties for the IoT hub. The possible keys to the dictionary are Connections, DeviceTelemetry, C2DCommands, DeviceIdentityOperations, FileUploadOperations, Routes, D2CTwinOperations, C2DTwinOperations, TwinQueries, JobsOperations, DirectMethods.

    :param events: Dictionary of :code:`<OperationMonitoringLevel>`.
    :type events: dict[str, str or ~azure.mgmt.iothub.models.OperationMonitoringLevel]
    """

    _attribute_map = {
        'events': {'key': 'events', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationsMonitoringProperties, self).__init__(**kwargs)
        self.events = kwargs.get('events', None)


class RegistryStatistics(msrest.serialization.Model):
    """Identity registry statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_device_count: The total count of devices in the identity registry.
    :vartype total_device_count: long
    :ivar enabled_device_count: The count of enabled devices in the identity registry.
    :vartype enabled_device_count: long
    :ivar disabled_device_count: The count of disabled devices in the identity registry.
    :vartype disabled_device_count: long
    """

    _validation = {
        'total_device_count': {'readonly': True},
        'enabled_device_count': {'readonly': True},
        'disabled_device_count': {'readonly': True},
    }

    _attribute_map = {
        'total_device_count': {'key': 'totalDeviceCount', 'type': 'long'},
        'enabled_device_count': {'key': 'enabledDeviceCount', 'type': 'long'},
        'disabled_device_count': {'key': 'disabledDeviceCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryStatistics, self).__init__(**kwargs)
        self.total_device_count = None
        self.enabled_device_count = None
        self.disabled_device_count = None


class RouteProperties(msrest.serialization.Model):
    """The properties of a routing rule that your IoT hub uses to route messages to endpoints.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the route. The name can only include alphanumeric
     characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be
     unique.
    :type name: str
    :param source: Required. The source that the routing rule is to be applied to, such as
     DeviceMessages. Possible values include: "DeviceMessages", "TwinChangeEvents",
     "DeviceLifecycleEvents", "DeviceJobLifecycleEvents".
    :type source: str or ~azure.mgmt.iothub.models.RoutingSource
    :param condition: The condition that is evaluated to apply the routing rule. If no condition is
     provided, it evaluates to true by default. For grammar, see:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language.
    :type condition: str
    :param endpoint_names: Required. The list of endpoints to which messages that satisfy the
     condition are routed. Currently only one endpoint is allowed.
    :type endpoint_names: list[str]
    :param is_enabled: Required. Used to specify whether a route is enabled.
    :type is_enabled: bool
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
        'source': {'required': True},
        'endpoint_names': {'required': True, 'max_items': 1, 'min_items': 1},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'condition': {'key': 'condition', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RouteProperties, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.source = kwargs['source']
        self.condition = kwargs.get('condition', None)
        self.endpoint_names = kwargs['endpoint_names']
        self.is_enabled = kwargs['is_enabled']


class RoutingEndpoints(msrest.serialization.Model):
    """The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.

    :param service_bus_queues: The list of Service Bus queue endpoints that IoT hub routes the
     messages to, based on the routing rules.
    :type service_bus_queues:
     list[~azure.mgmt.iothub.models.RoutingServiceBusQueueEndpointProperties]
    :param service_bus_topics: The list of Service Bus topic endpoints that the IoT hub routes the
     messages to, based on the routing rules.
    :type service_bus_topics:
     list[~azure.mgmt.iothub.models.RoutingServiceBusTopicEndpointProperties]
    :param event_hubs: The list of Event Hubs endpoints that IoT hub routes messages to, based on
     the routing rules. This list does not include the built-in Event Hubs endpoint.
    :type event_hubs: list[~azure.mgmt.iothub.models.RoutingEventHubProperties]
    :param storage_containers: The list of storage container endpoints that IoT hub routes messages
     to, based on the routing rules.
    :type storage_containers: list[~azure.mgmt.iothub.models.RoutingStorageContainerProperties]
    """

    _attribute_map = {
        'service_bus_queues': {'key': 'serviceBusQueues', 'type': '[RoutingServiceBusQueueEndpointProperties]'},
        'service_bus_topics': {'key': 'serviceBusTopics', 'type': '[RoutingServiceBusTopicEndpointProperties]'},
        'event_hubs': {'key': 'eventHubs', 'type': '[RoutingEventHubProperties]'},
        'storage_containers': {'key': 'storageContainers', 'type': '[RoutingStorageContainerProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingEndpoints, self).__init__(**kwargs)
        self.service_bus_queues = kwargs.get('service_bus_queues', None)
        self.service_bus_topics = kwargs.get('service_bus_topics', None)
        self.event_hubs = kwargs.get('event_hubs', None)
        self.storage_containers = kwargs.get('storage_containers', None)


class RoutingEventHubProperties(msrest.serialization.Model):
    """The properties related to an event hub endpoint.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. The connection string of the event hub endpoint.
    :type connection_string: str
    :param name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, operationsMonitoringEvents,
     fileNotifications, $default. Endpoint names must be unique across endpoint types.
    :type name: str
    :param subscription_id: The subscription identifier of the event hub endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the event hub endpoint.
    :type resource_group: str
    """

    _validation = {
        'connection_string': {'required': True},
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingEventHubProperties, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.name = kwargs['name']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)


class RoutingProperties(msrest.serialization.Model):
    """The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging.

    :param endpoints: The properties related to the custom endpoints to which your IoT hub routes
     messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all
     endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types
     for free hubs.
    :type endpoints: ~azure.mgmt.iothub.models.RoutingEndpoints
    :param routes: The list of user-provided routing rules that the IoT hub uses to route messages
     to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and
     a maximum of 5 routing rules are allowed for free hubs.
    :type routes: list[~azure.mgmt.iothub.models.RouteProperties]
    :param fallback_route: The properties of the route that is used as a fall-back route when none
     of the conditions specified in the 'routes' section are met. This is an optional parameter.
     When this property is not set, the messages which do not meet any of the conditions specified
     in the 'routes' section get routed to the built-in eventhub endpoint.
    :type fallback_route: ~azure.mgmt.iothub.models.FallbackRouteProperties
    """

    _attribute_map = {
        'endpoints': {'key': 'endpoints', 'type': 'RoutingEndpoints'},
        'routes': {'key': 'routes', 'type': '[RouteProperties]'},
        'fallback_route': {'key': 'fallbackRoute', 'type': 'FallbackRouteProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingProperties, self).__init__(**kwargs)
        self.endpoints = kwargs.get('endpoints', None)
        self.routes = kwargs.get('routes', None)
        self.fallback_route = kwargs.get('fallback_route', None)


class RoutingServiceBusQueueEndpointProperties(msrest.serialization.Model):
    """The properties related to service bus queue endpoint types.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. The connection string of the service bus queue endpoint.
    :type connection_string: str
    :param name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, operationsMonitoringEvents,
     fileNotifications, $default. Endpoint names must be unique across endpoint types. The name need
     not be the same as the actual queue name.
    :type name: str
    :param subscription_id: The subscription identifier of the service bus queue endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the service bus queue endpoint.
    :type resource_group: str
    """

    _validation = {
        'connection_string': {'required': True},
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingServiceBusQueueEndpointProperties, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.name = kwargs['name']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)


class RoutingServiceBusTopicEndpointProperties(msrest.serialization.Model):
    """The properties related to service bus topic endpoint types.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. The connection string of the service bus topic endpoint.
    :type connection_string: str
    :param name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, operationsMonitoringEvents,
     fileNotifications, $default. Endpoint names must be unique across endpoint types.  The name
     need not be the same as the actual topic name.
    :type name: str
    :param subscription_id: The subscription identifier of the service bus topic endpoint.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the service bus topic endpoint.
    :type resource_group: str
    """

    _validation = {
        'connection_string': {'required': True},
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingServiceBusTopicEndpointProperties, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.name = kwargs['name']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)


class RoutingStorageContainerProperties(msrest.serialization.Model):
    """The properties related to a storage container endpoint.

    All required parameters must be populated in order to send to Azure.

    :param connection_string: Required. The connection string of the storage account.
    :type connection_string: str
    :param name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, operationsMonitoringEvents,
     fileNotifications, $default. Endpoint names must be unique across endpoint types.
    :type name: str
    :param subscription_id: The subscription identifier of the storage account.
    :type subscription_id: str
    :param resource_group: The name of the resource group of the storage account.
    :type resource_group: str
    :param container_name: Required. The name of storage container in the storage account.
    :type container_name: str
    :param file_name_format: File name format for the blob. Default format is
     {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be
     reordered.
    :type file_name_format: str
    :param batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value
     should be between 60 and 720 seconds. Default value is 300 seconds.
    :type batch_frequency_in_seconds: int
    :param max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value
     should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
    :type max_chunk_size_in_bytes: int
    :param encoding: Encoding that is used to serialize messages to blobs. Supported values are
     'avro' and 'avroDeflate'. Default value is 'avro'.
    :type encoding: str
    """

    _validation = {
        'connection_string': {'required': True},
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
        'container_name': {'required': True},
        'batch_frequency_in_seconds': {'maximum': 720, 'minimum': 60},
        'max_chunk_size_in_bytes': {'maximum': 524288000, 'minimum': 10485760},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'file_name_format': {'key': 'fileNameFormat', 'type': 'str'},
        'batch_frequency_in_seconds': {'key': 'batchFrequencyInSeconds', 'type': 'int'},
        'max_chunk_size_in_bytes': {'key': 'maxChunkSizeInBytes', 'type': 'int'},
        'encoding': {'key': 'encoding', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoutingStorageContainerProperties, self).__init__(**kwargs)
        self.connection_string = kwargs['connection_string']
        self.name = kwargs['name']
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group = kwargs.get('resource_group', None)
        self.container_name = kwargs['container_name']
        self.file_name_format = kwargs.get('file_name_format', None)
        self.batch_frequency_in_seconds = kwargs.get('batch_frequency_in_seconds', None)
        self.max_chunk_size_in_bytes = kwargs.get('max_chunk_size_in_bytes', None)
        self.encoding = kwargs.get('encoding', None)


class SharedAccessSignatureAuthorizationRule(msrest.serialization.Model):
    """The properties of an IoT hub shared access policy.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The name of the shared access policy.
    :type key_name: str
    :param primary_key: The primary key.
    :type primary_key: str
    :param secondary_key: The secondary key.
    :type secondary_key: str
    :param rights: Required. The permissions assigned to the shared access policy. Possible values
     include: "RegistryRead", "RegistryWrite", "ServiceConnect", "DeviceConnect", "RegistryRead,
     RegistryWrite", "RegistryRead, ServiceConnect", "RegistryRead, DeviceConnect", "RegistryWrite,
     ServiceConnect", "RegistryWrite, DeviceConnect", "ServiceConnect, DeviceConnect",
     "RegistryRead, RegistryWrite, ServiceConnect", "RegistryRead, RegistryWrite, DeviceConnect",
     "RegistryRead, ServiceConnect, DeviceConnect", "RegistryWrite, ServiceConnect, DeviceConnect",
     "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect".
    :type rights: str or ~azure.mgmt.iothub.models.AccessRights
    """

    _validation = {
        'key_name': {'required': True},
        'rights': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'rights': {'key': 'rights', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SharedAccessSignatureAuthorizationRule, self).__init__(**kwargs)
        self.key_name = kwargs['key_name']
        self.primary_key = kwargs.get('primary_key', None)
        self.secondary_key = kwargs.get('secondary_key', None)
        self.rights = kwargs['rights']


class SharedAccessSignatureAuthorizationRuleListResult(msrest.serialization.Model):
    """The list of shared access policies with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of shared access policies.
    :type value: list[~azure.mgmt.iothub.models.SharedAccessSignatureAuthorizationRule]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SharedAccessSignatureAuthorizationRuleListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class StorageEndpointProperties(msrest.serialization.Model):
    """The properties of the Azure Storage endpoint for file upload.

    All required parameters must be populated in order to send to Azure.

    :param sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for
     file upload is valid. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-
     upload#file-upload-notification-configuration-options.
    :type sas_ttl_as_iso8601: ~datetime.timedelta
    :param connection_string: Required. The connection string for the Azure Storage account to
     which files are uploaded.
    :type connection_string: str
    :param container_name: Required. The name of the root container where you upload files. The
     container need not exist but should be creatable using the connectionString specified.
    :type container_name: str
    """

    _validation = {
        'connection_string': {'required': True},
        'container_name': {'required': True},
    }

    _attribute_map = {
        'sas_ttl_as_iso8601': {'key': 'sasTtlAsIso8601', 'type': 'duration'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageEndpointProperties, self).__init__(**kwargs)
        self.sas_ttl_as_iso8601 = kwargs.get('sas_ttl_as_iso8601', None)
        self.connection_string = kwargs['connection_string']
        self.container_name = kwargs['container_name']


class TagsResource(msrest.serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on an IoT Hub instance.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
