# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class ServiceFabric(Resource):
    """A Service Fabric.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param external_service_fabric_id: The backing service fabric resource's
     id
    :type external_service_fabric_id: str
    :param environment_id: The resource id of the environment under which the
     service fabric resource is present
    :type environment_id: str
    :ivar applicable_schedule: The applicable schedule for the virtual
     machine.
    :vartype applicable_schedule:
     ~azure.mgmt.devtestlabs.models.ApplicableSchedule
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'applicable_schedule': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'external_service_fabric_id': {'key': 'properties.externalServiceFabricId', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'applicable_schedule': {'key': 'properties.applicableSchedule', 'type': 'ApplicableSchedule'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceFabric, self).__init__(**kwargs)
        self.external_service_fabric_id = kwargs.get('external_service_fabric_id', None)
        self.environment_id = kwargs.get('environment_id', None)
        self.applicable_schedule = None
        self.provisioning_state = None
        self.unique_identifier = None
