# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class BackupManagementType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Backup management type to execute the current job.
    """

    INVALID = "Invalid"
    AZURE_IAAS_VM = "AzureIaasVM"
    MAB = "MAB"
    DPM = "DPM"
    AZURE_BACKUP_SERVER = "AzureBackupServer"
    AZURE_SQL = "AzureSql"
    AZURE_STORAGE = "AzureStorage"
    AZURE_WORKLOAD = "AzureWorkload"
    DEFAULT_BACKUP = "DefaultBackup"

class CopyOptions(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Options to resolve copy conflicts.
    """

    INVALID = "Invalid"
    CREATE_COPY = "CreateCopy"
    SKIP = "Skip"
    OVERWRITE = "Overwrite"
    FAIL_ON_CONFLICT = "FailOnConflict"

class CreateMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Create mode to indicate recovery of existing soft deleted data source or creation of new data
    source.
    """

    INVALID = "Invalid"
    DEFAULT = "Default"
    RECOVER = "Recover"

class DataSourceType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of workload this item represents.
    """

    INVALID = "Invalid"
    VM = "VM"
    FILE_FOLDER = "FileFolder"
    AZURE_SQL_DB = "AzureSqlDb"
    SQLDB = "SQLDB"
    EXCHANGE = "Exchange"
    SHAREPOINT = "Sharepoint"
    V_MWARE_VM = "VMwareVM"
    SYSTEM_STATE = "SystemState"
    CLIENT = "Client"
    GENERIC_DATA_SOURCE = "GenericDataSource"
    SQL_DATA_BASE = "SQLDataBase"
    AZURE_FILE_SHARE = "AzureFileShare"
    SAP_HANA_DATABASE = "SAPHanaDatabase"
    SAP_ASE_DATABASE = "SAPAseDatabase"

class HealthState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Health State for the backed up item.
    """

    PASSED = "Passed"
    ACTION_REQUIRED = "ActionRequired"
    ACTION_SUGGESTED = "ActionSuggested"
    INVALID = "Invalid"

class HealthStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """backups running status for this backup item.
    """

    PASSED = "Passed"
    ACTION_REQUIRED = "ActionRequired"
    ACTION_SUGGESTED = "ActionSuggested"
    INVALID = "Invalid"

class JobOperationType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of operation.
    """

    INVALID = "Invalid"
    REGISTER = "Register"
    UN_REGISTER = "UnRegister"
    CONFIGURE_BACKUP = "ConfigureBackup"
    BACKUP = "Backup"
    RESTORE = "Restore"
    DISABLE_BACKUP = "DisableBackup"
    DELETE_BACKUP_DATA = "DeleteBackupData"
    CROSS_REGION_RESTORE = "CrossRegionRestore"
    UNDELETE = "Undelete"
    UPDATE_CUSTOMER_MANAGED_KEY = "UpdateCustomerManagedKey"

class JobStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the job.
    """

    INVALID = "Invalid"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    FAILED = "Failed"
    COMPLETED_WITH_WARNINGS = "CompletedWithWarnings"
    CANCELLED = "Cancelled"
    CANCELLING = "Cancelling"

class JobSupportedAction(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    INVALID = "Invalid"
    CANCELLABLE = "Cancellable"
    RETRIABLE = "Retriable"

class LastBackupStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Last backup operation status. Possible values: Healthy, Unhealthy.
    """

    INVALID = "Invalid"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    IR_PENDING = "IRPending"

class MabServerType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Server type of MAB container.
    """

    INVALID = "Invalid"
    UNKNOWN = "Unknown"
    IAAS_VM_CONTAINER = "IaasVMContainer"
    IAAS_VM_SERVICE_CONTAINER = "IaasVMServiceContainer"
    DPM_CONTAINER = "DPMContainer"
    AZURE_BACKUP_SERVER_CONTAINER = "AzureBackupServerContainer"
    MAB_CONTAINER = "MABContainer"
    CLUSTER = "Cluster"
    AZURE_SQL_CONTAINER = "AzureSqlContainer"
    WINDOWS = "Windows"
    V_CENTER = "VCenter"
    VM_APP_CONTAINER = "VMAppContainer"
    SQLAG_WORK_LOAD_CONTAINER = "SQLAGWorkLoadContainer"
    STORAGE_CONTAINER = "StorageContainer"
    GENERIC_CONTAINER = "GenericContainer"

class OperationStatusValues(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Operation status.
    """

    INVALID = "Invalid"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class OverwriteOptions(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Can Overwrite if Target DataBase already exists
    """

    INVALID = "Invalid"
    FAIL_ON_CONFLICT = "FailOnConflict"
    OVERWRITE = "Overwrite"

class ProtectedItemHealthStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Health status of the backup item, evaluated based on last heartbeat received
    """

    INVALID = "Invalid"
    HEALTHY = "Healthy"
    UNHEALTHY = "Unhealthy"
    NOT_REACHABLE = "NotReachable"
    IR_PENDING = "IRPending"

class ProtectedItemState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Backup state of the backed up item.
    """

    INVALID = "Invalid"
    IR_PENDING = "IRPending"
    PROTECTED = "Protected"
    PROTECTION_ERROR = "ProtectionError"
    PROTECTION_STOPPED = "ProtectionStopped"
    PROTECTION_PAUSED = "ProtectionPaused"

class ProtectionState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Backup state of this backup item.
    """

    INVALID = "Invalid"
    IR_PENDING = "IRPending"
    PROTECTED = "Protected"
    PROTECTION_ERROR = "ProtectionError"
    PROTECTION_STOPPED = "ProtectionStopped"
    PROTECTION_PAUSED = "ProtectionPaused"

class RecoveryMode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Defines whether the current recovery mode is file restore or database restore
    """

    INVALID = "Invalid"
    FILE_RECOVERY = "FileRecovery"
    WORKLOAD_RECOVERY = "WorkloadRecovery"

class RecoveryPointTierStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Recovery point tier status.
    """

    INVALID = "Invalid"
    VALID = "Valid"
    DISABLED = "Disabled"
    DELETED = "Deleted"
    REHYDRATED = "Rehydrated"

class RecoveryPointTierType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Recovery point tier type.
    """

    INVALID = "Invalid"
    INSTANT_RP = "InstantRP"
    HARDENED_RP = "HardenedRP"
    ARCHIVED_RP = "ArchivedRP"

class RecoveryType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of this recovery.
    """

    INVALID = "Invalid"
    ORIGINAL_LOCATION = "OriginalLocation"
    ALTERNATE_LOCATION = "AlternateLocation"
    RESTORE_DISKS = "RestoreDisks"
    OFFLINE = "Offline"

class ResourceHealthStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Resource Health Status
    """

    HEALTHY = "Healthy"
    TRANSIENT_DEGRADED = "TransientDegraded"
    PERSISTENT_DEGRADED = "PersistentDegraded"
    TRANSIENT_UNHEALTHY = "TransientUnhealthy"
    PERSISTENT_UNHEALTHY = "PersistentUnhealthy"
    INVALID = "Invalid"

class RestorePointQueryType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """RestorePoint type
    """

    INVALID = "Invalid"
    FULL = "Full"
    LOG = "Log"
    DIFFERENTIAL = "Differential"
    FULL_AND_DIFFERENTIAL = "FullAndDifferential"
    ALL = "All"
    INCREMENTAL = "Incremental"

class RestorePointType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of restore point
    """

    INVALID = "Invalid"
    FULL = "Full"
    LOG = "Log"
    DIFFERENTIAL = "Differential"
    INCREMENTAL = "Incremental"

class RestoreRequestType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Restore Type (FullShareRestore or ItemLevelRestore)
    """

    INVALID = "Invalid"
    FULL_SHARE_RESTORE = "FullShareRestore"
    ITEM_LEVEL_RESTORE = "ItemLevelRestore"

class SQLDataDirectoryType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of data directory mapping
    """

    INVALID = "Invalid"
    DATA = "Data"
    LOG = "Log"

class StorageType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Storage type
    """

    INVALID = "Invalid"
    GEO_REDUNDANT = "GeoRedundant"
    LOCALLY_REDUNDANT = "LocallyRedundant"
    ZONE_REDUNDANT = "ZoneRedundant"
    READ_ACCESS_GEO_ZONE_REDUNDANT = "ReadAccessGeoZoneRedundant"

class StorageTypeState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Locked or Unlocked. Once a machine is registered against a resource, the storageTypeState is
    always Locked.
    """

    INVALID = "Invalid"
    LOCKED = "Locked"
    UNLOCKED = "Unlocked"

class Type(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Backup management type for this container.
    """

    INVALID = "Invalid"
    BACKUP_PROTECTED_ITEM_COUNT_SUMMARY = "BackupProtectedItemCountSummary"
    BACKUP_PROTECTION_CONTAINER_COUNT_SUMMARY = "BackupProtectionContainerCountSummary"

class UsagesUnit(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Unit of the usage.
    """

    COUNT = "Count"
    BYTES = "Bytes"
    SECONDS = "Seconds"
    PERCENT = "Percent"
    COUNT_PER_SECOND = "CountPerSecond"
    BYTES_PER_SECOND = "BytesPerSecond"

class WorkloadType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Workload type of backup item.
    """

    INVALID = "Invalid"
    VM = "VM"
    FILE_FOLDER = "FileFolder"
    AZURE_SQL_DB = "AzureSqlDb"
    SQLDB = "SQLDB"
    EXCHANGE = "Exchange"
    SHAREPOINT = "Sharepoint"
    V_MWARE_VM = "VMwareVM"
    SYSTEM_STATE = "SystemState"
    CLIENT = "Client"
    GENERIC_DATA_SOURCE = "GenericDataSource"
    SQL_DATA_BASE = "SQLDataBase"
    AZURE_FILE_SHARE = "AzureFileShare"
    SAP_HANA_DATABASE = "SAPHanaDatabase"
    SAP_ASE_DATABASE = "SAPAseDatabase"
