# Copyright (c) Microsoft Corporation.  All rights reserved.

"""Runtime Constants.
"""


class MediaTypes:
    """Constants of media types.

    http://www.iana.org/assignments/media-types/media-types.xhtml
    """
    Any = '*/*'
    ImageJpeg = 'image/jpeg'
    ImagePng = 'image/png'
    JavaScript = 'application/x-javascript'
    Json = 'application/json'
    OctetStream = 'application/octet-stream'
    QueryJson = 'application/query+json'
    SQL = 'application/sql'
    TextHtml = 'text/html'
    TextPlain = 'text/plain'
    Xml = 'application/xml'