# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import FrontDoorManagementClientConfiguration
from .operations import NetworkExperimentProfilesOperations
from .operations import PreconfiguredEndpointsOperations
from .operations import ExperimentsOperations
from .operations import ReportsOperations
from .operations import FrontDoorNameAvailabilityOperations
from .operations import FrontDoorNameAvailabilityWithSubscriptionOperations
from .operations import FrontDoorsOperations
from .operations import FrontendEndpointsOperations
from .operations import EndpointsOperations
from .operations import RulesEnginesOperations
from .operations import PoliciesOperations
from .operations import ManagedRuleSetsOperations
from .. import models


class FrontDoorManagementClient(object):
    """FrontDoor Client.

    :ivar network_experiment_profiles: NetworkExperimentProfilesOperations operations
    :vartype network_experiment_profiles: azure.mgmt.frontdoor.aio.operations.NetworkExperimentProfilesOperations
    :ivar preconfigured_endpoints: PreconfiguredEndpointsOperations operations
    :vartype preconfigured_endpoints: azure.mgmt.frontdoor.aio.operations.PreconfiguredEndpointsOperations
    :ivar experiments: ExperimentsOperations operations
    :vartype experiments: azure.mgmt.frontdoor.aio.operations.ExperimentsOperations
    :ivar reports: ReportsOperations operations
    :vartype reports: azure.mgmt.frontdoor.aio.operations.ReportsOperations
    :ivar front_door_name_availability: FrontDoorNameAvailabilityOperations operations
    :vartype front_door_name_availability: azure.mgmt.frontdoor.aio.operations.FrontDoorNameAvailabilityOperations
    :ivar front_door_name_availability_with_subscription: FrontDoorNameAvailabilityWithSubscriptionOperations operations
    :vartype front_door_name_availability_with_subscription: azure.mgmt.frontdoor.aio.operations.FrontDoorNameAvailabilityWithSubscriptionOperations
    :ivar front_doors: FrontDoorsOperations operations
    :vartype front_doors: azure.mgmt.frontdoor.aio.operations.FrontDoorsOperations
    :ivar frontend_endpoints: FrontendEndpointsOperations operations
    :vartype frontend_endpoints: azure.mgmt.frontdoor.aio.operations.FrontendEndpointsOperations
    :ivar endpoints: EndpointsOperations operations
    :vartype endpoints: azure.mgmt.frontdoor.aio.operations.EndpointsOperations
    :ivar rules_engines: RulesEnginesOperations operations
    :vartype rules_engines: azure.mgmt.frontdoor.aio.operations.RulesEnginesOperations
    :ivar policies: PoliciesOperations operations
    :vartype policies: azure.mgmt.frontdoor.aio.operations.PoliciesOperations
    :ivar managed_rule_sets: ManagedRuleSetsOperations operations
    :vartype managed_rule_sets: azure.mgmt.frontdoor.aio.operations.ManagedRuleSetsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = FrontDoorManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.network_experiment_profiles = NetworkExperimentProfilesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.preconfigured_endpoints = PreconfiguredEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.experiments = ExperimentsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.reports = ReportsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.front_door_name_availability = FrontDoorNameAvailabilityOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.front_door_name_availability_with_subscription = FrontDoorNameAvailabilityWithSubscriptionOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.front_doors = FrontDoorsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.frontend_endpoints = FrontendEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.endpoints = EndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.rules_engines = RulesEnginesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.policies = PoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.managed_rule_sets = ManagedRuleSetsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "FrontDoorManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
