/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import py4j.Gateway;
import py4j.GatewayServer;
import py4j.JavaServer;
import py4j.Protocol;
import py4j.Py4JJavaServer;
import py4j.Py4JPythonClient;
import py4j.PythonClient;

public class ClientServer {
    private final int javaPort;
    private final InetAddress javaAddress;
    private final int pythonPort;
    private final InetAddress pythonAddress;
    private int listeningPort;
    private final int connectTimeout;
    private final int readTimeout;
    private final ServerSocketFactory sSocketFactory;
    private final SocketFactory socketFactory;
    private final Gateway gateway;
    private final JavaServer javaServer;
    private final PythonClient pythonClient;
    protected final Logger logger = Logger.getLogger(ClientServer.class.getName());

    public ClientServer(Object entryPoint) {
        this(25333, GatewayServer.defaultAddress(), 25334, GatewayServer.defaultAddress(), 0, 0, ServerSocketFactory.getDefault(), SocketFactory.getDefault(), entryPoint);
    }

    public ClientServer(int javaPort, InetAddress javaAddress, int pythonPort, InetAddress pythonAddress, int connectTimeout, int readTimeout, ServerSocketFactory sSocketFactory, SocketFactory socketFactory, Object entryPoint) {
        this.javaPort = javaPort;
        this.javaAddress = javaAddress;
        this.pythonPort = pythonPort;
        this.pythonAddress = pythonAddress;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.sSocketFactory = sSocketFactory;
        this.socketFactory = socketFactory;
        this.pythonClient = new PythonClient(null, null, pythonPort, pythonAddress, 30L, TimeUnit.SECONDS, SocketFactory.getDefault(), null);
        this.javaServer = new JavaServer(entryPoint, this.javaPort, this.connectTimeout, this.readTimeout, null, this.pythonClient);
        this.gateway = this.javaServer.getGateway();
        this.pythonClient.setGateway(this.gateway);
        this.pythonClient.setJavaServer(this.javaServer);
        this.gateway.startup();
    }

    public Py4JJavaServer getJavaServer() {
        return this.javaServer;
    }

    public Py4JPythonClient getPythonClient() {
        return this.pythonClient;
    }

    public void startServer(boolean fork) {
        this.javaServer.start(fork);
    }

    public void shutdown() {
        this.javaServer.shutdown(true);
    }

    public Object getPythonServerEntryPoint(Class[] interfacesToImplement) {
        Object proxy = Protocol.getPythonProxyHandler(this.gateway.getClass().getClassLoader(), interfacesToImplement, "t", this.gateway);
        return proxy;
    }
}

