# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MaxSizeCapability(Model):
    """The maximum size limits for a database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar limit: The maximum size of the database (see 'unit' for the units).
    :vartype limit: long
    :ivar unit: The units that the limit is expressed in. Possible values
     include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes'
    :vartype unit: str or ~azure.mgmt.sql.models.MaxSizeUnits
    :ivar status: The status of the maximum size capability. Possible values
     include: 'Visible', 'Available', 'Default', 'Disabled'
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    """

    _validation = {
        'limit': {'readonly': True},
        'unit': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'MaxSizeUnits'},
        'status': {'key': 'status', 'type': 'CapabilityStatus'},
    }

    def __init__(self):
        self.limit = None
        self.unit = None
        self.status = None
