# Copyright (c) 2020, Manfred Moitzi
# License: MIT License
# Scaled for $MEASUREMENT=1 (m, cm, mm, ...)
# Collected, extracted and scaled from various DXF files ...
ISO_PATTERN = {
    "ACAD_ISO02W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0]]],
    "ACAD_ISO03W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -18.0]]],
    "ACAD_ISO04W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 0.5, -3.0]]],
    "ACAD_ISO05W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 0.5, -3.0, 0.5, -3.0]]
    ],
    "ACAD_ISO06W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 0.5, -3.0, 0.5, -6.5]],
        [0.0, (0.0, 0.0), (0.0, 5.0), [-34.0, 0.5, -3.0]],
    ],
    "ACAD_ISO07W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [0.5, -3.0]]],
    "ACAD_ISO08W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 6.0, -3.0]]],
    "ACAD_ISO09W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 6.0, -3.0, 6.0, -3.0]]
    ],
    "ACAD_ISO10W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 0.5, -3.0]]],
    "ACAD_ISO11W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 12.0, -3.0, 0.5, -3.0]]
    ],
    "ACAD_ISO12W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 0.5, -3.0, 0.5, -3.0]]
    ],
    "ACAD_ISO13W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 12.0, -3.0, 0.5, -6.5]],
        [0.0, (0.0, 0.0), (0.0, 5.0), [-33.5, 0.5, -3.0]],
    ],
    "ACAD_ISO14W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 0.5, -3.0, 0.5, -6.5]],
        [0.0, (0.0, 0.0), (0.0, 5.0), [-22.0, 0.5, -3.0]],
    ],
    "ACAD_ISO15W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 12.0, -3.0, 0.5, -10.0]],
        [0.0, (0.0, 0.0), (0.0, 5.0), [-33.5, 0.5, -3.0, 0.5, -3.0]],
    ],
    "ANCHORLOCK": [
        [
            18.435,
            (-7.5301714395, -2.5100646395),
            (50.2011354351, 25.1006237677),
            [15.875, -63.5],
        ],
        [
            333.435,
            (-17.5703851665, -22.590536607),
            (25.1005788571, 2.25052e-05),
            [11.2253201325, -44.9012805935],
        ],
        [
            63.435,
            (-2.5100869915, 32.6307503975),
            (-2.23917e-05, 25.1005789423),
            [11.2253201325, -44.9012805935],
        ],
        [
            108.435,
            (2.5100198085, 17.5704075185),
            (-2.24201e-05, 25.1005789276),
            [15.875, -63.5],
        ],
    ],
    "ANGLE": [
        [0.0, (0.0, 0.0), (0.0, 13.97), [10.16, -3.81]],
        [90.0, (0.0, 0.0), (-13.97, 0.0), [10.16, -3.81]],
    ],
    "ANSI31": [[45.0, (0.0, 0.0), (-2.2450640303, 2.2450640303), []]],
    "ANSI32": [
        [45.0, (0.0, 0.0), (-6.7351920908, 6.7351920908), []],
        [45.0, (4.490128053, 0.0), (-6.7351920908, 6.7351920908), []],
    ],
    "ANSI33": [
        [45.0, (0.0, 0.0), (-4.4901280605, 4.4901280605), []],
        [45.0, (4.490128053, 0.0), (-4.4901280605, 4.4901280605), [3.175, -1.5875]],
    ],
    "ANSI34": [
        [45.0, (0.0, 0.0), (-13.4703841816, 13.4703841816), []],
        [45.0, (4.490128053, 0.0), (-13.4703841816, 13.4703841816), []],
        [45.0, (8.9802561314, 0.0), (-13.4703841816, 13.4703841816), []],
        [45.0, (13.4703841844, 0.0), (-13.4703841816, 13.4703841816), []],
    ],
    "ANSI35": [
        [45.0, (0.0, 0.0), (-4.4901280605, 4.4901280605), []],
        [
            45.0,
            (4.490128053, 0.0),
            (-4.4901280605, 4.4901280605),
            [7.9375, -1.5875, 0.0, -1.5875],
        ],
    ],
    "ANSI36": [
        [
            45.0,
            (0.0, 0.0),
            (1.6837980227, 6.1739260832),
            [7.9375, -1.5875, 0.0, -1.5875],
        ]
    ],
    "ANSI37": [
        [45.0, (0.0, 0.0), (-2.2450640303, 2.2450640303), []],
        [135.0, (0.0, 0.0), (-2.2450640303, -2.2450640303), []],
    ],
    "ANSI38": [
        [45.0, (0.0, 0.0), (-2.2450640303, 2.2450640303), []],
        [135.0, (0.0, 0.0), (-6.7351920908, 2.2450640303), [7.9375, -4.7625]],
    ],
    "AR-B816": [
        [0.0, (0.0, 0.0), (0.0, 203.2), []],
        [90.0, (0.0, 0.0), (-203.2, 203.2), [203.2, -203.2]],
    ],
    "AR-B816C": [
        [0.0, (0.0, 0.0), (203.2, 203.2), [396.875, -9.525]],
        [0.0, (-203.2, 9.525), (203.2, 203.2), [396.875, -9.525]],
        [90.0, (0.0, 0.0), (-203.2, 203.2), [-212.725, 193.675]],
        [90.0, (-9.525, 0.0), (-203.2, 203.2), [-212.725, 193.675]],
    ],
    "AR-B88": [
        [0.0, (0.0, 0.0), (0.0, 203.2), []],
        [90.0, (0.0, 0.0), (-101.6, 203.2), [203.2, -203.2]],
    ],
    "AR-BRELM": [
        [0.0, (0.0, 0.0), (0.0, 135.484), [193.675, -9.525]],
        [0.0, (0.0, 57.15), (0.0, 135.484), [193.675, -9.525]],
        [0.0, (50.8, 67.7418), (0.0, 135.484), [92.075, -9.525]],
        [0.0, (50.8, 124.892), (0.0, 135.484), [92.075, -9.525]],
        [90.0, (0.0, 0.0), (-203.2, 0.0), [57.15, -78.334]],
        [90.0, (-9.525, 0.0), (-203.2, 0.0), [57.15, -78.334]],
        [90.0, (50.8, 67.7418), (-101.6, 0.0), [57.15, -78.334]],
        [90.0, (41.275, 67.7418), (-101.6, 0.0), [57.15, -78.334]],
    ],
    "AR-BRSTD": [
        [0.0, (0.0, 0.0), (0.0, 67.7418), []],
        [90.0, (0.0, 0.0), (-101.6, 67.7418), [67.7418, -67.7418]],
    ],
    "AR-CONC": [
        [50.0, (0.0, 0.0), (182.184668996, -15.9390855389), [19.05, -209.55]],
        [355.0, (0.0, 0.0), (-35.243421425, 191.056845239), [15.24, -167.64058417]],
        [
            100.4514447,
            (15.182007, -1.3282535),
            (146.9412470904, 175.1177519122),
            [16.1900088, -178.0902446],
        ],
        [46.1842, (0.0, 50.8), (271.0790408921, -42.0423279327), [28.575, -314.325]],
        [
            96.63555761,
            (22.5899, 47.2965),
            (237.4041340515, 247.4261245977),
            [24.28502314, -267.13560816],
        ],
        [
            351.18415117,
            (0.0, 50.8),
            (237.404134065, 247.4261245855),
            [22.85996707, -251.45973192],
        ],
        [21.0, (25.4, 38.1), (151.6143912691, -102.2651981871), [19.05, -209.55]],
        [326.0, (25.4, 38.1), (61.8020283476, 184.1879661223), [15.24, -167.64]],
        [
            71.451445,
            (38.0345326, 29.5779001),
            (213.4164192787, 81.9227688859),
            [16.1900088, -178.0899376],
        ],
        [
            37.5,
            (0.0, 0.0),
            (3.0886032506, 84.5550388732),
            [0.0, -165.608, 0.0, -170.18, 0.0, -168.275],
        ],
        [
            7.5,
            (0.0, 0.0),
            (66.8196625103, 100.1805748181),
            [0.0, -97.028, 0.0, -161.798, 0.0, -64.135],
        ],
        [
            -32.5,
            (-56.642, 0.0),
            (135.5905951669, -5.7287439927),
            [0.0, -63.5, 0.0, -198.12, 0.0, -262.89],
        ],
        [
            -42.5,
            (-82.042, 0.0),
            (148.129181386, 25.4264910333),
            [0.0, -82.55, 0.0, -131.572, 0.0, -186.69],
        ],
    ],
    "AR-HBONE": [
        [45.0, (0.0, 0.0), (0.0, 143.6840979371), [304.8, -101.6]],
        [135.0, (71.842, 71.842), (0.0, 143.6840979371), [304.8, -101.6]],
    ],
    "AR-PARQ1": [
        [90.0, (0.0, 0.0), (-304.8, 304.8), [304.8, -304.8]],
        [90.0, (50.8, 0.0), (-304.8, 304.8), [304.8, -304.8]],
        [90.0, (101.6, 0.0), (-304.8, 304.8), [304.8, -304.8]],
        [90.0, (152.4, 0.0), (-304.8, 304.8), [304.8, -304.8]],
        [90.0, (203.2, 0.0), (-304.8, 304.8), [304.8, -304.8]],
        [90.0, (254.0, 0.0), (-304.8, 304.8), [304.8, -304.8]],
        [90.0, (304.8, 0.0), (-304.8, 304.8), [304.8, -304.8]],
        [0.0, (0.0, 304.8), (304.8, -304.8), [304.8, -304.8]],
        [0.0, (0.0, 355.6), (304.8, -304.8), [304.8, -304.8]],
        [0.0, (0.0, 406.4), (304.8, -304.8), [304.8, -304.8]],
        [0.0, (0.0, 457.2), (304.8, -304.8), [304.8, -304.8]],
        [0.0, (0.0, 508.0), (304.8, -304.8), [304.8, -304.8]],
        [0.0, (0.0, 558.8), (304.8, -304.8), [304.8, -304.8]],
        [0.0, (0.0, 609.6), (304.8, -304.8), [304.8, -304.8]],
    ],
    "AR-RROOF": [
        [0.0, (0.0, 0.0), (55.88, 25.4), [381.0, -50.8, 127.0, -25.4]],
        [0.0, (33.782, 12.7), (-25.4, 33.782), [76.2, -8.382, 152.4, -19.05]],
        [0.0, (12.7, 21.59), (132.08, 17.018), [203.2, -35.56, 101.6, -25.4]],
    ],
    "AR-RSHKE": [
        [0.0, (0.0, 0.0), (647.7, 304.8), [152.4, -127.0, 177.8, -76.2, 228.6, -101.6]],
        [0.0, (152.4, 12.7), (647.7, 304.8), [127.0, -482.6, 101.6, -152.4]],
        [0.0, (457.2, -19.05), (647.7, 304.8), [76.2, -787.4]],
        [90.0, (0.0, 0.0), (-215.9, 304.8), [292.1, -927.1]],
        [90.0, (152.4, 0.0), (-215.9, 304.8), [285.75, -933.45]],
        [90.0, (279.4, 0.0), (-215.9, 304.8), [266.7, -952.5]],
        [90.0, (457.2, -19.05), (-215.9, 304.8), [292.1, -927.1]],
        [90.0, (533.4, -19.05), (-215.9, 304.8), [292.1, -927.1]],
        [90.0, (762.0, 0.0), (-215.9, 304.8), [279.4, -939.8]],
    ],
    "AR-SAND": [
        [
            37.5,
            (0.0, 0.0),
            (-1.600031296, 48.9413237329),
            [0.0, -38.608, 0.0, -43.18, 0.0, -41.275],
        ],
        [
            7.5,
            (0.0, 0.0),
            (44.9523283138, 71.6825100568),
            [0.0, -20.828, 0.0, -34.798, 0.0, -13.335],
        ],
        [
            -32.5,
            (-31.242, 0.0),
            (79.0992370241, 0.1437184679),
            [0.0, -12.7, 0.0, -45.72, 0.0, -59.69],
        ],
        [
            -42.5,
            (-31.242, 0.0),
            (76.3556452472, 22.2929323257),
            [0.0, -6.35, 0.0, -29.972, 0.0, -34.29],
        ],
    ],
    "ASPHALT": [
        [0.0, (11.8968774, 4.6476158), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-11.464417, 8.075549), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-11.5913916, -4.5570648), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (3.1998666, -5.128387), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (8.7227918, -5.3188108), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (1.1684508, 11.1860838), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (10.5002838, 11.8208806), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-2.5134824, 5.4728618), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-0.5455412, 0.3944112), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-5.1162458, -1.827403), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-7.46506, 1.3466318), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (7.9610204, 0.9657334), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-0.2281428, 7.8850998), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-5.1797204, 11.4400076), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (6.3739776, 7.5677014), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-9.6234504, 4.9650142), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (0.2797048, -1.6369538), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (6.5644268, -11.2225074), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-9.306052, -10.9050836), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-2.7039316, -8.429371), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-7.972933, -7.984998), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (-12.7, 12.7), (0.0, 25.4), [25.4, 0.0]],
        [0.0, (-12.7, 9.525), (0.0, 25.4), [25.4, 0.0]],
        [0.0, (-12.7, 6.35), (0.0, 25.4), [25.4, 0.0]],
        [0.0, (-12.7, 3.175), (0.0, 25.4), [25.4, 0.0]],
        [0.0, (-12.7, 0.0), (0.0, 25.4), [25.4, 0.0]],
        [0.0, (-12.7, -3.175), (0.0, 25.4), [25.4, 0.0]],
        [0.0, (-12.7, -6.35), (0.0, 25.4), [25.4, 0.0]],
        [0.0, (-12.7, -9.525), (0.0, 25.4), [25.4, 0.0]],
    ],
    "BLOCKS": [
        [0.0, (0.0, 0.0), (0.0, 203.2), []],
        [90.0, (0.0, 0.0), (-203.2, 203.2), [203.2, -203.2]],
    ],
    "BOARD": [
        [0.0, (0.0, 1.016), (0.0, 2.54), []],
        [90.0, (0.0, 1.016), (-10.16, 10.16), [2.54, -35.56]],
        [90.0, (15.24, 6.096), (-10.16, 10.16), [2.54, -35.56]],
    ],
    "BOX": [
        [90.0, (0.0, 0.0), (-25.4, 0.0), []],
        [90.0, (6.35, 0.0), (-25.4, 0.0), []],
        [0.0, (0.0, 0.0), (0.0, 25.4), [-6.35, 6.35]],
        [0.0, (0.0, 6.35), (0.0, 25.4), [-6.35, 6.35]],
        [0.0, (0.0, 12.7), (0.0, 25.4), [6.35, -6.35]],
        [0.0, (0.0, 19.05), (0.0, 25.4), [6.35, -6.35]],
        [90.0, (12.7, 0.0), (-25.4, 0.0), [6.35, -6.35]],
        [90.0, (19.05, 0.0), (-25.4, 0.0), [6.35, -6.35]],
    ],
    "BRASS": [
        [0.0, (0.0, 0.0), (0.0, 6.35), []],
        [0.0, (0.0, 3.175), (0.0, 6.35), [3.175, -1.5875]],
    ],
    "BRICK": [
        [0.0, (0.0, 0.0), (0.0, 6.35), []],
        [90.0, (0.0, 0.0), (-12.7, 0.0), [6.35, -6.35]],
        [90.0, (6.35, 0.0), (-12.7, 0.0), [-6.35, 6.35]],
    ],
    "BRICK_DEMOLITION": [
        [45.0, (0.0, 0.0), (-5.3881536726, 5.3881536726), [2.54, -2.54]],
        [45.0, (1.796034, 0.0), (-5.3881536726, 5.3881536726), [2.54, -2.54]],
    ],
    "BRICK_EXISTING": [
        [45.0, (0.0, 0.0), (-7.1842048969, 7.1842048969), []],
        [45.0, (3.5920934, 0.0), (-7.1842048969, 7.1842048969), []],
    ],
    "BRICK_FLBOND": [
        [0.0, (0.0, 0.0), (38.1, 16.9333333291), [48.41875, -27.78125]],
        [0.0, (50.8, 0.0), (38.1, 16.9333333291), [23.01875, -53.18125]],
        [0.0, (0.0, 14.5520833291), (38.1, 16.9333333291), [48.41875, -27.78125]],
        [0.0, (50.8, 14.5520833291), (38.1, 16.9333333291), [23.01875, -53.18125]],
        [90.0, (0.0, 0.0), (-38.1, 16.9333333291), [14.5520833291, -19.3145833291]],
        [
            90.0,
            (48.41875, 0.0),
            (-38.1, 16.9333333291),
            [14.5520833291, -19.3145833291],
        ],
        [90.0, (50.8, 0.0), (-38.1, 16.9333333291), [14.5520833291, -19.3145833291]],
        [
            90.0,
            (73.81875, 0.0),
            (-38.1, 16.9333333291),
            [14.5520833291, -19.3145833291],
        ],
    ],
    "BRICK_INSULATING": [
        [45.0, (0.0, 0.0), (-6.2861792847, 6.2861792847), []],
        [0.0, (0.0, 0.0), (0.0, 2.54), [0.0, -2.54]],
    ],
    "BRICK_LWEIGHT": [
        [45.0, (0.0, 0.0), (-6.2861792847, 6.2861792847), []],
        [0.0, (0.0, 0.0), (0.79375, 1.5875), [0.0, -1.5875]],
    ],
    "BRICK_PAIRS": [
        [
            0.0,
            (0.0, 0.0),
            (50.8, 50.8),
            [48.41875, -2.38125, 23.01875, -2.38125, 23.01875, -2.38125],
        ],
        [0.0, (0.0, 23.01875), (50.8, 50.8), [48.41875, -53.18125]],
        [0.0, (0.0, 25.4), (50.8, 50.8), [48.41875, -53.18125]],
        [
            0.0,
            (0.0, 48.41875),
            (50.8, 50.8),
            [48.41875, -2.38125, 23.01875, -2.38125, 23.01875, -2.38125],
        ],
        [
            90.0,
            (0.0, 0.0),
            (-50.8, 50.8),
            [23.01875, -2.38125, 23.01875, -2.38125, 48.41875, -2.38125],
        ],
        [90.0, (23.01875, 50.8), (-50.8, 50.8), [48.41875, -53.18125]],
        [90.0, (25.4, 50.8), (-50.8, 50.8), [48.41875, -53.18125]],
        [
            90.0,
            (48.41875, 0.0),
            (-50.8, 50.8),
            [23.01875, -2.38125, 23.01875, -2.38125, 48.41875, -2.38125],
        ],
    ],
    "BRICK_STBOND": [
        [0.0, (0.0, 0.0), (0.0, 25.4), []],
        [90.0, (0.0, 0.0), (-50.8, 0.0), []],
    ],
    "BRICK_STRBOND": [
        [0.0, (0.0, 0.0), (0.0, 50.8), []],
        [90.0, (0.0, 0.0), (-101.6, 50.8), [50.8, -50.8]],
    ],
    "BRSTONE": [
        [0.0, (0.0, 0.0), (0.0, 8.382), []],
        [90.0, (22.86, 0.0), (-12.7, 8.382), [8.382, -8.382]],
        [90.0, (20.32, 0.0), (-12.7, 8.382), [8.382, -8.382]],
        [0.0, (22.86, 1.397), (12.7, 8.382), [-22.86, 2.54]],
        [0.0, (22.86, 2.794), (12.7, 8.382), [-22.86, 2.54]],
        [0.0, (22.86, 4.191), (12.7, 8.382), [-22.86, 2.54]],
        [0.0, (22.86, 5.588), (12.7, 8.382), [-22.86, 2.54]],
        [0.0, (22.86, 6.985), (12.7, 8.382), [-22.86, 2.54]],
    ],
    "BUTTERFLY": [
        [0.0, (-6.35, 0.0), (19.05, 19.05), [12.7, -25.4]],
        [0.0, (12.7, 6.35), (19.05, 19.05), [12.7, -25.4]],
        [90.0, (0.0, 0.0), (-19.05, 19.05), [25.4, -12.7]],
        [
            45.0,
            (6.35, 0.0),
            (-19.0500000129, 19.0500000129),
            [8.980256106, -17.960512212],
        ],
        [
            135.0,
            (-6.35, 0.0),
            (-19.0500000129, -19.0500000129),
            [8.980256106, -17.960512212],
        ],
    ],
    "CHECKER": [
        [0.0, (0.0, 0.0), (12.7, 12.7), [12.7, -12.7]],
        [90.0, (6.35, 6.35), (-12.7, 12.7), [12.7, -12.7]],
    ],
    "CLAY": [
        [0.0, (0.0, 0.0), (0.0, 4.7625), []],
        [0.0, (0.0, 0.79375), (0.0, 4.7625), []],
        [0.0, (0.0, 1.5875), (0.0, 4.7625), []],
        [0.0, (0.0, 3.175), (0.0, 4.7625), [4.7625, -3.175]],
    ],
    "CONCRETE1": [
        [0.0, (0.0, 0.0), (20.32, 20.32), [2.54, -17.78]],
        [90.0, (0.0, 0.0), (-20.32, 20.32), [2.54, -17.78]],
        [135.0, (2.54, 0.0), (-20.3199999659, 0.0), [3.592102544, -25.144717808]],
        [0.0, (2.54, 11.43), (20.32, 20.32), [2.54, -17.78]],
        [45.0, (3.81, 10.16), (0.0, 20.3199999659), [1.796050256, -26.940768064]],
        [135.0, (3.81, 10.16), (-20.3199999659, 0.0), [1.796050256, -26.940768064]],
        [0.0, (10.16, 16.51), (20.32, 20.32), [3.592102544, -16.727897456]],
        [45.0, (10.16, 16.51), (0.0, 20.3199999659), [2.54, -26.196820352]],
        [135.0, (13.752102544, 16.51), (-20.3199999659, 0.0), [2.54, -26.196820352]],
        [90.0, (13.97, 5.08), (-20.32, 20.32), [2.54, -17.78]],
        [45.0, (13.97, 5.08), (0.0, 20.3199999659), [1.796050256, -26.940768064]],
        [135.0, (15.24, 6.35), (-20.3199999659, 0.0), [1.796050256, -26.940768064]],
        [0.0, (2.54, 5.08), (20.32, 20.32), [1.27, -17.018]],
        [0.0, (17.78, 10.16), (20.32, 20.32), [1.27, -17.018]],
        [90.0, (11.43, 12.7), (-20.32, 20.32), [1.27, -17.018]],
        [135.0, (13.97, 1.27), (-20.3199999659, 0.0), [1.796050256, -26.940768064]],
        [135.0, (5.08, 15.24), (-20.3199999659, 0.0), [1.796050256, -26.940768064]],
        [45.0, (9.525, 6.6675), (0.0, 20.3199999659), [1.796050256, -26.940768064]],
        [90.0, (6.985, 2.54), (-20.32, 20.32), [0.3175, -20.0025]],
        [90.0, (7.9375, 11.1125), (-20.32, 20.32), [0.3175, -20.0025]],
        [90.0, (17.4625, 14.605), (-20.32, 20.32), [0.3175, -20.0025]],
        [90.0, (17.78, 3.81), (-20.32, 20.32), [0.3175, -20.0025]],
    ],
    "CONCRETE2": [
        [50.0, (0.0, 0.0), (14.5747269104, -1.2751233828), [1.524, -16.764]],
        [355.0, (0.0, 0.0), (-2.819427099, 15.2845441568), [1.2192, -13.4112]],
        [
            100.4514,
            (1.2145605376, -0.1062601888),
            (11.7553106364, 14.0094114947),
            [1.2952006608, -14.2472077158],
        ],
        [46.1842, (0.0, 4.064), (21.6863381081, -3.3633463712), [2.286, -25.146]],
        [
            96.6356,
            (1.8071946584, 3.7837200018),
            (18.9923461767, 19.7940751367),
            [1.9428010522, -21.37080816],
        ],
        [351.1842, (0.0, 4.064), (18.9923307251, 19.7940899708), [1.8288, -20.1168]],
        [21.0, (2.032, 3.048), (12.129151299, -8.1812158583), [1.524, -16.764]],
        [326.0, (2.032, 3.048), (4.9441675446, 14.7350489154), [1.2192, -13.4112]],
        [
            71.4514,
            (3.0427621746, 2.3662313661),
            (17.0733238128, 6.5538196931),
            [1.2952006608, -14.2472077158],
        ],
        [
            37.5,
            (0.0, 0.0),
            (0.24708826, 6.7644031099),
            [0.0, -13.24864, 0.0, -13.6144, 0.0, -13.462],
        ],
        [
            7.5,
            (0.0, 0.0),
            (5.3455730008, 8.0144459854),
            [0.0, -7.76224, 0.0, -12.94384, 0.0, -5.1308],
        ],
        [
            -32.5,
            (-4.53136, 0.0),
            (10.847271903, -0.4583149936),
            [0.0, -5.08, 0.0, -15.8496, 0.0, -21.0312],
        ],
        [
            -42.5,
            (-6.56336, 0.0),
            (11.850342961, 2.034133241),
            [0.0, -6.604, 0.0, -10.52576, 0.0, -14.9352],
        ],
    ],
    "CONCRETE3": [
        [
            82.88,
            (97.10721498, 59.2083144),
            (-0.0008534187, 16.9336313627),
            [0.03725418, -136.48436],
        ],
        [
            97.13,
            (97.10660538, 59.2448904),
            (-16.9431028479, 118.5322702695),
            [0.04934458, -136.4722696],
        ],
        [
            116.57,
            (97.09453022, 59.29154258),
            (-16.9342802744, 16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            135.0,
            (97.06356, 59.33695778),
            (-16.9331709419, 0.0),
            [0.05941822, -23.88770178],
        ],
        [
            172.88,
            (97.01943258, 59.3792564),
            (-118.5352255934, 16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            172.88,
            (96.9621632, 59.3875368),
            (-118.5352255934, 16.9224148061),
            [0.03852418, -136.48309],
        ],
        [
            187.13,
            (96.92463978, 59.38655382),
            (-118.5322702695, -16.9431028479),
            [0.05259578, -136.4690184],
        ],
        [
            225.0,
            (96.8702152, 59.3801708),
            (-0.0, -16.9331709419),
            [0.06072378, -23.88639622],
        ],
        [
            243.44,
            (96.82142942, 59.3422232),
            (0.0014916558, -16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            262.88,
            (96.79022298, 59.29440262),
            (0.0008534187, -16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            262.88,
            (96.78295858, 59.2425536),
            (0.0008534187, -16.9336313627),
            [0.03852418, -136.48309],
        ],
        [
            277.13,
            (96.78366978, 59.20499462),
            (16.9431028479, -118.5322702695),
            [0.0483108, -136.47330338],
        ],
        [
            296.57,
            (96.79555698, 59.1593432),
            (16.9342802744, -16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            315.0,
            (96.8265272, 59.11391022),
            (16.9331709419, -0.0),
            [0.05941822, -23.88770178],
        ],
        [
            352.88,
            (96.87065462, 59.07162938),
            (118.5352255934, -16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            7.13,
            (96.96544742, 59.0642964),
            (118.5322702695, 16.9431028479),
            [0.0521208, -136.46949338],
        ],
        [
            45.0,
            (97.0198212, 59.07066418),
            (0.0, 16.9331709419),
            [0.0608076, -23.8863124],
        ],
        [
            63.44,
            (97.06865778, 59.1086448),
            (-0.0014916558, 16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            82.88,
            (97.09986422, 59.15646538),
            (-0.0008534187, 16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            82.88,
            (87.67045458, 53.3422352),
            (-0.0008534187, 16.9336313627),
            [0.03725418, -136.48436],
        ],
        [
            97.13,
            (87.66984498, 53.37879342),
            (-16.9431028479, 118.5322702695),
            [0.04934458, -136.4722696],
        ],
        [
            116.57,
            (87.65776982, 53.4254456),
            (-16.9342802744, 16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            135.0,
            (87.6267996, 53.47087858),
            (-16.9331709419, 0.0),
            [0.05941822, -23.88770178],
        ],
        [
            172.88,
            (87.58267218, 53.51315942),
            (-118.5352255934, 16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            172.88,
            (87.5254028, 53.52143982),
            (-118.5352255934, 16.9224148061),
            [0.03852418, -136.48309],
        ],
        [
            187.13,
            (87.48787938, 53.52045938),
            (-118.5322702695, -16.9431028479),
            [0.05259578, -136.4690184],
        ],
        [
            225.0,
            (87.4334548, 53.51407382),
            (-0.0, -16.9331709419),
            [0.06072378, -23.88639622],
        ],
        [
            243.44,
            (87.38466902, 53.47612622),
            (0.0014916558, -16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            262.88,
            (87.35346258, 53.42830818),
            (0.0008534187, -16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            262.88,
            (87.34619818, 53.37645662),
            (0.0008534187, -16.9336313627),
            [0.03852418, -136.48309],
        ],
        [
            277.13,
            (87.34690938, 53.33890018),
            (16.9431028479, -118.5322702695),
            [0.0483108, -136.47330338],
        ],
        [
            296.57,
            (87.35879658, 53.29324622),
            (16.9342802744, -16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            315.0,
            (87.3897668, 53.24781578),
            (16.9331709419, -0.0),
            [0.05941822, -23.88770178],
        ],
        [
            352.88,
            (87.43389422, 53.2055324),
            (118.5352255934, -16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            7.13,
            (87.52868702, 53.19819942),
            (118.5322702695, 16.9431028479),
            [0.0521208, -136.46949338],
        ],
        [
            45.0,
            (87.5830608, 53.2045672),
            (0.0, 16.9331709419),
            [0.0608076, -23.8863124],
        ],
        [
            63.44,
            (87.63189738, 53.24254782),
            (-0.0014916558, 16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            82.88,
            (87.66310382, 53.29038618),
            (-0.0008534187, 16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            82.88,
            (93.68222818, 52.93331298),
            (-0.0008534187, 16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            63.44,
            (93.6510192, 52.8854924),
            (-0.0014916558, 16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            45.0,
            (93.60218262, 52.847494),
            (0.0, 16.9331709419),
            [0.0608076, -23.8863124],
        ],
        [
            7.13,
            (93.54781138, 52.84112622),
            (118.5322702695, 16.9431028479),
            [0.0521208, -136.46949338],
        ],
        [
            352.88,
            (93.45301858, 52.84847698),
            (118.5352255934, -16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            315.0,
            (93.40888862, 52.89075782),
            (16.9331709419, -0.0),
            [0.05941822, -23.88770178],
        ],
        [
            296.57,
            (93.3779184, 52.93617302),
            (16.9342802744, -16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            277.13,
            (93.3660312, 52.98182698),
            (16.9431028479, -118.5322702695),
            [0.0483108, -136.47330338],
        ],
        [
            262.88,
            (93.36532, 53.01938342),
            (0.0008534187, -16.9336313627),
            [0.03852418, -136.48309],
        ],
        [
            262.88,
            (93.3725844, 53.07125022),
            (0.0008534187, -16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            243.44,
            (93.40379338, 53.1190708),
            (0.0014916558, -16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            225.0,
            (93.45257662, 53.15700062),
            (-0.0, -16.9331709419),
            [0.06072378, -23.88639622],
        ],
        [
            187.13,
            (93.5070012, 53.16340142),
            (-118.5322702695, -16.9431028479),
            [0.05259578, -136.4690184],
        ],
        [
            172.88,
            (93.54452462, 53.16436662),
            (-118.5352255934, 16.9224148061),
            [0.03852418, -136.48309],
        ],
        [
            172.88,
            (93.601794, 53.15608622),
            (-118.5352255934, 16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            135.0,
            (93.64592142, 53.11380538),
            (-16.9331709419, 0.0),
            [0.05941822, -23.88770178],
        ],
        [
            116.57,
            (93.67689418, 53.0683724),
            (-16.9342802744, 16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            97.13,
            (93.6889668, 53.02172022),
            (-16.9431028479, 118.5322702695),
            [0.04934458, -136.4722696],
        ],
        [
            82.88,
            (93.6895764, 52.985162),
            (-0.0008534187, 16.9336313627),
            [0.03725418, -136.48436],
        ],
        [
            82.88,
            (89.09138138, 65.02255982),
            (-0.0008534187, 16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            63.44,
            (89.06015462, 64.97474178),
            (-0.0014916558, 16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            45.0,
            (89.01132058, 64.93675862),
            (0.0, 16.9331709419),
            [0.0608076, -23.8863124],
        ],
        [
            7.13,
            (88.95696458, 64.93039338),
            (118.5322702695, 16.9431028479),
            [0.0521208, -136.46949338],
        ],
        [
            352.88,
            (88.862154, 64.93772382),
            (118.5352255934, -16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            315.0,
            (88.81802658, 64.9800072),
            (16.9331709419, -0.0),
            [0.05941822, -23.88770178],
        ],
        [
            296.57,
            (88.78705382, 65.0254224),
            (16.9342802744, -16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            277.13,
            (88.7751844, 65.07107382),
            (16.9431028479, -118.5322702695),
            [0.0483108, -136.47330338],
        ],
        [
            262.88,
            (88.77445542, 65.10865058),
            (0.0008534187, -16.9336313627),
            [0.03852418, -136.48309],
        ],
        [
            262.88,
            (88.78171982, 65.1604996),
            (0.0008534187, -16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            243.44,
            (88.81294658, 65.20832018),
            (0.0014916558, -16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            225.0,
            (88.86171458, 65.24626778),
            (-0.0, -16.9331709419),
            [0.06072378, -23.88639622],
        ],
        [
            187.13,
            (88.9161544, 65.2526508),
            (-118.5322702695, -16.9431028479),
            [0.05259578, -136.4690184],
        ],
        [
            172.88,
            (88.95366258, 65.253616),
            (-118.5352255934, 16.9224148061),
            [0.03852418, -136.48309],
        ],
        [
            172.88,
            (89.0109472, 65.2453356),
            (-118.5352255934, 16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            135.0,
            (89.05507462, 65.20305222),
            (-16.9331709419, 0.0),
            [0.05941822, -23.88770178],
        ],
        [
            116.57,
            (89.08604738, 65.15763702),
            (-16.9342802744, 16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            97.13,
            (89.09810222, 65.11098738),
            (-16.9431028479, 118.5322702695),
            [0.04934458, -136.4722696],
        ],
        [
            82.88,
            (89.0987296, 65.07441138),
            (-0.0008534187, 16.9336313627),
            [0.03725418, -136.48436],
        ],
        [
            82.88,
            (88.11877982, 63.97348902),
            (-0.0008534187, 16.9336313627),
            [0.15551658, -136.3660976],
        ],
        [
            97.13,
            (88.11622458, 64.12612778),
            (-16.9431028479, 118.5322702695),
            [0.20597622, -136.31563542],
        ],
        [
            116.57,
            (88.06583098, 64.32089498),
            (-16.9342802744, 16.9313563251),
            [0.23506938, -37.62955898],
        ],
        [
            135.0,
            (87.93656022, 64.51053138),
            (-16.9331709419, 0.0),
            [0.24807418, -23.69904582],
        ],
        [
            172.88,
            (87.75230862, 64.6870436),
            (-118.5352255934, 16.9224148061),
            [0.24306022, -136.27855142],
        ],
        [
            172.88,
            (87.51319302, 64.72162062),
            (-118.5352255934, 16.9224148061),
            [0.16085058, -136.3607636],
        ],
        [
            187.13,
            (87.35657662, 64.71755662),
            (-118.5322702695, -16.9431028479),
            [0.21959062, -136.30202102],
        ],
        [
            225.0,
            (87.12934822, 64.69088662),
            (-0.0, -16.9331709419),
            [0.25350978, -23.69361022],
        ],
        [
            243.44,
            (86.92572658, 64.53249222),
            (0.0014916558, -16.9328188651),
            [0.23410418, -37.63052418],
        ],
        [
            262.88,
            (86.79542458, 64.33284822),
            (0.0008534187, -16.9336313627),
            [0.21999702, -136.30161462],
        ],
        [
            262.88,
            (86.76506142, 64.11637418),
            (0.0008534187, -16.9336313627),
            [0.16085058, -136.3607636],
        ],
        [
            277.13,
            (86.7680764, 63.95955458),
            (16.9431028479, -118.5322702695),
            [0.20170902, -136.31990262],
        ],
        [
            296.57,
            (86.81769022, 63.768986),
            (16.9342802744, -16.9313563251),
            [0.23506938, -37.62955898],
        ],
        [
            315.0,
            (86.94696098, 63.5793496),
            (16.9331709419, -0.0),
            [0.24807418, -23.69904582],
        ],
        [
            352.88,
            (87.13121258, 63.4028196),
            (118.5352255934, -16.9224148061),
            [0.24306022, -136.27855142],
        ],
        [
            7.13,
            (87.52695982, 63.37220498),
            (118.5322702695, 16.9431028479),
            [0.21760942, -136.30400222],
        ],
        [
            45.0,
            (87.75393422, 63.39877338),
            (0.0, 16.9331709419),
            [0.2538476, -23.6932724],
        ],
        [
            63.44,
            (87.95779462, 63.55737098),
            (-0.0014916558, 16.9328188651),
            [0.23410418, -37.63052418],
        ],
        [
            82.88,
            (88.0881144, 63.75701498),
            (-0.0008534187, 16.9336313627),
            [0.21999702, -136.30161462],
        ],
        [
            82.88,
            (87.3229648, 65.74639378),
            (-0.0008534187, 16.9336313627),
            [0.21999702, -136.30161462],
        ],
        [
            63.44,
            (87.1926628, 65.54674978),
            (-0.0014916558, 16.9328188651),
            [0.23410418, -37.63052418],
        ],
        [
            45.0,
            (86.98878462, 65.38815218),
            (0.0, 16.9331709419),
            [0.2538476, -23.6932724],
        ],
        [
            7.13,
            (86.76181022, 65.361566),
            (118.5322702695, 16.9431028479),
            [0.21760942, -136.30400222],
        ],
        [
            352.88,
            (86.36606298, 65.3921984),
            (118.5352255934, -16.9224148061),
            [0.24306022, -136.27855142],
        ],
        [
            315.0,
            (86.18182662, 65.56871062),
            (16.9331709419, -0.0),
            [0.24807418, -23.69904582],
        ],
        [
            296.57,
            (86.05254062, 65.75834702),
            (16.9342802744, -16.9313563251),
            [0.23506938, -37.62955898],
        ],
        [
            277.13,
            (86.00294458, 65.94893338),
            (16.9431028479, -118.5322702695),
            [0.20170902, -136.31990262],
        ],
        [
            262.88,
            (85.9999296, 66.1057352),
            (0.0008534187, -16.9336313627),
            [0.16085058, -136.3607636],
        ],
        [
            262.88,
            (86.03027498, 66.32222702),
            (0.0008534187, -16.9336313627),
            [0.21999702, -136.30161462],
        ],
        [
            243.44,
            (86.16057698, 66.52187102),
            (0.0014916558, -16.9328188651),
            [0.23410418, -37.63052418],
        ],
        [
            225.0,
            (86.36419862, 66.68025018),
            (-0.0, -16.9331709419),
            [0.25350978, -23.69361022],
        ],
        [
            187.13,
            (86.5914448, 66.70692018),
            (-118.5322702695, -16.9431028479),
            [0.21959062, -136.30202102],
        ],
        [
            172.88,
            (86.7480612, 66.71099942),
            (-118.5352255934, 16.9224148061),
            [0.16085058, -136.3607636],
        ],
        [
            172.88,
            (86.9871768, 66.6764224),
            (-118.5352255934, 16.9224148061),
            [0.24306022, -136.27855142],
        ],
        [
            135.0,
            (87.17141062, 66.4998924),
            (-16.9331709419, 0.0),
            [0.24807418, -23.69904582],
        ],
        [
            116.57,
            (87.30069662, 66.310256),
            (-16.9342802744, 16.9313563251),
            [0.23506938, -37.62955898],
        ],
        [
            97.13,
            (87.35107498, 66.1154888),
            (-16.9431028479, 118.5322702695),
            [0.20597622, -136.31563542],
        ],
        [
            82.88,
            (87.353648, 65.96285258),
            (-0.0008534187, 16.9336313627),
            [0.15551658, -136.3660976],
        ],
        [
            82.88,
            (94.74125578, 62.99714858),
            (-0.0008534187, 16.9336313627),
            [0.52391818, -135.997696],
        ],
        [
            63.44,
            (94.43093382, 62.52167582),
            (-0.0014916558, 16.9328188651),
            [0.55751222, -37.3071136],
        ],
        [
            45.0,
            (93.94542298, 62.14397782),
            (0.0, 16.9331709419),
            [0.60453778, -23.34258222],
        ],
        [
            7.13,
            (93.40487542, 62.08068102),
            (118.5322702695, 16.9431028479),
            [0.51824382, -136.00336782],
        ],
        [
            352.88,
            (92.46236778, 62.15361458),
            (118.5352255934, -16.9224148061),
            [0.578866, -135.94274818],
        ],
        [
            315.0,
            (92.0235904, 62.5740176),
            (16.9331709419, -0.0),
            [0.59077098, -23.35634902],
        ],
        [
            296.57,
            (91.71570938, 63.0256296),
            (16.9342802744, -16.9313563251),
            [0.559816, -37.30480982],
        ],
        [
            277.13,
            (91.5975816, 63.47950982),
            (16.9431028479, -118.5322702695),
            [0.4803648, -136.04124938],
        ],
        [
            262.88,
            (91.59040102, 63.85294062),
            (0.0008534187, -16.9336313627),
            [0.38306502, -136.13854662],
        ],
        [
            262.88,
            (91.66267418, 64.36850982),
            (0.0008534187, -16.9336313627),
            [0.52391818, -135.997696],
        ],
        [
            243.44,
            (91.97301138, 64.84398258),
            (0.0014916558, -16.9328188651),
            [0.55751222, -37.3071136],
        ],
        [
            225.0,
            (92.4579304, 65.22117258),
            (-0.0, -16.9331709419),
            [0.603758, -23.343362],
        ],
        [
            187.13,
            (92.99912058, 65.28468782),
            (-118.5322702695, -16.9431028479),
            [0.52296822, -135.99864342],
        ],
        [
            172.88,
            (93.37209418, 65.29439062),
            (-118.5352255934, 16.9224148061),
            [0.38306502, -136.13854662],
        ],
        [
            172.88,
            (93.94156218, 65.21204382),
            (-118.5352255934, 16.9224148061),
            [0.578866, -135.94274818],
        ],
        [
            135.0,
            (94.38033702, 64.7916408),
            (-16.9331709419, 0.0),
            [0.59077098, -23.35634902],
        ],
        [
            116.57,
            (94.68822058, 64.3400288),
            (-16.9342802744, 16.9313563251),
            [0.559816, -37.30480982],
        ],
        [
            97.13,
            (94.80822542, 63.876174),
            (-16.9431028479, 118.5322702695),
            [0.49054258, -136.0310716],
        ],
        [
            82.88,
            (94.81432142, 63.51266698),
            (-0.0008534187, 16.9336313627),
            [0.37036502, -136.15124662],
        ],
        [
            82.88,
            (99.5581956, 54.0248856),
            (-0.0008534187, 16.9336313627),
            [0.37036502, -136.15124662],
        ],
        [
            97.13,
            (99.5520996, 54.3884104),
            (-16.9431028479, 118.5322702695),
            [0.49054258, -136.0310716],
        ],
        [
            116.57,
            (99.43211, 54.8522652),
            (-16.9342802744, 16.9313563251),
            [0.559816, -37.30480982],
        ],
        [
            135.0,
            (99.12422898, 55.3038772),
            (-16.9331709419, 0.0),
            [0.59077098, -23.35634902],
        ],
        [
            172.88,
            (98.6854516, 55.72428022),
            (-118.5352255934, 16.9224148061),
            [0.578866, -135.94274818],
        ],
        [
            172.88,
            (98.1159836, 55.80661178),
            (-118.5352255934, 16.9224148061),
            [0.38306502, -136.13854662],
        ],
        [
            187.13,
            (97.74301, 55.79692422),
            (-118.5322702695, -16.9431028479),
            [0.52296822, -135.99864342],
        ],
        [
            225.0,
            (97.20181982, 55.73340898),
            (-0.0, -16.9331709419),
            [0.603758, -23.343362],
        ],
        [
            243.44,
            (96.7169008, 55.3562012),
            (0.0014916558, -16.9328188651),
            [0.55751222, -37.3071136],
        ],
        [
            262.88,
            (96.4065636, 54.88073098),
            (0.0008534187, -16.9336313627),
            [0.52391818, -135.997696],
        ],
        [
            262.88,
            (96.33429298, 54.36517702),
            (0.0008534187, -16.9336313627),
            [0.38306502, -136.13854662],
        ],
        [
            277.13,
            (96.34147102, 53.99174622),
            (16.9431028479, -118.5322702695),
            [0.4803648, -136.04124938],
        ],
        [
            296.57,
            (96.4595988, 53.53784822),
            (16.9342802744, -16.9313563251),
            [0.559816, -37.30480982],
        ],
        [
            315.0,
            (96.76747982, 53.08623622),
            (16.9331709419, -0.0),
            [0.59077098, -23.35634902],
        ],
        [
            352.88,
            (97.2062572, 52.6658332),
            (118.5352255934, -16.9224148061),
            [0.578866, -135.94274818],
        ],
        [
            7.13,
            (98.1487496, 52.59291742),
            (118.5322702695, 16.9431028479),
            [0.51824382, -136.00336782],
        ],
        [
            45.0,
            (98.68929462, 52.65619898),
            (0.0, 16.9331709419),
            [0.60453778, -23.34258222],
        ],
        [
            63.44,
            (99.174808, 53.03391222),
            (-0.0014916558, 16.9328188651),
            [0.55751222, -37.3071136],
        ],
        [
            82.88,
            (99.4851452, 53.50938498),
            (-0.0008534187, 16.9336313627),
            [0.52391818, -135.997696],
        ],
        [
            82.88,
            (100.58544018, 60.18634902),
            (-0.0008534187, 16.9336313627),
            [0.21999702, -136.30161462],
        ],
        [
            63.44,
            (100.4551204, 59.98670502),
            (-0.0014916558, 16.9328188651),
            [0.23410418, -37.63052418],
        ],
        [
            45.0,
            (100.25126, 59.82810742),
            (0.0, 16.9331709419),
            [0.2538476, -23.6932724],
        ],
        [
            7.13,
            (100.0242856, 59.80153902),
            (118.5322702695, 16.9431028479),
            [0.21760942, -136.30400222],
        ],
        [
            352.88,
            (99.62853582, 59.83215618),
            (118.5352255934, -16.9224148061),
            [0.24306022, -136.27855142],
        ],
        [
            315.0,
            (99.444302, 60.00868618),
            (16.9331709419, -0.0),
            [0.24807418, -23.69904582],
        ],
        [
            296.57,
            (99.315016, 60.1983048),
            (16.9342802744, -16.9313563251),
            [0.23506938, -37.62955898],
        ],
        [
            277.13,
            (99.26541742, 60.38888862),
            (16.9431028479, -118.5322702695),
            [0.20170902, -136.31990262],
        ],
        [
            262.88,
            (99.26240498, 60.54570822),
            (0.0008534187, -16.9336313627),
            [0.16085058, -136.3607636],
        ],
        [
            262.88,
            (99.29274782, 60.7621848),
            (0.0008534187, -16.9336313627),
            [0.21999702, -136.30161462],
        ],
        [
            243.44,
            (99.42304982, 60.9618288),
            (0.0014916558, -16.9328188651),
            [0.23410418, -37.63052418],
        ],
        [
            225.0,
            (99.626674, 61.1202232),
            (-0.0, -16.9331709419),
            [0.25350978, -23.69361022],
        ],
        [
            187.13,
            (99.85392018, 61.1468932),
            (-118.5322702695, -16.9431028479),
            [0.21959062, -136.30202102],
        ],
        [
            172.88,
            (100.01053658, 61.1509572),
            (-118.5352255934, 16.9224148061),
            [0.16085058, -136.3607636],
        ],
        [
            172.88,
            (100.24965218, 61.11638018),
            (-118.5352255934, 16.9224148061),
            [0.24306022, -136.27855142],
        ],
        [
            135.0,
            (100.433886, 60.93986542),
            (-16.9331709419, 0.0),
            [0.24807418, -23.69904582],
        ],
        [
            116.57,
            (100.563172, 60.75022902),
            (-16.9342802744, 16.9313563251),
            [0.23506938, -37.62955898],
        ],
        [
            97.13,
            (100.61354782, 60.55544658),
            (-16.9431028479, 118.5322702695),
            [0.20597622, -136.31563542],
        ],
        [
            82.88,
            (100.6161056, 60.40280782),
            (-0.0008534187, 16.9336313627),
            [0.15551658, -136.3660976],
        ],
        [
            82.88,
            (97.50794062, 65.78770942),
            (-0.0008534187, 16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            63.44,
            (97.47673418, 65.73989138),
            (-0.0014916558, 16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            45.0,
            (97.4278976, 65.70189298),
            (0.0, 16.9331709419),
            [0.0608076, -23.8863124],
        ],
        [
            7.13,
            (97.37352382, 65.6955252),
            (118.5322702695, 16.9431028479),
            [0.0521208, -136.46949338],
        ],
        [
            352.88,
            (97.27873102, 65.70285818),
            (118.5352255934, -16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            315.0,
            (97.2346036, 65.7451568),
            (16.9331709419, -0.0),
            [0.05941822, -23.88770178],
        ],
        [
            296.57,
            (97.20363338, 65.790572),
            (16.9342802744, -16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            277.13,
            (97.19174618, 65.83622342),
            (16.9431028479, -118.5322702695),
            [0.0483108, -136.47330338],
        ],
        [
            262.88,
            (97.19103498, 65.8737824),
            (0.0008534187, -16.9336313627),
            [0.03852418, -136.48309],
        ],
        [
            262.88,
            (97.19829938, 65.9256492),
            (0.0008534187, -16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            243.44,
            (97.22950582, 65.97346978),
            (0.0014916558, -16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            225.0,
            (97.2782916, 66.0113996),
            (-0.0, -16.9331709419),
            [0.06072378, -23.88639622],
        ],
        [
            187.13,
            (97.33271618, 66.01778262),
            (-118.5322702695, -16.9431028479),
            [0.05259578, -136.4690184],
        ],
        [
            172.88,
            (97.3702396, 66.0187656),
            (-118.5352255934, 16.9224148061),
            [0.03852418, -136.48309],
        ],
        [
            172.88,
            (97.42750898, 66.0104852),
            (-118.5352255934, 16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            135.0,
            (97.4716364, 65.96820182),
            (-16.9331709419, 0.0),
            [0.05941822, -23.88770178],
        ],
        [
            116.57,
            (97.50260662, 65.92277138),
            (-16.9342802744, 16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            97.13,
            (97.51468178, 65.8761192),
            (-16.9431028479, 118.5322702695),
            [0.04934458, -136.4722696],
        ],
        [
            82.88,
            (97.51529138, 65.83956098),
            (-0.0008534187, 16.9336313627),
            [0.03725418, -136.48436],
        ],
        [
            82.88,
            (98.2182948, 64.2727696),
            (-0.0008534187, 16.9336313627),
            [0.15922498, -136.3623892],
        ],
        [
            63.44,
            (98.12399222, 64.12827662),
            (-0.0014916558, 16.9328188651),
            [0.16943578, -37.69519258],
        ],
        [
            45.0,
            (97.97641822, 64.01346862),
            (0.0, 16.9331709419),
            [0.18372582, -23.76339418],
        ],
        [
            7.13,
            (97.8121488, 63.99425098),
            (118.5322702695, 16.9431028479),
            [0.15749778, -136.3641164],
        ],
        [
            352.88,
            (97.52570538, 64.01639978),
            (118.5352255934, -16.9224148061),
            [0.17593818, -136.345676],
        ],
        [
            315.0,
            (97.3923376, 64.14417702),
            (16.9331709419, -0.0),
            [0.17954498, -23.76757502],
        ],
        [
            296.57,
            (97.298764, 64.28142338),
            (16.9342802744, -16.9313563251),
            [0.17014698, -37.69448138],
        ],
        [
            277.13,
            (97.26286618, 64.4193784),
            (16.9431028479, -118.5322702695),
            [0.1459992, -136.37561498],
        ],
        [
            262.88,
            (97.26069702, 64.5328656),
            (0.0008534187, -16.9336313627),
            [0.11641582, -136.40519582],
        ],
        [
            262.88,
            (97.2826604, 64.68956582),
            (0.0008534187, -16.9336313627),
            [0.15922498, -136.3623892],
        ],
        [
            243.44,
            (97.37697822, 64.8340588),
            (0.0014916558, -16.9328188651),
            [0.16943578, -37.69519258],
        ],
        [
            225.0,
            (97.52434902, 64.94869662),
            (-0.0, -16.9331709419),
            [0.1834896, -23.7636304],
        ],
        [
            187.13,
            (97.68882418, 64.96800062),
            (-118.5322702695, -16.9431028479),
            [0.15893542, -136.36267622],
        ],
        [
            172.88,
            (97.80217422, 64.9709648),
            (-118.5352255934, 16.9224148061),
            [0.11641582, -136.40519582],
        ],
        [
            172.88,
            (97.97524982, 64.94593818),
            (-118.5352255934, 16.9224148061),
            [0.17593818, -136.345676],
        ],
        [
            135.0,
            (98.1086176, 64.8181584),
            (-16.9331709419, 0.0),
            [0.17954498, -23.76757502],
        ],
        [
            116.57,
            (98.2021912, 64.68091458),
            (-16.9342802744, 16.9313563251),
            [0.17014698, -37.69448138],
        ],
        [
            97.13,
            (98.23864782, 64.5399268),
            (-16.9431028479, 118.5322702695),
            [0.14908022, -136.37253142],
        ],
        [
            82.88,
            (98.24051218, 64.42945458),
            (-0.0008534187, 16.9336313627),
            [0.11255502, -136.40905662],
        ],
        [
            82.88,
            (94.03588, 58.51547098),
            (-0.0008534187, 16.9336313627),
            [0.15551658, -136.3660976],
        ],
        [
            97.13,
            (94.03332222, 58.6681072),
            (-16.9431028479, 118.5322702695),
            [0.20597622, -136.31563542],
        ],
        [
            116.57,
            (93.9829464, 58.8628744),
            (-16.9342802744, 16.9313563251),
            [0.23506938, -37.62955898],
        ],
        [
            135.0,
            (93.8536604, 59.0525108),
            (-16.9331709419, 0.0),
            [0.24807418, -23.69904582],
        ],
        [
            172.88,
            (93.66942658, 59.2290408),
            (-118.5352255934, 16.9224148061),
            [0.24306022, -136.27855142],
        ],
        [
            172.88,
            (93.4302932, 59.26360258),
            (-118.5352255934, 16.9224148061),
            [0.16085058, -136.3607636],
        ],
        [
            187.13,
            (93.27369458, 59.25953858),
            (-118.5322702695, -16.9431028479),
            [0.21959062, -136.30202102],
        ],
        [
            225.0,
            (93.0464484, 59.23286858),
            (-0.0, -16.9331709419),
            [0.25350978, -23.69361022],
        ],
        [
            243.44,
            (92.84282422, 59.07447418),
            (0.0014916558, -16.9328188651),
            [0.23410418, -37.63052418],
        ],
        [
            262.88,
            (92.71252222, 58.87483018),
            (0.0008534187, -16.9336313627),
            [0.21999702, -136.30161462],
        ],
        [
            262.88,
            (92.68217938, 58.6583536),
            (0.0008534187, -16.9336313627),
            [0.16085058, -136.3607636],
        ],
        [
            277.13,
            (92.68519182, 58.50155178),
            (16.9431028479, -118.5322702695),
            [0.20170902, -136.31990262],
        ],
        [
            296.57,
            (92.7347904, 58.31096542),
            (16.9342802744, -16.9313563251),
            [0.23506938, -37.62955898],
        ],
        [
            315.0,
            (92.86405862, 58.12132902),
            (16.9331709419, -0.0),
            [0.24807418, -23.69904582],
        ],
        [
            352.88,
            (93.04831022, 57.94479902),
            (118.5352255934, -16.9224148061),
            [0.24306022, -136.27855142],
        ],
        [
            7.13,
            (93.44406, 57.9141844),
            (118.5322702695, 16.9431028479),
            [0.21760942, -136.30400222],
        ],
        [
            45.0,
            (93.6710344, 57.9407528),
            (0.0, 16.9331709419),
            [0.2538476, -23.6932724],
        ],
        [
            63.44,
            (93.8748948, 58.0993504),
            (-0.0014916558, 16.9328188651),
            [0.23410418, -37.63052418],
        ],
        [
            82.88,
            (94.00521458, 58.29901218),
            (-0.0008534187, 16.9336313627),
            [0.21999702, -136.30161462],
        ],
        [
            82.88,
            (90.7421096, 59.22648302),
            (-0.0008534187, 16.9336313627),
            [0.11255502, -136.40905662],
        ],
        [
            97.13,
            (90.74024778, 59.33695778),
            (-16.9431028479, 118.5322702695),
            [0.14908022, -136.37253142],
        ],
        [
            116.57,
            (90.70378862, 59.47794302),
            (-16.9342802744, 16.9313563251),
            [0.17014698, -37.69448138],
        ],
        [
            135.0,
            (90.61021502, 59.61518938),
            (-16.9331709419, 0.0),
            [0.17954498, -23.76757502],
        ],
        [
            172.88,
            (90.47686502, 59.74296662),
            (-118.5352255934, 16.9224148061),
            [0.17593818, -136.345676],
        ],
        [
            172.88,
            (90.30378942, 59.767978),
            (-118.5352255934, 16.9224148061),
            [0.11641582, -136.40519582],
        ],
        [
            187.13,
            (90.1904216, 59.7650316),
            (-118.5322702695, -16.9431028479),
            [0.15893542, -136.36267622],
        ],
        [
            225.0,
            (90.02594898, 59.7457276),
            (-0.0, -16.9331709419),
            [0.1834896, -23.7636304],
        ],
        [
            243.44,
            (89.87857818, 59.63108978),
            (0.0014916558, -16.9328188651),
            [0.16943578, -37.69519258],
        ],
        [
            262.88,
            (89.78425782, 59.4865968),
            (0.0008534187, -16.9336313627),
            [0.15922498, -136.3623892],
        ],
        [
            262.88,
            (89.76229698, 59.32989658),
            (0.0008534187, -16.9336313627),
            [0.11641582, -136.40519582],
        ],
        [
            277.13,
            (89.7644636, 59.21640938),
            (16.9431028479, -118.5322702695),
            [0.1459992, -136.37561498],
        ],
        [
            296.57,
            (89.8003792, 59.07845182),
            (16.9342802744, -16.9313563251),
            [0.17014698, -37.69448138],
        ],
        [
            315.0,
            (89.8939528, 58.941208),
            (16.9331709419, -0.0),
            [0.17954498, -23.76757502],
        ],
        [
            352.88,
            (90.0273028, 58.81342822),
            (118.5352255934, -16.9224148061),
            [0.17593818, -136.345676],
        ],
        [
            7.13,
            (90.31374622, 58.79126418),
            (118.5322702695, 16.9431028479),
            [0.15749778, -136.3641164],
        ],
        [
            45.0,
            (90.47803342, 58.8104996),
            (0.0, 16.9331709419),
            [0.18372582, -23.76339418],
        ],
        [
            63.44,
            (90.62559218, 58.9253076),
            (-0.0014916558, 16.9328188651),
            [0.16943578, -37.69519258],
        ],
        [
            82.88,
            (90.71991, 59.06980058),
            (-0.0008534187, 16.9336313627),
            [0.15922498, -136.3623892],
        ],
        [
            82.88,
            (88.04749218, 58.09938342),
            (-0.0008534187, 16.9336313627),
            [0.21413978, -136.3074744],
        ],
        [
            97.13,
            (88.0439692, 58.30954302),
            (-16.9431028479, 118.5322702695),
            [0.28359862, -136.23801302],
        ],
        [
            116.57,
            (87.97459418, 58.57771622),
            (-16.9342802744, 16.9313563251),
            [0.32366458, -37.54096378],
        ],
        [
            135.0,
            (87.79659098, 58.83882822),
            (-16.9331709419, 0.0),
            [0.34156142, -23.60555858],
        ],
        [
            172.88,
            (87.54291102, 59.0818732),
            (-118.5352255934, 16.9224148061),
            [0.3346704, -136.18694378],
        ],
        [
            172.88,
            (87.21367622, 59.12949058),
            (-118.5352255934, 16.9224148061),
            [0.22147022, -136.30014142],
        ],
        [
            187.13,
            (86.998048, 59.1238848),
            (-118.5322702695, -16.9431028479),
            [0.3023616, -136.21925258],
        ],
        [
            225.0,
            (86.68515302, 59.0871564),
            (-0.0, -16.9331709419),
            [0.34906458, -23.59805542],
        ],
        [
            243.44,
            (86.40478782, 58.869072),
            (0.0014916558, -16.9328188651),
            [0.322326, -37.54229982],
        ],
        [
            262.88,
            (86.22538, 58.59417542),
            (0.0008534187, -16.9336313627),
            [0.30290262, -136.21870902],
        ],
        [
            262.88,
            (86.18358938, 58.29611658),
            (0.0008534187, -16.9336313627),
            [0.22147022, -136.30014142],
        ],
        [
            277.13,
            (86.1877372, 58.08021658),
            (16.9431028479, -118.5322702695),
            [0.2777236, -136.24389058],
        ],
        [
            296.57,
            (86.25603018, 57.81779902),
            (16.9342802744, -16.9313563251),
            [0.32366458, -37.54096378],
        ],
        [
            315.0,
            (86.43403338, 57.5567048),
            (16.9331709419, -0.0),
            [0.34156142, -23.60555858],
        ],
        [
            352.88,
            (86.6877108, 57.31364458),
            (118.5352255934, -16.9224148061),
            [0.3346704, -136.18694378],
        ],
        [
            7.13,
            (87.23262462, 57.27148058),
            (118.5322702695, 16.9431028479),
            [0.2996184, -136.22199578],
        ],
        [
            45.0,
            (87.54514622, 57.30807182),
            (0.0, 16.9331709419),
            [0.349504, -23.597616],
        ],
        [
            63.44,
            (87.825834, 57.52644578),
            (-0.0014916558, 16.9328188651),
            [0.322326, -37.54229982],
        ],
        [
            82.88,
            (88.0052596, 57.80133982),
            (-0.0008534187, 16.9336313627),
            [0.30290262, -136.21870902],
        ],
        [
            82.88,
            (90.0168888, 60.63658942),
            (-0.0008534187, 16.9336313627),
            [0.03725418, -136.48436],
        ],
        [
            97.13,
            (90.0162792, 60.67315018),
            (-16.9431028479, 118.5322702695),
            [0.04934458, -136.4722696],
        ],
        [
            116.57,
            (90.00420658, 60.71979982),
            (-16.9342802744, 16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            135.0,
            (89.9732516, 60.7652328),
            (-16.9331709419, 0.0),
            [0.05941822, -23.88770178],
        ],
        [
            172.88,
            (89.9291064, 60.80751618),
            (-118.5352255934, 16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            172.88,
            (89.87183702, 60.81579658),
            (-118.5352255934, 16.9224148061),
            [0.03852418, -136.48309],
        ],
        [
            187.13,
            (89.8343136, 60.8148136),
            (-118.5322702695, -16.9431028479),
            [0.05259578, -136.4690184],
        ],
        [
            225.0,
            (89.77988902, 60.80843058),
            (-0.0, -16.9331709419),
            [0.06072378, -23.88639622],
        ],
        [
            243.44,
            (89.73110578, 60.77049822),
            (0.0014916558, -16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            262.88,
            (89.6998968, 60.7226624),
            (0.0008534187, -16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            262.88,
            (89.6926324, 60.67081338),
            (0.0008534187, -16.9336313627),
            [0.03852418, -136.48309],
        ],
        [
            277.13,
            (89.6933436, 60.6332544),
            (16.9431028479, -118.5322702695),
            [0.0483108, -136.47330338],
        ],
        [
            296.57,
            (89.7052308, 60.58760298),
            (16.9342802744, -16.9313563251),
            [0.05630418, -37.80832418],
        ],
        [
            315.0,
            (89.73620102, 60.54218778),
            (16.9331709419, -0.0),
            [0.05941822, -23.88770178],
        ],
        [
            352.88,
            (89.78033098, 60.49988662),
            (118.5352255934, -16.9224148061),
            [0.0582168, -136.46339738],
        ],
        [
            7.13,
            (89.87512378, 60.49255618),
            (118.5322702695, 16.9431028479),
            [0.0521208, -136.46949338],
        ],
        [
            45.0,
            (89.92949502, 60.49892142),
            (0.0, 16.9331709419),
            [0.0608076, -23.8863124],
        ],
        [
            63.44,
            (89.9783316, 60.53691982),
            (-0.0014916558, 16.9328188651),
            [0.0560832, -37.80854262],
        ],
        [
            82.88,
            (90.00954058, 60.5847404),
            (-0.0008534187, 16.9336313627),
            [0.05269738, -136.4689168],
        ],
        [
            82.88,
            (91.272614, 55.4477428),
            (-0.0008534187, 16.9336313627),
            [0.52391818, -135.997696],
        ],
        [
            63.44,
            (90.9622768, 54.97227258),
            (-0.0014916558, 16.9328188651),
            [0.55751222, -37.3071136],
        ],
        [
            45.0,
            (90.47676342, 54.5945568),
            (0.0, 16.9331709419),
            [0.60453778, -23.34258222],
        ],
        [
            7.13,
            (89.9362184, 54.53127778),
            (118.5322702695, 16.9431028479),
            [0.51824382, -136.00336782],
        ],
        [
            352.88,
            (88.993726, 54.6042088),
            (118.5352255934, -16.9224148061),
            [0.578866, -135.94274818],
        ],
        [
            315.0,
            (88.55494862, 55.02461182),
            (16.9331709419, -0.0),
            [0.59077098, -23.35634902],
        ],
        [
            296.57,
            (88.2470676, 55.47622382),
            (16.9342802744, -16.9313563251),
            [0.559816, -37.30480982],
        ],
        [
            277.13,
            (88.12893982, 55.93010658),
            (16.9431028479, -118.5322702695),
            [0.4803648, -136.04124938],
        ],
        [
            262.88,
            (88.12176178, 56.30353738),
            (0.0008534187, -16.9336313627),
            [0.38306502, -136.13854662],
        ],
        [
            262.88,
            (88.1940324, 56.8190888),
            (0.0008534187, -16.9336313627),
            [0.52391818, -135.997696],
        ],
        [
            243.44,
            (88.5043696, 57.2945768),
            (0.0014916558, -16.9328188651),
            [0.55751222, -37.3071136],
        ],
        [
            225.0,
            (88.98928862, 57.6717668),
            (-0.0, -16.9331709419),
            [0.603758, -23.343362],
        ],
        [
            187.13,
            (89.5304788, 57.73528458),
            (-118.5322702695, -16.9431028479),
            [0.52296822, -135.99864342],
        ],
        [
            172.88,
            (89.9034524, 57.74498738),
            (-118.5352255934, 16.9224148061),
            [0.38306502, -136.13854662],
        ],
        [
            172.88,
            (90.4729204, 57.66264058),
            (-118.5352255934, 16.9224148061),
            [0.578866, -135.94274818],
        ],
        [
            135.0,
            (90.91169778, 57.24223502),
            (-16.9331709419, 0.0),
            [0.59077098, -23.35634902],
        ],
        [
            116.57,
            (91.2195788, 56.79062302),
            (-16.9342802744, 16.9313563251),
            [0.559816, -37.30480982],
        ],
        [
            97.13,
            (91.3395684, 56.32676822),
            (-16.9431028479, 118.5322702695),
            [0.49054258, -136.0310716],
        ],
        [
            82.88,
            (91.3456644, 55.96324342),
            (-0.0008534187, 16.9336313627),
            [0.37036502, -136.15124662],
        ],
    ],
    "CONC_DEMOLITION": [
        [45.0, (0.0, 0.0), (-5.3881536726, 5.3881536726), [2.54, -2.54]],
        [45.0, (1.796034, 0.0), (-5.3881536726, 5.3881536726), [2.54, -2.54]],
        [-45.0, (0.0, 0.0), (5.3881536726, 5.3881536726), [2.54, -2.54]],
        [-45.0, (1.796034, 0.0), (5.3881536726, 5.3881536726), [2.54, -2.54]],
    ],
    "CONC_EXISTING": [
        [45.0, (0.0, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (1.7960467, 0.0), (-5.3881536726, 5.3881536726), []],
        [-45.0, (0.0, 0.0), (5.3881536726, 5.3881536726), []],
        [-45.0, (1.7960467, 0.0), (5.3881536726, 5.3881536726), []],
    ],
    "CONC_PRECAST": [
        [45.0, (0.0, 0.0), (-2.6940768363, 2.6940768363), []],
        [-45.0, (0.0, 0.0), (5.3881536726, 5.3881536726), []],
    ],
    "CORK": [
        [0.0, (0.0, 0.0), (0.0, 3.81), []],
        [
            135.0,
            (1.905, -1.905),
            (-7.6199999872, -7.6199999872),
            [5.3881536941, -5.3881536941],
        ],
        [
            135.0,
            (2.8575, -1.905),
            (-7.6199999872, -7.6199999872),
            [5.3881536941, -5.3881536941],
        ],
        [
            135.0,
            (3.81, -1.905),
            (-7.6199999872, -7.6199999872),
            [5.3881536941, -5.3881536941],
        ],
    ],
    "CROSS": [
        [0.0, (0.0, 0.0), (6.35, 6.35), [3.175, -9.525]],
        [90.0, (1.5875, -1.5875), (-6.35, 6.35), [3.175, -9.525]],
    ],
    "CROSSES": [
        [45.0, (-4.48945, 0.0), (-8.9802561211, 8.9802561211), [6.35, -6.35]],
        [135.0, (0.0, 0.0), (-8.9802561211, -8.9802561211), [6.35, -6.35]],
    ],
    "DASH": [[0.0, (0.0, 0.0), (3.175, 3.175), [3.175, -3.175]]],
    "DIAMONDS": [
        [60.0, (0.0, 0.0), (-5.499261314, 3.175), []],
        [120.0, (0.0, 0.0), (-5.499261314, -3.175), []],
    ],
    "DOLMIT": [
        [0.0, (0.0, 0.0), (0.0, 6.35), []],
        [
            45.0,
            (0.0, 0.0),
            (-12.6999913435, 12.6999913435),
            [8.9802561211, -17.9605122421],
        ],
    ],
    "DOTGRID": [[0.0, (0.0, 0.0), (0.0, 25.4), [0.0, -25.4]]],
    "DOTS": [[0.0, (0.0, 0.0), (0.79375, 1.5875), [0.0, -1.5875]]],
    "DOTS1": [[0.0, (0.0, 0.0), (0.79375, 1.5875), [0.0, -1.5875]]],
    "DOTS2": [
        [0.0, (1.016, 0.508), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (9.144, 1.016), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (4.572, 6.604), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (10.16, 10.668), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (3.556, 12.192), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (5.588, 18.288), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (2.032, 22.86), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (10.16, 22.352), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (16.256, 23.368), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (19.304, 17.272), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (24.384, 16.764), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (24.384, 7.62), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (19.812, 4.572), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (12.7, 6.096), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (17.272, 10.668), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (12.7, 15.24), (0.0, 25.4), [0.0, -25.4]],
        [0.0, (23.368, 1.016), (0.0, 25.4), [0.0, -25.4]],
    ],
    "EARTH": [
        [0.0, (0.0, 0.0), (6.35, 6.35), [6.35, -6.35]],
        [0.0, (0.0, 2.38125), (6.35, 6.35), [6.35, -6.35]],
        [0.0, (0.0, 4.7625), (6.35, 6.35), [6.35, -6.35]],
        [90.0, (0.79375, 5.55625), (-6.35, 6.35), [6.35, -6.35]],
        [90.0, (3.175, 5.55625), (-6.35, 6.35), [6.35, -6.35]],
        [90.0, (5.55625, 5.55625), (-6.35, 6.35), [6.35, -6.35]],
    ],
    "EARTH1": [
        [0.0, (0.0, 0.0), (6.35, 6.35), [6.35, -6.35]],
        [0.0, (0.0, 2.38125), (6.35, 6.35), [6.35, -6.35]],
        [0.0, (0.0, 4.7625), (6.35, 6.35), [6.35, -6.35]],
        [90.0, (0.79375, 5.55625), (-6.35, 6.35), [6.35, -6.35]],
        [90.0, (3.175, 5.55625), (-6.35, 6.35), [6.35, -6.35]],
        [90.0, (5.55625, 5.55625), (-6.35, 6.35), [6.35, -6.35]],
    ],
    "EARTH2": [
        [45.0, (0.0, 0.0), (0.0, 13.4703841816), [9.525, -9.525]],
        [45.0, (-1.3470384159, 1.3470384159), (0.0, 13.4703841816), [9.525, -9.525]],
        [45.0, (-2.6940768128, 2.6940768128), (0.0, 13.4703841816), [9.525, -9.525]],
        [45.0, (-4.0411152668, 4.0411152668), (0.0, 13.4703841816), [9.525, -9.525]],
        [45.0, (-5.388153435, 5.388153435), (0.0, 13.4703841816), [9.525, -9.525]],
        [45.0, (-6.73519227, 6.73519227), (0.0, 13.4703841816), [9.525, -9.525]],
        [135.0, (0.0, 0.0), (-13.4703841816, 0.0), [9.525, -9.525]],
        [135.0, (-1.3470384159, -1.3470384159), (-13.4703841816, 0.0), [9.525, -9.525]],
        [135.0, (-2.6940768128, -2.6940768128), (-13.4703841816, 0.0), [9.525, -9.525]],
        [135.0, (-4.0411152668, -4.0411152668), (-13.4703841816, 0.0), [9.525, -9.525]],
        [135.0, (-5.388153435, -5.388153435), (-13.4703841816, 0.0), [9.525, -9.525]],
        [135.0, (-6.73519227, -6.73519227), (-13.4703841816, 0.0), [9.525, -9.525]],
    ],
    "EGYPTIAN": [
        [0.0, (0.0, 0.0), (0.0, 31.75), [6.35, -6.35, 19.05]],
        [0.0, (0.0, 6.35), (0.0, 31.75), [-19.05, 12.7]],
        [0.0, (0.0, 12.7), (0.0, 31.75), [-19.05, 6.35, -6.35]],
        [0.0, (0.0, 19.05), (0.0, 31.75), [-12.7, 12.7, -6.35]],
        [0.0, (0.0, 25.4), (0.0, 31.75), [-6.35, 25.4]],
        [90.0, (6.35, 0.0), (-31.75, 0.0), [25.4, -6.35]],
        [90.0, (12.7, 0.0), (-31.75, 0.0), [19.05, -12.7]],
        [90.0, (19.05, 0.0), (-31.75, 0.0), [-6.35, 6.35, -19.05]],
        [90.0, (25.4, 0.0), (-31.75, 0.0), [-12.7, 6.35, -12.7]],
        [90.0, (31.75, 0.0), (-31.75, 0.0), [-6.35, 19.05, -6.35]],
    ],
    "ESCHER": [
        [60.0, (0.0, 0.0), (-30.4799999881, -6.9e-09), [27.94, -2.54]],
        [180.0, (0.0, 0.0), (15.24, -26.3964542936), [27.94, -2.54]],
        [300.0, (0.0, 0.0), (30.4799999881, -6.9e-09), [27.94, -2.54]],
        [60.0, (2.54, 0.0), (-30.4799999881, -6.9e-09), [5.08, -25.4]],
        [300.0, (2.54, 0.0), (30.4799999881, -6.9e-09), [5.08, -25.4]],
        [60.0, (-1.27, 2.199704516), (-30.4799999881, -6.9e-09), [5.08, -25.4]],
        [180.0, (-1.27, 2.199704516), (15.24, -26.3964542936), [5.08, -25.4]],
        [300.0, (-1.27, -2.199704516), (30.4799999881, -6.9e-09), [5.08, -25.4]],
        [180.0, (-1.27, -2.199704516), (15.24, -26.3964542936), [5.08, -25.4]],
        [60.0, (-10.16, 0.0), (-30.4799999881, -6.9e-09), [5.08, -25.4]],
        [300.0, (-10.16, 0.0), (30.4799999881, -6.9e-09), [5.08, -25.4]],
        [60.0, (5.08, -8.7988180894), (-30.4799999881, -6.9e-09), [5.08, -25.4]],
        [180.0, (5.08, -8.7988180894), (15.24, -26.3964542936), [5.08, -25.4]],
        [300.0, (5.08, 8.7988180894), (30.4799999881, -6.9e-09), [5.08, -25.4]],
        [180.0, (5.08, 8.7988180894), (15.24, -26.3964542936), [5.08, -25.4]],
        [0.0, (5.08, 4.3994090574), (-15.24, 26.3964542936), [17.78, -12.7]],
        [0.0, (5.08, -4.3994090574), (-15.24, 26.3964542936), [17.78, -12.7]],
        [120.0, (1.27, 6.5991135734), (-30.4799999881, 6.9e-09), [17.78, -12.7]],
        [120.0, (-6.35, 2.199704516), (-30.4799999881, 6.9e-09), [17.78, -12.7]],
        [240.0, (-6.35, -2.199704516), (15.2399999881, -26.3964543005), [17.78, -12.7]],
        [240.0, (1.27, -6.5991135734), (15.2399999881, -26.3964543005), [17.78, -12.7]],
    ],
    "FLEX": [
        [0.0, (0.0, 0.0), (0.0, 6.35), [6.35, -6.35]],
        [
            45.0,
            (6.35, 0.0),
            (0.0, 6.3499999893),
            [1.5875, -5.8052561314, 1.5875, -8.9802561314],
        ],
    ],
    "FLEXIBLE": [
        [0.0, (0.0, 0.0), (0.0, 7.62), [7.62, -7.62]],
        [
            45.0,
            (7.62, 0.0),
            (0.0, 7.6199999872),
            [1.905, -6.9663073577, 1.905, -10.7763073577],
        ],
    ],
    "GLASS": [
        [
            236.3099,
            (12.192, 14.224),
            (-20.3200271172, -40.6399910139),
            [7.3264776, -65.93831872],
        ],
        [
            236.3099,
            (12.5984, 13.0048),
            (-20.3200271172, -40.6399910139),
            [4.39588656, -68.86890976],
        ],
        [
            236.3099,
            (10.16, 13.0048),
            (-20.3200271172, -40.6399910139),
            [4.39588656, -68.86890976],
        ],
    ],
    "GOST_GLASS": [
        [45.0, (0.0, 0.0), (8.4852813742, 0.0), [5.0, -7.0]],
        [45.0, (2.12132, 0.0), (8.4852813742, 0.0), [2.0, -10.0]],
        [45.0, (0.0, 2.12132), (8.4852813742, 0.0), [2.0, -10.0]],
    ],
    "GOST_GROUND": [
        [45.0, (0.0, 0.0), (14.1421356237, 0.0), [20.0]],
        [45.0, (3.0, 0.0), (14.1421356237, 0.0), [20.0]],
        [45.0, (6.0, 0.0), (14.1421356237, 0.0), [20.0]],
    ],
    "GOST_WOOD": [
        [90.0, (0.0, 0.0), (6.0, 0.0), [10.0, -2.0]],
        [90.0, (2.0, -2.0), (6.0, 0.0), [6.0, -1.5, 3.0, -1.5]],
        [90.0, (4.0, -5.0), (6.0, 0.0), [10.0, -2.0]],
    ],
    "GRASS": [
        [90.0, (0.0, 0.0), (-17.96051224, 17.96051224), [4.7625, -31.15852448]],
        [45.0, (0.0, 0.0), (-17.9605122421, 17.9605122421), [4.7625, -20.6375]],
        [135.0, (0.0, 0.0), (-17.9605122421, -17.9605122421), [4.7625, -20.6375]],
    ],
    "GRASS1": [
        [90.0, (0.0, 0.0), (-14.3684097899, 14.3684097899), [3.81, -24.9268196002]],
        [45.0, (0.0, 0.0), (-14.3684097937, 14.3684097937), [3.81, -16.51]],
        [135.0, (0.0, 0.0), (-14.3684097937, -14.3684097937), [3.81, -16.51]],
    ],
    "GRASS2": [
        [0.0, (0.0, 0.0), (10.16, 17.597636189), [2.54, -17.78]],
        [90.0, (1.27, 0.0), (-10.16, 17.597636189), [1.27, -33.9252723779]],
        [90.0, (1.5875, 0.0), (-10.16, 17.597636189), [1.016, -34.1792723779]],
        [90.0, (0.9525, 0.0), (-10.16, 17.597636189), [1.016, -34.1792723779]],
        [60.0, (1.905, 0.0), (-10.1599999862, 17.5976361969), [0.8128, -19.5072]],
        [120.0, (0.635, 0.0), (-20.3199999862, 8e-09), [0.8128, -19.5072]],
    ],
    "GRATE": [
        [0.0, (0.0, 0.0), (0.0, 0.79375), []],
        [90.0, (0.0, 0.0), (-3.175, 0.0), []],
    ],
    "GRAVEL": [
        [
            228.0127875,
            (18.288, 25.4),
            (-203.200000016, -228.5999999858),
            [3.4172144, -338.3048363956],
        ],
        [
            184.969741,
            (16.002, 22.86),
            (304.7999998794, 25.400001447),
            [5.8640472, -580.5404889352],
        ],
        [
            132.5104471,
            (10.16, 22.352),
            (254.0000001073, -279.3999999025),
            [4.1348152, -409.347227941],
        ],
        [
            267.273689,
            (0.254, 16.002),
            (25.4000000532, 507.9999999973),
            [5.3400452, -528.6643742574],
        ],
        [
            292.83365418,
            (0.0, 10.668),
            (-127.0000000106, 304.7999999956),
            [5.236337, -518.3980774534],
        ],
        [
            357.273689,
            (2.032, 5.842),
            (-507.9999999973, 25.4000000532),
            [5.3400452, -528.6643742574],
        ],
        [
            37.69424047,
            (7.366, 5.588),
            (-330.1999999854, -254.000000019),
            [7.0619366, -699.1311531425],
        ],
        [
            72.25532837,
            (12.954, 9.906),
            (177.8000000478, 558.7999999848),
            [6.6671952, -660.0525660191],
        ],
        [
            121.42956562,
            (14.986, 16.256),
            (-203.2000000288, 330.1999999823),
            [5.35813, -530.4554569871],
        ],
        [
            175.2363583,
            (12.192, 20.828),
            (279.399999996, -25.4000000439),
            [6.1171328, -299.7393695],
        ],
        [
            222.3974378,
            (6.096, 21.336),
            (-304.7999999902, -279.4000000106),
            [7.9107792, -783.1677251218],
        ],
        [
            138.81407483,
            (25.4, 15.748),
            (-177.7999999893, 152.4000000124),
            [2.7000454, -267.3056582434],
        ],
        [
            171.4692344,
            (23.368, 17.526),
            (330.2000000089, -50.7999999424),
            [5.1368198, -508.5463899704],
        ],
        [225.0, (18.288, 18.288), (-0.0, -25.4), [3.5920934, -32.3289310843]],
        [
            203.19859051,
            (16.51, 21.336),
            (127.0000000035, 50.7999999911),
            [1.9344132, -191.5062236889],
        ],
        [
            291.80140949,
            (14.732, 20.574),
            (-25.4000000053, 76.1999999982),
            [2.7356562, -134.0475299],
        ],
        [
            30.96375653,
            (15.748, 18.034),
            (76.2000000019, 50.7999999972),
            [4.4431966, -143.6629815291],
        ],
        [
            161.56505118,
            (19.558, 20.32),
            (50.8000000013, -25.3999999973),
            [3.2128714, -77.1089811683],
        ],
        [16.389540334, (0.0, 20.574), (254.0, 76.2), [4.50088, -445.5882667254]],
        [
            70.34617594,
            (4.318, 21.844),
            (-101.6000000093, -279.3999999967),
            [3.7759894, -373.822156782],
        ],
        [
            293.19859051,
            (19.558, 25.4),
            (-50.7999999911, 127.0000000036),
            [3.868801, -189.5718358889],
        ],
        [
            343.61045967,
            (21.082, 21.844),
            (-254.0000000053, 76.1999999822),
            [4.50088, -445.5882667254],
        ],
        [339.44395478, (0.0, 4.826), (-127.0, 50.8), [4.340352, -212.6773431311]],
        [
            294.7751406,
            (4.064, 3.302),
            (-127.0000001512, 279.3999999313),
            [3.6367212, -360.0359338072],
        ],
        [
            66.80140949,
            (19.812, 0.0),
            (50.799999992, 127.0000000032),
            [3.868801, -189.5718358889],
        ],
        [
            17.35402464,
            (21.336, 3.556),
            (-330.1999999934, -101.6000000213),
            [4.2578274, -421.523759802],
        ],
        [
            69.44395478,
            (7.366, 0.0),
            (-50.8000000009, -126.9999999996),
            [2.170176, -214.8475191311],
        ],
        [101.309932474, (18.288, 0.0), (-25.4, 101.6), [1.295146, -128.2199496453]],
        [165.963756532, (18.034, 1.27), (76.2, -25.4), [5.236337, -99.4905458907]],
        [
            186.00900596,
            (12.954, 2.54),
            (253.9999999987, 25.4000000133),
            [4.85267, -480.4136486334],
        ],
        [
            303.69006753,
            (15.748, 15.748),
            (-25.4000000035, 50.7999999982),
            [3.6632388, -87.9177635968],
        ],
        [
            353.15722659,
            (17.78, 12.7),
            (431.8000000027, -50.7999999774),
            [6.3955676, -633.1600906503],
        ],
        [
            60.9453959,
            (24.13, 11.938),
            (-101.6000000028, -177.7999999984),
            [2.6150824, -258.8939231811],
        ],
        [90.0, (25.4, 14.224), (-25.4, 25.4), [1.524, -23.876]],
        [
            120.25643716,
            (12.446, 3.302),
            (101.5999999876, -177.8000000071),
            [3.5286696, -349.339407732],
        ],
        [
            48.0127875,
            (10.668, 6.35),
            (203.2000000168, 228.5999999851),
            [6.8344288, -334.8876219957],
        ],
        [0.0, (15.24, 11.43), (25.4, 25.4), [6.604, -18.796]],
        [
            325.3048465,
            (21.844, 11.43),
            (254.0000000962, -177.7999998625),
            [4.0160956, -397.5931672414],
        ],
        [
            254.0546041,
            (25.146, 9.144),
            (-25.3999999982, -101.6000000004),
            [3.6982908, -181.2165003877],
        ],
        [
            207.64597536,
            (24.13, 5.588),
            (-482.6000000177, -253.9999999663),
            [6.021451, -596.1246442294],
        ],
        [175.42607874, (18.796, 2.794), (-330.2, 25.4), [6.3702946, -630.6584645624]],
    ],
    "GRAVEL1": [
        [
            228.0128,
            (12.9600000032, 17.9999999816),
            (-143.9999681763, -162.000024158),
            [2.4216479939, -239.7435839968],
        ],
        [
            184.9697,
            (11.3399999971, 16.2000000155),
            (216.0000189102, 17.9998435066),
            [4.1556239824, -411.4066499867],
        ],
        [
            132.5104,
            (7.2000000018, 15.840000004),
            (179.9998329469, -198.0001561228),
            [2.9301840101, -290.0885759914],
        ],
        [
            267.2737,
            (0.1800000058, 11.3399999971),
            (17.9999283207, 360.0000052976),
            [3.7842839935, -374.6440439896],
        ],
        [
            292.8337,
            (0.0, 7.5600000133),
            (-90.0001782992, 215.999935404),
            [3.7107900079, -367.3687139784],
        ],
        [
            357.2737,
            (1.4400000004, 4.1399999953),
            (-360.0000052976, 17.9999283207),
            [3.7842839935, -374.6440439896],
        ],
        [
            37.6942,
            (5.2199999842, 3.9599999896),
            (-234.0001322119, -179.9998272812),
            [5.0045219899, -495.4472817984],
        ],
        [
            72.2553,
            (9.1800000194, 7.019999996),
            (126.0001937207, 395.9999321528),
            [4.724783987, -467.7537780288],
        ],
        [
            121.4296,
            (10.6200000198, 11.5200000029),
            (-144.0001482242, 233.9999106564),
            [3.7970999953, -375.9133139885],
        ],
        [
            175.2364,
            (8.6400000022, 14.7600000151),
            (198.0000170247, -17.9998475922),
            [4.3349759986, -212.4137339982],
        ],
        [
            222.3974,
            (4.3200000011, 15.1199999809),
            (-216.0001323074, -197.9998574727),
            [5.6060640076, -555.0007501944],
        ],
        [
            138.8141,
            (17.9999999816, 11.1599999914),
            (-126.0000530418, 107.9999516683),
            [1.9134179816, -189.4291919867],
        ],
        [
            171.4692,
            (16.5599999813, 12.419999986),
            (233.9999691401, -36.0001423904),
            [3.6402659935, -360.3871980151],
        ],
        [
            225.0,
            (12.9600000032, 12.9600000032),
            (-0.0, -18.000005591),
            [2.5455779975, -22.9102560184],
        ],
        [
            203.1986,
            (11.7000000086, 15.1199999809),
            (89.9999951667, 36.0000238407),
            [1.3708440198, -135.7130699906],
        ],
        [
            291.8014,
            (10.440000014, 14.5800000094),
            (-17.9999983704, 54.0000049026),
            [1.9386540043, -94.9943160054],
        ],
        [
            30.9638,
            (11.1599999914, 12.7799999975),
            (53.9999644169, 36.0000446951),
            [3.1487219982, -101.8084140155],
        ],
        [
            161.5651,
            (13.8599999863, 14.4000000036),
            (36.0000078261, -17.9999712785),
            [2.2768379863, -54.644165987],
        ],
        [
            16.3895,
            (0.0, 14.5800000094),
            (180.0000395482, 53.999868792),
            [3.1896000216, -315.7712100108],
        ],
        [
            70.3462,
            (3.0600000065, 15.4799999924),
            (-71.9999144577, -198.0000384368),
            [2.6758980112, -264.913343995],
        ],
        [
            293.1986,
            (13.8599999863, 17.9999999816),
            (-36.0000238407, 89.9999951667),
            [2.7416699802, -134.3422439845],
        ],
        [
            343.6105,
            (14.9400000209, 15.4799999924),
            (-180.0000395482, 53.999868792),
            [3.1896000216, -315.7712100108],
        ],
        [
            339.444,
            (0.0, 3.420000018),
            (-90.000033183, 35.9999279355),
            [3.0758400205, -150.7162320086],
        ],
        [
            294.7751,
            (2.8800000007, 2.3399999834),
            (-89.9998594132, 198.0000615975),
            [2.5772039845, -255.1435739892],
        ],
        [
            66.8014,
            (14.0399999921, 0.0),
            (36.0000238407, 89.9999951667),
            [2.7416699802, -134.3422439845],
        ],
        [
            17.354,
            (15.1199999809, 2.5199999892),
            (-234.0000363497, -71.9999010651),
            [3.017358014, -298.7176319971],
        ],
        [
            69.444,
            (5.2199999842, 0.0),
            (-35.9999279355, -90.000033183),
            [1.5379199874, -152.254151996],
        ],
        [
            101.3099,
            (12.9600000032, 0.0),
            (-17.9999573944, 72.0000135294),
            [0.9178199932, -90.8645219942],
        ],
        [
            165.9638,
            (12.7799999975, 0.8999999831),
            (54.0000098409, -17.9999650276),
            [3.7107900079, -70.5050999903],
        ],
        [
            186.009,
            (9.1800000194, 1.8000000119),
            (179.9999954963, 17.9999876948),
            [3.4388999802, -340.4506140022],
        ],
        [
            303.6901,
            (11.1599999914, 11.1599999914),
            (-18.0000240412, 35.9999920382),
            [2.5959960018, -62.3039220112],
        ],
        [
            353.1572,
            (12.5999999917, 9.0000000137),
            (305.9999885795, -36.0001439522),
            [4.5322919971, -448.6961339953],
        ],
        [
            60.9454,
            (17.0999999986, 8.4599999964),
            (-72.0000005012, -126.0000069224),
            [1.8532079878, -183.4681320216],
        ],
        [
            90.0,
            (17.9999999816, 10.0800000025),
            (-17.9999999816, 17.9999999816),
            [1.0799999888, -16.9199999928],
        ],
        [
            120.2564,
            (8.8200000079, 2.3399999834),
            (71.9999079614, -126.0000441964),
            [2.5006319914, -247.5633600209],
        ],
        [
            48.0128,
            (7.5600000133, 4.5000000068),
            (143.9999681763, 162.000024158),
            [4.8432959878, -237.3219360029],
        ],
        [
            0.0,
            (10.7999999798, 8.0999999849),
            (17.9999999816, 17.9999999816),
            [4.6800000126, -13.3200000148],
        ],
        [
            325.3048,
            (15.4799999924, 8.0999999849),
            (-179.9998966718, 126.0001549797),
            [2.8460519863, -281.7589319903],
        ],
        [
            254.0546,
            (17.8200000216, 6.4799999788),
            (-17.9999980057, -72.0000022974),
            [2.6208359978, -128.4211439852],
        ],
        [
            207.646,
            (17.0999999986, 3.9599999896),
            (-341.999924501, -180.0001388421),
            [4.2671699924, -422.4505320137],
        ],
        [
            175.4261,
            (13.320007142, 1.980001628),
            (-233.9997863523, 17.9999001623),
            [4.51438391, -446.9228933],
        ],
    ],
    "GRID": [[0.0, (0.0, 0.0), (0.0, 25.4), []], [90.0, (0.0, 0.0), (-25.4, 0.0), []]],
    "GROUT": [
        [0.0, (5.08, 2.54), (1.27, 10.16), [1.27, -8.89]],
        [0.0, (6.35, 6.35), (0.0, 10.16), [0.0, -10.16]],
        [0.0, (2.54, 2.54), (3.81, 10.16), [0.0, -10.16]],
        [0.0, (2.54, 10.16), (10.16, 10.16), [2.54, -17.78]],
        [0.0, (10.16, 3.81), (0.0, 10.16), [0.0, -10.16]],
        [0.0, (7.62, 2.54), (2.54, 10.16), [0.0, -10.16]],
        [0.0, (8.89, 3.81), (0.0, 10.16), [0.0, -10.16]],
        [0.0, (3.81, 10.16), (0.0, 10.16), [0.0, -10.16]],
    ],
    "HERRING_45": [
        [0.0, (0.0, 0.0), (25.4, 25.4), [76.2, -25.4]],
        [90.0, (25.4, 0.0), (-25.4, -25.4), [76.2, -25.4]],
    ],
    "HERRING_H": [
        [0.0, (0.0, 0.0), (0.0, 20.32), []],
        [315.0, (0.0, 0.0), (20.3199999946, -0.0), [28.7368196002, -28.7368196002]],
        [45.0, (0.0, 0.0), (20.3199999946, 0.0), [28.7368196002, -28.7368196002]],
    ],
    "HERRING_UNI": [
        [
            18.435,
            (0.0, 0.0),
            (25.1005565075, 25.1006013476),
            [7.9375, -63.5, 15.875, -71.4375],
        ],
        [
            18.435,
            (17.5703865, -2.510028),
            (25.1005565075, 25.1006013476),
            [15.875, -63.5, 7.9375, -71.4375],
        ],
        [
            108.435,
            (2.510028, -7.5301475),
            (25.1005565075, 25.1006013476),
            [15.875, -63.5, 15.875, -63.5],
        ],
        [
            108.435,
            (2.510028, 17.5703865),
            (25.1005565075, 25.1006013476),
            [15.875, -63.5, 15.875, -63.5],
        ],
        [108.435, (25.100534, 0.0), (25.1005565075, 25.1006013476), [7.9375, -71.4375]],
        [
            108.435,
            (-22.5905695, 17.5703865),
            (25.1005565075, 25.1006013476),
            [7.9375, -71.4375],
        ],
        [
            333.435,
            (7.5301729, 2.5100661),
            (25.1005713744, 25.1005878164),
            [11.2253395, -101.02788405, 11.2253395, -101.02788405],
        ],
        [
            333.435,
            (-42.6710094, 27.6106001),
            (25.1005713744, 25.1005878164),
            [11.22532045, -213.2810822],
        ],
        [
            333.435,
            (32.630745, 2.51008515),
            (25.1005713744, 25.1005878164),
            [11.2253395, -44.93962818, 11.2253395, -157.15447995],
        ],
        [
            333.435,
            (-17.57043095, 27.61061915),
            (25.1005713744, 25.1005878164),
            [11.22532045, -213.2810822],
        ],
        [
            333.435,
            (57.7313425, 2.5100915),
            (25.1005713744, 25.1005878164),
            [11.2253395, -101.02788405, 11.2253395, -101.02788405],
        ],
        [
            333.435,
            (107.9325121, -22.59042345),
            (25.1005713744, 25.1005878164),
            [11.22532045, -213.2810822],
        ],
        [
            63.435,
            (-2.510155, 7.530465),
            (-25.1007417629, -25.1005026224),
            [11.22553, -44.90085, 11.22553, -101.0285, 11.22553, -44.90085],
        ],
    ],
    "HERRING_V": [
        [45.0, (0.0, 0.0), (0.0, 35.9210244843), [76.2, -25.4]],
        [135.0, (17.9605122437, 17.9605122437), (0.0, 35.9210244843), [76.2, -25.4]],
    ],
    "HEX": [
        [0.0, (0.0, 0.0), (0.0, 5.4992613154), [3.175, -6.35]],
        [120.0, (0.0, 0.0), (-4.7625000012, -2.7496306577), [3.175, -6.35]],
        [60.0, (3.175, 0.0), (-4.7625000012, 2.7496306577), [3.175, -6.35]],
    ],
    "HEXAGONS": [
        [0.0, (0.0, 0.0), (0.0, 6.5991135785), [3.81, -7.62]],
        [120.0, (0.0, 0.0), (-5.7150000014, -3.2995567892), [3.81, -7.62]],
        [60.0, (3.81, 0.0), (-5.7150000014, 3.2995567892), [3.81, -7.62]],
    ],
    "HONEY": [
        [0.0, (0.0, 0.0), (4.7625, 2.749630645), [3.175, -6.35]],
        [120.0, (0.0, 0.0), (-4.7624999896, 2.749630663), [3.175, -6.35]],
        [60.0, (0.0, 0.0), (1.04e-08, 5.499261308), [-6.35, 3.175]],
    ],
    "HONEYCOMB": [
        [0.0, (0.0, 0.0), (5.715, 3.299556774), [3.81, -7.62]],
        [120.0, (0.0, 0.0), (-5.7149999875, 3.2995567956), [3.81, -7.62]],
        [60.0, (0.0, 0.0), (1.25e-08, 6.5991135696), [-7.62, 3.81]],
    ],
    "HOUND": [
        [0.0, (0.0, 0.0), (6.35, 1.5875), [25.4, -12.7]],
        [90.0, (0.0, 0.0), (-1.5875, -6.35), [25.4, -12.7]],
    ],
    "INSUL": [
        [0.0, (0.0, 0.0), (0.0, 9.525), []],
        [0.0, (0.0, 3.175), (0.0, 9.525), [3.175, -3.175]],
        [0.0, (0.0, 6.35), (0.0, 9.525), [3.175, -3.175]],
    ],
    "INSULATION": [
        [45.0, (0.0, 0.0), (-2.5144717139, 2.5144717139), []],
        [135.0, (0.0, 0.0), (-2.5144717139, -2.5144717139), []],
    ],
    "ISO02W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0]]],
    "ISO03W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -18.0]]],
    "ISO04W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 0.5, -3.0]]],
    "ISO05W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 0.5, -3.0, 0.5, -3.0]]],
    "ISO06W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 0.5, -3.0, 0.5, -6.5]],
        [0.0, (0.0, 0.0), (0.0, 5.0), [-34.0, 0.5, -3.0]],
    ],
    "ISO07W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [0.5, -3.0]]],
    "ISO08W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 6.0, -3.0]]],
    "ISO09W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [24.0, -3.0, 6.0, -3.0, 6.0, -3.0]]],
    "ISO10W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 0.5, -3.0]]],
    "ISO11W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 12.0, -3.0, 0.5, -3.0]]],
    "ISO12W100": [[0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 0.5, -3.0, 0.5, -3.0]]],
    "ISO13W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 12.0, -3.0, 0.5, -6.5]],
        [0.0, (0.0, 0.0), (0.0, 5.0), [-33.5, 0.5, -3.0]],
    ],
    "ISO14W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 0.5, -3.0, 0.5, -6.5]],
        [0.0, (0.0, 0.0), (0.0, 5.0), [-22.0, 0.5, -3.0]],
    ],
    "ISO15W100": [
        [0.0, (0.0, 0.0), (0.0, 5.0), [12.0, -3.0, 12.0, -3.0, 0.5, -10.0]],
        [0.0, (0.0, 0.0), (0.0, 5.0), [-33.5, 0.5, -3.0, 0.5, -3.0]],
    ],
    "JIS_LC_20": [
        [45.0, (0.0, 0.0), (-14.1421356237, 14.1421356237), []],
        [45.0, (0.4, 0.0), (-14.1421356237, 14.1421356237), []],
    ],
    "JIS_LC_20A": [
        [45.0, (0.0, 0.0), (-14.1421356237, 14.1421356237), []],
        [45.0, (1.0, 0.0), (-14.1421356237, 14.1421356237), []],
    ],
    "JIS_LC_8": [
        [45.0, (0.0, 0.0), (-5.5154328933, 5.5154328933), []],
        [45.0, (0.4, 0.0), (-5.5154328933, 5.5154328933), []],
    ],
    "JIS_LC_8A": [
        [45.0, (0.0, 0.0), (-5.5154328933, 5.5154328933), []],
        [45.0, (1.0, 0.0), (-5.5154328933, 5.5154328933), []],
    ],
    "JIS_RC_10": [
        [45.0, (0.0, 0.0), (-7.0710678119, 7.0710678119), []],
        [45.0, (0.725, 0.0), (-7.0710678119, 7.0710678119), []],
        [45.0, (1.45, 0.0), (-7.0710678119, 7.0710678119), []],
    ],
    "JIS_RC_15": [
        [45.0, (0.0, 0.0), (-10.6066017178, 10.6066017178), []],
        [45.0, (0.725, 0.0), (-10.6066017178, 10.6066017178), []],
        [45.0, (1.45, 0.0), (-10.6066017178, 10.6066017178), []],
    ],
    "JIS_RC_18": [
        [45.0, (0.0, 0.0), (-12.7279220614, 12.7279220614), []],
        [45.0, (1.0, 0.0), (-12.7279220614, 12.7279220614), []],
        [45.0, (2.0, 0.0), (-12.7279220614, 12.7279220614), []],
    ],
    "JIS_RC_30": [
        [45.0, (0.0, 0.0), (-21.2132034356, 21.2132034356), []],
        [45.0, (1.0, 0.0), (-21.2132034356, 21.2132034356), []],
        [45.0, (2.0, 0.0), (-21.2132034356, 21.2132034356), []],
    ],
    "JIS_STN_1E": [
        [45.0, (0.0, 0.0), (-0.7071067812, 0.7071067812), []],
        [45.0, (0.705, 0.0), (-0.7071067812, 0.7071067812), [1.0, -0.5]],
    ],
    "JIS_STN_2.5": [
        [45.0, (0.0, 0.0), (-1.767766953, 1.767766953), []],
        [45.0, (1.765, 0.0), (-1.767766953, 1.767766953), [1.2, -0.5]],
    ],
    "JIS_WOOD": [[45.0, (0.0, 0.0), (-0.4999999992, 0.4999999992), []]],
    "LINE": [[0.0, (0.0, 0.0), (0.0, 3.175), []]],
    "LINES": [[0.0, (0.0, 0.0), (0.0, 2.54), []]],
    "MUDST": [[0.0, (0.0, 0.0), (12.7, 6.35), [6.35, -6.35, 0.0, -6.35, 0.0, -6.35]]],
    "NATURAL": [
        [45.0, (0.0, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (3.5920934, 0.0), (-5.3881536726, 5.3881536726), [1.27, -1.27]],
        [45.0, (7.1841868, 0.0), (-5.3881536726, 5.3881536726), [1.27, -1.27]],
    ],
    "NET": [[0.0, (0.0, 0.0), (0.0, 3.175), []], [90.0, (0.0, 0.0), (-3.175, 0.0), []]],
    "NET3": [
        [0.0, (0.0, 0.0), (0.0, 3.175), []],
        [60.0, (0.0, 0.0), (-2.749630657, 1.5875), []],
        [120.0, (0.0, 0.0), (-2.749630657, -1.5875), []],
    ],
    "OCTAGONS": [
        [315.0, (0.0, 8.8392), (30.480009432, -0.0), [12.50051856, -30.60472416]],
        [0.0, (8.8392, 0.0), (30.48, 30.48), [12.8016, -17.6784]],
        [45.0, (21.6408, 0.0), (0.0, 30.480009432), [12.50051856, -30.60472416]],
        [135.0, (30.48, 21.6408), (-30.480009432, 0.0), [12.50051856, -30.60472416]],
        [225.0, (8.8392, 30.48), (-0.0, -30.480009432), [12.50051856, -30.60472416]],
        [270.0, (0.0, 21.6408), (30.48, -30.48), [12.8016, -17.6784]],
    ],
    "PLAST": [
        [0.0, (0.0, 0.0), (0.0, 6.35), []],
        [0.0, (0.0, 0.79375), (0.0, 6.35), []],
        [0.0, (0.0, 1.5875), (0.0, 6.35), []],
    ],
    "PLASTI": [
        [0.0, (0.0, 0.0), (0.0, 6.35), []],
        [0.0, (0.0, 0.79375), (0.0, 6.35), []],
        [0.0, (0.0, 1.5875), (0.0, 6.35), []],
        [0.0, (0.0, 3.96875), (0.0, 6.35), []],
    ],
    "PLUSSES": [
        [0.0, (0.0, 0.0), (7.62, 7.62), [3.81, -11.43]],
        [90.0, (1.905, -1.905), (-7.62, 7.62), [3.81, -11.43]],
    ],
    "ROCK": [
        [0.0, (0.0, 0.0), (0.0, 5.08), []],
        [
            45.0,
            (0.0, 0.0),
            (-10.159999983, 10.159999983),
            [7.1842048848, -14.3684280576],
        ],
    ],
    "SACNCR": [
        [45.0, (0.0, 0.0), (-1.6837980227, 1.6837980227), []],
        [45.0, (1.6838, 0.0), (-1.6837980227, 1.6837980227), [0.0, -2.38125]],
    ],
    "SAND": [
        [45.0, (0.0, 0.0), (-4.0411152545, 4.0411152545), [-1.905, 1.905, -1.905]],
        [45.0, (4.0386, 0.0), (-4.0411152545, 4.0411152545), [-1.905, 1.905, -1.905]],
        [135.0, (0.0, 0.0), (-4.0411152545, -4.0411152545), [0.9525, -3.81, 0.9525]],
        [135.0, (4.0386, 0.0), (-4.0411152545, -4.0411152545), [0.9525, -3.81, 0.9525]],
    ],
    "SCREED": [
        [0.0, (0.0, 0.0), (50.8, 12.7), [-6.35, 0.0, -19.05, 0.0]],
        [
            0.0,
            (0.0, 0.635),
            (50.8, 12.7),
            [-2.54, 0.0, -8.89, 0.0, -4.572, 0.0, -19.05, 0.0],
        ],
        [
            0.0,
            (0.0, 1.27),
            (50.8, 12.7),
            [-1.27, 0.0, -6.35, 0.0, -6.35, 0.0, -13.97, 0.0, -4.572, 0.0],
        ],
        [0.0, (0.0, 1.905), (50.8, 12.7), [-4.572, 0.0, -20.32, 0.0]],
        [0.0, (0.0, 2.54), (50.8, 12.7), [-15.24, 0.0, -15.24, 0.0]],
        [0.0, (0.0, 3.175), (50.8, 12.7), [-21.59, 0.0]],
        [0.0, (0.0, 3.81), (50.8, 12.7), [-6.35, 0.0, -27.94, 0.0]],
        [0.0, (0.0, 4.445), (50.8, 12.7), [-8.89, 0.0, -5.08, 0.0]],
        [0.0, (0.0, 5.08), (50.8, 12.7), [-12.7, 0.0]],
        [0.0, (0.0, 6.35), (50.8, 12.7), [-1.778, 0.0, -19.05, 0.0, -11.43, 0.0]],
        [0.0, (0.0, 6.985), (50.8, 12.7), [-2.54, 0.0, -0.254, 0.0, -6.35, 0.0]],
        [0.0, (0.0, 7.62), (50.8, 12.7), [-1.27, 0.0, -16.51, 0.0, -19.05, 0.0]],
        [0.0, (0.0, 8.255), (50.8, 12.7), [-12.7, 0.0]],
        [0.0, (0.0, 8.89), (50.8, 12.7), [-6.35, 0.0, -26.67, 0.0]],
        [0.0, (0.0, 10.16), (50.8, 12.7), [-30.48, 0.0]],
        [0.0, (0.0, 10.795), (50.8, 12.7), [-6.35, 0.0, -0.508, 0.0, -8.89, 0.0]],
        [
            0.0,
            (0.0, 11.43),
            (50.8, 12.7),
            [-1.778, 0.0, -12.7, 0.0, -5.08, 0.0, -8.89, 0.0, -10.16, 0.0],
        ],
        [
            0.0,
            (0.0, 12.065),
            (50.8, 12.7),
            [-3.81, 0.0, -5.08, 0.0, -12.7, 0.0, -0.508, 0.0, -6.35, 0.0],
        ],
        [0.0, (0.0, 12.7), (50.8, 12.7), [-12.7, 0.0]],
    ],
    "SHAKES": [
        [0.0, (0.0, 3.048), (101.6, 101.6), [10.16, -91.44]],
        [0.0, (10.16, 0.0), (101.6, 101.6), [30.48, -71.12]],
        [0.0, (40.64, 2.032), (101.6, 101.6), [15.24, -86.36]],
        [0.0, (55.88, 0.0), (101.6, 101.6), [30.48, -71.12]],
        [0.0, (86.36, 3.048), (101.6, 101.6), [15.24, -86.36]],
        [0.0, (15.24, 33.528), (101.6, 101.6), [30.48, -71.12]],
        [0.0, (0.0, 35.56), (101.6, 101.6), [15.24, -86.36]],
        [0.0, (45.72, 36.576), (101.6, 101.6), [20.32, -81.28]],
        [0.0, (66.04, 33.528), (101.6, 101.6), [35.56, -66.04]],
        [0.0, (0.0, 68.072), (101.6, 101.6), [34.544, -67.056]],
        [0.0, (34.544, 70.104), (101.6, 101.6), [24.384, -77.216]],
        [0.0, (58.928, 67.056), (101.6, 101.6), [18.288, -83.312]],
        [0.0, (77.216, 71.12), (101.6, 101.6), [17.272, -84.328]],
        [180.0, (101.6, 68.072), (-101.6, -101.6), [7.112, -94.488]],
        [90.0, (10.16, 0.0), (-101.6, 101.6), [35.56, -66.04]],
        [90.0, (40.64, 0.0), (-101.6, 101.6), [33.528, -68.072]],
        [90.0, (55.88, 0.0), (-101.6, 101.6), [36.576, -65.024]],
        [90.0, (86.36, 0.0), (-101.6, 101.6), [33.528, -68.072]],
        [90.0, (45.72, 33.528), (-101.6, 101.6), [36.576, -65.024]],
        [90.0, (34.544, 68.072), (-101.6, 101.6), [33.528, -68.072]],
        [90.0, (58.928, 67.056), (-101.6, 101.6), [34.544, -67.056]],
        [270.0, (0.0, 68.072), (101.6, -101.6), [34.544, -67.056]],
        [270.0, (15.24, 68.072), (101.6, -101.6), [34.544, -67.056]],
        [270.0, (66.04, 67.056), (101.6, -101.6), [33.528, -68.072]],
        [90.0, (94.488, 68.072), (-101.6, 101.6), [33.528, -68.072]],
        [90.0, (77.216, 67.056), (-101.6, 101.6), [34.544, -67.056]],
        [270.0, (94.488, 3.048), (101.6, -101.6), [3.048, -98.552]],
    ],
    "SOLID": [[45.0, (0.0, 0.0), (-0.0883883476, 0.0883883476), []]],
    "SPANISH": [
        [
            274.9697,
            (28.0416, 30.48),
            (-30.4797350376, 365.7600320503),
            [28.14742656, -675.53802408],
        ],
        [180.0, (30.48, 2.4384), (-30.48, -30.48), [2.4384, -28.0416]],
        [0.0, (0.0, 0.0), (30.48, 30.48), [8.5344, -21.9456]],
        [90.0, (8.5344, 0.0), (-30.48, 30.48), [3.048, -27.432]],
        [270.0, (28.0416, 3.048), (30.48, -30.48), [3.048, -27.432]],
        [0.0, (28.0416, 0.0), (30.48, 30.48), [2.4384, -28.0416]],
        [0.0, (0.0, 2.4384), (30.48, 30.48), [6.096, -24.384]],
        [
            85.0303,
            (6.096, 2.4384),
            (30.4797350376, 365.7600320503),
            [28.14742656, -675.53802408],
        ],
        [
            52.6961,
            (6.096, 3.9624),
            (-396.2395699236, -518.1603274067),
            [8.04696384, -796.64814],
        ],
        [
            18.4349,
            (10.9728, 10.3632),
            (60.9600132464, 30.4799513302),
            [7.71089136, -88.6753116],
        ],
        [
            341.5651,
            (18.288, 12.8016),
            (-60.9600132464, 30.4799513302),
            [7.71089136, -88.6753116],
        ],
        [
            307.3039,
            (25.6032, 10.3632),
            (396.2395699236, -518.1603274067),
            [8.04696384, -796.64814],
        ],
        [
            20.2249,
            (12.4968, 8.2296),
            (-335.2799166169, -121.920254069),
            [6.1717428, -611.00122656],
        ],
        [
            339.7751,
            (18.288, 10.3632),
            (335.2799166169, -121.920254069),
            [6.1717428, -611.00122656],
        ],
        [
            307.4054,
            (24.0792, 8.2296),
            (304.8003033557, -396.2397703326),
            [6.52299432, -645.777474],
        ],
        [
            52.5946,
            (8.5344, 3.048),
            (-304.8003033557, -396.2397703326),
            [6.52299432, -645.777474],
        ],
    ],
    "SQUARE": [
        [0.0, (0.0, 0.0), (0.0, 3.175), [3.175, -3.175]],
        [90.0, (0.0, 0.0), (-3.175, 0.0), [3.175, -3.175]],
    ],
    "SQUARES": [
        [0.0, (0.0, 0.0), (0.0, 3.81), [3.81, -3.81]],
        [90.0, (0.0, 0.0), (-3.81, 0.0), [3.81, -3.81]],
    ],
    "STARS": [
        [0.0, (0.0, 0.0), (0.0, 5.4992613154), [3.175, -3.175]],
        [60.0, (0.0, 0.0), (-4.7625000012, 2.7496306577), [3.175, -3.175]],
        [
            120.0,
            (1.5875, 2.7496306704),
            (-4.7625000012, -2.7496306577),
            [3.175, -3.175],
        ],
    ],
    "STEEL": [
        [45.0, (0.0, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (4.318, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (4.572, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (4.826, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (5.08, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (5.334, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (5.588, 0.0), (-5.3881536726, 5.3881536726), []],
        [45.0, (5.842, 0.0), (-5.3881536726, 5.3881536726), []],
    ],
    "SWAMP": [
        [0.0, (0.0, 0.0), (12.7, 21.9970452362), [3.175, -22.225]],
        [90.0, (1.5875, 0.0), (-12.7, 21.9970452362), [1.5875, -42.4065904724]],
        [90.0, (1.984375, 0.0), (-12.7, 21.9970452362), [1.27, -42.7240904724]],
        [90.0, (1.190625, 0.0), (-12.7, 21.9970452362), [1.27, -42.7240904724]],
        [60.0, (2.38125, 0.0), (-12.6999999827, 21.9970452462), [1.016, -24.384]],
        [120.0, (0.79375, 0.0), (-25.3999999827, 1e-08), [1.016, -24.384]],
    ],
    "TILEPAT1": [
        [0.0, (5.7473088, 0.0), (24.384, 24.384), [37.2731792, -11.4948208]],
        [90.0, (0.0, 5.7473088), (-24.384, 24.384), [37.2731792, -11.4948208]],
        [
            45.0,
            (18.6366912, 24.384),
            (-24.3840535245, 24.3840535245),
            [8.128, -26.3562592],
        ],
        [
            315.0,
            (18.6366912, 24.384),
            (24.3840535245, 24.3840535245),
            [8.128, -26.3562592],
        ],
        [
            45.0,
            (24.384, 18.6366912),
            (-24.3840535245, 24.3840535245),
            [8.128, -26.3562592],
        ],
        [
            315.0,
            (24.384, 30.1313088),
            (24.3840535245, 24.3840535245),
            [8.128, -26.3562592],
        ],
    ],
    "TRANS": [
        [0.0, (0.0, 0.0), (0.0, 6.35), []],
        [0.0, (0.0, 3.175), (0.0, 6.35), [3.175, -3.175]],
    ],
    "TRIANG": [
        [60.0, (0.0, 0.0), (-4.7624999908, 8.2488919657), [4.7625, -4.7625]],
        [120.0, (0.0, 0.0), (-9.5249999908, 5.3e-09), [4.7625, -4.7625]],
        [0.0, (-2.38125, 4.1244459802), (4.7625, 8.2488919604), [4.7625, -4.7625]],
    ],
    "TRIANGLES": [
        [60.0, (0.0, 0.0), (-5.7149999889, 9.8986703589), [5.715, -5.715]],
        [120.0, (0.0, 0.0), (-11.4299999889, 6.4e-09), [5.715, -5.715]],
        [0.0, (-2.8575, 4.9493351762), (5.715, 9.8986703525), [5.715, -5.715]],
    ],
    "TRIHEX": [
        [30.0, (0.0, 0.0), (6.9e-09, 30.4799999881), [10.16, -20.32]],
        [30.0, (-8.7988181148, 15.24), (6.9e-09, 30.4799999881), [10.16, -20.32]],
        [90.0, (0.0, 20.32), (-26.3964542936, 15.24), [10.16, -20.32]],
        [90.0, (17.5976362296, 20.32), (-26.3964542936, 15.24), [10.16, -20.32]],
        [150.0, (0.0, 0.0), (-26.3964543005, -15.2399999881), [10.16, -20.32]],
        [
            150.0,
            (-8.7988181148, 15.24),
            (-26.3964543005, -15.2399999881),
            [10.16, -20.32],
        ],
    ],
    "V_BATTEN_FLOOR": [[0.0, (0.0, 0.0), (0.0, 15.0), []]],
    "V_MASONRY200x100": [
        [0.0, (0.0, 0.0), (0.0, 10.0), []],
        [90.0, (0.0, 0.0), (-10.0, 10.0), [10.0, -10.0]],
    ],
    "V_MASONRY200x60": [
        [0.0, (0.0, 0.0), (0.0, 6.0), []],
        [90.0, (0.0, 0.0), (-10.0, 6.0), [6.0, -6.0]],
    ],
    "V_MASONRY200x75": [
        [0.0, (0.0, 0.0), (0.0, 7.5), []],
        [90.0, (0.0, 0.0), (-10.0, 7.5), [7.5, -7.5]],
    ],
    "V_MASONRY220x80": [
        [0.0, (0.0, 0.0), (0.0, 8.0), []],
        [90.0, (0.0, 0.0), (-11.0, 8.0), [8.0, -8.0]],
    ],
    "V_MASONRY300x100": [
        [0.0, (0.0, 0.0), (0.0, 10.0), []],
        [90.0, (0.0, 0.0), (-15.0, 10.0), [10.0, -10.0]],
    ],
    "V_MASONRY300x150": [
        [0.0, (0.0, 0.0), (0.0, 15.0), []],
        [90.0, (0.0, 0.0), (-15.0, 15.0), [15.0, -15.0]],
    ],
    "V_MASONRY300x200": [
        [0.0, (0.0, 0.0), (0.0, 20.0), []],
        [90.0, (0.0, 0.0), (-15.0, 20.0), [20.0, -20.0]],
    ],
    "V_MASONRY300x75": [
        [0.0, (0.0, 0.0), (0.0, 7.5), []],
        [90.0, (0.0, 0.0), (-15.0, 7.5), [7.5, -7.5]],
    ],
    "V_MASONRY400x100": [
        [0.0, (0.0, 0.0), (0.0, 10.0), []],
        [90.0, (0.0, 0.0), (-20.0, 10.0), [10.0, -10.0]],
    ],
    "V_MASONRY400x200": [
        [0.0, (0.0, 0.0), (0.0, 20.0), []],
        [90.0, (0.0, 0.0), (-20.0, 20.0), [20.0, -20.0]],
    ],
    "V_PARQUET": [[0.0, (0.0, 0.0), (0.0, 15.0), []]],
    "V_STANDING_SEAM": [
        [90.0, (0.0, 0.0), (-55.0, 0.0), []],
        [90.0, (2.0, 0.0), (-55.0, 0.0), []],
    ],
    "V_ZINC": [
        [90.0, (0.0, 0.0), (-40.0, 0.0), []],
        [90.0, (0.0, 2.0), (-40.0, 0.0), []],
    ],
    "WAFFLE": [
        [0.0, (8.89, 6.35), (0.0, 15.24), [12.7, -2.54]],
        [0.0, (8.89, 8.89), (0.0, 15.24), [12.7, -2.54]],
        [90.0, (6.35, 8.89), (-15.24, 0.0), [12.7, -2.54]],
        [90.0, (8.89, 8.89), (-15.24, 0.0), [12.7, -2.54]],
    ],
    "WATER": [
        [0.0, (0.0, 0.0), (0.0, 20.32), [4.064, -16.256]],
        [45.0, (8.128, 2.032), (0.0, 20.3200000004), [5.747363918, -22.989455672]],
        [135.0, (16.256, 2.032), (-20.3200000004, 0.0), [5.747363918, -22.989455672]],
        [
            26.5650512,
            (4.064, 0.0),
            (20.3199999955, 1.72e-08),
            [4.543552, -40.8933492926],
        ],
        [
            333.4349488,
            (16.256, 2.032),
            (20.3199999955, -1.72e-08),
            [4.543552, -40.8933492926],
        ],
    ],
    "WOOD1": [
        [216.8699, (8.128, 20.32), (60.9599983302, 40.6400025047), [10.16, -91.44]],
        [
            206.5651,
            (20.32, 14.224),
            (-20.3199828894, -20.3200266069),
            [22.71845088, -22.71845088],
        ],
        [
            198.4349,
            (20.32, 4.064),
            (-40.6400088309, -20.3199675535),
            [12.85150592, -51.40598304],
        ],
    ],
    "WOOD2": [
        [
            108.4349,
            (5.2832, 0.0),
            (-20.3199675535, 40.6400088309),
            [7.71089136, -56.54657728],
        ],
        [
            139.3987,
            (2.8448, 7.3152),
            (-121.9199800489, 101.6000085595),
            [3.74682512, -183.59432928],
        ],
        [
            136.8476,
            (20.32, 9.7536),
            (-304.7999499622, 284.4800575845),
            [8.91304288, -436.73934496],
        ],
        [
            109.9831,
            (13.8176, 15.8496),
            (-60.9599889052, 162.5600133871),
            [4.75679008, -233.08271392],
        ],
        [90.0, (12.192, 0.0), (-20.32, 20.32), [4.064, -16.256]],
        [
            118.4429,
            (12.192, 4.064),
            (142.2398748065, -264.1600765238),
            [11.09256608, -543.53549408],
        ],
        [
            84.2894,
            (6.9088, 13.8176),
            (-20.320026714, -182.8799882854),
            [4.08427936, -200.12920096],
        ],
        [
            129.8056,
            (7.3152, 17.8816),
            (81.2800494301, -101.5999606056),
            [3.1740856, -155.5301944],
        ],
    ],
    "WOOD3": [
        [
            355.2364,
            (0.0, 9.4996),
            (-614.6800528803, 55.8795268451),
            [6.72884608, -666.15548252],
        ],
        [
            11.3099,
            (6.7056, 8.9408),
            (223.5200420347, 55.8798676852),
            [8.54801948, -276.38521812],
        ],
        [45.0, (15.0876, 10.6172), (0.0, 55.880017292), [6.32209556, -72.70412688]],
        [
            46.8476,
            (19.558, 15.0876),
            (782.3201583573, 838.199862396),
            [12.25543396, -1213.2886326],
        ],
        [
            12.9946,
            (27.94, 24.0284),
            (-502.9200429018, -111.7598646351),
            [7.45534196, -738.07684236],
        ],
        [0.0, (35.2044, 25.7048), (55.88, 55.88), [13.97, -41.91]],
        [
            350.5377,
            (49.1744, 25.7048),
            (-279.4000432341, 55.8798960186),
            [6.7980814, -333.10665916],
        ],
        [
            354.2894,
            (0.0, 24.5872),
            (-502.9199677849, 55.8800734636),
            [5.61588412, -555.97118676],
        ],
        [0.0, (5.588, 24.0284), (55.88, 55.88), [8.382, -47.498]],
        [
            28.3008,
            (13.97, 24.0284),
            (614.6797272924, 335.2804958908),
            [8.25057024, -816.807739],
        ],
        [
            52.125,
            (21.2344, 27.94),
            (-223.5201042102, -279.3999496738),
            [12.7425958, -624.38741772],
        ],
        [
            39.2894,
            (29.0576, 37.9984),
            (335.2800357399, 279.3999794311),
            [7.94205676, -786.26199872],
        ],
        [
            6.3402,
            (35.2044, 43.0276),
            (447.0399666176, 55.8800882323),
            [10.12031504, -495.89459876],
        ],
        [
            348.1113,
            (45.2628, 44.1452),
            (-782.3198491826, 167.6405887097),
            [10.8499402, -1074.14340924],
        ],
        [
            353.2902,
            (0.0, 41.91),
            (502.9200557543, -55.8796580839),
            [9.56509136, -946.9463916],
        ],
        [
            3.3665,
            (9.4996, 40.7924),
            (894.0799621116, 55.8806126322),
            [9.51602872, -942.08611684],
        ],
        [
            33.6901,
            (18.9992, 41.3512),
            (-111.7599752883, -55.8800745723),
            [10.07393464, -191.40431112],
        ],
        [
            47.4896,
            (27.3812, 46.9392),
            (558.7994813412, 614.6804846959),
            [9.09659344, -900.56386816],
        ],
        [
            14.9314,
            (33.528, 53.6448),
            (614.6800298916, 167.6398297883),
            [8.67492296, -858.81597604],
        ],
        [0.0, (41.91, 55.88), (55.88, 55.88), [6.7056, -49.1744]],
        [
            347.0054,
            (48.6156, 55.88),
            (502.9200429018, -111.7598646351),
            [7.45534196, -738.07684236],
        ],
        [0.0, (17.3228, 0.0), (55.88, 55.88), [0.0, -55.88]],
        [
            223.1524,
            (25.146, 8.382),
            (838.199862396, 782.3201583573),
            [12.25543396, -1213.2886326],
        ],
        [
            206.5651,
            (16.2052, 55.88),
            (-55.8799529457, -55.8800731691),
            [4.99807484, -119.953405],
        ],
        [
            188.1301,
            (11.7348, 53.6448),
            (-335.2799875086, -55.879964003),
            [7.90260548, -387.22861848],
        ],
        [
            156.8014,
            (3.9116, 52.5272),
            (-279.3999849497, 111.7600740558),
            [4.25570904, -421.3136862],
        ],
        [
            26.5651,
            (25.146, 8.382),
            (55.8799529457, 55.8800731691),
            [6.24755164, -118.7039282],
        ],
        [
            6.7098,
            (30.734, 11.176),
            (-502.9200557543, -55.8796580839),
            [9.56509136, -946.9463916],
        ],
        [
            349.8753,
            (40.2336, 12.2936),
            (949.9599323656, -167.6404799319),
            [15.89389252, -1573.49675648],
        ],
        [
            349.6952,
            (0.0, 3.3528),
            (335.2800536922, -55.879713645),
            [6.24755164, -618.50979168],
        ],
        [
            15.5241,
            (6.1468, 2.2352),
            (-614.6800572563, -167.6398758126),
            [10.4392222, -1033.48528888],
        ],
        [
            42.8789,
            (16.2052, 5.0292),
            (-726.4400443095, -670.5599862115),
            [10.675874, -1056.91001724],
        ],
        [
            34.6952,
            (24.0284, 12.2936),
            (558.7996791922, 391.1604811041),
            [8.83541032, -874.70495112],
        ],
        [
            9.4623,
            (31.2928, 17.3228),
            (279.4000432341, 55.8798960186),
            [10.19715004, -329.7076464],
        ],
        [
            353.4181,
            (41.3512, 18.9992),
            (-949.9600803515, 111.7592568165),
            [14.625193, -1447.8943864],
        ],
        [
            351.8699,
            (0.0, 17.3228),
            (-335.2799875086, 55.879964003),
            [7.90260548, -387.22861848],
        ],
        [
            11.3099,
            (7.8232, 16.2052),
            (223.5200420347, 55.8798676852),
            [8.54801948, -276.38521812],
        ],
        [
            42.5104,
            (16.2052, 17.8816),
            (-614.6804846959, -558.7994813412),
            [9.09659344, -900.56386816],
        ],
        [45.0, (22.9108, 24.0284), (0.0, 55.880017292), [10.27342624, -68.75285208]],
        [
            17.354,
            (30.1752, 31.2928),
            (-726.4401128271, -223.5196927862),
            [9.36722028, -927.35229312],
        ],
        [
            356.6335,
            (39.116, 34.0868),
            (-894.0799621116, 55.8806126322),
            [9.51602872, -942.08611684],
        ],
        [
            342.8973,
            (48.6156, 33.528),
            (558.8000967259, -167.6397481729),
            [7.6005182, -752.44968128],
        ],
        [
            351.2538,
            (0.0, 31.2928),
            (391.1599629156, -55.8802345316),
            [7.34984052, -727.63678196],
        ],
        [
            14.9314,
            (7.2644, 30.1752),
            (614.6800298916, 167.6398297883),
            [8.67492296, -858.81597604],
        ],
        [
            32.0054,
            (15.6464, 32.4104),
            (-279.3999410347, -167.6400617685),
            [10.5434384, -516.62747576],
        ],
        [
            49.8991,
            (24.5872, 37.9984),
            (-614.6798915808, -726.440107823),
            [13.8803126, -1374.1501092],
        ],
        [
            15.9454,
            (33.528, 48.6156),
            (-223.5200070773, -55.8799938139),
            [8.13623976, -398.67630704],
        ],
        [
            353.991,
            (41.3512, 50.8508),
            (558.7999860806, -55.8799618609),
            [10.675874, -1056.91001724],
        ],
        [
            336.8014,
            (51.9684, 49.7332),
            (279.3999849497, -111.7600740558),
            [4.25570904, -421.3136862],
        ],
        [
            350.5377,
            (0.0, 48.0568),
            (-279.4000432341, 55.8798960186),
            [6.7980814, -333.10665916],
        ],
        [
            10.008,
            (6.7056, 46.9392),
            (614.6799751096, 111.7601940241),
            [9.64639676, -954.991994],
        ],
        [
            37.4054,
            (16.2052, 48.6156),
            (726.4395789431, 558.8005561521),
            [11.95882292, -1183.925369],
        ],
        [
            29.0546,
            (25.7048, 0.0),
            (391.1600214898, 223.5200015199),
            [5.75318128, -569.56662312],
        ],
        [
            10.7843,
            (30.734, 2.794),
            (-894.0799722664, -167.6400307161),
            [11.94580288, -1182.63219404],
        ],
        [
            352.875,
            (42.4688, 5.0292),
            (-391.1600212258, 55.8799039922),
            [13.51558384, -437.0033932],
        ],
    ],
    "WOOD4": [
        [
            349.6952,
            (17.3228, 43.0276),
            (335.2800536922, -55.879713645),
            [6.24755164, -618.50979168],
        ],
        [0.0, (23.4696, 41.91), (55.88, 55.88), [6.1468, -49.7332]],
        [
            18.4349,
            (29.6164, 41.91),
            (111.7600242851, 55.8799107721),
            [5.30122384, -171.40681492],
        ],
        [
            172.875,
            (34.6456, 43.5864),
            (391.1600212258, -55.8799039922),
            [4.50521324, -446.0137638],
        ],
        [
            174.8056,
            (30.1752, 44.1452),
            (558.8000374421, -55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [
            194.0362,
            (24.0284, 44.704),
            (-167.6400305099, -55.8798914453),
            [6.91196484, -223.48714256],
        ],
        [
            9.4623,
            (21.7932, 43.0276),
            (279.4000432341, 55.8798960186),
            [3.39906864, -336.5057278],
        ],
        [
            353.6598,
            (25.146, 43.5864),
            (-447.0399666176, 55.8800882323),
            [5.06015752, -500.95475628],
        ],
        [
            185.7106,
            (30.1752, 43.0276),
            (-502.9199677849, -55.8800734636),
            [5.61588412, -555.97118676],
        ],
        [
            168.6901,
            (24.5872, 42.4688),
            (223.5200420347, -55.8798676852),
            [2.8493212, -282.08386052],
        ],
        [
            354.8056,
            (12.2936, 42.4688),
            (-558.8000374421, 55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [
            348.6901,
            (18.4404, 41.91),
            (-223.5200420347, 55.8798676852),
            [5.6986424, -279.23453932],
        ],
        [0.0, (24.0284, 40.7924), (55.88, 55.88), [6.7056, -49.1744]],
        [
            20.556,
            (30.734, 40.7924),
            (279.400103073, 111.75977628),
            [4.7743872, -472.66455632],
        ],
        [
            3.8141,
            (35.2044, 42.4688),
            (782.3199632, 55.8803422077),
            [8.40060804, -831.65997244],
        ],
        [
            354.8056,
            (43.5864, 43.0276),
            (-558.8000374421, 55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [0.0, (49.7332, 42.4688), (55.88, 55.88), [6.1468, -49.7332]],
        [
            5.1944,
            (0.0, 42.4688),
            (558.8000374421, 55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [
            354.8056,
            (6.1468, 43.0276),
            (-558.8000374421, 55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [0.0, (0.0, 43.5864), (55.88, 55.88), [3.3528, -52.5272]],
        [
            5.1944,
            (3.3528, 43.5864),
            (558.8000374421, 55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [0.0, (9.4996, 44.1452), (55.88, 55.88), [5.588, -50.292]],
        [
            10.3048,
            (15.0876, 44.1452),
            (-335.2800536922, -55.879713645),
            [6.24755164, -618.50979168],
        ],
        [
            5.1944,
            (21.2344, 45.2628),
            (558.8000374421, 55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [
            354.8056,
            (27.3812, 45.8216),
            (-558.8000374421, 55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [
            354.8056,
            (33.528, 45.2628),
            (-558.8000374421, 55.8797331562),
            [6.17216952, -611.04260316],
        ],
        [
            351.8699,
            (39.6748, 44.704),
            (-335.2799875086, 55.879964003),
            [7.90260548, -387.22861848],
        ],
        [0.0, (47.498, 43.5864), (55.88, 55.88), [8.382, -47.498]],
        [
            347.4712,
            (45.2628, 10.0584),
            (279.4000179045, -55.8799778181),
            [5.1518566, -510.03626212],
        ],
        [
            354.2894,
            (50.292, 8.9408),
            (-502.9199677849, 55.8800734636),
            [5.61588412, -555.97118676],
        ],
        [
            8.1301,
            (45.2628, 10.0584),
            (335.2799875086, 55.879964003),
            [3.95133068, -391.17994916],
        ],
        [
            9.4623,
            (49.1744, 10.6172),
            (279.4000432341, 55.8798960186),
            [6.7980814, -333.10665916],
        ],
        [0.0, (0.0, 11.7348), (55.88, 55.88), [6.7056, -49.1744]],
        [
            350.5377,
            (6.7056, 11.7348),
            (-279.4000432341, 55.8798960186),
            [3.39906864, -336.5057278],
        ],
        [
            201.8014,
            (10.0584, 11.176),
            (167.6400152558, 55.8799949988),
            [3.00924976, -297.91377044],
        ],
        [
            192.9946,
            (7.2644, 10.0584),
            (502.9200429018, 111.7598646351),
            [7.45534196, -738.07684236],
        ],
        [
            352.875,
            (51.4096, 10.0584),
            (-391.1600212258, 55.8799039922),
            [4.50521324, -446.0137638],
        ],
        [
            7.125,
            (51.4096, 10.0584),
            (391.1600212258, 55.8799039922),
            [4.50521324, -446.0137638],
        ],
        [0.0, (0.0, 10.6172), (55.88, 55.88), [4.4704, -51.4096]],
        [
            194.0362,
            (4.4704, 10.6172),
            (-167.6400305099, -55.8798914453),
            [4.60797656, -225.79118672],
        ],
        [
            356.6335,
            (12.2936, 12.2936),
            (-894.0799621116, 55.8806126322),
            [9.51602872, -942.08611684],
        ],
        [
            357.7094,
            (21.7932, 11.7348),
            (-1341.1200072183, 55.8797626847),
            [13.981176, -1384.13597696],
        ],
        [
            3.1798,
            (35.7632, 11.176),
            (949.9600280908, 55.8794994452),
            [10.07393464, -997.31712652],
        ],
        [
            9.4623,
            (45.8216, 11.7348),
            (279.4000432341, 55.8798960186),
            [10.19715004, -329.7076464],
        ],
        [
            10.3048,
            (0.0, 6.7056),
            (-335.2800536922, -55.879713645),
            [6.24755164, -618.50979168],
        ],
        [
            15.9454,
            (6.1468, 7.8232),
            (-223.5200070773, -55.8799938139),
            [8.13623976, -398.67630704],
        ],
        [0.0, (13.97, 10.0584), (55.88, 55.88), [7.2644, -48.6156]],
        [
            351.8699,
            (21.2344, 10.0584),
            (-335.2799875086, 55.879964003),
            [7.90260548, -387.22861848],
        ],
        [
            3.5763,
            (29.0576, 8.9408),
            (838.2000365642, 55.8794812845),
            [8.95823456, -886.86628316],
        ],
        [
            351.2538,
            (37.9984, 9.4996),
            (391.1599629156, -55.8802345316),
            [7.34984052, -727.63678196],
        ],
        [
            345.9638,
            (45.2628, 8.382),
            (-167.6400305099, 55.8798914453),
            [6.91196484, -223.48714256],
        ],
        [0.0, (51.9684, 6.7056), (55.88, 55.88), [3.9116, -51.9684]],
        [
            174.8056,
            (12.2936, 12.2936),
            (558.8000374421, -55.8797331562),
            [12.34428316, -604.87048952],
        ],
        [
            355.2364,
            (0.0, 15.6464),
            (-614.6800528803, 55.8795268451),
            [13.45769216, -659.42663644],
        ],
        [0.0, (13.4112, 14.5288), (55.88, 55.88), [12.8524, -43.0276]],
        [
            4.0856,
            (26.2636, 14.5288),
            (726.4400083269, 55.879783876),
            [15.68624244, -768.6268854],
        ],
        [0.0, (41.91, 15.6464), (55.88, 55.88), [13.97, -41.91]],
        [
            7.125,
            (0.0, 3.9116),
            (391.1600212258, 55.8799039922),
            [13.51558384, -437.0033932],
        ],
        [
            6.3402,
            (13.4112, 5.588),
            (447.0399666176, 55.8800882323),
            [10.12031504, -495.89459876],
        ],
        [
            357.5104,
            (23.4696, 6.7056),
            (-1229.3599709259, 55.8809983113),
            [12.86452596, -1273.58969056],
        ],
        [
            353.4802,
            (36.322, 6.1468),
            (-1452.879988314, 167.6399734706),
            [19.68529464, -1948.84584576],
        ],
        [
            3.0128,
            (0.0, 40.2336),
            (1005.8400006536, 55.8802293806),
            [10.63189644, -1052.5576358],
        ],
        [
            351.8699,
            (10.6172, 40.7924),
            (-335.2799875086, 55.879964003),
            [11.85393616, -383.27734368],
        ],
        [
            357.6141,
            (22.352, 39.116),
            (-1285.2400292741, 55.8790372189),
            [13.42282304, -1328.86082208],
        ],
        [
            10.6197,
            (35.7632, 38.5572),
            (-614.6799108501, -111.7604516847),
            [9.09659344, -900.56386816],
        ],
        [0.0, (44.704, 40.2336), (55.88, 55.88), [11.176, -44.704]],
        [
            356.8202,
            (0.0, 46.9392),
            (-949.9600280908, 55.8794994452),
            [10.07393464, -997.31712652],
        ],
        [
            6.009,
            (10.0584, 46.3804),
            (-558.7999860806, -55.8799618609),
            [10.675874, -1056.91001724],
        ],
        [
            6.7098,
            (20.6756, 47.498),
            (-502.9200557543, -55.8796580839),
            [9.56509136, -946.9463916],
        ],
        [
            354.2894,
            (30.1752, 48.6156),
            (-502.9199677849, 55.8800734636),
            [11.23176824, -550.35530264],
        ],
        [
            347.9052,
            (41.3512, 47.498),
            (-502.9199218582, 111.7603762673),
            [8.00078664, -792.07905084],
        ],
        [
            9.4623,
            (49.1744, 45.8216),
            (279.4000432341, 55.8798960186),
            [6.7980814, -333.10665916],
        ],
        [
            3.8141,
            (0.0, 36.322),
            (782.3199632, 55.8803422077),
            [8.40060804, -831.65997244],
        ],
        [
            347.1957,
            (8.382, 36.8808),
            (-726.4398796839, 167.6404128232),
            [12.6070868, -1248.10315784],
        ],
        [0.0, (20.6756, 34.0868), (55.88, 55.88), [13.97, -41.91]],
        [
            5.4403,
            (34.6456, 34.0868),
            (-614.6800174462, -55.879629585),
            [11.787886, -1167.00199924],
        ],
        [
            6.7098,
            (46.3804, 35.2044),
            (-502.9200557543, -55.8796580839),
            [9.56509136, -946.9463916],
        ],
        [0.0, (0.0, 50.8508), (55.88, 55.88), [9.4996, -46.3804]],
        [
            8.1301,
            (9.4996, 50.8508),
            (335.2799875086, 55.879964003),
            [15.80526684, -379.326013],
        ],
        [
            357.6141,
            (25.146, 53.086),
            (-1285.2400292741, 55.8790372189),
            [13.42282304, -1328.86082208],
        ],
        [
            354.4725,
            (38.5572, 52.5272),
            (1173.4800960801, -111.7591830157),
            [17.40371424, -1722.968995],
        ],
        [
            6.8428,
            (0.0, 0.0),
            (-949.9599645429, -111.760446924),
            [14.07024872, -1392.95222044],
        ],
        [0.0, (13.97, 1.6764), (55.88, 55.88), [15.6464, -40.2336]],
        [
            356.3478,
            (29.6164, 1.6764),
            (-1732.280052651, 111.7592902418),
            [26.31702128, -2605.38773308],
        ],
        [0.0, (0.0, 19.558), (55.88, 55.88), [13.4112, -42.4688]],
        [
            4.7636,
            (13.4112, 19.558),
            (614.6800528803, 55.8795268451),
            [13.45769216, -659.42663644],
        ],
        [
            358.1524,
            (26.8224, 20.6756),
            (-1676.4000259456, 55.8796837064),
            [17.33179668, -1715.84926832],
        ],
        [
            357.2737,
            (44.1452, 20.1168),
            (-1117.6000164831, 55.8797774706),
            [11.74809944, -1163.06162104],
        ],
        [
            354.8056,
            (0.0, 28.4988),
            (-558.8000374421, 55.8797331562),
            [12.34428316, -604.87048952],
        ],
        [0.0, (12.2936, 27.3812), (55.88, 55.88), [17.8816, -37.9984]],
        [
            1.9092,
            (30.1752, 27.3812),
            (1620.5199458846, 55.8813545915),
            [16.77333196, -1660.5577406],
        ],
        [
            3.5763,
            (46.9392, 27.94),
            (838.2000365642, 55.8794812845),
            [8.95823456, -886.86628316],
        ],
    ],
    "ZIGZAG": [
        [0.0, (0.0, 0.0), (6.35, 6.35), [6.35, -6.35]],
        [90.0, (6.35, 0.0), (-6.35, 6.35), [6.35, -6.35]],
    ],
}
