'''

The MIT License (MIT)

Copyright (c) 2016 Gehad Shaat

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

'''

def add_attributes_to_findings(findingArns=None, attributes=None):
    """
    Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
    
    
    :example: response = client.add_attributes_to_findings(
        findingArns=[
            'string',
        ],
        attributes=[
            {
                'key': 'string',
                'value': 'string'
            },
        ]
    )
    
    
    :type findingArns: list
    :param findingArns: [REQUIRED]
            The ARNs that specify the findings that you want to assign attributes to.
            (string) --
            

    :type attributes: list
    :param attributes: [REQUIRED]
            The array of attributes that you want to assign to specified findings.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) -- [REQUIRED]The attribute key.
            value (string) --The value assigned to the attribute key.
            
            

    :rtype: dict
    :return: {
        'failedItems': {
            'string': {
                'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                'retryable': True|False
            }
        }
    }
    
    
    """
    pass

def can_paginate(operation_name=None):
    """
    Check if an operation can be paginated.
    
    :type operation_name: string
    :param operation_name: The operation name. This is the same name
            as the method name on the client. For example, if the
            method name is create_foo, and you'd normally invoke the
            operation as client.create_foo(**kwargs), if the
            create_foo operation can be paginated, you can use the
            call client.get_paginator('create_foo').

    """
    pass

def create_assessment_target(assessmentTargetName=None, resourceGroupArn=None):
    """
    Creates a new assessment target using the ARN of the resource group that is generated by  CreateResourceGroup . You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see Amazon Inspector Assessment Targets .
    
    
    :example: response = client.create_assessment_target(
        assessmentTargetName='string',
        resourceGroupArn='string'
    )
    
    
    :type assessmentTargetName: string
    :param assessmentTargetName: [REQUIRED]
            The user-defined name that identifies the assessment target that you want to create. The name must be unique within the AWS account.
            

    :type resourceGroupArn: string
    :param resourceGroupArn: [REQUIRED]
            The ARN that specifies the resource group that is used to create the assessment target.
            

    :rtype: dict
    :return: {
        'assessmentTargetArn': 'string'
    }
    
    
    """
    pass

def create_assessment_template(assessmentTargetArn=None, assessmentTemplateName=None, durationInSeconds=None, rulesPackageArns=None, userAttributesForFindings=None):
    """
    Creates an assessment template for the assessment target that is specified by the ARN of the assessment target.
    
    
    :example: response = client.create_assessment_template(
        assessmentTargetArn='string',
        assessmentTemplateName='string',
        durationInSeconds=123,
        rulesPackageArns=[
            'string',
        ],
        userAttributesForFindings=[
            {
                'key': 'string',
                'value': 'string'
            },
        ]
    )
    
    
    :type assessmentTargetArn: string
    :param assessmentTargetArn: [REQUIRED]
            The ARN that specifies the assessment target for which you want to create the assessment template.
            

    :type assessmentTemplateName: string
    :param assessmentTemplateName: [REQUIRED]
            The user-defined name that identifies the assessment template that you want to create. You can create several assessment templates for an assessment target. The names of the assessment templates that correspond to a particular assessment target must be unique.
            

    :type durationInSeconds: integer
    :param durationInSeconds: [REQUIRED]
            The duration of the assessment run in seconds. The default value is 3600 seconds (one hour).
            

    :type rulesPackageArns: list
    :param rulesPackageArns: [REQUIRED]
            The ARNs that specify the rules packages that you want to attach to the assessment template.
            (string) --
            

    :type userAttributesForFindings: list
    :param userAttributesForFindings: The user-defined attributes that are assigned to every finding that is generated by the assessment run that uses this assessment template.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) -- [REQUIRED]The attribute key.
            value (string) --The value assigned to the attribute key.
            
            

    :rtype: dict
    :return: {
        'assessmentTemplateArn': 'string'
    }
    
    
    """
    pass

def create_resource_group(resourceGroupTags=None):
    """
    Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see  CreateAssessmentTarget .
    
    
    :example: response = client.create_resource_group(
        resourceGroupTags=[
            {
                'key': 'string',
                'value': 'string'
            },
        ]
    )
    
    
    :type resourceGroupTags: list
    :param resourceGroupTags: [REQUIRED]
            A collection of keys and an array of possible values, '[{'key':'key1','values':['Value1','Value2']},{'key':'Key2','values':['Value3']}]'.
            For example,'[{'key':'Name','values':['TestEC2Instance']}]'.
            (dict) --This data type is used as one of the elements of the ResourceGroup data type.
            key (string) -- [REQUIRED]A tag key.
            value (string) --The value assigned to a tag key.
            
            

    :rtype: dict
    :return: {
        'resourceGroupArn': 'string'
    }
    
    
    """
    pass

def delete_assessment_run(assessmentRunArn=None):
    """
    Deletes the assessment run that is specified by the ARN of the assessment run.
    
    
    :example: response = client.delete_assessment_run(
        assessmentRunArn='string'
    )
    
    
    :type assessmentRunArn: string
    :param assessmentRunArn: [REQUIRED]
            The ARN that specifies the assessment run that you want to delete.
            

    """
    pass

def delete_assessment_target(assessmentTargetArn=None):
    """
    Deletes the assessment target that is specified by the ARN of the assessment target.
    
    
    :example: response = client.delete_assessment_target(
        assessmentTargetArn='string'
    )
    
    
    :type assessmentTargetArn: string
    :param assessmentTargetArn: [REQUIRED]
            The ARN that specifies the assessment target that you want to delete.
            

    """
    pass

def delete_assessment_template(assessmentTemplateArn=None):
    """
    Deletes the assessment template that is specified by the ARN of the assessment template.
    
    
    :example: response = client.delete_assessment_template(
        assessmentTemplateArn='string'
    )
    
    
    :type assessmentTemplateArn: string
    :param assessmentTemplateArn: [REQUIRED]
            The ARN that specifies the assessment template that you want to delete.
            

    """
    pass

def describe_assessment_runs(assessmentRunArns=None):
    """
    Describes the assessment runs that are specified by the ARNs of the assessment runs.
    
    
    :example: response = client.describe_assessment_runs(
        assessmentRunArns=[
            'string',
        ]
    )
    
    
    :type assessmentRunArns: list
    :param assessmentRunArns: [REQUIRED]
            The ARN that specifies the assessment run that you want to describe.
            (string) --
            

    :rtype: dict
    :return: {
        'assessmentRuns': [
            {
                'arn': 'string',
                'name': 'string',
                'assessmentTemplateArn': 'string',
                'state': 'CREATED'|'START_DATA_COLLECTION_PENDING'|'START_DATA_COLLECTION_IN_PROGRESS'|'COLLECTING_DATA'|'STOP_DATA_COLLECTION_PENDING'|'DATA_COLLECTED'|'EVALUATING_RULES'|'FAILED'|'COMPLETED'|'COMPLETED_WITH_ERRORS',
                'durationInSeconds': 123,
                'rulesPackageArns': [
                    'string',
                ],
                'userAttributesForFindings': [
                    {
                        'key': 'string',
                        'value': 'string'
                    },
                ],
                'createdAt': datetime(2015, 1, 1),
                'startedAt': datetime(2015, 1, 1),
                'completedAt': datetime(2015, 1, 1),
                'stateChangedAt': datetime(2015, 1, 1),
                'dataCollected': True|False,
                'stateChanges': [
                    {
                        'stateChangedAt': datetime(2015, 1, 1),
                        'state': 'CREATED'|'START_DATA_COLLECTION_PENDING'|'START_DATA_COLLECTION_IN_PROGRESS'|'COLLECTING_DATA'|'STOP_DATA_COLLECTION_PENDING'|'DATA_COLLECTED'|'EVALUATING_RULES'|'FAILED'|'COMPLETED'|'COMPLETED_WITH_ERRORS'
                    },
                ],
                'notifications': [
                    {
                        'date': datetime(2015, 1, 1),
                        'event': 'ASSESSMENT_RUN_STARTED'|'ASSESSMENT_RUN_COMPLETED'|'ASSESSMENT_RUN_STATE_CHANGED'|'FINDING_REPORTED'|'OTHER',
                        'message': 'string',
                        'error': True|False,
                        'snsTopicArn': 'string',
                        'snsPublishStatusCode': 'SUCCESS'|'TOPIC_DOES_NOT_EXIST'|'ACCESS_DENIED'|'INTERNAL_ERROR'
                    },
                ]
            },
        ],
        'failedItems': {
            'string': {
                'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                'retryable': True|False
            }
        }
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def describe_assessment_targets(assessmentTargetArns=None):
    """
    Describes the assessment targets that are specified by the ARNs of the assessment targets.
    
    
    :example: response = client.describe_assessment_targets(
        assessmentTargetArns=[
            'string',
        ]
    )
    
    
    :type assessmentTargetArns: list
    :param assessmentTargetArns: [REQUIRED]
            The ARNs that specifies the assessment targets that you want to describe.
            (string) --
            

    :rtype: dict
    :return: {
        'assessmentTargets': [
            {
                'arn': 'string',
                'name': 'string',
                'resourceGroupArn': 'string',
                'createdAt': datetime(2015, 1, 1),
                'updatedAt': datetime(2015, 1, 1)
            },
        ],
        'failedItems': {
            'string': {
                'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                'retryable': True|False
            }
        }
    }
    
    
    """
    pass

def describe_assessment_templates(assessmentTemplateArns=None):
    """
    Describes the assessment templates that are specified by the ARNs of the assessment templates.
    
    
    :example: response = client.describe_assessment_templates(
        assessmentTemplateArns=[
            'string',
        ]
    )
    
    
    :type assessmentTemplateArns: list
    :param assessmentTemplateArns: [REQUIRED]
            The ARN that specifiesthe assessment templates that you want to describe.
            (string) --
            

    :rtype: dict
    :return: {
        'assessmentTemplates': [
            {
                'arn': 'string',
                'name': 'string',
                'assessmentTargetArn': 'string',
                'durationInSeconds': 123,
                'rulesPackageArns': [
                    'string',
                ],
                'userAttributesForFindings': [
                    {
                        'key': 'string',
                        'value': 'string'
                    },
                ],
                'createdAt': datetime(2015, 1, 1)
            },
        ],
        'failedItems': {
            'string': {
                'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                'retryable': True|False
            }
        }
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def describe_cross_account_access_role():
    """
    Describes the IAM role that enables Amazon Inspector to access your AWS account.
    
    
    :example: response = client.describe_cross_account_access_role()
    
    
    :rtype: dict
    :return: {
        'roleArn': 'string',
        'valid': True|False,
        'registeredAt': datetime(2015, 1, 1)
    }
    
    
    """
    pass

def describe_findings(findingArns=None, locale=None):
    """
    Describes the findings that are specified by the ARNs of the findings.
    
    
    :example: response = client.describe_findings(
        findingArns=[
            'string',
        ],
        locale='EN_US'
    )
    
    
    :type findingArns: list
    :param findingArns: [REQUIRED]
            The ARN that specifies the finding that you want to describe.
            (string) --
            

    :type locale: string
    :param locale: The locale into which you want to translate a finding description, recommendation, and the short description that identifies the finding.

    :rtype: dict
    :return: {
        'findings': [
            {
                'arn': 'string',
                'schemaVersion': 123,
                'service': 'string',
                'serviceAttributes': {
                    'schemaVersion': 123,
                    'assessmentRunArn': 'string',
                    'rulesPackageArn': 'string'
                },
                'assetType': 'ec2-instance',
                'assetAttributes': {
                    'schemaVersion': 123,
                    'agentId': 'string',
                    'autoScalingGroup': 'string',
                    'amiId': 'string',
                    'hostname': 'string',
                    'ipv4Addresses': [
                        'string',
                    ]
                },
                'id': 'string',
                'title': 'string',
                'description': 'string',
                'recommendation': 'string',
                'severity': 'Low'|'Medium'|'High'|'Informational'|'Undefined',
                'numericSeverity': 123.0,
                'confidence': 123,
                'indicatorOfCompromise': True|False,
                'attributes': [
                    {
                        'key': 'string',
                        'value': 'string'
                    },
                ],
                'userAttributes': [
                    {
                        'key': 'string',
                        'value': 'string'
                    },
                ],
                'createdAt': datetime(2015, 1, 1),
                'updatedAt': datetime(2015, 1, 1)
            },
        ],
        'failedItems': {
            'string': {
                'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                'retryable': True|False
            }
        }
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def describe_resource_groups(resourceGroupArns=None):
    """
    Describes the resource groups that are specified by the ARNs of the resource groups.
    
    
    :example: response = client.describe_resource_groups(
        resourceGroupArns=[
            'string',
        ]
    )
    
    
    :type resourceGroupArns: list
    :param resourceGroupArns: [REQUIRED]
            The ARN that specifies the resource group that you want to describe.
            (string) --
            

    :rtype: dict
    :return: {
        'resourceGroups': [
            {
                'arn': 'string',
                'tags': [
                    {
                        'key': 'string',
                        'value': 'string'
                    },
                ],
                'createdAt': datetime(2015, 1, 1)
            },
        ],
        'failedItems': {
            'string': {
                'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                'retryable': True|False
            }
        }
    }
    
    
    """
    pass

def describe_rules_packages(rulesPackageArns=None, locale=None):
    """
    Describes the rules packages that are specified by the ARNs of the rules packages.
    
    
    :example: response = client.describe_rules_packages(
        rulesPackageArns=[
            'string',
        ],
        locale='EN_US'
    )
    
    
    :type rulesPackageArns: list
    :param rulesPackageArns: [REQUIRED]
            The ARN that specifies the rules package that you want to describe.
            (string) --
            

    :type locale: string
    :param locale: The locale that you want to translate a rules package description into.

    :rtype: dict
    :return: {
        'rulesPackages': [
            {
                'arn': 'string',
                'name': 'string',
                'version': 'string',
                'provider': 'string',
                'description': 'string'
            },
        ],
        'failedItems': {
            'string': {
                'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                'retryable': True|False
            }
        }
    }
    
    
    """
    pass

def generate_presigned_url(ClientMethod=None, Params=None, ExpiresIn=None, HttpMethod=None):
    """
    Generate a presigned url given a client, its method, and arguments
    
    :type ClientMethod: string
    :param ClientMethod: The client method to presign for

    :type Params: dict
    :param Params: The parameters normally passed to
            ClientMethod.

    :type ExpiresIn: int
    :param ExpiresIn: The number of seconds the presigned url is valid
            for. By default it expires in an hour (3600 seconds)

    :type HttpMethod: string
    :param HttpMethod: The http method to use on the generated url. By
            default, the http method is whatever is used in the method's model.

    """
    pass

def get_paginator(operation_name=None):
    """
    Create a paginator for an operation.
    
    :type operation_name: string
    :param operation_name: The operation name. This is the same name
            as the method name on the client. For example, if the
            method name is create_foo, and you'd normally invoke the
            operation as client.create_foo(**kwargs), if the
            create_foo operation can be paginated, you can use the
            call client.get_paginator('create_foo').

    :rtype: L{botocore.paginate.Paginator}
    """
    pass

def get_telemetry_metadata(assessmentRunArn=None):
    """
    Information about the data that is collected for the specified assessment run.
    
    
    :example: response = client.get_telemetry_metadata(
        assessmentRunArn='string'
    )
    
    
    :type assessmentRunArn: string
    :param assessmentRunArn: [REQUIRED]
            The ARN that specifies the assessment run that has the telemetry data that you want to obtain.
            

    :rtype: dict
    :return: {
        'telemetryMetadata': [
            {
                'messageType': 'string',
                'count': 123,
                'dataSize': 123
            },
        ]
    }
    
    
    """
    pass

def get_waiter():
    """
    
    """
    pass

def list_assessment_run_agents(assessmentRunArn=None, filter=None, nextToken=None, maxResults=None):
    """
    Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
    
    
    :example: response = client.list_assessment_run_agents(
        assessmentRunArn='string',
        filter={
            'agentHealths': [
                'HEALTHY'|'UNHEALTHY',
            ],
            'agentHealthCodes': [
                'IDLE'|'RUNNING'|'SHUTDOWN'|'UNHEALTHY'|'THROTTLED'|'UNKNOWN',
            ]
        },
        nextToken='string',
        maxResults=123
    )
    
    
    :type assessmentRunArn: string
    :param assessmentRunArn: [REQUIRED]
            The ARN that specifies the assessment run whose agents you want to list.
            

    :type filter: dict
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            agentHealths (list) -- [REQUIRED]The current health state of the agent. Values can be set to HEALTHY or UNHEALTHY .
            (string) --
            agentHealthCodes (list) -- [REQUIRED]The detailed health state of the agent. Values can be set to IDLE , RUNNING , SHUTDOWN , UNHEALTHY , THROTTLED , and UNKNOWN .
            (string) --
            

    :type nextToken: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentRunAgents action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.

    :type maxResults: integer
    :param maxResults: You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.

    :rtype: dict
    :return: {
        'assessmentRunAgents': [
            {
                'agentId': 'string',
                'assessmentRunArn': 'string',
                'agentHealth': 'HEALTHY'|'UNHEALTHY',
                'agentHealthCode': 'IDLE'|'RUNNING'|'SHUTDOWN'|'UNHEALTHY'|'THROTTLED'|'UNKNOWN',
                'agentHealthDetails': 'string',
                'autoScalingGroup': 'string',
                'telemetryMetadata': [
                    {
                        'messageType': 'string',
                        'count': 123,
                        'dataSize': 123
                    },
                ]
            },
        ],
        'nextToken': 'string'
    }
    
    
    """
    pass

def list_assessment_runs(assessmentTemplateArns=None, filter=None, nextToken=None, maxResults=None):
    """
    Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
    
    
    :example: response = client.list_assessment_runs(
        assessmentTemplateArns=[
            'string',
        ],
        filter={
            'namePattern': 'string',
            'states': [
                'CREATED'|'START_DATA_COLLECTION_PENDING'|'START_DATA_COLLECTION_IN_PROGRESS'|'COLLECTING_DATA'|'STOP_DATA_COLLECTION_PENDING'|'DATA_COLLECTED'|'EVALUATING_RULES'|'FAILED'|'COMPLETED'|'COMPLETED_WITH_ERRORS',
            ],
            'durationRange': {
                'minSeconds': 123,
                'maxSeconds': 123
            },
            'rulesPackageArns': [
                'string',
            ],
            'startTimeRange': {
                'beginDate': datetime(2015, 1, 1),
                'endDate': datetime(2015, 1, 1)
            },
            'completionTimeRange': {
                'beginDate': datetime(2015, 1, 1),
                'endDate': datetime(2015, 1, 1)
            },
            'stateChangeTimeRange': {
                'beginDate': datetime(2015, 1, 1),
                'endDate': datetime(2015, 1, 1)
            }
        },
        nextToken='string',
        maxResults=123
    )
    
    
    :type assessmentTemplateArns: list
    :param assessmentTemplateArns: The ARNs that specify the assessment templates whose assessment runs you want to list.
            (string) --
            

    :type filter: dict
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            namePattern (string) --For a record to match a filter, an explicit value or a string containing a wildcard that is specified for this data type property must match the value of the assessmentRunName property of the AssessmentRun data type.
            states (list) --For a record to match a filter, one of the values specified for this data type property must be the exact match of the value of the assessmentRunState property of the AssessmentRun data type.
            (string) --
            durationRange (dict) --For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the durationInSeconds property of the AssessmentRun data type.
            minSeconds (integer) --The minimum value of the duration range. Must be greater than zero.
            maxSeconds (integer) --The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).
            rulesPackageArns (list) --For a record to match a filter, the value that is specified for this data type property must be contained in the list of values of the rulesPackages property of the AssessmentRun data type.
            (string) --
            startTimeRange (dict) --For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the startTime property of the AssessmentRun data type.
            beginDate (datetime) --The minimum value of the timestamp range.
            endDate (datetime) --The maximum value of the timestamp range.
            completionTimeRange (dict) --For a record to match a filter, the value that is specified for this data type property must inclusively match any value between the specified minimum and maximum values of the completedAt property of the AssessmentRun data type.
            beginDate (datetime) --The minimum value of the timestamp range.
            endDate (datetime) --The maximum value of the timestamp range.
            stateChangeTimeRange (dict) --For a record to match a filter, the value that is specified for this data type property must match the stateChangedAt property of the AssessmentRun data type.
            beginDate (datetime) --The minimum value of the timestamp range.
            endDate (datetime) --The maximum value of the timestamp range.
            
            

    :type nextToken: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentRuns action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.

    :type maxResults: integer
    :param maxResults: You can use this parameter to indicate the maximum number of items that you want in the response. The default value is 10. The maximum value is 500.

    :rtype: dict
    :return: {
        'assessmentRunArns': [
            'string',
        ],
        'nextToken': 'string'
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def list_assessment_targets(filter=None, nextToken=None, maxResults=None):
    """
    Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see Amazon Inspector Assessment Targets .
    
    
    :example: response = client.list_assessment_targets(
        filter={
            'assessmentTargetNamePattern': 'string'
        },
        nextToken='string',
        maxResults=123
    )
    
    
    :type filter: dict
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            assessmentTargetNamePattern (string) --For a record to match a filter, an explicit value or a string that contains a wildcard that is specified for this data type property must match the value of the assessmentTargetName property of the AssessmentTarget data type.
            

    :type nextToken: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentTargets action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.

    :type maxResults: integer
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.

    :rtype: dict
    :return: {
        'assessmentTargetArns': [
            'string',
        ],
        'nextToken': 'string'
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def list_assessment_templates(assessmentTargetArns=None, filter=None, nextToken=None, maxResults=None):
    """
    Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
    
    
    :example: response = client.list_assessment_templates(
        assessmentTargetArns=[
            'string',
        ],
        filter={
            'namePattern': 'string',
            'durationRange': {
                'minSeconds': 123,
                'maxSeconds': 123
            },
            'rulesPackageArns': [
                'string',
            ]
        },
        nextToken='string',
        maxResults=123
    )
    
    
    :type assessmentTargetArns: list
    :param assessmentTargetArns: A list of ARNs that specifies the assessment targets whose assessment templates you want to list.
            (string) --
            

    :type filter: dict
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            namePattern (string) --For a record to match a filter, an explicit value or a string that contains a wildcard that is specified for this data type property must match the value of the assessmentTemplateName property of the AssessmentTemplate data type.
            durationRange (dict) --For a record to match a filter, the value specified for this data type property must inclusively match any value between the specified minimum and maximum values of the durationInSeconds property of the AssessmentTemplate data type.
            minSeconds (integer) --The minimum value of the duration range. Must be greater than zero.
            maxSeconds (integer) --The maximum value of the duration range. Must be less than or equal to 604800 seconds (1 week).
            rulesPackageArns (list) --For a record to match a filter, the values that are specified for this data type property must be contained in the list of values of the rulesPackageArns property of the AssessmentTemplate data type.
            (string) --
            

    :type nextToken: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListAssessmentTemplates action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.

    :type maxResults: integer
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.

    :rtype: dict
    :return: {
        'assessmentTemplateArns': [
            'string',
        ],
        'nextToken': 'string'
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def list_event_subscriptions(resourceArn=None, nextToken=None, maxResults=None):
    """
    Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see  SubscribeToEvent and  UnsubscribeFromEvent .
    
    
    :example: response = client.list_event_subscriptions(
        resourceArn='string',
        nextToken='string',
        maxResults=123
    )
    
    
    :type resourceArn: string
    :param resourceArn: The ARN of the assessment template for which you want to list the existing event subscriptions.

    :type nextToken: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListEventSubscriptions action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.

    :type maxResults: integer
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.

    :rtype: dict
    :return: {
        'subscriptions': [
            {
                'resourceArn': 'string',
                'topicArn': 'string',
                'eventSubscriptions': [
                    {
                        'event': 'ASSESSMENT_RUN_STARTED'|'ASSESSMENT_RUN_COMPLETED'|'ASSESSMENT_RUN_STATE_CHANGED'|'FINDING_REPORTED'|'OTHER',
                        'subscribedAt': datetime(2015, 1, 1)
                    },
                ]
            },
        ],
        'nextToken': 'string'
    }
    
    
    """
    pass

def list_findings(assessmentRunArns=None, filter=None, nextToken=None, maxResults=None):
    """
    Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
    
    
    :example: response = client.list_findings(
        assessmentRunArns=[
            'string',
        ],
        filter={
            'agentIds': [
                'string',
            ],
            'autoScalingGroups': [
                'string',
            ],
            'ruleNames': [
                'string',
            ],
            'severities': [
                'Low'|'Medium'|'High'|'Informational'|'Undefined',
            ],
            'rulesPackageArns': [
                'string',
            ],
            'attributes': [
                {
                    'key': 'string',
                    'value': 'string'
                },
            ],
            'userAttributes': [
                {
                    'key': 'string',
                    'value': 'string'
                },
            ],
            'creationTimeRange': {
                'beginDate': datetime(2015, 1, 1),
                'endDate': datetime(2015, 1, 1)
            }
        },
        nextToken='string',
        maxResults=123
    )
    
    
    :type assessmentRunArns: list
    :param assessmentRunArns: The ARNs of the assessment runs that generate the findings that you want to list.
            (string) --
            

    :type filter: dict
    :param filter: You can use this parameter to specify a subset of data to be included in the action's response.
            For a record to match a filter, all specified filter attributes must match. When multiple values are specified for a filter attribute, any of the values can match.
            agentIds (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the agentId property of the Finding data type.
            (string) --
            autoScalingGroups (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the autoScalingGroup property of the Finding data type.
            (string) --
            ruleNames (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the ruleName property of the Finding data type.
            (string) --
            severities (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the severity property of the Finding data type.
            (string) --
            rulesPackageArns (list) --For a record to match a filter, one of the values that is specified for this data type property must be the exact match of the value of the rulesPackageArn property of the Finding data type.
            (string) --
            attributes (list) --For a record to match a filter, the list of values that are specified for this data type property must be contained in the list of values of the attributes property of the Finding data type.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) -- [REQUIRED]The attribute key.
            value (string) --The value assigned to the attribute key.
            
            userAttributes (list) --For a record to match a filter, the value that is specified for this data type property must be contained in the list of values of the userAttributes property of the Finding data type.
            (dict) --This data type is used as a request parameter in the AddAttributesToFindings and CreateAssessmentTemplate actions.
            key (string) -- [REQUIRED]The attribute key.
            value (string) --The value assigned to the attribute key.
            
            creationTimeRange (dict) --The time range during which the finding is generated.
            beginDate (datetime) --The minimum value of the timestamp range.
            endDate (datetime) --The maximum value of the timestamp range.
            
            

    :type nextToken: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListFindings action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.

    :type maxResults: integer
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.

    :rtype: dict
    :return: {
        'findingArns': [
            'string',
        ],
        'nextToken': 'string'
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def list_rules_packages(nextToken=None, maxResults=None):
    """
    Lists all available Amazon Inspector rules packages.
    
    
    :example: response = client.list_rules_packages(
        nextToken='string',
        maxResults=123
    )
    
    
    :type nextToken: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListRulesPackages action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.

    :type maxResults: integer
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.

    :rtype: dict
    :return: {
        'rulesPackageArns': [
            'string',
        ],
        'nextToken': 'string'
    }
    
    
    :returns: 
    (string) --
    
    """
    pass

def list_tags_for_resource(resourceArn=None):
    """
    Lists all tags associated with an assessment template.
    
    
    :example: response = client.list_tags_for_resource(
        resourceArn='string'
    )
    
    
    :type resourceArn: string
    :param resourceArn: [REQUIRED]
            The ARN that specifies the assessment template whose tags you want to list.
            

    :rtype: dict
    :return: {
        'tags': [
            {
                'key': 'string',
                'value': 'string'
            },
        ]
    }
    
    
    """
    pass

def preview_agents(previewAgentsArn=None, nextToken=None, maxResults=None):
    """
    Previews the agents installed on the EC2 instances that are part of the specified assessment target.
    
    
    :example: response = client.preview_agents(
        previewAgentsArn='string',
        nextToken='string',
        maxResults=123
    )
    
    
    :type previewAgentsArn: string
    :param previewAgentsArn: [REQUIRED]
            The ARN of the assessment target whose agents you want to preview.
            

    :type nextToken: string
    :param nextToken: You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the PreviewAgents action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.

    :type maxResults: integer
    :param maxResults: You can use this parameter to indicate the maximum number of items you want in the response. The default value is 10. The maximum value is 500.

    :rtype: dict
    :return: {
        'agentPreviews': [
            {
                'agentId': 'string',
                'autoScalingGroup': 'string'
            },
        ],
        'nextToken': 'string'
    }
    
    
    """
    pass

def register_cross_account_access_role(roleArn=None):
    """
    Registers the IAM role that Amazon Inspector uses to list your EC2 instances at the start of the assessment run or when you call the  PreviewAgents action.
    
    
    :example: response = client.register_cross_account_access_role(
        roleArn='string'
    )
    
    
    :type roleArn: string
    :param roleArn: [REQUIRED]
            The ARN of the IAM role that Amazon Inspector uses to list your EC2 instances during the assessment run or when you call the PreviewAgents action.
            

    """
    pass

def remove_attributes_from_findings(findingArns=None, attributeKeys=None):
    """
    Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
    
    
    :example: response = client.remove_attributes_from_findings(
        findingArns=[
            'string',
        ],
        attributeKeys=[
            'string',
        ]
    )
    
    
    :type findingArns: list
    :param findingArns: [REQUIRED]
            The ARNs that specify the findings that you want to remove attributes from.
            (string) --
            

    :type attributeKeys: list
    :param attributeKeys: [REQUIRED]
            The array of attribute keys that you want to remove from specified findings.
            (string) --
            

    :rtype: dict
    :return: {
        'failedItems': {
            'string': {
                'failureCode': 'INVALID_ARN'|'DUPLICATE_ARN'|'ITEM_DOES_NOT_EXIST'|'ACCESS_DENIED'|'LIMIT_EXCEEDED'|'INTERNAL_ERROR',
                'retryable': True|False
            }
        }
    }
    
    
    """
    pass

def set_tags_for_resource(resourceArn=None, tags=None):
    """
    Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
    
    
    :example: response = client.set_tags_for_resource(
        resourceArn='string',
        tags=[
            {
                'key': 'string',
                'value': 'string'
            },
        ]
    )
    
    
    :type resourceArn: string
    :param resourceArn: [REQUIRED]
            The ARN of the assessment template that you want to set tags to.
            

    :type tags: list
    :param tags: A collection of key and value pairs that you want to set to the assessment template.
            (dict) --A key and value pair. This data type is used as a request parameter in the SetTagsForResource action and a response element in the ListTagsForResource action.
            key (string) -- [REQUIRED]A tag key.
            value (string) --A value assigned to a tag key.
            
            

    """
    pass

def start_assessment_run(assessmentTemplateArn=None, assessmentRunName=None):
    """
    Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.
    
    
    :example: response = client.start_assessment_run(
        assessmentTemplateArn='string',
        assessmentRunName='string'
    )
    
    
    :type assessmentTemplateArn: string
    :param assessmentTemplateArn: [REQUIRED]
            The ARN of the assessment template of the assessment run that you want to start.
            

    :type assessmentRunName: string
    :param assessmentRunName: You can specify the name for the assessment run, or you can use the auto-generated name that is based on the assessment template name. The name must be unique for the assessment template.

    :rtype: dict
    :return: {
        'assessmentRunArn': 'string'
    }
    
    
    """
    pass

def stop_assessment_run(assessmentRunArn=None):
    """
    Stops the assessment run that is specified by the ARN of the assessment run.
    
    
    :example: response = client.stop_assessment_run(
        assessmentRunArn='string'
    )
    
    
    :type assessmentRunArn: string
    :param assessmentRunArn: [REQUIRED]
            The ARN of the assessment run that you want to stop.
            

    """
    pass

def subscribe_to_event(resourceArn=None, event=None, topicArn=None):
    """
    Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
    
    
    :example: response = client.subscribe_to_event(
        resourceArn='string',
        event='ASSESSMENT_RUN_STARTED'|'ASSESSMENT_RUN_COMPLETED'|'ASSESSMENT_RUN_STATE_CHANGED'|'FINDING_REPORTED'|'OTHER',
        topicArn='string'
    )
    
    
    :type resourceArn: string
    :param resourceArn: [REQUIRED]
            The ARN of the assessment template that is used during the event for which you want to receive SNS notifications.
            

    :type event: string
    :param event: [REQUIRED]
            The event for which you want to receive SNS notifications.
            

    :type topicArn: string
    :param topicArn: [REQUIRED]
            The ARN of the SNS topic to which the SNS notifications are sent.
            

    """
    pass

def unsubscribe_from_event(resourceArn=None, event=None, topicArn=None):
    """
    Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
    
    
    :example: response = client.unsubscribe_from_event(
        resourceArn='string',
        event='ASSESSMENT_RUN_STARTED'|'ASSESSMENT_RUN_COMPLETED'|'ASSESSMENT_RUN_STATE_CHANGED'|'FINDING_REPORTED'|'OTHER',
        topicArn='string'
    )
    
    
    :type resourceArn: string
    :param resourceArn: [REQUIRED]
            The ARN of the assessment template that is used during the event for which you want to stop receiving SNS notifications.
            

    :type event: string
    :param event: [REQUIRED]
            The event for which you want to stop receiving SNS notifications.
            

    :type topicArn: string
    :param topicArn: [REQUIRED]
            The ARN of the SNS topic to which SNS notifications are sent.
            

    """
    pass

def update_assessment_target(assessmentTargetArn=None, assessmentTargetName=None, resourceGroupArn=None):
    """
    Updates the assessment target that is specified by the ARN of the assessment target.
    
    
    :example: response = client.update_assessment_target(
        assessmentTargetArn='string',
        assessmentTargetName='string',
        resourceGroupArn='string'
    )
    
    
    :type assessmentTargetArn: string
    :param assessmentTargetArn: [REQUIRED]
            The ARN of the assessment target that you want to update.
            

    :type assessmentTargetName: string
    :param assessmentTargetName: [REQUIRED]
            The name of the assessment target that you want to update.
            

    :type resourceGroupArn: string
    :param resourceGroupArn: [REQUIRED]
            The ARN of the resource group that is used to specify the new resource group to associate with the assessment target.
            

    """
    pass

