# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class BackendAddressPool(SubResource):
    """
    Pool of backend IP addresseses

    :param id: Resource Id
    :type id: str
    :param backend_ip_configurations: Gets collection of references to IPs
     defined in NICs
    :type backend_ip_configurations: list of
     :class:`NetworkInterfaceIPConfiguration
     <azure.mgmt.network.models.NetworkInterfaceIPConfiguration>`
    :param load_balancing_rules: Gets Load Balancing rules that use this
     Backend Address Pool
    :type load_balancing_rules: list of :class:`SubResource
     <azure.mgmt.network.models.SubResource>`
    :param outbound_nat_rule: Gets outbound rules that use this Backend
     Address Pool
    :type outbound_nat_rule: :class:`SubResource
     <azure.mgmt.network.models.SubResource>`
    :param provisioning_state: Provisioning state of the PublicIP resource
     Updating/Deleting/Failed
    :type provisioning_state: str
    :param name: Gets name of the resource that is unique within a resource
     group. This name can be used to access the resource
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated
    :type etag: str
    """ 

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'outbound_nat_rule': {'key': 'properties.outboundNatRule', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, id=None, backend_ip_configurations=None, load_balancing_rules=None, outbound_nat_rule=None, provisioning_state=None, name=None, etag=None):
        super(BackendAddressPool, self).__init__(id=id)
        self.backend_ip_configurations = backend_ip_configurations
        self.load_balancing_rules = load_balancing_rules
        self.outbound_nat_rule = outbound_nat_rule
        self.provisioning_state = provisioning_state
        self.name = name
        self.etag = etag
