/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class JSONConverter {
    public static String jsonize(Object o) throws JSONException {
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter(writer);
        JSONConverter.jsonize(o, jsonWriter);
        return writer.toString();
    }

    private static void jsonize(Object o, JSONWriter jsonWriter) throws JSONException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        if (o instanceof Map) {
            jsonWriter.object();
            HashMap m = (HashMap)o;
            for (String key : m.keySet()) {
                Object val = m.get(key);
                if (val instanceof Date) {
                    val = df.format((Date)val);
                }
                jsonWriter.key(key).value(val);
            }
            jsonWriter.endObject();
            return;
        }
        if (o instanceof Collection) {
            jsonWriter.array();
            Collection l = (Collection)o;
            for (Object child : l) {
                JSONConverter.jsonize(child, jsonWriter);
            }
            jsonWriter.endArray();
            return;
        }
        throw new IllegalArgumentException("argument should be map or collection, " + o.getClass().getName());
    }

    public static Map<String, Object> parse(JSONObject jsonObject) throws IOException {
        HashMap<String, Object> m = new HashMap<String, Object>();
        String[] names = JSONObject.getNames(jsonObject);
        if (names == null) {
            return m;
        }
        for (String key : names) {
            try {
                Map<String, Object> value = jsonObject.get(key);
                if (value == JSONObject.NULL) {
                    value = null;
                } else if (value instanceof JSONArray) {
                    value = JSONConverter.parse((JSONArray)((Object)value));
                } else if (value instanceof JSONObject) {
                    value = JSONConverter.parse((JSONObject)((Object)value));
                }
                m.put(key, value);
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
        return m;
    }

    public static Object parse(JSONArray jsonarray) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < jsonarray.length(); ++i) {
            try {
                Object o = jsonarray.get(i);
                if (o == JSONObject.NULL) {
                    list.add(null);
                    continue;
                }
                if (o instanceof JSONArray) {
                    list.add(JSONConverter.parse((JSONArray)o));
                    continue;
                }
                if (o instanceof JSONObject) {
                    list.add(JSONConverter.parse((JSONObject)o));
                    continue;
                }
                list.add(o);
                continue;
            }
            catch (JSONException e) {
                throw new IOException(e);
            }
        }
        return list;
    }
}

