/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.websocket;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.araqne.websocket.Base64;
import org.araqne.websocket.WebSocketFrame;
import org.araqne.websocket.WebSocketListener;
import org.araqne.websocket.WebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocket {
    private static final String WEBSOCKET_KEY_TRAILER = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final Logger logger = LoggerFactory.getLogger(WebSocket.class);
    private URI uri;
    private Socket socket;
    private CopyOnWriteArraySet<WebSocketListener> listeners;
    private Receiver receiver;
    private boolean closed;

    public WebSocket(URI uri) throws IOException {
        this(uri, 0, 10000);
    }

    public WebSocket(URI uri, int connectTimeout) throws IOException {
        this(uri, connectTimeout, 10000);
    }

    public WebSocket(URI uri, int connectTimeout, int readTimeout) throws IOException {
        String scheme = uri.getScheme();
        if (!scheme.equalsIgnoreCase("ws") && !scheme.equalsIgnoreCase("wss")) {
            throw new IllegalArgumentException("illegal websocket schema: " + scheme);
        }
        this.uri = uri;
        this.listeners = new CopyOnWriteArraySet();
        this.connect(connectTimeout, readTimeout);
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void connect(int connectTimeout, int readTimeout) throws UnknownHostException, IOException {
        int port = this.uri.getPort();
        String scheme = this.uri.getScheme();
        if (scheme.equalsIgnoreCase("ws")) {
            if (port == -1) {
                port = 80;
            }
            this.socket = new Socket();
        } else {
            if (port == -1) {
                port = 443;
            }
            SSLContext sc = null;
            try {
                sc = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("unsupported ssl context", e);
            }
            SSLSocketFactory factory = sc.getSocketFactory();
            this.socket = factory.createSocket();
        }
        this.socket.connect(new InetSocketAddress(this.uri.getHost(), port), connectTimeout);
        this.socket.setSoTimeout(readTimeout);
        try {
            String[] lines;
            int readBytes;
            String webSocketKey = this.newWebSocketKey();
            String handshake = this.newHandshakeRequest(webSocketKey);
            OutputStream os = this.socket.getOutputStream();
            os.write(handshake.getBytes("utf-8"));
            os.flush();
            String response = "";
            byte[] b = new byte[8096];
            InputStream is = this.socket.getInputStream();
            while ((readBytes = is.read(b)) > 0 && !(response = response + new String(b, 0, readBytes)).endsWith("\r\n\r\n")) {
            }
            if (!response.startsWith("HTTP/1.1 101 ")) {
                throw new IOException("websocket not suported");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String line : lines = response.split("\r\n")) {
                int p = line.indexOf(58);
                if (p < 0) continue;
                String key = line.substring(0, p).trim().toLowerCase();
                String value = line.substring(p + 1).trim();
                headers.put(key, value);
            }
            String upgrade = this.getHeader(headers, "upgrade");
            String connection = this.getHeader(headers, "connection");
            String accept = this.getHeader(headers, "sec-websocket-accept");
            if (!upgrade.equalsIgnoreCase("websocket")) {
                throw new IOException("Unexpected Upgrade value: " + upgrade);
            }
            if (!connection.equals("Upgrade")) {
                throw new IOException("Unexpected Connection value: " + connection);
            }
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                String input = webSocketKey + WEBSOCKET_KEY_TRAILER;
                String expected = new String(Base64.encode(md.digest(input.getBytes())));
                if (!expected.equals(accept)) {
                    throw new IOException("invalid websocket accept: key " + webSocketKey + ", expected " + expected + ", actual " + accept);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("SHA-1 digest not supported");
            }
            this.receiver = new Receiver();
            this.receiver.setDaemon(true);
            this.receiver.start();
        }
        catch (IOException e) {
            this.socket.close();
            throw e;
        }
        catch (IllegalStateException e) {
            this.socket.close();
            throw e;
        }
    }

    private String getHeader(Map<String, String> headers, String name) throws IOException {
        String value = headers.get(name);
        if (value == null) {
            throw new IOException(name + " header not found");
        }
        return value;
    }

    private String newWebSocketKey() {
        Random r = new Random();
        byte[] b = new byte[16];
        r.nextBytes(b);
        return new String(Base64.encode(b));
    }

    private String newHandshakeRequest(String webSocketKey) {
        StringBuilder sb = new StringBuilder();
        sb.append("GET /websocket HTTP/1.1\r\n");
        sb.append("Host: " + this.uri.getHost() + "\r\n");
        sb.append("Upgrade: websocket\r\n");
        sb.append("Connection: Upgrade\r\n");
        sb.append("Sec-WebSocket-Key: " + webSocketKey + "\r\n");
        sb.append("Sec-WebSocket-Version: 13\r\n");
        sb.append("Content-Length: 0");
        sb.append("\r\n\r\n");
        return sb.toString();
    }

    public void close() throws IOException {
        this.close(null);
    }

    private void close(Throwable cause) throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Socket captured = this.socket;
        if (captured != null) {
            try {
                this.ensureClose(captured.getOutputStream());
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.ensureClose(captured.getInputStream());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            captured.close();
        }
        this.invokeOnCloseCallbacks(cause);
    }

    private void ensureClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void addListener(WebSocketListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(WebSocketListener listener) {
        this.listeners.remove(listener);
    }

    public void send(String text) throws IOException {
        if (this.closed) {
            throw new IOException("websocket is closed");
        }
        WebSocketFrame frame = new WebSocketFrame(text);
        byte[] encoded = frame.encode();
        this.socket.getOutputStream().write(encoded);
        this.socket.getOutputStream().flush();
    }

    private void invokeOnMessageCallbacks(String text) {
        for (WebSocketListener listener : this.listeners) {
            try {
                listener.onMessage(new WebSocketMessage(WebSocketFrame.Opcode.TEXT.getCode(), text));
            }
            catch (Throwable t) {
                this.logger.warn("araqne websocket: websocket listener should not throw any exception", t);
            }
        }
    }

    private void invokeOnErrorCallbacks(Throwable e) {
        for (WebSocketListener listener : this.listeners) {
            try {
                listener.onError(e);
            }
            catch (Throwable t) {
                this.logger.warn("araqne websocket: websocket listener should not throw any exception", t);
            }
        }
    }

    private void invokeOnCloseCallbacks(Throwable cause) {
        for (WebSocketListener listener : this.listeners) {
            try {
                listener.onClose(cause);
            }
            catch (Throwable t) {
                this.logger.warn("araqne websocket: websocket listener should not throw any exception", t);
            }
        }
    }

    static /* synthetic */ void access$200(WebSocket x0, Throwable x1) {
        x0.invokeOnErrorCallbacks(x1);
    }

    static /* synthetic */ Logger access$300(WebSocket x0) {
        return x0.logger;
    }

    static /* synthetic */ void access$400(WebSocket x0, Throwable x1) throws IOException {
        x0.close(x1);
    }

    private class Receiver
    extends Thread {
        private boolean doStop;
        private ByteArrayOutputStream os;

        public Receiver() {
            super("WebSocket Receiver [" + WebSocket.this.uri + "]");
            this.os = new ByteArrayOutputStream();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void ensureRead(byte[] b) throws IOException {
            this.ensureRead(b, b.length);
        }

        private void ensureRead(byte[] b, int len) throws IOException {
            int readBytes;
            InputStream is = WebSocket.this.socket.getInputStream();
            for (int total = 0; total != len; total += readBytes) {
                readBytes = is.read(b, total, len - total);
                if (readBytes >= 0) continue;
                throw new SocketException("Connection reset");
            }
        }

        private void recv() throws IOException {
            byte[] sb = new byte[2];
            this.ensureRead(sb);
            boolean fin = (sb[0] & 0x80) == 128;
            int opcode = sb[0] & 0xF;
            boolean mask = (sb[1] & 0x80) == 128;
            long payloadLen = 0L;
            int len = sb[1] & 0x7F;
            if (len < 126) {
                payloadLen = len;
            } else if (len == 126) {
                this.ensureRead(sb);
                payloadLen = ByteBuffer.wrap(sb).getShort() & 0xFFFF;
            } else if (len == 127) {
                byte[] longbuf = new byte[8];
                this.ensureRead(longbuf);
                payloadLen = ByteBuffer.wrap(longbuf).getLong();
            }
            byte[] b = new byte[(int)payloadLen];
            this.ensureRead(b);
            if (opcode == WebSocketFrame.Opcode.TEXT.getCode() || !fin && opcode == WebSocketFrame.Opcode.CONTINUATION.getCode()) {
                this.os.write(b);
            }
            if (fin) {
                String text = new String(this.os.toByteArray());
                this.os = new ByteArrayOutputStream();
                WebSocket.this.invokeOnMessageCallbacks(text);
            }
        }
    }
}

