/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client.http.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.araqne.logdb.client.AbstractLogDbSession;
import org.araqne.logdb.client.Message;
import org.araqne.logdb.client.MessageException;
import org.araqne.logdb.client.http.impl.MessageCodec;
import org.araqne.logdb.client.http.impl.TrapListener;
import org.araqne.logdb.client.http.impl.WaitingCall;
import org.araqne.logdb.client.http.impl.WebSocketBlockingTable;
import org.araqne.websocket.WebSocket;
import org.araqne.websocket.WebSocketListener;
import org.araqne.websocket.WebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketSession
extends AbstractLogDbSession
implements WebSocketListener {
    private static final int DEFAULT_READ_TIMEOUT = 10000;
    private final Logger logger = LoggerFactory.getLogger(WebSocketSession.class);
    private Object sendLock = new Object();
    private WebSocket websocket;
    private WebSocketBlockingTable table = new WebSocketBlockingTable();
    private final Timer timer;

    public WebSocketSession(String host, int port) throws IOException {
        this(host, port, false, 0);
    }

    public WebSocketSession(String host, int port, boolean secure) throws IOException {
        this(host, port, secure, 0);
    }

    public WebSocketSession(String host, int port, boolean secure, int connectTimeout) throws IOException {
        this(host, port, secure, connectTimeout, 10000);
    }

    public WebSocketSession(String host, int port, boolean secure, int connectTimeout, int readTimeout) throws IOException {
        URI uri = null;
        try {
            String scheme = secure ? "wss://" : "ws://";
            uri = new URI(scheme + host + ":" + port + "/websocket");
            this.websocket = new WebSocket(uri, connectTimeout, readTimeout);
            this.websocket.addListener(this);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid host: " + host);
        }
        this.timer = new Timer("WebSocket [" + uri + "] Ping Timer", true);
        this.timer.scheduleAtFixedRate((TimerTask)new PingTask(), new Date(), 2000L);
    }

    @Override
    public boolean isClosed() {
        return this.websocket.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message rpc(Message req, int timeout) throws IOException {
        Message m;
        WaitingCall call = this.table.set(req.getGuid());
        String json = MessageCodec.encode(req);
        Object object = this.sendLock;
        synchronized (object) {
            this.websocket.send(json);
        }
        try {
            m = timeout == 0 ? this.table.await(call) : this.table.await(call, timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("interrupted: " + e.getMessage());
        }
        if (m.getErrorCode() != null) {
            throw new MessageException(m.getErrorCode(), m.getErrorMessage(), m.getParameters());
        }
        return m;
    }

    @Override
    public void onMessage(WebSocketMessage msg) {
        String json = (String)msg.getData();
        if (json.isEmpty()) {
            return;
        }
        Message m = MessageCodec.decode(json);
        this.logger.debug("araqne logdb client: received {}", msg.getData());
        if (m.getType() == Message.Type.Response) {
            this.table.signal(m.getRequestId(), m);
        } else if (m.getType() == Message.Type.Trap) {
            for (TrapListener listener : this.listeners) {
                try {
                    listener.onTrap(m);
                }
                catch (Throwable t) {
                    this.logger.error("araqne logdb client: trap listener should not throw any exception", t);
                }
            }
        }
    }

    @Override
    public void onError(Throwable t) {
    }

    @Override
    public void onClose(Throwable t) {
        for (TrapListener listener : this.listeners) {
            try {
                listener.onClose(t);
            }
            catch (Throwable t2) {
                this.logger.error("araqne logdb client: trap listener should not throw any exception", t2);
            }
        }
        try {
            this.releaseResources();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.releaseResources();
    }

    private void releaseResources() throws IOException {
        super.close();
        this.timer.cancel();
        this.table.close();
        this.websocket.close();
    }

    private class PingTask
    extends TimerTask {
        private PingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (WebSocketSession.this.websocket.isClosed()) {
                return;
            }
            try {
                Object object = WebSocketSession.this.sendLock;
                synchronized (object) {
                    WebSocketSession.this.websocket.send("ping");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

