/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client.http.impl;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.araqne.logdb.client.Message;
import org.araqne.logdb.client.http.impl.WaitingCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketBlockingTable {
    private final Logger logger = LoggerFactory.getLogger(WebSocketBlockingTable.class);
    private Message interruptSignal = new Message();
    private ConcurrentMap<String, WaitingCall> lockMap = new ConcurrentHashMap<String, WaitingCall>();

    public WaitingCall set(String guid) {
        WaitingCall item = new WaitingCall(guid);
        this.lockMap.put(guid, item);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(String guid, Message response) {
        WaitingCall item;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("araqne-rpc: signal call response {}", (Object)guid);
        }
        if ((item = (WaitingCall)this.lockMap.get(guid)) == null) {
            this.logger.warn("araqne-rpc: no waiting item {}, maybe timeout", (Object)guid);
            return;
        }
        WaitingCall waitingCall = item;
        synchronized (waitingCall) {
            item.done(response);
            item.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message await(WaitingCall item) throws InterruptedException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("araqne logdb client: waiting call response id {}", (Object)item.getGuid());
        }
        try {
            WaitingCall waitingCall = item;
            synchronized (waitingCall) {
                while (item.getResult() == null) {
                    item.wait();
                }
            }
            if (item.getResult() == this.interruptSignal) {
                throw new InterruptedException("call cancelled");
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("araqne logdb client: removing blocking lock id {}", (Object)item.getGuid());
            }
            this.lockMap.remove(item.getGuid());
        }
        return item.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message await(WaitingCall item, long timeout) throws InterruptedException {
        long before = new Date().getTime();
        try {
            WaitingCall waitingCall = item;
            synchronized (waitingCall) {
                while (item.getResult() == null) {
                    item.wait(timeout);
                    if (new Date().getTime() - before < timeout) continue;
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("araqne logdb client: blocking timeout of id {}", (Object)item.getGuid());
                    break;
                }
            }
            if (item.getResult() == this.interruptSignal) {
                throw new InterruptedException("call cancelled");
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("araqne logdb client: blocking finished for id {}", (Object)item.getGuid());
            }
            this.lockMap.remove(item.getGuid());
        }
        return item.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        for (String guid : this.lockMap.keySet()) {
            WaitingCall item = (WaitingCall)this.lockMap.get(guid);
            if (item == null) continue;
            WaitingCall waitingCall = item;
            synchronized (waitingCall) {
                item.done(this.interruptSignal);
                item.notifyAll();
            }
        }
        this.lockMap.clear();
    }
}

