/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client.http.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.araqne.logdb.client.AbstractLogDbSession;
import org.araqne.logdb.client.Message;
import org.araqne.logdb.client.MessageException;
import org.araqne.logdb.client.http.impl.MessageCodec;
import org.araqne.logdb.client.http.impl.TrapListener;
import org.araqne.logdb.client.http.impl.TrapReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CometSession
extends AbstractLogDbSession
implements TrapListener {
    private final Logger logger = LoggerFactory.getLogger(CometSession.class);
    private String host;
    private int port;
    private String cookie;
    private TrapReceiver trapReceiver;

    public CometSession(String host) {
        this(host, 80);
    }

    public CometSession(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void login(String loginName, String password, boolean force) throws IOException {
        super.login(loginName, password, force);
        this.trapReceiver = new TrapReceiver(this.host, this.port, this.cookie);
        this.trapReceiver.addListener(this);
        this.trapReceiver.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message rpc(Message req, int timeout) throws IOException {
        String json = MessageCodec.encode(req);
        HttpURLConnection con = null;
        InputStream is = null;
        try {
            int read;
            con = (HttpURLConnection)new URL("http://" + this.host + ":" + this.port + "/msgbus/request").openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            if (this.cookie != null) {
                con.setRequestProperty("Cookie", this.cookie);
            }
            con.getOutputStream().write(json.getBytes("utf-8"));
            is = con.getInputStream();
            if (con.getHeaderField("Set-Cookie") != null) {
                this.cookie = con.getHeaderField("Set-Cookie").split(";")[0];
            }
            ByteArrayOutputStream bos = null;
            bos = con.getContentLength() > 0 ? new ByteArrayOutputStream(con.getContentLength()) : new ByteArrayOutputStream();
            byte[] b = new byte[8096];
            while ((read = is.read(b)) >= 0) {
                bos.write(b, 0, read);
            }
            String text = new String(bos.toByteArray(), "utf-8");
            Message msg = MessageCodec.decode(text);
            if (msg.getErrorCode() != null) {
                throw new MessageException(msg.getErrorCode(), msg.getErrorMessage(), msg.getParameters());
            }
            Message message = msg;
            return message;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (con != null) {
                con.disconnect();
            }
        }
    }

    @Override
    public void onTrap(Message msg) {
        for (TrapListener listener : this.listeners) {
            try {
                listener.onTrap(msg);
            }
            catch (Throwable t) {
                this.logger.error("logdb client: trap listener should not throw any exception", t);
            }
        }
    }

    @Override
    public void onClose(Throwable t) {
        this.trapReceiver = null;
        for (TrapListener listener : this.listeners) {
            try {
                listener.onClose(t);
            }
            catch (Throwable t2) {
                this.logger.error("logdb client: trap listener should not throw any exception", t2);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        super.close();
        if (this.trapReceiver != null) {
            this.trapReceiver.close();
            this.trapReceiver = null;
        }
    }
}

