/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.util.ArrayList;
import java.util.List;
import org.araqne.logdb.client.TableConfig;

public class StorageEngineConfig {
    private String type;
    private String basePath;
    private List<TableConfig> configs = new ArrayList<TableConfig>();

    public StorageEngineConfig() {
    }

    public StorageEngineConfig(String type) {
        this.type = type;
    }

    public StorageEngineConfig(String type, String basePath) {
        this.type = type;
        this.basePath = basePath;
    }

    public StorageEngineConfig clone() {
        StorageEngineConfig c = new StorageEngineConfig();
        c.setType(this.type);
        c.setBasePath(this.basePath);
        c.setConfigs(this.clone(this.configs));
        return c;
    }

    private List<TableConfig> clone(List<TableConfig> l) {
        ArrayList<TableConfig> cloned = new ArrayList<TableConfig>();
        for (TableConfig config : l) {
            cloned.add(config.clone());
        }
        return cloned;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public List<TableConfig> getConfigs() {
        return this.configs;
    }

    public TableConfig getConfig(String key) {
        for (TableConfig c : this.configs) {
            if (!c.getKey().equals(key)) continue;
            return c;
        }
        return null;
    }

    public void setConfigs(List<TableConfig> configs) {
        this.configs = configs;
    }

    public String toString() {
        String bp = "";
        if (this.basePath != null) {
            bp = ", base_path=" + this.basePath;
        }
        String c = "";
        if (!this.configs.isEmpty()) {
            c = ", configs=" + this.configs;
        }
        return "type=" + this.type + c + bp;
    }
}

