/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IndexInfo {
    private String tableName;
    private String indexName;
    private String tokenizerName;
    private Map<String, String> tokenizerConfigs = new HashMap<String, String>();
    private boolean useBloomFilter;
    private int bloomFilterCapacity0 = 1250000;
    private double bloomFilterErrorRate0 = 0.001f;
    private int bloomFilterCapacity1 = 10000000;
    private double bloomFilterErrorRate1 = 0.02f;
    private Date minIndexDay;
    private String basePath;
    private boolean buildPastIndex;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getTokenizerName() {
        return this.tokenizerName;
    }

    public void setTokenizerName(String tokenizerName) {
        this.tokenizerName = tokenizerName;
    }

    public Map<String, String> getTokenizerConfigs() {
        return this.tokenizerConfigs;
    }

    public void setTokenizerConfigs(Map<String, String> tokenizerConfigs) {
        this.tokenizerConfigs = tokenizerConfigs;
    }

    public boolean isUseBloomFilter() {
        return this.useBloomFilter;
    }

    public void setUseBloomFilter(boolean useBloomFilter) {
        this.useBloomFilter = useBloomFilter;
    }

    public int getBloomFilterCapacity0() {
        return this.bloomFilterCapacity0;
    }

    public void setBloomFilterCapacity0(int bloomFilterCapacity0) {
        this.bloomFilterCapacity0 = bloomFilterCapacity0;
    }

    public double getBloomFilterErrorRate0() {
        return this.bloomFilterErrorRate0;
    }

    public void setBloomFilterErrorRate0(double bloomFilterErrorRate0) {
        this.bloomFilterErrorRate0 = bloomFilterErrorRate0;
    }

    public int getBloomFilterCapacity1() {
        return this.bloomFilterCapacity1;
    }

    public void setBloomFilterCapacity1(int bloomFilterCapacity1) {
        this.bloomFilterCapacity1 = bloomFilterCapacity1;
    }

    public double getBloomFilterErrorRate1() {
        return this.bloomFilterErrorRate1;
    }

    public void setBloomFilterErrorRate1(double bloomFilterErrorRate1) {
        this.bloomFilterErrorRate1 = bloomFilterErrorRate1;
    }

    public Date getMinIndexDay() {
        return this.minIndexDay;
    }

    public void setMinIndexDay(Date minIndexDay) {
        this.minIndexDay = minIndexDay;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public boolean isBuildPastIndex() {
        return this.buildPastIndex;
    }

    public void setBuildPastIndex(boolean buildPastIndex) {
        this.buildPastIndex = buildPastIndex;
    }

    public String toString() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String s = null;
        if (this.minIndexDay != null) {
            s = f.format(this.minIndexDay);
        }
        String bloomFilterConfig = "bloomfilter=" + this.useBloomFilter;
        if (this.useBloomFilter) {
            bloomFilterConfig = bloomFilterConfig + "[lv0: " + this.bloomFilterCapacity0 + ", " + this.bloomFilterErrorRate0 + ", ";
            bloomFilterConfig = bloomFilterConfig + "lv1: " + this.bloomFilterCapacity1 + ", " + this.bloomFilterErrorRate1 + "]";
        }
        return "table=" + this.tableName + ", index=" + this.indexName + "," + bloomFilterConfig + ", tokenizer=" + this.tokenizerName + ", tokenizer configs=" + this.tokenizerConfigs + ", base path=" + this.basePath + ", min index day=" + s + ", build past index=" + this.buildPastIndex;
    }
}

