/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldInfo {
    private String name;
    private String type;
    private int length;

    public static FieldInfo parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("field definition should not be null");
        }
        Pattern p = Pattern.compile("(\\S+)\\s+([^() ]+)(?:\\s*\\(\\s*(\\d+)\\s*\\))*");
        Matcher m = p.matcher(s);
        if (!m.find()) {
            throw new IllegalStateException("invalid field definition format: " + s);
        }
        String fieldName = m.group(1);
        String type = m.group(2);
        int len = 0;
        if (m.group(3) != null) {
            len = Integer.valueOf(m.group(3));
        }
        return new FieldInfo(fieldName, type, len);
    }

    public FieldInfo() {
    }

    public FieldInfo(String name, String type) {
        this(name, type, 0);
    }

    public FieldInfo(String name, String type, int length) {
        this.name = name;
        this.type = type;
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String toString() {
        if (this.length > 0) {
            return this.name + " " + this.type + "(" + this.length + ")";
        }
        return this.name + " " + this.type;
    }
}

