/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.araqne.logdb.client.AccountInfo;
import org.araqne.logdb.client.ArchiveConfig;
import org.araqne.logdb.client.ConfigSpec;
import org.araqne.logdb.client.IndexConfigSpec;
import org.araqne.logdb.client.IndexInfo;
import org.araqne.logdb.client.IndexTokenizerFactoryInfo;
import org.araqne.logdb.client.LogCursor;
import org.araqne.logdb.client.LogDbClient;
import org.araqne.logdb.client.LogQuery;
import org.araqne.logdb.client.LogQueryCommand;
import org.araqne.logdb.client.LoggerFactoryInfo;
import org.araqne.logdb.client.LoggerInfo;
import org.araqne.logdb.client.ParserFactoryInfo;
import org.araqne.logdb.client.ParserInfo;
import org.araqne.logdb.client.Privilege;
import org.araqne.logdb.client.StorageEngineInfo;
import org.araqne.logdb.client.TableConfig;
import org.araqne.logdb.client.TableSchemaInfo;
import org.araqne.logdb.client.TransformerFactoryInfo;
import org.araqne.logdb.client.TransformerInfo;

public class Console {
    private BufferedReader br;
    private LogDbClient client;
    private String host;
    private String loginName;
    private String password;

    public static void main(String[] args) throws IOException {
        ConsoleAppender ca = new ConsoleAppender(new PatternLayout());
        ca.setThreshold(Level.INFO);
        BasicConfigurator.configure(ca);
        Map<String, String> opts = Console.getOpts(args);
        if (opts.containsKey("-e")) {
            Console.oneShotQuery(opts);
            return;
        }
        new Console().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void oneShotQuery(Map<String, String> opts) throws IOException {
        CSVWriter csvWriter = null;
        try {
            LogDbClient client = null;
            try {
                client = new LogDbClient();
                String query = null;
                String queryPath = opts.get("-f");
                if (queryPath != null) {
                    File f = new File(queryPath);
                    if (!f.exists()) {
                        System.err.println("query file not found: " + f.getAbsolutePath());
                        System.exit(-1);
                    }
                    if (!f.canRead()) {
                        System.err.println("check query file permission: " + f.getAbsolutePath());
                        System.exit(-1);
                    }
                    query = Console.readQueryFile(f);
                }
                if (query == null) {
                    query = Console.getOpt(opts, "-e", "Error: -e, query string is missing");
                }
                String host = Console.getOpt(opts, "-h", "Error: -h, host is required");
                String loginName = Console.getOpt(opts, "-u", "Error: -u, login name is required");
                String password = Console.getOpt(opts, "-p", "Error: -p, password is required");
                String port = Console.getOpt(opts, "-P", "Error: -P, port is required");
                String cols = opts.get("-c");
                String[] headers = null;
                String[] line = null;
                if (cols != null && !cols.trim().isEmpty()) {
                    headers = cols.split(",");
                    for (int i = 0; i < headers.length; ++i) {
                        headers[i] = headers[i].trim();
                    }
                    line = new String[headers.length];
                }
                client.connect(host, Integer.valueOf(port), loginName, password);
                String lineEnd = System.getProperty("line.separator");
                csvWriter = new CSVWriter((Writer)new OutputStreamWriter(System.out), ',', '\"', lineEnd);
                LogCursor cursor = client.query(query);
                while (cursor.hasNext()) {
                    Map m = (Map)cursor.next();
                    if (line == null) {
                        System.out.println(m);
                        continue;
                    }
                    for (int i = 0; i < line.length; ++i) {
                        Object o = m.get(headers[i]);
                        line[i] = o == null ? "" : o.toString();
                    }
                    csvWriter.writeNext(line);
                }
            }
            catch (Throwable throwable) {
                Console.ensureClose(csvWriter);
                Console.ensureClose(client);
                throw throwable;
            }
            Console.ensureClose(csvWriter);
            Console.ensureClose(client);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readQueryFile(File f) {
        BufferedReader br = null;
        FileInputStream is = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            is = new FileInputStream(f);
            br = new BufferedReader(new InputStreamReader((InputStream)is, "utf-8"));
            while ((line = br.readLine()) != null) {
                if (line.trim().startsWith("#")) continue;
                sb.append(" " + line);
            }
        }
        catch (IOException e) {
            try {
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            catch (Throwable throwable) {
                Console.ensureClose(is);
                throw throwable;
            }
            Console.ensureClose(is);
        }
        Console.ensureClose(is);
        return sb.toString();
    }

    private static void ensureClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getOpt(Map<String, String> opts, String key, String msg) {
        String val = opts.get(key);
        if (val == null) {
            throw new IllegalArgumentException(msg);
        }
        return val;
    }

    private static Map<String, String> getOpts(String[] args) {
        String name = null;
        String value = "";
        HashMap<String, String> opts = new HashMap<String, String>();
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (name != null) {
                    opts.put(name, value);
                    value = "";
                }
                name = arg;
                continue;
            }
            value = arg;
        }
        if (name != null) {
            opts.put(name, value);
        }
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        Console.w("Araqne LogDB Console 0.9.5 (2014-05-15)");
        Console.w("Type \"help\" for more information");
        this.br = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                String[] tokens;
                System.out.print(this.getPrompt());
                String line = this.br.readLine();
                if (line == null) {
                    break;
                }
                if (line.trim().isEmpty() || (tokens = Console.tokenize(line)).length == 0) continue;
                String cmd = tokens[0].trim();
                if (cmd.equals("quit")) break;
                if (cmd.equals("exit")) {
                    break;
                }
                if (cmd.equals("help")) {
                    this.help();
                    continue;
                }
                if (cmd.equals("connect")) {
                    this.connect(tokens);
                    continue;
                }
                if (cmd.equals("disconnect")) {
                    this.disconnect();
                    continue;
                }
                if (cmd.equals("query")) {
                    this.query(tokens);
                    continue;
                }
                if (cmd.equals("create_query")) {
                    this.createQuery(tokens);
                    continue;
                }
                if (cmd.equals("start_query")) {
                    this.startQuery(tokens);
                    continue;
                }
                if (cmd.equals("stop_query")) {
                    this.stopQuery(tokens);
                    continue;
                }
                if (cmd.equals("remove_query")) {
                    this.removeQuery(tokens);
                    continue;
                }
                if (cmd.equals("fetch")) {
                    this.fetch(tokens);
                    continue;
                }
                if (cmd.equals("queries")) {
                    this.queries();
                    continue;
                }
                if (cmd.equals("query_status")) {
                    this.queryStatus(tokens);
                    continue;
                }
                if (cmd.equals("create_table")) {
                    this.createTable(tokens);
                    continue;
                }
                if (cmd.equals("drop_table")) {
                    this.dropTable(tokens);
                    continue;
                }
                if (cmd.equals("tables")) {
                    this.listTables();
                    continue;
                }
                if (cmd.equals("table")) {
                    this.manageTable(tokens);
                    continue;
                }
                if (cmd.equals("loggers")) {
                    this.listLoggers();
                    continue;
                }
                if (cmd.equals("logger_factories")) {
                    this.listLoggerFactories();
                    continue;
                }
                if (cmd.equals("parser_factories")) {
                    this.listParserFactories();
                    continue;
                }
                if (cmd.equals("parser_factory")) {
                    this.getParserFactoryInfo(tokens);
                    continue;
                }
                if (cmd.equals("parsers")) {
                    this.listParsers();
                    continue;
                }
                if (cmd.equals("transformer_factories")) {
                    this.listTransformerFactories();
                    continue;
                }
                if (cmd.equals("transformer_factory")) {
                    this.getTransformerFactoryInfo(tokens);
                    continue;
                }
                if (cmd.equals("transformers")) {
                    this.listTransformers();
                    continue;
                }
                if (cmd.equals("create_transformer")) {
                    this.createTransformer(tokens);
                    continue;
                }
                if (cmd.equals("remove_transformer")) {
                    this.removeTransformer(tokens);
                    continue;
                }
                if (cmd.equals("create_parser")) {
                    this.createParser(tokens);
                    continue;
                }
                if (cmd.equals("remove_parser")) {
                    this.removeParser(tokens);
                    continue;
                }
                if (cmd.equals("test_parse")) {
                    this.testParse(tokens);
                    continue;
                }
                if (cmd.equals("create_logger")) {
                    this.createLogger(tokens);
                    continue;
                }
                if (cmd.equals("remove_logger")) {
                    this.removeLogger(tokens);
                    continue;
                }
                if (cmd.equals("start_logger")) {
                    this.startLogger(tokens);
                    continue;
                }
                if (cmd.equals("stop_logger")) {
                    this.stopLogger(tokens);
                    continue;
                }
                if (cmd.equals("index_tokenizers")) {
                    this.listIndexTokenizers(tokens);
                    continue;
                }
                if (cmd.equals("indexes")) {
                    this.listIndexes(tokens);
                    continue;
                }
                if (cmd.equals("index")) {
                    this.getIndexInfo(tokens);
                    continue;
                }
                if (cmd.equals("create_index")) {
                    this.createIndex(tokens);
                    continue;
                }
                if (cmd.equals("drop_index")) {
                    this.dropIndex(tokens);
                    continue;
                }
                if (cmd.equals("test_index_tokenize")) {
                    this.testIndexTokenize(tokens);
                    continue;
                }
                if (cmd.equals("accounts")) {
                    this.listAccounts(tokens);
                    continue;
                }
                if (cmd.equals("create_account")) {
                    this.createAccount(tokens);
                    continue;
                }
                if (cmd.equals("remove_account")) {
                    this.removeAccount(tokens);
                    continue;
                }
                if (cmd.equals("passwd")) {
                    this.changePassword(tokens);
                    continue;
                }
                if (cmd.equals("grant")) {
                    this.grantPrivilege(tokens);
                    continue;
                }
                if (cmd.equals("revoke")) {
                    this.revokePrivilege(tokens);
                    continue;
                }
                if (cmd.equals("archives")) {
                    this.listArchiveConfigs(tokens);
                    continue;
                }
                if (cmd.equals("create_archive")) {
                    this.createArchiveConfig(tokens);
                    continue;
                }
                if (cmd.equals("remove_archive")) {
                    this.removeArchiveConfig(tokens);
                    continue;
                }
                if (cmd.equals("engines")) {
                    this.engines();
                    continue;
                }
                Console.w("syntax error");
            }
        }
        finally {
            if (this.client != null) {
                Console.w("closing logdb connection...");
                this.client.close();
                Console.w("bye!");
            }
        }
    }

    private void connect(String[] tokens) {
        block10: {
            if (tokens.length < 3) {
                Console.w("Usage: connect <host:port> <loginname> [<password>]");
                return;
            }
            if (this.client != null) {
                Console.w("already connected");
                return;
            }
            String addr = tokens[1];
            String[] addrTokens = addr.split(":");
            this.host = addrTokens[0];
            int port = 80;
            if (addrTokens.length > 1) {
                port = Integer.valueOf(addrTokens[1]);
            }
            try {
                InetAddress.getByName(this.host);
            }
            catch (UnknownHostException e) {
                Console.w("invalid hostname " + this.host + ", connect failed");
                return;
            }
            this.loginName = tokens[2];
            this.password = "";
            if (tokens.length > 3) {
                this.password = tokens[3];
            }
            try {
                this.client = new LogDbClient();
                this.client.connect(this.host, port, this.loginName, this.password);
                Console.w("connected to " + this.host + " as " + this.loginName);
            }
            catch (Throwable t) {
                Console.w(t.getMessage());
                if (this.client == null) break block10;
                try {
                    this.client.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.client = null;
            }
        }
    }

    private void disconnect() {
        if (this.client == null) {
            Console.w("not connected yet");
            return;
        }
        Console.w("closing connection...");
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Console.w("disconnected");
        this.client = null;
    }

    private void queries() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            List<LogQuery> queries = this.client.getQueries();
            if (queries.size() == 0) {
                Console.w("no result");
                return;
            }
            for (LogQuery query : queries) {
                Console.w(query.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void queryStatus(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: query_status <query_id>");
            return;
        }
        try {
            LogQuery query = this.client.getQuery(Integer.valueOf(tokens[1]));
            if (query == null) {
                Console.w("query not found");
                return;
            }
            Console.w(query.toString());
            for (LogQueryCommand cmd : query.getCommands()) {
                Console.w("\t" + cmd);
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void query(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        long begin = System.currentTimeMillis();
        String queryString = this.join(tokens);
        Console.w("querying [" + queryString + "] ...");
        long count = 0L;
        LogCursor cursor = null;
        try {
            cursor = this.client.query(queryString);
            while (cursor.hasNext()) {
                Object o = cursor.next();
                Console.w(o.toString());
                ++count;
            }
            long end = System.currentTimeMillis();
            Console.w("total " + count + " row(s), elapsed " + (end - begin) + "ms");
        }
        catch (Throwable t) {
            if (this.client != null && this.client.isClosed()) {
                this.client = null;
            }
            Console.w("query failed: " + t.getMessage());
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void createQuery(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: create_query <query_string>");
            return;
        }
        try {
            String queryString = this.join(tokens);
            int id = this.client.createQuery(queryString);
            Console.w("created query " + id);
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private String join(String[] tokens) {
        StringBuilder sb = new StringBuilder();
        int p = 0;
        for (int i = 1; i < tokens.length; ++i) {
            String t = tokens[i];
            if (p++ != 0) {
                sb.append(" ");
            }
            sb.append(t);
        }
        return sb.toString();
    }

    private void startQuery(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: start_query <query_id>");
            return;
        }
        try {
            int id = Integer.valueOf(tokens[1]);
            this.client.startQuery(id);
            Console.w("started query " + id);
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void stopQuery(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: stop_query <query_id>");
            return;
        }
        try {
            int id = Integer.valueOf(tokens[1]);
            this.client.stopQuery(id);
            Console.w("stopped query " + id);
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void removeQuery(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: remove_query <query_id>");
            return;
        }
        try {
            int id = Integer.valueOf(tokens[1]);
            this.client.removeQuery(id);
            Console.w("removed query " + id);
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void fetch(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 4) {
            Console.w("Usage: fetch <query_id> <offset> <limit>");
            return;
        }
        int id = Integer.valueOf(tokens[1]);
        long offset = Long.valueOf(tokens[2]);
        int limit = Integer.valueOf(tokens[3]);
        try {
            Map<String, Object> page = this.client.getResult(id, offset, limit);
            List rows = (List)page.get("result");
            for (Object row : rows) {
                Console.w(row.toString());
            }
            Console.w(rows.size() + " row(s)");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void createTable(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: create_table <table_name> <engine_type>");
            return;
        }
        try {
            this.client.createTable(tokens[1], tokens[2]);
            Console.w("created");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void dropTable(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: drop_table <table_name>");
            return;
        }
        try {
            this.client.dropTable(tokens[1]);
            Console.w("dropped");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listTables() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            for (TableSchemaInfo table : this.client.listTables()) {
                Console.w("Table [" + table.getName() + "]");
                for (Map.Entry<String, String> e : table.getMetadata().entrySet()) {
                    Console.w(" * " + e.getKey() + "=" + e.getValue());
                }
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void manageTable(String[] tokens) throws IOException {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: table <table_name> [<key>] [<value>]");
            return;
        }
        try {
            String tableName = tokens[1];
            if (tokens.length == 2) {
                TableSchemaInfo table = this.client.getTableInfo(tableName);
                Console.w("Table [" + table.getName() + "]");
                Console.w("");
                if (table.getPrimaryStorage() != null) {
                    Console.w("Primary Storage: type " + table.getPrimaryStorage().getType());
                    Console.w("------------------------------");
                    if (table.getPrimaryStorage().getBasePath() != null) {
                        Console.w("Base Path: " + table.getPrimaryStorage().getBasePath());
                    }
                    for (TableConfig tableConfig : table.getPrimaryStorage().getConfigs()) {
                        Console.w(tableConfig.toString());
                    }
                }
                if (table.getReplicaStorage() != null) {
                    Console.w("");
                    Console.w("Replica Storage: type " + table.getReplicaStorage().getType());
                    Console.w("------------------------------");
                    if (table.getReplicaStorage().getBasePath() != null) {
                        Console.w("Base Path: " + table.getReplicaStorage().getBasePath());
                    }
                    for (TableConfig tableConfig : table.getReplicaStorage().getConfigs()) {
                        Console.w(tableConfig.toString());
                    }
                }
                if (!table.getMetadata().isEmpty()) {
                    Console.w("");
                    Console.w("Metadata");
                    Console.w("----------");
                    for (Map.Entry entry : table.getMetadata().entrySet()) {
                        Console.w(" * " + (String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                }
            } else {
                String key = tokens[2];
                if (tokens.length == 3) {
                    HashSet<String> keys = new HashSet<String>();
                    keys.add(key);
                    this.client.unsetTableMetadata(tableName, keys);
                    Console.w("unset");
                } else if (tokens.length == 4) {
                    HashMap<String, String> config = new HashMap<String, String>();
                    String string = tokens[3];
                    config.put(key, string);
                    this.client.setTableMetadata(tableName, config);
                    Console.w("set");
                }
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listLoggers() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            Console.w("Loggers");
            Console.w("---------");
            for (LoggerInfo logger : this.client.listLoggers()) {
                Console.w(logger.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listLoggerFactories() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            Console.w("Logger Factories");
            Console.w("------------------");
            for (LoggerFactoryInfo f : this.client.listLoggerFactories()) {
                Console.w(f.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listParserFactories() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            Console.w("Parser Factories");
            Console.w("------------------");
            for (ParserFactoryInfo f : this.client.listParserFactories()) {
                Console.w(f.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void getParserFactoryInfo(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: parser_factory <factory name>");
            return;
        }
        try {
            Console.w("Parser Factory");
            Console.w("------------------");
            ParserFactoryInfo f = this.client.getParserFactoryInfo(tokens[1]);
            Console.w(f.toString());
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listParsers() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            List<ParserInfo> parsers = this.client.listParsers();
            if (parsers.size() == 0) {
                Console.w("no result");
                return;
            }
            Console.w("Parsers");
            Console.w("----------");
            for (ParserInfo parser : parsers) {
                Console.w(parser.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void createParser(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: create_parser <factory_name> <name>");
            return;
        }
        try {
            ParserFactoryInfo f = this.client.getParserFactoryInfo(tokens[1]);
            ParserInfo p = new ParserInfo();
            p.setFactoryName(tokens[1]);
            p.setName(tokens[2]);
            for (ConfigSpec type : f.getConfigSpecs()) {
                this.inputOption(p, type);
            }
            this.client.createParser(p);
            Console.w("created");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void inputOption(ParserInfo parser, ConfigSpec spec) throws IOException {
        String directive = spec.isRequired() ? "(required)" : "(optional)";
        System.out.print(spec.getDisplayName() + " " + directive + "? ");
        String value = this.br.readLine();
        if (!value.isEmpty()) {
            parser.getConfigs().put(spec.getName(), value);
        }
        if (value.isEmpty() && spec.isRequired()) {
            this.inputOption(parser, spec);
        }
    }

    private void removeParser(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: remove_parser <name>");
            return;
        }
        try {
            this.client.removeParser(tokens[1]);
            Console.w("removed");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void testParse(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: test_parse <parser name> <line>");
            return;
        }
        try {
            String name = tokens[1];
            String line = tokens[2];
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("line", line);
            List<Map<String, Object>> rows = this.client.testParser(name, data);
            Console.w("Parsed rows");
            Console.w("-------------");
            for (Map<String, Object> row : rows) {
                Console.w(row.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listTransformerFactories() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            Console.w("Transformer Factories");
            Console.w("------------------");
            for (TransformerFactoryInfo f : this.client.listTransformerFactories()) {
                Console.w(f.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void getTransformerFactoryInfo(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: transformer_factory <factory name>");
            return;
        }
        try {
            Console.w("Transformer Factory");
            Console.w("------------------");
            TransformerFactoryInfo f = this.client.getTransformerFactoryInfo(tokens[1]);
            Console.w(f.toString());
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listTransformers() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            List<TransformerInfo> transformers = this.client.listTransformers();
            if (transformers.size() == 0) {
                Console.w("no result");
                return;
            }
            Console.w("Transformers");
            Console.w("--------------");
            for (TransformerInfo transformer : transformers) {
                Console.w(transformer.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void createTransformer(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: create_transformer <factory_name> <name>");
            return;
        }
        try {
            TransformerFactoryInfo f = this.client.getTransformerFactoryInfo(tokens[1]);
            TransformerInfo p = new TransformerInfo();
            p.setFactoryName(tokens[1]);
            p.setName(tokens[2]);
            for (ConfigSpec type : f.getConfigSpecs()) {
                this.inputOption(p, type);
            }
            this.client.createTransformer(p);
            Console.w("created");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void inputOption(TransformerInfo parser, ConfigSpec spec) throws IOException {
        String directive = spec.isRequired() ? "(required)" : "(optional)";
        System.out.print(spec.getDisplayName() + " " + directive + "? ");
        String value = this.br.readLine();
        if (!value.isEmpty()) {
            parser.getConfigs().put(spec.getName(), value);
        }
        if (value.isEmpty() && spec.isRequired()) {
            this.inputOption(parser, spec);
        }
    }

    private void removeTransformer(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: remove_transformer <name>");
            return;
        }
        try {
            this.client.removeTransformer(tokens[1]);
            Console.w("removed");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void createLogger(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 4) {
            Console.w("Usage: create_logger <factory name> <namespace> <name>");
            return;
        }
        try {
            LoggerInfo logger = new LoggerInfo();
            logger.setFactoryName(tokens[1]);
            logger.setNamespace(tokens[2]);
            logger.setName(tokens[3]);
            LoggerFactoryInfo f = this.client.getLoggerFactoryInfo(tokens[1]);
            for (ConfigSpec type : f.getConfigSpecs()) {
                this.inputOption(logger, type);
            }
            this.client.createLogger(logger);
            Console.w("created");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void inputOption(LoggerInfo logger, ConfigSpec spec) throws IOException {
        String directive = spec.isRequired() ? "(required)" : "(optional)";
        System.out.print(spec.getDisplayName() + " " + directive + "? ");
        String value = this.br.readLine();
        if (!value.isEmpty()) {
            logger.getConfigs().put(spec.getName(), value);
        }
        if (value.isEmpty() && spec.isRequired()) {
            this.inputOption(logger, spec);
        }
    }

    private void removeLogger(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: remove_logger <logger fullname>");
            return;
        }
        try {
            this.client.removeLogger(tokens[1]);
            Console.w("removed");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void startLogger(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: start_logger <logger fullname> <interval (millisec)>");
            return;
        }
        try {
            this.client.startLogger(tokens[1], Integer.valueOf(tokens[2]));
            Console.w("started with interval " + tokens[2] + "ms");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listIndexTokenizers(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            for (IndexTokenizerFactoryInfo tokenizer : this.client.listIndexTokenizerFactories()) {
                Console.w(tokenizer.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listIndexes(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: indexes <table name>");
            return;
        }
        try {
            for (IndexInfo index : this.client.listIndexes(tokens[1])) {
                Console.w(index.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void getIndexInfo(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: index <table name> <index name>");
            return;
        }
        try {
            IndexInfo index = this.client.getIndexInfo(tokens[1], tokens[2]);
            Console.w(index.toString());
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void stopLogger(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: stop_logger <logger fullname>");
            return;
        }
        try {
            this.client.stopLogger(tokens[1], 5000);
            Console.w("stopped");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void createIndex(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: create_index <table name> <index name>");
            return;
        }
        try {
            String tableName = tokens[1];
            String indexName = tokens[2];
            IndexInfo index = new IndexInfo();
            index.setTableName(tableName);
            index.setIndexName(indexName);
            Console.w("Available Index Tokenizers");
            Console.w("----------------------------");
            List<IndexTokenizerFactoryInfo> tokenizers = this.client.listIndexTokenizerFactories();
            for (IndexTokenizerFactoryInfo tokenizer : tokenizers) {
                Console.w(tokenizer.toString());
            }
            System.out.print("select tokenizer? ");
            String tokenizerName = this.br.readLine().trim();
            IndexTokenizerFactoryInfo selected = null;
            for (IndexTokenizerFactoryInfo tokenizer : tokenizers) {
                if (!tokenizer.getName().equals(tokenizerName)) continue;
                selected = tokenizer;
            }
            if (selected == null) {
                Console.w("invalid index tokenizer");
                return;
            }
            index.setTokenizerName(tokenizerName);
            for (IndexConfigSpec type : selected.getConfigSpecs()) {
                this.inputOption(index, type);
            }
            System.out.print("use bloom filter (y/N)? ");
            index.setUseBloomFilter(this.br.readLine().trim().equalsIgnoreCase("y"));
            if (index.isUseBloomFilter()) {
                System.out.print("bloom filter lv0 capacity (enter to use default)? ");
                String t = this.br.readLine().trim();
                if (!t.isEmpty()) {
                    index.setBloomFilterCapacity0(Integer.valueOf(t));
                }
                System.out.print("bloom filter lv0 error rate (0<x<1, enter to use default)? ");
                t = this.br.readLine().trim();
                if (!t.isEmpty()) {
                    index.setBloomFilterErrorRate0(Double.valueOf(t));
                }
                System.out.print("bloom filter lv1 capacity (enter to use default)? ");
                if (!t.isEmpty()) {
                    index.setBloomFilterCapacity1(Integer.valueOf(t));
                }
                System.out.print("bloom filter lv1 error rate (0<x<1, enter to use default)? ");
                if (!t.isEmpty()) {
                    index.setBloomFilterErrorRate1(Double.valueOf(t));
                }
            }
            System.out.print("base path (optional)? ");
            String basePath = this.br.readLine().trim();
            if (basePath.isEmpty()) {
                basePath = null;
            }
            index.setBasePath(basePath);
            System.out.print("build past index (y/n)? ");
            String s = this.br.readLine().trim();
            index.setBuildPastIndex(s.equalsIgnoreCase("y"));
            if (index.isBuildPastIndex()) {
                System.out.print("min day (yyyymmdd or enter to skip)? ");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
                String minDayStr = this.br.readLine().trim();
                if (minDayStr != null) {
                    index.setMinIndexDay(dateFormat.parse(minDayStr));
                }
            }
            this.client.createIndex(index);
            Console.w("created");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void inputOption(IndexInfo index, IndexConfigSpec spec) throws IOException {
        String directive = spec.isRequired() ? "(required)" : "(optional)";
        System.out.print(spec.getName() + " " + directive + "? ");
        String value = this.br.readLine();
        if (!value.isEmpty()) {
            index.getTokenizerConfigs().put(spec.getKey(), value);
        }
        if (value.isEmpty() && spec.isRequired()) {
            this.inputOption(index, spec);
        }
    }

    private void dropIndex(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: drop_index <table name> <index name>");
            return;
        }
        try {
            this.client.dropIndex(tokens[1], tokens[2]);
            Console.w("dropped");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void testIndexTokenize(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 4) {
            Console.w("Usage: test_index_tokenize <table name> <index name> <line>");
            return;
        }
        try {
            String tableName = tokens[1];
            String indexName = tokens[2];
            String line = tokens[3];
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("line", line);
            Set<String> s = this.client.testIndexTokenizer(tableName, indexName, data);
            Console.w("Fulltext Tokens");
            Console.w("-----------------");
            for (String t : s) {
                Console.w(t);
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listAccounts(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            for (AccountInfo account : this.client.listAccounts()) {
                Console.w(account.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void createAccount(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: create_account <login name> <password>");
            return;
        }
        try {
            AccountInfo account = new AccountInfo();
            account.setLoginName(tokens[1]);
            account.setPassword(tokens[2]);
            this.client.createAccount(account);
            Console.w("created");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void removeAccount(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: remove_account <login name>");
            return;
        }
        try {
            this.client.removeAccount(tokens[1]);
            Console.w("removed");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void changePassword(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: passwd <login name> <password>");
            return;
        }
        try {
            this.client.changePassword(tokens[1], tokens[2]);
            Console.w("changed");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void grantPrivilege(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: grant <login name> <table name>");
            return;
        }
        try {
            this.client.grantPrivilege(new Privilege(tokens[1], tokens[2]));
            Console.w("granted");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void revokePrivilege(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: revoke <login name> <table name>");
            return;
        }
        try {
            this.client.revokePrivilege(new Privilege(tokens[1], tokens[2]));
            Console.w("revoked");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void listArchiveConfigs(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            Console.w("Archive Configs");
            Console.w("-----------------");
            for (ArchiveConfig config : this.client.listArchiveConfigs()) {
                Console.w(config.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void createArchiveConfig(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 3) {
            Console.w("Usage: create_archive <logger fullname> <table name> [<host name>]");
            return;
        }
        try {
            ArchiveConfig config = new ArchiveConfig();
            config.setLoggerName(tokens[1]);
            config.setTableName(tokens[2]);
            if (tokens.length > 3) {
                config.setHost(tokens[3]);
            }
            config.setEnabled(true);
            this.client.createArchiveConfig(config);
            Console.w("created");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void removeArchiveConfig(String[] tokens) {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        if (tokens.length < 2) {
            Console.w("Usage: remove_archive <logger fullname>");
            return;
        }
        try {
            this.client.removeArchiveConfig(tokens[1]);
            Console.w("removed");
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private void engines() {
        if (this.client == null) {
            Console.w("connect first please");
            return;
        }
        try {
            List<StorageEngineInfo> engines = this.client.listStorageEngines();
            for (StorageEngineInfo e : engines) {
                Console.w(e.toString());
            }
        }
        catch (Throwable t) {
            Console.w(t.getMessage());
        }
    }

    private String getPrompt() {
        if (this.client != null) {
            return "logdb@" + this.host + "> ";
        }
        return "logdb> ";
    }

    private void help() {
        Console.w("connect <host> <loginname> <password>");
        Console.w("\tconnect to specified araqne logdb instance");
        Console.w("disconnect");
        Console.w("\tdisconnect database connection");
        Console.w("queries");
        Console.w("\tprint all queries initiated by this session");
        Console.w("query <query string>");
        Console.w("\tcreate, start and fetch query result at once");
        Console.w("create_query <query string>");
        Console.w("\tcreate query with specified query string, and return allocated query id");
        Console.w("start_query <query id>");
        Console.w("\tstart query");
        Console.w("stop_query <query_id>");
        Console.w("\tstop running query");
        Console.w("remove_query <query_id>");
        Console.w("\tstop and remove query");
        Console.w("fetch <query_id> <offset> <limit>");
        Console.w("\tfetch result set of specified window. you can fetch partial result before query is ended");
    }

    private static void w(String s) {
        System.out.println(s);
    }

    private static String[] tokenize(String line) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        boolean quoteOpen = false;
        boolean squoteOpen = false;
        boolean escape = false;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            ++i;
            if (c == '\\') {
                if (escape) {
                    escape = false;
                    sb.append(c);
                    continue;
                }
                if (squoteOpen) {
                    sb.append(c);
                    continue;
                }
                escape = true;
                continue;
            }
            if (c == '\"') {
                if (escape) {
                    escape = false;
                    sb.append(c);
                    continue;
                }
                if (squoteOpen) {
                    sb.append(c);
                    continue;
                }
                if (quoteOpen = !quoteOpen) continue;
                args.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (c == '\'') {
                if (escape) {
                    escape = false;
                    sb.append(c);
                    continue;
                }
                quoteOpen = !quoteOpen;
                boolean bl = squoteOpen = !squoteOpen;
                if (quoteOpen) continue;
                args.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (c == ' ' && !quoteOpen) {
                String parsed = sb.toString();
                if (!parsed.trim().isEmpty()) {
                    args.add(parsed);
                }
                sb = new StringBuilder();
                continue;
            }
            if (c != '\\' && escape) {
                sb.append('\\');
                escape = false;
            }
            sb.append(c);
        }
        String parsed = sb.toString();
        if (!parsed.trim().isEmpty()) {
            args.add(sb.toString());
        }
        return args.toArray(new String[0]);
    }
}

