/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.logdb.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.araqne.logdb.client.LogDbSession;
import org.araqne.logdb.client.Message;
import org.araqne.logdb.client.http.impl.TrapListener;

public abstract class AbstractLogDbSession
implements LogDbSession {
    protected boolean isClosed;
    protected CopyOnWriteArraySet<TrapListener> listeners = new CopyOnWriteArraySet();

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void login(String loginName, String password) throws IOException {
        this.login(loginName, password, false);
    }

    @Override
    public void login(String loginName, String password, boolean force) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("login_name", loginName);
        params.put("password", password);
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.login", params);
    }

    @Override
    public void logout() throws IOException {
        this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.logout");
    }

    @Override
    public Message rpc(String method) throws IOException {
        return this.rpc(method, 0);
    }

    @Override
    public Message rpc(String method, Map<String, Object> params) throws IOException {
        return this.rpc(method, params, 0);
    }

    @Override
    public Message rpc(String method, int timeout) throws IOException {
        Message req = new Message();
        req.setMethod(method);
        return this.rpc(req, timeout);
    }

    @Override
    public Message rpc(String method, Map<String, Object> params, int timeout) throws IOException {
        Message req = new Message();
        req.setMethod(method);
        req.setParameters(params);
        return this.rpc(req, timeout);
    }

    @Override
    public void registerTrap(String callbackName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", callbackName);
        this.rpc("org.araqne.msgbus.PushPlugin.subscribe", params);
    }

    @Override
    public void unregisterTrap(String callbackName) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", callbackName);
        this.rpc("org.araqne.msgbus.PushPlugin.unsubscribe", params);
    }

    @Override
    public void addListener(TrapListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(TrapListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.isClosed()) {
                return;
            }
            this.isClosed = true;
            this.rpc("org.araqne.logdb.msgbus.ManagementPlugin.logout", 1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

