/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.codec;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.araqne.codec.BinaryForm;
import org.araqne.codec.EncodedStringCache;
import org.araqne.codec.EncodingRule;
import org.araqne.codec.FastCustomCodec;
import org.araqne.codec.UnsupportedTypeException;

public class FastEncodingRule {
    public byte[] encodeRawNumber(Class<?> clazz, long value) {
        int len = EncodingRule.lengthOfRawNumber(clazz, value);
        byte[] b = new byte[len];
        if (len == 1) {
            b[0] = (byte)value;
            return b;
        }
        for (int i = 0; i < len; ++i) {
            byte data;
            byte signalBit = (byte)(i != len - 1 ? 128 : 0);
            b[i] = data = (byte)(signalBit | (byte)(value >> 7 * (len - i - 1) & 0x7FL));
        }
        return b;
    }

    public ByteBuffer encode(Object value) {
        return this.encode(value, null);
    }

    public ByteBuffer encode(Object value, FastCustomCodec cc) {
        BinaryForm bf = this.preencode(value, cc);
        ByteBuffer bb = ByteBuffer.allocate(bf.totalLength);
        this.encode(bb, bf);
        bb.flip();
        return bb;
    }

    public void encode(ByteBuffer bb, BinaryForm bf) {
        bb.put((byte)bf.type);
        switch (bf.type) {
            case 0: {
                break;
            }
            case 5: 
            case 11: {
                bb.put(bf.lengthBytes);
                bb.put(bf.payloadBytes);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                bb.put(bf.payloadBytes);
                break;
            }
            case 9: 
            case 10: {
                bb.put(bf.lengthBytes);
                for (BinaryForm c : bf.children) {
                    this.encode(bb, c);
                }
                break;
            }
            default: {
                bb.put(bf.lengthBytes);
                if (bf.payloadBytes != null) {
                    bb.put(bf.payloadBytes);
                    break;
                }
                if (bf.children == null) break;
                for (BinaryForm c : bf.children) {
                    this.encode(bb, c);
                }
            }
        }
    }

    public BinaryForm preencode(Object value) {
        return this.preencode(value, null);
    }

    public BinaryForm preencode(Object value, FastCustomCodec cc) {
        if (value == null) {
            BinaryForm bf = new BinaryForm();
            bf.type = 0;
            bf.totalLength = 1;
            return bf;
        }
        if (value instanceof String) {
            return this.preencodeString(value);
        }
        if (value instanceof Integer) {
            return this.preencodeInt(value);
        }
        if (value instanceof Long) {
            return this.preencodeLong((Long)value);
        }
        if (value instanceof Short) {
            return this.preencodeShort((Short)value);
        }
        if (value instanceof Date) {
            return this.preencodeDate((Date)value);
        }
        if (value instanceof Inet4Address) {
            return this.preencodeIp4((Inet4Address)value);
        }
        if (value instanceof Inet6Address) {
            return this.preencodeIp6((Inet6Address)value);
        }
        if (value instanceof Boolean) {
            return this.preencodeBoolean((Boolean)value);
        }
        if (value instanceof Float) {
            return this.preencodeFloat(value);
        }
        if (value instanceof Double) {
            return this.preencodeDouble(value);
        }
        if (value instanceof Map) {
            return this.preencodeMap(value, cc);
        }
        if (value instanceof List) {
            return this.preencodeArray((List)value, cc);
        }
        if (value.getClass().isArray()) {
            Class<?> c = value.getClass().getComponentType();
            if (c == Byte.TYPE) {
                return this.preencodeBlob((byte[])value);
            }
            if (c == Integer.TYPE) {
                return this.preencodeArray((int[])value);
            }
            if (c == Long.TYPE) {
                return this.preencodeArray((long[])value);
            }
            if (c == Short.TYPE) {
                return this.preencodeArray((short[])value);
            }
            if (c == Boolean.TYPE) {
                return this.preencodeArray((boolean[])value);
            }
            if (c == Double.TYPE) {
                return this.preencodeArray((double[])value);
            }
            if (c == Float.TYPE) {
                return this.preencodeArray((float[])value);
            }
            if (c == Character.TYPE) {
                throw new UnsupportedTypeException(value.getClass().getName());
            }
            return this.preencodeArray((Object[])value, cc);
        }
        if (cc != null) {
            return cc.preencode(this, value);
        }
        throw new UnsupportedTypeException(value.getClass().getName());
    }

    private BinaryForm preencodeIp6(Inet6Address value) {
        BinaryForm bf = new BinaryForm();
        bf.type = 8;
        bf.payloadBytes = value.getAddress();
        bf.totalLength = 1 + bf.payloadBytes.length;
        bf.value = value;
        return bf;
    }

    private BinaryForm preencodeBoolean(boolean value) {
        BinaryForm bf = new BinaryForm();
        bf.type = 1;
        bf.payloadBytes = new byte[]{(byte)(Boolean.valueOf(value) != false ? 1 : 0)};
        bf.totalLength = 2;
        bf.value = value;
        return bf;
    }

    private BinaryForm preencodeMap(Object value, FastCustomCodec cc) {
        Map map = (Map)value;
        BinaryForm bf = new BinaryForm();
        bf.type = 9;
        bf.children = new BinaryForm[map.size() * 2];
        int i = 0;
        int payloadLength = 0;
        for (Map.Entry e : map.entrySet()) {
            BinaryForm k = this.preencodeString(e.getKey());
            BinaryForm v = this.preencode(e.getValue(), cc);
            bf.children[i++] = k;
            bf.children[i++] = v;
            payloadLength += k.totalLength + v.totalLength;
        }
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, payloadLength);
        bf.totalLength = 1 + bf.lengthBytes.length + payloadLength;
        bf.value = value;
        return bf;
    }

    private BinaryForm preencodeDouble(Object value) {
        long v = Double.doubleToLongBits((Double)value);
        byte[] b = new byte[8];
        for (int i = 7; i >= 0; --i) {
            b[i] = (byte)(v & 0xFFL);
            v >>= 8;
        }
        BinaryForm bf = new BinaryForm();
        bf.type = 16;
        bf.payloadBytes = b;
        bf.totalLength = 1 + bf.payloadBytes.length;
        bf.value = value;
        return bf;
    }

    private BinaryForm preencodeFloat(Object value) {
        int v = Float.floatToIntBits(((Float)value).floatValue());
        byte[] b = new byte[4];
        for (int i = 3; i >= 0; --i) {
            b[i] = (byte)(v & 0xFF);
            v >>= 8;
        }
        BinaryForm bf = new BinaryForm();
        bf.type = 15;
        bf.payloadBytes = b;
        bf.totalLength = 1 + bf.payloadBytes.length;
        bf.value = value;
        return bf;
    }

    private BinaryForm preencodeIp4(Inet4Address value) {
        BinaryForm bf = new BinaryForm();
        bf.type = 7;
        bf.payloadBytes = value.getAddress();
        bf.totalLength = 1 + bf.payloadBytes.length;
        bf.value = value;
        return bf;
    }

    private BinaryForm preencodeInt(Object value) {
        BinaryForm bf = new BinaryForm();
        bf.type = 13;
        int v = (Integer)value;
        long zvalue = (long)v << 1 ^ (long)v >> 31;
        bf.payloadBytes = this.encodeRawNumber(Integer.TYPE, zvalue);
        bf.totalLength = 1 + bf.payloadBytes.length;
        bf.value = v;
        return bf;
    }

    private BinaryForm preencodeLong(long value) {
        BinaryForm bf = new BinaryForm();
        bf.type = 14;
        long v = value;
        long zvalue = v << 1 ^ v >> 63;
        bf.payloadBytes = this.encodeRawNumber(Long.TYPE, zvalue);
        bf.totalLength = 1 + bf.payloadBytes.length;
        bf.value = v;
        return bf;
    }

    private BinaryForm preencodeDate(Date value) {
        BinaryForm bf = new BinaryForm();
        bf.type = 6;
        long l = value.getTime();
        byte[] b = new byte[8];
        for (int i = 7; i >= 0; --i) {
            b[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        bf.payloadBytes = b;
        bf.totalLength = 1 + bf.payloadBytes.length;
        bf.value = value;
        return bf;
    }

    private BinaryForm preencodeShort(short value) {
        BinaryForm bf = new BinaryForm();
        bf.type = 12;
        short v = value;
        long zvalue = (long)v << 1 ^ (long)v >> 31;
        bf.payloadBytes = this.encodeRawNumber(Short.TYPE, zvalue);
        bf.totalLength = 1 + bf.payloadBytes.length;
        bf.value = (int)v;
        return bf;
    }

    private BinaryForm preencodeString(Object value) {
        BinaryForm bf = new BinaryForm();
        EncodedStringCache k = EncodedStringCache.getEncodedString((String)value);
        bf.type = 5;
        bf.payloadBytes = k.value();
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, bf.payloadBytes.length);
        bf.totalLength = 1 + bf.lengthBytes.length + bf.payloadBytes.length;
        bf.value = value;
        return bf;
    }

    public BinaryForm preencodeBlob(byte[] b) {
        BinaryForm bf = new BinaryForm();
        bf.type = 11;
        bf.payloadBytes = b;
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, bf.payloadBytes.length);
        bf.totalLength = 1 + bf.lengthBytes.length + bf.payloadBytes.length;
        bf.value = b;
        return bf;
    }

    public BinaryForm preencodeArray(Object[] array) {
        return this.preencodeArray(array, null);
    }

    public BinaryForm preencodeArray(Object[] array, FastCustomCodec cc) {
        return this.preencodeArray(Arrays.asList(array), cc);
    }

    public BinaryForm preencodeArray(List<?> array, FastCustomCodec cc) {
        BinaryForm bf = new BinaryForm();
        bf.type = 10;
        bf.children = new BinaryForm[array.size()];
        int payloadLength = 0;
        int p = 0;
        for (Object obj : array) {
            BinaryForm c = this.preencode(obj, cc);
            payloadLength += c.totalLength;
            bf.children[p++] = c;
        }
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, payloadLength);
        bf.totalLength = 1 + bf.lengthBytes.length + payloadLength;
        bf.value = array;
        return bf;
    }

    public BinaryForm preencodeArray(int[] array) {
        BinaryForm bf = new BinaryForm();
        bf.type = 10;
        bf.children = new BinaryForm[array.length];
        int p = 0;
        int payloadLength = 0;
        for (int i : array) {
            BinaryForm c = this.preencodeInt(i);
            bf.children[p++] = c;
            payloadLength += c.totalLength;
        }
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, payloadLength);
        bf.totalLength = 1 + bf.lengthBytes.length + payloadLength;
        bf.value = array;
        return bf;
    }

    public BinaryForm preencodeArray(long[] array) {
        BinaryForm bf = new BinaryForm();
        bf.type = 10;
        bf.children = new BinaryForm[array.length];
        int p = 0;
        int payloadLength = 0;
        for (long i : array) {
            BinaryForm c = this.preencodeLong(i);
            bf.children[p++] = c;
            payloadLength += c.totalLength;
        }
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, payloadLength);
        bf.totalLength = 1 + bf.lengthBytes.length + payloadLength;
        bf.value = array;
        return bf;
    }

    public BinaryForm preencodeArray(short[] array) {
        BinaryForm bf = new BinaryForm();
        bf.type = 10;
        bf.children = new BinaryForm[array.length];
        int p = 0;
        int payloadLength = 0;
        for (short i : array) {
            BinaryForm c = this.preencodeShort(i);
            bf.children[p++] = c;
            payloadLength += c.totalLength;
        }
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, payloadLength);
        bf.totalLength = 1 + bf.lengthBytes.length + payloadLength;
        bf.value = array;
        return bf;
    }

    public BinaryForm preencodeArray(double[] array) {
        BinaryForm bf = new BinaryForm();
        bf.type = 10;
        bf.children = new BinaryForm[array.length];
        int p = 0;
        int payloadLength = 0;
        for (double i : array) {
            BinaryForm c = this.preencodeDouble(i);
            bf.children[p++] = c;
            payloadLength += c.totalLength;
        }
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, payloadLength);
        bf.totalLength = 1 + bf.lengthBytes.length + payloadLength;
        bf.value = array;
        return bf;
    }

    public BinaryForm preencodeArray(float[] array) {
        BinaryForm bf = new BinaryForm();
        bf.type = 10;
        bf.children = new BinaryForm[array.length];
        int p = 0;
        int payloadLength = 0;
        for (float i : array) {
            BinaryForm c = this.preencodeFloat(Float.valueOf(i));
            bf.children[p++] = c;
            payloadLength += c.totalLength;
        }
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, payloadLength);
        bf.totalLength = 1 + bf.lengthBytes.length + payloadLength;
        bf.value = array;
        return bf;
    }

    public BinaryForm preencodeArray(boolean[] array) {
        BinaryForm bf = new BinaryForm();
        bf.type = 10;
        bf.children = new BinaryForm[array.length];
        int p = 0;
        int payloadLength = 0;
        for (boolean i : array) {
            BinaryForm c = this.preencodeBoolean(i);
            bf.children[p++] = c;
            payloadLength += c.totalLength;
        }
        bf.lengthBytes = this.encodeRawNumber(Integer.TYPE, payloadLength);
        bf.totalLength = 1 + bf.lengthBytes.length + payloadLength;
        bf.value = array;
        return bf;
    }
}

