/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.codec;

import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.araqne.codec.CustomCodec;
import org.araqne.codec.EncodedStringCache;
import org.araqne.codec.TypeMismatchException;
import org.araqne.codec.UnsupportedTypeException;

public class EncodingRule {
    public static final byte NULL_TYPE = 0;
    public static final byte BOOLEAN_TYPE = 1;
    public static final byte INT16_TYPE = 2;
    public static final byte INT32_TYPE = 3;
    public static final byte INT64_TYPE = 4;
    public static final byte STRING_TYPE = 5;
    public static final byte DATE_TYPE = 6;
    public static final byte IP4_TYPE = 7;
    public static final byte IP6_TYPE = 8;
    public static final byte MAP_TYPE = 9;
    public static final byte ARRAY_TYPE = 10;
    public static final byte BLOB_TYPE = 11;
    public static final byte ZINT16_TYPE = 12;
    public static final byte ZINT32_TYPE = 13;
    public static final byte ZINT64_TYPE = 14;
    public static final byte FLOAT_TYPE = 15;
    public static final byte DOUBLE_TYPE = 16;
    private static final Charset utf8 = Charset.forName("utf-8");

    private EncodingRule() {
    }

    public static void encode(ByteBuffer bb, Object value) {
        EncodingRule.encode(bb, value, null);
    }

    public static void encode(ByteBuffer bb, Object value, CustomCodec cc) {
        if (value == null) {
            EncodingRule.encodeNull(bb);
        } else if (value instanceof String) {
            EncodingRule.encodeString(bb, (String)value);
        } else if (value instanceof Long) {
            EncodingRule.encodeLong(bb, (Long)value);
        } else if (value instanceof Integer) {
            EncodingRule.encodeInt(bb, (Integer)value);
        } else if (value instanceof Short) {
            EncodingRule.encodeShort(bb, (Short)value);
        } else if (value instanceof Date) {
            EncodingRule.encodeDate(bb, (Date)value);
        } else if (value instanceof Inet4Address) {
            EncodingRule.encodeIp4(bb, (Inet4Address)value);
        } else if (value instanceof Inet6Address) {
            EncodingRule.encodeIp6(bb, (Inet6Address)value);
        } else if (value instanceof Map) {
            EncodingRule.encodeMap(bb, (Map)value, cc);
        } else if (value instanceof List) {
            EncodingRule.encodeArray(bb, (List)value, cc);
        } else if (value.getClass().isArray()) {
            Class<?> c = value.getClass().getComponentType();
            if (c == Byte.TYPE) {
                EncodingRule.encodeBlob(bb, (byte[])value);
            } else if (c == Integer.TYPE) {
                EncodingRule.encodeArray(bb, (int[])value);
            } else if (c == Long.TYPE) {
                EncodingRule.encodeArray(bb, (long[])value);
            } else if (c == Short.TYPE) {
                EncodingRule.encodeArray(bb, (short[])value);
            } else if (c == Boolean.TYPE) {
                EncodingRule.encodeArray(bb, (boolean[])value);
            } else if (c == Double.TYPE) {
                EncodingRule.encodeArray(bb, (double[])value);
            } else if (c == Float.TYPE) {
                EncodingRule.encodeArray(bb, (float[])value);
            } else {
                if (c == Character.TYPE) {
                    throw new UnsupportedTypeException(value.getClass().getName());
                }
                EncodingRule.encodeArray(bb, (Object[])value, cc);
            }
        } else if (value instanceof Boolean) {
            EncodingRule.encodeBoolean(bb, (Boolean)value);
        } else if (value instanceof Float) {
            EncodingRule.encodeFloat(bb, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            EncodingRule.encodeDouble(bb, (Double)value);
        } else if (cc != null) {
            cc.encode(bb, value);
        } else {
            throw new UnsupportedTypeException(value.getClass().getName());
        }
    }

    @Deprecated
    public static int length(Object value) {
        return EncodingRule.lengthOf(value);
    }

    public static int lengthOf(Object value) {
        return EncodingRule.lengthOf(value, null);
    }

    public static int lengthOf(Object value, CustomCodec cc) {
        if (value == null) {
            return EncodingRule.lengthOfNull();
        }
        if (value instanceof String) {
            return EncodingRule.lengthOfString((String)value);
        }
        if (value instanceof Long) {
            return EncodingRule.lengthOfLong((Long)value);
        }
        if (value instanceof Integer) {
            return EncodingRule.lengthOfInt((Integer)value);
        }
        if (value instanceof Short) {
            return EncodingRule.lengthOfShort((Short)value);
        }
        if (value instanceof Date) {
            return EncodingRule.lengthOfDate();
        }
        if (value instanceof Inet4Address) {
            return EncodingRule.lengthOfIp4((Inet4Address)value);
        }
        if (value instanceof Inet6Address) {
            return EncodingRule.lengthOfIp6((Inet6Address)value);
        }
        if (value instanceof Map) {
            return EncodingRule.lengthOfMap((Map)value, cc);
        }
        if (value instanceof List) {
            return EncodingRule.lengthOfArray((List)value, cc);
        }
        if (value.getClass().isArray()) {
            Class<?> c = value.getClass().getComponentType();
            if (c == Byte.TYPE) {
                return EncodingRule.lengthOfBlob((byte[])value);
            }
            if (c == Integer.TYPE) {
                return EncodingRule.lengthOfArray((int[])value);
            }
            if (c == Long.TYPE) {
                return EncodingRule.lengthOfArray((long[])value);
            }
            if (c == Short.TYPE) {
                return EncodingRule.lengthOfArray((short[])value);
            }
            if (c == Boolean.TYPE) {
                return EncodingRule.lengthOfArray((boolean[])value);
            }
            if (c == Double.TYPE) {
                return EncodingRule.lengthOfArray((double[])value);
            }
            if (c == Float.TYPE) {
                return EncodingRule.lengthOfArray((float[])value);
            }
            if (c == Character.TYPE) {
                throw new UnsupportedTypeException(value.getClass().getName());
            }
            return EncodingRule.lengthOfArray((Object[])value, cc);
        }
        if (value instanceof Boolean) {
            return EncodingRule.lengthOfBoolean((Boolean)value);
        }
        if (value instanceof Float) {
            return EncodingRule.lengthOfFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return EncodingRule.lengthOfDouble((Double)value);
        }
        if (cc != null) {
            return cc.lengthOf(value);
        }
        throw new UnsupportedTypeException(value.getClass().getName());
    }

    public static int getObjectLength(ByteBuffer bb) {
        return EncodingRule.getObjectLength(bb, null);
    }

    public static int getObjectLength(ByteBuffer bb, CustomCodec cc) {
        ByteBuffer buf = bb.duplicate();
        byte typeByte = buf.get();
        switch (typeByte) {
            case 0: {
                return 1;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                int pos = buf.position();
                return 1 + (int)EncodingRule.decodeRawNumber(buf) + (buf.position() - pos);
            }
            case 3: {
                throw new UnsupportedTypeException("deprecated number type");
            }
            case 2: {
                throw new UnsupportedTypeException("deprecated number type");
            }
            case 4: {
                throw new UnsupportedTypeException("deprecated number type");
            }
            case 6: {
                int pos = buf.position();
                buf.getLong();
                return 1 + (buf.position() - pos);
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 17;
            }
            case 1: {
                return 2;
            }
            case 12: 
            case 13: 
            case 14: {
                int pos = buf.position();
                EncodingRule.decodeRawNumber(buf);
                return 1 + (buf.position() - pos);
            }
            case 15: {
                return 5;
            }
            case 16: {
                return 9;
            }
        }
        if (cc != null) {
            return cc.getObjectLength(buf);
        }
        throw new UnsupportedTypeException("type: " + typeByte);
    }

    public static Object decode(ByteBuffer bb) {
        return EncodingRule.decode(bb, null);
    }

    public static Object decode(ByteBuffer bb, CustomCodec cc) {
        byte typeByte = bb.get(bb.position());
        switch (typeByte) {
            case 0: {
                bb.get();
                return null;
            }
            case 5: {
                return EncodingRule.decodeString(bb);
            }
            case 3: {
                throw new UnsupportedTypeException("deprecated number type");
            }
            case 2: {
                throw new UnsupportedTypeException("deprecated number type");
            }
            case 4: {
                throw new UnsupportedTypeException("deprecated number type");
            }
            case 6: {
                return EncodingRule.decodeDate(bb);
            }
            case 7: {
                return EncodingRule.decodeIp4(bb);
            }
            case 8: {
                return EncodingRule.decodeIp6(bb);
            }
            case 9: {
                return EncodingRule.decodeMap(bb, cc);
            }
            case 10: {
                return EncodingRule.decodeArray(bb, cc);
            }
            case 11: {
                return EncodingRule.decodeBlob(bb);
            }
            case 1: {
                return EncodingRule.decodeBoolean(bb);
            }
            case 13: {
                return EncodingRule.decodeInt(bb);
            }
            case 12: {
                return EncodingRule.decodeShort(bb);
            }
            case 14: {
                return EncodingRule.decodeLong(bb);
            }
            case 15: {
                return Float.valueOf(EncodingRule.decodeFloat(bb));
            }
            case 16: {
                return EncodingRule.decodeDouble(bb);
            }
        }
        if (cc != null) {
            return cc.decode(bb);
        }
        throw new UnsupportedTypeException("type: " + typeByte);
    }

    public static void encodeNull(ByteBuffer bb) {
        bb.put((byte)0);
    }

    public static void encodeNumber(ByteBuffer bb, Class<?> clazz, long value) {
        if (clazz.equals(Integer.TYPE)) {
            EncodingRule.encodeInt(bb, (int)value);
        } else if (clazz.equals(Long.TYPE)) {
            EncodingRule.encodeLong(bb, value);
        } else if (clazz.equals(Short.TYPE)) {
            EncodingRule.encodeShort(bb, (short)value);
        } else {
            throw new UnsupportedTypeException("invalid number type: " + clazz.getName());
        }
    }

    public static void encodeRawNumber(ByteBuffer bb, Class<?> clazz, long value) {
        int len = EncodingRule.lengthOfRawNumber(clazz, value);
        for (int i = 0; i < len; ++i) {
            byte signalBit = (byte)(i != len - 1 ? 128 : 0);
            byte data = (byte)(signalBit | (byte)(value >> 7 * (len - i - 1) & 0x7FL));
            bb.put(data);
        }
    }

    public static long decodeRawNumber(ByteBuffer bb) {
        byte b;
        long value = 0L;
        do {
            value <<= 7;
            b = bb.get();
            value |= (long)(b & 0x7F);
        } while ((b & 0x80) == 128);
        return value;
    }

    public static void encodePlainLong(ByteBuffer bb, long value) {
        bb.put((byte)4);
        EncodingRule.encodeRawNumber(bb, Long.TYPE, value);
    }

    public static long decodePlainLong(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 4) {
            throw new TypeMismatchException(4, type, bb.position() - 1);
        }
        return EncodingRule.decodeRawNumber(bb);
    }

    public static void encodePlainInt(ByteBuffer bb, int value) {
        bb.put((byte)3);
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, value);
    }

    public static int decodePlainInt(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 3) {
            throw new TypeMismatchException(3, type, bb.position() - 1);
        }
        return (int)EncodingRule.decodeRawNumber(bb);
    }

    public static void encodePlainShort(ByteBuffer bb, short value) {
        bb.put((byte)2);
        EncodingRule.encodeRawNumber(bb, Short.TYPE, value);
    }

    public static short decodePlainShort(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 2) {
            throw new TypeMismatchException(2, type, bb.position() - 1);
        }
        return (short)EncodingRule.decodeRawNumber(bb);
    }

    public static void encodeLong(ByteBuffer bb, long value) {
        bb.put((byte)14);
        long zvalue = value << 1 ^ value >> 63;
        EncodingRule.encodeRawNumber(bb, Long.TYPE, zvalue);
    }

    public static long decodeLong(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 14) {
            throw new TypeMismatchException(14, type, bb.position() - 1);
        }
        long zvalue = EncodingRule.decodeRawNumber(bb);
        return zvalue >> 1 & Long.MAX_VALUE ^ -(zvalue & 1L);
    }

    public static void encodeInt(ByteBuffer bb, int value) {
        bb.put((byte)13);
        long zvalue = (long)value << 1 ^ (long)value >> 31;
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, zvalue);
    }

    public static int decodeInt(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 13) {
            throw new TypeMismatchException(13, type, bb.position() - 1);
        }
        int zvalue = (int)EncodingRule.decodeRawNumber(bb);
        int v = zvalue >> 1 & Integer.MAX_VALUE ^ -(zvalue & 1);
        return v;
    }

    public static void encodeShort(ByteBuffer bb, short value) {
        bb.put((byte)12);
        long zvalue = (long)value << 1 ^ (long)value >> 15;
        EncodingRule.encodeRawNumber(bb, Short.TYPE, zvalue);
    }

    public static short decodeShort(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 12) {
            throw new TypeMismatchException(12, type, bb.position() - 1);
        }
        long zvalue = EncodingRule.decodeRawNumber(bb);
        return (short)(zvalue >> 1 & 0x7FFFL ^ -(zvalue & 1L));
    }

    public static void encodeString(ByteBuffer bb, String value) {
        bb.put((byte)5);
        try {
            byte[] buffer = value.getBytes("utf-8");
            EncodingRule.encodeRawNumber(bb, Integer.TYPE, buffer.length);
            bb.put(buffer);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static String decodeString(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 5) {
            throw new TypeMismatchException(5, type, bb.position() - 1);
        }
        int length = (int)EncodingRule.decodeRawNumber(bb);
        int oldLimit = bb.limit();
        bb.limit(bb.position() + length);
        CharBuffer cb = utf8.decode(bb);
        String value = cb.toString();
        bb.limit(oldLimit);
        return value;
    }

    public static void encodeDate(ByteBuffer bb, Date value) {
        bb.put((byte)6);
        bb.putLong(value.getTime());
    }

    public static Date decodeDate(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 6) {
            throw new TypeMismatchException(6, type, bb.position() - 1);
        }
        return new Date(bb.getLong());
    }

    public static void encodeBoolean(ByteBuffer bb, boolean value) {
        bb.put((byte)1);
        bb.put((byte)(value ? 1 : 0));
    }

    public static boolean decodeBoolean(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 1) {
            throw new TypeMismatchException(1, type, bb.position() - 1);
        }
        byte value = bb.get();
        return value == 1;
    }

    public static void encodeIp4(ByteBuffer bb, Inet4Address value) {
        bb.put((byte)7);
        bb.put(value.getAddress());
    }

    public static InetAddress decodeIp4(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 7) {
            throw new TypeMismatchException(7, type, bb.position() - 1);
        }
        byte[] address = new byte[4];
        bb.get(address);
        try {
            return Inet4Address.getByAddress(address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static void encodeIp6(ByteBuffer bb, Inet6Address value) {
        bb.put((byte)8);
        bb.put(value.getAddress());
    }

    public static InetAddress decodeIp6(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 8) {
            throw new TypeMismatchException(8, type, bb.position() - 1);
        }
        byte[] address = new byte[16];
        bb.get(address);
        try {
            return Inet6Address.getByAddress(address);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static void encodeMap(ByteBuffer bb, Map<String, Object> map) {
        EncodingRule.encodeMap(bb, map, null);
    }

    public static void encodeMap(ByteBuffer bb, Map<String, Object> map, CustomCodec cc) {
        bb.put((byte)9);
        int length = EncodingRule.preencodeMap(map, 0, cc);
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, length);
        for (String key : map.keySet()) {
            EncodedStringCache k = EncodedStringCache.getEncodedString(key);
            bb.put((byte)5);
            EncodingRule.encodeRawNumber(bb, Integer.TYPE, k.value().length);
            bb.put(k.value());
            Object value = map.get(key);
            if (value instanceof String) {
                EncodedStringCache v = EncodedStringCache.getEncodedString((String)value);
                bb.put((byte)5);
                EncodingRule.encodeRawNumber(bb, Integer.TYPE, v.value().length);
                bb.put(v.value());
                continue;
            }
            EncodingRule.encode(bb, value, cc);
        }
    }

    private static int preencodeMap(Map<String, Object> map, int depth, CustomCodec cc) {
        int length = 0;
        for (String key : map.keySet()) {
            EncodedStringCache k = EncodedStringCache.getEncodedString(key);
            length += k.length();
            Object value = map.get(key);
            if (value instanceof String) {
                length += EncodedStringCache.getEncodedString((String)value).length();
                continue;
            }
            if (value instanceof Map) {
                length += EncodingRule.preencodeMap((Map)value, depth + 1, cc);
                continue;
            }
            if (value instanceof List) {
                length += EncodingRule.preencodeArray((List)value, depth + 1, cc);
                continue;
            }
            if (value instanceof Object[]) {
                length += EncodingRule.preencodeArray((Object[])value, depth + 1, cc);
                continue;
            }
            length += EncodingRule.lengthOf(value, cc);
        }
        if (depth == 0) {
            return length;
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, length) + length;
    }

    public static Map<String, Object> decodeMap(ByteBuffer bb) {
        return EncodingRule.decodeMap(bb, null);
    }

    public static Map<String, Object> decodeMap(ByteBuffer bb, CustomCodec cc) {
        int after;
        int before;
        byte type = bb.get();
        if (type != 9) {
            throw new TypeMismatchException(9, type, bb.position() - 1);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (int length = (int)EncodingRule.decodeRawNumber(bb); length > 0; length -= before - after) {
            before = bb.remaining();
            byte ktype = bb.get();
            if (ktype != 5) {
                throw new TypeMismatchException(5, type, bb.position() - 1);
            }
            int klength = (int)EncodingRule.decodeRawNumber(bb);
            int oldLimit = bb.limit();
            int advance = bb.position() + klength;
            bb.limit(advance);
            String key = utf8.decode(bb).toString();
            bb.limit(oldLimit);
            Object value = null;
            if (bb.get(advance) == 5) {
                bb.get();
                klength = (int)EncodingRule.decodeRawNumber(bb);
                oldLimit = bb.limit();
                advance = bb.position() + klength;
                bb.limit(advance);
                value = utf8.decode(bb).toString();
                bb.limit(oldLimit);
            } else {
                value = EncodingRule.decode(bb, cc);
            }
            after = bb.remaining();
            m.put(key, value);
        }
        return m;
    }

    public static void encodeArray(ByteBuffer bb, List<?> array) {
        EncodingRule.encodeArray(bb, array, null);
    }

    public static void encodeArray(ByteBuffer bb, List<?> array, CustomCodec cc) {
        bb.put((byte)10);
        int length = EncodingRule.preencodeArray(array, 0, cc);
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, length);
        for (Object obj : array) {
            if (obj instanceof String) {
                EncodedStringCache es = EncodedStringCache.getEncodedString((String)obj);
                bb.put((byte)5);
                EncodingRule.encodeRawNumber(bb, Integer.TYPE, es.value().length);
                bb.put(es.value());
                continue;
            }
            EncodingRule.encode(bb, obj, cc);
        }
    }

    public static void encodeArray(ByteBuffer bb, int[] array) {
        bb.put((byte)10);
        int contentLength = 0;
        for (int i : array) {
            contentLength += EncodingRule.lengthOfInt(i);
        }
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, contentLength);
        for (int i : array) {
            EncodingRule.encodeInt(bb, i);
        }
    }

    public static void encodeArray(ByteBuffer bb, long[] array) {
        bb.put((byte)10);
        int contentLength = 0;
        for (long i : array) {
            contentLength += EncodingRule.lengthOfLong(i);
        }
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, contentLength);
        for (long i : array) {
            EncodingRule.encodeLong(bb, i);
        }
    }

    public static void encodeArray(ByteBuffer bb, short[] array) {
        bb.put((byte)10);
        int contentLength = 0;
        for (short i : array) {
            contentLength += EncodingRule.lengthOfShort(i);
        }
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, contentLength);
        for (short i : array) {
            EncodingRule.encodeShort(bb, i);
        }
    }

    public static void encodeArray(ByteBuffer bb, double[] array) {
        bb.put((byte)10);
        int contentLength = 0;
        for (double i : array) {
            contentLength += EncodingRule.lengthOfDouble(i);
        }
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, contentLength);
        for (double i : array) {
            EncodingRule.encodeDouble(bb, i);
        }
    }

    public static void encodeArray(ByteBuffer bb, float[] array) {
        bb.put((byte)10);
        int contentLength = 0;
        for (float i : array) {
            contentLength += EncodingRule.lengthOfFloat(i);
        }
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, contentLength);
        for (float i : array) {
            EncodingRule.encodeFloat(bb, i);
        }
    }

    public static void encodeArray(ByteBuffer bb, boolean[] array) {
        bb.put((byte)10);
        int contentLength = 0;
        for (boolean i : array) {
            contentLength += EncodingRule.lengthOfBoolean(i);
        }
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, contentLength);
        for (boolean i : array) {
            EncodingRule.encodeBoolean(bb, i);
        }
    }

    private static int preencodeArray(List<?> array, int depth, CustomCodec cc) {
        int length = 0;
        for (Object object : array) {
            if (object instanceof String) {
                length += EncodedStringCache.getEncodedString((String)object).length();
                continue;
            }
            if (object instanceof Map) {
                length += EncodingRule.preencodeMap((Map)object, depth + 1, cc);
                continue;
            }
            if (object instanceof List) {
                length += EncodingRule.preencodeArray((List)object, depth + 1, cc);
                continue;
            }
            if (object instanceof Object[]) {
                length += EncodingRule.preencodeArray((Object[])object, depth + 1, cc);
                continue;
            }
            length += EncodingRule.lengthOf(object, cc);
        }
        if (depth == 0) {
            return length;
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, length) + length;
    }

    public static void encodeArray(ByteBuffer bb, Object[] array) {
        EncodingRule.encodeArray(bb, array, null);
    }

    public static void encodeArray(ByteBuffer bb, Object[] array, CustomCodec cc) {
        EncodingRule.encodeArray(bb, Arrays.asList(array), cc);
    }

    private static int preencodeArray(Object[] array, int depth, CustomCodec cc) {
        return EncodingRule.preencodeArray(Arrays.asList(array), depth, cc);
    }

    public static Object[] decodeArray(ByteBuffer bb) {
        return EncodingRule.decodeArray(bb, null);
    }

    public static Object[] decodeArray(ByteBuffer bb, CustomCodec cc) {
        int after;
        int before;
        byte type = bb.get();
        if (type != 10) {
            throw new TypeMismatchException(10, type, bb.position() - 1);
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (int length = (int)EncodingRule.decodeRawNumber(bb); length > 0; length -= before - after) {
            before = bb.remaining();
            l.add(EncodingRule.decode(bb, cc));
            after = bb.remaining();
        }
        return l.toArray();
    }

    public static void encodeBlob(ByteBuffer bb, byte[] buffer) {
        bb.put((byte)11);
        EncodingRule.encodeRawNumber(bb, Integer.TYPE, buffer.length);
        bb.put(buffer);
    }

    public static byte[] decodeBlob(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 11) {
            throw new TypeMismatchException(11, type, bb.position() - 1);
        }
        int length = (int)EncodingRule.decodeRawNumber(bb);
        byte[] blob = new byte[length];
        bb.get(blob);
        return blob;
    }

    public static void encodeFloat(ByteBuffer bb, float value) {
        bb.put((byte)15);
        int v = Float.floatToIntBits(value);
        byte[] b = new byte[4];
        for (int i = 3; i >= 0; --i) {
            b[i] = (byte)(v & 0xFF);
            v >>= 8;
        }
        bb.put(b);
    }

    public static float decodeFloat(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 15) {
            throw new TypeMismatchException(15, type, bb.position() - 1);
        }
        byte[] b = new byte[4];
        bb.get(b);
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v <<= 8;
            v |= b[i] & 0xFF;
        }
        return Float.intBitsToFloat(v);
    }

    public static void encodeDouble(ByteBuffer bb, double value) {
        bb.put((byte)16);
        long v = Double.doubleToLongBits(value);
        byte[] b = new byte[8];
        for (int i = 7; i >= 0; --i) {
            b[i] = (byte)(v & 0xFFL);
            v >>= 8;
        }
        bb.put(b);
    }

    public static double decodeDouble(ByteBuffer bb) {
        byte type = bb.get();
        if (type != 16) {
            throw new TypeMismatchException(16, type, bb.position() - 1);
        }
        byte[] b = new byte[8];
        bb.get(b);
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(b[i] & 0xFF);
        }
        return Double.longBitsToDouble(v);
    }

    public static int lengthOfLong(long value) {
        long zvalue = value << 1 ^ value >> 63;
        return 1 + EncodingRule.lengthOfRawNumber(Long.TYPE, zvalue);
    }

    public static <T> int lengthOfRawNumber(Class<T> clazz, long value) {
        if (value < 0L) {
            if (Long.TYPE == clazz) {
                return 10;
            }
            if (Integer.TYPE == clazz) {
                return 5;
            }
            return 3;
        }
        if (value <= 127L) {
            return 1;
        }
        if (value <= 16383L) {
            return 2;
        }
        return (63 - Long.numberOfLeadingZeros(value)) / 7 + 1;
    }

    public static <T> int lengthOfNumber(Class<T> clazz, long value) {
        if (clazz.equals(Integer.TYPE)) {
            return EncodingRule.lengthOfInt((int)value);
        }
        if (clazz.equals(Long.TYPE)) {
            return EncodingRule.lengthOfLong(value);
        }
        if (clazz.equals(Short.TYPE)) {
            return EncodingRule.lengthOfShort((short)value);
        }
        throw new UnsupportedTypeException("invalid number type: " + clazz.getName());
    }

    public static int lengthOfInt(int value) {
        int zvalue = value << 1 ^ value >> 31;
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, zvalue);
    }

    public static int lengthOfNull() {
        return 1;
    }

    public static int lengthOfShort(short value) {
        short zvalue = (short)(value << 1 ^ value >> 15);
        return 1 + EncodingRule.lengthOfRawNumber(Short.TYPE, zvalue);
    }

    public static int lengthOfString(String value) {
        byte[] buffer = null;
        try {
            buffer = value.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, buffer.length) + buffer.length;
    }

    public static int lengthOfDate() {
        return 9;
    }

    public static int lengthOfBoolean(boolean value) {
        return 2;
    }

    public static int lengthOfIp4(Inet4Address value) {
        return 1 + value.getAddress().length;
    }

    public static int lengthOfIp6(Inet6Address value) {
        return 1 + value.getAddress().length;
    }

    public static int lengthOfMap(Map<String, Object> value) {
        return EncodingRule.lengthOfMap(value, null);
    }

    public static int lengthOfMap(Map<String, Object> value, CustomCodec cc) {
        int contentLength = 0;
        for (String key : value.keySet()) {
            contentLength += EncodingRule.lengthOfString(key);
            contentLength += EncodingRule.lengthOf(value.get(key), cc);
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, contentLength) + contentLength;
    }

    public static int lengthOfArray(List<?> value) {
        return EncodingRule.lengthOfArray(value, null);
    }

    public static int lengthOfArray(int[] value) {
        int contentLength = 0;
        for (int obj : value) {
            contentLength += EncodingRule.lengthOfInt(obj);
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, contentLength) + contentLength;
    }

    public static int lengthOfArray(long[] value) {
        int contentLength = 0;
        for (long obj : value) {
            contentLength += EncodingRule.lengthOfLong(obj);
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, contentLength) + contentLength;
    }

    public static int lengthOfArray(short[] value) {
        int contentLength = 0;
        for (short obj : value) {
            contentLength += EncodingRule.lengthOfShort(obj);
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, contentLength) + contentLength;
    }

    public static int lengthOfArray(boolean[] value) {
        int contentLength = 0;
        for (boolean obj : value) {
            contentLength += EncodingRule.lengthOfBoolean(obj);
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, contentLength) + contentLength;
    }

    public static int lengthOfArray(double[] value) {
        int contentLength = 0;
        for (double obj : value) {
            contentLength += EncodingRule.lengthOfDouble(obj);
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, contentLength) + contentLength;
    }

    public static int lengthOfArray(float[] value) {
        int contentLength = 0;
        for (float obj : value) {
            contentLength += EncodingRule.lengthOfFloat(obj);
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, contentLength) + contentLength;
    }

    public static int lengthOfArray(List<?> value, CustomCodec cc) {
        int contentLength = 0;
        for (Object obj : value) {
            contentLength += EncodingRule.lengthOf(obj, cc);
        }
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, contentLength) + contentLength;
    }

    public static int lengthOfArray(Object[] value) {
        return EncodingRule.lengthOfArray(value, null);
    }

    public static int lengthOfArray(Object[] value, CustomCodec cc) {
        return EncodingRule.lengthOfArray(Arrays.asList(value), cc);
    }

    public static int lengthOfBlob(byte[] value) {
        return 1 + EncodingRule.lengthOfRawNumber(Integer.TYPE, value.length) + value.length;
    }

    public static int lengthOfFloat(float value) {
        return 5;
    }

    public static int lengthOfDouble(double value) {
        return 9;
    }
}

