/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

public class Version
implements Comparable<Version> {
    private String str;
    private int major;
    private int minor;
    private String rev;

    public Version(String str) {
        this.str = str;
        String[] tokens = str.split("[\\.-]");
        this.major = Integer.parseInt(tokens[0]);
        this.minor = Integer.parseInt(tokens[1]);
        this.rev = "";
        for (int i = 2; i < tokens.length; ++i) {
            if (i != 2) {
                this.rev = this.rev + ".";
            }
            this.rev = this.rev + tokens[i];
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return this.str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version other = (Version)o;
        return !(this.str == null ? other.str != null : !this.str.equals(other.str));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
        return result;
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.major != o.major) {
            return this.major - o.major;
        }
        if (this.minor != o.minor) {
            return this.minor - o.minor;
        }
        try {
            int lhs = Integer.parseInt(this.rev);
            int rhs = Integer.parseInt(o.rev);
            return lhs - rhs;
        }
        catch (NumberFormatException e) {
            if (this.rev == null && o.rev == null) {
                return 0;
            }
            if (this.rev == null) {
                return -1;
            }
            if (o.rev == null) {
                return 1;
            }
            return this.rev.compareTo(o.rev);
        }
    }
}

