/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.araqne.api.CollectionTypeHint;
import org.araqne.api.FieldOption;
import org.araqne.api.MapTypeHint;
import org.araqne.api.PrimitiveParseCallback;
import org.araqne.api.PrimitiveSerializeCallback;
import org.araqne.api.ReferenceKey;

public class PrimitiveConverter {
    private static Set<Class<?>> nonSerializeClasses = new HashSet<Class>(Arrays.asList(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, String.class, Date.class));

    public static Object serialize(Object obj) {
        return PrimitiveConverter.serialize(obj, obj, null, null, new SerializeOption[0]);
    }

    public static Object serialize(Object obj, PrimitiveSerializeCallback callback) {
        return PrimitiveConverter.serialize(obj, obj, callback, null, new SerializeOption[0]);
    }

    public static Object serialize(Object obj, SerializeOption ... options) {
        return PrimitiveConverter.serialize(obj, obj, null, null, options);
    }

    public static Object serialize(Object obj, PrimitiveSerializeCallback callback, SerializeOption ... options) {
        return PrimitiveConverter.serialize(obj, obj, callback, null, options);
    }

    private static Object serialize(Object root, Object obj, PrimitiveSerializeCallback callback, List<String> refkey, SerializeOption ... options) {
        if (obj == null) {
            return null;
        }
        List<SerializeOption> optionList = Arrays.asList(options);
        Class<?> cls = obj.getClass();
        if (nonSerializeClasses.contains(cls)) {
            return obj;
        }
        if (cls.isArray()) {
            if (cls.getComponentType().isPrimitive()) {
                return obj;
            }
            Object[] ary = new Object[Array.getLength(obj)];
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = PrimitiveConverter.serialize(root, Array.get(obj, i), callback, refkey, options);
            }
            return ary;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            ArrayList<Object> col = new ArrayList<Object>();
            for (Object o : (Collection)obj) {
                col.add(PrimitiveConverter.serialize(root, o, callback, refkey, options));
            }
            return col;
        }
        if (Map.class.isAssignableFrom(cls)) {
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            Map o = (Map)obj;
            for (Object key : o.keySet()) {
                Object k = PrimitiveConverter.serialize(root, key, callback, refkey, options);
                Object value = o.get(key);
                Object v = PrimitiveConverter.serialize(root, value, callback, refkey, options);
                m.put(k, v);
            }
            return m;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (Field f : cls.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            try {
                FieldOption option = f.getAnnotation(FieldOption.class);
                if (option != null && option.skip() && !optionList.contains((Object)SerializeOption.INCLUDE_SKIP_FIELD) || refkey != null && !refkey.contains(f.getName())) continue;
                String fieldName = PrimitiveConverter.toUnderscoreName(f.getName());
                if (option != null && !option.name().isEmpty()) {
                    fieldName = option.name();
                }
                f.setAccessible(true);
                Object value = f.get(obj);
                if (option != null && !option.nullable() && value == null) {
                    throw new IllegalArgumentException(String.format("Can not set %s field %s.%s to null value", f.getType().getSimpleName(), cls.getName(), f.getName()));
                }
                if (value instanceof Enum) {
                    m.put(fieldName, value.toString());
                    continue;
                }
                if (value instanceof String) {
                    if (option != null && option.length() > 0 && ((String)value).length() > option.length()) {
                        String s = (String)value;
                        throw new IllegalArgumentException(String.format("Too long String value for %s.%s (limit: %d, input: [%s])", cls.getName(), f.getName(), option.length(), s));
                    }
                    m.put(fieldName, value);
                    continue;
                }
                if (value == null) {
                    m.put(fieldName, null);
                    continue;
                }
                List<String> referenceKey = null;
                if (f.getAnnotation(ReferenceKey.class) != null && callback != null) {
                    referenceKey = Arrays.asList(f.getAnnotation(ReferenceKey.class).value());
                }
                Object serialized = PrimitiveConverter.serialize(root, value, callback, referenceKey, options);
                m.put(fieldName, serialized);
            }
            catch (Exception e) {
                throw new RuntimeException("araqne api: serialize failed", e);
            }
        }
        if (!(callback == null || refkey == null || refkey.containsAll(m.keySet()) && m.keySet().containsAll(refkey))) {
            callback.onSerialize(root, cls, obj, m);
        }
        return m;
    }

    public static <T> T parse(Class<T> cls, Object obj) {
        return PrimitiveConverter.parse(cls, obj, null);
    }

    public static <T> T parse(Class<T> cls, Object obj, PrimitiveParseCallback callback) {
        if (obj == null || !(obj instanceof Map) || cls.equals(Object.class)) {
            return (T)obj;
        }
        try {
            Map m = (Map)obj;
            T n = null;
            try {
                n = cls.newInstance();
            }
            catch (IllegalAccessException e) {
                Constructor<T> c = cls.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                n = c.newInstance(new Object[0]);
            }
            for (Field f : cls.getDeclaredFields()) {
                Annotation hint;
                FieldOption option = f.getAnnotation(FieldOption.class);
                if (option != null && option.skip()) continue;
                String fieldName = PrimitiveConverter.toUnderscoreName(f.getName());
                if (option != null && !option.name().isEmpty()) {
                    fieldName = option.name();
                }
                if (!m.containsKey(fieldName)) continue;
                Object value = m.get(fieldName);
                f.setAccessible(true);
                if (value == null) {
                    f.set(n, null);
                    continue;
                }
                Class<?> fieldType = f.getType();
                ReferenceKey refkey = f.getAnnotation(ReferenceKey.class);
                if (refkey != null) {
                    if (value instanceof Map) {
                        Map keys = (Map)value;
                        if (callback != null) {
                            f.set(n, callback.onParse(fieldType, PrimitiveConverter.getRefKeys(keys, refkey.value())));
                            continue;
                        }
                        if (option == null || option.nullable()) continue;
                        throw new IllegalArgumentException(fieldName + " requires parse callback");
                    }
                    if (!(value instanceof Object[])) continue;
                    ArrayList coll = new ArrayList();
                    for (Object object : (Object[])value) {
                        Map keys = (Map)object;
                        if (callback != null) {
                            Object o = callback.onParse(f.getAnnotation(CollectionTypeHint.class).value(), PrimitiveConverter.getRefKeys(keys, refkey.value()));
                            if (o == null) continue;
                            coll.add(o);
                            continue;
                        }
                        if (option == null || option.nullable()) continue;
                        throw new IllegalArgumentException(fieldName + " requires parse callback");
                    }
                    if (List.class.isAssignableFrom(fieldType)) {
                        f.set(n, coll);
                        continue;
                    }
                    if (Set.class.isAssignableFrom(fieldType)) {
                        f.set(n, new HashSet(coll));
                        continue;
                    }
                    if (!fieldType.isArray()) continue;
                    f.set(n, coll.toArray());
                    continue;
                }
                if (fieldType.isEnum()) {
                    Object found = null;
                    for (Object obj2 : fieldType.getEnumConstants()) {
                        if (!obj2.toString().equals(value)) continue;
                        found = obj2;
                    }
                    f.set(n, found);
                    continue;
                }
                if (fieldType.isArray()) {
                    if (fieldType.getComponentType().isPrimitive()) {
                        f.set(n, value);
                        continue;
                    }
                    Object[] o = (Object[])value;
                    Object object = Array.newInstance(fieldType.getComponentType(), o.length);
                    for (int i = 0; i < o.length; ++i) {
                        Array.set(object, i, o[i]);
                    }
                    f.set(n, object);
                    continue;
                }
                if (Collection.class.isAssignableFrom(fieldType)) {
                    if (value instanceof Object[]) {
                        value = Arrays.asList((Object[])value);
                    }
                    hint = f.getAnnotation(CollectionTypeHint.class);
                    if (!(value instanceof List)) continue;
                    if (hint != null) {
                        f.set(n, PrimitiveConverter.parseCollection(hint.value(), (List)value));
                        continue;
                    }
                    f.set(n, value);
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    hint = f.getAnnotation(MapTypeHint.class);
                    if (hint == null) {
                        f.set(n, value);
                        continue;
                    }
                    Map map = (Map)value;
                    HashMap fmap = new HashMap();
                    for (Object k : map.keySet()) {
                        fmap.put(PrimitiveConverter.parse(hint.value()[0], k, callback), PrimitiveConverter.parse(hint.value()[1], map.get(k), callback));
                    }
                    f.set(n, fmap);
                    continue;
                }
                f.set(n, PrimitiveConverter.parse(fieldType, value, callback));
            }
            return n;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Primitive parse failed. Please check if nullary constructor is accessible", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Primitive parse failed", e);
        }
    }

    private static Map<String, Object> getRefKeys(Map<String, Object> src, String[] refkeys) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (String key : refkeys) {
            key = PrimitiveConverter.toUnderscoreName(key);
            m.put(key, src.get(key));
        }
        return m;
    }

    public static <T> Collection<T> parseCollection(Class<T> cls, Collection<Object> coll) {
        return PrimitiveConverter.parseCollection(cls, coll, null);
    }

    public static <T> Collection<T> parseCollection(Class<T> cls, Collection<Object> coll, PrimitiveParseCallback callback) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object obj : coll) {
            if (Map.class.isAssignableFrom(obj.getClass())) {
                result.add(PrimitiveConverter.parse(cls, obj, callback));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public static Object overwrite(Object obj, Map<String, Object> m) {
        return PrimitiveConverter.overwrite(obj, m, (PrimitiveParseCallback)null);
    }

    public static Object overwrite(Object obj, Map<String, Object> m, PrimitiveParseCallback callback) {
        Object newObj = PrimitiveConverter.parse(obj.getClass(), m, callback);
        return PrimitiveConverter.overwrite(obj, newObj, m);
    }

    private static Object overwrite(Object before, Object after, Map<String, Object> m) {
        if (before == null || after == null) {
            return after;
        }
        try {
            for (Field f : before.getClass().getDeclaredFields()) {
                String fieldName = PrimitiveConverter.toUnderscoreName(f.getName());
                if (!m.containsKey(fieldName)) continue;
                f.setAccessible(true);
                Class<?> cls = f.getType();
                Object newValue = m.get(fieldName);
                if (newValue != null && Map.class.isAssignableFrom(newValue.getClass()) && !Map.class.isAssignableFrom(cls)) {
                    f.set(before, PrimitiveConverter.overwrite(f.get(before), f.get(after), (Map)newValue));
                    continue;
                }
                f.set(before, f.get(after));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Primitive overwrite failed", e);
        }
        return before;
    }

    public static String toUnderscoreName(String s) {
        int tolower = 32;
        StringBuilder sb = new StringBuilder(s.length() * 2);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (i != 0) {
                    sb.append("_");
                }
                sb.append((char)(c + 32));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static enum SerializeOption {
        INCLUDE_SKIP_FIELD;

    }
}

