/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.araqne.api.AlreadyInstalledPackageException;
import org.araqne.api.BundleDescriptor;
import org.araqne.api.MavenResolveException;
import org.araqne.api.PackageDescriptor;
import org.araqne.api.PackageIndex;
import org.araqne.api.PackageNotFoundException;
import org.araqne.api.PackageRepository;
import org.araqne.api.PackageUpdatePlan;
import org.araqne.api.PackageVersionHistory;
import org.araqne.api.ProgressMonitor;
import org.araqne.api.Version;

public interface PackageManager {
    public List<PackageRepository> getRepositories();

    public PackageRepository getRepository(String var1);

    @Deprecated
    public void addRepository(String var1, URL var2);

    @Deprecated
    public void addSecureRepository(String var1, URL var2, String var3, String var4);

    public void createRepository(PackageRepository var1);

    public void updateRepository(PackageRepository var1);

    public void removeRepository(String var1);

    public List<PackageDescriptor> getInstalledPackages();

    public void installPackage(String var1, String var2, ProgressMonitor var3) throws AlreadyInstalledPackageException, PackageNotFoundException, MavenResolveException, KeyStoreException, UnrecoverableKeyException, KeyManagementException;

    public void updatePackage(String var1, Version var2, ProgressMonitor var3) throws PackageNotFoundException, MavenResolveException, KeyStoreException, UnrecoverableKeyException, KeyManagementException;

    public void uninstallPackage(String var1, ProgressMonitor var2) throws PackageNotFoundException;

    public Set<BundleDescriptor> findRelatedBundles(PackageDescriptor var1);

    public Map<String, List<PackageDescriptor>> checkUninstallDependency(String var1) throws PackageNotFoundException;

    public PackageUpdatePlan getUpdatePlan(String var1, Version var2) throws PackageNotFoundException, KeyStoreException, UnrecoverableKeyException, KeyManagementException;

    public PackageVersionHistory checkUpdate(String var1) throws PackageNotFoundException, KeyStoreException, UnrecoverableKeyException, KeyManagementException;

    public PackageVersionHistory getLatestVersion(String var1) throws PackageNotFoundException, KeyStoreException, UnrecoverableKeyException, KeyManagementException;

    public PackageDescriptor findInstalledPackage(String var1);

    public List<PackageIndex> getPackageIndexes();

    public PackageIndex getPackageIndex(PackageRepository var1);
}

